/* ScummVM - Graphic Adventure Engine
 *
 * ScummVM is the legal property of its developers, whose names
 * are too numerous to list here. Please refer to the COPYRIGHT
 * file distributed with this source distribution.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef NANCY9DATA_H
#define NANCY9DATA_H

#include "types.h"

const GameConstants _nancy9Constants ={
	45,												// numItems
	672,											// numEventFlags
	{	0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10,			// genericEventFlags
		11, 12, 13, 14, 15, 16, 17, 18, 19, 20,
		21, 22, 23, 24, 25, 26, 27, 28, 29, 30 },
	20,												// numCursorTypes
	4000,											// logoEndAfter
	32												// wonGameFlagID
};

const Common::Array<Common::Array<ConditionalDialogue>> _nancy9ConditionalDialogue = {
{	// Andy Jason, 16 responses
	{	0, 1350, "NAC50",
		{ { kEv, 40, false } } },
	{	0, 1351, "NAC51",
		{ { kEv, 409, false }, { kEv, 47, false } } },
	{	0, 1352, "NAC52",
		{ { kEv, 221, false }, { kEv, 50, false } } },
	{	0, 1353, "NAC53",
		{ { kEv, 50, true }, { kEv, 40, true }, { kEv, 221, false }, { kEv, 52, false } } },
	{	0, 1354, "NAC54",
		{ { kEv, 508, true }, { kEv, 46, false }, { kIn, 11, false } } },
	{	0, 1355, "NAC55",
		{ { kEv, 293, true }, { kEv, 49, false }, { kIn, 19, false } } },
	{	0, 1356, "NAC56",
		{ { kEv, 400, true }, { kEv, 483, true }, { kEv, 41, false } } },
	{	0, 1357, "NAC57",
		{ { kEv, 179, true }, { kEv, 43, false } } },
	{	0, 1360, "NAC60",
		{ { kEv, 309, true }, { kEv, 187, false }, { kEv, 36, false } } },
	{	0, 1362, "NAC62",
		{ { kEv, 41, true }, { kEv, 43, true }, { kEv, 396, false } } },
	{	0, 1367, "NAC67",
		{ { kEv, 158, true }, { kEv, 409, false }, { kEv, 220, false }, { kEv, 37, false }, { kEv, 242, false } } },
	{	0, 1368, "NAC68",
		{ { kEv, 223, true }, { kEv, 48, false } } },
	{	0, 1369, "NAC69",
		{ { kEv, 424, true }, { kEv, 51, false } } },
	{	0, 1363, "NAC63",
		{ { kEv, 221, true }, { kEv, 187, false }, { kEv, 38, false } } },
	{	0, 1365, "NAC65",
		{ { kEv, 418, true }, { kEv, 345, true }, { kEv, 419, false }, { kEv, 45, false } } },
	{	0, 1366, "NAC66",
		{ { kEv, 307, true }, { kEv, 187, true }, { kEv, 53, false } } },
},
{	// Holt Scotto, 11 responses
	{	0, 1250, "NHK50",
		{ { kEv, 409, false }, { kEv, 183, false } } },
	{	0, 1251, "NHK51",
		{ { kEv, 256, true }, { kEv, 189, false } } },
	{	0, 1252, "NHK52",
		{ { kEv, 224, true }, { kEv, 179, false }, { kEv, 185, false } } },
	{	0, 1253, "NHK53",
		{ { kEv, 120, true }, { kEv, 191, false }, { kEv, 286, false } } },
	{	0, 1254, "NHK54",
		{ { kEv, 175, true }, { kEv, 190, false }, { kEv, 116, false } } },
	{	0, 1255, "NHK55",
		{ { kEv, 249, true }, { kEv, 45, true }, { kEv, 186, false }, { kEv, 192, false } } },
	{	0, 1256, "NHK56",
		{ { kEv, 318, true }, { kEv, 326, true }, { kEv, 327, false }, { kEv, 184, false } } },
	{	0, 1257, "NHK57",
		{ { kEv, 508, true }, { kEv, 188, false }, { kIn, 11, false } } },
	{	0, 1259, "NHK59",
		{ { kEv, 409, true }, { kEv, 179, true }, { kEv, 182, false } } },
	{	0, 1260, "NHK60",
		{ { kEv, 307, true }, { kEv, 187, false } } },
	{	0, 1261, "NHK61",
		{ { kEv, 401, true }, { kEv, 339, false } } },
},
{	// Jenna Deblin, 15 responses
	{	0, 1150, "NJK50",
        { { kEv, 240, true }, { kEv, 219, false } } },
	{	0, 1166, "NJK04a",
        { { kEv, 283, false }, { kEv, 225, false } } },
	{	0, 1151, "NJK51",
        { { kEv, 275, true }, { kEv, 217, false } } },
	{	0, 1153, "NJK53",
        { { kEv, 158, true }, { kEv, 409, false }, { kEv, 37, false }, { kEv, 220, false } } },
	{	0, 1154, "NJK54",
        { { kEv, 508, true }, { kEv, 228, false }, { kIn, 11, false } } },
	{	0, 1164, "NJK64",
        { { kEv, 37, true }, { kEv, 409, true }, { kEv, 224, false } } },
	{	0, 1155, "NJK55",
        { { kEv, 409, true }, { kEv, 179, true }, { kEv, 223, false } } },
	{	0, 1157, "NJK57",
        { { kEv, 434, true }, { kEv, 235, false }, { kIn, 11, true } } },
	{	0, 1158, "NJK58",
        { { kEv, 434, true }, { kEv, 283, true }, { kEv, 235, true }, { kEv, 236, false }, { kIn, 11, true } } },
	{	0, 1159, "NJK59",
        { { kEv, 402, true }, { kEv, 341, false }, { kEv, 234, false } } },
	{	0, 1160, "NJK60",
        { { kEv, 229, true }, { kEv, 419, true }, { kEv, 415, false }, { kEv, 233, false } } },
	{	0, 1162, "NJK62",
        { { kEv, 231, true }, { kEv, 222, false } } },
	{	0, 1163, "NJK63",
        { { kEv, 222, true }, { kEv, 230, false } } },
	{	0, 1152, "NJK52",
        { { kEv, 231, true }, { kEv, 222, false }, { kEv, 226, false }, { kEv, 230, false } } },
	{	0, 1165, "NJK65",
        { { kEv, 226, true }, { kEv, 230, false } } },
},
{
	// Katie Firestone, 12 responses
	{	0, 1051, "NKB51",
        { { kEv, 310, true }, { kEv, 268, false }, { kEv, 240, false } } },
	{	0, 1052, "NKB52",
        { { kEv, 252, false }, { kEv, 280, false } } },
	{	0, 1060, "NKB60",
        { { kEv, 333, true }, { kEv, 256, false } } },
	{	0, 1055, "NKB55",
        { { kEv, 275, true }, { kEv, 221, false }, { kEv, 248, false } } },
	{	0, 1058, "NKB58",
        { { kEv, 277, true }, { kEv, 221, false }, { kEv, 255, false } } },
	{	0, 1059, "NKB59",
        { { kEv, 243, false }, { kIn, 8, true } } },
	{	0, 1063, "NKB63",
        { { kEv, 470, true }, { kEv, 418, false }, { kEv, 251, false } } },
	{	0, 1065, "NKB65",
        { { kEv, 232, true }, { kEv, 356, true }, { kEv, 244, true }, { kEv, 239, false } } },
	{	0, 1066, "NKB66",
        { { kEv, 239, true }, { kEv, 327, true }, { kEv, 253, false }, { kIn, 11, true } } },
	{	0, 1068, "NKB68",
        { { kEv, 36, true }, { kEv, 415, false }, { kEv, 246, false } } },
	{	0, 1088, "NKB88",
        { { kEv, 283, true }, { kEv, 508, true }, { kEv, 250, false } } },
	{	0, 1069, "NKB69",
        { { kEv, 250, true }, { kEv, 429, true }, { kEv, 428, true }, { kEv, 247, false }, { kEv, 303, false } } },
},
{	// Bess & George, 35 responses
	{	0, 1650, "NBG50",
        { { kEv, 99, false }, { kEv, 409, false } } },
	{	0, 1651, "NBG51",
        { { kEv, 346, true }, { kEv, 275, true }, { kEv, 186, false }, { kEv, 88, false } } },
	{	0, 1653, "NBG53",
        { { kEv, 277, true }, { kEv, 221, false }, { kEv, 83, false } } },
	{	0, 1654, "NBG54",
        { { kEv, 222, true }, { kEv, 226, true }, { kEv, 225, true }, { kEv, 283, false }, { kEv, 82, false } } },
	{	0, 1655, "NBG55",
        { { kEv, 186, true }, { kEv, 84, false } } },
	{	0, 1656, "NBG56",
        { { kEv, 268, true }, { kEv, 388, false }, { kEv, 64, false } } },
	{	0, 1657, "NBG57",
        { { kEv, 331, false }, { kEv, 409, false }, { kEv, 68, false }, { kIn, 14, true }, { kIn, 15, true }, { kIn, 16, true }, { kIn, 17, true } } },
	{	0, 1659, "NBG59",
        { { kEv, 338, true }, { kEv, 42, true }, { kEv, 224, true }, { kEv, 420, false }, { kEv, 79, false }, { kIn, 23, true } } },
	{	0, 1660, "NBG60",
        { { kEv, 99, true }, { kEv, 177, true }, { kEv, 412, false }, { kEv, 80, false } } },
	{	0, 1661, "NBG61",
        { { kEv, 223, true }, { kEv, 402, false }, { kEv, 74, false } } },
	{	0, 1662, "NBG62",
        { { kEv, 82, true }, { kEv, 221, true }, { kEv, 412, false }, { kEv, 70, false } } },
	{	0, 1663, "NBG63",
        { { kEv, 109, true }, { kEv, 75, false }, { kEv, 97, false } } },
	{	0, 1664, "NBG64",
        { { kEv, 254, true }, { kEv, 75, false }, { kEv, 66, false } } },
	{	0, 1699, "NBG99",
        { { kEv, 81, false }, { kEv, 75, false }, { kEv, 71, false } } },
	{	0, 1658, "NBG58",
        { { kEv, 81, true }, { kEv, 120, false }, { kEv, 426, false }, { kEv, 95, false }, { kIn, 20, true } } },
	{	0, 1481, "NBB81",
        { { kEv, 81, true }, { kEv, 518, true }, { kEv, 398, false }, { kEv, 67, false } } },
	{	0, 1673, "NBG73",
        { { kEv, 81, true }, { kEv, 410, false }, { kEv, 78, false }, { kIn, 14, true }, { kIn, 15, true }, { kIn, 16, true }, { kIn, 17, true } } },
	{	0, 1674, "NBG74",
        { { kEv, 81, true }, { kEv, 465, true }, { kEv, 409, false }, { kEv, 328, false }, { kEv, 93, false } } },
	{	0, 1675, "NBG75",
        { { kEv, 81, true }, { kEv, 465, true }, { kEv, 409, false }, { kEv, 328, true }, { kEv, 77, false } } },
	{	0, 1676, "NBG76",
        { { kEv, 81, true }, { kEv, 467, true }, { kEv, 179, false }, { kEv, 98, false } } },
	{	0, 1677, "NBG77",
        { { kEv, 81, true }, { kEv, 316, false }, { kEv, 119, false }, { kEv, 72, false }, { kIn, 6, true } } },
	{	0, 1678, "NBG78",
        { { kEv, 81, true }, { kEv, 460, true }, { kEv, 316, true }, { kEv, 119, false }, { kEv, 73, false } } },
	{	0, 1679, "NBG79",
        { { kEv, 81, true }, { kEv, 339, true }, { kEv, 341, true }, { kEv, 416, false }, { kEv, 103, false }, { kIn, 12, true } } },
	{	0, 1680, "NBG80",
        { { kEv, 81, true }, { kEv, 470, true }, { kEv, 418, false }, { kEv, 85, false } } },
	{	0, 1681, "NBG81",
        { { kEv, 81, true }, { kEv, 472, true }, { kEv, 421, false }, { kEv, 91, false } } },
	{	0, 1682, "NBG82",
        { { kEv, 81, true }, { kEv, 473, true }, { kEv, 422, false }, { kEv, 69, false } } },
	{	0, 1683, "NBG83",
        { { kEv, 81, true }, { kEv, 112, true }, { kEv, 352, false }, { kEv, 397, false }, { kEv, 65, false } } },
	{	0, 1684, "NBG84",
        { { kEv, 81, true }, { kEv, 221, true }, { kEv, 329, true }, { kEv, 182, true }, { kEv, 474, true }, { kEv, 405, false }, { kEv, 406, false }, { kEv, 407, false }, { kEv, 408, false }, { kEv, 92, false } } },
	{	0, 1685, "NBG85",
        { { kEv, 81, true }, { kEv, 404, true }, { kEv, 358, false }, { kEv, 100, false } } },
	{	0, 1686, "NBG86",
        { { kEv, 81, true }, { kEv, 320, true }, { kEv, 411, false }, { kEv, 90, false } } },
	{	0, 1687, "NBG87",
        { { kEv, 81, true }, { kEv, 478, true }, { kEv, 469, false }, { kEv, 96, false } } },
	{	0, 1688, "NBG88",
        { { kEv, 81, true }, { kEv, 469, true }, { kEv, 478, false }, { kEv, 96, false } } },
	{	0, 1689, "NBG89",
        { { kEv, 81, true }, { kEv, 469, true }, { kEv, 478, true }, { kEv, 419, false }, { kEv, 96, false } } },
	{	0, 1482, "NBB82",
        { { kEv, 81, true }, { kEv, 180, true }, { kEv, 432, false }, { kEv, 94, false } } },
	{	0, 1698, "NBG98",
        { { kEv, 81, true }, { kEv, 336, true }, { kEv, 415, false }, { kEv, 86, false }, { kIn, 29, true } } },
},
{	// Frank & Joe, 31 responses
	{	0, 1750, "NFJ50",
		{ { kEv, 275, false }, { kEv, 277, false }, { kEv, 268, false }, { kEv, 154, false } } },
	{	0, 1751, "NFJ51",
		{ { kEv, 275, true }, { kEv, 277, true }, { kEv, 268, true }, { kEv, 409, false }, { kEv, 144, false } } },
	{	0, 1752, "NFJ52",
		{ { kEv, 140, true }, { kEv, 139, true }, { kEv, 268, true }, { kEv, 409, false }, { kEv, 124, false } } },
	{	0, 1753, "NFJ53",
		{ { kEv, 36, true }, { kEv, 246, true }, { kEv, 75, false }, { kEv, 138, false } } },
	{	0, 1754, "NFJ54",
		{ { kEv, 271, true }, { kEv, 276, true }, { kEv, 107, false }, { kEv, 388, false }, { kEv, 133, false }, { kEv, 441, true } } },
	{	0, 1755, "NFJ55",
		{ { kEv, 273, true }, { kEv, 75, false }, { kEv, 135, false } } },
	{	0, 1756, "NFJ56",
		{ { kEv, 138, true }, { kEv, 229, true }, { kEv, 419, false }, { kEv, 75, false }, { kEv, 156, false } } },
	{	0, 1757, "NFJ57",
		{ { kEv, 351, true }, { kEv, 192, true }, { kEv, 249, true }, { kEv, 45, true }, { kEv, 186, true }, { kEv, 418, false }, { kEv, 141, false } } },
	{	0, 1758, "NFJ58",
		{ { kEv, 419, true }, { kEv, 313, true }, { kEv, 415, false }, { kEv, 137, false } } },
	{	0, 1759, "NFJ59",
		{ { kEv, 347, true }, { kEv, 275, true }, { kEv, 135, true }, { kEv, 388, false }, { kEv, 129, false } } },
	{	0, 1770, "NFJ70",
		{ { kEv, 150, false }, { kEv, 426, false }, { kEv, 120, false }, { kIn, 20, true } } },
	{	0, 1771, "NFJ71",
		{ { kEv, 518, true }, { kEv, 398, false }, { kEv, 459, false }, { kEv, 126, false } } },
	{	0, 1772, "NFJ72",
		{ { kEv, 410, false }, { kEv, 136, false }, { kIn, 14, true }, { kIn, 15, true }, { kIn, 16, true }, { kIn, 17, true } } },
	{	0, 1773, "NFJ73",
		{ { kEv, 465, true }, { kEv, 409, false }, { kEv, 328, false }, { kEv, 148, false } } },
	{	0, 1774, "NFJ74",
		{ { kEv, 465, true }, { kEv, 328, true }, { kEv, 409, false }, { kEv, 134, false } } },
	{	0, 1775, "NFJ75",
		{ { kEv, 467, true }, { kEv, 179, false }, { kEv, 153, false } } },
	{	0, 1776, "NFJ76",
		{ { kEv, 316, false }, { kEv, 119, false }, { kEv, 130, false }, { kIn, 6, true } } },
	{	0, 1777, "NFJ77",
		{ { kEv, 460, true }, { kEv, 316, true }, { kEv, 119, false }, { kEv, 131, false } } },
	{	0, 1778, "NFJ78",
		{ { kEv, 339, true }, { kEv, 341, true }, { kEv, 416, false }, { kEv, 157, false }, { kIn, 12, true } } },
	{	0, 1779, "NFJ79",
		{ { kEv, 470, true }, { kEv, 418, false }, { kEv, 142, false } } },
	{	0, 1780, "NFJ80",
		{ { kEv, 472, true }, { kEv, 421, false }, { kEv, 146, false } } },
	{	0, 1781, "NFJ81",
		{ { kEv, 422, false }, { kEv, 473, true }, { kEv, 127, false } } },
	{	0, 1782, "NFJ82",
		{ { kEv, 112, true }, { kEv, 352, false }, { kEv, 397, false }, { kEv, 125, false } } },
	{	0, 1783, "NFJ83",
		{ { kEv, 221, true }, { kEv, 329, true }, { kEv, 182, true }, { kEv, 474, true }, { kEv, 405, false }, { kEv, 406, false }, { kEv, 407, false }, { kEv, 408, false }, { kEv, 92, false } } },
	{	0, 1784, "NFJ84",
		{ { kEv, 404, true }, { kEv, 358, false }, { kEv, 155, false } } },
	{	0, 1785, "NFJ85",
		{ { kEv, 320, true }, { kEv, 411, false }, { kEv, 145, false } } },
	{	0, 1786, "NFJ86",
		{ { kEv, 478, true }, { kEv, 469, false }, { kEv, 151, false } } },
	{	0, 1787, "NFJ87",
		{ { kEv, 469, true }, { kEv, 478, false }, { kEv, 151, false } } },
	{	0, 1788, "NFJ88",
		{ { kEv, 469, true }, { kEv, 478, true }, { kEv, 419, false }, { kEv, 151, false } } },
	{	0, 1794, "NFJ94",
		{ { kEv, 180, true }, { kEv, 432, false }, { kEv, 149, false } } },
	{	0, 1789, "NFJ89",
		{ { kEv, 336, true }, { kEv, 415, false }, { kEv, 143, false }, { kIn, 29, true } } },
}
};

const Common::Array<Goodbye> _nancy9Goodbyes = {
	{ "NAC90", { { { 1390, 1391, 1392, 1393 }, {}, NOFLAG } } },	// Andy Jason
	{ "NHK90", { { { 1290, 1291, 1292, 1293 }, {}, NOFLAG } } },	// Holt Scotto
	{ "NJK90", { { { 1190, 1191, 1192, 1193 }, {}, NOFLAG } } },	// Jenna Deblin
	{ "NKB90", { { { 1090, 1091, 1092, 1093 }, {}, NOFLAG } } },	// Katie Firestone
	{ "NBG90", { { { 1690, 1691, 1692, 1693 }, {}, NOFLAG } } },	// Bess & George
	{ "NFJ90", { { { 1790, 1791, 1792, 1793 }, {}, NOFLAG } } },	// Frank & Joe
};

const Common::Array<const char *> _nancy9EventFlagNames = {
	"EV_Generic0",
	"EV_Generic1",
	"EV_Generic2",
	"EV_Generic3",
	"EV_Generic4",
	"EV_Generic5",
	"EV_Generic6",
	"EV_Generic7",
	"EV_Generic8",
	"EV_Generic9",
	"EV_Generic10",
	"EV_Generic11",
	"EV_Generic12",
	"EV_Generic13",
	"EV_Generic14",
	"EV_Generic15",
	"EV_Generic16",
	"EV_Generic17",
	"EV_Generic18",
	"EV_Generic19",
	"EV_Generic20",
	"EV_Generic21",
	"EV_Generic22",
	"EV_Generic23",
	"EV_Generic24",
	"EV_Generic25",
	"EV_Generic26",
	"EV_Generic27",
	"EV_Generic28",
	"EV_Generic29",
	"EV_Generic30",
	"EV_TimeForEndgame",
	"EV_PlayerWonGame",
	"EV_StopPlayerScrolling",
	"EV_Easter_Eggs",
	"EV_AJ_Available",
	"EV_AJ_Said_Bottle_Boat",
	"EV_AJ_Said_Bottle_Note",
	"EV_AJ_Said_Burglary",
	"EV_AJ_Said_Careful",
	"EV_AJ_Said_Competition",
	"EV_AJ_Said_Free_Tour",
	"EV_AJ_Said_Hilda",
	"EV_AJ_Said_Hilda_Gift",
	"EV_AJ_Said_JD_Seething",
	"EV_AJ_Said_Lighthouse",
	"EV_AJ_Said_No_Light",
	"EV_AJ_Said_Nothing",
	"EV_AJ_Said_Permit_Task",
	"EV_AJ_Said_Punchcard",
	"EV_AJ_Said_Ransack",
	"EV_AJ_Said_Take_Permit",
	"EV_AJ_Said_Too_Bad",
	"EV_AJ_Said_Yes",
	"EV_Answered_SQ_Q01",
	"EV_Answered_SQ_Q02",
	"EV_Answered_SQ_Q03",
	"EV_Answered_SQ_Q04",
	"EV_Answered_SQ_Q05",
	"EV_Answered_SQ_Q06",
	"EV_Answered_SQ_Q08",
	"EV_Answered_SQ_Q09",
	"EV_Answered_SQ_Q10",
	"EV_Bad_Quiz",
	"EV_BG_Said_AJ_Suspect",
	"EV_BG_Said_Book",
	"EV_BG_Said_Boot",
	"EV_BG_Said_Bottle_Dislodge",
	"EV_BG_Said_Bottles",
	"EV_BG_Said_Bulbs",
	"EV_BG_Said_Burglary",
	"EV_BG_Said_Call_Hardys",
	"EV_BG_Said_Chess_Book",
	"EV_BG_Said_Chess_Stumped",
	"EV_BG_Said_Clams",
	"EV_BG_Said_Figured_Out",
	"EV_BG_Said_Follow_Her",
	"EV_BG_Said_Geocache",
	"EV_BG_Said_GPS_Beach",
	"EV_BG_Said_Hilda",
	"EV_BG_Said_Hilda_Mean",
	"EV_BG_Said_Hints",
	"EV_BG_Said_JD_Cook",
	"EV_BG_Said_JD_Suspect",
	"EV_BG_Said_Lighthouse",
	"EV_BG_Said_Lighthouse_Lock",
	"EV_BG_Said_Lock",
	"EV_BG_Said_Machine",
	"EV_BG_Said_Meddle",
	"EV_BG_Said_No_Igniting",
	"EV_BG_Said_Nuns",
	"EV_BG_Said_Oil",
	"EV_BG_Said_Poker",
	"EV_BG_Said_Poster",
	"EV_BG_Said_Riddle",
	"EV_BG_Said_See_URLs",
	"EV_BG_Said_Sides",
	"EV_BG_Said_Smuggling",
	"EV_BG_Said_Story",
	"EV_BG_Said_Suspicious",
	"EV_BG_Said_Table_Push",
	"EV_BG_Said_Task_List1",
	"EV_BG_Said_Task_List2",
	"EV_BG_Said_Unscramble",
	"EV_BG_Stall1",
	"EV_Casey_Said_Call_Back",
	"EV_Casey_Said_Many_Ships",
	"EV_Casey_Said_Name",
	"EV_Casey_Said_No_Ships",
	"EV_Casey_Said_Smuggling",
	"EV_Casey_Said_Try_Again",
	"EV_Casey_Said_URL",
	"EV_Casey_Said_Wood_Type",
	"EV_Casey_Stall1",
	"EV_Casey_Stall2",
	"EV_Coast_Guard_Bust",
	"EV_Crab_Done",
	"EV_DT_Difficulty_Level",
	"EV_EV_Saw_Card",
	"EV_Finished_Chess_Quiz",
	"EV_Finished_Quiz",
	"EV_Fish_TidePool_Pos01",
	"EV_Fish_TidePool_Pos02",
	"EV_Fish_TidePool_Pos03",
	"EV_FJ_Said_Andy",
	"EV_FJ_Said_Book",
	"EV_FJ_Said_Bottle_Dislodge",
	"EV_FJ_Said_Bulbs",
	"EV_FJ_Said_Bust",
	"EV_FJ_Said_Caddy",
	"EV_FJ_Said_Chess_Book",
	"EV_FJ_Said_Chess_Stumped",
	"EV_FJ_Said_Cleaning",
	"EV_FJ_Said_Driftwood",
	"EV_FJ_Said_Geocache",
	"EV_FJ_Said_GPS",
	"EV_FJ_Said_GPS_Beach",
	"EV_FJ_Said_Hawkins",
	"EV_FJ_Said_Hiding",
	"EV_FJ_Said_Holt",
	"EV_FJ_Said_Jenna",
	"EV_FJ_Said_Lighthouse",
	"EV_FJ_Said_Lighthouse_Lock",
	"EV_FJ_Said_Lock",
	"EV_FJ_Said_No_Like",
	"EV_FJ_Said_Nuns",
	"EV_FJ_Said_Oil",
	"EV_FJ_Said_Poker",
	"EV_FJ_Said_Poster",
	"EV_FJ_Said_Riddle",
	"EV_FJ_Said_See_URLs",
	"EV_FJ_Said_Sides",
	"EV_FJ_Said_Still_There",
	"EV_FJ_Said_Story",
	"EV_FJ_Said_Suspects",
	"EV_FJ_Said_Table_Push",
	"EV_FJ_Said_Tunnel",
	"EV_FJ_Said_Unscramble",
	"EV_Found_Bottle_Note",
	"EV_Found_Bulbs",
	"EV_Found_Clam01",
	"EV_Found_Clam02",
	"EV_Found_Clam03",
	"EV_Found_Clam04",
	"EV_Found_Clam05",
	"EV_Found_Clam06",
	"EV_Found_Clam07",
	"EV_Found_Clam08",
	"EV_Found_Clam09",
	"EV_Found_Clam10",
	"EV_Found_Clam11",
	"EV_Found_Clam12",
	"EV_Found_Clam13",
	"EV_Found_Clam14",
	"EV_Found_Clam15",
	"EV_Got_Crab",
	"EV_Heard_Engine_Turn",
	"EV_Hilda_Said_Buoy_Hunt",
	"EV_Hilda_Said_Hawkins_Boat",
	"EV_Hilda_Said_Objects",
	"EV_Hilda_Said_Tunnel_Riddle",
	"EV_HS_Available",
	"EV_HS_Said_Chess_Task",
	"EV_HS_Said_Harbormaster",
	"EV_HS_Said_Herring",
	"EV_HS_Said_Knew_Hilda",
	"EV_HS_Said_Lighthouse_Bust",
	"EV_HS_Said_No",
	"EV_HS_Said_No_Light",
	"EV_HS_Said_Quiz",
	"EV_HS_Said_See_Crab",
	"EV_HS_Said_See_Quiz",
	"EV_HS_Said_Stay_Away",
	"EV_HS_Said_Wrong_Crab",
	"EV_Inserted_Card",
	"EV_IP_Said_Black_Locust",
	"EV_IP_Said_Black_Walnut",
	"EV_IP_Said_Buckeye",
	"EV_IP_Said_Butternut",
	"EV_IP_Said_Chinkapin",
	"EV_IP_Said_Coffeetree",
	"EV_IP_Said_Douglas",
	"EV_IP_Said_Hemlock",
	"EV_IP_Said_Holly",
	"EV_IP_Said_Honeylocust",
	"EV_IP_Said_Luan",
	"EV_IP_Said_Pecan",
	"EV_IP_Said_Puzzle",
	"EV_IP_Said_Quaking_Aspen",
	"EV_IP_Said_Red_Mulberry",
	"EV_IP_Said_Slippery_Elm",
	"EV_IP_Said_Start",
	"EV_IP_Said_Tanoak",
	"EV_IP_Said_White_Pine",
	"EV_IP_Said_Winged_Elm",
	"EV_Irina_Said_Need_Sample",
	"EV_JD_Available",
	"EV_JD_Denies_Tunnels",
	"EV_JD_No_Tell_Pause",
	"EV_JD_Said_Andy",
	"EV_JD_Said_Bottle_Note",
	"EV_JD_Said_Burglary",
	"EV_JD_Said_Chowder_Up",
	"EV_JD_Said_Clam_Task",
	"EV_JD_Said_Hilda",
	"EV_JD_Said_How_Long",
	"EV_JD_Said_Muffin",
	"EV_JD_Said_No",
	"EV_JD_Said_No_Light",
	"EV_JD_Said_No_Tell",
	"EV_JD_Said_On_House",
	"EV_JD_Said_Sample",
	"EV_JD_Said_SaveKing",
	"EV_JD_Said_Shame",
	"EV_JD_Said_Show_Object",
	"EV_JD_Said_Trap_Door",
	"EV_JD_Said_Tunnel",
	"EV_KF_Ate_Food",
	"EV_KF_Cooled_Off",
	"EV_KF_Denies_SaveKing",
	"EV_KF_Said_Andy",
	"EV_KF_Said_Book_Think",
	"EV_KF_Said_Bottle_Note",
	"EV_KF_Said_Driftwood",
	"EV_KF_Said_Fixed",
	"EV_KF_Said_GPS_Toast",
	"EV_KF_Said_Hawkins",
	"EV_KF_Said_Help_Self",
	"EV_KF_Said_Holt",
	"EV_KF_Said_Holt_Guardian",
	"EV_KF_Said_Hungry",
	"EV_KF_Said_Lighthouse",
	"EV_KF_Said_No_Cops",
	"EV_KF_Said_No_Freezer",
	"EV_KF_Said_Raincheck",
	"EV_KF_Said_Rumors",
	"EV_KF_Said_See_Holt",
	"EV_KF_Said_Ticked_Off",
	"EV_KF_Said_Town_Meeting",
	"EV_KF_Said_Use_Scope",
	"EV_Left1_Up",
	"EV_Left2_Up",
	"EV_Left3_Up",
	"EV_Left4_Up",
	"EV_Left5_Up",
	"EV_Left6_Up",
	"EV_Left7_Up",
	"EV_Left8_Up",
	"EV_Met_AJ",
	"EV_Met_Beach",
	"EV_Met_BG",
	"EV_Met_Casey",
	"EV_Met_FJ",
	"EV_Met_GPS",
	"EV_Met_Hilda",
	"EV_Met_HS",
	"EV_Met_Irina",
	"EV_Met_JD",
	"EV_Met_Kayak",
	"EV_Met_KF",
	"EV_Met_Map",
	"EV_Met_Museum",
	"EV_Met_Sea_Caves",
	"EV_Met_Tunnel",
	"EV_Near_Wood_Sample",
	"EV_Out_Of_Service",
	"EV_Quiz_Done",
	"EV_Released_Crab",
	"EV_Said_Buckeye",
	"EV_Said_Buster",
	"EV_Said_Fetch",
	"EV_Said_First_Guess",
	"EV_Said_JD_Said_Muffin",
	"EV_Said_Key_Card",
	"EV_Said_Know_Type",
	"EV_Said_Label_One",
	"EV_Said_Many_Ships",
	"EV_Said_Not_Back",
	"EV_Said_Quaking_Aspen",
	"EV_Said_SaveKing",
	"EV_Said_Smell",
	"EV_Said_Sorry_Holt",
	"EV_Said_Trained",
	"EV_Said_Want_Sandwich",
	"EV_Said_White_Pine",
	"EV_Said_Wrong_Crab",
	"EV_Saw_BOA_Bottle",
	"EV_Saw_Boat_Gone",
	"EV_Saw_Boat_Parts",
	"EV_Saw_Bottle_Boat",
	"EV_Saw_Card",
	"EV_Saw_CAV_Bottle",
	"EV_Saw_CAV_Containers",
	"EV_Saw_CAV_Ledge",
	"EV_Saw_Celestial_URL",
	"EV_Saw_CHA_Bottle",
	"EV_Saw_Combo",
	"EV_Saw_Crabs_URL",
	"EV_Saw_Dead_Fish",
	"EV_Saw_Email_Bad",
	"EV_Saw_Email_Buoy",
	"EV_Saw_Email_Crisis",
	"EV_Saw_Email_Day",
	"EV_Saw_Email_Guess",
	"EV_Saw_Email_Hair",
	"EV_Saw_Email_Outgoing",
	"EV_Saw_Fish_Postcard",
	"EV_Saw_Fish_Thaw",
	"EV_Saw_Flags_Poster",
	"EV_Saw_Flush_URL",
	"EV_Saw_Flyer",
	"EV_Saw_Four_Bottles",
	"EV_Saw_Gloves",
	"EV_Saw_GPS_Smashed",
	"EV_Saw_Harness",
	"EV_Saw_Hawkins_Door",
	"EV_Saw_Hawkins_Lock",
	"EV_Saw_Hawkins_Msg",
	"EV_Saw_Hilda_Letter",
	"EV_Saw_HS_Hilda_Object",
	"EV_Saw_JD_Burglary",
	"EV_Saw_JD_Hilda_Object",
	"EV_Saw_Key_Chain_Sign",
	"EV_Saw_Knot_URL",
	"EV_Saw_LIG_Lighthouse_Turn",
	"EV_Saw_Lighthouse_Deadend",
	"EV_Saw_Meddle_Note",
	"EV_Saw_Monster_Book",
	"EV_Saw_Morse_URL",
	"EV_Saw_Multi_Bottles",
	"EV_Saw_Nautical_URL",
	"EV_Saw_Near_Miss",
	"EV_Saw_Number_Predoviciu",
	"EV_Saw_Poker_Book",
	"EV_Saw_ROC_Bottle",
	"EV_Saw_Schooner_URL",
	"EV_Saw_Sticker",
	"EV_Saw_Tour_Sign",
	"EV_Saw_Trap_Door",
	"EV_Saw_TUN_Lighthouse_Turn",
	"EV_Saw_Under_Both_Stores",
	"EV_Saw_Under_Store_One",
	"EV_Saw_Under_Store_Two",
	"EV_Saw_Vote_Poster",
	"EV_Saw_WQ_Question01",
	"EV_Saw_WQ_Question02",
	"EV_Saw_WQ_Question03",
	"EV_Saw_WQ_Question04",
	"EV_Saw_WQ_Question05",
	"EV_Saw_WQ_Question06",
	"EV_Saw_WQ_Question07",
	"EV_Saw_WQ_Question08",
	"EV_Saw_WQ_Question09",
	"EV_Saw_WQ_Question10",
	"EV_Saw_WQ_Question11",
	"EV_Saw_WQ_Question12",
	"EV_Saw_WQ_Question13",
	"EV_Saw_WQ_Question14",
	"EV_Saw_WQ_Question15",
	"EV_Saw_WQ_Question16",
	"EV_Saw_WQ_Question17",
	"EV_Saw_WQ_Question18",
	"EV_Saw_WQ_Question19",
	"EV_Saw_WQ_Question20",
	"EV_Second_Promo_Available",
	"EV_Secret_Cave_Door_Opened",
	"EV_Sent_Bad_Morse",
	"EV_Sent_Bad_Morse_Code",
	"EV_Sent_Morse_Code",
	"EV_Slide_Wood",
	"EV_Slide01",
	"EV_Slide02",
	"EV_Slide03",
	"EV_Slide04",
	"EV_Slide05",
	"EV_Slide06",
	"EV_Solved_AJ_Hilda_Object",
	"EV_Solved_Books",
	"EV_Solved_Bottle_Dislodge",
	"EV_Solved_Buoys",
	"EV_Solved_Center_Games",
	"EV_Solved_Chess_Task",
	"EV_Solved_Clam_Task",
	"EV_Solved_Crab",
	"EV_Solved_Flush",
	"EV_Solved_FlushA",
	"EV_Solved_FlushB",
	"EV_Solved_FlushC",
	"EV_Solved_FlushD",
	"EV_Solved_Geocache",
	"EV_Solved_GPS_Beach",
	"EV_Solved_GPS_CacheA",
	"EV_Solved_GPS_CacheB",
	"EV_Solved_Hawkins_Door",
	"EV_Solved_Hawkins_Key",
	"EV_Solved_Hawkins_Lock",
	"EV_Solved_Letter_Assembler",
	"EV_Solved_LIG_Wall",
	"EV_Solved_Lighthouse_Door",
	"EV_Solved_Lighthouse_Turn",
	"EV_Solved_Morse_Code",
	"EV_Solved_Morse_Oil",
	"EV_Solved_Morse_Repair",
	"EV_Solved_Necklace_Box",
	"EV_Solved_Permit_Task",
	"EV_Solved_Pipes",
	"EV_Solved_Quiz",
	"EV_Solved_Red_Mulberry",
	"EV_Solved_Sandwich_Bad",
	"EV_Solved_Sandwich_Good",
	"EV_Solved_Self_Sandwich_Bad",
	"EV_Solved_Self_Sandwich_Good",
	"EV_Solved_Shanghai_Riddle",
	"EV_Solved_Slider_Heck",
	"EV_Solved_Trap_Door",
	"EV_Solved_TUN_Wall",
	"EV_Solved_Whale_Call",
	"EV_Solved_Whale_Feed",
	"EV_Solved_Whale_Quiz",
	"EV_Solved_Whale_Survivor",
	"EV_Solved_Wood_ID",
	"EV_Solved_Wood_Sample",
	"EV_Solved_WQ_Level1",
	"EV_Solved_WQ_Level2",
	"EV_Solved_WQ_Level3",
	"EV_Solved_WQ_Level4",
	"EV_Took_Bulb01",
	"EV_Took_Bulb02",
	"EV_Took_Bulb03",
	"EV_Took_Bulb04",
	"EV_Took_Bulb05",
	"EV_Took_Bulb06",
	"EV_Took_Bulb07",
	"EV_Took_Bulb08",
	"EV_Took_Bulb09",
	"EV_Took_Bulb10",
	"EV_Took_Driftwood",
	"EV_Tried_AJ",
	"EV_Tried_Books",
	"EV_Tried_Bottle_Dislodge",
	"EV_Tried_Chess_Quiz",
	"EV_Tried_FlushA",
	"EV_Tried_FlushB",
	"EV_Tried_FlushC",
	"EV_Tried_FlushD",
	"EV_Tried_Geocache",
	"EV_Tried_Hawkins_Lock",
	"EV_Tried_Hilda_Story",
	"EV_Tried_Letter_Assembler",
	"EV_Tried_LIG_Lighthouse_Turn",
	"EV_Tried_Lighthouse_Door",
	"EV_Tried_Morse_Code",
	"EV_Tried_Morse_Oil",
	"EV_Tried_Morse_Repair",
	"EV_Tried_Multi_Flush",
	"EV_Tried_Necklace_Box",
	"EV_Tried_Permit_Task",
	"EV_Tried_Slide_Hellr",
	"EV_Tried_TUN_Lighthouse_Turn",
	"EV_Tried_Whale_Call",
	"EV_Tried_Whale_Feed",
	"EV_Tried_Whale_Quiz",
	"EV_Tried_Whale_Survivor",
	"EV_Won_Tour",
	"EV_GPS_BEA",
	"EV_GPS_BOA",
	"EV_GPS_CEN",
	"EV_GPS_FRE",
	"EV_GPS_KET",
	"EV_GPS_LIG",
	"EV_GPS_ROC",
	"EV_GPS_CHA_BEA",
	"EV_GPS_CHA_BOA",
	"EV_GPS_CHA_A",
	"EV_GPS_CHA_B",
	"EV_GPS_CHA_C",
	"EV_GPS_CHA_D",
	"EV_GPS_CHA_E",
	"EV_GPS_CHA_F",
	"EV_GPS_CHA_G",
	"EV_GPS_CHA_H",
	"EV_GPS_CHA_I",
	"EV_GPS_CHA_J",
	"EV_GPS_CHA_K",
	"EV_GPS_CHA_L",
	"EV_GPS_CHA_M",
	"EV_GPS_CHA_Remote",
	"EV_GPS_BEA_Island",
	"EV_Said_Comment01",
	"EV_Said_Comment02",
	"EV_Said_Comment03",
	"EV_Said_Comment04",
	"EV_Said_Comment05",
	"EV_Said_Comment06",
	"EV_Said_Comment07",
	"EV_Said_Comment08",
	"EV_Said_Comment09",
	"EV_Said_Comment10",
	"EV_Said_Comment11",
	"EV_Said_Comment12",
	"EV_Said_Comment13",
	"EV_Said_Comment14",
	"EV_Said_Comment15",
	"EV_Said_Comment16",
	"EV_Said_Comment17",
	"EV_Said_Comment18",
	"EV_Said_Comment19",
	"EV_Said_Comment20",
	"EV_Said_Comment21",
	"EV_Said_Comment22",
	"EV_Said_Comment23",
	"EV_Said_Comment24",
	"EV_Said_Comment25",
	"EV_Said_Comment26",
	"EV_Said_Comment27",
	"EV_Said_Comment28",
	"EV_Said_Comment29",
	"EV_Said_Comment30",
	"EV_Said_Comment31",
	"EV_Said_Comment32",
	"EV_Said_Comment33",
	"EV_Said_Comment34",
	"EV_Said_Comment35",
	"EV_Said_Comment36",
	"EV_Said_Comment37",
	"EV_Said_Comment38",
	"EV_Said_Comment39",
	"EV_Said_Comment40",
	"EV_Said_Comment41",
	"EV_Said_Comment42",
	"EV_Said_Comment43",
	"EV_Said_Comment44",
	"EV_Said_Comment45",
	"EV_Said_Comment46",
	"EV_Said_Comment47",
	"EV_Said_Comment48",
	"EV_Said_Comment49",
	"EV_Said_Comment50",
	"EV_Empty1",
	"EV_Empty2",
	"EV_Empty3",
	"EV_Empty4",
	"EV_Empty5",
	"EV_Empty6",
	"EV_Empty7",
	"EV_Empty8",
	"EV_Empty9",
	"EV_Empty10",
	"EV_Empty11",
	"EV_Empty12",
	"EV_Empty13",
	"EV_Empty14",
	"EV_Empty15",
	"EV_Empty16",
	"EV_Empty17",
	"EV_Empty18",
	"EV_Empty19",
	"EV_Empty20",
	"EV_Empty21",
	"EV_Empty22",
	"EV_Empty23",
	"EV_Empty24",
	"EV_Empty25",
	"EV_Empty26",
	"EV_Empty27",
	"EV_Empty28",
	"EV_Empty29",
	"EV_Empty30",
	"EV_Empty31",
	"EV_Empty32",
	"EV_Empty33",
	"EV_Empty34",
	"EV_Empty35",
	"EV_Empty36",
	"EV_Empty37",
	"EV_Empty38",
	"EV_Empty39",
	"EV_Empty40",
	"EV_Empty41",
	"EV_Empty42",
	"EV_Empty43",
	"EV_Empty44",
	"EV_Empty45",
	"EV_Empty46",
	"EV_Empty47",
	"EV_Empty48",
	"EV_Empty49",
	"EV_Empty50",
	"EV_Empty51",
	"EV_Empty52",
	"EV_Empty53",
	"EV_Empty54",
	"EV_Empty55",
	"EV_Empty56",
	"EV_Empty57",
	"EV_Empty58",
	"EV_Empty59",
	"EV_Empty60",
	"EV_Empty61",
	"EV_Empty62",
	"EV_Empty63",
	"EV_Empty64",
	"EV_Empty65",
	"EV_Empty66",
	"EV_Empty67",
	"EV_Empty68",
	"EV_Empty69",
	"EV_Empty70",
	"EV_Empty71",
	"EV_Empty72",
	"EV_Empty73",
	"EV_Empty74",
	"EV_Empty75",
	"EV_Empty76",
	"EV_Empty77",
	"EV_Empty78",
	"EV_Empty79",
	"EV_Empty80",
	"EV_Empty81",
	"EV_Empty82",
	"EV_Empty83",
	"EV_Empty84",
	"EV_Empty85",
	"EV_Empty86",
	"EV_Empty87",
	"EV_Empty88",
	"EV_Empty89",
	"EV_Empty90",
	"EV_Empty91",
	"EV_Empty92",
	"EV_Empty93",
	"EV_Empty94",
	"EV_Empty95",
	"EV_Empty96",
	"EV_Empty97",
	"EV_Empty98",
	"EV_Empty99",
	"EV_Empty100",
	"EV_Empty101",
	"EV_Empty102",
	"EV_Empty103",
	"EV_Empty104",
	"EV_Empty105",
	"EV_Empty106",
	"EV_Empty107",
	"EV_Empty108",
	"EV_Empty109",
	"EV_Empty110",
	"EV_Empty111",
	"EV_Empty112",
	"EV_Empty113",
	"EV_Empty114",
};

#endif // NANCY9DATA_H
