// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(
    clippy::collapsible_if,
    clippy::bool_comparison,
    clippy::nonminimal_bool,
    clippy::comparison_to_empty,
    clippy::redundant_pattern_matching,
    clippy::useless_asref
)]
pub(super) fn resolve_endpoint(
    _params: &crate::config::endpoint::Params,
    _diagnostic_collector: &mut crate::endpoint_lib::diagnostic::DiagnosticCollector,
    partition_resolver: &crate::endpoint_lib::partition::PartitionResolver,
) -> ::aws_smithy_http::endpoint::Result {
    #[allow(unused_variables)]
    let bucket = &_params.bucket;
    #[allow(unused_variables)]
    let region = &_params.region;
    #[allow(unused_variables)]
    let use_fips = &_params.use_fips;
    #[allow(unused_variables)]
    let use_dual_stack = &_params.use_dual_stack;
    #[allow(unused_variables)]
    let endpoint = &_params.endpoint;
    #[allow(unused_variables)]
    let force_path_style = &_params.force_path_style;
    #[allow(unused_variables)]
    let accelerate = &_params.accelerate;
    #[allow(unused_variables)]
    let use_global_endpoint = &_params.use_global_endpoint;
    #[allow(unused_variables)]
    let use_object_lambda_endpoint = &_params.use_object_lambda_endpoint;
    #[allow(unused_variables)]
    let key = &_params.key;
    #[allow(unused_variables)]
    let prefix = &_params.prefix;
    #[allow(unused_variables)]
    let copy_source = &_params.copy_source;
    #[allow(unused_variables)]
    let disable_access_points = &_params.disable_access_points;
    #[allow(unused_variables)]
    let disable_multi_region_access_points = &_params.disable_multi_region_access_points;
    #[allow(unused_variables)]
    let use_arn_region = &_params.use_arn_region;
    #[allow(unused_variables)]
    let use_s3_express_control_endpoint = &_params.use_s3_express_control_endpoint;
    #[allow(unused_variables)]
    let disable_s3_express_session_auth = &_params.disable_s3_express_session_auth;
    #[allow(unused_variables)]
    if let Some(region) = region {
        if (*accelerate) == (true) {
            if (*use_fips) == (true) {
                return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message(
                    "Accelerate cannot be used with FIPS".to_string(),
                ));
            }
        }
        if (*use_dual_stack) == (true) {
            #[allow(unused_variables)]
            if let Some(endpoint) = endpoint {
                return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message(
                    "Cannot set dual-stack in combination with a custom endpoint.".to_string(),
                ));
            }
        }
        #[allow(unused_variables)]
        if let Some(endpoint) = endpoint {
            if (*use_fips) == (true) {
                return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message(
                    "A custom endpoint cannot be combined with FIPS".to_string(),
                ));
            }
        }
        #[allow(unused_variables)]
        if let Some(endpoint) = endpoint {
            if (*accelerate) == (true) {
                return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message(
                    "A custom endpoint cannot be combined with S3 Accelerate".to_string(),
                ));
            }
        }
        if (*use_fips) == (true) {
            #[allow(unused_variables)]
            if let Some(partition_result) = partition_resolver.resolve_partition(region.as_ref() as &str, _diagnostic_collector) {
                if (partition_result.name()) == ("aws-cn") {
                    return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message(
                        "Partition does not support FIPS".to_string(),
                    ));
                }
            }
        }
        #[allow(unused_variables)]
        if let Some(bucket) = bucket {
            #[allow(unused_variables)]
            if let Some(bucket_suffix) = crate::endpoint_lib::substring::substring(bucket.as_ref() as &str, 0, 6, true, _diagnostic_collector) {
                if (bucket_suffix.as_ref() as &str) == ("--x-s3") {
                    if (*use_dual_stack) == (true) {
                        return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message(
                            "S3Express does not support Dual-stack.".to_string(),
                        ));
                    }
                    if (*accelerate) == (true) {
                        return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message(
                            "S3Express does not support S3 Accelerate.".to_string(),
                        ));
                    }
                    #[allow(unused_variables)]
                    if let Some(endpoint) = endpoint {
                        #[allow(unused_variables)]
                        if let Some(url) = crate::endpoint_lib::parse_url::parse_url(endpoint.as_ref() as &str, _diagnostic_collector) {
                            #[allow(unused_variables)]
                            if let Some(disable_s3_express_session_auth) = disable_s3_express_session_auth {
                                if (*disable_s3_express_session_auth) == (true) {
                                    if (url.is_ip()) == (true) {
                                        let uri_encoded_bucket =
                                            crate::endpoint_lib::uri_encode::uri_encode(bucket.as_ref() as &str, _diagnostic_collector);
                                        return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                            .url({
                                                let mut out = String::new();
                                                #[allow(clippy::needless_borrow)]
                                                out.push_str(&url.scheme());
                                                out.push_str("://");
                                                #[allow(clippy::needless_borrow)]
                                                out.push_str(&url.authority());
                                                out.push('/');
                                                #[allow(clippy::needless_borrow)]
                                                out.push_str(&uri_encoded_bucket.as_ref() as &str);
                                                #[allow(clippy::needless_borrow)]
                                                out.push_str(&url.path());
                                                out
                                            })
                                            .property("backend", "S3Express".to_string())
                                            .property(
                                                "authSchemes",
                                                vec![::aws_smithy_types::Document::from({
                                                    let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                    out.insert("disableDoubleEncoding".to_string(), true.into());
                                                    out.insert("name".to_string(), "sigv4".to_string().into());
                                                    out.insert("signingName".to_string(), "s3express".to_string().into());
                                                    out.insert("signingRegion".to_string(), region.to_owned().into());
                                                    out
                                                })],
                                            )
                                            .build());
                                    }
                                    if crate::endpoint_lib::s3::is_virtual_hostable_s3_bucket(bucket.as_ref() as &str, false, _diagnostic_collector) {
                                        return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                            .url({
                                                let mut out = String::new();
                                                #[allow(clippy::needless_borrow)]
                                                out.push_str(&url.scheme());
                                                out.push_str("://");
                                                #[allow(clippy::needless_borrow)]
                                                out.push_str(&bucket.as_ref() as &str);
                                                out.push('.');
                                                #[allow(clippy::needless_borrow)]
                                                out.push_str(&url.authority());
                                                #[allow(clippy::needless_borrow)]
                                                out.push_str(&url.path());
                                                out
                                            })
                                            .property("backend", "S3Express".to_string())
                                            .property(
                                                "authSchemes",
                                                vec![::aws_smithy_types::Document::from({
                                                    let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                    out.insert("disableDoubleEncoding".to_string(), true.into());
                                                    out.insert("name".to_string(), "sigv4".to_string().into());
                                                    out.insert("signingName".to_string(), "s3express".to_string().into());
                                                    out.insert("signingRegion".to_string(), region.to_owned().into());
                                                    out
                                                })],
                                            )
                                            .build());
                                    }
                                    return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message(
                                        "S3Express bucket name is not a valid virtual hostable name.".to_string(),
                                    ));
                                }
                            }
                            if (url.is_ip()) == (true) {
                                let uri_encoded_bucket = crate::endpoint_lib::uri_encode::uri_encode(bucket.as_ref() as &str, _diagnostic_collector);
                                return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                    .url({
                                        let mut out = String::new();
                                        #[allow(clippy::needless_borrow)]
                                        out.push_str(&url.scheme());
                                        out.push_str("://");
                                        #[allow(clippy::needless_borrow)]
                                        out.push_str(&url.authority());
                                        out.push('/');
                                        #[allow(clippy::needless_borrow)]
                                        out.push_str(&uri_encoded_bucket.as_ref() as &str);
                                        #[allow(clippy::needless_borrow)]
                                        out.push_str(&url.path());
                                        out
                                    })
                                    .property("backend", "S3Express".to_string())
                                    .property(
                                        "authSchemes",
                                        vec![::aws_smithy_types::Document::from({
                                            let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                            out.insert("disableDoubleEncoding".to_string(), true.into());
                                            out.insert("name".to_string(), "sigv4-s3express".to_string().into());
                                            out.insert("signingName".to_string(), "s3express".to_string().into());
                                            out.insert("signingRegion".to_string(), region.to_owned().into());
                                            out
                                        })],
                                    )
                                    .build());
                            }
                            if crate::endpoint_lib::s3::is_virtual_hostable_s3_bucket(bucket.as_ref() as &str, false, _diagnostic_collector) {
                                return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                    .url({
                                        let mut out = String::new();
                                        #[allow(clippy::needless_borrow)]
                                        out.push_str(&url.scheme());
                                        out.push_str("://");
                                        #[allow(clippy::needless_borrow)]
                                        out.push_str(&bucket.as_ref() as &str);
                                        out.push('.');
                                        #[allow(clippy::needless_borrow)]
                                        out.push_str(&url.authority());
                                        #[allow(clippy::needless_borrow)]
                                        out.push_str(&url.path());
                                        out
                                    })
                                    .property("backend", "S3Express".to_string())
                                    .property(
                                        "authSchemes",
                                        vec![::aws_smithy_types::Document::from({
                                            let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                            out.insert("disableDoubleEncoding".to_string(), true.into());
                                            out.insert("name".to_string(), "sigv4-s3express".to_string().into());
                                            out.insert("signingName".to_string(), "s3express".to_string().into());
                                            out.insert("signingRegion".to_string(), region.to_owned().into());
                                            out
                                        })],
                                    )
                                    .build());
                            }
                            return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message(
                                "S3Express bucket name is not a valid virtual hostable name.".to_string(),
                            ));
                        }
                    }
                    #[allow(unused_variables)]
                    if let Some(use_s3_express_control_endpoint) = use_s3_express_control_endpoint {
                        if (*use_s3_express_control_endpoint) == (true) {
                            #[allow(unused_variables)]
                            if let Some(partition_result) = partition_resolver.resolve_partition(region.as_ref() as &str, _diagnostic_collector) {
                                let uri_encoded_bucket = crate::endpoint_lib::uri_encode::uri_encode(bucket.as_ref() as &str, _diagnostic_collector);
                                if !(endpoint.is_some()) {
                                    if (*use_fips) == (true) {
                                        return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                            .url({
                                                let mut out = String::new();
                                                out.push_str("https://s3express-control-fips.");
                                                #[allow(clippy::needless_borrow)]
                                                out.push_str(&region.as_ref() as &str);
                                                out.push('.');
                                                #[allow(clippy::needless_borrow)]
                                                out.push_str(&partition_result.dns_suffix());
                                                out.push('/');
                                                #[allow(clippy::needless_borrow)]
                                                out.push_str(&uri_encoded_bucket.as_ref() as &str);
                                                out
                                            })
                                            .property("backend", "S3Express".to_string())
                                            .property(
                                                "authSchemes",
                                                vec![::aws_smithy_types::Document::from({
                                                    let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                    out.insert("disableDoubleEncoding".to_string(), true.into());
                                                    out.insert("name".to_string(), "sigv4".to_string().into());
                                                    out.insert("signingName".to_string(), "s3express".to_string().into());
                                                    out.insert("signingRegion".to_string(), region.to_owned().into());
                                                    out
                                                })],
                                            )
                                            .build());
                                    }
                                    return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                        .url({
                                            let mut out = String::new();
                                            out.push_str("https://s3express-control.");
                                            #[allow(clippy::needless_borrow)]
                                            out.push_str(&region.as_ref() as &str);
                                            out.push('.');
                                            #[allow(clippy::needless_borrow)]
                                            out.push_str(&partition_result.dns_suffix());
                                            out.push('/');
                                            #[allow(clippy::needless_borrow)]
                                            out.push_str(&uri_encoded_bucket.as_ref() as &str);
                                            out
                                        })
                                        .property("backend", "S3Express".to_string())
                                        .property(
                                            "authSchemes",
                                            vec![::aws_smithy_types::Document::from({
                                                let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                out.insert("disableDoubleEncoding".to_string(), true.into());
                                                out.insert("name".to_string(), "sigv4".to_string().into());
                                                out.insert("signingName".to_string(), "s3express".to_string().into());
                                                out.insert("signingRegion".to_string(), region.to_owned().into());
                                                out
                                            })],
                                        )
                                        .build());
                                }
                                #[allow(unreachable_code)]
                                return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message(format!(
                                    "No rules matched these parameters. This is a bug. {:?}",
                                    _params
                                )));
                            }
                            #[allow(unreachable_code)]
                            return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message(format!(
                                "No rules matched these parameters. This is a bug. {:?}",
                                _params
                            )));
                        }
                    }
                    if crate::endpoint_lib::s3::is_virtual_hostable_s3_bucket(bucket.as_ref() as &str, false, _diagnostic_collector) {
                        #[allow(unused_variables)]
                        if let Some(partition_result) = partition_resolver.resolve_partition(region.as_ref() as &str, _diagnostic_collector) {
                            #[allow(unused_variables)]
                            if let Some(disable_s3_express_session_auth) = disable_s3_express_session_auth {
                                if (*disable_s3_express_session_auth) == (true) {
                                    #[allow(unused_variables)]
                                    if let Some(s3express_availability_zone_id) =
                                        crate::endpoint_lib::substring::substring(bucket.as_ref() as &str, 6, 14, true, _diagnostic_collector)
                                    {
                                        #[allow(unused_variables)]
                                        if let Some(s3express_availability_zone_delim) =
                                            crate::endpoint_lib::substring::substring(bucket.as_ref() as &str, 14, 16, true, _diagnostic_collector)
                                        {
                                            if (s3express_availability_zone_delim.as_ref() as &str) == ("--") {
                                                if (*use_fips) == (true) {
                                                    return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                                        .url({
                                                            let mut out = String::new();
                                                            out.push_str("https://");
                                                            #[allow(clippy::needless_borrow)]
                                                            out.push_str(&bucket.as_ref() as &str);
                                                            out.push_str(".s3express-fips-");
                                                            #[allow(clippy::needless_borrow)]
                                                            out.push_str(&s3express_availability_zone_id.as_ref() as &str);
                                                            out.push('.');
                                                            #[allow(clippy::needless_borrow)]
                                                            out.push_str(&region.as_ref() as &str);
                                                            out.push('.');
                                                            #[allow(clippy::needless_borrow)]
                                                            out.push_str(&partition_result.dns_suffix());
                                                            out
                                                        })
                                                        .property("backend", "S3Express".to_string())
                                                        .property(
                                                            "authSchemes",
                                                            vec![::aws_smithy_types::Document::from({
                                                                let mut out =
                                                                    ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                                out.insert("disableDoubleEncoding".to_string(), true.into());
                                                                out.insert("name".to_string(), "sigv4".to_string().into());
                                                                out.insert("signingName".to_string(), "s3express".to_string().into());
                                                                out.insert("signingRegion".to_string(), region.to_owned().into());
                                                                out
                                                            })],
                                                        )
                                                        .build());
                                                }
                                                return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                                    .url({
                                                        let mut out = String::new();
                                                        out.push_str("https://");
                                                        #[allow(clippy::needless_borrow)]
                                                        out.push_str(&bucket.as_ref() as &str);
                                                        out.push_str(".s3express-");
                                                        #[allow(clippy::needless_borrow)]
                                                        out.push_str(&s3express_availability_zone_id.as_ref() as &str);
                                                        out.push('.');
                                                        #[allow(clippy::needless_borrow)]
                                                        out.push_str(&region.as_ref() as &str);
                                                        out.push('.');
                                                        #[allow(clippy::needless_borrow)]
                                                        out.push_str(&partition_result.dns_suffix());
                                                        out
                                                    })
                                                    .property("backend", "S3Express".to_string())
                                                    .property(
                                                        "authSchemes",
                                                        vec![::aws_smithy_types::Document::from({
                                                            let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                            out.insert("disableDoubleEncoding".to_string(), true.into());
                                                            out.insert("name".to_string(), "sigv4".to_string().into());
                                                            out.insert("signingName".to_string(), "s3express".to_string().into());
                                                            out.insert("signingRegion".to_string(), region.to_owned().into());
                                                            out
                                                        })],
                                                    )
                                                    .build());
                                            }
                                        }
                                    }
                                    #[allow(unused_variables)]
                                    if let Some(s3express_availability_zone_id) =
                                        crate::endpoint_lib::substring::substring(bucket.as_ref() as &str, 6, 15, true, _diagnostic_collector)
                                    {
                                        #[allow(unused_variables)]
                                        if let Some(s3express_availability_zone_delim) =
                                            crate::endpoint_lib::substring::substring(bucket.as_ref() as &str, 15, 17, true, _diagnostic_collector)
                                        {
                                            if (s3express_availability_zone_delim.as_ref() as &str) == ("--") {
                                                if (*use_fips) == (true) {
                                                    return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                                        .url({
                                                            let mut out = String::new();
                                                            out.push_str("https://");
                                                            #[allow(clippy::needless_borrow)]
                                                            out.push_str(&bucket.as_ref() as &str);
                                                            out.push_str(".s3express-fips-");
                                                            #[allow(clippy::needless_borrow)]
                                                            out.push_str(&s3express_availability_zone_id.as_ref() as &str);
                                                            out.push('.');
                                                            #[allow(clippy::needless_borrow)]
                                                            out.push_str(&region.as_ref() as &str);
                                                            out.push('.');
                                                            #[allow(clippy::needless_borrow)]
                                                            out.push_str(&partition_result.dns_suffix());
                                                            out
                                                        })
                                                        .property("backend", "S3Express".to_string())
                                                        .property(
                                                            "authSchemes",
                                                            vec![::aws_smithy_types::Document::from({
                                                                let mut out =
                                                                    ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                                out.insert("disableDoubleEncoding".to_string(), true.into());
                                                                out.insert("name".to_string(), "sigv4".to_string().into());
                                                                out.insert("signingName".to_string(), "s3express".to_string().into());
                                                                out.insert("signingRegion".to_string(), region.to_owned().into());
                                                                out
                                                            })],
                                                        )
                                                        .build());
                                                }
                                                return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                                    .url({
                                                        let mut out = String::new();
                                                        out.push_str("https://");
                                                        #[allow(clippy::needless_borrow)]
                                                        out.push_str(&bucket.as_ref() as &str);
                                                        out.push_str(".s3express-");
                                                        #[allow(clippy::needless_borrow)]
                                                        out.push_str(&s3express_availability_zone_id.as_ref() as &str);
                                                        out.push('.');
                                                        #[allow(clippy::needless_borrow)]
                                                        out.push_str(&region.as_ref() as &str);
                                                        out.push('.');
                                                        #[allow(clippy::needless_borrow)]
                                                        out.push_str(&partition_result.dns_suffix());
                                                        out
                                                    })
                                                    .property("backend", "S3Express".to_string())
                                                    .property(
                                                        "authSchemes",
                                                        vec![::aws_smithy_types::Document::from({
                                                            let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                            out.insert("disableDoubleEncoding".to_string(), true.into());
                                                            out.insert("name".to_string(), "sigv4".to_string().into());
                                                            out.insert("signingName".to_string(), "s3express".to_string().into());
                                                            out.insert("signingRegion".to_string(), region.to_owned().into());
                                                            out
                                                        })],
                                                    )
                                                    .build());
                                            }
                                        }
                                    }
                                    #[allow(unused_variables)]
                                    if let Some(s3express_availability_zone_id) =
                                        crate::endpoint_lib::substring::substring(bucket.as_ref() as &str, 6, 19, true, _diagnostic_collector)
                                    {
                                        #[allow(unused_variables)]
                                        if let Some(s3express_availability_zone_delim) =
                                            crate::endpoint_lib::substring::substring(bucket.as_ref() as &str, 19, 21, true, _diagnostic_collector)
                                        {
                                            if (s3express_availability_zone_delim.as_ref() as &str) == ("--") {
                                                if (*use_fips) == (true) {
                                                    return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                                        .url({
                                                            let mut out = String::new();
                                                            out.push_str("https://");
                                                            #[allow(clippy::needless_borrow)]
                                                            out.push_str(&bucket.as_ref() as &str);
                                                            out.push_str(".s3express-fips-");
                                                            #[allow(clippy::needless_borrow)]
                                                            out.push_str(&s3express_availability_zone_id.as_ref() as &str);
                                                            out.push('.');
                                                            #[allow(clippy::needless_borrow)]
                                                            out.push_str(&region.as_ref() as &str);
                                                            out.push('.');
                                                            #[allow(clippy::needless_borrow)]
                                                            out.push_str(&partition_result.dns_suffix());
                                                            out
                                                        })
                                                        .property("backend", "S3Express".to_string())
                                                        .property(
                                                            "authSchemes",
                                                            vec![::aws_smithy_types::Document::from({
                                                                let mut out =
                                                                    ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                                out.insert("disableDoubleEncoding".to_string(), true.into());
                                                                out.insert("name".to_string(), "sigv4".to_string().into());
                                                                out.insert("signingName".to_string(), "s3express".to_string().into());
                                                                out.insert("signingRegion".to_string(), region.to_owned().into());
                                                                out
                                                            })],
                                                        )
                                                        .build());
                                                }
                                                return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                                    .url({
                                                        let mut out = String::new();
                                                        out.push_str("https://");
                                                        #[allow(clippy::needless_borrow)]
                                                        out.push_str(&bucket.as_ref() as &str);
                                                        out.push_str(".s3express-");
                                                        #[allow(clippy::needless_borrow)]
                                                        out.push_str(&s3express_availability_zone_id.as_ref() as &str);
                                                        out.push('.');
                                                        #[allow(clippy::needless_borrow)]
                                                        out.push_str(&region.as_ref() as &str);
                                                        out.push('.');
                                                        #[allow(clippy::needless_borrow)]
                                                        out.push_str(&partition_result.dns_suffix());
                                                        out
                                                    })
                                                    .property("backend", "S3Express".to_string())
                                                    .property(
                                                        "authSchemes",
                                                        vec![::aws_smithy_types::Document::from({
                                                            let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                            out.insert("disableDoubleEncoding".to_string(), true.into());
                                                            out.insert("name".to_string(), "sigv4".to_string().into());
                                                            out.insert("signingName".to_string(), "s3express".to_string().into());
                                                            out.insert("signingRegion".to_string(), region.to_owned().into());
                                                            out
                                                        })],
                                                    )
                                                    .build());
                                            }
                                        }
                                    }
                                    #[allow(unused_variables)]
                                    if let Some(s3express_availability_zone_id) =
                                        crate::endpoint_lib::substring::substring(bucket.as_ref() as &str, 6, 20, true, _diagnostic_collector)
                                    {
                                        #[allow(unused_variables)]
                                        if let Some(s3express_availability_zone_delim) =
                                            crate::endpoint_lib::substring::substring(bucket.as_ref() as &str, 20, 22, true, _diagnostic_collector)
                                        {
                                            if (s3express_availability_zone_delim.as_ref() as &str) == ("--") {
                                                if (*use_fips) == (true) {
                                                    return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                                        .url({
                                                            let mut out = String::new();
                                                            out.push_str("https://");
                                                            #[allow(clippy::needless_borrow)]
                                                            out.push_str(&bucket.as_ref() as &str);
                                                            out.push_str(".s3express-fips-");
                                                            #[allow(clippy::needless_borrow)]
                                                            out.push_str(&s3express_availability_zone_id.as_ref() as &str);
                                                            out.push('.');
                                                            #[allow(clippy::needless_borrow)]
                                                            out.push_str(&region.as_ref() as &str);
                                                            out.push('.');
                                                            #[allow(clippy::needless_borrow)]
                                                            out.push_str(&partition_result.dns_suffix());
                                                            out
                                                        })
                                                        .property("backend", "S3Express".to_string())
                                                        .property(
                                                            "authSchemes",
                                                            vec![::aws_smithy_types::Document::from({
                                                                let mut out =
                                                                    ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                                out.insert("disableDoubleEncoding".to_string(), true.into());
                                                                out.insert("name".to_string(), "sigv4".to_string().into());
                                                                out.insert("signingName".to_string(), "s3express".to_string().into());
                                                                out.insert("signingRegion".to_string(), region.to_owned().into());
                                                                out
                                                            })],
                                                        )
                                                        .build());
                                                }
                                                return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                                    .url({
                                                        let mut out = String::new();
                                                        out.push_str("https://");
                                                        #[allow(clippy::needless_borrow)]
                                                        out.push_str(&bucket.as_ref() as &str);
                                                        out.push_str(".s3express-");
                                                        #[allow(clippy::needless_borrow)]
                                                        out.push_str(&s3express_availability_zone_id.as_ref() as &str);
                                                        out.push('.');
                                                        #[allow(clippy::needless_borrow)]
                                                        out.push_str(&region.as_ref() as &str);
                                                        out.push('.');
                                                        #[allow(clippy::needless_borrow)]
                                                        out.push_str(&partition_result.dns_suffix());
                                                        out
                                                    })
                                                    .property("backend", "S3Express".to_string())
                                                    .property(
                                                        "authSchemes",
                                                        vec![::aws_smithy_types::Document::from({
                                                            let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                            out.insert("disableDoubleEncoding".to_string(), true.into());
                                                            out.insert("name".to_string(), "sigv4".to_string().into());
                                                            out.insert("signingName".to_string(), "s3express".to_string().into());
                                                            out.insert("signingRegion".to_string(), region.to_owned().into());
                                                            out
                                                        })],
                                                    )
                                                    .build());
                                            }
                                        }
                                    }
                                    #[allow(unused_variables)]
                                    if let Some(s3express_availability_zone_id) =
                                        crate::endpoint_lib::substring::substring(bucket.as_ref() as &str, 6, 26, true, _diagnostic_collector)
                                    {
                                        #[allow(unused_variables)]
                                        if let Some(s3express_availability_zone_delim) =
                                            crate::endpoint_lib::substring::substring(bucket.as_ref() as &str, 26, 28, true, _diagnostic_collector)
                                        {
                                            if (s3express_availability_zone_delim.as_ref() as &str) == ("--") {
                                                if (*use_fips) == (true) {
                                                    return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                                        .url({
                                                            let mut out = String::new();
                                                            out.push_str("https://");
                                                            #[allow(clippy::needless_borrow)]
                                                            out.push_str(&bucket.as_ref() as &str);
                                                            out.push_str(".s3express-fips-");
                                                            #[allow(clippy::needless_borrow)]
                                                            out.push_str(&s3express_availability_zone_id.as_ref() as &str);
                                                            out.push('.');
                                                            #[allow(clippy::needless_borrow)]
                                                            out.push_str(&region.as_ref() as &str);
                                                            out.push('.');
                                                            #[allow(clippy::needless_borrow)]
                                                            out.push_str(&partition_result.dns_suffix());
                                                            out
                                                        })
                                                        .property("backend", "S3Express".to_string())
                                                        .property(
                                                            "authSchemes",
                                                            vec![::aws_smithy_types::Document::from({
                                                                let mut out =
                                                                    ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                                out.insert("disableDoubleEncoding".to_string(), true.into());
                                                                out.insert("name".to_string(), "sigv4".to_string().into());
                                                                out.insert("signingName".to_string(), "s3express".to_string().into());
                                                                out.insert("signingRegion".to_string(), region.to_owned().into());
                                                                out
                                                            })],
                                                        )
                                                        .build());
                                                }
                                                return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                                    .url({
                                                        let mut out = String::new();
                                                        out.push_str("https://");
                                                        #[allow(clippy::needless_borrow)]
                                                        out.push_str(&bucket.as_ref() as &str);
                                                        out.push_str(".s3express-");
                                                        #[allow(clippy::needless_borrow)]
                                                        out.push_str(&s3express_availability_zone_id.as_ref() as &str);
                                                        out.push('.');
                                                        #[allow(clippy::needless_borrow)]
                                                        out.push_str(&region.as_ref() as &str);
                                                        out.push('.');
                                                        #[allow(clippy::needless_borrow)]
                                                        out.push_str(&partition_result.dns_suffix());
                                                        out
                                                    })
                                                    .property("backend", "S3Express".to_string())
                                                    .property(
                                                        "authSchemes",
                                                        vec![::aws_smithy_types::Document::from({
                                                            let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                            out.insert("disableDoubleEncoding".to_string(), true.into());
                                                            out.insert("name".to_string(), "sigv4".to_string().into());
                                                            out.insert("signingName".to_string(), "s3express".to_string().into());
                                                            out.insert("signingRegion".to_string(), region.to_owned().into());
                                                            out
                                                        })],
                                                    )
                                                    .build());
                                            }
                                        }
                                    }
                                    return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message(
                                        "Unrecognized S3Express bucket name format.".to_string(),
                                    ));
                                }
                            }
                            #[allow(unused_variables)]
                            if let Some(s3express_availability_zone_id) =
                                crate::endpoint_lib::substring::substring(bucket.as_ref() as &str, 6, 14, true, _diagnostic_collector)
                            {
                                #[allow(unused_variables)]
                                if let Some(s3express_availability_zone_delim) =
                                    crate::endpoint_lib::substring::substring(bucket.as_ref() as &str, 14, 16, true, _diagnostic_collector)
                                {
                                    if (s3express_availability_zone_delim.as_ref() as &str) == ("--") {
                                        if (*use_fips) == (true) {
                                            return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                                .url({
                                                    let mut out = String::new();
                                                    out.push_str("https://");
                                                    #[allow(clippy::needless_borrow)]
                                                    out.push_str(&bucket.as_ref() as &str);
                                                    out.push_str(".s3express-fips-");
                                                    #[allow(clippy::needless_borrow)]
                                                    out.push_str(&s3express_availability_zone_id.as_ref() as &str);
                                                    out.push('.');
                                                    #[allow(clippy::needless_borrow)]
                                                    out.push_str(&region.as_ref() as &str);
                                                    out.push('.');
                                                    #[allow(clippy::needless_borrow)]
                                                    out.push_str(&partition_result.dns_suffix());
                                                    out
                                                })
                                                .property("backend", "S3Express".to_string())
                                                .property(
                                                    "authSchemes",
                                                    vec![::aws_smithy_types::Document::from({
                                                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                        out.insert("disableDoubleEncoding".to_string(), true.into());
                                                        out.insert("name".to_string(), "sigv4-s3express".to_string().into());
                                                        out.insert("signingName".to_string(), "s3express".to_string().into());
                                                        out.insert("signingRegion".to_string(), region.to_owned().into());
                                                        out
                                                    })],
                                                )
                                                .build());
                                        }
                                        return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                            .url({
                                                let mut out = String::new();
                                                out.push_str("https://");
                                                #[allow(clippy::needless_borrow)]
                                                out.push_str(&bucket.as_ref() as &str);
                                                out.push_str(".s3express-");
                                                #[allow(clippy::needless_borrow)]
                                                out.push_str(&s3express_availability_zone_id.as_ref() as &str);
                                                out.push('.');
                                                #[allow(clippy::needless_borrow)]
                                                out.push_str(&region.as_ref() as &str);
                                                out.push('.');
                                                #[allow(clippy::needless_borrow)]
                                                out.push_str(&partition_result.dns_suffix());
                                                out
                                            })
                                            .property("backend", "S3Express".to_string())
                                            .property(
                                                "authSchemes",
                                                vec![::aws_smithy_types::Document::from({
                                                    let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                    out.insert("disableDoubleEncoding".to_string(), true.into());
                                                    out.insert("name".to_string(), "sigv4-s3express".to_string().into());
                                                    out.insert("signingName".to_string(), "s3express".to_string().into());
                                                    out.insert("signingRegion".to_string(), region.to_owned().into());
                                                    out
                                                })],
                                            )
                                            .build());
                                    }
                                }
                            }
                            #[allow(unused_variables)]
                            if let Some(s3express_availability_zone_id) =
                                crate::endpoint_lib::substring::substring(bucket.as_ref() as &str, 6, 15, true, _diagnostic_collector)
                            {
                                #[allow(unused_variables)]
                                if let Some(s3express_availability_zone_delim) =
                                    crate::endpoint_lib::substring::substring(bucket.as_ref() as &str, 15, 17, true, _diagnostic_collector)
                                {
                                    if (s3express_availability_zone_delim.as_ref() as &str) == ("--") {
                                        if (*use_fips) == (true) {
                                            return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                                .url({
                                                    let mut out = String::new();
                                                    out.push_str("https://");
                                                    #[allow(clippy::needless_borrow)]
                                                    out.push_str(&bucket.as_ref() as &str);
                                                    out.push_str(".s3express-fips-");
                                                    #[allow(clippy::needless_borrow)]
                                                    out.push_str(&s3express_availability_zone_id.as_ref() as &str);
                                                    out.push('.');
                                                    #[allow(clippy::needless_borrow)]
                                                    out.push_str(&region.as_ref() as &str);
                                                    out.push('.');
                                                    #[allow(clippy::needless_borrow)]
                                                    out.push_str(&partition_result.dns_suffix());
                                                    out
                                                })
                                                .property("backend", "S3Express".to_string())
                                                .property(
                                                    "authSchemes",
                                                    vec![::aws_smithy_types::Document::from({
                                                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                        out.insert("disableDoubleEncoding".to_string(), true.into());
                                                        out.insert("name".to_string(), "sigv4-s3express".to_string().into());
                                                        out.insert("signingName".to_string(), "s3express".to_string().into());
                                                        out.insert("signingRegion".to_string(), region.to_owned().into());
                                                        out
                                                    })],
                                                )
                                                .build());
                                        }
                                        return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                            .url({
                                                let mut out = String::new();
                                                out.push_str("https://");
                                                #[allow(clippy::needless_borrow)]
                                                out.push_str(&bucket.as_ref() as &str);
                                                out.push_str(".s3express-");
                                                #[allow(clippy::needless_borrow)]
                                                out.push_str(&s3express_availability_zone_id.as_ref() as &str);
                                                out.push('.');
                                                #[allow(clippy::needless_borrow)]
                                                out.push_str(&region.as_ref() as &str);
                                                out.push('.');
                                                #[allow(clippy::needless_borrow)]
                                                out.push_str(&partition_result.dns_suffix());
                                                out
                                            })
                                            .property("backend", "S3Express".to_string())
                                            .property(
                                                "authSchemes",
                                                vec![::aws_smithy_types::Document::from({
                                                    let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                    out.insert("disableDoubleEncoding".to_string(), true.into());
                                                    out.insert("name".to_string(), "sigv4-s3express".to_string().into());
                                                    out.insert("signingName".to_string(), "s3express".to_string().into());
                                                    out.insert("signingRegion".to_string(), region.to_owned().into());
                                                    out
                                                })],
                                            )
                                            .build());
                                    }
                                }
                            }
                            #[allow(unused_variables)]
                            if let Some(s3express_availability_zone_id) =
                                crate::endpoint_lib::substring::substring(bucket.as_ref() as &str, 6, 19, true, _diagnostic_collector)
                            {
                                #[allow(unused_variables)]
                                if let Some(s3express_availability_zone_delim) =
                                    crate::endpoint_lib::substring::substring(bucket.as_ref() as &str, 19, 21, true, _diagnostic_collector)
                                {
                                    if (s3express_availability_zone_delim.as_ref() as &str) == ("--") {
                                        if (*use_fips) == (true) {
                                            return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                                .url({
                                                    let mut out = String::new();
                                                    out.push_str("https://");
                                                    #[allow(clippy::needless_borrow)]
                                                    out.push_str(&bucket.as_ref() as &str);
                                                    out.push_str(".s3express-fips-");
                                                    #[allow(clippy::needless_borrow)]
                                                    out.push_str(&s3express_availability_zone_id.as_ref() as &str);
                                                    out.push('.');
                                                    #[allow(clippy::needless_borrow)]
                                                    out.push_str(&region.as_ref() as &str);
                                                    out.push('.');
                                                    #[allow(clippy::needless_borrow)]
                                                    out.push_str(&partition_result.dns_suffix());
                                                    out
                                                })
                                                .property("backend", "S3Express".to_string())
                                                .property(
                                                    "authSchemes",
                                                    vec![::aws_smithy_types::Document::from({
                                                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                        out.insert("disableDoubleEncoding".to_string(), true.into());
                                                        out.insert("name".to_string(), "sigv4-s3express".to_string().into());
                                                        out.insert("signingName".to_string(), "s3express".to_string().into());
                                                        out.insert("signingRegion".to_string(), region.to_owned().into());
                                                        out
                                                    })],
                                                )
                                                .build());
                                        }
                                        return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                            .url({
                                                let mut out = String::new();
                                                out.push_str("https://");
                                                #[allow(clippy::needless_borrow)]
                                                out.push_str(&bucket.as_ref() as &str);
                                                out.push_str(".s3express-");
                                                #[allow(clippy::needless_borrow)]
                                                out.push_str(&s3express_availability_zone_id.as_ref() as &str);
                                                out.push('.');
                                                #[allow(clippy::needless_borrow)]
                                                out.push_str(&region.as_ref() as &str);
                                                out.push('.');
                                                #[allow(clippy::needless_borrow)]
                                                out.push_str(&partition_result.dns_suffix());
                                                out
                                            })
                                            .property("backend", "S3Express".to_string())
                                            .property(
                                                "authSchemes",
                                                vec![::aws_smithy_types::Document::from({
                                                    let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                    out.insert("disableDoubleEncoding".to_string(), true.into());
                                                    out.insert("name".to_string(), "sigv4-s3express".to_string().into());
                                                    out.insert("signingName".to_string(), "s3express".to_string().into());
                                                    out.insert("signingRegion".to_string(), region.to_owned().into());
                                                    out
                                                })],
                                            )
                                            .build());
                                    }
                                }
                            }
                            #[allow(unused_variables)]
                            if let Some(s3express_availability_zone_id) =
                                crate::endpoint_lib::substring::substring(bucket.as_ref() as &str, 6, 20, true, _diagnostic_collector)
                            {
                                #[allow(unused_variables)]
                                if let Some(s3express_availability_zone_delim) =
                                    crate::endpoint_lib::substring::substring(bucket.as_ref() as &str, 20, 22, true, _diagnostic_collector)
                                {
                                    if (s3express_availability_zone_delim.as_ref() as &str) == ("--") {
                                        if (*use_fips) == (true) {
                                            return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                                .url({
                                                    let mut out = String::new();
                                                    out.push_str("https://");
                                                    #[allow(clippy::needless_borrow)]
                                                    out.push_str(&bucket.as_ref() as &str);
                                                    out.push_str(".s3express-fips-");
                                                    #[allow(clippy::needless_borrow)]
                                                    out.push_str(&s3express_availability_zone_id.as_ref() as &str);
                                                    out.push('.');
                                                    #[allow(clippy::needless_borrow)]
                                                    out.push_str(&region.as_ref() as &str);
                                                    out.push('.');
                                                    #[allow(clippy::needless_borrow)]
                                                    out.push_str(&partition_result.dns_suffix());
                                                    out
                                                })
                                                .property("backend", "S3Express".to_string())
                                                .property(
                                                    "authSchemes",
                                                    vec![::aws_smithy_types::Document::from({
                                                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                        out.insert("disableDoubleEncoding".to_string(), true.into());
                                                        out.insert("name".to_string(), "sigv4-s3express".to_string().into());
                                                        out.insert("signingName".to_string(), "s3express".to_string().into());
                                                        out.insert("signingRegion".to_string(), region.to_owned().into());
                                                        out
                                                    })],
                                                )
                                                .build());
                                        }
                                        return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                            .url({
                                                let mut out = String::new();
                                                out.push_str("https://");
                                                #[allow(clippy::needless_borrow)]
                                                out.push_str(&bucket.as_ref() as &str);
                                                out.push_str(".s3express-");
                                                #[allow(clippy::needless_borrow)]
                                                out.push_str(&s3express_availability_zone_id.as_ref() as &str);
                                                out.push('.');
                                                #[allow(clippy::needless_borrow)]
                                                out.push_str(&region.as_ref() as &str);
                                                out.push('.');
                                                #[allow(clippy::needless_borrow)]
                                                out.push_str(&partition_result.dns_suffix());
                                                out
                                            })
                                            .property("backend", "S3Express".to_string())
                                            .property(
                                                "authSchemes",
                                                vec![::aws_smithy_types::Document::from({
                                                    let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                    out.insert("disableDoubleEncoding".to_string(), true.into());
                                                    out.insert("name".to_string(), "sigv4-s3express".to_string().into());
                                                    out.insert("signingName".to_string(), "s3express".to_string().into());
                                                    out.insert("signingRegion".to_string(), region.to_owned().into());
                                                    out
                                                })],
                                            )
                                            .build());
                                    }
                                }
                            }
                            #[allow(unused_variables)]
                            if let Some(s3express_availability_zone_id) =
                                crate::endpoint_lib::substring::substring(bucket.as_ref() as &str, 6, 26, true, _diagnostic_collector)
                            {
                                #[allow(unused_variables)]
                                if let Some(s3express_availability_zone_delim) =
                                    crate::endpoint_lib::substring::substring(bucket.as_ref() as &str, 26, 28, true, _diagnostic_collector)
                                {
                                    if (s3express_availability_zone_delim.as_ref() as &str) == ("--") {
                                        if (*use_fips) == (true) {
                                            return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                                .url({
                                                    let mut out = String::new();
                                                    out.push_str("https://");
                                                    #[allow(clippy::needless_borrow)]
                                                    out.push_str(&bucket.as_ref() as &str);
                                                    out.push_str(".s3express-fips-");
                                                    #[allow(clippy::needless_borrow)]
                                                    out.push_str(&s3express_availability_zone_id.as_ref() as &str);
                                                    out.push('.');
                                                    #[allow(clippy::needless_borrow)]
                                                    out.push_str(&region.as_ref() as &str);
                                                    out.push('.');
                                                    #[allow(clippy::needless_borrow)]
                                                    out.push_str(&partition_result.dns_suffix());
                                                    out
                                                })
                                                .property("backend", "S3Express".to_string())
                                                .property(
                                                    "authSchemes",
                                                    vec![::aws_smithy_types::Document::from({
                                                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                        out.insert("disableDoubleEncoding".to_string(), true.into());
                                                        out.insert("name".to_string(), "sigv4-s3express".to_string().into());
                                                        out.insert("signingName".to_string(), "s3express".to_string().into());
                                                        out.insert("signingRegion".to_string(), region.to_owned().into());
                                                        out
                                                    })],
                                                )
                                                .build());
                                        }
                                        return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                            .url({
                                                let mut out = String::new();
                                                out.push_str("https://");
                                                #[allow(clippy::needless_borrow)]
                                                out.push_str(&bucket.as_ref() as &str);
                                                out.push_str(".s3express-");
                                                #[allow(clippy::needless_borrow)]
                                                out.push_str(&s3express_availability_zone_id.as_ref() as &str);
                                                out.push('.');
                                                #[allow(clippy::needless_borrow)]
                                                out.push_str(&region.as_ref() as &str);
                                                out.push('.');
                                                #[allow(clippy::needless_borrow)]
                                                out.push_str(&partition_result.dns_suffix());
                                                out
                                            })
                                            .property("backend", "S3Express".to_string())
                                            .property(
                                                "authSchemes",
                                                vec![::aws_smithy_types::Document::from({
                                                    let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                    out.insert("disableDoubleEncoding".to_string(), true.into());
                                                    out.insert("name".to_string(), "sigv4-s3express".to_string().into());
                                                    out.insert("signingName".to_string(), "s3express".to_string().into());
                                                    out.insert("signingRegion".to_string(), region.to_owned().into());
                                                    out
                                                })],
                                            )
                                            .build());
                                    }
                                }
                            }
                            return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message(
                                "Unrecognized S3Express bucket name format.".to_string(),
                            ));
                        }
                        #[allow(unreachable_code)]
                        return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message(format!(
                            "No rules matched these parameters. This is a bug. {:?}",
                            _params
                        )));
                    }
                    return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message(
                        "S3Express bucket name is not a valid virtual hostable name.".to_string(),
                    ));
                }
            }
        }
        #[allow(unused_variables)]
        if let Some(bucket) = bucket {
            #[allow(unused_variables)]
            if let Some(access_point_suffix) = crate::endpoint_lib::substring::substring(bucket.as_ref() as &str, 0, 7, true, _diagnostic_collector) {
                if (access_point_suffix.as_ref() as &str) == ("--xa-s3") {
                    if (*use_dual_stack) == (true) {
                        return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message(
                            "S3Express does not support Dual-stack.".to_string(),
                        ));
                    }
                    if (*accelerate) == (true) {
                        return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message(
                            "S3Express does not support S3 Accelerate.".to_string(),
                        ));
                    }
                    #[allow(unused_variables)]
                    if let Some(endpoint) = endpoint {
                        #[allow(unused_variables)]
                        if let Some(url) = crate::endpoint_lib::parse_url::parse_url(endpoint.as_ref() as &str, _diagnostic_collector) {
                            #[allow(unused_variables)]
                            if let Some(disable_s3_express_session_auth) = disable_s3_express_session_auth {
                                if (*disable_s3_express_session_auth) == (true) {
                                    if (url.is_ip()) == (true) {
                                        let uri_encoded_bucket =
                                            crate::endpoint_lib::uri_encode::uri_encode(bucket.as_ref() as &str, _diagnostic_collector);
                                        return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                            .url({
                                                let mut out = String::new();
                                                #[allow(clippy::needless_borrow)]
                                                out.push_str(&url.scheme());
                                                out.push_str("://");
                                                #[allow(clippy::needless_borrow)]
                                                out.push_str(&url.authority());
                                                out.push('/');
                                                #[allow(clippy::needless_borrow)]
                                                out.push_str(&uri_encoded_bucket.as_ref() as &str);
                                                #[allow(clippy::needless_borrow)]
                                                out.push_str(&url.path());
                                                out
                                            })
                                            .property("backend", "S3Express".to_string())
                                            .property(
                                                "authSchemes",
                                                vec![::aws_smithy_types::Document::from({
                                                    let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                    out.insert("disableDoubleEncoding".to_string(), true.into());
                                                    out.insert("name".to_string(), "sigv4".to_string().into());
                                                    out.insert("signingName".to_string(), "s3express".to_string().into());
                                                    out.insert("signingRegion".to_string(), region.to_owned().into());
                                                    out
                                                })],
                                            )
                                            .build());
                                    }
                                    if crate::endpoint_lib::s3::is_virtual_hostable_s3_bucket(bucket.as_ref() as &str, false, _diagnostic_collector) {
                                        return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                            .url({
                                                let mut out = String::new();
                                                #[allow(clippy::needless_borrow)]
                                                out.push_str(&url.scheme());
                                                out.push_str("://");
                                                #[allow(clippy::needless_borrow)]
                                                out.push_str(&bucket.as_ref() as &str);
                                                out.push('.');
                                                #[allow(clippy::needless_borrow)]
                                                out.push_str(&url.authority());
                                                #[allow(clippy::needless_borrow)]
                                                out.push_str(&url.path());
                                                out
                                            })
                                            .property("backend", "S3Express".to_string())
                                            .property(
                                                "authSchemes",
                                                vec![::aws_smithy_types::Document::from({
                                                    let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                    out.insert("disableDoubleEncoding".to_string(), true.into());
                                                    out.insert("name".to_string(), "sigv4".to_string().into());
                                                    out.insert("signingName".to_string(), "s3express".to_string().into());
                                                    out.insert("signingRegion".to_string(), region.to_owned().into());
                                                    out
                                                })],
                                            )
                                            .build());
                                    }
                                    return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message(
                                        "S3Express bucket name is not a valid virtual hostable name.".to_string(),
                                    ));
                                }
                            }
                            if (url.is_ip()) == (true) {
                                let uri_encoded_bucket = crate::endpoint_lib::uri_encode::uri_encode(bucket.as_ref() as &str, _diagnostic_collector);
                                return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                    .url({
                                        let mut out = String::new();
                                        #[allow(clippy::needless_borrow)]
                                        out.push_str(&url.scheme());
                                        out.push_str("://");
                                        #[allow(clippy::needless_borrow)]
                                        out.push_str(&url.authority());
                                        out.push('/');
                                        #[allow(clippy::needless_borrow)]
                                        out.push_str(&uri_encoded_bucket.as_ref() as &str);
                                        #[allow(clippy::needless_borrow)]
                                        out.push_str(&url.path());
                                        out
                                    })
                                    .property("backend", "S3Express".to_string())
                                    .property(
                                        "authSchemes",
                                        vec![::aws_smithy_types::Document::from({
                                            let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                            out.insert("disableDoubleEncoding".to_string(), true.into());
                                            out.insert("name".to_string(), "sigv4-s3express".to_string().into());
                                            out.insert("signingName".to_string(), "s3express".to_string().into());
                                            out.insert("signingRegion".to_string(), region.to_owned().into());
                                            out
                                        })],
                                    )
                                    .build());
                            }
                            if crate::endpoint_lib::s3::is_virtual_hostable_s3_bucket(bucket.as_ref() as &str, false, _diagnostic_collector) {
                                return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                    .url({
                                        let mut out = String::new();
                                        #[allow(clippy::needless_borrow)]
                                        out.push_str(&url.scheme());
                                        out.push_str("://");
                                        #[allow(clippy::needless_borrow)]
                                        out.push_str(&bucket.as_ref() as &str);
                                        out.push('.');
                                        #[allow(clippy::needless_borrow)]
                                        out.push_str(&url.authority());
                                        #[allow(clippy::needless_borrow)]
                                        out.push_str(&url.path());
                                        out
                                    })
                                    .property("backend", "S3Express".to_string())
                                    .property(
                                        "authSchemes",
                                        vec![::aws_smithy_types::Document::from({
                                            let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                            out.insert("disableDoubleEncoding".to_string(), true.into());
                                            out.insert("name".to_string(), "sigv4-s3express".to_string().into());
                                            out.insert("signingName".to_string(), "s3express".to_string().into());
                                            out.insert("signingRegion".to_string(), region.to_owned().into());
                                            out
                                        })],
                                    )
                                    .build());
                            }
                            return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message(
                                "S3Express bucket name is not a valid virtual hostable name.".to_string(),
                            ));
                        }
                    }
                    if crate::endpoint_lib::s3::is_virtual_hostable_s3_bucket(bucket.as_ref() as &str, false, _diagnostic_collector) {
                        #[allow(unused_variables)]
                        if let Some(partition_result) = partition_resolver.resolve_partition(region.as_ref() as &str, _diagnostic_collector) {
                            #[allow(unused_variables)]
                            if let Some(disable_s3_express_session_auth) = disable_s3_express_session_auth {
                                if (*disable_s3_express_session_auth) == (true) {
                                    #[allow(unused_variables)]
                                    if let Some(s3express_availability_zone_id) =
                                        crate::endpoint_lib::substring::substring(bucket.as_ref() as &str, 7, 15, true, _diagnostic_collector)
                                    {
                                        #[allow(unused_variables)]
                                        if let Some(s3express_availability_zone_delim) =
                                            crate::endpoint_lib::substring::substring(bucket.as_ref() as &str, 15, 17, true, _diagnostic_collector)
                                        {
                                            if (s3express_availability_zone_delim.as_ref() as &str) == ("--") {
                                                if (*use_fips) == (true) {
                                                    return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                                        .url({
                                                            let mut out = String::new();
                                                            out.push_str("https://");
                                                            #[allow(clippy::needless_borrow)]
                                                            out.push_str(&bucket.as_ref() as &str);
                                                            out.push_str(".s3express-fips-");
                                                            #[allow(clippy::needless_borrow)]
                                                            out.push_str(&s3express_availability_zone_id.as_ref() as &str);
                                                            out.push('.');
                                                            #[allow(clippy::needless_borrow)]
                                                            out.push_str(&region.as_ref() as &str);
                                                            out.push('.');
                                                            #[allow(clippy::needless_borrow)]
                                                            out.push_str(&partition_result.dns_suffix());
                                                            out
                                                        })
                                                        .property("backend", "S3Express".to_string())
                                                        .property(
                                                            "authSchemes",
                                                            vec![::aws_smithy_types::Document::from({
                                                                let mut out =
                                                                    ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                                out.insert("disableDoubleEncoding".to_string(), true.into());
                                                                out.insert("name".to_string(), "sigv4".to_string().into());
                                                                out.insert("signingName".to_string(), "s3express".to_string().into());
                                                                out.insert("signingRegion".to_string(), region.to_owned().into());
                                                                out
                                                            })],
                                                        )
                                                        .build());
                                                }
                                                return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                                    .url({
                                                        let mut out = String::new();
                                                        out.push_str("https://");
                                                        #[allow(clippy::needless_borrow)]
                                                        out.push_str(&bucket.as_ref() as &str);
                                                        out.push_str(".s3express-");
                                                        #[allow(clippy::needless_borrow)]
                                                        out.push_str(&s3express_availability_zone_id.as_ref() as &str);
                                                        out.push('.');
                                                        #[allow(clippy::needless_borrow)]
                                                        out.push_str(&region.as_ref() as &str);
                                                        out.push('.');
                                                        #[allow(clippy::needless_borrow)]
                                                        out.push_str(&partition_result.dns_suffix());
                                                        out
                                                    })
                                                    .property("backend", "S3Express".to_string())
                                                    .property(
                                                        "authSchemes",
                                                        vec![::aws_smithy_types::Document::from({
                                                            let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                            out.insert("disableDoubleEncoding".to_string(), true.into());
                                                            out.insert("name".to_string(), "sigv4".to_string().into());
                                                            out.insert("signingName".to_string(), "s3express".to_string().into());
                                                            out.insert("signingRegion".to_string(), region.to_owned().into());
                                                            out
                                                        })],
                                                    )
                                                    .build());
                                            }
                                        }
                                    }
                                    #[allow(unused_variables)]
                                    if let Some(s3express_availability_zone_id) =
                                        crate::endpoint_lib::substring::substring(bucket.as_ref() as &str, 7, 16, true, _diagnostic_collector)
                                    {
                                        #[allow(unused_variables)]
                                        if let Some(s3express_availability_zone_delim) =
                                            crate::endpoint_lib::substring::substring(bucket.as_ref() as &str, 16, 18, true, _diagnostic_collector)
                                        {
                                            if (s3express_availability_zone_delim.as_ref() as &str) == ("--") {
                                                if (*use_fips) == (true) {
                                                    return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                                        .url({
                                                            let mut out = String::new();
                                                            out.push_str("https://");
                                                            #[allow(clippy::needless_borrow)]
                                                            out.push_str(&bucket.as_ref() as &str);
                                                            out.push_str(".s3express-fips-");
                                                            #[allow(clippy::needless_borrow)]
                                                            out.push_str(&s3express_availability_zone_id.as_ref() as &str);
                                                            out.push('.');
                                                            #[allow(clippy::needless_borrow)]
                                                            out.push_str(&region.as_ref() as &str);
                                                            out.push('.');
                                                            #[allow(clippy::needless_borrow)]
                                                            out.push_str(&partition_result.dns_suffix());
                                                            out
                                                        })
                                                        .property("backend", "S3Express".to_string())
                                                        .property(
                                                            "authSchemes",
                                                            vec![::aws_smithy_types::Document::from({
                                                                let mut out =
                                                                    ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                                out.insert("disableDoubleEncoding".to_string(), true.into());
                                                                out.insert("name".to_string(), "sigv4".to_string().into());
                                                                out.insert("signingName".to_string(), "s3express".to_string().into());
                                                                out.insert("signingRegion".to_string(), region.to_owned().into());
                                                                out
                                                            })],
                                                        )
                                                        .build());
                                                }
                                                return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                                    .url({
                                                        let mut out = String::new();
                                                        out.push_str("https://");
                                                        #[allow(clippy::needless_borrow)]
                                                        out.push_str(&bucket.as_ref() as &str);
                                                        out.push_str(".s3express-");
                                                        #[allow(clippy::needless_borrow)]
                                                        out.push_str(&s3express_availability_zone_id.as_ref() as &str);
                                                        out.push('.');
                                                        #[allow(clippy::needless_borrow)]
                                                        out.push_str(&region.as_ref() as &str);
                                                        out.push('.');
                                                        #[allow(clippy::needless_borrow)]
                                                        out.push_str(&partition_result.dns_suffix());
                                                        out
                                                    })
                                                    .property("backend", "S3Express".to_string())
                                                    .property(
                                                        "authSchemes",
                                                        vec![::aws_smithy_types::Document::from({
                                                            let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                            out.insert("disableDoubleEncoding".to_string(), true.into());
                                                            out.insert("name".to_string(), "sigv4".to_string().into());
                                                            out.insert("signingName".to_string(), "s3express".to_string().into());
                                                            out.insert("signingRegion".to_string(), region.to_owned().into());
                                                            out
                                                        })],
                                                    )
                                                    .build());
                                            }
                                        }
                                    }
                                    #[allow(unused_variables)]
                                    if let Some(s3express_availability_zone_id) =
                                        crate::endpoint_lib::substring::substring(bucket.as_ref() as &str, 7, 20, true, _diagnostic_collector)
                                    {
                                        #[allow(unused_variables)]
                                        if let Some(s3express_availability_zone_delim) =
                                            crate::endpoint_lib::substring::substring(bucket.as_ref() as &str, 20, 22, true, _diagnostic_collector)
                                        {
                                            if (s3express_availability_zone_delim.as_ref() as &str) == ("--") {
                                                if (*use_fips) == (true) {
                                                    return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                                        .url({
                                                            let mut out = String::new();
                                                            out.push_str("https://");
                                                            #[allow(clippy::needless_borrow)]
                                                            out.push_str(&bucket.as_ref() as &str);
                                                            out.push_str(".s3express-fips-");
                                                            #[allow(clippy::needless_borrow)]
                                                            out.push_str(&s3express_availability_zone_id.as_ref() as &str);
                                                            out.push('.');
                                                            #[allow(clippy::needless_borrow)]
                                                            out.push_str(&region.as_ref() as &str);
                                                            out.push('.');
                                                            #[allow(clippy::needless_borrow)]
                                                            out.push_str(&partition_result.dns_suffix());
                                                            out
                                                        })
                                                        .property("backend", "S3Express".to_string())
                                                        .property(
                                                            "authSchemes",
                                                            vec![::aws_smithy_types::Document::from({
                                                                let mut out =
                                                                    ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                                out.insert("disableDoubleEncoding".to_string(), true.into());
                                                                out.insert("name".to_string(), "sigv4".to_string().into());
                                                                out.insert("signingName".to_string(), "s3express".to_string().into());
                                                                out.insert("signingRegion".to_string(), region.to_owned().into());
                                                                out
                                                            })],
                                                        )
                                                        .build());
                                                }
                                                return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                                    .url({
                                                        let mut out = String::new();
                                                        out.push_str("https://");
                                                        #[allow(clippy::needless_borrow)]
                                                        out.push_str(&bucket.as_ref() as &str);
                                                        out.push_str(".s3express-");
                                                        #[allow(clippy::needless_borrow)]
                                                        out.push_str(&s3express_availability_zone_id.as_ref() as &str);
                                                        out.push('.');
                                                        #[allow(clippy::needless_borrow)]
                                                        out.push_str(&region.as_ref() as &str);
                                                        out.push('.');
                                                        #[allow(clippy::needless_borrow)]
                                                        out.push_str(&partition_result.dns_suffix());
                                                        out
                                                    })
                                                    .property("backend", "S3Express".to_string())
                                                    .property(
                                                        "authSchemes",
                                                        vec![::aws_smithy_types::Document::from({
                                                            let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                            out.insert("disableDoubleEncoding".to_string(), true.into());
                                                            out.insert("name".to_string(), "sigv4".to_string().into());
                                                            out.insert("signingName".to_string(), "s3express".to_string().into());
                                                            out.insert("signingRegion".to_string(), region.to_owned().into());
                                                            out
                                                        })],
                                                    )
                                                    .build());
                                            }
                                        }
                                    }
                                    #[allow(unused_variables)]
                                    if let Some(s3express_availability_zone_id) =
                                        crate::endpoint_lib::substring::substring(bucket.as_ref() as &str, 7, 21, true, _diagnostic_collector)
                                    {
                                        #[allow(unused_variables)]
                                        if let Some(s3express_availability_zone_delim) =
                                            crate::endpoint_lib::substring::substring(bucket.as_ref() as &str, 21, 23, true, _diagnostic_collector)
                                        {
                                            if (s3express_availability_zone_delim.as_ref() as &str) == ("--") {
                                                if (*use_fips) == (true) {
                                                    return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                                        .url({
                                                            let mut out = String::new();
                                                            out.push_str("https://");
                                                            #[allow(clippy::needless_borrow)]
                                                            out.push_str(&bucket.as_ref() as &str);
                                                            out.push_str(".s3express-fips-");
                                                            #[allow(clippy::needless_borrow)]
                                                            out.push_str(&s3express_availability_zone_id.as_ref() as &str);
                                                            out.push('.');
                                                            #[allow(clippy::needless_borrow)]
                                                            out.push_str(&region.as_ref() as &str);
                                                            out.push('.');
                                                            #[allow(clippy::needless_borrow)]
                                                            out.push_str(&partition_result.dns_suffix());
                                                            out
                                                        })
                                                        .property("backend", "S3Express".to_string())
                                                        .property(
                                                            "authSchemes",
                                                            vec![::aws_smithy_types::Document::from({
                                                                let mut out =
                                                                    ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                                out.insert("disableDoubleEncoding".to_string(), true.into());
                                                                out.insert("name".to_string(), "sigv4".to_string().into());
                                                                out.insert("signingName".to_string(), "s3express".to_string().into());
                                                                out.insert("signingRegion".to_string(), region.to_owned().into());
                                                                out
                                                            })],
                                                        )
                                                        .build());
                                                }
                                                return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                                    .url({
                                                        let mut out = String::new();
                                                        out.push_str("https://");
                                                        #[allow(clippy::needless_borrow)]
                                                        out.push_str(&bucket.as_ref() as &str);
                                                        out.push_str(".s3express-");
                                                        #[allow(clippy::needless_borrow)]
                                                        out.push_str(&s3express_availability_zone_id.as_ref() as &str);
                                                        out.push('.');
                                                        #[allow(clippy::needless_borrow)]
                                                        out.push_str(&region.as_ref() as &str);
                                                        out.push('.');
                                                        #[allow(clippy::needless_borrow)]
                                                        out.push_str(&partition_result.dns_suffix());
                                                        out
                                                    })
                                                    .property("backend", "S3Express".to_string())
                                                    .property(
                                                        "authSchemes",
                                                        vec![::aws_smithy_types::Document::from({
                                                            let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                            out.insert("disableDoubleEncoding".to_string(), true.into());
                                                            out.insert("name".to_string(), "sigv4".to_string().into());
                                                            out.insert("signingName".to_string(), "s3express".to_string().into());
                                                            out.insert("signingRegion".to_string(), region.to_owned().into());
                                                            out
                                                        })],
                                                    )
                                                    .build());
                                            }
                                        }
                                    }
                                    #[allow(unused_variables)]
                                    if let Some(s3express_availability_zone_id) =
                                        crate::endpoint_lib::substring::substring(bucket.as_ref() as &str, 7, 27, true, _diagnostic_collector)
                                    {
                                        #[allow(unused_variables)]
                                        if let Some(s3express_availability_zone_delim) =
                                            crate::endpoint_lib::substring::substring(bucket.as_ref() as &str, 27, 29, true, _diagnostic_collector)
                                        {
                                            if (s3express_availability_zone_delim.as_ref() as &str) == ("--") {
                                                if (*use_fips) == (true) {
                                                    return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                                        .url({
                                                            let mut out = String::new();
                                                            out.push_str("https://");
                                                            #[allow(clippy::needless_borrow)]
                                                            out.push_str(&bucket.as_ref() as &str);
                                                            out.push_str(".s3express-fips-");
                                                            #[allow(clippy::needless_borrow)]
                                                            out.push_str(&s3express_availability_zone_id.as_ref() as &str);
                                                            out.push('.');
                                                            #[allow(clippy::needless_borrow)]
                                                            out.push_str(&region.as_ref() as &str);
                                                            out.push('.');
                                                            #[allow(clippy::needless_borrow)]
                                                            out.push_str(&partition_result.dns_suffix());
                                                            out
                                                        })
                                                        .property("backend", "S3Express".to_string())
                                                        .property(
                                                            "authSchemes",
                                                            vec![::aws_smithy_types::Document::from({
                                                                let mut out =
                                                                    ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                                out.insert("disableDoubleEncoding".to_string(), true.into());
                                                                out.insert("name".to_string(), "sigv4".to_string().into());
                                                                out.insert("signingName".to_string(), "s3express".to_string().into());
                                                                out.insert("signingRegion".to_string(), region.to_owned().into());
                                                                out
                                                            })],
                                                        )
                                                        .build());
                                                }
                                                return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                                    .url({
                                                        let mut out = String::new();
                                                        out.push_str("https://");
                                                        #[allow(clippy::needless_borrow)]
                                                        out.push_str(&bucket.as_ref() as &str);
                                                        out.push_str(".s3express-");
                                                        #[allow(clippy::needless_borrow)]
                                                        out.push_str(&s3express_availability_zone_id.as_ref() as &str);
                                                        out.push('.');
                                                        #[allow(clippy::needless_borrow)]
                                                        out.push_str(&region.as_ref() as &str);
                                                        out.push('.');
                                                        #[allow(clippy::needless_borrow)]
                                                        out.push_str(&partition_result.dns_suffix());
                                                        out
                                                    })
                                                    .property("backend", "S3Express".to_string())
                                                    .property(
                                                        "authSchemes",
                                                        vec![::aws_smithy_types::Document::from({
                                                            let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                            out.insert("disableDoubleEncoding".to_string(), true.into());
                                                            out.insert("name".to_string(), "sigv4".to_string().into());
                                                            out.insert("signingName".to_string(), "s3express".to_string().into());
                                                            out.insert("signingRegion".to_string(), region.to_owned().into());
                                                            out
                                                        })],
                                                    )
                                                    .build());
                                            }
                                        }
                                    }
                                    return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message(
                                        "Unrecognized S3Express bucket name format.".to_string(),
                                    ));
                                }
                            }
                            #[allow(unused_variables)]
                            if let Some(s3express_availability_zone_id) =
                                crate::endpoint_lib::substring::substring(bucket.as_ref() as &str, 7, 15, true, _diagnostic_collector)
                            {
                                #[allow(unused_variables)]
                                if let Some(s3express_availability_zone_delim) =
                                    crate::endpoint_lib::substring::substring(bucket.as_ref() as &str, 15, 17, true, _diagnostic_collector)
                                {
                                    if (s3express_availability_zone_delim.as_ref() as &str) == ("--") {
                                        if (*use_fips) == (true) {
                                            return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                                .url({
                                                    let mut out = String::new();
                                                    out.push_str("https://");
                                                    #[allow(clippy::needless_borrow)]
                                                    out.push_str(&bucket.as_ref() as &str);
                                                    out.push_str(".s3express-fips-");
                                                    #[allow(clippy::needless_borrow)]
                                                    out.push_str(&s3express_availability_zone_id.as_ref() as &str);
                                                    out.push('.');
                                                    #[allow(clippy::needless_borrow)]
                                                    out.push_str(&region.as_ref() as &str);
                                                    out.push('.');
                                                    #[allow(clippy::needless_borrow)]
                                                    out.push_str(&partition_result.dns_suffix());
                                                    out
                                                })
                                                .property("backend", "S3Express".to_string())
                                                .property(
                                                    "authSchemes",
                                                    vec![::aws_smithy_types::Document::from({
                                                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                        out.insert("disableDoubleEncoding".to_string(), true.into());
                                                        out.insert("name".to_string(), "sigv4-s3express".to_string().into());
                                                        out.insert("signingName".to_string(), "s3express".to_string().into());
                                                        out.insert("signingRegion".to_string(), region.to_owned().into());
                                                        out
                                                    })],
                                                )
                                                .build());
                                        }
                                        return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                            .url({
                                                let mut out = String::new();
                                                out.push_str("https://");
                                                #[allow(clippy::needless_borrow)]
                                                out.push_str(&bucket.as_ref() as &str);
                                                out.push_str(".s3express-");
                                                #[allow(clippy::needless_borrow)]
                                                out.push_str(&s3express_availability_zone_id.as_ref() as &str);
                                                out.push('.');
                                                #[allow(clippy::needless_borrow)]
                                                out.push_str(&region.as_ref() as &str);
                                                out.push('.');
                                                #[allow(clippy::needless_borrow)]
                                                out.push_str(&partition_result.dns_suffix());
                                                out
                                            })
                                            .property("backend", "S3Express".to_string())
                                            .property(
                                                "authSchemes",
                                                vec![::aws_smithy_types::Document::from({
                                                    let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                    out.insert("disableDoubleEncoding".to_string(), true.into());
                                                    out.insert("name".to_string(), "sigv4-s3express".to_string().into());
                                                    out.insert("signingName".to_string(), "s3express".to_string().into());
                                                    out.insert("signingRegion".to_string(), region.to_owned().into());
                                                    out
                                                })],
                                            )
                                            .build());
                                    }
                                }
                            }
                            #[allow(unused_variables)]
                            if let Some(s3express_availability_zone_id) =
                                crate::endpoint_lib::substring::substring(bucket.as_ref() as &str, 7, 16, true, _diagnostic_collector)
                            {
                                #[allow(unused_variables)]
                                if let Some(s3express_availability_zone_delim) =
                                    crate::endpoint_lib::substring::substring(bucket.as_ref() as &str, 16, 18, true, _diagnostic_collector)
                                {
                                    if (s3express_availability_zone_delim.as_ref() as &str) == ("--") {
                                        if (*use_fips) == (true) {
                                            return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                                .url({
                                                    let mut out = String::new();
                                                    out.push_str("https://");
                                                    #[allow(clippy::needless_borrow)]
                                                    out.push_str(&bucket.as_ref() as &str);
                                                    out.push_str(".s3express-fips-");
                                                    #[allow(clippy::needless_borrow)]
                                                    out.push_str(&s3express_availability_zone_id.as_ref() as &str);
                                                    out.push('.');
                                                    #[allow(clippy::needless_borrow)]
                                                    out.push_str(&region.as_ref() as &str);
                                                    out.push('.');
                                                    #[allow(clippy::needless_borrow)]
                                                    out.push_str(&partition_result.dns_suffix());
                                                    out
                                                })
                                                .property("backend", "S3Express".to_string())
                                                .property(
                                                    "authSchemes",
                                                    vec![::aws_smithy_types::Document::from({
                                                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                        out.insert("disableDoubleEncoding".to_string(), true.into());
                                                        out.insert("name".to_string(), "sigv4-s3express".to_string().into());
                                                        out.insert("signingName".to_string(), "s3express".to_string().into());
                                                        out.insert("signingRegion".to_string(), region.to_owned().into());
                                                        out
                                                    })],
                                                )
                                                .build());
                                        }
                                        return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                            .url({
                                                let mut out = String::new();
                                                out.push_str("https://");
                                                #[allow(clippy::needless_borrow)]
                                                out.push_str(&bucket.as_ref() as &str);
                                                out.push_str(".s3express-");
                                                #[allow(clippy::needless_borrow)]
                                                out.push_str(&s3express_availability_zone_id.as_ref() as &str);
                                                out.push('.');
                                                #[allow(clippy::needless_borrow)]
                                                out.push_str(&region.as_ref() as &str);
                                                out.push('.');
                                                #[allow(clippy::needless_borrow)]
                                                out.push_str(&partition_result.dns_suffix());
                                                out
                                            })
                                            .property("backend", "S3Express".to_string())
                                            .property(
                                                "authSchemes",
                                                vec![::aws_smithy_types::Document::from({
                                                    let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                    out.insert("disableDoubleEncoding".to_string(), true.into());
                                                    out.insert("name".to_string(), "sigv4-s3express".to_string().into());
                                                    out.insert("signingName".to_string(), "s3express".to_string().into());
                                                    out.insert("signingRegion".to_string(), region.to_owned().into());
                                                    out
                                                })],
                                            )
                                            .build());
                                    }
                                }
                            }
                            #[allow(unused_variables)]
                            if let Some(s3express_availability_zone_id) =
                                crate::endpoint_lib::substring::substring(bucket.as_ref() as &str, 7, 20, true, _diagnostic_collector)
                            {
                                #[allow(unused_variables)]
                                if let Some(s3express_availability_zone_delim) =
                                    crate::endpoint_lib::substring::substring(bucket.as_ref() as &str, 20, 22, true, _diagnostic_collector)
                                {
                                    if (s3express_availability_zone_delim.as_ref() as &str) == ("--") {
                                        if (*use_fips) == (true) {
                                            return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                                .url({
                                                    let mut out = String::new();
                                                    out.push_str("https://");
                                                    #[allow(clippy::needless_borrow)]
                                                    out.push_str(&bucket.as_ref() as &str);
                                                    out.push_str(".s3express-fips-");
                                                    #[allow(clippy::needless_borrow)]
                                                    out.push_str(&s3express_availability_zone_id.as_ref() as &str);
                                                    out.push('.');
                                                    #[allow(clippy::needless_borrow)]
                                                    out.push_str(&region.as_ref() as &str);
                                                    out.push('.');
                                                    #[allow(clippy::needless_borrow)]
                                                    out.push_str(&partition_result.dns_suffix());
                                                    out
                                                })
                                                .property("backend", "S3Express".to_string())
                                                .property(
                                                    "authSchemes",
                                                    vec![::aws_smithy_types::Document::from({
                                                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                        out.insert("disableDoubleEncoding".to_string(), true.into());
                                                        out.insert("name".to_string(), "sigv4-s3express".to_string().into());
                                                        out.insert("signingName".to_string(), "s3express".to_string().into());
                                                        out.insert("signingRegion".to_string(), region.to_owned().into());
                                                        out
                                                    })],
                                                )
                                                .build());
                                        }
                                        return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                            .url({
                                                let mut out = String::new();
                                                out.push_str("https://");
                                                #[allow(clippy::needless_borrow)]
                                                out.push_str(&bucket.as_ref() as &str);
                                                out.push_str(".s3express-");
                                                #[allow(clippy::needless_borrow)]
                                                out.push_str(&s3express_availability_zone_id.as_ref() as &str);
                                                out.push('.');
                                                #[allow(clippy::needless_borrow)]
                                                out.push_str(&region.as_ref() as &str);
                                                out.push('.');
                                                #[allow(clippy::needless_borrow)]
                                                out.push_str(&partition_result.dns_suffix());
                                                out
                                            })
                                            .property("backend", "S3Express".to_string())
                                            .property(
                                                "authSchemes",
                                                vec![::aws_smithy_types::Document::from({
                                                    let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                    out.insert("disableDoubleEncoding".to_string(), true.into());
                                                    out.insert("name".to_string(), "sigv4-s3express".to_string().into());
                                                    out.insert("signingName".to_string(), "s3express".to_string().into());
                                                    out.insert("signingRegion".to_string(), region.to_owned().into());
                                                    out
                                                })],
                                            )
                                            .build());
                                    }
                                }
                            }
                            #[allow(unused_variables)]
                            if let Some(s3express_availability_zone_id) =
                                crate::endpoint_lib::substring::substring(bucket.as_ref() as &str, 7, 21, true, _diagnostic_collector)
                            {
                                #[allow(unused_variables)]
                                if let Some(s3express_availability_zone_delim) =
                                    crate::endpoint_lib::substring::substring(bucket.as_ref() as &str, 21, 23, true, _diagnostic_collector)
                                {
                                    if (s3express_availability_zone_delim.as_ref() as &str) == ("--") {
                                        if (*use_fips) == (true) {
                                            return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                                .url({
                                                    let mut out = String::new();
                                                    out.push_str("https://");
                                                    #[allow(clippy::needless_borrow)]
                                                    out.push_str(&bucket.as_ref() as &str);
                                                    out.push_str(".s3express-fips-");
                                                    #[allow(clippy::needless_borrow)]
                                                    out.push_str(&s3express_availability_zone_id.as_ref() as &str);
                                                    out.push('.');
                                                    #[allow(clippy::needless_borrow)]
                                                    out.push_str(&region.as_ref() as &str);
                                                    out.push('.');
                                                    #[allow(clippy::needless_borrow)]
                                                    out.push_str(&partition_result.dns_suffix());
                                                    out
                                                })
                                                .property("backend", "S3Express".to_string())
                                                .property(
                                                    "authSchemes",
                                                    vec![::aws_smithy_types::Document::from({
                                                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                        out.insert("disableDoubleEncoding".to_string(), true.into());
                                                        out.insert("name".to_string(), "sigv4-s3express".to_string().into());
                                                        out.insert("signingName".to_string(), "s3express".to_string().into());
                                                        out.insert("signingRegion".to_string(), region.to_owned().into());
                                                        out
                                                    })],
                                                )
                                                .build());
                                        }
                                        return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                            .url({
                                                let mut out = String::new();
                                                out.push_str("https://");
                                                #[allow(clippy::needless_borrow)]
                                                out.push_str(&bucket.as_ref() as &str);
                                                out.push_str(".s3express-");
                                                #[allow(clippy::needless_borrow)]
                                                out.push_str(&s3express_availability_zone_id.as_ref() as &str);
                                                out.push('.');
                                                #[allow(clippy::needless_borrow)]
                                                out.push_str(&region.as_ref() as &str);
                                                out.push('.');
                                                #[allow(clippy::needless_borrow)]
                                                out.push_str(&partition_result.dns_suffix());
                                                out
                                            })
                                            .property("backend", "S3Express".to_string())
                                            .property(
                                                "authSchemes",
                                                vec![::aws_smithy_types::Document::from({
                                                    let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                    out.insert("disableDoubleEncoding".to_string(), true.into());
                                                    out.insert("name".to_string(), "sigv4-s3express".to_string().into());
                                                    out.insert("signingName".to_string(), "s3express".to_string().into());
                                                    out.insert("signingRegion".to_string(), region.to_owned().into());
                                                    out
                                                })],
                                            )
                                            .build());
                                    }
                                }
                            }
                            #[allow(unused_variables)]
                            if let Some(s3express_availability_zone_id) =
                                crate::endpoint_lib::substring::substring(bucket.as_ref() as &str, 7, 27, true, _diagnostic_collector)
                            {
                                #[allow(unused_variables)]
                                if let Some(s3express_availability_zone_delim) =
                                    crate::endpoint_lib::substring::substring(bucket.as_ref() as &str, 27, 29, true, _diagnostic_collector)
                                {
                                    if (s3express_availability_zone_delim.as_ref() as &str) == ("--") {
                                        if (*use_fips) == (true) {
                                            return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                                .url({
                                                    let mut out = String::new();
                                                    out.push_str("https://");
                                                    #[allow(clippy::needless_borrow)]
                                                    out.push_str(&bucket.as_ref() as &str);
                                                    out.push_str(".s3express-fips-");
                                                    #[allow(clippy::needless_borrow)]
                                                    out.push_str(&s3express_availability_zone_id.as_ref() as &str);
                                                    out.push('.');
                                                    #[allow(clippy::needless_borrow)]
                                                    out.push_str(&region.as_ref() as &str);
                                                    out.push('.');
                                                    #[allow(clippy::needless_borrow)]
                                                    out.push_str(&partition_result.dns_suffix());
                                                    out
                                                })
                                                .property("backend", "S3Express".to_string())
                                                .property(
                                                    "authSchemes",
                                                    vec![::aws_smithy_types::Document::from({
                                                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                        out.insert("disableDoubleEncoding".to_string(), true.into());
                                                        out.insert("name".to_string(), "sigv4-s3express".to_string().into());
                                                        out.insert("signingName".to_string(), "s3express".to_string().into());
                                                        out.insert("signingRegion".to_string(), region.to_owned().into());
                                                        out
                                                    })],
                                                )
                                                .build());
                                        }
                                        return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                            .url({
                                                let mut out = String::new();
                                                out.push_str("https://");
                                                #[allow(clippy::needless_borrow)]
                                                out.push_str(&bucket.as_ref() as &str);
                                                out.push_str(".s3express-");
                                                #[allow(clippy::needless_borrow)]
                                                out.push_str(&s3express_availability_zone_id.as_ref() as &str);
                                                out.push('.');
                                                #[allow(clippy::needless_borrow)]
                                                out.push_str(&region.as_ref() as &str);
                                                out.push('.');
                                                #[allow(clippy::needless_borrow)]
                                                out.push_str(&partition_result.dns_suffix());
                                                out
                                            })
                                            .property("backend", "S3Express".to_string())
                                            .property(
                                                "authSchemes",
                                                vec![::aws_smithy_types::Document::from({
                                                    let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                    out.insert("disableDoubleEncoding".to_string(), true.into());
                                                    out.insert("name".to_string(), "sigv4-s3express".to_string().into());
                                                    out.insert("signingName".to_string(), "s3express".to_string().into());
                                                    out.insert("signingRegion".to_string(), region.to_owned().into());
                                                    out
                                                })],
                                            )
                                            .build());
                                    }
                                }
                            }
                            return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message(
                                "Unrecognized S3Express bucket name format.".to_string(),
                            ));
                        }
                        #[allow(unreachable_code)]
                        return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message(format!(
                            "No rules matched these parameters. This is a bug. {:?}",
                            _params
                        )));
                    }
                    return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message(
                        "S3Express bucket name is not a valid virtual hostable name.".to_string(),
                    ));
                }
            }
        }
        if !(bucket.is_some()) {
            #[allow(unused_variables)]
            if let Some(use_s3_express_control_endpoint) = use_s3_express_control_endpoint {
                if (*use_s3_express_control_endpoint) == (true) {
                    #[allow(unused_variables)]
                    if let Some(partition_result) = partition_resolver.resolve_partition(region.as_ref() as &str, _diagnostic_collector) {
                        #[allow(unused_variables)]
                        if let Some(endpoint) = endpoint {
                            #[allow(unused_variables)]
                            if let Some(url) = crate::endpoint_lib::parse_url::parse_url(endpoint.as_ref() as &str, _diagnostic_collector) {
                                return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                    .url({
                                        let mut out = String::new();
                                        #[allow(clippy::needless_borrow)]
                                        out.push_str(&url.scheme());
                                        out.push_str("://");
                                        #[allow(clippy::needless_borrow)]
                                        out.push_str(&url.authority());
                                        #[allow(clippy::needless_borrow)]
                                        out.push_str(&url.path());
                                        out
                                    })
                                    .property("backend", "S3Express".to_string())
                                    .property(
                                        "authSchemes",
                                        vec![::aws_smithy_types::Document::from({
                                            let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                            out.insert("disableDoubleEncoding".to_string(), true.into());
                                            out.insert("name".to_string(), "sigv4".to_string().into());
                                            out.insert("signingName".to_string(), "s3express".to_string().into());
                                            out.insert("signingRegion".to_string(), region.to_owned().into());
                                            out
                                        })],
                                    )
                                    .build());
                            }
                        }
                        if (*use_fips) == (true) {
                            return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                .url({
                                    let mut out = String::new();
                                    out.push_str("https://s3express-control-fips.");
                                    #[allow(clippy::needless_borrow)]
                                    out.push_str(&region.as_ref() as &str);
                                    out.push('.');
                                    #[allow(clippy::needless_borrow)]
                                    out.push_str(&partition_result.dns_suffix());
                                    out
                                })
                                .property("backend", "S3Express".to_string())
                                .property(
                                    "authSchemes",
                                    vec![::aws_smithy_types::Document::from({
                                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                        out.insert("disableDoubleEncoding".to_string(), true.into());
                                        out.insert("name".to_string(), "sigv4".to_string().into());
                                        out.insert("signingName".to_string(), "s3express".to_string().into());
                                        out.insert("signingRegion".to_string(), region.to_owned().into());
                                        out
                                    })],
                                )
                                .build());
                        }
                        return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                            .url({
                                let mut out = String::new();
                                out.push_str("https://s3express-control.");
                                #[allow(clippy::needless_borrow)]
                                out.push_str(&region.as_ref() as &str);
                                out.push('.');
                                #[allow(clippy::needless_borrow)]
                                out.push_str(&partition_result.dns_suffix());
                                out
                            })
                            .property("backend", "S3Express".to_string())
                            .property(
                                "authSchemes",
                                vec![::aws_smithy_types::Document::from({
                                    let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                    out.insert("disableDoubleEncoding".to_string(), true.into());
                                    out.insert("name".to_string(), "sigv4".to_string().into());
                                    out.insert("signingName".to_string(), "s3express".to_string().into());
                                    out.insert("signingRegion".to_string(), region.to_owned().into());
                                    out
                                })],
                            )
                            .build());
                    }
                    #[allow(unreachable_code)]
                    return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message(format!(
                        "No rules matched these parameters. This is a bug. {:?}",
                        _params
                    )));
                }
            }
        }
        #[allow(unused_variables)]
        if let Some(bucket) = bucket {
            #[allow(unused_variables)]
            if let Some(hardware_type) = crate::endpoint_lib::substring::substring(bucket.as_ref() as &str, 49, 50, true, _diagnostic_collector) {
                #[allow(unused_variables)]
                if let Some(region_prefix) = crate::endpoint_lib::substring::substring(bucket.as_ref() as &str, 8, 12, true, _diagnostic_collector) {
                    #[allow(unused_variables)]
                    if let Some(bucket_alias_suffix) =
                        crate::endpoint_lib::substring::substring(bucket.as_ref() as &str, 0, 7, true, _diagnostic_collector)
                    {
                        #[allow(unused_variables)]
                        if let Some(outpost_id) =
                            crate::endpoint_lib::substring::substring(bucket.as_ref() as &str, 32, 49, true, _diagnostic_collector)
                        {
                            #[allow(unused_variables)]
                            if let Some(region_partition) = partition_resolver.resolve_partition(region.as_ref() as &str, _diagnostic_collector) {
                                if (bucket_alias_suffix.as_ref() as &str) == ("--op-s3") {
                                    if crate::endpoint_lib::host::is_valid_host_label(outpost_id.as_ref() as &str, false, _diagnostic_collector) {
                                        if (hardware_type.as_ref() as &str) == ("e") {
                                            if (region_prefix.as_ref() as &str) == ("beta") {
                                                if !(endpoint.is_some()) {
                                                    return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message(
                                                        "Expected a endpoint to be specified but no endpoint was found".to_string(),
                                                    ));
                                                }
                                                #[allow(unused_variables)]
                                                if let Some(endpoint) = endpoint {
                                                    #[allow(unused_variables)]
                                                    if let Some(url) =
                                                        crate::endpoint_lib::parse_url::parse_url(endpoint.as_ref() as &str, _diagnostic_collector)
                                                    {
                                                        return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                                            .url({
                                                                let mut out = String::new();
                                                                out.push_str("https://");
                                                                #[allow(clippy::needless_borrow)]
                                                                out.push_str(&bucket.as_ref() as &str);
                                                                out.push_str(".ec2.");
                                                                #[allow(clippy::needless_borrow)]
                                                                out.push_str(&url.authority());
                                                                out
                                                            })
                                                            .property(
                                                                "authSchemes",
                                                                vec![
                                                                    ::aws_smithy_types::Document::from({
                                                                        let mut out =
                                                                            ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new(
                                                                            );
                                                                        out.insert("disableDoubleEncoding".to_string(), true.into());
                                                                        out.insert("name".to_string(), "sigv4a".to_string().into());
                                                                        out.insert("signingName".to_string(), "s3-outposts".to_string().into());
                                                                        out.insert(
                                                                            "signingRegionSet".to_string(),
                                                                            vec![::aws_smithy_types::Document::from("*".to_string())].into(),
                                                                        );
                                                                        out
                                                                    }),
                                                                    ::aws_smithy_types::Document::from({
                                                                        let mut out =
                                                                            ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new(
                                                                            );
                                                                        out.insert("disableDoubleEncoding".to_string(), true.into());
                                                                        out.insert("name".to_string(), "sigv4".to_string().into());
                                                                        out.insert("signingName".to_string(), "s3-outposts".to_string().into());
                                                                        out.insert("signingRegion".to_string(), region.to_owned().into());
                                                                        out
                                                                    }),
                                                                ],
                                                            )
                                                            .build());
                                                    }
                                                }
                                                #[allow(unreachable_code)]
                                                return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message(format!(
                                                    "No rules matched these parameters. This is a bug. {:?}",
                                                    _params
                                                )));
                                            }
                                            return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                                .url({
                                                    let mut out = String::new();
                                                    out.push_str("https://");
                                                    #[allow(clippy::needless_borrow)]
                                                    out.push_str(&bucket.as_ref() as &str);
                                                    out.push_str(".ec2.s3-outposts.");
                                                    #[allow(clippy::needless_borrow)]
                                                    out.push_str(&region.as_ref() as &str);
                                                    out.push('.');
                                                    #[allow(clippy::needless_borrow)]
                                                    out.push_str(&region_partition.dns_suffix());
                                                    out
                                                })
                                                .property(
                                                    "authSchemes",
                                                    vec![
                                                        ::aws_smithy_types::Document::from({
                                                            let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                            out.insert("disableDoubleEncoding".to_string(), true.into());
                                                            out.insert("name".to_string(), "sigv4a".to_string().into());
                                                            out.insert("signingName".to_string(), "s3-outposts".to_string().into());
                                                            out.insert(
                                                                "signingRegionSet".to_string(),
                                                                vec![::aws_smithy_types::Document::from("*".to_string())].into(),
                                                            );
                                                            out
                                                        }),
                                                        ::aws_smithy_types::Document::from({
                                                            let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                            out.insert("disableDoubleEncoding".to_string(), true.into());
                                                            out.insert("name".to_string(), "sigv4".to_string().into());
                                                            out.insert("signingName".to_string(), "s3-outposts".to_string().into());
                                                            out.insert("signingRegion".to_string(), region.to_owned().into());
                                                            out
                                                        }),
                                                    ],
                                                )
                                                .build());
                                        }
                                        if (hardware_type.as_ref() as &str) == ("o") {
                                            if (region_prefix.as_ref() as &str) == ("beta") {
                                                if !(endpoint.is_some()) {
                                                    return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message(
                                                        "Expected a endpoint to be specified but no endpoint was found".to_string(),
                                                    ));
                                                }
                                                #[allow(unused_variables)]
                                                if let Some(endpoint) = endpoint {
                                                    #[allow(unused_variables)]
                                                    if let Some(url) =
                                                        crate::endpoint_lib::parse_url::parse_url(endpoint.as_ref() as &str, _diagnostic_collector)
                                                    {
                                                        return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                                            .url({
                                                                let mut out = String::new();
                                                                out.push_str("https://");
                                                                #[allow(clippy::needless_borrow)]
                                                                out.push_str(&bucket.as_ref() as &str);
                                                                out.push_str(".op-");
                                                                #[allow(clippy::needless_borrow)]
                                                                out.push_str(&outpost_id.as_ref() as &str);
                                                                out.push('.');
                                                                #[allow(clippy::needless_borrow)]
                                                                out.push_str(&url.authority());
                                                                out
                                                            })
                                                            .property(
                                                                "authSchemes",
                                                                vec![
                                                                    ::aws_smithy_types::Document::from({
                                                                        let mut out =
                                                                            ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new(
                                                                            );
                                                                        out.insert("disableDoubleEncoding".to_string(), true.into());
                                                                        out.insert("name".to_string(), "sigv4a".to_string().into());
                                                                        out.insert("signingName".to_string(), "s3-outposts".to_string().into());
                                                                        out.insert(
                                                                            "signingRegionSet".to_string(),
                                                                            vec![::aws_smithy_types::Document::from("*".to_string())].into(),
                                                                        );
                                                                        out
                                                                    }),
                                                                    ::aws_smithy_types::Document::from({
                                                                        let mut out =
                                                                            ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new(
                                                                            );
                                                                        out.insert("disableDoubleEncoding".to_string(), true.into());
                                                                        out.insert("name".to_string(), "sigv4".to_string().into());
                                                                        out.insert("signingName".to_string(), "s3-outposts".to_string().into());
                                                                        out.insert("signingRegion".to_string(), region.to_owned().into());
                                                                        out
                                                                    }),
                                                                ],
                                                            )
                                                            .build());
                                                    }
                                                }
                                                #[allow(unreachable_code)]
                                                return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message(format!(
                                                    "No rules matched these parameters. This is a bug. {:?}",
                                                    _params
                                                )));
                                            }
                                            return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                                .url({
                                                    let mut out = String::new();
                                                    out.push_str("https://");
                                                    #[allow(clippy::needless_borrow)]
                                                    out.push_str(&bucket.as_ref() as &str);
                                                    out.push_str(".op-");
                                                    #[allow(clippy::needless_borrow)]
                                                    out.push_str(&outpost_id.as_ref() as &str);
                                                    out.push_str(".s3-outposts.");
                                                    #[allow(clippy::needless_borrow)]
                                                    out.push_str(&region.as_ref() as &str);
                                                    out.push('.');
                                                    #[allow(clippy::needless_borrow)]
                                                    out.push_str(&region_partition.dns_suffix());
                                                    out
                                                })
                                                .property(
                                                    "authSchemes",
                                                    vec![
                                                        ::aws_smithy_types::Document::from({
                                                            let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                            out.insert("disableDoubleEncoding".to_string(), true.into());
                                                            out.insert("name".to_string(), "sigv4a".to_string().into());
                                                            out.insert("signingName".to_string(), "s3-outposts".to_string().into());
                                                            out.insert(
                                                                "signingRegionSet".to_string(),
                                                                vec![::aws_smithy_types::Document::from("*".to_string())].into(),
                                                            );
                                                            out
                                                        }),
                                                        ::aws_smithy_types::Document::from({
                                                            let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                            out.insert("disableDoubleEncoding".to_string(), true.into());
                                                            out.insert("name".to_string(), "sigv4".to_string().into());
                                                            out.insert("signingName".to_string(), "s3-outposts".to_string().into());
                                                            out.insert("signingRegion".to_string(), region.to_owned().into());
                                                            out
                                                        }),
                                                    ],
                                                )
                                                .build());
                                        }
                                        return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message({
                                            let mut out = String::new();
                                            out.push_str("Unrecognized hardware type: \"Expected hardware type o or e but got ");
                                            #[allow(clippy::needless_borrow)]
                                            out.push_str(&hardware_type.as_ref() as &str);
                                            out.push('"');
                                            out
                                        }));
                                    }
                                    return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message(
                                        "Invalid ARN: The outpost Id must only contain a-z, A-Z, 0-9 and `-`.".to_string(),
                                    ));
                                }
                            }
                        }
                    }
                }
            }
        }
        #[allow(unused_variables)]
        if let Some(bucket) = bucket {
            #[allow(unused_variables)]
            if let Some(endpoint) = endpoint {
                if !(crate::endpoint_lib::parse_url::parse_url(endpoint.as_ref() as &str, _diagnostic_collector).is_some()) {
                    return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message({
                        let mut out = String::new();
                        out.push_str("Custom endpoint `");
                        #[allow(clippy::needless_borrow)]
                        out.push_str(&endpoint.as_ref() as &str);
                        out.push_str("` was not a valid URI");
                        out
                    }));
                }
            }
            if (*force_path_style) == (false) {
                if crate::endpoint_lib::s3::is_virtual_hostable_s3_bucket(bucket.as_ref() as &str, false, _diagnostic_collector) {
                    #[allow(unused_variables)]
                    if let Some(partition_result) = partition_resolver.resolve_partition(region.as_ref() as &str, _diagnostic_collector) {
                        if crate::endpoint_lib::host::is_valid_host_label(region.as_ref() as &str, false, _diagnostic_collector) {
                            if (*accelerate) == (true) {
                                if (partition_result.name()) == ("aws-cn") {
                                    return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message(
                                        "S3 Accelerate cannot be used in this region".to_string(),
                                    ));
                                }
                            }
                            if (*use_dual_stack) == (true) {
                                if (*use_fips) == (true) {
                                    if (*accelerate) == (false) {
                                        if !(endpoint.is_some()) {
                                            if (region.as_ref() as &str) == ("aws-global") {
                                                return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                                    .url({
                                                        let mut out = String::new();
                                                        out.push_str("https://");
                                                        #[allow(clippy::needless_borrow)]
                                                        out.push_str(&bucket.as_ref() as &str);
                                                        out.push_str(".s3-fips.dualstack.us-east-1.");
                                                        #[allow(clippy::needless_borrow)]
                                                        out.push_str(&partition_result.dns_suffix());
                                                        out
                                                    })
                                                    .property(
                                                        "authSchemes",
                                                        vec![::aws_smithy_types::Document::from({
                                                            let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                            out.insert("disableDoubleEncoding".to_string(), true.into());
                                                            out.insert("name".to_string(), "sigv4".to_string().into());
                                                            out.insert("signingName".to_string(), "s3".to_string().into());
                                                            out.insert("signingRegion".to_string(), "us-east-1".to_string().into());
                                                            out
                                                        })],
                                                    )
                                                    .build());
                                            }
                                        }
                                    }
                                }
                            }
                            if (*use_dual_stack) == (true) {
                                if (*use_fips) == (true) {
                                    if (*accelerate) == (false) {
                                        if !(endpoint.is_some()) {
                                            if !((region.as_ref() as &str) == ("aws-global")) {
                                                if (*use_global_endpoint) == (true) {
                                                    return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                                        .url({
                                                            let mut out = String::new();
                                                            out.push_str("https://");
                                                            #[allow(clippy::needless_borrow)]
                                                            out.push_str(&bucket.as_ref() as &str);
                                                            out.push_str(".s3-fips.dualstack.");
                                                            #[allow(clippy::needless_borrow)]
                                                            out.push_str(&region.as_ref() as &str);
                                                            out.push('.');
                                                            #[allow(clippy::needless_borrow)]
                                                            out.push_str(&partition_result.dns_suffix());
                                                            out
                                                        })
                                                        .property(
                                                            "authSchemes",
                                                            vec![::aws_smithy_types::Document::from({
                                                                let mut out =
                                                                    ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                                out.insert("disableDoubleEncoding".to_string(), true.into());
                                                                out.insert("name".to_string(), "sigv4".to_string().into());
                                                                out.insert("signingName".to_string(), "s3".to_string().into());
                                                                out.insert("signingRegion".to_string(), region.to_owned().into());
                                                                out
                                                            })],
                                                        )
                                                        .build());
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                            if (*use_dual_stack) == (true) {
                                if (*use_fips) == (true) {
                                    if (*accelerate) == (false) {
                                        if !(endpoint.is_some()) {
                                            if !((region.as_ref() as &str) == ("aws-global")) {
                                                if (*use_global_endpoint) == (false) {
                                                    return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                                        .url({
                                                            let mut out = String::new();
                                                            out.push_str("https://");
                                                            #[allow(clippy::needless_borrow)]
                                                            out.push_str(&bucket.as_ref() as &str);
                                                            out.push_str(".s3-fips.dualstack.");
                                                            #[allow(clippy::needless_borrow)]
                                                            out.push_str(&region.as_ref() as &str);
                                                            out.push('.');
                                                            #[allow(clippy::needless_borrow)]
                                                            out.push_str(&partition_result.dns_suffix());
                                                            out
                                                        })
                                                        .property(
                                                            "authSchemes",
                                                            vec![::aws_smithy_types::Document::from({
                                                                let mut out =
                                                                    ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                                out.insert("disableDoubleEncoding".to_string(), true.into());
                                                                out.insert("name".to_string(), "sigv4".to_string().into());
                                                                out.insert("signingName".to_string(), "s3".to_string().into());
                                                                out.insert("signingRegion".to_string(), region.to_owned().into());
                                                                out
                                                            })],
                                                        )
                                                        .build());
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                            if (*use_dual_stack) == (false) {
                                if (*use_fips) == (true) {
                                    if (*accelerate) == (false) {
                                        if !(endpoint.is_some()) {
                                            if (region.as_ref() as &str) == ("aws-global") {
                                                return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                                    .url({
                                                        let mut out = String::new();
                                                        out.push_str("https://");
                                                        #[allow(clippy::needless_borrow)]
                                                        out.push_str(&bucket.as_ref() as &str);
                                                        out.push_str(".s3-fips.us-east-1.");
                                                        #[allow(clippy::needless_borrow)]
                                                        out.push_str(&partition_result.dns_suffix());
                                                        out
                                                    })
                                                    .property(
                                                        "authSchemes",
                                                        vec![::aws_smithy_types::Document::from({
                                                            let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                            out.insert("disableDoubleEncoding".to_string(), true.into());
                                                            out.insert("name".to_string(), "sigv4".to_string().into());
                                                            out.insert("signingName".to_string(), "s3".to_string().into());
                                                            out.insert("signingRegion".to_string(), "us-east-1".to_string().into());
                                                            out
                                                        })],
                                                    )
                                                    .build());
                                            }
                                        }
                                    }
                                }
                            }
                            if (*use_dual_stack) == (false) {
                                if (*use_fips) == (true) {
                                    if (*accelerate) == (false) {
                                        if !(endpoint.is_some()) {
                                            if !((region.as_ref() as &str) == ("aws-global")) {
                                                if (*use_global_endpoint) == (true) {
                                                    return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                                        .url({
                                                            let mut out = String::new();
                                                            out.push_str("https://");
                                                            #[allow(clippy::needless_borrow)]
                                                            out.push_str(&bucket.as_ref() as &str);
                                                            out.push_str(".s3-fips.");
                                                            #[allow(clippy::needless_borrow)]
                                                            out.push_str(&region.as_ref() as &str);
                                                            out.push('.');
                                                            #[allow(clippy::needless_borrow)]
                                                            out.push_str(&partition_result.dns_suffix());
                                                            out
                                                        })
                                                        .property(
                                                            "authSchemes",
                                                            vec![::aws_smithy_types::Document::from({
                                                                let mut out =
                                                                    ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                                out.insert("disableDoubleEncoding".to_string(), true.into());
                                                                out.insert("name".to_string(), "sigv4".to_string().into());
                                                                out.insert("signingName".to_string(), "s3".to_string().into());
                                                                out.insert("signingRegion".to_string(), region.to_owned().into());
                                                                out
                                                            })],
                                                        )
                                                        .build());
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                            if (*use_dual_stack) == (false) {
                                if (*use_fips) == (true) {
                                    if (*accelerate) == (false) {
                                        if !(endpoint.is_some()) {
                                            if !((region.as_ref() as &str) == ("aws-global")) {
                                                if (*use_global_endpoint) == (false) {
                                                    return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                                        .url({
                                                            let mut out = String::new();
                                                            out.push_str("https://");
                                                            #[allow(clippy::needless_borrow)]
                                                            out.push_str(&bucket.as_ref() as &str);
                                                            out.push_str(".s3-fips.");
                                                            #[allow(clippy::needless_borrow)]
                                                            out.push_str(&region.as_ref() as &str);
                                                            out.push('.');
                                                            #[allow(clippy::needless_borrow)]
                                                            out.push_str(&partition_result.dns_suffix());
                                                            out
                                                        })
                                                        .property(
                                                            "authSchemes",
                                                            vec![::aws_smithy_types::Document::from({
                                                                let mut out =
                                                                    ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                                out.insert("disableDoubleEncoding".to_string(), true.into());
                                                                out.insert("name".to_string(), "sigv4".to_string().into());
                                                                out.insert("signingName".to_string(), "s3".to_string().into());
                                                                out.insert("signingRegion".to_string(), region.to_owned().into());
                                                                out
                                                            })],
                                                        )
                                                        .build());
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                            if (*use_dual_stack) == (true) {
                                if (*use_fips) == (false) {
                                    if (*accelerate) == (true) {
                                        if !(endpoint.is_some()) {
                                            if (region.as_ref() as &str) == ("aws-global") {
                                                return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                                    .url({
                                                        let mut out = String::new();
                                                        out.push_str("https://");
                                                        #[allow(clippy::needless_borrow)]
                                                        out.push_str(&bucket.as_ref() as &str);
                                                        out.push_str(".s3-accelerate.dualstack.us-east-1.");
                                                        #[allow(clippy::needless_borrow)]
                                                        out.push_str(&partition_result.dns_suffix());
                                                        out
                                                    })
                                                    .property(
                                                        "authSchemes",
                                                        vec![::aws_smithy_types::Document::from({
                                                            let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                            out.insert("disableDoubleEncoding".to_string(), true.into());
                                                            out.insert("name".to_string(), "sigv4".to_string().into());
                                                            out.insert("signingName".to_string(), "s3".to_string().into());
                                                            out.insert("signingRegion".to_string(), "us-east-1".to_string().into());
                                                            out
                                                        })],
                                                    )
                                                    .build());
                                            }
                                        }
                                    }
                                }
                            }
                            if (*use_dual_stack) == (true) {
                                if (*use_fips) == (false) {
                                    if (*accelerate) == (true) {
                                        if !(endpoint.is_some()) {
                                            if !((region.as_ref() as &str) == ("aws-global")) {
                                                if (*use_global_endpoint) == (true) {
                                                    return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                                        .url({
                                                            let mut out = String::new();
                                                            out.push_str("https://");
                                                            #[allow(clippy::needless_borrow)]
                                                            out.push_str(&bucket.as_ref() as &str);
                                                            out.push_str(".s3-accelerate.dualstack.");
                                                            #[allow(clippy::needless_borrow)]
                                                            out.push_str(&partition_result.dns_suffix());
                                                            out
                                                        })
                                                        .property(
                                                            "authSchemes",
                                                            vec![::aws_smithy_types::Document::from({
                                                                let mut out =
                                                                    ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                                out.insert("disableDoubleEncoding".to_string(), true.into());
                                                                out.insert("name".to_string(), "sigv4".to_string().into());
                                                                out.insert("signingName".to_string(), "s3".to_string().into());
                                                                out.insert("signingRegion".to_string(), region.to_owned().into());
                                                                out
                                                            })],
                                                        )
                                                        .build());
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                            if (*use_dual_stack) == (true) {
                                if (*use_fips) == (false) {
                                    if (*accelerate) == (true) {
                                        if !(endpoint.is_some()) {
                                            if !((region.as_ref() as &str) == ("aws-global")) {
                                                if (*use_global_endpoint) == (false) {
                                                    return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                                        .url({
                                                            let mut out = String::new();
                                                            out.push_str("https://");
                                                            #[allow(clippy::needless_borrow)]
                                                            out.push_str(&bucket.as_ref() as &str);
                                                            out.push_str(".s3-accelerate.dualstack.");
                                                            #[allow(clippy::needless_borrow)]
                                                            out.push_str(&partition_result.dns_suffix());
                                                            out
                                                        })
                                                        .property(
                                                            "authSchemes",
                                                            vec![::aws_smithy_types::Document::from({
                                                                let mut out =
                                                                    ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                                out.insert("disableDoubleEncoding".to_string(), true.into());
                                                                out.insert("name".to_string(), "sigv4".to_string().into());
                                                                out.insert("signingName".to_string(), "s3".to_string().into());
                                                                out.insert("signingRegion".to_string(), region.to_owned().into());
                                                                out
                                                            })],
                                                        )
                                                        .build());
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                            if (*use_dual_stack) == (true) {
                                if (*use_fips) == (false) {
                                    if (*accelerate) == (false) {
                                        if !(endpoint.is_some()) {
                                            if (region.as_ref() as &str) == ("aws-global") {
                                                return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                                    .url({
                                                        let mut out = String::new();
                                                        out.push_str("https://");
                                                        #[allow(clippy::needless_borrow)]
                                                        out.push_str(&bucket.as_ref() as &str);
                                                        out.push_str(".s3.dualstack.us-east-1.");
                                                        #[allow(clippy::needless_borrow)]
                                                        out.push_str(&partition_result.dns_suffix());
                                                        out
                                                    })
                                                    .property(
                                                        "authSchemes",
                                                        vec![::aws_smithy_types::Document::from({
                                                            let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                            out.insert("disableDoubleEncoding".to_string(), true.into());
                                                            out.insert("name".to_string(), "sigv4".to_string().into());
                                                            out.insert("signingName".to_string(), "s3".to_string().into());
                                                            out.insert("signingRegion".to_string(), "us-east-1".to_string().into());
                                                            out
                                                        })],
                                                    )
                                                    .build());
                                            }
                                        }
                                    }
                                }
                            }
                            if (*use_dual_stack) == (true) {
                                if (*use_fips) == (false) {
                                    if (*accelerate) == (false) {
                                        if !(endpoint.is_some()) {
                                            if !((region.as_ref() as &str) == ("aws-global")) {
                                                if (*use_global_endpoint) == (true) {
                                                    return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                                        .url({
                                                            let mut out = String::new();
                                                            out.push_str("https://");
                                                            #[allow(clippy::needless_borrow)]
                                                            out.push_str(&bucket.as_ref() as &str);
                                                            out.push_str(".s3.dualstack.");
                                                            #[allow(clippy::needless_borrow)]
                                                            out.push_str(&region.as_ref() as &str);
                                                            out.push('.');
                                                            #[allow(clippy::needless_borrow)]
                                                            out.push_str(&partition_result.dns_suffix());
                                                            out
                                                        })
                                                        .property(
                                                            "authSchemes",
                                                            vec![::aws_smithy_types::Document::from({
                                                                let mut out =
                                                                    ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                                out.insert("disableDoubleEncoding".to_string(), true.into());
                                                                out.insert("name".to_string(), "sigv4".to_string().into());
                                                                out.insert("signingName".to_string(), "s3".to_string().into());
                                                                out.insert("signingRegion".to_string(), region.to_owned().into());
                                                                out
                                                            })],
                                                        )
                                                        .build());
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                            if (*use_dual_stack) == (true) {
                                if (*use_fips) == (false) {
                                    if (*accelerate) == (false) {
                                        if !(endpoint.is_some()) {
                                            if !((region.as_ref() as &str) == ("aws-global")) {
                                                if (*use_global_endpoint) == (false) {
                                                    return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                                        .url({
                                                            let mut out = String::new();
                                                            out.push_str("https://");
                                                            #[allow(clippy::needless_borrow)]
                                                            out.push_str(&bucket.as_ref() as &str);
                                                            out.push_str(".s3.dualstack.");
                                                            #[allow(clippy::needless_borrow)]
                                                            out.push_str(&region.as_ref() as &str);
                                                            out.push('.');
                                                            #[allow(clippy::needless_borrow)]
                                                            out.push_str(&partition_result.dns_suffix());
                                                            out
                                                        })
                                                        .property(
                                                            "authSchemes",
                                                            vec![::aws_smithy_types::Document::from({
                                                                let mut out =
                                                                    ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                                out.insert("disableDoubleEncoding".to_string(), true.into());
                                                                out.insert("name".to_string(), "sigv4".to_string().into());
                                                                out.insert("signingName".to_string(), "s3".to_string().into());
                                                                out.insert("signingRegion".to_string(), region.to_owned().into());
                                                                out
                                                            })],
                                                        )
                                                        .build());
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                            if (*use_dual_stack) == (false) {
                                if (*use_fips) == (false) {
                                    if (*accelerate) == (false) {
                                        #[allow(unused_variables)]
                                        if let Some(endpoint) = endpoint {
                                            #[allow(unused_variables)]
                                            if let Some(url) =
                                                crate::endpoint_lib::parse_url::parse_url(endpoint.as_ref() as &str, _diagnostic_collector)
                                            {
                                                if (url.is_ip()) == (true) {
                                                    if (region.as_ref() as &str) == ("aws-global") {
                                                        return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                                            .url({
                                                                let mut out = String::new();
                                                                #[allow(clippy::needless_borrow)]
                                                                out.push_str(&url.scheme());
                                                                out.push_str("://");
                                                                #[allow(clippy::needless_borrow)]
                                                                out.push_str(&url.authority());
                                                                #[allow(clippy::needless_borrow)]
                                                                out.push_str(&url.normalized_path());
                                                                #[allow(clippy::needless_borrow)]
                                                                out.push_str(&bucket.as_ref() as &str);
                                                                out
                                                            })
                                                            .property(
                                                                "authSchemes",
                                                                vec![::aws_smithy_types::Document::from({
                                                                    let mut out =
                                                                        ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                                    out.insert("disableDoubleEncoding".to_string(), true.into());
                                                                    out.insert("name".to_string(), "sigv4".to_string().into());
                                                                    out.insert("signingName".to_string(), "s3".to_string().into());
                                                                    out.insert("signingRegion".to_string(), "us-east-1".to_string().into());
                                                                    out
                                                                })],
                                                            )
                                                            .build());
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                            if (*use_dual_stack) == (false) {
                                if (*use_fips) == (false) {
                                    if (*accelerate) == (false) {
                                        #[allow(unused_variables)]
                                        if let Some(endpoint) = endpoint {
                                            #[allow(unused_variables)]
                                            if let Some(url) =
                                                crate::endpoint_lib::parse_url::parse_url(endpoint.as_ref() as &str, _diagnostic_collector)
                                            {
                                                if (url.is_ip()) == (false) {
                                                    if (region.as_ref() as &str) == ("aws-global") {
                                                        return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                                            .url({
                                                                let mut out = String::new();
                                                                #[allow(clippy::needless_borrow)]
                                                                out.push_str(&url.scheme());
                                                                out.push_str("://");
                                                                #[allow(clippy::needless_borrow)]
                                                                out.push_str(&bucket.as_ref() as &str);
                                                                out.push('.');
                                                                #[allow(clippy::needless_borrow)]
                                                                out.push_str(&url.authority());
                                                                #[allow(clippy::needless_borrow)]
                                                                out.push_str(&url.path());
                                                                out
                                                            })
                                                            .property(
                                                                "authSchemes",
                                                                vec![::aws_smithy_types::Document::from({
                                                                    let mut out =
                                                                        ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                                    out.insert("disableDoubleEncoding".to_string(), true.into());
                                                                    out.insert("name".to_string(), "sigv4".to_string().into());
                                                                    out.insert("signingName".to_string(), "s3".to_string().into());
                                                                    out.insert("signingRegion".to_string(), "us-east-1".to_string().into());
                                                                    out
                                                                })],
                                                            )
                                                            .build());
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                            if (*use_dual_stack) == (false) {
                                if (*use_fips) == (false) {
                                    if (*accelerate) == (false) {
                                        #[allow(unused_variables)]
                                        if let Some(endpoint) = endpoint {
                                            #[allow(unused_variables)]
                                            if let Some(url) =
                                                crate::endpoint_lib::parse_url::parse_url(endpoint.as_ref() as &str, _diagnostic_collector)
                                            {
                                                if (url.is_ip()) == (true) {
                                                    if !((region.as_ref() as &str) == ("aws-global")) {
                                                        if (*use_global_endpoint) == (true) {
                                                            if (region.as_ref() as &str) == ("us-east-1") {
                                                                return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                                                    .url({
                                                                        let mut out = String::new();
                                                                        #[allow(clippy::needless_borrow)]
                                                                        out.push_str(&url.scheme());
                                                                        out.push_str("://");
                                                                        #[allow(clippy::needless_borrow)]
                                                                        out.push_str(&url.authority());
                                                                        #[allow(clippy::needless_borrow)]
                                                                        out.push_str(&url.normalized_path());
                                                                        #[allow(clippy::needless_borrow)]
                                                                        out.push_str(&bucket.as_ref() as &str);
                                                                        out
                                                                    })
                                                                    .property(
                                                                        "authSchemes",
                                                                        vec![::aws_smithy_types::Document::from({
                                                                            let mut out = ::std::collections::HashMap::<
                                                                                String,
                                                                                ::aws_smithy_types::Document,
                                                                            >::new(
                                                                            );
                                                                            out.insert("disableDoubleEncoding".to_string(), true.into());
                                                                            out.insert("name".to_string(), "sigv4".to_string().into());
                                                                            out.insert("signingName".to_string(), "s3".to_string().into());
                                                                            out.insert("signingRegion".to_string(), region.to_owned().into());
                                                                            out
                                                                        })],
                                                                    )
                                                                    .build());
                                                            }
                                                            return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                                                .url({
                                                                    let mut out = String::new();
                                                                    #[allow(clippy::needless_borrow)]
                                                                    out.push_str(&url.scheme());
                                                                    out.push_str("://");
                                                                    #[allow(clippy::needless_borrow)]
                                                                    out.push_str(&url.authority());
                                                                    #[allow(clippy::needless_borrow)]
                                                                    out.push_str(&url.normalized_path());
                                                                    #[allow(clippy::needless_borrow)]
                                                                    out.push_str(&bucket.as_ref() as &str);
                                                                    out
                                                                })
                                                                .property(
                                                                    "authSchemes",
                                                                    vec![::aws_smithy_types::Document::from({
                                                                        let mut out =
                                                                            ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new(
                                                                            );
                                                                        out.insert("disableDoubleEncoding".to_string(), true.into());
                                                                        out.insert("name".to_string(), "sigv4".to_string().into());
                                                                        out.insert("signingName".to_string(), "s3".to_string().into());
                                                                        out.insert("signingRegion".to_string(), region.to_owned().into());
                                                                        out
                                                                    })],
                                                                )
                                                                .build());
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                            if (*use_dual_stack) == (false) {
                                if (*use_fips) == (false) {
                                    if (*accelerate) == (false) {
                                        #[allow(unused_variables)]
                                        if let Some(endpoint) = endpoint {
                                            #[allow(unused_variables)]
                                            if let Some(url) =
                                                crate::endpoint_lib::parse_url::parse_url(endpoint.as_ref() as &str, _diagnostic_collector)
                                            {
                                                if (url.is_ip()) == (false) {
                                                    if !((region.as_ref() as &str) == ("aws-global")) {
                                                        if (*use_global_endpoint) == (true) {
                                                            if (region.as_ref() as &str) == ("us-east-1") {
                                                                return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                                                    .url({
                                                                        let mut out = String::new();
                                                                        #[allow(clippy::needless_borrow)]
                                                                        out.push_str(&url.scheme());
                                                                        out.push_str("://");
                                                                        #[allow(clippy::needless_borrow)]
                                                                        out.push_str(&bucket.as_ref() as &str);
                                                                        out.push('.');
                                                                        #[allow(clippy::needless_borrow)]
                                                                        out.push_str(&url.authority());
                                                                        #[allow(clippy::needless_borrow)]
                                                                        out.push_str(&url.path());
                                                                        out
                                                                    })
                                                                    .property(
                                                                        "authSchemes",
                                                                        vec![::aws_smithy_types::Document::from({
                                                                            let mut out = ::std::collections::HashMap::<
                                                                                String,
                                                                                ::aws_smithy_types::Document,
                                                                            >::new(
                                                                            );
                                                                            out.insert("disableDoubleEncoding".to_string(), true.into());
                                                                            out.insert("name".to_string(), "sigv4".to_string().into());
                                                                            out.insert("signingName".to_string(), "s3".to_string().into());
                                                                            out.insert("signingRegion".to_string(), region.to_owned().into());
                                                                            out
                                                                        })],
                                                                    )
                                                                    .build());
                                                            }
                                                            return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                                                .url({
                                                                    let mut out = String::new();
                                                                    #[allow(clippy::needless_borrow)]
                                                                    out.push_str(&url.scheme());
                                                                    out.push_str("://");
                                                                    #[allow(clippy::needless_borrow)]
                                                                    out.push_str(&bucket.as_ref() as &str);
                                                                    out.push('.');
                                                                    #[allow(clippy::needless_borrow)]
                                                                    out.push_str(&url.authority());
                                                                    #[allow(clippy::needless_borrow)]
                                                                    out.push_str(&url.path());
                                                                    out
                                                                })
                                                                .property(
                                                                    "authSchemes",
                                                                    vec![::aws_smithy_types::Document::from({
                                                                        let mut out =
                                                                            ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new(
                                                                            );
                                                                        out.insert("disableDoubleEncoding".to_string(), true.into());
                                                                        out.insert("name".to_string(), "sigv4".to_string().into());
                                                                        out.insert("signingName".to_string(), "s3".to_string().into());
                                                                        out.insert("signingRegion".to_string(), region.to_owned().into());
                                                                        out
                                                                    })],
                                                                )
                                                                .build());
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                            if (*use_dual_stack) == (false) {
                                if (*use_fips) == (false) {
                                    if (*accelerate) == (false) {
                                        #[allow(unused_variables)]
                                        if let Some(endpoint) = endpoint {
                                            #[allow(unused_variables)]
                                            if let Some(url) =
                                                crate::endpoint_lib::parse_url::parse_url(endpoint.as_ref() as &str, _diagnostic_collector)
                                            {
                                                if (url.is_ip()) == (true) {
                                                    if !((region.as_ref() as &str) == ("aws-global")) {
                                                        if (*use_global_endpoint) == (false) {
                                                            return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                                                .url({
                                                                    let mut out = String::new();
                                                                    #[allow(clippy::needless_borrow)]
                                                                    out.push_str(&url.scheme());
                                                                    out.push_str("://");
                                                                    #[allow(clippy::needless_borrow)]
                                                                    out.push_str(&url.authority());
                                                                    #[allow(clippy::needless_borrow)]
                                                                    out.push_str(&url.normalized_path());
                                                                    #[allow(clippy::needless_borrow)]
                                                                    out.push_str(&bucket.as_ref() as &str);
                                                                    out
                                                                })
                                                                .property(
                                                                    "authSchemes",
                                                                    vec![::aws_smithy_types::Document::from({
                                                                        let mut out =
                                                                            ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new(
                                                                            );
                                                                        out.insert("disableDoubleEncoding".to_string(), true.into());
                                                                        out.insert("name".to_string(), "sigv4".to_string().into());
                                                                        out.insert("signingName".to_string(), "s3".to_string().into());
                                                                        out.insert("signingRegion".to_string(), region.to_owned().into());
                                                                        out
                                                                    })],
                                                                )
                                                                .build());
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                            if (*use_dual_stack) == (false) {
                                if (*use_fips) == (false) {
                                    if (*accelerate) == (false) {
                                        #[allow(unused_variables)]
                                        if let Some(endpoint) = endpoint {
                                            #[allow(unused_variables)]
                                            if let Some(url) =
                                                crate::endpoint_lib::parse_url::parse_url(endpoint.as_ref() as &str, _diagnostic_collector)
                                            {
                                                if (url.is_ip()) == (false) {
                                                    if !((region.as_ref() as &str) == ("aws-global")) {
                                                        if (*use_global_endpoint) == (false) {
                                                            return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                                                .url({
                                                                    let mut out = String::new();
                                                                    #[allow(clippy::needless_borrow)]
                                                                    out.push_str(&url.scheme());
                                                                    out.push_str("://");
                                                                    #[allow(clippy::needless_borrow)]
                                                                    out.push_str(&bucket.as_ref() as &str);
                                                                    out.push('.');
                                                                    #[allow(clippy::needless_borrow)]
                                                                    out.push_str(&url.authority());
                                                                    #[allow(clippy::needless_borrow)]
                                                                    out.push_str(&url.path());
                                                                    out
                                                                })
                                                                .property(
                                                                    "authSchemes",
                                                                    vec![::aws_smithy_types::Document::from({
                                                                        let mut out =
                                                                            ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new(
                                                                            );
                                                                        out.insert("disableDoubleEncoding".to_string(), true.into());
                                                                        out.insert("name".to_string(), "sigv4".to_string().into());
                                                                        out.insert("signingName".to_string(), "s3".to_string().into());
                                                                        out.insert("signingRegion".to_string(), region.to_owned().into());
                                                                        out
                                                                    })],
                                                                )
                                                                .build());
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                            if (*use_dual_stack) == (false) {
                                if (*use_fips) == (false) {
                                    if (*accelerate) == (true) {
                                        if !(endpoint.is_some()) {
                                            if (region.as_ref() as &str) == ("aws-global") {
                                                return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                                    .url({
                                                        let mut out = String::new();
                                                        out.push_str("https://");
                                                        #[allow(clippy::needless_borrow)]
                                                        out.push_str(&bucket.as_ref() as &str);
                                                        out.push_str(".s3-accelerate.");
                                                        #[allow(clippy::needless_borrow)]
                                                        out.push_str(&partition_result.dns_suffix());
                                                        out
                                                    })
                                                    .property(
                                                        "authSchemes",
                                                        vec![::aws_smithy_types::Document::from({
                                                            let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                            out.insert("disableDoubleEncoding".to_string(), true.into());
                                                            out.insert("name".to_string(), "sigv4".to_string().into());
                                                            out.insert("signingName".to_string(), "s3".to_string().into());
                                                            out.insert("signingRegion".to_string(), "us-east-1".to_string().into());
                                                            out
                                                        })],
                                                    )
                                                    .build());
                                            }
                                        }
                                    }
                                }
                            }
                            if (*use_dual_stack) == (false) {
                                if (*use_fips) == (false) {
                                    if (*accelerate) == (true) {
                                        if !(endpoint.is_some()) {
                                            if !((region.as_ref() as &str) == ("aws-global")) {
                                                if (*use_global_endpoint) == (true) {
                                                    if (region.as_ref() as &str) == ("us-east-1") {
                                                        return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                                            .url({
                                                                let mut out = String::new();
                                                                out.push_str("https://");
                                                                #[allow(clippy::needless_borrow)]
                                                                out.push_str(&bucket.as_ref() as &str);
                                                                out.push_str(".s3-accelerate.");
                                                                #[allow(clippy::needless_borrow)]
                                                                out.push_str(&partition_result.dns_suffix());
                                                                out
                                                            })
                                                            .property(
                                                                "authSchemes",
                                                                vec![::aws_smithy_types::Document::from({
                                                                    let mut out =
                                                                        ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                                    out.insert("disableDoubleEncoding".to_string(), true.into());
                                                                    out.insert("name".to_string(), "sigv4".to_string().into());
                                                                    out.insert("signingName".to_string(), "s3".to_string().into());
                                                                    out.insert("signingRegion".to_string(), region.to_owned().into());
                                                                    out
                                                                })],
                                                            )
                                                            .build());
                                                    }
                                                    return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                                        .url({
                                                            let mut out = String::new();
                                                            out.push_str("https://");
                                                            #[allow(clippy::needless_borrow)]
                                                            out.push_str(&bucket.as_ref() as &str);
                                                            out.push_str(".s3-accelerate.");
                                                            #[allow(clippy::needless_borrow)]
                                                            out.push_str(&partition_result.dns_suffix());
                                                            out
                                                        })
                                                        .property(
                                                            "authSchemes",
                                                            vec![::aws_smithy_types::Document::from({
                                                                let mut out =
                                                                    ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                                out.insert("disableDoubleEncoding".to_string(), true.into());
                                                                out.insert("name".to_string(), "sigv4".to_string().into());
                                                                out.insert("signingName".to_string(), "s3".to_string().into());
                                                                out.insert("signingRegion".to_string(), region.to_owned().into());
                                                                out
                                                            })],
                                                        )
                                                        .build());
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                            if (*use_dual_stack) == (false) {
                                if (*use_fips) == (false) {
                                    if (*accelerate) == (true) {
                                        if !(endpoint.is_some()) {
                                            if !((region.as_ref() as &str) == ("aws-global")) {
                                                if (*use_global_endpoint) == (false) {
                                                    return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                                        .url({
                                                            let mut out = String::new();
                                                            out.push_str("https://");
                                                            #[allow(clippy::needless_borrow)]
                                                            out.push_str(&bucket.as_ref() as &str);
                                                            out.push_str(".s3-accelerate.");
                                                            #[allow(clippy::needless_borrow)]
                                                            out.push_str(&partition_result.dns_suffix());
                                                            out
                                                        })
                                                        .property(
                                                            "authSchemes",
                                                            vec![::aws_smithy_types::Document::from({
                                                                let mut out =
                                                                    ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                                out.insert("disableDoubleEncoding".to_string(), true.into());
                                                                out.insert("name".to_string(), "sigv4".to_string().into());
                                                                out.insert("signingName".to_string(), "s3".to_string().into());
                                                                out.insert("signingRegion".to_string(), region.to_owned().into());
                                                                out
                                                            })],
                                                        )
                                                        .build());
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                            if (*use_dual_stack) == (false) {
                                if (*use_fips) == (false) {
                                    if (*accelerate) == (false) {
                                        if !(endpoint.is_some()) {
                                            if (region.as_ref() as &str) == ("aws-global") {
                                                return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                                    .url({
                                                        let mut out = String::new();
                                                        out.push_str("https://");
                                                        #[allow(clippy::needless_borrow)]
                                                        out.push_str(&bucket.as_ref() as &str);
                                                        out.push_str(".s3.");
                                                        #[allow(clippy::needless_borrow)]
                                                        out.push_str(&partition_result.dns_suffix());
                                                        out
                                                    })
                                                    .property(
                                                        "authSchemes",
                                                        vec![::aws_smithy_types::Document::from({
                                                            let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                            out.insert("disableDoubleEncoding".to_string(), true.into());
                                                            out.insert("name".to_string(), "sigv4".to_string().into());
                                                            out.insert("signingName".to_string(), "s3".to_string().into());
                                                            out.insert("signingRegion".to_string(), "us-east-1".to_string().into());
                                                            out
                                                        })],
                                                    )
                                                    .build());
                                            }
                                        }
                                    }
                                }
                            }
                            if (*use_dual_stack) == (false) {
                                if (*use_fips) == (false) {
                                    if (*accelerate) == (false) {
                                        if !(endpoint.is_some()) {
                                            if !((region.as_ref() as &str) == ("aws-global")) {
                                                if (*use_global_endpoint) == (true) {
                                                    if (region.as_ref() as &str) == ("us-east-1") {
                                                        return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                                            .url({
                                                                let mut out = String::new();
                                                                out.push_str("https://");
                                                                #[allow(clippy::needless_borrow)]
                                                                out.push_str(&bucket.as_ref() as &str);
                                                                out.push_str(".s3.");
                                                                #[allow(clippy::needless_borrow)]
                                                                out.push_str(&partition_result.dns_suffix());
                                                                out
                                                            })
                                                            .property(
                                                                "authSchemes",
                                                                vec![::aws_smithy_types::Document::from({
                                                                    let mut out =
                                                                        ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                                    out.insert("disableDoubleEncoding".to_string(), true.into());
                                                                    out.insert("name".to_string(), "sigv4".to_string().into());
                                                                    out.insert("signingName".to_string(), "s3".to_string().into());
                                                                    out.insert("signingRegion".to_string(), region.to_owned().into());
                                                                    out
                                                                })],
                                                            )
                                                            .build());
                                                    }
                                                    return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                                        .url({
                                                            let mut out = String::new();
                                                            out.push_str("https://");
                                                            #[allow(clippy::needless_borrow)]
                                                            out.push_str(&bucket.as_ref() as &str);
                                                            out.push_str(".s3.");
                                                            #[allow(clippy::needless_borrow)]
                                                            out.push_str(&region.as_ref() as &str);
                                                            out.push('.');
                                                            #[allow(clippy::needless_borrow)]
                                                            out.push_str(&partition_result.dns_suffix());
                                                            out
                                                        })
                                                        .property(
                                                            "authSchemes",
                                                            vec![::aws_smithy_types::Document::from({
                                                                let mut out =
                                                                    ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                                out.insert("disableDoubleEncoding".to_string(), true.into());
                                                                out.insert("name".to_string(), "sigv4".to_string().into());
                                                                out.insert("signingName".to_string(), "s3".to_string().into());
                                                                out.insert("signingRegion".to_string(), region.to_owned().into());
                                                                out
                                                            })],
                                                        )
                                                        .build());
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                            if (*use_dual_stack) == (false) {
                                if (*use_fips) == (false) {
                                    if (*accelerate) == (false) {
                                        if !(endpoint.is_some()) {
                                            if !((region.as_ref() as &str) == ("aws-global")) {
                                                if (*use_global_endpoint) == (false) {
                                                    return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                                        .url({
                                                            let mut out = String::new();
                                                            out.push_str("https://");
                                                            #[allow(clippy::needless_borrow)]
                                                            out.push_str(&bucket.as_ref() as &str);
                                                            out.push_str(".s3.");
                                                            #[allow(clippy::needless_borrow)]
                                                            out.push_str(&region.as_ref() as &str);
                                                            out.push('.');
                                                            #[allow(clippy::needless_borrow)]
                                                            out.push_str(&partition_result.dns_suffix());
                                                            out
                                                        })
                                                        .property(
                                                            "authSchemes",
                                                            vec![::aws_smithy_types::Document::from({
                                                                let mut out =
                                                                    ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                                out.insert("disableDoubleEncoding".to_string(), true.into());
                                                                out.insert("name".to_string(), "sigv4".to_string().into());
                                                                out.insert("signingName".to_string(), "s3".to_string().into());
                                                                out.insert("signingRegion".to_string(), region.to_owned().into());
                                                                out
                                                            })],
                                                        )
                                                        .build());
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                            #[allow(unreachable_code)]
                            return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message(format!(
                                "No rules matched these parameters. This is a bug. {:?}",
                                _params
                            )));
                        }
                        return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message(
                            "Invalid region: region was not a valid DNS name.".to_string(),
                        ));
                    }
                    #[allow(unreachable_code)]
                    return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message(format!(
                        "No rules matched these parameters. This is a bug. {:?}",
                        _params
                    )));
                }
            }
            #[allow(unused_variables)]
            if let Some(endpoint) = endpoint {
                #[allow(unused_variables)]
                if let Some(url) = crate::endpoint_lib::parse_url::parse_url(endpoint.as_ref() as &str, _diagnostic_collector) {
                    if (url.scheme()) == ("http") {
                        if crate::endpoint_lib::s3::is_virtual_hostable_s3_bucket(bucket.as_ref() as &str, true, _diagnostic_collector) {
                            if (*force_path_style) == (false) {
                                if (*use_fips) == (false) {
                                    if (*use_dual_stack) == (false) {
                                        if (*accelerate) == (false) {
                                            #[allow(unused_variables)]
                                            if let Some(partition_result) =
                                                partition_resolver.resolve_partition(region.as_ref() as &str, _diagnostic_collector)
                                            {
                                                if crate::endpoint_lib::host::is_valid_host_label(
                                                    region.as_ref() as &str,
                                                    false,
                                                    _diagnostic_collector,
                                                ) {
                                                    return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                                        .url({
                                                            let mut out = String::new();
                                                            #[allow(clippy::needless_borrow)]
                                                            out.push_str(&url.scheme());
                                                            out.push_str("://");
                                                            #[allow(clippy::needless_borrow)]
                                                            out.push_str(&bucket.as_ref() as &str);
                                                            out.push('.');
                                                            #[allow(clippy::needless_borrow)]
                                                            out.push_str(&url.authority());
                                                            #[allow(clippy::needless_borrow)]
                                                            out.push_str(&url.path());
                                                            out
                                                        })
                                                        .property(
                                                            "authSchemes",
                                                            vec![::aws_smithy_types::Document::from({
                                                                let mut out =
                                                                    ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                                out.insert("disableDoubleEncoding".to_string(), true.into());
                                                                out.insert("name".to_string(), "sigv4".to_string().into());
                                                                out.insert("signingName".to_string(), "s3".to_string().into());
                                                                out.insert("signingRegion".to_string(), region.to_owned().into());
                                                                out
                                                            })],
                                                        )
                                                        .build());
                                                }
                                                return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message(
                                                    "Invalid region: region was not a valid DNS name.".to_string(),
                                                ));
                                            }
                                            #[allow(unreachable_code)]
                                            return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message(format!(
                                                "No rules matched these parameters. This is a bug. {:?}",
                                                _params
                                            )));
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            if (*force_path_style) == (false) {
                #[allow(unused_variables)]
                if let Some(bucket_arn) = crate::endpoint_lib::arn::parse_arn(bucket.as_ref() as &str, _diagnostic_collector) {
                    #[allow(unused_variables)]
                    if let Some(arn_type) = bucket_arn.resource_id().first().cloned() {
                        if !((arn_type.as_ref() as &str) == ("")) {
                            if (bucket_arn.service()) == ("s3-object-lambda") {
                                if (arn_type.as_ref() as &str) == ("accesspoint") {
                                    #[allow(unused_variables)]
                                    if let Some(access_point_name) = bucket_arn.resource_id().get(1).cloned() {
                                        if !((access_point_name.as_ref() as &str) == ("")) {
                                            if (*use_dual_stack) == (true) {
                                                return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message(
                                                    "S3 Object Lambda does not support Dual-stack".to_string(),
                                                ));
                                            }
                                            if (*accelerate) == (true) {
                                                return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message(
                                                    "S3 Object Lambda does not support S3 Accelerate".to_string(),
                                                ));
                                            }
                                            if !((bucket_arn.region()) == ("")) {
                                                #[allow(unused_variables)]
                                                if let Some(disable_access_points) = disable_access_points {
                                                    if (*disable_access_points) == (true) {
                                                        return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message(
                                                            "Access points are not supported for this operation".to_string(),
                                                        ));
                                                    }
                                                }
                                                if !(bucket_arn.resource_id().get(2).cloned().is_some()) {
                                                    #[allow(unused_variables)]
                                                    if let Some(use_arn_region) = use_arn_region {
                                                        if (*use_arn_region) == (false) {
                                                            if !((bucket_arn.region()) == (region.as_ref() as &str)) {
                                                                return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message({
                                                                    let mut out = String::new();
                                                                    out.push_str("Invalid configuration: region from ARN `");
                                                                    #[allow(clippy::needless_borrow)]
                                                                    out.push_str(&bucket_arn.region());
                                                                    out.push_str("` does not match client region `");
                                                                    #[allow(clippy::needless_borrow)]
                                                                    out.push_str(&region.as_ref() as &str);
                                                                    out.push_str("` and UseArnRegion is `false`");
                                                                    out
                                                                }));
                                                            }
                                                        }
                                                    }
                                                    #[allow(unused_variables)]
                                                    if let Some(bucket_partition) =
                                                        partition_resolver.resolve_partition(bucket_arn.region(), _diagnostic_collector)
                                                    {
                                                        #[allow(unused_variables)]
                                                        if let Some(partition_result) =
                                                            partition_resolver.resolve_partition(region.as_ref() as &str, _diagnostic_collector)
                                                        {
                                                            if (bucket_partition.name()) == (partition_result.name()) {
                                                                if crate::endpoint_lib::host::is_valid_host_label(
                                                                    bucket_arn.region(),
                                                                    true,
                                                                    _diagnostic_collector,
                                                                ) {
                                                                    if (bucket_arn.account_id()) == ("") {
                                                                        return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message(
                                                                            "Invalid ARN: Missing account id".to_string(),
                                                                        ));
                                                                    }
                                                                    if crate::endpoint_lib::host::is_valid_host_label(
                                                                        bucket_arn.account_id(),
                                                                        false,
                                                                        _diagnostic_collector,
                                                                    ) {
                                                                        if crate::endpoint_lib::host::is_valid_host_label(
                                                                            access_point_name.as_ref() as &str,
                                                                            false,
                                                                            _diagnostic_collector,
                                                                        ) {
                                                                            #[allow(unused_variables)]
                                                                            if let Some(endpoint) = endpoint {
                                                                                #[allow(unused_variables)]
                                                                                if let Some(url) = crate::endpoint_lib::parse_url::parse_url(
                                                                                    endpoint.as_ref() as &str,
                                                                                    _diagnostic_collector,
                                                                                ) {
                                                                                    return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                                                                        .url({
                                                                                            let mut out = String::new();
                                                                                            #[allow(clippy::needless_borrow)]
                                                                                            out.push_str(&url.scheme());
                                                                                            out.push_str("://");
                                                                                            #[allow(clippy::needless_borrow)]
                                                                                            out.push_str(&access_point_name.as_ref() as &str);
                                                                                            out.push('-');
                                                                                            #[allow(clippy::needless_borrow)]
                                                                                            out.push_str(&bucket_arn.account_id());
                                                                                            out.push('.');
                                                                                            #[allow(clippy::needless_borrow)]
                                                                                            out.push_str(&url.authority());
                                                                                            #[allow(clippy::needless_borrow)]
                                                                                            out.push_str(&url.path());
                                                                                            out
                                                                                        })
                                                                                        .property(
                                                                                            "authSchemes",
                                                                                            vec![::aws_smithy_types::Document::from({
                                                                                                let mut out = ::std::collections::HashMap::<
                                                                                                    String,
                                                                                                    ::aws_smithy_types::Document,
                                                                                                >::new(
                                                                                                );
                                                                                                out.insert(
                                                                                                    "disableDoubleEncoding".to_string(),
                                                                                                    true.into(),
                                                                                                );
                                                                                                out.insert(
                                                                                                    "name".to_string(),
                                                                                                    "sigv4".to_string().into(),
                                                                                                );
                                                                                                out.insert(
                                                                                                    "signingName".to_string(),
                                                                                                    "s3-object-lambda".to_string().into(),
                                                                                                );
                                                                                                out.insert(
                                                                                                    "signingRegion".to_string(),
                                                                                                    bucket_arn.region().to_owned().into(),
                                                                                                );
                                                                                                out
                                                                                            })],
                                                                                        )
                                                                                        .build());
                                                                                }
                                                                            }
                                                                            if (*use_fips) == (true) {
                                                                                return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                                                                    .url({
                                                                                        let mut out = String::new();
                                                                                        out.push_str("https://");
                                                                                        #[allow(clippy::needless_borrow)]
                                                                                        out.push_str(&access_point_name.as_ref() as &str);
                                                                                        out.push('-');
                                                                                        #[allow(clippy::needless_borrow)]
                                                                                        out.push_str(&bucket_arn.account_id());
                                                                                        out.push_str(".s3-object-lambda-fips.");
                                                                                        #[allow(clippy::needless_borrow)]
                                                                                        out.push_str(&bucket_arn.region());
                                                                                        out.push('.');
                                                                                        #[allow(clippy::needless_borrow)]
                                                                                        out.push_str(&bucket_partition.dns_suffix());
                                                                                        out
                                                                                    })
                                                                                    .property(
                                                                                        "authSchemes",
                                                                                        vec![::aws_smithy_types::Document::from({
                                                                                            let mut out = ::std::collections::HashMap::<
                                                                                                String,
                                                                                                ::aws_smithy_types::Document,
                                                                                            >::new(
                                                                                            );
                                                                                            out.insert(
                                                                                                "disableDoubleEncoding".to_string(),
                                                                                                true.into(),
                                                                                            );
                                                                                            out.insert(
                                                                                                "name".to_string(),
                                                                                                "sigv4".to_string().into(),
                                                                                            );
                                                                                            out.insert(
                                                                                                "signingName".to_string(),
                                                                                                "s3-object-lambda".to_string().into(),
                                                                                            );
                                                                                            out.insert(
                                                                                                "signingRegion".to_string(),
                                                                                                bucket_arn.region().to_owned().into(),
                                                                                            );
                                                                                            out
                                                                                        })],
                                                                                    )
                                                                                    .build());
                                                                            }
                                                                            return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                                                                .url({
                                                                                    let mut out = String::new();
                                                                                    out.push_str("https://");
                                                                                    #[allow(clippy::needless_borrow)]
                                                                                    out.push_str(&access_point_name.as_ref() as &str);
                                                                                    out.push('-');
                                                                                    #[allow(clippy::needless_borrow)]
                                                                                    out.push_str(&bucket_arn.account_id());
                                                                                    out.push_str(".s3-object-lambda.");
                                                                                    #[allow(clippy::needless_borrow)]
                                                                                    out.push_str(&bucket_arn.region());
                                                                                    out.push('.');
                                                                                    #[allow(clippy::needless_borrow)]
                                                                                    out.push_str(&bucket_partition.dns_suffix());
                                                                                    out
                                                                                })
                                                                                .property(
                                                                                    "authSchemes",
                                                                                    vec![::aws_smithy_types::Document::from({
                                                                                        let mut out = ::std::collections::HashMap::<
                                                                                            String,
                                                                                            ::aws_smithy_types::Document,
                                                                                        >::new(
                                                                                        );
                                                                                        out.insert("disableDoubleEncoding".to_string(), true.into());
                                                                                        out.insert("name".to_string(), "sigv4".to_string().into());
                                                                                        out.insert(
                                                                                            "signingName".to_string(),
                                                                                            "s3-object-lambda".to_string().into(),
                                                                                        );
                                                                                        out.insert(
                                                                                            "signingRegion".to_string(),
                                                                                            bucket_arn.region().to_owned().into(),
                                                                                        );
                                                                                        out
                                                                                    })],
                                                                                )
                                                                                .build());
                                                                        }
                                                                        return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message({
                                                                            let mut out = String::new();
                                                                            out.push_str("Invalid ARN: The access point name may only contain a-z, A-Z, 0-9 and `-`. Found: `");
                                                                            #[allow(clippy::needless_borrow)]
                                                                            out.push_str(&access_point_name.as_ref() as &str);
                                                                            out.push('`');
                                                                            out
                                                                        }));
                                                                    }
                                                                    return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message({
                                                                        let mut out = String::new();
                                                                        out.push_str("Invalid ARN: The account id may only contain a-z, A-Z, 0-9 and `-`. Found: `");
                                                                        #[allow(clippy::needless_borrow)]
                                                                        out.push_str(&bucket_arn.account_id());
                                                                        out.push('`');
                                                                        out
                                                                    }));
                                                                }
                                                                return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message({
                                                                    let mut out = String::new();
                                                                    out.push_str("Invalid region in ARN: `");
                                                                    #[allow(clippy::needless_borrow)]
                                                                    out.push_str(&bucket_arn.region());
                                                                    out.push_str("` (invalid DNS name)");
                                                                    out
                                                                }));
                                                            }
                                                            return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message({
                                                                let mut out = String::new();
                                                                out.push_str("Client was configured for partition `");
                                                                #[allow(clippy::needless_borrow)]
                                                                out.push_str(&partition_result.name());
                                                                out.push_str("` but ARN (`");
                                                                #[allow(clippy::needless_borrow)]
                                                                out.push_str(&bucket.as_ref() as &str);
                                                                out.push_str("`) has `");
                                                                #[allow(clippy::needless_borrow)]
                                                                out.push_str(&bucket_partition.name());
                                                                out.push('`');
                                                                out
                                                            }));
                                                        }
                                                        #[allow(unreachable_code)]
                                                        return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message(format!(
                                                            "No rules matched these parameters. This is a bug. {:?}",
                                                            _params
                                                        )));
                                                    }
                                                    #[allow(unreachable_code)]
                                                    return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message(format!(
                                                        "No rules matched these parameters. This is a bug. {:?}",
                                                        _params
                                                    )));
                                                }
                                                return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message(
                                                    "Invalid ARN: The ARN may only contain a single resource component after `accesspoint`."
                                                        .to_string(),
                                                ));
                                            }
                                            return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message(
                                                "Invalid ARN: bucket ARN is missing a region".to_string(),
                                            ));
                                        }
                                    }
                                    return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message(
                                        "Invalid ARN: Expected a resource of the format `accesspoint:<accesspoint name>` but no name was provided"
                                            .to_string(),
                                    ));
                                }
                                return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message({
                                    let mut out = String::new();
                                    out.push_str("Invalid ARN: Object Lambda ARNs only support `accesspoint` arn types, but found: `");
                                    #[allow(clippy::needless_borrow)]
                                    out.push_str(&arn_type.as_ref() as &str);
                                    out.push('`');
                                    out
                                }));
                            }
                            if (arn_type.as_ref() as &str) == ("accesspoint") {
                                #[allow(unused_variables)]
                                if let Some(access_point_name) = bucket_arn.resource_id().get(1).cloned() {
                                    if !((access_point_name.as_ref() as &str) == ("")) {
                                        if !((bucket_arn.region()) == ("")) {
                                            if (arn_type.as_ref() as &str) == ("accesspoint") {
                                                if !((bucket_arn.region()) == ("")) {
                                                    #[allow(unused_variables)]
                                                    if let Some(disable_access_points) = disable_access_points {
                                                        if (*disable_access_points) == (true) {
                                                            return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message(
                                                                "Access points are not supported for this operation".to_string(),
                                                            ));
                                                        }
                                                    }
                                                    if !(bucket_arn.resource_id().get(2).cloned().is_some()) {
                                                        #[allow(unused_variables)]
                                                        if let Some(use_arn_region) = use_arn_region {
                                                            if (*use_arn_region) == (false) {
                                                                if !((bucket_arn.region()) == (region.as_ref() as &str)) {
                                                                    return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message({
                                                                        let mut out = String::new();
                                                                        out.push_str("Invalid configuration: region from ARN `");
                                                                        #[allow(clippy::needless_borrow)]
                                                                        out.push_str(&bucket_arn.region());
                                                                        out.push_str("` does not match client region `");
                                                                        #[allow(clippy::needless_borrow)]
                                                                        out.push_str(&region.as_ref() as &str);
                                                                        out.push_str("` and UseArnRegion is `false`");
                                                                        out
                                                                    }));
                                                                }
                                                            }
                                                        }
                                                        #[allow(unused_variables)]
                                                        if let Some(bucket_partition) =
                                                            partition_resolver.resolve_partition(bucket_arn.region(), _diagnostic_collector)
                                                        {
                                                            #[allow(unused_variables)]
                                                            if let Some(partition_result) =
                                                                partition_resolver.resolve_partition(region.as_ref() as &str, _diagnostic_collector)
                                                            {
                                                                if (bucket_partition.name()) == (partition_result.name()) {
                                                                    if crate::endpoint_lib::host::is_valid_host_label(
                                                                        bucket_arn.region(),
                                                                        true,
                                                                        _diagnostic_collector,
                                                                    ) {
                                                                        if (bucket_arn.service()) == ("s3") {
                                                                            if crate::endpoint_lib::host::is_valid_host_label(
                                                                                bucket_arn.account_id(),
                                                                                false,
                                                                                _diagnostic_collector,
                                                                            ) {
                                                                                if crate::endpoint_lib::host::is_valid_host_label(
                                                                                    access_point_name.as_ref() as &str,
                                                                                    false,
                                                                                    _diagnostic_collector,
                                                                                ) {
                                                                                    if (*accelerate) == (true) {
                                                                                        return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message("Access Points do not support S3 Accelerate"
.to_string()));
                                                                                    }
                                                                                    if (*use_fips) == (true) {
                                                                                        if (*use_dual_stack) == (true) {
                                                                                            return Ok(::aws_smithy_types::endpoint::Endpoint::builder().url({ let mut out = String::new();
out.push_str("https://");
#[allow(clippy::needless_borrow)]
out.push_str(&access_point_name.as_ref() as &str);
out.push('-');
#[allow(clippy::needless_borrow)]
out.push_str(&bucket_arn.account_id());
out.push_str(".s3-accesspoint-fips.dualstack.");
#[allow(clippy::needless_borrow)]
out.push_str(&bucket_arn.region());
out.push('.');
#[allow(clippy::needless_borrow)]
out.push_str(&bucket_partition.dns_suffix());
out })
.property("authSchemes", vec![::aws_smithy_types::Document::from( {
    let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
    out.insert("disableDoubleEncoding".to_string(), true.into());
    out.insert("name".to_string(), "sigv4"
    .to_string().into());
    out.insert("signingName".to_string(), "s3"
    .to_string().into());
    out.insert("signingRegion".to_string(), bucket_arn.region()
    .to_owned().into());
    out
}),])
.build());
                                                                                        }
                                                                                    }
                                                                                    if (*use_fips) == (true) {
                                                                                        if (*use_dual_stack) == (false) {
                                                                                            return Ok(::aws_smithy_types::endpoint::Endpoint::builder().url({ let mut out = String::new();
out.push_str("https://");
#[allow(clippy::needless_borrow)]
out.push_str(&access_point_name.as_ref() as &str);
out.push('-');
#[allow(clippy::needless_borrow)]
out.push_str(&bucket_arn.account_id());
out.push_str(".s3-accesspoint-fips.");
#[allow(clippy::needless_borrow)]
out.push_str(&bucket_arn.region());
out.push('.');
#[allow(clippy::needless_borrow)]
out.push_str(&bucket_partition.dns_suffix());
out })
.property("authSchemes", vec![::aws_smithy_types::Document::from( {
    let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
    out.insert("disableDoubleEncoding".to_string(), true.into());
    out.insert("name".to_string(), "sigv4"
    .to_string().into());
    out.insert("signingName".to_string(), "s3"
    .to_string().into());
    out.insert("signingRegion".to_string(), bucket_arn.region()
    .to_owned().into());
    out
}),])
.build());
                                                                                        }
                                                                                    }
                                                                                    if (*use_fips) == (false) {
                                                                                        if (*use_dual_stack) == (true) {
                                                                                            return Ok(::aws_smithy_types::endpoint::Endpoint::builder().url({ let mut out = String::new();
out.push_str("https://");
#[allow(clippy::needless_borrow)]
out.push_str(&access_point_name.as_ref() as &str);
out.push('-');
#[allow(clippy::needless_borrow)]
out.push_str(&bucket_arn.account_id());
out.push_str(".s3-accesspoint.dualstack.");
#[allow(clippy::needless_borrow)]
out.push_str(&bucket_arn.region());
out.push('.');
#[allow(clippy::needless_borrow)]
out.push_str(&bucket_partition.dns_suffix());
out })
.property("authSchemes", vec![::aws_smithy_types::Document::from( {
    let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
    out.insert("disableDoubleEncoding".to_string(), true.into());
    out.insert("name".to_string(), "sigv4"
    .to_string().into());
    out.insert("signingName".to_string(), "s3"
    .to_string().into());
    out.insert("signingRegion".to_string(), bucket_arn.region()
    .to_owned().into());
    out
}),])
.build());
                                                                                        }
                                                                                    }
                                                                                    if (*use_fips) == (false) {
                                                                                        if (*use_dual_stack) == (false) {
                                                                                            #[allow(unused_variables)]
                                                                                            if let Some(endpoint) = endpoint {
                                                                                                #[allow(unused_variables)]
                                                                                                if let Some(url) =
                                                                                                    crate::endpoint_lib::parse_url::parse_url(
                                                                                                        endpoint.as_ref() as &str,
                                                                                                        _diagnostic_collector,
                                                                                                    )
                                                                                                {
                                                                                                    return Ok(::aws_smithy_types::endpoint::Endpoint::builder().url({ let mut out = String::new();
#[allow(clippy::needless_borrow)]
out.push_str(&url.scheme());
out.push_str("://");
#[allow(clippy::needless_borrow)]
out.push_str(&access_point_name.as_ref() as &str);
out.push('-');
#[allow(clippy::needless_borrow)]
out.push_str(&bucket_arn.account_id());
out.push('.');
#[allow(clippy::needless_borrow)]
out.push_str(&url.authority());
#[allow(clippy::needless_borrow)]
out.push_str(&url.path());
out })
.property("authSchemes", vec![::aws_smithy_types::Document::from( {
    let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
    out.insert("disableDoubleEncoding".to_string(), true.into());
    out.insert("name".to_string(), "sigv4"
    .to_string().into());
    out.insert("signingName".to_string(), "s3"
    .to_string().into());
    out.insert("signingRegion".to_string(), bucket_arn.region()
    .to_owned().into());
    out
}),])
.build());
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                    if (*use_fips) == (false) {
                                                                                        if (*use_dual_stack) == (false) {
                                                                                            return Ok(::aws_smithy_types::endpoint::Endpoint::builder().url({ let mut out = String::new();
out.push_str("https://");
#[allow(clippy::needless_borrow)]
out.push_str(&access_point_name.as_ref() as &str);
out.push('-');
#[allow(clippy::needless_borrow)]
out.push_str(&bucket_arn.account_id());
out.push_str(".s3-accesspoint.");
#[allow(clippy::needless_borrow)]
out.push_str(&bucket_arn.region());
out.push('.');
#[allow(clippy::needless_borrow)]
out.push_str(&bucket_partition.dns_suffix());
out })
.property("authSchemes", vec![::aws_smithy_types::Document::from( {
    let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
    out.insert("disableDoubleEncoding".to_string(), true.into());
    out.insert("name".to_string(), "sigv4"
    .to_string().into());
    out.insert("signingName".to_string(), "s3"
    .to_string().into());
    out.insert("signingRegion".to_string(), bucket_arn.region()
    .to_owned().into());
    out
}),])
.build());
                                                                                        }
                                                                                    }
                                                                                    #[allow(unreachable_code)]
return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message(format!("No rules matched these parameters. This is a bug. {:?}", _params)));
                                                                                }
                                                                                return Err(
                                                                                    ::aws_smithy_http::endpoint::ResolveEndpointError::message({
                                                                                        let mut out = String::new();
                                                                                        out.push_str("Invalid ARN: The access point name may only contain a-z, A-Z, 0-9 and `-`. Found: `");
                                                                                        #[allow(clippy::needless_borrow)]
                                                                                        out.push_str(&access_point_name.as_ref() as &str);
                                                                                        out.push('`');
                                                                                        out
                                                                                    }),
                                                                                );
                                                                            }
                                                                            return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message(
                                                                                {
                                                                                    let mut out = String::new();
                                                                                    out.push_str("Invalid ARN: The account id may only contain a-z, A-Z, 0-9 and `-`. Found: `");
                                                                                    #[allow(clippy::needless_borrow)]
                                                                                    out.push_str(&bucket_arn.account_id());
                                                                                    out.push('`');
                                                                                    out
                                                                                },
                                                                            ));
                                                                        }
                                                                        return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message({
                                                                            let mut out = String::new();
                                                                            out.push_str("Invalid ARN: The ARN was not for the S3 service, found: ");
                                                                            #[allow(clippy::needless_borrow)]
                                                                            out.push_str(&bucket_arn.service());
                                                                            out
                                                                        }));
                                                                    }
                                                                    return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message({
                                                                        let mut out = String::new();
                                                                        out.push_str("Invalid region in ARN: `");
                                                                        #[allow(clippy::needless_borrow)]
                                                                        out.push_str(&bucket_arn.region());
                                                                        out.push_str("` (invalid DNS name)");
                                                                        out
                                                                    }));
                                                                }
                                                                return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message({
                                                                    let mut out = String::new();
                                                                    out.push_str("Client was configured for partition `");
                                                                    #[allow(clippy::needless_borrow)]
                                                                    out.push_str(&partition_result.name());
                                                                    out.push_str("` but ARN (`");
                                                                    #[allow(clippy::needless_borrow)]
                                                                    out.push_str(&bucket.as_ref() as &str);
                                                                    out.push_str("`) has `");
                                                                    #[allow(clippy::needless_borrow)]
                                                                    out.push_str(&bucket_partition.name());
                                                                    out.push('`');
                                                                    out
                                                                }));
                                                            }
                                                            #[allow(unreachable_code)]
                                                            return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message(format!(
                                                                "No rules matched these parameters. This is a bug. {:?}",
                                                                _params
                                                            )));
                                                        }
                                                        #[allow(unreachable_code)]
                                                        return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message(format!(
                                                            "No rules matched these parameters. This is a bug. {:?}",
                                                            _params
                                                        )));
                                                    }
                                                    return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message(
                                                        "Invalid ARN: The ARN may only contain a single resource component after `accesspoint`."
                                                            .to_string(),
                                                    ));
                                                }
                                                #[allow(unreachable_code)]
                                                return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message(format!(
                                                    "No rules matched these parameters. This is a bug. {:?}",
                                                    _params
                                                )));
                                            }
                                            #[allow(unreachable_code)]
                                            return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message(format!(
                                                "No rules matched these parameters. This is a bug. {:?}",
                                                _params
                                            )));
                                        }
                                        if crate::endpoint_lib::host::is_valid_host_label(
                                            access_point_name.as_ref() as &str,
                                            true,
                                            _diagnostic_collector,
                                        ) {
                                            if (*use_dual_stack) == (true) {
                                                return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message(
                                                    "S3 MRAP does not support dual-stack".to_string(),
                                                ));
                                            }
                                            if (*use_fips) == (true) {
                                                return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message(
                                                    "S3 MRAP does not support FIPS".to_string(),
                                                ));
                                            }
                                            if (*accelerate) == (true) {
                                                return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message(
                                                    "S3 MRAP does not support S3 Accelerate".to_string(),
                                                ));
                                            }
                                            if (*disable_multi_region_access_points) == (true) {
                                                return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message(
                                                    "Invalid configuration: Multi-Region Access Point ARNs are disabled.".to_string(),
                                                ));
                                            }
                                            #[allow(unused_variables)]
                                            if let Some(mrap_partition) =
                                                partition_resolver.resolve_partition(region.as_ref() as &str, _diagnostic_collector)
                                            {
                                                if (mrap_partition.name()) == (bucket_arn.partition()) {
                                                    return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                                        .url({
                                                            let mut out = String::new();
                                                            out.push_str("https://");
                                                            #[allow(clippy::needless_borrow)]
                                                            out.push_str(&access_point_name.as_ref() as &str);
                                                            out.push_str(".accesspoint.s3-global.");
                                                            #[allow(clippy::needless_borrow)]
                                                            out.push_str(&mrap_partition.dns_suffix());
                                                            out
                                                        })
                                                        .property(
                                                            "authSchemes",
                                                            vec![::aws_smithy_types::Document::from({
                                                                let mut out =
                                                                    ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                                out.insert("disableDoubleEncoding".to_string(), true.into());
                                                                out.insert("name".to_string(), "sigv4a".to_string().into());
                                                                out.insert("signingName".to_string(), "s3".to_string().into());
                                                                out.insert(
                                                                    "signingRegionSet".to_string(),
                                                                    vec![::aws_smithy_types::Document::from("*".to_string())].into(),
                                                                );
                                                                out
                                                            })],
                                                        )
                                                        .build());
                                                }
                                                return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message({
                                                    let mut out = String::new();
                                                    out.push_str("Client was configured for partition `");
                                                    #[allow(clippy::needless_borrow)]
                                                    out.push_str(&mrap_partition.name());
                                                    out.push_str("` but bucket referred to partition `");
                                                    #[allow(clippy::needless_borrow)]
                                                    out.push_str(&bucket_arn.partition());
                                                    out.push('`');
                                                    out
                                                }));
                                            }
                                            #[allow(unreachable_code)]
                                            return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message(format!(
                                                "No rules matched these parameters. This is a bug. {:?}",
                                                _params
                                            )));
                                        }
                                        return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message(
                                            "Invalid Access Point Name".to_string(),
                                        ));
                                    }
                                }
                                return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message(
                                    "Invalid ARN: Expected a resource of the format `accesspoint:<accesspoint name>` but no name was provided"
                                        .to_string(),
                                ));
                            }
                            if (bucket_arn.service()) == ("s3-outposts") {
                                if (*use_dual_stack) == (true) {
                                    return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message(
                                        "S3 Outposts does not support Dual-stack".to_string(),
                                    ));
                                }
                                if (*use_fips) == (true) {
                                    return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message(
                                        "S3 Outposts does not support FIPS".to_string(),
                                    ));
                                }
                                if (*accelerate) == (true) {
                                    return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message(
                                        "S3 Outposts does not support S3 Accelerate".to_string(),
                                    ));
                                }
                                #[allow(unused_variables)]
                                if let Some(_) = bucket_arn.resource_id().get(4).cloned() {
                                    return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message(
                                        "Invalid Arn: Outpost Access Point ARN contains sub resources".to_string(),
                                    ));
                                }
                                #[allow(unused_variables)]
                                if let Some(outpost_id) = bucket_arn.resource_id().get(1).cloned() {
                                    if crate::endpoint_lib::host::is_valid_host_label(outpost_id.as_ref() as &str, false, _diagnostic_collector) {
                                        #[allow(unused_variables)]
                                        if let Some(use_arn_region) = use_arn_region {
                                            if (*use_arn_region) == (false) {
                                                if !((bucket_arn.region()) == (region.as_ref() as &str)) {
                                                    return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message({
                                                        let mut out = String::new();
                                                        out.push_str("Invalid configuration: region from ARN `");
                                                        #[allow(clippy::needless_borrow)]
                                                        out.push_str(&bucket_arn.region());
                                                        out.push_str("` does not match client region `");
                                                        #[allow(clippy::needless_borrow)]
                                                        out.push_str(&region.as_ref() as &str);
                                                        out.push_str("` and UseArnRegion is `false`");
                                                        out
                                                    }));
                                                }
                                            }
                                        }
                                        #[allow(unused_variables)]
                                        if let Some(bucket_partition) =
                                            partition_resolver.resolve_partition(bucket_arn.region(), _diagnostic_collector)
                                        {
                                            #[allow(unused_variables)]
                                            if let Some(partition_result) =
                                                partition_resolver.resolve_partition(region.as_ref() as &str, _diagnostic_collector)
                                            {
                                                if (bucket_partition.name()) == (partition_result.name()) {
                                                    if crate::endpoint_lib::host::is_valid_host_label(
                                                        bucket_arn.region(),
                                                        true,
                                                        _diagnostic_collector,
                                                    ) {
                                                        if crate::endpoint_lib::host::is_valid_host_label(
                                                            bucket_arn.account_id(),
                                                            false,
                                                            _diagnostic_collector,
                                                        ) {
                                                            #[allow(unused_variables)]
                                                            if let Some(outpost_type) = bucket_arn.resource_id().get(2).cloned() {
                                                                #[allow(unused_variables)]
                                                                if let Some(access_point_name) = bucket_arn.resource_id().get(3).cloned() {
                                                                    if (outpost_type.as_ref() as &str) == ("accesspoint") {
                                                                        #[allow(unused_variables)]
                                                                        if let Some(endpoint) = endpoint {
                                                                            #[allow(unused_variables)]
                                                                            if let Some(url) = crate::endpoint_lib::parse_url::parse_url(
                                                                                endpoint.as_ref() as &str,
                                                                                _diagnostic_collector,
                                                                            ) {
                                                                                return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                                                                    .url({
                                                                                        let mut out = String::new();
                                                                                        out.push_str("https://");
                                                                                        #[allow(clippy::needless_borrow)]
                                                                                        out.push_str(&access_point_name.as_ref() as &str);
                                                                                        out.push('-');
                                                                                        #[allow(clippy::needless_borrow)]
                                                                                        out.push_str(&bucket_arn.account_id());
                                                                                        out.push('.');
                                                                                        #[allow(clippy::needless_borrow)]
                                                                                        out.push_str(&outpost_id.as_ref() as &str);
                                                                                        out.push('.');
                                                                                        #[allow(clippy::needless_borrow)]
                                                                                        out.push_str(&url.authority());
                                                                                        out
                                                                                    })
                                                                                    .property(
                                                                                        "authSchemes",
                                                                                        vec![
                                                                                            ::aws_smithy_types::Document::from({
                                                                                                let mut out = ::std::collections::HashMap::<
                                                                                                    String,
                                                                                                    ::aws_smithy_types::Document,
                                                                                                >::new(
                                                                                                );
                                                                                                out.insert(
                                                                                                    "disableDoubleEncoding".to_string(),
                                                                                                    true.into(),
                                                                                                );
                                                                                                out.insert(
                                                                                                    "name".to_string(),
                                                                                                    "sigv4a".to_string().into(),
                                                                                                );
                                                                                                out.insert(
                                                                                                    "signingName".to_string(),
                                                                                                    "s3-outposts".to_string().into(),
                                                                                                );
                                                                                                out.insert(
                                                                                                    "signingRegionSet".to_string(),
                                                                                                    vec![::aws_smithy_types::Document::from(
                                                                                                        "*".to_string(),
                                                                                                    )]
                                                                                                    .into(),
                                                                                                );
                                                                                                out
                                                                                            }),
                                                                                            ::aws_smithy_types::Document::from({
                                                                                                let mut out = ::std::collections::HashMap::<
                                                                                                    String,
                                                                                                    ::aws_smithy_types::Document,
                                                                                                >::new(
                                                                                                );
                                                                                                out.insert(
                                                                                                    "disableDoubleEncoding".to_string(),
                                                                                                    true.into(),
                                                                                                );
                                                                                                out.insert(
                                                                                                    "name".to_string(),
                                                                                                    "sigv4".to_string().into(),
                                                                                                );
                                                                                                out.insert(
                                                                                                    "signingName".to_string(),
                                                                                                    "s3-outposts".to_string().into(),
                                                                                                );
                                                                                                out.insert(
                                                                                                    "signingRegion".to_string(),
                                                                                                    bucket_arn.region().to_owned().into(),
                                                                                                );
                                                                                                out
                                                                                            }),
                                                                                        ],
                                                                                    )
                                                                                    .build());
                                                                            }
                                                                        }
                                                                        return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                                                            .url({
                                                                                let mut out = String::new();
                                                                                out.push_str("https://");
                                                                                #[allow(clippy::needless_borrow)]
                                                                                out.push_str(&access_point_name.as_ref() as &str);
                                                                                out.push('-');
                                                                                #[allow(clippy::needless_borrow)]
                                                                                out.push_str(&bucket_arn.account_id());
                                                                                out.push('.');
                                                                                #[allow(clippy::needless_borrow)]
                                                                                out.push_str(&outpost_id.as_ref() as &str);
                                                                                out.push_str(".s3-outposts.");
                                                                                #[allow(clippy::needless_borrow)]
                                                                                out.push_str(&bucket_arn.region());
                                                                                out.push('.');
                                                                                #[allow(clippy::needless_borrow)]
                                                                                out.push_str(&bucket_partition.dns_suffix());
                                                                                out
                                                                            })
                                                                            .property(
                                                                                "authSchemes",
                                                                                vec![
                                                                                    ::aws_smithy_types::Document::from({
                                                                                        let mut out = ::std::collections::HashMap::<
                                                                                            String,
                                                                                            ::aws_smithy_types::Document,
                                                                                        >::new(
                                                                                        );
                                                                                        out.insert("disableDoubleEncoding".to_string(), true.into());
                                                                                        out.insert("name".to_string(), "sigv4a".to_string().into());
                                                                                        out.insert(
                                                                                            "signingName".to_string(),
                                                                                            "s3-outposts".to_string().into(),
                                                                                        );
                                                                                        out.insert(
                                                                                            "signingRegionSet".to_string(),
                                                                                            vec![::aws_smithy_types::Document::from("*".to_string())]
                                                                                                .into(),
                                                                                        );
                                                                                        out
                                                                                    }),
                                                                                    ::aws_smithy_types::Document::from({
                                                                                        let mut out = ::std::collections::HashMap::<
                                                                                            String,
                                                                                            ::aws_smithy_types::Document,
                                                                                        >::new(
                                                                                        );
                                                                                        out.insert("disableDoubleEncoding".to_string(), true.into());
                                                                                        out.insert("name".to_string(), "sigv4".to_string().into());
                                                                                        out.insert(
                                                                                            "signingName".to_string(),
                                                                                            "s3-outposts".to_string().into(),
                                                                                        );
                                                                                        out.insert(
                                                                                            "signingRegion".to_string(),
                                                                                            bucket_arn.region().to_owned().into(),
                                                                                        );
                                                                                        out
                                                                                    }),
                                                                                ],
                                                                            )
                                                                            .build());
                                                                    }
                                                                    return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message({
                                                                        let mut out = String::new();
                                                                        out.push_str("Expected an outpost type `accesspoint`, found ");
                                                                        #[allow(clippy::needless_borrow)]
                                                                        out.push_str(&outpost_type.as_ref() as &str);
                                                                        out
                                                                    }));
                                                                }
                                                                return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message(
                                                                    "Invalid ARN: expected an access point name".to_string(),
                                                                ));
                                                            }
                                                            return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message(
                                                                "Invalid ARN: Expected a 4-component resource".to_string(),
                                                            ));
                                                        }
                                                        return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message({
                                                            let mut out = String::new();
                                                            out.push_str(
                                                                "Invalid ARN: The account id may only contain a-z, A-Z, 0-9 and `-`. Found: `",
                                                            );
                                                            #[allow(clippy::needless_borrow)]
                                                            out.push_str(&bucket_arn.account_id());
                                                            out.push('`');
                                                            out
                                                        }));
                                                    }
                                                    return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message({
                                                        let mut out = String::new();
                                                        out.push_str("Invalid region in ARN: `");
                                                        #[allow(clippy::needless_borrow)]
                                                        out.push_str(&bucket_arn.region());
                                                        out.push_str("` (invalid DNS name)");
                                                        out
                                                    }));
                                                }
                                                return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message({
                                                    let mut out = String::new();
                                                    out.push_str("Client was configured for partition `");
                                                    #[allow(clippy::needless_borrow)]
                                                    out.push_str(&partition_result.name());
                                                    out.push_str("` but ARN (`");
                                                    #[allow(clippy::needless_borrow)]
                                                    out.push_str(&bucket.as_ref() as &str);
                                                    out.push_str("`) has `");
                                                    #[allow(clippy::needless_borrow)]
                                                    out.push_str(&bucket_partition.name());
                                                    out.push('`');
                                                    out
                                                }));
                                            }
                                            #[allow(unreachable_code)]
                                            return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message(format!(
                                                "No rules matched these parameters. This is a bug. {:?}",
                                                _params
                                            )));
                                        }
                                        #[allow(unreachable_code)]
                                        return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message(format!(
                                            "No rules matched these parameters. This is a bug. {:?}",
                                            _params
                                        )));
                                    }
                                    return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message({
                                        let mut out = String::new();
                                        out.push_str("Invalid ARN: The outpost Id may only contain a-z, A-Z, 0-9 and `-`. Found: `");
                                        #[allow(clippy::needless_borrow)]
                                        out.push_str(&outpost_id.as_ref() as &str);
                                        out.push('`');
                                        out
                                    }));
                                }
                                return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message(
                                    "Invalid ARN: The Outpost Id was not set".to_string(),
                                ));
                            }
                            return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message({
                                let mut out = String::new();
                                out.push_str("Invalid ARN: Unrecognized format: ");
                                #[allow(clippy::needless_borrow)]
                                out.push_str(&bucket.as_ref() as &str);
                                out.push_str(" (type: ");
                                #[allow(clippy::needless_borrow)]
                                out.push_str(&arn_type.as_ref() as &str);
                                out.push(')');
                                out
                            }));
                        }
                    }
                    return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message(
                        "Invalid ARN: No ARN type specified".to_string(),
                    ));
                }
            }
            #[allow(unused_variables)]
            if let Some(arn_prefix) = crate::endpoint_lib::substring::substring(bucket.as_ref() as &str, 0, 4, false, _diagnostic_collector) {
                if (arn_prefix.as_ref() as &str) == ("arn:") {
                    if !(crate::endpoint_lib::arn::parse_arn(bucket.as_ref() as &str, _diagnostic_collector).is_some()) {
                        return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message({
                            let mut out = String::new();
                            out.push_str("Invalid ARN: `");
                            #[allow(clippy::needless_borrow)]
                            out.push_str(&bucket.as_ref() as &str);
                            out.push_str("` was not a valid ARN");
                            out
                        }));
                    }
                }
            }
            if (*force_path_style) == (true) {
                #[allow(unused_variables)]
                if let Some(_) = crate::endpoint_lib::arn::parse_arn(bucket.as_ref() as &str, _diagnostic_collector) {
                    return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message(
                        "Path-style addressing cannot be used with ARN buckets".to_string(),
                    ));
                }
            }
            let uri_encoded_bucket = crate::endpoint_lib::uri_encode::uri_encode(bucket.as_ref() as &str, _diagnostic_collector);
            #[allow(unused_variables)]
            if let Some(partition_result) = partition_resolver.resolve_partition(region.as_ref() as &str, _diagnostic_collector) {
                if (*accelerate) == (false) {
                    if (*use_dual_stack) == (true) {
                        if !(endpoint.is_some()) {
                            if (*use_fips) == (true) {
                                if (region.as_ref() as &str) == ("aws-global") {
                                    return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                        .url({
                                            let mut out = String::new();
                                            out.push_str("https://s3-fips.dualstack.us-east-1.");
                                            #[allow(clippy::needless_borrow)]
                                            out.push_str(&partition_result.dns_suffix());
                                            out.push('/');
                                            #[allow(clippy::needless_borrow)]
                                            out.push_str(&uri_encoded_bucket.as_ref() as &str);
                                            out
                                        })
                                        .property(
                                            "authSchemes",
                                            vec![::aws_smithy_types::Document::from({
                                                let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                out.insert("disableDoubleEncoding".to_string(), true.into());
                                                out.insert("name".to_string(), "sigv4".to_string().into());
                                                out.insert("signingName".to_string(), "s3".to_string().into());
                                                out.insert("signingRegion".to_string(), "us-east-1".to_string().into());
                                                out
                                            })],
                                        )
                                        .build());
                                }
                            }
                        }
                    }
                    if (*use_dual_stack) == (true) {
                        if !(endpoint.is_some()) {
                            if (*use_fips) == (true) {
                                if !((region.as_ref() as &str) == ("aws-global")) {
                                    if (*use_global_endpoint) == (true) {
                                        return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                            .url({
                                                let mut out = String::new();
                                                out.push_str("https://s3-fips.dualstack.");
                                                #[allow(clippy::needless_borrow)]
                                                out.push_str(&region.as_ref() as &str);
                                                out.push('.');
                                                #[allow(clippy::needless_borrow)]
                                                out.push_str(&partition_result.dns_suffix());
                                                out.push('/');
                                                #[allow(clippy::needless_borrow)]
                                                out.push_str(&uri_encoded_bucket.as_ref() as &str);
                                                out
                                            })
                                            .property(
                                                "authSchemes",
                                                vec![::aws_smithy_types::Document::from({
                                                    let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                    out.insert("disableDoubleEncoding".to_string(), true.into());
                                                    out.insert("name".to_string(), "sigv4".to_string().into());
                                                    out.insert("signingName".to_string(), "s3".to_string().into());
                                                    out.insert("signingRegion".to_string(), region.to_owned().into());
                                                    out
                                                })],
                                            )
                                            .build());
                                    }
                                }
                            }
                        }
                    }
                    if (*use_dual_stack) == (true) {
                        if !(endpoint.is_some()) {
                            if (*use_fips) == (true) {
                                if !((region.as_ref() as &str) == ("aws-global")) {
                                    if (*use_global_endpoint) == (false) {
                                        return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                            .url({
                                                let mut out = String::new();
                                                out.push_str("https://s3-fips.dualstack.");
                                                #[allow(clippy::needless_borrow)]
                                                out.push_str(&region.as_ref() as &str);
                                                out.push('.');
                                                #[allow(clippy::needless_borrow)]
                                                out.push_str(&partition_result.dns_suffix());
                                                out.push('/');
                                                #[allow(clippy::needless_borrow)]
                                                out.push_str(&uri_encoded_bucket.as_ref() as &str);
                                                out
                                            })
                                            .property(
                                                "authSchemes",
                                                vec![::aws_smithy_types::Document::from({
                                                    let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                    out.insert("disableDoubleEncoding".to_string(), true.into());
                                                    out.insert("name".to_string(), "sigv4".to_string().into());
                                                    out.insert("signingName".to_string(), "s3".to_string().into());
                                                    out.insert("signingRegion".to_string(), region.to_owned().into());
                                                    out
                                                })],
                                            )
                                            .build());
                                    }
                                }
                            }
                        }
                    }
                    if (*use_dual_stack) == (false) {
                        if !(endpoint.is_some()) {
                            if (*use_fips) == (true) {
                                if (region.as_ref() as &str) == ("aws-global") {
                                    return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                        .url({
                                            let mut out = String::new();
                                            out.push_str("https://s3-fips.us-east-1.");
                                            #[allow(clippy::needless_borrow)]
                                            out.push_str(&partition_result.dns_suffix());
                                            out.push('/');
                                            #[allow(clippy::needless_borrow)]
                                            out.push_str(&uri_encoded_bucket.as_ref() as &str);
                                            out
                                        })
                                        .property(
                                            "authSchemes",
                                            vec![::aws_smithy_types::Document::from({
                                                let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                out.insert("disableDoubleEncoding".to_string(), true.into());
                                                out.insert("name".to_string(), "sigv4".to_string().into());
                                                out.insert("signingName".to_string(), "s3".to_string().into());
                                                out.insert("signingRegion".to_string(), "us-east-1".to_string().into());
                                                out
                                            })],
                                        )
                                        .build());
                                }
                            }
                        }
                    }
                    if (*use_dual_stack) == (false) {
                        if !(endpoint.is_some()) {
                            if (*use_fips) == (true) {
                                if !((region.as_ref() as &str) == ("aws-global")) {
                                    if (*use_global_endpoint) == (true) {
                                        return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                            .url({
                                                let mut out = String::new();
                                                out.push_str("https://s3-fips.");
                                                #[allow(clippy::needless_borrow)]
                                                out.push_str(&region.as_ref() as &str);
                                                out.push('.');
                                                #[allow(clippy::needless_borrow)]
                                                out.push_str(&partition_result.dns_suffix());
                                                out.push('/');
                                                #[allow(clippy::needless_borrow)]
                                                out.push_str(&uri_encoded_bucket.as_ref() as &str);
                                                out
                                            })
                                            .property(
                                                "authSchemes",
                                                vec![::aws_smithy_types::Document::from({
                                                    let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                    out.insert("disableDoubleEncoding".to_string(), true.into());
                                                    out.insert("name".to_string(), "sigv4".to_string().into());
                                                    out.insert("signingName".to_string(), "s3".to_string().into());
                                                    out.insert("signingRegion".to_string(), region.to_owned().into());
                                                    out
                                                })],
                                            )
                                            .build());
                                    }
                                }
                            }
                        }
                    }
                    if (*use_dual_stack) == (false) {
                        if !(endpoint.is_some()) {
                            if (*use_fips) == (true) {
                                if !((region.as_ref() as &str) == ("aws-global")) {
                                    if (*use_global_endpoint) == (false) {
                                        return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                            .url({
                                                let mut out = String::new();
                                                out.push_str("https://s3-fips.");
                                                #[allow(clippy::needless_borrow)]
                                                out.push_str(&region.as_ref() as &str);
                                                out.push('.');
                                                #[allow(clippy::needless_borrow)]
                                                out.push_str(&partition_result.dns_suffix());
                                                out.push('/');
                                                #[allow(clippy::needless_borrow)]
                                                out.push_str(&uri_encoded_bucket.as_ref() as &str);
                                                out
                                            })
                                            .property(
                                                "authSchemes",
                                                vec![::aws_smithy_types::Document::from({
                                                    let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                    out.insert("disableDoubleEncoding".to_string(), true.into());
                                                    out.insert("name".to_string(), "sigv4".to_string().into());
                                                    out.insert("signingName".to_string(), "s3".to_string().into());
                                                    out.insert("signingRegion".to_string(), region.to_owned().into());
                                                    out
                                                })],
                                            )
                                            .build());
                                    }
                                }
                            }
                        }
                    }
                    if (*use_dual_stack) == (true) {
                        if !(endpoint.is_some()) {
                            if (*use_fips) == (false) {
                                if (region.as_ref() as &str) == ("aws-global") {
                                    return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                        .url({
                                            let mut out = String::new();
                                            out.push_str("https://s3.dualstack.us-east-1.");
                                            #[allow(clippy::needless_borrow)]
                                            out.push_str(&partition_result.dns_suffix());
                                            out.push('/');
                                            #[allow(clippy::needless_borrow)]
                                            out.push_str(&uri_encoded_bucket.as_ref() as &str);
                                            out
                                        })
                                        .property(
                                            "authSchemes",
                                            vec![::aws_smithy_types::Document::from({
                                                let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                out.insert("disableDoubleEncoding".to_string(), true.into());
                                                out.insert("name".to_string(), "sigv4".to_string().into());
                                                out.insert("signingName".to_string(), "s3".to_string().into());
                                                out.insert("signingRegion".to_string(), "us-east-1".to_string().into());
                                                out
                                            })],
                                        )
                                        .build());
                                }
                            }
                        }
                    }
                    if (*use_dual_stack) == (true) {
                        if !(endpoint.is_some()) {
                            if (*use_fips) == (false) {
                                if !((region.as_ref() as &str) == ("aws-global")) {
                                    if (*use_global_endpoint) == (true) {
                                        return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                            .url({
                                                let mut out = String::new();
                                                out.push_str("https://s3.dualstack.");
                                                #[allow(clippy::needless_borrow)]
                                                out.push_str(&region.as_ref() as &str);
                                                out.push('.');
                                                #[allow(clippy::needless_borrow)]
                                                out.push_str(&partition_result.dns_suffix());
                                                out.push('/');
                                                #[allow(clippy::needless_borrow)]
                                                out.push_str(&uri_encoded_bucket.as_ref() as &str);
                                                out
                                            })
                                            .property(
                                                "authSchemes",
                                                vec![::aws_smithy_types::Document::from({
                                                    let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                    out.insert("disableDoubleEncoding".to_string(), true.into());
                                                    out.insert("name".to_string(), "sigv4".to_string().into());
                                                    out.insert("signingName".to_string(), "s3".to_string().into());
                                                    out.insert("signingRegion".to_string(), region.to_owned().into());
                                                    out
                                                })],
                                            )
                                            .build());
                                    }
                                }
                            }
                        }
                    }
                    if (*use_dual_stack) == (true) {
                        if !(endpoint.is_some()) {
                            if (*use_fips) == (false) {
                                if !((region.as_ref() as &str) == ("aws-global")) {
                                    if (*use_global_endpoint) == (false) {
                                        return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                            .url({
                                                let mut out = String::new();
                                                out.push_str("https://s3.dualstack.");
                                                #[allow(clippy::needless_borrow)]
                                                out.push_str(&region.as_ref() as &str);
                                                out.push('.');
                                                #[allow(clippy::needless_borrow)]
                                                out.push_str(&partition_result.dns_suffix());
                                                out.push('/');
                                                #[allow(clippy::needless_borrow)]
                                                out.push_str(&uri_encoded_bucket.as_ref() as &str);
                                                out
                                            })
                                            .property(
                                                "authSchemes",
                                                vec![::aws_smithy_types::Document::from({
                                                    let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                    out.insert("disableDoubleEncoding".to_string(), true.into());
                                                    out.insert("name".to_string(), "sigv4".to_string().into());
                                                    out.insert("signingName".to_string(), "s3".to_string().into());
                                                    out.insert("signingRegion".to_string(), region.to_owned().into());
                                                    out
                                                })],
                                            )
                                            .build());
                                    }
                                }
                            }
                        }
                    }
                    if (*use_dual_stack) == (false) {
                        #[allow(unused_variables)]
                        if let Some(endpoint) = endpoint {
                            #[allow(unused_variables)]
                            if let Some(url) = crate::endpoint_lib::parse_url::parse_url(endpoint.as_ref() as &str, _diagnostic_collector) {
                                if (*use_fips) == (false) {
                                    if (region.as_ref() as &str) == ("aws-global") {
                                        return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                            .url({
                                                let mut out = String::new();
                                                #[allow(clippy::needless_borrow)]
                                                out.push_str(&url.scheme());
                                                out.push_str("://");
                                                #[allow(clippy::needless_borrow)]
                                                out.push_str(&url.authority());
                                                #[allow(clippy::needless_borrow)]
                                                out.push_str(&url.normalized_path());
                                                #[allow(clippy::needless_borrow)]
                                                out.push_str(&uri_encoded_bucket.as_ref() as &str);
                                                out
                                            })
                                            .property(
                                                "authSchemes",
                                                vec![::aws_smithy_types::Document::from({
                                                    let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                    out.insert("disableDoubleEncoding".to_string(), true.into());
                                                    out.insert("name".to_string(), "sigv4".to_string().into());
                                                    out.insert("signingName".to_string(), "s3".to_string().into());
                                                    out.insert("signingRegion".to_string(), "us-east-1".to_string().into());
                                                    out
                                                })],
                                            )
                                            .build());
                                    }
                                }
                            }
                        }
                    }
                    if (*use_dual_stack) == (false) {
                        #[allow(unused_variables)]
                        if let Some(endpoint) = endpoint {
                            #[allow(unused_variables)]
                            if let Some(url) = crate::endpoint_lib::parse_url::parse_url(endpoint.as_ref() as &str, _diagnostic_collector) {
                                if (*use_fips) == (false) {
                                    if !((region.as_ref() as &str) == ("aws-global")) {
                                        if (*use_global_endpoint) == (true) {
                                            if (region.as_ref() as &str) == ("us-east-1") {
                                                return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                                    .url({
                                                        let mut out = String::new();
                                                        #[allow(clippy::needless_borrow)]
                                                        out.push_str(&url.scheme());
                                                        out.push_str("://");
                                                        #[allow(clippy::needless_borrow)]
                                                        out.push_str(&url.authority());
                                                        #[allow(clippy::needless_borrow)]
                                                        out.push_str(&url.normalized_path());
                                                        #[allow(clippy::needless_borrow)]
                                                        out.push_str(&uri_encoded_bucket.as_ref() as &str);
                                                        out
                                                    })
                                                    .property(
                                                        "authSchemes",
                                                        vec![::aws_smithy_types::Document::from({
                                                            let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                            out.insert("disableDoubleEncoding".to_string(), true.into());
                                                            out.insert("name".to_string(), "sigv4".to_string().into());
                                                            out.insert("signingName".to_string(), "s3".to_string().into());
                                                            out.insert("signingRegion".to_string(), region.to_owned().into());
                                                            out
                                                        })],
                                                    )
                                                    .build());
                                            }
                                            return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                                .url({
                                                    let mut out = String::new();
                                                    #[allow(clippy::needless_borrow)]
                                                    out.push_str(&url.scheme());
                                                    out.push_str("://");
                                                    #[allow(clippy::needless_borrow)]
                                                    out.push_str(&url.authority());
                                                    #[allow(clippy::needless_borrow)]
                                                    out.push_str(&url.normalized_path());
                                                    #[allow(clippy::needless_borrow)]
                                                    out.push_str(&uri_encoded_bucket.as_ref() as &str);
                                                    out
                                                })
                                                .property(
                                                    "authSchemes",
                                                    vec![::aws_smithy_types::Document::from({
                                                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                        out.insert("disableDoubleEncoding".to_string(), true.into());
                                                        out.insert("name".to_string(), "sigv4".to_string().into());
                                                        out.insert("signingName".to_string(), "s3".to_string().into());
                                                        out.insert("signingRegion".to_string(), region.to_owned().into());
                                                        out
                                                    })],
                                                )
                                                .build());
                                        }
                                    }
                                }
                            }
                        }
                    }
                    if (*use_dual_stack) == (false) {
                        #[allow(unused_variables)]
                        if let Some(endpoint) = endpoint {
                            #[allow(unused_variables)]
                            if let Some(url) = crate::endpoint_lib::parse_url::parse_url(endpoint.as_ref() as &str, _diagnostic_collector) {
                                if (*use_fips) == (false) {
                                    if !((region.as_ref() as &str) == ("aws-global")) {
                                        if (*use_global_endpoint) == (false) {
                                            return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                                .url({
                                                    let mut out = String::new();
                                                    #[allow(clippy::needless_borrow)]
                                                    out.push_str(&url.scheme());
                                                    out.push_str("://");
                                                    #[allow(clippy::needless_borrow)]
                                                    out.push_str(&url.authority());
                                                    #[allow(clippy::needless_borrow)]
                                                    out.push_str(&url.normalized_path());
                                                    #[allow(clippy::needless_borrow)]
                                                    out.push_str(&uri_encoded_bucket.as_ref() as &str);
                                                    out
                                                })
                                                .property(
                                                    "authSchemes",
                                                    vec![::aws_smithy_types::Document::from({
                                                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                        out.insert("disableDoubleEncoding".to_string(), true.into());
                                                        out.insert("name".to_string(), "sigv4".to_string().into());
                                                        out.insert("signingName".to_string(), "s3".to_string().into());
                                                        out.insert("signingRegion".to_string(), region.to_owned().into());
                                                        out
                                                    })],
                                                )
                                                .build());
                                        }
                                    }
                                }
                            }
                        }
                    }
                    if (*use_dual_stack) == (false) {
                        if !(endpoint.is_some()) {
                            if (*use_fips) == (false) {
                                if (region.as_ref() as &str) == ("aws-global") {
                                    return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                        .url({
                                            let mut out = String::new();
                                            out.push_str("https://s3.");
                                            #[allow(clippy::needless_borrow)]
                                            out.push_str(&partition_result.dns_suffix());
                                            out.push('/');
                                            #[allow(clippy::needless_borrow)]
                                            out.push_str(&uri_encoded_bucket.as_ref() as &str);
                                            out
                                        })
                                        .property(
                                            "authSchemes",
                                            vec![::aws_smithy_types::Document::from({
                                                let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                out.insert("disableDoubleEncoding".to_string(), true.into());
                                                out.insert("name".to_string(), "sigv4".to_string().into());
                                                out.insert("signingName".to_string(), "s3".to_string().into());
                                                out.insert("signingRegion".to_string(), "us-east-1".to_string().into());
                                                out
                                            })],
                                        )
                                        .build());
                                }
                            }
                        }
                    }
                    if (*use_dual_stack) == (false) {
                        if !(endpoint.is_some()) {
                            if (*use_fips) == (false) {
                                if !((region.as_ref() as &str) == ("aws-global")) {
                                    if (*use_global_endpoint) == (true) {
                                        if (region.as_ref() as &str) == ("us-east-1") {
                                            return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                                .url({
                                                    let mut out = String::new();
                                                    out.push_str("https://s3.");
                                                    #[allow(clippy::needless_borrow)]
                                                    out.push_str(&partition_result.dns_suffix());
                                                    out.push('/');
                                                    #[allow(clippy::needless_borrow)]
                                                    out.push_str(&uri_encoded_bucket.as_ref() as &str);
                                                    out
                                                })
                                                .property(
                                                    "authSchemes",
                                                    vec![::aws_smithy_types::Document::from({
                                                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                        out.insert("disableDoubleEncoding".to_string(), true.into());
                                                        out.insert("name".to_string(), "sigv4".to_string().into());
                                                        out.insert("signingName".to_string(), "s3".to_string().into());
                                                        out.insert("signingRegion".to_string(), region.to_owned().into());
                                                        out
                                                    })],
                                                )
                                                .build());
                                        }
                                        return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                            .url({
                                                let mut out = String::new();
                                                out.push_str("https://s3.");
                                                #[allow(clippy::needless_borrow)]
                                                out.push_str(&region.as_ref() as &str);
                                                out.push('.');
                                                #[allow(clippy::needless_borrow)]
                                                out.push_str(&partition_result.dns_suffix());
                                                out.push('/');
                                                #[allow(clippy::needless_borrow)]
                                                out.push_str(&uri_encoded_bucket.as_ref() as &str);
                                                out
                                            })
                                            .property(
                                                "authSchemes",
                                                vec![::aws_smithy_types::Document::from({
                                                    let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                    out.insert("disableDoubleEncoding".to_string(), true.into());
                                                    out.insert("name".to_string(), "sigv4".to_string().into());
                                                    out.insert("signingName".to_string(), "s3".to_string().into());
                                                    out.insert("signingRegion".to_string(), region.to_owned().into());
                                                    out
                                                })],
                                            )
                                            .build());
                                    }
                                }
                            }
                        }
                    }
                    if (*use_dual_stack) == (false) {
                        if !(endpoint.is_some()) {
                            if (*use_fips) == (false) {
                                if !((region.as_ref() as &str) == ("aws-global")) {
                                    if (*use_global_endpoint) == (false) {
                                        return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                            .url({
                                                let mut out = String::new();
                                                out.push_str("https://s3.");
                                                #[allow(clippy::needless_borrow)]
                                                out.push_str(&region.as_ref() as &str);
                                                out.push('.');
                                                #[allow(clippy::needless_borrow)]
                                                out.push_str(&partition_result.dns_suffix());
                                                out.push('/');
                                                #[allow(clippy::needless_borrow)]
                                                out.push_str(&uri_encoded_bucket.as_ref() as &str);
                                                out
                                            })
                                            .property(
                                                "authSchemes",
                                                vec![::aws_smithy_types::Document::from({
                                                    let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                    out.insert("disableDoubleEncoding".to_string(), true.into());
                                                    out.insert("name".to_string(), "sigv4".to_string().into());
                                                    out.insert("signingName".to_string(), "s3".to_string().into());
                                                    out.insert("signingRegion".to_string(), region.to_owned().into());
                                                    out
                                                })],
                                            )
                                            .build());
                                    }
                                }
                            }
                        }
                    }
                    #[allow(unreachable_code)]
                    return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message(format!(
                        "No rules matched these parameters. This is a bug. {:?}",
                        _params
                    )));
                }
                return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message(
                    "Path-style addressing cannot be used with S3 Accelerate".to_string(),
                ));
            }
            #[allow(unreachable_code)]
            return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message(format!(
                "No rules matched these parameters. This is a bug. {:?}",
                _params
            )));
        }
        #[allow(unused_variables)]
        if let Some(use_object_lambda_endpoint) = use_object_lambda_endpoint {
            if (*use_object_lambda_endpoint) == (true) {
                #[allow(unused_variables)]
                if let Some(partition_result) = partition_resolver.resolve_partition(region.as_ref() as &str, _diagnostic_collector) {
                    if crate::endpoint_lib::host::is_valid_host_label(region.as_ref() as &str, true, _diagnostic_collector) {
                        if (*use_dual_stack) == (true) {
                            return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message(
                                "S3 Object Lambda does not support Dual-stack".to_string(),
                            ));
                        }
                        if (*accelerate) == (true) {
                            return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message(
                                "S3 Object Lambda does not support S3 Accelerate".to_string(),
                            ));
                        }
                        #[allow(unused_variables)]
                        if let Some(endpoint) = endpoint {
                            #[allow(unused_variables)]
                            if let Some(url) = crate::endpoint_lib::parse_url::parse_url(endpoint.as_ref() as &str, _diagnostic_collector) {
                                return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                    .url({
                                        let mut out = String::new();
                                        #[allow(clippy::needless_borrow)]
                                        out.push_str(&url.scheme());
                                        out.push_str("://");
                                        #[allow(clippy::needless_borrow)]
                                        out.push_str(&url.authority());
                                        #[allow(clippy::needless_borrow)]
                                        out.push_str(&url.path());
                                        out
                                    })
                                    .property(
                                        "authSchemes",
                                        vec![::aws_smithy_types::Document::from({
                                            let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                            out.insert("disableDoubleEncoding".to_string(), true.into());
                                            out.insert("name".to_string(), "sigv4".to_string().into());
                                            out.insert("signingName".to_string(), "s3-object-lambda".to_string().into());
                                            out.insert("signingRegion".to_string(), region.to_owned().into());
                                            out
                                        })],
                                    )
                                    .build());
                            }
                        }
                        if (*use_fips) == (true) {
                            return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                .url({
                                    let mut out = String::new();
                                    out.push_str("https://s3-object-lambda-fips.");
                                    #[allow(clippy::needless_borrow)]
                                    out.push_str(&region.as_ref() as &str);
                                    out.push('.');
                                    #[allow(clippy::needless_borrow)]
                                    out.push_str(&partition_result.dns_suffix());
                                    out
                                })
                                .property(
                                    "authSchemes",
                                    vec![::aws_smithy_types::Document::from({
                                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                        out.insert("disableDoubleEncoding".to_string(), true.into());
                                        out.insert("name".to_string(), "sigv4".to_string().into());
                                        out.insert("signingName".to_string(), "s3-object-lambda".to_string().into());
                                        out.insert("signingRegion".to_string(), region.to_owned().into());
                                        out
                                    })],
                                )
                                .build());
                        }
                        return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                            .url({
                                let mut out = String::new();
                                out.push_str("https://s3-object-lambda.");
                                #[allow(clippy::needless_borrow)]
                                out.push_str(&region.as_ref() as &str);
                                out.push('.');
                                #[allow(clippy::needless_borrow)]
                                out.push_str(&partition_result.dns_suffix());
                                out
                            })
                            .property(
                                "authSchemes",
                                vec![::aws_smithy_types::Document::from({
                                    let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                    out.insert("disableDoubleEncoding".to_string(), true.into());
                                    out.insert("name".to_string(), "sigv4".to_string().into());
                                    out.insert("signingName".to_string(), "s3-object-lambda".to_string().into());
                                    out.insert("signingRegion".to_string(), region.to_owned().into());
                                    out
                                })],
                            )
                            .build());
                    }
                    return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message(
                        "Invalid region: region was not a valid DNS name.".to_string(),
                    ));
                }
                #[allow(unreachable_code)]
                return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message(format!(
                    "No rules matched these parameters. This is a bug. {:?}",
                    _params
                )));
            }
        }
        if !(bucket.is_some()) {
            #[allow(unused_variables)]
            if let Some(partition_result) = partition_resolver.resolve_partition(region.as_ref() as &str, _diagnostic_collector) {
                if crate::endpoint_lib::host::is_valid_host_label(region.as_ref() as &str, true, _diagnostic_collector) {
                    if (*use_fips) == (true) {
                        if (*use_dual_stack) == (true) {
                            if !(endpoint.is_some()) {
                                if (region.as_ref() as &str) == ("aws-global") {
                                    return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                        .url({
                                            let mut out = String::new();
                                            out.push_str("https://s3-fips.dualstack.us-east-1.");
                                            #[allow(clippy::needless_borrow)]
                                            out.push_str(&partition_result.dns_suffix());
                                            out
                                        })
                                        .property(
                                            "authSchemes",
                                            vec![::aws_smithy_types::Document::from({
                                                let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                out.insert("disableDoubleEncoding".to_string(), true.into());
                                                out.insert("name".to_string(), "sigv4".to_string().into());
                                                out.insert("signingName".to_string(), "s3".to_string().into());
                                                out.insert("signingRegion".to_string(), "us-east-1".to_string().into());
                                                out
                                            })],
                                        )
                                        .build());
                                }
                            }
                        }
                    }
                    if (*use_fips) == (true) {
                        if (*use_dual_stack) == (true) {
                            if !(endpoint.is_some()) {
                                if !((region.as_ref() as &str) == ("aws-global")) {
                                    if (*use_global_endpoint) == (true) {
                                        return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                            .url({
                                                let mut out = String::new();
                                                out.push_str("https://s3-fips.dualstack.");
                                                #[allow(clippy::needless_borrow)]
                                                out.push_str(&region.as_ref() as &str);
                                                out.push('.');
                                                #[allow(clippy::needless_borrow)]
                                                out.push_str(&partition_result.dns_suffix());
                                                out
                                            })
                                            .property(
                                                "authSchemes",
                                                vec![::aws_smithy_types::Document::from({
                                                    let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                    out.insert("disableDoubleEncoding".to_string(), true.into());
                                                    out.insert("name".to_string(), "sigv4".to_string().into());
                                                    out.insert("signingName".to_string(), "s3".to_string().into());
                                                    out.insert("signingRegion".to_string(), region.to_owned().into());
                                                    out
                                                })],
                                            )
                                            .build());
                                    }
                                }
                            }
                        }
                    }
                    if (*use_fips) == (true) {
                        if (*use_dual_stack) == (true) {
                            if !(endpoint.is_some()) {
                                if !((region.as_ref() as &str) == ("aws-global")) {
                                    if (*use_global_endpoint) == (false) {
                                        return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                            .url({
                                                let mut out = String::new();
                                                out.push_str("https://s3-fips.dualstack.");
                                                #[allow(clippy::needless_borrow)]
                                                out.push_str(&region.as_ref() as &str);
                                                out.push('.');
                                                #[allow(clippy::needless_borrow)]
                                                out.push_str(&partition_result.dns_suffix());
                                                out
                                            })
                                            .property(
                                                "authSchemes",
                                                vec![::aws_smithy_types::Document::from({
                                                    let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                    out.insert("disableDoubleEncoding".to_string(), true.into());
                                                    out.insert("name".to_string(), "sigv4".to_string().into());
                                                    out.insert("signingName".to_string(), "s3".to_string().into());
                                                    out.insert("signingRegion".to_string(), region.to_owned().into());
                                                    out
                                                })],
                                            )
                                            .build());
                                    }
                                }
                            }
                        }
                    }
                    if (*use_fips) == (true) {
                        if (*use_dual_stack) == (false) {
                            if !(endpoint.is_some()) {
                                if (region.as_ref() as &str) == ("aws-global") {
                                    return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                        .url({
                                            let mut out = String::new();
                                            out.push_str("https://s3-fips.us-east-1.");
                                            #[allow(clippy::needless_borrow)]
                                            out.push_str(&partition_result.dns_suffix());
                                            out
                                        })
                                        .property(
                                            "authSchemes",
                                            vec![::aws_smithy_types::Document::from({
                                                let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                out.insert("disableDoubleEncoding".to_string(), true.into());
                                                out.insert("name".to_string(), "sigv4".to_string().into());
                                                out.insert("signingName".to_string(), "s3".to_string().into());
                                                out.insert("signingRegion".to_string(), "us-east-1".to_string().into());
                                                out
                                            })],
                                        )
                                        .build());
                                }
                            }
                        }
                    }
                    if (*use_fips) == (true) {
                        if (*use_dual_stack) == (false) {
                            if !(endpoint.is_some()) {
                                if !((region.as_ref() as &str) == ("aws-global")) {
                                    if (*use_global_endpoint) == (true) {
                                        return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                            .url({
                                                let mut out = String::new();
                                                out.push_str("https://s3-fips.");
                                                #[allow(clippy::needless_borrow)]
                                                out.push_str(&region.as_ref() as &str);
                                                out.push('.');
                                                #[allow(clippy::needless_borrow)]
                                                out.push_str(&partition_result.dns_suffix());
                                                out
                                            })
                                            .property(
                                                "authSchemes",
                                                vec![::aws_smithy_types::Document::from({
                                                    let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                    out.insert("disableDoubleEncoding".to_string(), true.into());
                                                    out.insert("name".to_string(), "sigv4".to_string().into());
                                                    out.insert("signingName".to_string(), "s3".to_string().into());
                                                    out.insert("signingRegion".to_string(), region.to_owned().into());
                                                    out
                                                })],
                                            )
                                            .build());
                                    }
                                }
                            }
                        }
                    }
                    if (*use_fips) == (true) {
                        if (*use_dual_stack) == (false) {
                            if !(endpoint.is_some()) {
                                if !((region.as_ref() as &str) == ("aws-global")) {
                                    if (*use_global_endpoint) == (false) {
                                        return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                            .url({
                                                let mut out = String::new();
                                                out.push_str("https://s3-fips.");
                                                #[allow(clippy::needless_borrow)]
                                                out.push_str(&region.as_ref() as &str);
                                                out.push('.');
                                                #[allow(clippy::needless_borrow)]
                                                out.push_str(&partition_result.dns_suffix());
                                                out
                                            })
                                            .property(
                                                "authSchemes",
                                                vec![::aws_smithy_types::Document::from({
                                                    let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                    out.insert("disableDoubleEncoding".to_string(), true.into());
                                                    out.insert("name".to_string(), "sigv4".to_string().into());
                                                    out.insert("signingName".to_string(), "s3".to_string().into());
                                                    out.insert("signingRegion".to_string(), region.to_owned().into());
                                                    out
                                                })],
                                            )
                                            .build());
                                    }
                                }
                            }
                        }
                    }
                    if (*use_fips) == (false) {
                        if (*use_dual_stack) == (true) {
                            if !(endpoint.is_some()) {
                                if (region.as_ref() as &str) == ("aws-global") {
                                    return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                        .url({
                                            let mut out = String::new();
                                            out.push_str("https://s3.dualstack.us-east-1.");
                                            #[allow(clippy::needless_borrow)]
                                            out.push_str(&partition_result.dns_suffix());
                                            out
                                        })
                                        .property(
                                            "authSchemes",
                                            vec![::aws_smithy_types::Document::from({
                                                let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                out.insert("disableDoubleEncoding".to_string(), true.into());
                                                out.insert("name".to_string(), "sigv4".to_string().into());
                                                out.insert("signingName".to_string(), "s3".to_string().into());
                                                out.insert("signingRegion".to_string(), "us-east-1".to_string().into());
                                                out
                                            })],
                                        )
                                        .build());
                                }
                            }
                        }
                    }
                    if (*use_fips) == (false) {
                        if (*use_dual_stack) == (true) {
                            if !(endpoint.is_some()) {
                                if !((region.as_ref() as &str) == ("aws-global")) {
                                    if (*use_global_endpoint) == (true) {
                                        return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                            .url({
                                                let mut out = String::new();
                                                out.push_str("https://s3.dualstack.");
                                                #[allow(clippy::needless_borrow)]
                                                out.push_str(&region.as_ref() as &str);
                                                out.push('.');
                                                #[allow(clippy::needless_borrow)]
                                                out.push_str(&partition_result.dns_suffix());
                                                out
                                            })
                                            .property(
                                                "authSchemes",
                                                vec![::aws_smithy_types::Document::from({
                                                    let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                    out.insert("disableDoubleEncoding".to_string(), true.into());
                                                    out.insert("name".to_string(), "sigv4".to_string().into());
                                                    out.insert("signingName".to_string(), "s3".to_string().into());
                                                    out.insert("signingRegion".to_string(), region.to_owned().into());
                                                    out
                                                })],
                                            )
                                            .build());
                                    }
                                }
                            }
                        }
                    }
                    if (*use_fips) == (false) {
                        if (*use_dual_stack) == (true) {
                            if !(endpoint.is_some()) {
                                if !((region.as_ref() as &str) == ("aws-global")) {
                                    if (*use_global_endpoint) == (false) {
                                        return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                            .url({
                                                let mut out = String::new();
                                                out.push_str("https://s3.dualstack.");
                                                #[allow(clippy::needless_borrow)]
                                                out.push_str(&region.as_ref() as &str);
                                                out.push('.');
                                                #[allow(clippy::needless_borrow)]
                                                out.push_str(&partition_result.dns_suffix());
                                                out
                                            })
                                            .property(
                                                "authSchemes",
                                                vec![::aws_smithy_types::Document::from({
                                                    let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                    out.insert("disableDoubleEncoding".to_string(), true.into());
                                                    out.insert("name".to_string(), "sigv4".to_string().into());
                                                    out.insert("signingName".to_string(), "s3".to_string().into());
                                                    out.insert("signingRegion".to_string(), region.to_owned().into());
                                                    out
                                                })],
                                            )
                                            .build());
                                    }
                                }
                            }
                        }
                    }
                    if (*use_fips) == (false) {
                        if (*use_dual_stack) == (false) {
                            #[allow(unused_variables)]
                            if let Some(endpoint) = endpoint {
                                #[allow(unused_variables)]
                                if let Some(url) = crate::endpoint_lib::parse_url::parse_url(endpoint.as_ref() as &str, _diagnostic_collector) {
                                    if (region.as_ref() as &str) == ("aws-global") {
                                        return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                            .url({
                                                let mut out = String::new();
                                                #[allow(clippy::needless_borrow)]
                                                out.push_str(&url.scheme());
                                                out.push_str("://");
                                                #[allow(clippy::needless_borrow)]
                                                out.push_str(&url.authority());
                                                #[allow(clippy::needless_borrow)]
                                                out.push_str(&url.path());
                                                out
                                            })
                                            .property(
                                                "authSchemes",
                                                vec![::aws_smithy_types::Document::from({
                                                    let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                    out.insert("disableDoubleEncoding".to_string(), true.into());
                                                    out.insert("name".to_string(), "sigv4".to_string().into());
                                                    out.insert("signingName".to_string(), "s3".to_string().into());
                                                    out.insert("signingRegion".to_string(), "us-east-1".to_string().into());
                                                    out
                                                })],
                                            )
                                            .build());
                                    }
                                }
                            }
                        }
                    }
                    if (*use_fips) == (false) {
                        if (*use_dual_stack) == (false) {
                            #[allow(unused_variables)]
                            if let Some(endpoint) = endpoint {
                                #[allow(unused_variables)]
                                if let Some(url) = crate::endpoint_lib::parse_url::parse_url(endpoint.as_ref() as &str, _diagnostic_collector) {
                                    if !((region.as_ref() as &str) == ("aws-global")) {
                                        if (*use_global_endpoint) == (true) {
                                            if (region.as_ref() as &str) == ("us-east-1") {
                                                return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                                    .url({
                                                        let mut out = String::new();
                                                        #[allow(clippy::needless_borrow)]
                                                        out.push_str(&url.scheme());
                                                        out.push_str("://");
                                                        #[allow(clippy::needless_borrow)]
                                                        out.push_str(&url.authority());
                                                        #[allow(clippy::needless_borrow)]
                                                        out.push_str(&url.path());
                                                        out
                                                    })
                                                    .property(
                                                        "authSchemes",
                                                        vec![::aws_smithy_types::Document::from({
                                                            let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                            out.insert("disableDoubleEncoding".to_string(), true.into());
                                                            out.insert("name".to_string(), "sigv4".to_string().into());
                                                            out.insert("signingName".to_string(), "s3".to_string().into());
                                                            out.insert("signingRegion".to_string(), region.to_owned().into());
                                                            out
                                                        })],
                                                    )
                                                    .build());
                                            }
                                            return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                                .url({
                                                    let mut out = String::new();
                                                    #[allow(clippy::needless_borrow)]
                                                    out.push_str(&url.scheme());
                                                    out.push_str("://");
                                                    #[allow(clippy::needless_borrow)]
                                                    out.push_str(&url.authority());
                                                    #[allow(clippy::needless_borrow)]
                                                    out.push_str(&url.path());
                                                    out
                                                })
                                                .property(
                                                    "authSchemes",
                                                    vec![::aws_smithy_types::Document::from({
                                                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                        out.insert("disableDoubleEncoding".to_string(), true.into());
                                                        out.insert("name".to_string(), "sigv4".to_string().into());
                                                        out.insert("signingName".to_string(), "s3".to_string().into());
                                                        out.insert("signingRegion".to_string(), region.to_owned().into());
                                                        out
                                                    })],
                                                )
                                                .build());
                                        }
                                    }
                                }
                            }
                        }
                    }
                    if (*use_fips) == (false) {
                        if (*use_dual_stack) == (false) {
                            #[allow(unused_variables)]
                            if let Some(endpoint) = endpoint {
                                #[allow(unused_variables)]
                                if let Some(url) = crate::endpoint_lib::parse_url::parse_url(endpoint.as_ref() as &str, _diagnostic_collector) {
                                    if !((region.as_ref() as &str) == ("aws-global")) {
                                        if (*use_global_endpoint) == (false) {
                                            return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                                .url({
                                                    let mut out = String::new();
                                                    #[allow(clippy::needless_borrow)]
                                                    out.push_str(&url.scheme());
                                                    out.push_str("://");
                                                    #[allow(clippy::needless_borrow)]
                                                    out.push_str(&url.authority());
                                                    #[allow(clippy::needless_borrow)]
                                                    out.push_str(&url.path());
                                                    out
                                                })
                                                .property(
                                                    "authSchemes",
                                                    vec![::aws_smithy_types::Document::from({
                                                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                        out.insert("disableDoubleEncoding".to_string(), true.into());
                                                        out.insert("name".to_string(), "sigv4".to_string().into());
                                                        out.insert("signingName".to_string(), "s3".to_string().into());
                                                        out.insert("signingRegion".to_string(), region.to_owned().into());
                                                        out
                                                    })],
                                                )
                                                .build());
                                        }
                                    }
                                }
                            }
                        }
                    }
                    if (*use_fips) == (false) {
                        if (*use_dual_stack) == (false) {
                            if !(endpoint.is_some()) {
                                if (region.as_ref() as &str) == ("aws-global") {
                                    return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                        .url({
                                            let mut out = String::new();
                                            out.push_str("https://s3.");
                                            #[allow(clippy::needless_borrow)]
                                            out.push_str(&partition_result.dns_suffix());
                                            out
                                        })
                                        .property(
                                            "authSchemes",
                                            vec![::aws_smithy_types::Document::from({
                                                let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                out.insert("disableDoubleEncoding".to_string(), true.into());
                                                out.insert("name".to_string(), "sigv4".to_string().into());
                                                out.insert("signingName".to_string(), "s3".to_string().into());
                                                out.insert("signingRegion".to_string(), "us-east-1".to_string().into());
                                                out
                                            })],
                                        )
                                        .build());
                                }
                            }
                        }
                    }
                    if (*use_fips) == (false) {
                        if (*use_dual_stack) == (false) {
                            if !(endpoint.is_some()) {
                                if !((region.as_ref() as &str) == ("aws-global")) {
                                    if (*use_global_endpoint) == (true) {
                                        if (region.as_ref() as &str) == ("us-east-1") {
                                            return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                                .url({
                                                    let mut out = String::new();
                                                    out.push_str("https://s3.");
                                                    #[allow(clippy::needless_borrow)]
                                                    out.push_str(&partition_result.dns_suffix());
                                                    out
                                                })
                                                .property(
                                                    "authSchemes",
                                                    vec![::aws_smithy_types::Document::from({
                                                        let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                        out.insert("disableDoubleEncoding".to_string(), true.into());
                                                        out.insert("name".to_string(), "sigv4".to_string().into());
                                                        out.insert("signingName".to_string(), "s3".to_string().into());
                                                        out.insert("signingRegion".to_string(), region.to_owned().into());
                                                        out
                                                    })],
                                                )
                                                .build());
                                        }
                                        return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                            .url({
                                                let mut out = String::new();
                                                out.push_str("https://s3.");
                                                #[allow(clippy::needless_borrow)]
                                                out.push_str(&region.as_ref() as &str);
                                                out.push('.');
                                                #[allow(clippy::needless_borrow)]
                                                out.push_str(&partition_result.dns_suffix());
                                                out
                                            })
                                            .property(
                                                "authSchemes",
                                                vec![::aws_smithy_types::Document::from({
                                                    let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                    out.insert("disableDoubleEncoding".to_string(), true.into());
                                                    out.insert("name".to_string(), "sigv4".to_string().into());
                                                    out.insert("signingName".to_string(), "s3".to_string().into());
                                                    out.insert("signingRegion".to_string(), region.to_owned().into());
                                                    out
                                                })],
                                            )
                                            .build());
                                    }
                                }
                            }
                        }
                    }
                    if (*use_fips) == (false) {
                        if (*use_dual_stack) == (false) {
                            if !(endpoint.is_some()) {
                                if !((region.as_ref() as &str) == ("aws-global")) {
                                    if (*use_global_endpoint) == (false) {
                                        return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                            .url({
                                                let mut out = String::new();
                                                out.push_str("https://s3.");
                                                #[allow(clippy::needless_borrow)]
                                                out.push_str(&region.as_ref() as &str);
                                                out.push('.');
                                                #[allow(clippy::needless_borrow)]
                                                out.push_str(&partition_result.dns_suffix());
                                                out
                                            })
                                            .property(
                                                "authSchemes",
                                                vec![::aws_smithy_types::Document::from({
                                                    let mut out = ::std::collections::HashMap::<String, ::aws_smithy_types::Document>::new();
                                                    out.insert("disableDoubleEncoding".to_string(), true.into());
                                                    out.insert("name".to_string(), "sigv4".to_string().into());
                                                    out.insert("signingName".to_string(), "s3".to_string().into());
                                                    out.insert("signingRegion".to_string(), region.to_owned().into());
                                                    out
                                                })],
                                            )
                                            .build());
                                    }
                                }
                            }
                        }
                    }
                    #[allow(unreachable_code)]
                    return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message(format!(
                        "No rules matched these parameters. This is a bug. {:?}",
                        _params
                    )));
                }
                return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message(
                    "Invalid region: region was not a valid DNS name.".to_string(),
                ));
            }
            #[allow(unreachable_code)]
            return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message(format!(
                "No rules matched these parameters. This is a bug. {:?}",
                _params
            )));
        }
        #[allow(unreachable_code)]
        return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message(format!(
            "No rules matched these parameters. This is a bug. {:?}",
            _params
        )));
    }
    return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message(
        "A region must be set when sending requests to S3.".to_string(),
    ));
}
