/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.config.discovery.addon.usb;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.openhab.core.addon.AddonDiscoveryMethod;
import org.openhab.core.addon.AddonInfo;
import org.openhab.core.addon.AddonMatchProperty;
import org.openhab.core.config.discovery.addon.AddonFinder;
import org.openhab.core.config.discovery.addon.BaseAddonFinder;
import org.openhab.core.config.discovery.usbserial.UsbSerialDeviceInformation;
import org.openhab.core.config.discovery.usbserial.UsbSerialDiscovery;
import org.openhab.core.config.discovery.usbserial.UsbSerialDiscoveryListener;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
@Component(service={AddonFinder.class}, name="usb-addon-suggestion-finder")
public class UsbAddonFinder
extends BaseAddonFinder
implements UsbSerialDiscoveryListener {
    public static final String SERVICE_TYPE = "usb";
    public static final String SERVICE_NAME = "usb-addon-suggestion-finder";
    public static final String PRODUCT = "product";
    public static final String MANUFACTURER = "manufacturer";
    public static final String CHIP_ID = "chipId";
    public static final String REMOTE = "remote";
    public static final Set<String> SUPPORTED_PROPERTIES = Set.of("product", "manufacturer", "chipId", "remote");
    private final Logger logger = LoggerFactory.getLogger(UsbAddonFinder.class);
    private final Map<Long, UsbSerialDeviceInformation> usbDeviceInformations = new HashMap<Long, UsbSerialDeviceInformation>();

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addUsbSerialDiscovery(UsbSerialDiscovery usbSerialDiscovery) {
        usbSerialDiscovery.registerDiscoveryListener((UsbSerialDiscoveryListener)this);
    }

    protected synchronized void removeUsbSerialDiscovery(UsbSerialDiscovery usbSerialDiscovery) {
        usbSerialDiscovery.unregisterDiscoveryListener((UsbSerialDiscoveryListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<AddonInfo> getSuggestedAddons() {
        HashSet<AddonInfo> result = new HashSet<AddonInfo>();
        block3: for (AddonInfo candidate : this.addonCandidates) {
            for (AddonDiscoveryMethod method2 : candidate.getDiscoveryMethods().stream().filter(method -> SERVICE_TYPE.equals(method.getServiceType())).toList()) {
                Map<String, Pattern> matchProperties = method2.getMatchProperties().stream().collect(Collectors.toMap(AddonMatchProperty::getName, AddonMatchProperty::getPattern));
                HashSet<String> propertyNames = new HashSet<String>(matchProperties.keySet());
                propertyNames.removeAll(SUPPORTED_PROPERTIES);
                if (!propertyNames.isEmpty()) {
                    this.logger.warn("Add-on '{}' addon.xml file contains unsupported 'match-property' [{}]", (Object)candidate.getUID(), (Object)String.join((CharSequence)",", propertyNames));
                    continue block3;
                }
                this.logger.trace("Checking candidate: {}", (Object)candidate.getUID());
                UsbAddonFinder usbAddonFinder = this;
                synchronized (usbAddonFinder) {
                    for (UsbSerialDeviceInformation device : this.usbDeviceInformations.values()) {
                        this.logger.trace("Checking device: {}", (Object)device);
                        if (!UsbAddonFinder.propertyMatches(matchProperties, (String)PRODUCT, (String)device.getProduct()) || !UsbAddonFinder.propertyMatches(matchProperties, (String)MANUFACTURER, (String)device.getManufacturer()) || !UsbAddonFinder.propertyMatches(matchProperties, (String)CHIP_ID, (String)this.getChipId(device.getVendorId(), device.getProductId())) || !UsbAddonFinder.propertyMatches(matchProperties, (String)REMOTE, (String)String.valueOf(device.getRemote()))) continue;
                        result.add(candidate);
                        this.logger.debug("Suggested add-on found: {}", (Object)candidate.getUID());
                        break;
                    }
                }
            }
        }
        return result;
    }

    private String getChipId(int vendorId, int productId) {
        return String.format("%04x:%04x", vendorId, productId);
    }

    public String getServiceName() {
        return SERVICE_NAME;
    }

    private long keyOf(UsbSerialDeviceInformation deviceInfo) {
        return (deviceInfo.getRemote() ? 0x100000000L : 0L) + (long)deviceInfo.getVendorId() * 65536L + (long)deviceInfo.getProductId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void usbSerialDeviceDiscovered(UsbSerialDeviceInformation discoveredInfo) {
        UsbSerialDeviceInformation targetInfo = discoveredInfo;
        UsbAddonFinder usbAddonFinder = this;
        synchronized (usbAddonFinder) {
            UsbSerialDeviceInformation existingInfo = this.usbDeviceInformations.get(this.keyOf(targetInfo));
            if (existingInfo != null) {
                boolean remote;
                String serialNumber;
                String manufacturer;
                boolean isMerging = false;
                String product = existingInfo.getProduct();
                if (product != null) {
                    product = discoveredInfo.getProduct();
                    isMerging = true;
                }
                if ((manufacturer = existingInfo.getManufacturer()) != null) {
                    manufacturer = discoveredInfo.getManufacturer();
                    isMerging = true;
                }
                if ((serialNumber = existingInfo.getSerialNumber()) != null) {
                    serialNumber = discoveredInfo.getSerialNumber();
                    isMerging = true;
                }
                if ((remote = existingInfo.getRemote()) == discoveredInfo.getRemote()) {
                    isMerging = true;
                }
                if (isMerging) {
                    targetInfo = new UsbSerialDeviceInformation(discoveredInfo.getVendorId(), discoveredInfo.getProductId(), serialNumber, manufacturer, product, discoveredInfo.getInterfaceNumber(), discoveredInfo.getInterfaceDescription(), discoveredInfo.getSerialPort()).setRemote(remote);
                }
            }
            this.usbDeviceInformations.put(this.keyOf(targetInfo), targetInfo);
        }
    }

    public synchronized void usbSerialDeviceRemoved(UsbSerialDeviceInformation removedInfo) {
        this.usbDeviceInformations.remove(this.keyOf(removedInfo));
    }
}

