//go:build !ignore_autogenerated
// +build !ignore_autogenerated

/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by validation-gen. DO NOT EDIT.

package optional

import (
	context "context"
	fmt "fmt"

	equality "k8s.io/apimachinery/pkg/api/equality"
	operation "k8s.io/apimachinery/pkg/api/operation"
	safe "k8s.io/apimachinery/pkg/api/safe"
	validate "k8s.io/apimachinery/pkg/api/validate"
	field "k8s.io/apimachinery/pkg/util/validation/field"
	testscheme "k8s.io/code-generator/cmd/validation-gen/testscheme"
)

func init() { localSchemeBuilder.Register(RegisterValidations) }

// RegisterValidations adds validation functions to the given scheme.
// Public to allow building arbitrary schemes.
func RegisterValidations(scheme *testscheme.Scheme) error {
	// type Struct
	scheme.AddValidationFunc((*Struct)(nil), func(ctx context.Context, op operation.Operation, obj, oldObj interface{}) field.ErrorList {
		switch op.Request.SubresourcePath() {
		case "/":
			return Validate_Struct(ctx, op, nil /* fldPath */, obj.(*Struct), safe.Cast[*Struct](oldObj))
		}
		return field.ErrorList{field.InternalError(nil, fmt.Errorf("no validation found for %T, subresource: %v", obj, op.Request.SubresourcePath()))}
	})
	return nil
}

// Validate_IntType validates an instance of IntType according
// to declarative validation rules in the API schema.
func Validate_IntType(ctx context.Context, op operation.Operation, fldPath *field.Path, obj, oldObj *IntType) (errs field.ErrorList) {
	errs = append(errs, validate.FixedResult(ctx, op, fldPath, obj, oldObj, false, "type IntType")...)

	return errs
}

// Validate_MapType validates an instance of MapType according
// to declarative validation rules in the API schema.
func Validate_MapType(ctx context.Context, op operation.Operation, fldPath *field.Path, obj, oldObj MapType) (errs field.ErrorList) {
	errs = append(errs, validate.FixedResult(ctx, op, fldPath, obj, oldObj, false, "type MapType")...)

	return errs
}

// Validate_OtherStruct validates an instance of OtherStruct according
// to declarative validation rules in the API schema.
func Validate_OtherStruct(ctx context.Context, op operation.Operation, fldPath *field.Path, obj, oldObj *OtherStruct) (errs field.ErrorList) {
	errs = append(errs, validate.FixedResult(ctx, op, fldPath, obj, oldObj, false, "type OtherStruct")...)

	return errs
}

// Validate_SliceType validates an instance of SliceType according
// to declarative validation rules in the API schema.
func Validate_SliceType(ctx context.Context, op operation.Operation, fldPath *field.Path, obj, oldObj SliceType) (errs field.ErrorList) {
	errs = append(errs, validate.FixedResult(ctx, op, fldPath, obj, oldObj, false, "type SliceType")...)

	return errs
}

// Validate_StringType validates an instance of StringType according
// to declarative validation rules in the API schema.
func Validate_StringType(ctx context.Context, op operation.Operation, fldPath *field.Path, obj, oldObj *StringType) (errs field.ErrorList) {
	errs = append(errs, validate.FixedResult(ctx, op, fldPath, obj, oldObj, false, "type StringType")...)

	return errs
}

// Validate_Struct validates an instance of Struct according
// to declarative validation rules in the API schema.
func Validate_Struct(ctx context.Context, op operation.Operation, fldPath *field.Path, obj, oldObj *Struct) (errs field.ErrorList) {
	// field Struct.TypeMeta has no validation

	// field Struct.StringField
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj *string, oldValueCorrelated bool) (errs field.ErrorList) {
			// don't revalidate unchanged data
			if oldValueCorrelated && op.Type == operation.Update && (obj == oldObj || (obj != nil && oldObj != nil && *obj == *oldObj)) {
				return nil
			}
			// call field-attached validations
			earlyReturn := false
			if e := validate.OptionalValue(ctx, op, fldPath, obj, oldObj); len(e) != 0 {
				earlyReturn = true
			}
			if earlyReturn {
				return // do not proceed
			}
			errs = append(errs, validate.FixedResult(ctx, op, fldPath, obj, oldObj, false, "field Struct.StringField")...)
			return
		}(fldPath.Child("stringField"), &obj.StringField, safe.Field(oldObj, func(oldObj *Struct) *string { return &oldObj.StringField }), oldObj != nil)...)

	// field Struct.StringPtrField
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj *string, oldValueCorrelated bool) (errs field.ErrorList) {
			// don't revalidate unchanged data
			if oldValueCorrelated && op.Type == operation.Update && (obj == oldObj || (obj != nil && oldObj != nil && *obj == *oldObj)) {
				return nil
			}
			// call field-attached validations
			earlyReturn := false
			if e := validate.OptionalPointer(ctx, op, fldPath, obj, oldObj); len(e) != 0 {
				earlyReturn = true
			}
			if earlyReturn {
				return // do not proceed
			}
			errs = append(errs, validate.FixedResult(ctx, op, fldPath, obj, oldObj, false, "field Struct.StringPtrField")...)
			return
		}(fldPath.Child("stringPtrField"), obj.StringPtrField, safe.Field(oldObj, func(oldObj *Struct) *string { return oldObj.StringPtrField }), oldObj != nil)...)

	// field Struct.StringTypedefField
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj *StringType, oldValueCorrelated bool) (errs field.ErrorList) {
			// don't revalidate unchanged data
			if oldValueCorrelated && op.Type == operation.Update && (obj == oldObj || (obj != nil && oldObj != nil && *obj == *oldObj)) {
				return nil
			}
			// call field-attached validations
			earlyReturn := false
			if e := validate.OptionalValue(ctx, op, fldPath, obj, oldObj); len(e) != 0 {
				earlyReturn = true
			}
			if earlyReturn {
				return // do not proceed
			}
			errs = append(errs, validate.FixedResult(ctx, op, fldPath, obj, oldObj, false, "field Struct.StringTypedefField")...)
			// call the type's validation function
			errs = append(errs, Validate_StringType(ctx, op, fldPath, obj, oldObj)...)
			return
		}(fldPath.Child("stringTypedefField"), &obj.StringTypedefField, safe.Field(oldObj, func(oldObj *Struct) *StringType { return &oldObj.StringTypedefField }), oldObj != nil)...)

	// field Struct.StringTypedefPtrField
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj *StringType, oldValueCorrelated bool) (errs field.ErrorList) {
			// don't revalidate unchanged data
			if oldValueCorrelated && op.Type == operation.Update && (obj == oldObj || (obj != nil && oldObj != nil && *obj == *oldObj)) {
				return nil
			}
			// call field-attached validations
			earlyReturn := false
			if e := validate.OptionalPointer(ctx, op, fldPath, obj, oldObj); len(e) != 0 {
				earlyReturn = true
			}
			if earlyReturn {
				return // do not proceed
			}
			errs = append(errs, validate.FixedResult(ctx, op, fldPath, obj, oldObj, false, "field Struct.StringTypedefPtrField")...)
			// call the type's validation function
			errs = append(errs, Validate_StringType(ctx, op, fldPath, obj, oldObj)...)
			return
		}(fldPath.Child("stringTypedefPtrField"), obj.StringTypedefPtrField, safe.Field(oldObj, func(oldObj *Struct) *StringType { return oldObj.StringTypedefPtrField }), oldObj != nil)...)

	// field Struct.IntField
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj *int, oldValueCorrelated bool) (errs field.ErrorList) {
			// don't revalidate unchanged data
			if oldValueCorrelated && op.Type == operation.Update && (obj == oldObj || (obj != nil && oldObj != nil && *obj == *oldObj)) {
				return nil
			}
			// call field-attached validations
			earlyReturn := false
			if e := validate.OptionalValue(ctx, op, fldPath, obj, oldObj); len(e) != 0 {
				earlyReturn = true
			}
			if earlyReturn {
				return // do not proceed
			}
			errs = append(errs, validate.FixedResult(ctx, op, fldPath, obj, oldObj, false, "field Struct.IntField")...)
			return
		}(fldPath.Child("intField"), &obj.IntField, safe.Field(oldObj, func(oldObj *Struct) *int { return &oldObj.IntField }), oldObj != nil)...)

	// field Struct.IntPtrField
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj *int, oldValueCorrelated bool) (errs field.ErrorList) {
			// don't revalidate unchanged data
			if oldValueCorrelated && op.Type == operation.Update && (obj == oldObj || (obj != nil && oldObj != nil && *obj == *oldObj)) {
				return nil
			}
			// call field-attached validations
			earlyReturn := false
			if e := validate.OptionalPointer(ctx, op, fldPath, obj, oldObj); len(e) != 0 {
				earlyReturn = true
			}
			if earlyReturn {
				return // do not proceed
			}
			errs = append(errs, validate.FixedResult(ctx, op, fldPath, obj, oldObj, false, "field Struct.IntPtrField")...)
			return
		}(fldPath.Child("intPtrField"), obj.IntPtrField, safe.Field(oldObj, func(oldObj *Struct) *int { return oldObj.IntPtrField }), oldObj != nil)...)

	// field Struct.IntTypedefField
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj *IntType, oldValueCorrelated bool) (errs field.ErrorList) {
			// don't revalidate unchanged data
			if oldValueCorrelated && op.Type == operation.Update && (obj == oldObj || (obj != nil && oldObj != nil && *obj == *oldObj)) {
				return nil
			}
			// call field-attached validations
			earlyReturn := false
			if e := validate.OptionalValue(ctx, op, fldPath, obj, oldObj); len(e) != 0 {
				earlyReturn = true
			}
			if earlyReturn {
				return // do not proceed
			}
			errs = append(errs, validate.FixedResult(ctx, op, fldPath, obj, oldObj, false, "field Struct.IntTypedefField")...)
			// call the type's validation function
			errs = append(errs, Validate_IntType(ctx, op, fldPath, obj, oldObj)...)
			return
		}(fldPath.Child("intTypedefField"), &obj.IntTypedefField, safe.Field(oldObj, func(oldObj *Struct) *IntType { return &oldObj.IntTypedefField }), oldObj != nil)...)

	// field Struct.IntTypedefPtrField
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj *IntType, oldValueCorrelated bool) (errs field.ErrorList) {
			// don't revalidate unchanged data
			if oldValueCorrelated && op.Type == operation.Update && (obj == oldObj || (obj != nil && oldObj != nil && *obj == *oldObj)) {
				return nil
			}
			// call field-attached validations
			earlyReturn := false
			if e := validate.OptionalPointer(ctx, op, fldPath, obj, oldObj); len(e) != 0 {
				earlyReturn = true
			}
			if earlyReturn {
				return // do not proceed
			}
			errs = append(errs, validate.FixedResult(ctx, op, fldPath, obj, oldObj, false, "field Struct.IntTypedefPtrField")...)
			// call the type's validation function
			errs = append(errs, Validate_IntType(ctx, op, fldPath, obj, oldObj)...)
			return
		}(fldPath.Child("intTypedefPtrField"), obj.IntTypedefPtrField, safe.Field(oldObj, func(oldObj *Struct) *IntType { return oldObj.IntTypedefPtrField }), oldObj != nil)...)

	// field Struct.OtherStructPtrField
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj *OtherStruct, oldValueCorrelated bool) (errs field.ErrorList) {
			// don't revalidate unchanged data
			if oldValueCorrelated && op.Type == operation.Update && (obj == oldObj || (obj != nil && oldObj != nil && *obj == *oldObj)) {
				return nil
			}
			// call field-attached validations
			earlyReturn := false
			if e := validate.OptionalPointer(ctx, op, fldPath, obj, oldObj); len(e) != 0 {
				earlyReturn = true
			}
			if earlyReturn {
				return // do not proceed
			}
			errs = append(errs, validate.FixedResult(ctx, op, fldPath, obj, oldObj, false, "field Struct.OtherStructPtrField")...)
			// call the type's validation function
			errs = append(errs, Validate_OtherStruct(ctx, op, fldPath, obj, oldObj)...)
			return
		}(fldPath.Child("otherStructPtrField"), obj.OtherStructPtrField, safe.Field(oldObj, func(oldObj *Struct) *OtherStruct { return oldObj.OtherStructPtrField }), oldObj != nil)...)

	// field Struct.SliceField
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj []string, oldValueCorrelated bool) (errs field.ErrorList) {
			// don't revalidate unchanged data
			if oldValueCorrelated && op.Type == operation.Update && equality.Semantic.DeepEqual(obj, oldObj) {
				return nil
			}
			// call field-attached validations
			earlyReturn := false
			if e := validate.OptionalSlice(ctx, op, fldPath, obj, oldObj); len(e) != 0 {
				earlyReturn = true
			}
			if earlyReturn {
				return // do not proceed
			}
			errs = append(errs, validate.FixedResult(ctx, op, fldPath, obj, oldObj, false, "field Struct.SliceField")...)
			return
		}(fldPath.Child("sliceField"), obj.SliceField, safe.Field(oldObj, func(oldObj *Struct) []string { return oldObj.SliceField }), oldObj != nil)...)

	// field Struct.SliceTypedefField
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj SliceType, oldValueCorrelated bool) (errs field.ErrorList) {
			// don't revalidate unchanged data
			if oldValueCorrelated && op.Type == operation.Update && equality.Semantic.DeepEqual(obj, oldObj) {
				return nil
			}
			// call field-attached validations
			earlyReturn := false
			if e := validate.OptionalSlice(ctx, op, fldPath, obj, oldObj); len(e) != 0 {
				earlyReturn = true
			}
			if earlyReturn {
				return // do not proceed
			}
			errs = append(errs, validate.FixedResult(ctx, op, fldPath, obj, oldObj, false, "field Struct.SliceTypedefField")...)
			// call the type's validation function
			errs = append(errs, Validate_SliceType(ctx, op, fldPath, obj, oldObj)...)
			return
		}(fldPath.Child("sliceTypedefField"), obj.SliceTypedefField, safe.Field(oldObj, func(oldObj *Struct) SliceType { return oldObj.SliceTypedefField }), oldObj != nil)...)

	// field Struct.MapField
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj map[string]string, oldValueCorrelated bool) (errs field.ErrorList) {
			// don't revalidate unchanged data
			if oldValueCorrelated && op.Type == operation.Update && equality.Semantic.DeepEqual(obj, oldObj) {
				return nil
			}
			// call field-attached validations
			earlyReturn := false
			if e := validate.OptionalMap(ctx, op, fldPath, obj, oldObj); len(e) != 0 {
				earlyReturn = true
			}
			if earlyReturn {
				return // do not proceed
			}
			errs = append(errs, validate.FixedResult(ctx, op, fldPath, obj, oldObj, false, "field Struct.MapField")...)
			return
		}(fldPath.Child("mapField"), obj.MapField, safe.Field(oldObj, func(oldObj *Struct) map[string]string { return oldObj.MapField }), oldObj != nil)...)

	// field Struct.MapTypedefField
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj MapType, oldValueCorrelated bool) (errs field.ErrorList) {
			// don't revalidate unchanged data
			if oldValueCorrelated && op.Type == operation.Update && equality.Semantic.DeepEqual(obj, oldObj) {
				return nil
			}
			// call field-attached validations
			earlyReturn := false
			if e := validate.OptionalMap(ctx, op, fldPath, obj, oldObj); len(e) != 0 {
				earlyReturn = true
			}
			if earlyReturn {
				return // do not proceed
			}
			errs = append(errs, validate.FixedResult(ctx, op, fldPath, obj, oldObj, false, "field Struct.MapTypedefField")...)
			// call the type's validation function
			errs = append(errs, Validate_MapType(ctx, op, fldPath, obj, oldObj)...)
			return
		}(fldPath.Child("mapTypedefField"), obj.MapTypedefField, safe.Field(oldObj, func(oldObj *Struct) MapType { return oldObj.MapTypedefField }), oldObj != nil)...)

	return errs
}
