#[cfg(feature = "Win32_UI_Shell_Common")]
pub mod Common;
#[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
pub mod PropertiesSystem;
#[inline]
pub unsafe fn AssocCreate<T>(clsid: windows_core::GUID) -> windows_core::Result<T>
where
    T: windows_core::Interface,
{
    windows_core::link!("shlwapi.dll" "system" fn AssocCreate(clsid : windows_core::GUID, riid : *const windows_core::GUID, ppv : *mut *mut core::ffi::c_void) -> windows_core::HRESULT);
    let mut result__ = core::ptr::null_mut();
    unsafe { AssocCreate(core::mem::transmute(clsid), &T::IID, &mut result__).and_then(|| windows_core::Type::from_abi(result__)) }
}
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn AssocCreateForClasses<T>(rgclasses: &[ASSOCIATIONELEMENT]) -> windows_core::Result<T>
where
    T: windows_core::Interface,
{
    windows_core::link!("shell32.dll" "system" fn AssocCreateForClasses(rgclasses : *const ASSOCIATIONELEMENT, cclasses : u32, riid : *const windows_core::GUID, ppv : *mut *mut core::ffi::c_void) -> windows_core::HRESULT);
    let mut result__ = core::ptr::null_mut();
    unsafe { AssocCreateForClasses(core::mem::transmute(rgclasses.as_ptr()), rgclasses.len().try_into().unwrap(), &T::IID, &mut result__).and_then(|| windows_core::Type::from_abi(result__)) }
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant", feature = "Win32_UI_Shell_Common"))]
#[inline]
pub unsafe fn AssocGetDetailsOfPropKey<P0>(psf: P0, pidl: *const Common::ITEMIDLIST, pkey: *const super::super::Foundation::PROPERTYKEY, pv: *mut super::super::System::Variant::VARIANT, pffoundpropkey: Option<*mut windows_core::BOOL>) -> windows_core::Result<()>
where
    P0: windows_core::Param<IShellFolder>,
{
    windows_core::link!("shell32.dll" "system" fn AssocGetDetailsOfPropKey(psf : * mut core::ffi::c_void, pidl : *const Common:: ITEMIDLIST, pkey : *const super::super::Foundation:: PROPERTYKEY, pv : *mut super::super::System::Variant:: VARIANT, pffoundpropkey : *mut windows_core::BOOL) -> windows_core::HRESULT);
    unsafe { AssocGetDetailsOfPropKey(psf.param().abi(), pidl, pkey, core::mem::transmute(pv), pffoundpropkey.unwrap_or(core::mem::zeroed()) as _).ok() }
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn AssocGetPerceivedType<P0>(pszext: P0, ptype: *mut Common::PERCEIVED, pflag: *mut u32, ppsztype: Option<*mut windows_core::PWSTR>) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn AssocGetPerceivedType(pszext : windows_core::PCWSTR, ptype : *mut Common:: PERCEIVED, pflag : *mut u32, ppsztype : *mut windows_core::PWSTR) -> windows_core::HRESULT);
    unsafe { AssocGetPerceivedType(pszext.param().abi(), ptype as _, pflag as _, ppsztype.unwrap_or(core::mem::zeroed()) as _).ok() }
}
#[inline]
pub unsafe fn AssocIsDangerous<P0>(pszassoc: P0) -> windows_core::BOOL
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn AssocIsDangerous(pszassoc : windows_core::PCWSTR) -> windows_core::BOOL);
    unsafe { AssocIsDangerous(pszassoc.param().abi()) }
}
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn AssocQueryKeyA<P2, P3>(flags: ASSOCF, key: ASSOCKEY, pszassoc: P2, pszextra: P3) -> windows_core::Result<super::super::System::Registry::HKEY>
where
    P2: windows_core::Param<windows_core::PCSTR>,
    P3: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn AssocQueryKeyA(flags : ASSOCF, key : ASSOCKEY, pszassoc : windows_core::PCSTR, pszextra : windows_core::PCSTR, phkeyout : *mut super::super::System::Registry:: HKEY) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        AssocQueryKeyA(flags, key, pszassoc.param().abi(), pszextra.param().abi(), &mut result__).map(|| result__)
    }
}
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn AssocQueryKeyW<P2, P3>(flags: ASSOCF, key: ASSOCKEY, pszassoc: P2, pszextra: P3) -> windows_core::Result<super::super::System::Registry::HKEY>
where
    P2: windows_core::Param<windows_core::PCWSTR>,
    P3: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn AssocQueryKeyW(flags : ASSOCF, key : ASSOCKEY, pszassoc : windows_core::PCWSTR, pszextra : windows_core::PCWSTR, phkeyout : *mut super::super::System::Registry:: HKEY) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        AssocQueryKeyW(flags, key, pszassoc.param().abi(), pszextra.param().abi(), &mut result__).map(|| result__)
    }
}
#[inline]
pub unsafe fn AssocQueryStringA<P2, P3>(flags: ASSOCF, str: ASSOCSTR, pszassoc: P2, pszextra: P3, pszout: Option<windows_core::PSTR>, pcchout: *mut u32) -> windows_core::HRESULT
where
    P2: windows_core::Param<windows_core::PCSTR>,
    P3: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn AssocQueryStringA(flags : ASSOCF, str : ASSOCSTR, pszassoc : windows_core::PCSTR, pszextra : windows_core::PCSTR, pszout : windows_core::PSTR, pcchout : *mut u32) -> windows_core::HRESULT);
    unsafe { AssocQueryStringA(flags, str, pszassoc.param().abi(), pszextra.param().abi(), pszout.unwrap_or(core::mem::zeroed()) as _, pcchout as _) }
}
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn AssocQueryStringByKeyA<P3>(flags: ASSOCF, str: ASSOCSTR, hkassoc: super::super::System::Registry::HKEY, pszextra: P3, pszout: Option<windows_core::PSTR>, pcchout: *mut u32) -> windows_core::HRESULT
where
    P3: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn AssocQueryStringByKeyA(flags : ASSOCF, str : ASSOCSTR, hkassoc : super::super::System::Registry:: HKEY, pszextra : windows_core::PCSTR, pszout : windows_core::PSTR, pcchout : *mut u32) -> windows_core::HRESULT);
    unsafe { AssocQueryStringByKeyA(flags, str, hkassoc, pszextra.param().abi(), pszout.unwrap_or(core::mem::zeroed()) as _, pcchout as _) }
}
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn AssocQueryStringByKeyW<P3>(flags: ASSOCF, str: ASSOCSTR, hkassoc: super::super::System::Registry::HKEY, pszextra: P3, pszout: Option<windows_core::PWSTR>, pcchout: *mut u32) -> windows_core::HRESULT
where
    P3: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn AssocQueryStringByKeyW(flags : ASSOCF, str : ASSOCSTR, hkassoc : super::super::System::Registry:: HKEY, pszextra : windows_core::PCWSTR, pszout : windows_core::PWSTR, pcchout : *mut u32) -> windows_core::HRESULT);
    unsafe { AssocQueryStringByKeyW(flags, str, hkassoc, pszextra.param().abi(), pszout.unwrap_or(core::mem::zeroed()) as _, pcchout as _) }
}
#[inline]
pub unsafe fn AssocQueryStringW<P2, P3>(flags: ASSOCF, str: ASSOCSTR, pszassoc: P2, pszextra: P3, pszout: Option<windows_core::PWSTR>, pcchout: *mut u32) -> windows_core::HRESULT
where
    P2: windows_core::Param<windows_core::PCWSTR>,
    P3: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn AssocQueryStringW(flags : ASSOCF, str : ASSOCSTR, pszassoc : windows_core::PCWSTR, pszextra : windows_core::PCWSTR, pszout : windows_core::PWSTR, pcchout : *mut u32) -> windows_core::HRESULT);
    unsafe { AssocQueryStringW(flags, str, pszassoc.param().abi(), pszextra.param().abi(), pszout.unwrap_or(core::mem::zeroed()) as _, pcchout as _) }
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Registry", feature = "Win32_UI_Shell_Common"))]
#[inline]
pub unsafe fn CDefFolderMenu_Create2<P4>(pidlfolder: Option<*const Common::ITEMIDLIST>, hwnd: Option<super::super::Foundation::HWND>, apidl: Option<&[*const Common::ITEMIDLIST]>, psf: P4, pfn: LPFNDFMCALLBACK, ahkeys: Option<&[super::super::System::Registry::HKEY]>) -> windows_core::Result<IContextMenu>
where
    P4: windows_core::Param<IShellFolder>,
{
    windows_core::link!("shell32.dll" "system" fn CDefFolderMenu_Create2(pidlfolder : *const Common:: ITEMIDLIST, hwnd : super::super::Foundation:: HWND, cidl : u32, apidl : *const *const Common:: ITEMIDLIST, psf : * mut core::ffi::c_void, pfn : LPFNDFMCALLBACK, nkeys : u32, ahkeys : *const super::super::System::Registry:: HKEY, ppcm : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        CDefFolderMenu_Create2(pidlfolder.unwrap_or(core::mem::zeroed()) as _, hwnd.unwrap_or(core::mem::zeroed()) as _, apidl.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(apidl.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), psf.param().abi(), pfn, ahkeys.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(ahkeys.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_UI_Shell_Common"))]
#[inline]
pub unsafe fn CIDLData_CreateFromIDArray(pidlfolder: *const Common::ITEMIDLIST, apidl: Option<&[*const Common::ITEMIDLIST]>) -> windows_core::Result<super::super::System::Com::IDataObject> {
    windows_core::link!("shell32.dll" "system" fn CIDLData_CreateFromIDArray(pidlfolder : *const Common:: ITEMIDLIST, cidl : u32, apidl : *const *const Common:: ITEMIDLIST, ppdtobj : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        CIDLData_CreateFromIDArray(pidlfolder, apidl.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(apidl.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn ChrCmpIA(w1: u16, w2: u16) -> windows_core::BOOL {
    windows_core::link!("shlwapi.dll" "system" fn ChrCmpIA(w1 : u16, w2 : u16) -> windows_core::BOOL);
    unsafe { ChrCmpIA(w1, w2) }
}
#[inline]
pub unsafe fn ChrCmpIW(w1: u16, w2: u16) -> windows_core::BOOL {
    windows_core::link!("shlwapi.dll" "system" fn ChrCmpIW(w1 : u16, w2 : u16) -> windows_core::BOOL);
    unsafe { ChrCmpIW(w1, w2) }
}
#[inline]
pub unsafe fn ColorAdjustLuma(clrrgb: super::super::Foundation::COLORREF, n: i32, fscale: bool) -> super::super::Foundation::COLORREF {
    windows_core::link!("shlwapi.dll" "system" fn ColorAdjustLuma(clrrgb : super::super::Foundation:: COLORREF, n : i32, fscale : windows_core::BOOL) -> super::super::Foundation:: COLORREF);
    unsafe { ColorAdjustLuma(clrrgb, n, fscale.into()) }
}
#[inline]
pub unsafe fn ColorHLSToRGB(whue: u16, wluminance: u16, wsaturation: u16) -> super::super::Foundation::COLORREF {
    windows_core::link!("shlwapi.dll" "system" fn ColorHLSToRGB(whue : u16, wluminance : u16, wsaturation : u16) -> super::super::Foundation:: COLORREF);
    unsafe { ColorHLSToRGB(whue, wluminance, wsaturation) }
}
#[inline]
pub unsafe fn ColorRGBToHLS(clrrgb: super::super::Foundation::COLORREF, pwhue: *mut u16, pwluminance: *mut u16, pwsaturation: *mut u16) {
    windows_core::link!("shlwapi.dll" "system" fn ColorRGBToHLS(clrrgb : super::super::Foundation:: COLORREF, pwhue : *mut u16, pwluminance : *mut u16, pwsaturation : *mut u16));
    unsafe { ColorRGBToHLS(clrrgb, pwhue as _, pwluminance as _, pwsaturation as _) }
}
#[inline]
pub unsafe fn CommandLineToArgvW<P0>(lpcmdline: P0, pnumargs: *mut i32) -> *mut windows_core::PWSTR
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shell32.dll" "system" fn CommandLineToArgvW(lpcmdline : windows_core::PCWSTR, pnumargs : *mut i32) -> *mut windows_core::PWSTR);
    unsafe { CommandLineToArgvW(lpcmdline.param().abi(), pnumargs as _) }
}
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn ConnectToConnectionPoint<P0, P3>(punk: P0, riidevent: *const windows_core::GUID, fconnect: bool, punktarget: P3, pdwcookie: *mut u32, ppcpout: Option<*mut Option<super::super::System::Com::IConnectionPoint>>) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::IUnknown>,
    P3: windows_core::Param<windows_core::IUnknown>,
{
    windows_core::link!("shlwapi.dll" "system" fn ConnectToConnectionPoint(punk : * mut core::ffi::c_void, riidevent : *const windows_core::GUID, fconnect : windows_core::BOOL, punktarget : * mut core::ffi::c_void, pdwcookie : *mut u32, ppcpout : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe { ConnectToConnectionPoint(punk.param().abi(), riidevent, fconnect.into(), punktarget.param().abi(), pdwcookie as _, ppcpout.unwrap_or(core::mem::zeroed()) as _).ok() }
}
#[inline]
pub unsafe fn CreateProfile<P0, P1>(pszusersid: P0, pszusername: P1, pszprofilepath: &mut [u16]) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("userenv.dll" "system" fn CreateProfile(pszusersid : windows_core::PCWSTR, pszusername : windows_core::PCWSTR, pszprofilepath : windows_core::PWSTR, cchprofilepath : u32) -> windows_core::HRESULT);
    unsafe { CreateProfile(pszusersid.param().abi(), pszusername.param().abi(), core::mem::transmute(pszprofilepath.as_ptr()), pszprofilepath.len().try_into().unwrap()).ok() }
}
#[inline]
pub unsafe fn DAD_AutoScroll(hwnd: super::super::Foundation::HWND, pad: *mut AUTO_SCROLL_DATA, pptnow: *const super::super::Foundation::POINT) -> windows_core::BOOL {
    windows_core::link!("shell32.dll" "system" fn DAD_AutoScroll(hwnd : super::super::Foundation:: HWND, pad : *mut AUTO_SCROLL_DATA, pptnow : *const super::super::Foundation:: POINT) -> windows_core::BOOL);
    unsafe { DAD_AutoScroll(hwnd, pad as _, pptnow) }
}
#[inline]
pub unsafe fn DAD_DragEnterEx(hwndtarget: super::super::Foundation::HWND, ptstart: super::super::Foundation::POINT) -> windows_core::BOOL {
    windows_core::link!("shell32.dll" "system" fn DAD_DragEnterEx(hwndtarget : super::super::Foundation:: HWND, ptstart : super::super::Foundation:: POINT) -> windows_core::BOOL);
    unsafe { DAD_DragEnterEx(hwndtarget, core::mem::transmute(ptstart)) }
}
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn DAD_DragEnterEx2<P2>(hwndtarget: super::super::Foundation::HWND, ptstart: super::super::Foundation::POINT, pdtobject: P2) -> windows_core::BOOL
where
    P2: windows_core::Param<super::super::System::Com::IDataObject>,
{
    windows_core::link!("shell32.dll" "system" fn DAD_DragEnterEx2(hwndtarget : super::super::Foundation:: HWND, ptstart : super::super::Foundation:: POINT, pdtobject : * mut core::ffi::c_void) -> windows_core::BOOL);
    unsafe { DAD_DragEnterEx2(hwndtarget, core::mem::transmute(ptstart), pdtobject.param().abi()) }
}
#[inline]
pub unsafe fn DAD_DragLeave() -> windows_core::BOOL {
    windows_core::link!("shell32.dll" "system" fn DAD_DragLeave() -> windows_core::BOOL);
    unsafe { DAD_DragLeave() }
}
#[inline]
pub unsafe fn DAD_DragMove(pt: super::super::Foundation::POINT) -> windows_core::BOOL {
    windows_core::link!("shell32.dll" "system" fn DAD_DragMove(pt : super::super::Foundation:: POINT) -> windows_core::BOOL);
    unsafe { DAD_DragMove(core::mem::transmute(pt)) }
}
#[cfg(feature = "Win32_UI_Controls")]
#[inline]
pub unsafe fn DAD_SetDragImage(him: super::Controls::HIMAGELIST, pptoffset: *mut super::super::Foundation::POINT) -> windows_core::BOOL {
    windows_core::link!("shell32.dll" "system" fn DAD_SetDragImage(him : super::Controls:: HIMAGELIST, pptoffset : *mut super::super::Foundation:: POINT) -> windows_core::BOOL);
    unsafe { DAD_SetDragImage(him, pptoffset as _) }
}
#[inline]
pub unsafe fn DAD_ShowDragImage(fshow: bool) -> windows_core::BOOL {
    windows_core::link!("shell32.dll" "system" fn DAD_ShowDragImage(fshow : windows_core::BOOL) -> windows_core::BOOL);
    unsafe { DAD_ShowDragImage(fshow.into()) }
}
#[inline]
pub unsafe fn DefSubclassProc(hwnd: super::super::Foundation::HWND, umsg: u32, wparam: super::super::Foundation::WPARAM, lparam: super::super::Foundation::LPARAM) -> super::super::Foundation::LRESULT {
    windows_core::link!("comctl32.dll" "system" fn DefSubclassProc(hwnd : super::super::Foundation:: HWND, umsg : u32, wparam : super::super::Foundation:: WPARAM, lparam : super::super::Foundation:: LPARAM) -> super::super::Foundation:: LRESULT);
    unsafe { DefSubclassProc(hwnd, umsg, wparam, lparam) }
}
#[inline]
pub unsafe fn DeleteProfileA<P0, P1, P2>(lpsidstring: P0, lpprofilepath: P1, lpcomputername: P2) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCSTR>,
    P1: windows_core::Param<windows_core::PCSTR>,
    P2: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("userenv.dll" "system" fn DeleteProfileA(lpsidstring : windows_core::PCSTR, lpprofilepath : windows_core::PCSTR, lpcomputername : windows_core::PCSTR) -> windows_core::BOOL);
    unsafe { DeleteProfileA(lpsidstring.param().abi(), lpprofilepath.param().abi(), lpcomputername.param().abi()).ok() }
}
#[inline]
pub unsafe fn DeleteProfileW<P0, P1, P2>(lpsidstring: P0, lpprofilepath: P1, lpcomputername: P2) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
    P2: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("userenv.dll" "system" fn DeleteProfileW(lpsidstring : windows_core::PCWSTR, lpprofilepath : windows_core::PCWSTR, lpcomputername : windows_core::PCWSTR) -> windows_core::BOOL);
    unsafe { DeleteProfileW(lpsidstring.param().abi(), lpprofilepath.param().abi(), lpcomputername.param().abi()).ok() }
}
#[inline]
pub unsafe fn DoEnvironmentSubstA(pszsrc: &mut [u8]) -> u32 {
    windows_core::link!("shell32.dll" "system" fn DoEnvironmentSubstA(pszsrc : windows_core::PSTR, cchsrc : u32) -> u32);
    unsafe { DoEnvironmentSubstA(core::mem::transmute(pszsrc.as_ptr()), pszsrc.len().try_into().unwrap()) }
}
#[inline]
pub unsafe fn DoEnvironmentSubstW(pszsrc: &mut [u16]) -> u32 {
    windows_core::link!("shell32.dll" "system" fn DoEnvironmentSubstW(pszsrc : windows_core::PWSTR, cchsrc : u32) -> u32);
    unsafe { DoEnvironmentSubstW(core::mem::transmute(pszsrc.as_ptr()), pszsrc.len().try_into().unwrap()) }
}
#[inline]
pub unsafe fn DragAcceptFiles(hwnd: super::super::Foundation::HWND, faccept: bool) {
    windows_core::link!("shell32.dll" "system" fn DragAcceptFiles(hwnd : super::super::Foundation:: HWND, faccept : windows_core::BOOL));
    unsafe { DragAcceptFiles(hwnd, faccept.into()) }
}
#[inline]
pub unsafe fn DragFinish(hdrop: HDROP) {
    windows_core::link!("shell32.dll" "system" fn DragFinish(hdrop : HDROP));
    unsafe { DragFinish(hdrop) }
}
#[inline]
pub unsafe fn DragQueryFileA(hdrop: HDROP, ifile: u32, lpszfile: Option<&mut [u8]>) -> u32 {
    windows_core::link!("shell32.dll" "system" fn DragQueryFileA(hdrop : HDROP, ifile : u32, lpszfile : windows_core::PSTR, cch : u32) -> u32);
    unsafe { DragQueryFileA(hdrop, ifile, core::mem::transmute(lpszfile.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), lpszfile.as_deref().map_or(0, |slice| slice.len().try_into().unwrap())) }
}
#[inline]
pub unsafe fn DragQueryFileW(hdrop: HDROP, ifile: u32, lpszfile: Option<&mut [u16]>) -> u32 {
    windows_core::link!("shell32.dll" "system" fn DragQueryFileW(hdrop : HDROP, ifile : u32, lpszfile : windows_core::PWSTR, cch : u32) -> u32);
    unsafe { DragQueryFileW(hdrop, ifile, core::mem::transmute(lpszfile.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), lpszfile.as_deref().map_or(0, |slice| slice.len().try_into().unwrap())) }
}
#[inline]
pub unsafe fn DragQueryPoint(hdrop: HDROP, ppt: *mut super::super::Foundation::POINT) -> windows_core::BOOL {
    windows_core::link!("shell32.dll" "system" fn DragQueryPoint(hdrop : HDROP, ppt : *mut super::super::Foundation:: POINT) -> windows_core::BOOL);
    unsafe { DragQueryPoint(hdrop, ppt as _) }
}
#[inline]
pub unsafe fn DriveType(idrive: i32) -> i32 {
    windows_core::link!("shell32.dll" "system" fn DriveType(idrive : i32) -> i32);
    unsafe { DriveType(idrive) }
}
#[cfg(feature = "Win32_UI_WindowsAndMessaging")]
#[inline]
pub unsafe fn DuplicateIcon(hinst: Option<super::super::Foundation::HINSTANCE>, hicon: super::WindowsAndMessaging::HICON) -> super::WindowsAndMessaging::HICON {
    windows_core::link!("shell32.dll" "system" fn DuplicateIcon(hinst : super::super::Foundation:: HINSTANCE, hicon : super::WindowsAndMessaging:: HICON) -> super::WindowsAndMessaging:: HICON);
    unsafe { DuplicateIcon(hinst.unwrap_or(core::mem::zeroed()) as _, hicon) }
}
#[cfg(feature = "Win32_UI_WindowsAndMessaging")]
#[inline]
pub unsafe fn ExtractAssociatedIconA(hinst: Option<super::super::Foundation::HINSTANCE>, psziconpath: &mut [u8; 128], piicon: *mut u16) -> super::WindowsAndMessaging::HICON {
    windows_core::link!("shell32.dll" "system" fn ExtractAssociatedIconA(hinst : super::super::Foundation:: HINSTANCE, psziconpath : windows_core::PSTR, piicon : *mut u16) -> super::WindowsAndMessaging:: HICON);
    unsafe { ExtractAssociatedIconA(hinst.unwrap_or(core::mem::zeroed()) as _, core::mem::transmute(psziconpath.as_ptr()), piicon as _) }
}
#[cfg(feature = "Win32_UI_WindowsAndMessaging")]
#[inline]
pub unsafe fn ExtractAssociatedIconExA(hinst: Option<super::super::Foundation::HINSTANCE>, psziconpath: &mut [u8; 128], piiconindex: *mut u16, piiconid: *mut u16) -> super::WindowsAndMessaging::HICON {
    windows_core::link!("shell32.dll" "system" fn ExtractAssociatedIconExA(hinst : super::super::Foundation:: HINSTANCE, psziconpath : windows_core::PSTR, piiconindex : *mut u16, piiconid : *mut u16) -> super::WindowsAndMessaging:: HICON);
    unsafe { ExtractAssociatedIconExA(hinst.unwrap_or(core::mem::zeroed()) as _, core::mem::transmute(psziconpath.as_ptr()), piiconindex as _, piiconid as _) }
}
#[cfg(feature = "Win32_UI_WindowsAndMessaging")]
#[inline]
pub unsafe fn ExtractAssociatedIconExW(hinst: Option<super::super::Foundation::HINSTANCE>, psziconpath: &mut [u16; 128], piiconindex: *mut u16, piiconid: *mut u16) -> super::WindowsAndMessaging::HICON {
    windows_core::link!("shell32.dll" "system" fn ExtractAssociatedIconExW(hinst : super::super::Foundation:: HINSTANCE, psziconpath : windows_core::PWSTR, piiconindex : *mut u16, piiconid : *mut u16) -> super::WindowsAndMessaging:: HICON);
    unsafe { ExtractAssociatedIconExW(hinst.unwrap_or(core::mem::zeroed()) as _, core::mem::transmute(psziconpath.as_ptr()), piiconindex as _, piiconid as _) }
}
#[cfg(feature = "Win32_UI_WindowsAndMessaging")]
#[inline]
pub unsafe fn ExtractAssociatedIconW(hinst: Option<super::super::Foundation::HINSTANCE>, psziconpath: &mut [u16; 128], piicon: *mut u16) -> super::WindowsAndMessaging::HICON {
    windows_core::link!("shell32.dll" "system" fn ExtractAssociatedIconW(hinst : super::super::Foundation:: HINSTANCE, psziconpath : windows_core::PWSTR, piicon : *mut u16) -> super::WindowsAndMessaging:: HICON);
    unsafe { ExtractAssociatedIconW(hinst.unwrap_or(core::mem::zeroed()) as _, core::mem::transmute(psziconpath.as_ptr()), piicon as _) }
}
#[cfg(feature = "Win32_UI_WindowsAndMessaging")]
#[inline]
pub unsafe fn ExtractIconA<P1>(hinst: Option<super::super::Foundation::HINSTANCE>, pszexefilename: P1, niconindex: u32) -> super::WindowsAndMessaging::HICON
where
    P1: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shell32.dll" "system" fn ExtractIconA(hinst : super::super::Foundation:: HINSTANCE, pszexefilename : windows_core::PCSTR, niconindex : u32) -> super::WindowsAndMessaging:: HICON);
    unsafe { ExtractIconA(hinst.unwrap_or(core::mem::zeroed()) as _, pszexefilename.param().abi(), niconindex) }
}
#[cfg(feature = "Win32_UI_WindowsAndMessaging")]
#[inline]
pub unsafe fn ExtractIconExA<P0>(lpszfile: P0, niconindex: i32, phiconlarge: Option<*mut super::WindowsAndMessaging::HICON>, phiconsmall: Option<*mut super::WindowsAndMessaging::HICON>, nicons: u32) -> u32
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shell32.dll" "system" fn ExtractIconExA(lpszfile : windows_core::PCSTR, niconindex : i32, phiconlarge : *mut super::WindowsAndMessaging:: HICON, phiconsmall : *mut super::WindowsAndMessaging:: HICON, nicons : u32) -> u32);
    unsafe { ExtractIconExA(lpszfile.param().abi(), niconindex, phiconlarge.unwrap_or(core::mem::zeroed()) as _, phiconsmall.unwrap_or(core::mem::zeroed()) as _, nicons) }
}
#[cfg(feature = "Win32_UI_WindowsAndMessaging")]
#[inline]
pub unsafe fn ExtractIconExW<P0>(lpszfile: P0, niconindex: i32, phiconlarge: Option<*mut super::WindowsAndMessaging::HICON>, phiconsmall: Option<*mut super::WindowsAndMessaging::HICON>, nicons: u32) -> u32
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shell32.dll" "system" fn ExtractIconExW(lpszfile : windows_core::PCWSTR, niconindex : i32, phiconlarge : *mut super::WindowsAndMessaging:: HICON, phiconsmall : *mut super::WindowsAndMessaging:: HICON, nicons : u32) -> u32);
    unsafe { ExtractIconExW(lpszfile.param().abi(), niconindex, phiconlarge.unwrap_or(core::mem::zeroed()) as _, phiconsmall.unwrap_or(core::mem::zeroed()) as _, nicons) }
}
#[cfg(feature = "Win32_UI_WindowsAndMessaging")]
#[inline]
pub unsafe fn ExtractIconW<P1>(hinst: Option<super::super::Foundation::HINSTANCE>, pszexefilename: P1, niconindex: u32) -> super::WindowsAndMessaging::HICON
where
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shell32.dll" "system" fn ExtractIconW(hinst : super::super::Foundation:: HINSTANCE, pszexefilename : windows_core::PCWSTR, niconindex : u32) -> super::WindowsAndMessaging:: HICON);
    unsafe { ExtractIconW(hinst.unwrap_or(core::mem::zeroed()) as _, pszexefilename.param().abi(), niconindex) }
}
#[inline]
pub unsafe fn FindExecutableA<P0, P1>(lpfile: P0, lpdirectory: P1, lpresult: &mut [u8; 260]) -> super::super::Foundation::HINSTANCE
where
    P0: windows_core::Param<windows_core::PCSTR>,
    P1: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shell32.dll" "system" fn FindExecutableA(lpfile : windows_core::PCSTR, lpdirectory : windows_core::PCSTR, lpresult : windows_core::PSTR) -> super::super::Foundation:: HINSTANCE);
    unsafe { FindExecutableA(lpfile.param().abi(), lpdirectory.param().abi(), core::mem::transmute(lpresult.as_ptr())) }
}
#[inline]
pub unsafe fn FindExecutableW<P0, P1>(lpfile: P0, lpdirectory: P1, lpresult: &mut [u16; 260]) -> super::super::Foundation::HINSTANCE
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shell32.dll" "system" fn FindExecutableW(lpfile : windows_core::PCWSTR, lpdirectory : windows_core::PCWSTR, lpresult : windows_core::PWSTR) -> super::super::Foundation:: HINSTANCE);
    unsafe { FindExecutableW(lpfile.param().abi(), lpdirectory.param().abi(), core::mem::transmute(lpresult.as_ptr())) }
}
#[inline]
pub unsafe fn GetAcceptLanguagesA(pszlanguages: windows_core::PSTR, pcchlanguages: *mut u32) -> windows_core::Result<()> {
    windows_core::link!("shlwapi.dll" "system" fn GetAcceptLanguagesA(pszlanguages : windows_core::PSTR, pcchlanguages : *mut u32) -> windows_core::HRESULT);
    unsafe { GetAcceptLanguagesA(core::mem::transmute(pszlanguages), pcchlanguages as _).ok() }
}
#[inline]
pub unsafe fn GetAcceptLanguagesW(pszlanguages: windows_core::PWSTR, pcchlanguages: *mut u32) -> windows_core::Result<()> {
    windows_core::link!("shlwapi.dll" "system" fn GetAcceptLanguagesW(pszlanguages : windows_core::PWSTR, pcchlanguages : *mut u32) -> windows_core::HRESULT);
    unsafe { GetAcceptLanguagesW(core::mem::transmute(pszlanguages), pcchlanguages as _).ok() }
}
#[inline]
pub unsafe fn GetAllUsersProfileDirectoryA(lpprofiledir: Option<windows_core::PSTR>, lpcchsize: *mut u32) -> windows_core::Result<()> {
    windows_core::link!("userenv.dll" "system" fn GetAllUsersProfileDirectoryA(lpprofiledir : windows_core::PSTR, lpcchsize : *mut u32) -> windows_core::BOOL);
    unsafe { GetAllUsersProfileDirectoryA(lpprofiledir.unwrap_or(core::mem::zeroed()) as _, lpcchsize as _).ok() }
}
#[inline]
pub unsafe fn GetAllUsersProfileDirectoryW(lpprofiledir: Option<windows_core::PWSTR>, lpcchsize: *mut u32) -> windows_core::Result<()> {
    windows_core::link!("userenv.dll" "system" fn GetAllUsersProfileDirectoryW(lpprofiledir : windows_core::PWSTR, lpcchsize : *mut u32) -> windows_core::BOOL);
    unsafe { GetAllUsersProfileDirectoryW(lpprofiledir.unwrap_or(core::mem::zeroed()) as _, lpcchsize as _).ok() }
}
#[inline]
pub unsafe fn GetCurrentProcessExplicitAppUserModelID() -> windows_core::Result<windows_core::PWSTR> {
    windows_core::link!("shell32.dll" "system" fn GetCurrentProcessExplicitAppUserModelID(appid : *mut windows_core::PWSTR) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        GetCurrentProcessExplicitAppUserModelID(&mut result__).map(|| result__)
    }
}
#[inline]
pub unsafe fn GetDefaultUserProfileDirectoryA(lpprofiledir: Option<windows_core::PSTR>, lpcchsize: *mut u32) -> windows_core::Result<()> {
    windows_core::link!("userenv.dll" "system" fn GetDefaultUserProfileDirectoryA(lpprofiledir : windows_core::PSTR, lpcchsize : *mut u32) -> windows_core::BOOL);
    unsafe { GetDefaultUserProfileDirectoryA(lpprofiledir.unwrap_or(core::mem::zeroed()) as _, lpcchsize as _).ok() }
}
#[inline]
pub unsafe fn GetDefaultUserProfileDirectoryW(lpprofiledir: Option<windows_core::PWSTR>, lpcchsize: *mut u32) -> windows_core::Result<()> {
    windows_core::link!("userenv.dll" "system" fn GetDefaultUserProfileDirectoryW(lpprofiledir : windows_core::PWSTR, lpcchsize : *mut u32) -> windows_core::BOOL);
    unsafe { GetDefaultUserProfileDirectoryW(lpprofiledir.unwrap_or(core::mem::zeroed()) as _, lpcchsize as _).ok() }
}
#[inline]
pub unsafe fn GetDpiForShellUIComponent(param0: SHELL_UI_COMPONENT) -> u32 {
    windows_core::link!("api-ms-win-shcore-scaling-l1-1-2.dll" "system" fn GetDpiForShellUIComponent(param0 : SHELL_UI_COMPONENT) -> u32);
    unsafe { GetDpiForShellUIComponent(param0) }
}
#[inline]
pub unsafe fn GetFileNameFromBrowse<P3, P4, P5, P6>(hwnd: Option<super::super::Foundation::HWND>, pszfilepath: &mut [u16], pszworkingdir: P3, pszdefext: P4, pszfilters: P5, psztitle: P6) -> windows_core::BOOL
where
    P3: windows_core::Param<windows_core::PCWSTR>,
    P4: windows_core::Param<windows_core::PCWSTR>,
    P5: windows_core::Param<windows_core::PCWSTR>,
    P6: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shell32.dll" "system" fn GetFileNameFromBrowse(hwnd : super::super::Foundation:: HWND, pszfilepath : windows_core::PWSTR, cchfilepath : u32, pszworkingdir : windows_core::PCWSTR, pszdefext : windows_core::PCWSTR, pszfilters : windows_core::PCWSTR, psztitle : windows_core::PCWSTR) -> windows_core::BOOL);
    unsafe { GetFileNameFromBrowse(hwnd.unwrap_or(core::mem::zeroed()) as _, core::mem::transmute(pszfilepath.as_ptr()), pszfilepath.len().try_into().unwrap(), pszworkingdir.param().abi(), pszdefext.param().abi(), pszfilters.param().abi(), psztitle.param().abi()) }
}
#[cfg(feature = "Win32_UI_WindowsAndMessaging")]
#[inline]
pub unsafe fn GetMenuContextHelpId(param0: super::WindowsAndMessaging::HMENU) -> u32 {
    windows_core::link!("user32.dll" "system" fn GetMenuContextHelpId(param0 : super::WindowsAndMessaging:: HMENU) -> u32);
    unsafe { GetMenuContextHelpId(param0) }
}
#[cfg(feature = "Win32_UI_WindowsAndMessaging")]
#[inline]
pub unsafe fn GetMenuPosFromID(hmenu: super::WindowsAndMessaging::HMENU, id: u32) -> i32 {
    windows_core::link!("shlwapi.dll" "system" fn GetMenuPosFromID(hmenu : super::WindowsAndMessaging:: HMENU, id : u32) -> i32);
    unsafe { GetMenuPosFromID(hmenu, id) }
}
#[inline]
pub unsafe fn GetProfileType(dwflags: *mut u32) -> windows_core::Result<()> {
    windows_core::link!("userenv.dll" "system" fn GetProfileType(dwflags : *mut u32) -> windows_core::BOOL);
    unsafe { GetProfileType(dwflags as _).ok() }
}
#[inline]
pub unsafe fn GetProfilesDirectoryA(lpprofiledir: Option<windows_core::PSTR>, lpcchsize: *mut u32) -> windows_core::Result<()> {
    windows_core::link!("userenv.dll" "system" fn GetProfilesDirectoryA(lpprofiledir : windows_core::PSTR, lpcchsize : *mut u32) -> windows_core::BOOL);
    unsafe { GetProfilesDirectoryA(lpprofiledir.unwrap_or(core::mem::zeroed()) as _, lpcchsize as _).ok() }
}
#[inline]
pub unsafe fn GetProfilesDirectoryW(lpprofiledir: Option<windows_core::PWSTR>, lpcchsize: *mut u32) -> windows_core::Result<()> {
    windows_core::link!("userenv.dll" "system" fn GetProfilesDirectoryW(lpprofiledir : windows_core::PWSTR, lpcchsize : *mut u32) -> windows_core::BOOL);
    unsafe { GetProfilesDirectoryW(lpprofiledir.unwrap_or(core::mem::zeroed()) as _, lpcchsize as _).ok() }
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn GetScaleFactorForDevice(devicetype: DISPLAY_DEVICE_TYPE) -> Common::DEVICE_SCALE_FACTOR {
    windows_core::link!("api-ms-win-shcore-scaling-l1-1-0.dll" "system" fn GetScaleFactorForDevice(devicetype : DISPLAY_DEVICE_TYPE) -> Common:: DEVICE_SCALE_FACTOR);
    unsafe { GetScaleFactorForDevice(devicetype) }
}
#[cfg(all(feature = "Win32_Graphics_Gdi", feature = "Win32_UI_Shell_Common"))]
#[inline]
pub unsafe fn GetScaleFactorForMonitor(hmon: super::super::Graphics::Gdi::HMONITOR) -> windows_core::Result<Common::DEVICE_SCALE_FACTOR> {
    windows_core::link!("api-ms-win-shcore-scaling-l1-1-1.dll" "system" fn GetScaleFactorForMonitor(hmon : super::super::Graphics::Gdi:: HMONITOR, pscale : *mut Common:: DEVICE_SCALE_FACTOR) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        GetScaleFactorForMonitor(hmon, &mut result__).map(|| result__)
    }
}
#[inline]
pub unsafe fn GetUserProfileDirectoryA(htoken: super::super::Foundation::HANDLE, lpprofiledir: Option<windows_core::PSTR>, lpcchsize: *mut u32) -> windows_core::Result<()> {
    windows_core::link!("userenv.dll" "system" fn GetUserProfileDirectoryA(htoken : super::super::Foundation:: HANDLE, lpprofiledir : windows_core::PSTR, lpcchsize : *mut u32) -> windows_core::BOOL);
    unsafe { GetUserProfileDirectoryA(htoken, lpprofiledir.unwrap_or(core::mem::zeroed()) as _, lpcchsize as _).ok() }
}
#[inline]
pub unsafe fn GetUserProfileDirectoryW(htoken: super::super::Foundation::HANDLE, lpprofiledir: Option<windows_core::PWSTR>, lpcchsize: *mut u32) -> windows_core::Result<()> {
    windows_core::link!("userenv.dll" "system" fn GetUserProfileDirectoryW(htoken : super::super::Foundation:: HANDLE, lpprofiledir : windows_core::PWSTR, lpcchsize : *mut u32) -> windows_core::BOOL);
    unsafe { GetUserProfileDirectoryW(htoken, lpprofiledir.unwrap_or(core::mem::zeroed()) as _, lpcchsize as _).ok() }
}
#[inline]
pub unsafe fn GetWindowContextHelpId(param0: super::super::Foundation::HWND) -> u32 {
    windows_core::link!("user32.dll" "system" fn GetWindowContextHelpId(param0 : super::super::Foundation:: HWND) -> u32);
    unsafe { GetWindowContextHelpId(param0) }
}
#[inline]
pub unsafe fn GetWindowSubclass(hwnd: super::super::Foundation::HWND, pfnsubclass: SUBCLASSPROC, uidsubclass: usize, pdwrefdata: Option<*mut usize>) -> windows_core::BOOL {
    windows_core::link!("comctl32.dll" "system" fn GetWindowSubclass(hwnd : super::super::Foundation:: HWND, pfnsubclass : SUBCLASSPROC, uidsubclass : usize, pdwrefdata : *mut usize) -> windows_core::BOOL);
    unsafe { GetWindowSubclass(hwnd, pfnsubclass, uidsubclass, pdwrefdata.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(feature = "Win32_Graphics_Gdi")]
#[inline]
pub unsafe fn HMONITOR_UserFree(param0: *const u32, param1: *const super::super::Graphics::Gdi::HMONITOR) {
    windows_core::link!("ole32.dll" "system" fn HMONITOR_UserFree(param0 : *const u32, param1 : *const super::super::Graphics::Gdi:: HMONITOR));
    unsafe { HMONITOR_UserFree(param0, param1) }
}
#[cfg(feature = "Win32_Graphics_Gdi")]
#[inline]
pub unsafe fn HMONITOR_UserFree64(param0: *const u32, param1: *const super::super::Graphics::Gdi::HMONITOR) {
    windows_core::link!("ole32.dll" "system" fn HMONITOR_UserFree64(param0 : *const u32, param1 : *const super::super::Graphics::Gdi:: HMONITOR));
    unsafe { HMONITOR_UserFree64(param0, param1) }
}
#[cfg(feature = "Win32_Graphics_Gdi")]
#[inline]
pub unsafe fn HMONITOR_UserMarshal(param0: *const u32, param1: *mut u8, param2: *const super::super::Graphics::Gdi::HMONITOR) -> *mut u8 {
    windows_core::link!("ole32.dll" "system" fn HMONITOR_UserMarshal(param0 : *const u32, param1 : *mut u8, param2 : *const super::super::Graphics::Gdi:: HMONITOR) -> *mut u8);
    unsafe { HMONITOR_UserMarshal(param0, param1 as _, param2) }
}
#[cfg(feature = "Win32_Graphics_Gdi")]
#[inline]
pub unsafe fn HMONITOR_UserMarshal64(param0: *const u32, param1: *mut u8, param2: *const super::super::Graphics::Gdi::HMONITOR) -> *mut u8 {
    windows_core::link!("ole32.dll" "system" fn HMONITOR_UserMarshal64(param0 : *const u32, param1 : *mut u8, param2 : *const super::super::Graphics::Gdi:: HMONITOR) -> *mut u8);
    unsafe { HMONITOR_UserMarshal64(param0, param1 as _, param2) }
}
#[cfg(feature = "Win32_Graphics_Gdi")]
#[inline]
pub unsafe fn HMONITOR_UserSize(param0: *const u32, param1: u32, param2: *const super::super::Graphics::Gdi::HMONITOR) -> u32 {
    windows_core::link!("ole32.dll" "system" fn HMONITOR_UserSize(param0 : *const u32, param1 : u32, param2 : *const super::super::Graphics::Gdi:: HMONITOR) -> u32);
    unsafe { HMONITOR_UserSize(param0, param1, param2) }
}
#[cfg(feature = "Win32_Graphics_Gdi")]
#[inline]
pub unsafe fn HMONITOR_UserSize64(param0: *const u32, param1: u32, param2: *const super::super::Graphics::Gdi::HMONITOR) -> u32 {
    windows_core::link!("ole32.dll" "system" fn HMONITOR_UserSize64(param0 : *const u32, param1 : u32, param2 : *const super::super::Graphics::Gdi:: HMONITOR) -> u32);
    unsafe { HMONITOR_UserSize64(param0, param1, param2) }
}
#[cfg(feature = "Win32_Graphics_Gdi")]
#[inline]
pub unsafe fn HMONITOR_UserUnmarshal(param0: *const u32, param1: *const u8, param2: *mut super::super::Graphics::Gdi::HMONITOR) -> *mut u8 {
    windows_core::link!("ole32.dll" "system" fn HMONITOR_UserUnmarshal(param0 : *const u32, param1 : *const u8, param2 : *mut super::super::Graphics::Gdi:: HMONITOR) -> *mut u8);
    unsafe { HMONITOR_UserUnmarshal(param0, param1, param2 as _) }
}
#[cfg(feature = "Win32_Graphics_Gdi")]
#[inline]
pub unsafe fn HMONITOR_UserUnmarshal64(param0: *const u32, param1: *const u8, param2: *mut super::super::Graphics::Gdi::HMONITOR) -> *mut u8 {
    windows_core::link!("ole32.dll" "system" fn HMONITOR_UserUnmarshal64(param0 : *const u32, param1 : *const u8, param2 : *mut super::super::Graphics::Gdi:: HMONITOR) -> *mut u8);
    unsafe { HMONITOR_UserUnmarshal64(param0, param1, param2 as _) }
}
#[inline]
pub unsafe fn HashData(pbdata: &[u8], pbhash: &mut [u8]) -> windows_core::Result<()> {
    windows_core::link!("shlwapi.dll" "system" fn HashData(pbdata : *const u8, cbdata : u32, pbhash : *mut u8, cbhash : u32) -> windows_core::HRESULT);
    unsafe { HashData(core::mem::transmute(pbdata.as_ptr()), pbdata.len().try_into().unwrap(), core::mem::transmute(pbhash.as_ptr()), pbhash.len().try_into().unwrap()).ok() }
}
#[inline]
pub unsafe fn HlinkClone<P0, P2, T>(pihl: P0, pihlsiteforclone: P2, dwsitedata: u32) -> windows_core::Result<T>
where
    P0: windows_core::Param<IHlink>,
    P2: windows_core::Param<IHlinkSite>,
    T: windows_core::Interface,
{
    windows_core::link!("hlink.dll" "system" fn HlinkClone(pihl : * mut core::ffi::c_void, riid : *const windows_core::GUID, pihlsiteforclone : * mut core::ffi::c_void, dwsitedata : u32, ppvobj : *mut *mut core::ffi::c_void) -> windows_core::HRESULT);
    let mut result__ = core::ptr::null_mut();
    unsafe { HlinkClone(pihl.param().abi(), &T::IID, pihlsiteforclone.param().abi(), dwsitedata, &mut result__).and_then(|| windows_core::Type::from_abi(result__)) }
}
#[inline]
pub unsafe fn HlinkCreateBrowseContext<P0, T>(piunkouter: P0) -> windows_core::Result<T>
where
    P0: windows_core::Param<windows_core::IUnknown>,
    T: windows_core::Interface,
{
    windows_core::link!("hlink.dll" "system" fn HlinkCreateBrowseContext(piunkouter : * mut core::ffi::c_void, riid : *const windows_core::GUID, ppvobj : *mut *mut core::ffi::c_void) -> windows_core::HRESULT);
    let mut result__ = core::ptr::null_mut();
    unsafe { HlinkCreateBrowseContext(piunkouter.param().abi(), &T::IID, &mut result__).and_then(|| windows_core::Type::from_abi(result__)) }
}
#[inline]
pub unsafe fn HlinkCreateExtensionServices<P0, P2, P3, P4, T>(pwzadditionalheaders: P0, phwnd: super::super::Foundation::HWND, pszusername: P2, pszpassword: P3, piunkouter: P4) -> windows_core::Result<T>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P2: windows_core::Param<windows_core::PCWSTR>,
    P3: windows_core::Param<windows_core::PCWSTR>,
    P4: windows_core::Param<windows_core::IUnknown>,
    T: windows_core::Interface,
{
    windows_core::link!("hlink.dll" "system" fn HlinkCreateExtensionServices(pwzadditionalheaders : windows_core::PCWSTR, phwnd : super::super::Foundation:: HWND, pszusername : windows_core::PCWSTR, pszpassword : windows_core::PCWSTR, piunkouter : * mut core::ffi::c_void, riid : *const windows_core::GUID, ppvobj : *mut *mut core::ffi::c_void) -> windows_core::HRESULT);
    let mut result__ = core::ptr::null_mut();
    unsafe { HlinkCreateExtensionServices(pwzadditionalheaders.param().abi(), phwnd, pszusername.param().abi(), pszpassword.param().abi(), piunkouter.param().abi(), &T::IID, &mut result__).and_then(|| windows_core::Type::from_abi(result__)) }
}
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn HlinkCreateFromData<P0, P1, P3, T>(pidataobj: P0, pihlsite: P1, dwsitedata: u32, piunkouter: P3) -> windows_core::Result<T>
where
    P0: windows_core::Param<super::super::System::Com::IDataObject>,
    P1: windows_core::Param<IHlinkSite>,
    P3: windows_core::Param<windows_core::IUnknown>,
    T: windows_core::Interface,
{
    windows_core::link!("hlink.dll" "system" fn HlinkCreateFromData(pidataobj : * mut core::ffi::c_void, pihlsite : * mut core::ffi::c_void, dwsitedata : u32, piunkouter : * mut core::ffi::c_void, riid : *const windows_core::GUID, ppvobj : *mut *mut core::ffi::c_void) -> windows_core::HRESULT);
    let mut result__ = core::ptr::null_mut();
    unsafe { HlinkCreateFromData(pidataobj.param().abi(), pihlsite.param().abi(), dwsitedata, piunkouter.param().abi(), &T::IID, &mut result__).and_then(|| windows_core::Type::from_abi(result__)) }
}
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn HlinkCreateFromMoniker<P0, P1, P2, P3, P5, T>(pimktrgt: P0, pwzlocation: P1, pwzfriendlyname: P2, pihlsite: P3, dwsitedata: u32, piunkouter: P5) -> windows_core::Result<T>
where
    P0: windows_core::Param<super::super::System::Com::IMoniker>,
    P1: windows_core::Param<windows_core::PCWSTR>,
    P2: windows_core::Param<windows_core::PCWSTR>,
    P3: windows_core::Param<IHlinkSite>,
    P5: windows_core::Param<windows_core::IUnknown>,
    T: windows_core::Interface,
{
    windows_core::link!("hlink.dll" "system" fn HlinkCreateFromMoniker(pimktrgt : * mut core::ffi::c_void, pwzlocation : windows_core::PCWSTR, pwzfriendlyname : windows_core::PCWSTR, pihlsite : * mut core::ffi::c_void, dwsitedata : u32, piunkouter : * mut core::ffi::c_void, riid : *const windows_core::GUID, ppvobj : *mut *mut core::ffi::c_void) -> windows_core::HRESULT);
    let mut result__ = core::ptr::null_mut();
    unsafe { HlinkCreateFromMoniker(pimktrgt.param().abi(), pwzlocation.param().abi(), pwzfriendlyname.param().abi(), pihlsite.param().abi(), dwsitedata, piunkouter.param().abi(), &T::IID, &mut result__).and_then(|| windows_core::Type::from_abi(result__)) }
}
#[inline]
pub unsafe fn HlinkCreateFromString<P0, P1, P2, P3, P5, T>(pwztarget: P0, pwzlocation: P1, pwzfriendlyname: P2, pihlsite: P3, dwsitedata: u32, piunkouter: P5) -> windows_core::Result<T>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
    P2: windows_core::Param<windows_core::PCWSTR>,
    P3: windows_core::Param<IHlinkSite>,
    P5: windows_core::Param<windows_core::IUnknown>,
    T: windows_core::Interface,
{
    windows_core::link!("hlink.dll" "system" fn HlinkCreateFromString(pwztarget : windows_core::PCWSTR, pwzlocation : windows_core::PCWSTR, pwzfriendlyname : windows_core::PCWSTR, pihlsite : * mut core::ffi::c_void, dwsitedata : u32, piunkouter : * mut core::ffi::c_void, riid : *const windows_core::GUID, ppvobj : *mut *mut core::ffi::c_void) -> windows_core::HRESULT);
    let mut result__ = core::ptr::null_mut();
    unsafe { HlinkCreateFromString(pwztarget.param().abi(), pwzlocation.param().abi(), pwzfriendlyname.param().abi(), pihlsite.param().abi(), dwsitedata, piunkouter.param().abi(), &T::IID, &mut result__).and_then(|| windows_core::Type::from_abi(result__)) }
}
#[inline]
pub unsafe fn HlinkCreateShortcut<P1, P2, P3>(grfhlshortcutf: u32, pihl: P1, pwzdir: P2, pwzfilename: P3, ppwzshortcutfile: *mut windows_core::PWSTR, dwreserved: u32) -> windows_core::Result<()>
where
    P1: windows_core::Param<IHlink>,
    P2: windows_core::Param<windows_core::PCWSTR>,
    P3: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("hlink.dll" "system" fn HlinkCreateShortcut(grfhlshortcutf : u32, pihl : * mut core::ffi::c_void, pwzdir : windows_core::PCWSTR, pwzfilename : windows_core::PCWSTR, ppwzshortcutfile : *mut windows_core::PWSTR, dwreserved : u32) -> windows_core::HRESULT);
    unsafe { HlinkCreateShortcut(grfhlshortcutf, pihl.param().abi(), pwzdir.param().abi(), pwzfilename.param().abi(), ppwzshortcutfile as _, dwreserved).ok() }
}
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn HlinkCreateShortcutFromMoniker<P1, P2, P3, P4>(grfhlshortcutf: u32, pimktarget: P1, pwzlocation: P2, pwzdir: P3, pwzfilename: P4, ppwzshortcutfile: *mut windows_core::PWSTR, dwreserved: u32) -> windows_core::Result<()>
where
    P1: windows_core::Param<super::super::System::Com::IMoniker>,
    P2: windows_core::Param<windows_core::PCWSTR>,
    P3: windows_core::Param<windows_core::PCWSTR>,
    P4: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("hlink.dll" "system" fn HlinkCreateShortcutFromMoniker(grfhlshortcutf : u32, pimktarget : * mut core::ffi::c_void, pwzlocation : windows_core::PCWSTR, pwzdir : windows_core::PCWSTR, pwzfilename : windows_core::PCWSTR, ppwzshortcutfile : *mut windows_core::PWSTR, dwreserved : u32) -> windows_core::HRESULT);
    unsafe { HlinkCreateShortcutFromMoniker(grfhlshortcutf, pimktarget.param().abi(), pwzlocation.param().abi(), pwzdir.param().abi(), pwzfilename.param().abi(), ppwzshortcutfile as _, dwreserved).ok() }
}
#[inline]
pub unsafe fn HlinkCreateShortcutFromString<P1, P2, P3, P4>(grfhlshortcutf: u32, pwztarget: P1, pwzlocation: P2, pwzdir: P3, pwzfilename: P4, ppwzshortcutfile: *mut windows_core::PWSTR, dwreserved: u32) -> windows_core::Result<()>
where
    P1: windows_core::Param<windows_core::PCWSTR>,
    P2: windows_core::Param<windows_core::PCWSTR>,
    P3: windows_core::Param<windows_core::PCWSTR>,
    P4: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("hlink.dll" "system" fn HlinkCreateShortcutFromString(grfhlshortcutf : u32, pwztarget : windows_core::PCWSTR, pwzlocation : windows_core::PCWSTR, pwzdir : windows_core::PCWSTR, pwzfilename : windows_core::PCWSTR, ppwzshortcutfile : *mut windows_core::PWSTR, dwreserved : u32) -> windows_core::HRESULT);
    unsafe { HlinkCreateShortcutFromString(grfhlshortcutf, pwztarget.param().abi(), pwzlocation.param().abi(), pwzdir.param().abi(), pwzfilename.param().abi(), ppwzshortcutfile as _, dwreserved).ok() }
}
#[inline]
pub unsafe fn HlinkGetSpecialReference(ureference: u32) -> windows_core::Result<windows_core::PWSTR> {
    windows_core::link!("hlink.dll" "system" fn HlinkGetSpecialReference(ureference : u32, ppwzreference : *mut windows_core::PWSTR) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        HlinkGetSpecialReference(ureference, &mut result__).map(|| result__)
    }
}
#[inline]
pub unsafe fn HlinkGetValueFromParams<P0, P1>(pwzparams: P0, pwzname: P1) -> windows_core::Result<windows_core::PWSTR>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("hlink.dll" "system" fn HlinkGetValueFromParams(pwzparams : windows_core::PCWSTR, pwzname : windows_core::PCWSTR, ppwzvalue : *mut windows_core::PWSTR) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        HlinkGetValueFromParams(pwzparams.param().abi(), pwzname.param().abi(), &mut result__).map(|| result__)
    }
}
#[inline]
pub unsafe fn HlinkIsShortcut<P0>(pwzfilename: P0) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("hlink.dll" "system" fn HlinkIsShortcut(pwzfilename : windows_core::PCWSTR) -> windows_core::HRESULT);
    unsafe { HlinkIsShortcut(pwzfilename.param().abi()).ok() }
}
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn HlinkNavigate<P0, P1, P3, P4, P5>(pihl: P0, pihlframe: P1, grfhlnf: u32, pbc: P3, pibsc: P4, pihlbc: P5) -> windows_core::Result<()>
where
    P0: windows_core::Param<IHlink>,
    P1: windows_core::Param<IHlinkFrame>,
    P3: windows_core::Param<super::super::System::Com::IBindCtx>,
    P4: windows_core::Param<super::super::System::Com::IBindStatusCallback>,
    P5: windows_core::Param<IHlinkBrowseContext>,
{
    windows_core::link!("hlink.dll" "system" fn HlinkNavigate(pihl : * mut core::ffi::c_void, pihlframe : * mut core::ffi::c_void, grfhlnf : u32, pbc : * mut core::ffi::c_void, pibsc : * mut core::ffi::c_void, pihlbc : * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe { HlinkNavigate(pihl.param().abi(), pihlframe.param().abi(), grfhlnf, pbc.param().abi(), pibsc.param().abi(), pihlbc.param().abi()).ok() }
}
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn HlinkNavigateToStringReference<P0, P1, P2, P4, P6, P7, P8>(pwztarget: P0, pwzlocation: P1, pihlsite: P2, dwsitedata: u32, pihlframe: P4, grfhlnf: u32, pibc: P6, pibsc: P7, pihlbc: P8) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
    P2: windows_core::Param<IHlinkSite>,
    P4: windows_core::Param<IHlinkFrame>,
    P6: windows_core::Param<super::super::System::Com::IBindCtx>,
    P7: windows_core::Param<super::super::System::Com::IBindStatusCallback>,
    P8: windows_core::Param<IHlinkBrowseContext>,
{
    windows_core::link!("hlink.dll" "system" fn HlinkNavigateToStringReference(pwztarget : windows_core::PCWSTR, pwzlocation : windows_core::PCWSTR, pihlsite : * mut core::ffi::c_void, dwsitedata : u32, pihlframe : * mut core::ffi::c_void, grfhlnf : u32, pibc : * mut core::ffi::c_void, pibsc : * mut core::ffi::c_void, pihlbc : * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe { HlinkNavigateToStringReference(pwztarget.param().abi(), pwzlocation.param().abi(), pihlsite.param().abi(), dwsitedata, pihlframe.param().abi(), grfhlnf, pibc.param().abi(), pibsc.param().abi(), pihlbc.param().abi()).ok() }
}
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn HlinkOnNavigate<P0, P1, P3, P4, P5>(pihlframe: P0, pihlbc: P1, grfhlnf: u32, pimktarget: P3, pwzlocation: P4, pwzfriendlyname: P5, puhlid: *mut u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<IHlinkFrame>,
    P1: windows_core::Param<IHlinkBrowseContext>,
    P3: windows_core::Param<super::super::System::Com::IMoniker>,
    P4: windows_core::Param<windows_core::PCWSTR>,
    P5: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("hlink.dll" "system" fn HlinkOnNavigate(pihlframe : * mut core::ffi::c_void, pihlbc : * mut core::ffi::c_void, grfhlnf : u32, pimktarget : * mut core::ffi::c_void, pwzlocation : windows_core::PCWSTR, pwzfriendlyname : windows_core::PCWSTR, puhlid : *mut u32) -> windows_core::HRESULT);
    unsafe { HlinkOnNavigate(pihlframe.param().abi(), pihlbc.param().abi(), grfhlnf, pimktarget.param().abi(), pwzlocation.param().abi(), pwzfriendlyname.param().abi(), puhlid as _).ok() }
}
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn HlinkOnRenameDocument<P1, P2, P3>(dwreserved: u32, pihlbc: P1, pimkold: P2, pimknew: P3) -> windows_core::Result<()>
where
    P1: windows_core::Param<IHlinkBrowseContext>,
    P2: windows_core::Param<super::super::System::Com::IMoniker>,
    P3: windows_core::Param<super::super::System::Com::IMoniker>,
{
    windows_core::link!("hlink.dll" "system" fn HlinkOnRenameDocument(dwreserved : u32, pihlbc : * mut core::ffi::c_void, pimkold : * mut core::ffi::c_void, pimknew : * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe { HlinkOnRenameDocument(dwreserved, pihlbc.param().abi(), pimkold.param().abi(), pimknew.param().abi()).ok() }
}
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn HlinkParseDisplayName<P0, P1>(pibc: P0, pwzdisplayname: P1, fnoforceabs: bool, pccheaten: *mut u32, ppimk: *mut Option<super::super::System::Com::IMoniker>) -> windows_core::Result<()>
where
    P0: windows_core::Param<super::super::System::Com::IBindCtx>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("hlink.dll" "system" fn HlinkParseDisplayName(pibc : * mut core::ffi::c_void, pwzdisplayname : windows_core::PCWSTR, fnoforceabs : windows_core::BOOL, pccheaten : *mut u32, ppimk : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe { HlinkParseDisplayName(pibc.param().abi(), pwzdisplayname.param().abi(), fnoforceabs.into(), pccheaten as _, core::mem::transmute(ppimk)).ok() }
}
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn HlinkPreprocessMoniker<P0, P1>(pibc: P0, pimkin: P1) -> windows_core::Result<super::super::System::Com::IMoniker>
where
    P0: windows_core::Param<super::super::System::Com::IBindCtx>,
    P1: windows_core::Param<super::super::System::Com::IMoniker>,
{
    windows_core::link!("hlink.dll" "system" fn HlinkPreprocessMoniker(pibc : * mut core::ffi::c_void, pimkin : * mut core::ffi::c_void, ppimkout : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        HlinkPreprocessMoniker(pibc.param().abi(), pimkin.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn HlinkQueryCreateFromData<P0>(pidataobj: P0) -> windows_core::Result<()>
where
    P0: windows_core::Param<super::super::System::Com::IDataObject>,
{
    windows_core::link!("hlink.dll" "system" fn HlinkQueryCreateFromData(pidataobj : * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe { HlinkQueryCreateFromData(pidataobj.param().abi()).ok() }
}
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn HlinkResolveMonikerForData<P0, P2, P5, P6>(pimkreference: P0, reserved: u32, pibc: P2, cfmtetc: u32, rgfmtetc: *mut super::super::System::Com::FORMATETC, pibsc: P5, pimkbase: P6) -> windows_core::Result<()>
where
    P0: windows_core::Param<super::super::System::Com::IMoniker>,
    P2: windows_core::Param<super::super::System::Com::IBindCtx>,
    P5: windows_core::Param<super::super::System::Com::IBindStatusCallback>,
    P6: windows_core::Param<super::super::System::Com::IMoniker>,
{
    windows_core::link!("hlink.dll" "system" fn HlinkResolveMonikerForData(pimkreference : * mut core::ffi::c_void, reserved : u32, pibc : * mut core::ffi::c_void, cfmtetc : u32, rgfmtetc : *mut super::super::System::Com:: FORMATETC, pibsc : * mut core::ffi::c_void, pimkbase : * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe { HlinkResolveMonikerForData(pimkreference.param().abi(), reserved, pibc.param().abi(), cfmtetc, rgfmtetc as _, pibsc.param().abi(), pimkbase.param().abi()).ok() }
}
#[inline]
pub unsafe fn HlinkResolveShortcut<P0, P1, P3>(pwzshortcutfilename: P0, pihlsite: P1, dwsitedata: u32, piunkouter: P3, riid: *const windows_core::GUID, ppvobj: *mut *mut core::ffi::c_void) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<IHlinkSite>,
    P3: windows_core::Param<windows_core::IUnknown>,
{
    windows_core::link!("hlink.dll" "system" fn HlinkResolveShortcut(pwzshortcutfilename : windows_core::PCWSTR, pihlsite : * mut core::ffi::c_void, dwsitedata : u32, piunkouter : * mut core::ffi::c_void, riid : *const windows_core::GUID, ppvobj : *mut *mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe { HlinkResolveShortcut(pwzshortcutfilename.param().abi(), pihlsite.param().abi(), dwsitedata, piunkouter.param().abi(), riid, ppvobj as _).ok() }
}
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn HlinkResolveShortcutToMoniker<P0>(pwzshortcutfilename: P0, ppimktarget: *mut Option<super::super::System::Com::IMoniker>, ppwzlocation: *mut windows_core::PWSTR) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("hlink.dll" "system" fn HlinkResolveShortcutToMoniker(pwzshortcutfilename : windows_core::PCWSTR, ppimktarget : *mut * mut core::ffi::c_void, ppwzlocation : *mut windows_core::PWSTR) -> windows_core::HRESULT);
    unsafe { HlinkResolveShortcutToMoniker(pwzshortcutfilename.param().abi(), core::mem::transmute(ppimktarget), ppwzlocation as _).ok() }
}
#[inline]
pub unsafe fn HlinkResolveShortcutToString<P0>(pwzshortcutfilename: P0, ppwztarget: *mut windows_core::PWSTR, ppwzlocation: *mut windows_core::PWSTR) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("hlink.dll" "system" fn HlinkResolveShortcutToString(pwzshortcutfilename : windows_core::PCWSTR, ppwztarget : *mut windows_core::PWSTR, ppwzlocation : *mut windows_core::PWSTR) -> windows_core::HRESULT);
    unsafe { HlinkResolveShortcutToString(pwzshortcutfilename.param().abi(), ppwztarget as _, ppwzlocation as _).ok() }
}
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn HlinkResolveStringForData<P0, P2, P5, P6>(pwzreference: P0, reserved: u32, pibc: P2, cfmtetc: u32, rgfmtetc: *mut super::super::System::Com::FORMATETC, pibsc: P5, pimkbase: P6) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P2: windows_core::Param<super::super::System::Com::IBindCtx>,
    P5: windows_core::Param<super::super::System::Com::IBindStatusCallback>,
    P6: windows_core::Param<super::super::System::Com::IMoniker>,
{
    windows_core::link!("hlink.dll" "system" fn HlinkResolveStringForData(pwzreference : windows_core::PCWSTR, reserved : u32, pibc : * mut core::ffi::c_void, cfmtetc : u32, rgfmtetc : *mut super::super::System::Com:: FORMATETC, pibsc : * mut core::ffi::c_void, pimkbase : * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe { HlinkResolveStringForData(pwzreference.param().abi(), reserved, pibc.param().abi(), cfmtetc, rgfmtetc as _, pibsc.param().abi(), pimkbase.param().abi()).ok() }
}
#[inline]
pub unsafe fn HlinkSetSpecialReference<P1>(ureference: u32, pwzreference: P1) -> windows_core::Result<()>
where
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("hlink.dll" "system" fn HlinkSetSpecialReference(ureference : u32, pwzreference : windows_core::PCWSTR) -> windows_core::HRESULT);
    unsafe { HlinkSetSpecialReference(ureference, pwzreference.param().abi()).ok() }
}
#[inline]
pub unsafe fn HlinkTranslateURL<P0>(pwzurl: P0, grfflags: u32) -> windows_core::Result<windows_core::PWSTR>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("hlink.dll" "system" fn HlinkTranslateURL(pwzurl : windows_core::PCWSTR, grfflags : u32, ppwztranslatedurl : *mut windows_core::PWSTR) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        HlinkTranslateURL(pwzurl.param().abi(), grfflags, &mut result__).map(|| result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn HlinkUpdateStackItem<P0, P1, P3, P4, P5>(pihlframe: P0, pihlbc: P1, uhlid: u32, pimktrgt: P3, pwzlocation: P4, pwzfriendlyname: P5) -> windows_core::Result<()>
where
    P0: windows_core::Param<IHlinkFrame>,
    P1: windows_core::Param<IHlinkBrowseContext>,
    P3: windows_core::Param<super::super::System::Com::IMoniker>,
    P4: windows_core::Param<windows_core::PCWSTR>,
    P5: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("hlink.dll" "system" fn HlinkUpdateStackItem(pihlframe : * mut core::ffi::c_void, pihlbc : * mut core::ffi::c_void, uhlid : u32, pimktrgt : * mut core::ffi::c_void, pwzlocation : windows_core::PCWSTR, pwzfriendlyname : windows_core::PCWSTR) -> windows_core::HRESULT);
    unsafe { HlinkUpdateStackItem(pihlframe.param().abi(), pihlbc.param().abi(), uhlid, pimktrgt.param().abi(), pwzlocation.param().abi(), pwzfriendlyname.param().abi()).ok() }
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn ILAppendID(pidl: Option<*const Common::ITEMIDLIST>, pmkid: *const Common::SHITEMID, fappend: bool) -> *mut Common::ITEMIDLIST {
    windows_core::link!("shell32.dll" "system" fn ILAppendID(pidl : *const Common:: ITEMIDLIST, pmkid : *const Common:: SHITEMID, fappend : windows_core::BOOL) -> *mut Common:: ITEMIDLIST);
    unsafe { ILAppendID(pidl.unwrap_or(core::mem::zeroed()) as _, pmkid, fappend.into()) }
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn ILClone(pidl: *const Common::ITEMIDLIST) -> *mut Common::ITEMIDLIST {
    windows_core::link!("shell32.dll" "system" fn ILClone(pidl : *const Common:: ITEMIDLIST) -> *mut Common:: ITEMIDLIST);
    unsafe { ILClone(pidl) }
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn ILCloneFirst(pidl: *const Common::ITEMIDLIST) -> *mut Common::ITEMIDLIST {
    windows_core::link!("shell32.dll" "system" fn ILCloneFirst(pidl : *const Common:: ITEMIDLIST) -> *mut Common:: ITEMIDLIST);
    unsafe { ILCloneFirst(pidl) }
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn ILCombine(pidl1: Option<*const Common::ITEMIDLIST>, pidl2: Option<*const Common::ITEMIDLIST>) -> *mut Common::ITEMIDLIST {
    windows_core::link!("shell32.dll" "system" fn ILCombine(pidl1 : *const Common:: ITEMIDLIST, pidl2 : *const Common:: ITEMIDLIST) -> *mut Common:: ITEMIDLIST);
    unsafe { ILCombine(pidl1.unwrap_or(core::mem::zeroed()) as _, pidl2.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn ILCreateFromPathA<P0>(pszpath: P0) -> *mut Common::ITEMIDLIST
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shell32.dll" "system" fn ILCreateFromPathA(pszpath : windows_core::PCSTR) -> *mut Common:: ITEMIDLIST);
    unsafe { ILCreateFromPathA(pszpath.param().abi()) }
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn ILCreateFromPathW<P0>(pszpath: P0) -> *mut Common::ITEMIDLIST
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shell32.dll" "system" fn ILCreateFromPathW(pszpath : windows_core::PCWSTR) -> *mut Common:: ITEMIDLIST);
    unsafe { ILCreateFromPathW(pszpath.param().abi()) }
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn ILFindChild(pidlparent: *const Common::ITEMIDLIST, pidlchild: *const Common::ITEMIDLIST) -> *mut Common::ITEMIDLIST {
    windows_core::link!("shell32.dll" "system" fn ILFindChild(pidlparent : *const Common:: ITEMIDLIST, pidlchild : *const Common:: ITEMIDLIST) -> *mut Common:: ITEMIDLIST);
    unsafe { ILFindChild(pidlparent, pidlchild) }
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn ILFindLastID(pidl: *const Common::ITEMIDLIST) -> *mut Common::ITEMIDLIST {
    windows_core::link!("shell32.dll" "system" fn ILFindLastID(pidl : *const Common:: ITEMIDLIST) -> *mut Common:: ITEMIDLIST);
    unsafe { ILFindLastID(pidl) }
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn ILFree(pidl: Option<*const Common::ITEMIDLIST>) {
    windows_core::link!("shell32.dll" "system" fn ILFree(pidl : *const Common:: ITEMIDLIST));
    unsafe { ILFree(pidl.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn ILGetNext(pidl: Option<*const Common::ITEMIDLIST>) -> *mut Common::ITEMIDLIST {
    windows_core::link!("shell32.dll" "system" fn ILGetNext(pidl : *const Common:: ITEMIDLIST) -> *mut Common:: ITEMIDLIST);
    unsafe { ILGetNext(pidl.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn ILGetSize(pidl: Option<*const Common::ITEMIDLIST>) -> u32 {
    windows_core::link!("shell32.dll" "system" fn ILGetSize(pidl : *const Common:: ITEMIDLIST) -> u32);
    unsafe { ILGetSize(pidl.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn ILIsEqual(pidl1: *const Common::ITEMIDLIST, pidl2: *const Common::ITEMIDLIST) -> windows_core::BOOL {
    windows_core::link!("shell32.dll" "system" fn ILIsEqual(pidl1 : *const Common:: ITEMIDLIST, pidl2 : *const Common:: ITEMIDLIST) -> windows_core::BOOL);
    unsafe { ILIsEqual(pidl1, pidl2) }
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn ILIsParent(pidl1: *const Common::ITEMIDLIST, pidl2: *const Common::ITEMIDLIST, fimmediate: bool) -> windows_core::BOOL {
    windows_core::link!("shell32.dll" "system" fn ILIsParent(pidl1 : *const Common:: ITEMIDLIST, pidl2 : *const Common:: ITEMIDLIST, fimmediate : windows_core::BOOL) -> windows_core::BOOL);
    unsafe { ILIsParent(pidl1, pidl2, fimmediate.into()) }
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_UI_Shell_Common"))]
#[inline]
pub unsafe fn ILLoadFromStreamEx<P0>(pstm: P0) -> windows_core::Result<*mut Common::ITEMIDLIST>
where
    P0: windows_core::Param<super::super::System::Com::IStream>,
{
    windows_core::link!("shell32.dll" "system" fn ILLoadFromStreamEx(pstm : * mut core::ffi::c_void, pidl : *mut *mut Common:: ITEMIDLIST) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        ILLoadFromStreamEx(pstm.param().abi(), &mut result__).map(|| result__)
    }
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn ILRemoveLastID(pidl: Option<*mut Common::ITEMIDLIST>) -> windows_core::BOOL {
    windows_core::link!("shell32.dll" "system" fn ILRemoveLastID(pidl : *mut Common:: ITEMIDLIST) -> windows_core::BOOL);
    unsafe { ILRemoveLastID(pidl.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_UI_Shell_Common"))]
#[inline]
pub unsafe fn ILSaveToStream<P0>(pstm: P0, pidl: *const Common::ITEMIDLIST) -> windows_core::Result<()>
where
    P0: windows_core::Param<super::super::System::Com::IStream>,
{
    windows_core::link!("shell32.dll" "system" fn ILSaveToStream(pstm : * mut core::ffi::c_void, pidl : *const Common:: ITEMIDLIST) -> windows_core::HRESULT);
    unsafe { ILSaveToStream(pstm.param().abi(), pidl).ok() }
}
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn IStream_Copy<P0, P1>(pstmfrom: P0, pstmto: P1, cb: u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<super::super::System::Com::IStream>,
    P1: windows_core::Param<super::super::System::Com::IStream>,
{
    windows_core::link!("shlwapi.dll" "system" fn IStream_Copy(pstmfrom : * mut core::ffi::c_void, pstmto : * mut core::ffi::c_void, cb : u32) -> windows_core::HRESULT);
    unsafe { IStream_Copy(pstmfrom.param().abi(), pstmto.param().abi(), cb).ok() }
}
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn IStream_Read<P0>(pstm: P0, pv: *mut core::ffi::c_void, cb: u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<super::super::System::Com::IStream>,
{
    windows_core::link!("shlwapi.dll" "system" fn IStream_Read(pstm : * mut core::ffi::c_void, pv : *mut core::ffi::c_void, cb : u32) -> windows_core::HRESULT);
    unsafe { IStream_Read(pstm.param().abi(), pv as _, cb).ok() }
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_UI_Shell_Common"))]
#[inline]
pub unsafe fn IStream_ReadPidl<P0>(pstm: P0) -> windows_core::Result<*mut Common::ITEMIDLIST>
where
    P0: windows_core::Param<super::super::System::Com::IStream>,
{
    windows_core::link!("shlwapi.dll" "system" fn IStream_ReadPidl(pstm : * mut core::ffi::c_void, ppidlout : *mut *mut Common:: ITEMIDLIST) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        IStream_ReadPidl(pstm.param().abi(), &mut result__).map(|| result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn IStream_ReadStr<P0>(pstm: P0) -> windows_core::Result<windows_core::PWSTR>
where
    P0: windows_core::Param<super::super::System::Com::IStream>,
{
    windows_core::link!("shlwapi.dll" "system" fn IStream_ReadStr(pstm : * mut core::ffi::c_void, ppsz : *mut windows_core::PWSTR) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        IStream_ReadStr(pstm.param().abi(), &mut result__).map(|| result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn IStream_Reset<P0>(pstm: P0) -> windows_core::Result<()>
where
    P0: windows_core::Param<super::super::System::Com::IStream>,
{
    windows_core::link!("shlwapi.dll" "system" fn IStream_Reset(pstm : * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe { IStream_Reset(pstm.param().abi()).ok() }
}
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn IStream_Size<P0>(pstm: P0) -> windows_core::Result<u64>
where
    P0: windows_core::Param<super::super::System::Com::IStream>,
{
    windows_core::link!("shlwapi.dll" "system" fn IStream_Size(pstm : * mut core::ffi::c_void, pui : *mut u64) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        IStream_Size(pstm.param().abi(), &mut result__).map(|| result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn IStream_Write<P0>(pstm: P0, pv: *const core::ffi::c_void, cb: u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<super::super::System::Com::IStream>,
{
    windows_core::link!("shlwapi.dll" "system" fn IStream_Write(pstm : * mut core::ffi::c_void, pv : *const core::ffi::c_void, cb : u32) -> windows_core::HRESULT);
    unsafe { IStream_Write(pstm.param().abi(), pv, cb).ok() }
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_UI_Shell_Common"))]
#[inline]
pub unsafe fn IStream_WritePidl<P0>(pstm: P0, pidlwrite: *const Common::ITEMIDLIST) -> windows_core::Result<()>
where
    P0: windows_core::Param<super::super::System::Com::IStream>,
{
    windows_core::link!("shlwapi.dll" "system" fn IStream_WritePidl(pstm : * mut core::ffi::c_void, pidlwrite : *const Common:: ITEMIDLIST) -> windows_core::HRESULT);
    unsafe { IStream_WritePidl(pstm.param().abi(), pidlwrite).ok() }
}
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn IStream_WriteStr<P0, P1>(pstm: P0, psz: P1) -> windows_core::Result<()>
where
    P0: windows_core::Param<super::super::System::Com::IStream>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn IStream_WriteStr(pstm : * mut core::ffi::c_void, psz : windows_core::PCWSTR) -> windows_core::HRESULT);
    unsafe { IStream_WriteStr(pstm.param().abi(), psz.param().abi()).ok() }
}
#[inline]
pub unsafe fn IUnknown_AtomicRelease(ppunk: Option<*mut *mut core::ffi::c_void>) {
    windows_core::link!("shlwapi.dll" "system" fn IUnknown_AtomicRelease(ppunk : *mut *mut core::ffi::c_void));
    unsafe { IUnknown_AtomicRelease(ppunk.unwrap_or(core::mem::zeroed()) as _) }
}
#[inline]
pub unsafe fn IUnknown_GetSite<P0, T>(punk: P0) -> windows_core::Result<T>
where
    P0: windows_core::Param<windows_core::IUnknown>,
    T: windows_core::Interface,
{
    windows_core::link!("shlwapi.dll" "system" fn IUnknown_GetSite(punk : * mut core::ffi::c_void, riid : *const windows_core::GUID, ppv : *mut *mut core::ffi::c_void) -> windows_core::HRESULT);
    let mut result__ = core::ptr::null_mut();
    unsafe { IUnknown_GetSite(punk.param().abi(), &T::IID, &mut result__).and_then(|| windows_core::Type::from_abi(result__)) }
}
#[inline]
pub unsafe fn IUnknown_GetWindow<P0>(punk: P0) -> windows_core::Result<super::super::Foundation::HWND>
where
    P0: windows_core::Param<windows_core::IUnknown>,
{
    windows_core::link!("shlwapi.dll" "system" fn IUnknown_GetWindow(punk : * mut core::ffi::c_void, phwnd : *mut super::super::Foundation:: HWND) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        IUnknown_GetWindow(punk.param().abi(), &mut result__).map(|| result__)
    }
}
#[inline]
pub unsafe fn IUnknown_QueryService<P0, T>(punk: P0, guidservice: *const windows_core::GUID) -> windows_core::Result<T>
where
    P0: windows_core::Param<windows_core::IUnknown>,
    T: windows_core::Interface,
{
    windows_core::link!("shlwapi.dll" "system" fn IUnknown_QueryService(punk : * mut core::ffi::c_void, guidservice : *const windows_core::GUID, riid : *const windows_core::GUID, ppvout : *mut *mut core::ffi::c_void) -> windows_core::HRESULT);
    let mut result__ = core::ptr::null_mut();
    unsafe { IUnknown_QueryService(punk.param().abi(), guidservice, &T::IID, &mut result__).and_then(|| windows_core::Type::from_abi(result__)) }
}
#[inline]
pub unsafe fn IUnknown_Set<P1>(ppunk: *mut Option<windows_core::IUnknown>, punk: P1)
where
    P1: windows_core::Param<windows_core::IUnknown>,
{
    windows_core::link!("shlwapi.dll" "system" fn IUnknown_Set(ppunk : *mut * mut core::ffi::c_void, punk : * mut core::ffi::c_void));
    unsafe { IUnknown_Set(core::mem::transmute(ppunk), punk.param().abi()) }
}
#[inline]
pub unsafe fn IUnknown_SetSite<P0, P1>(punk: P0, punksite: P1) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::IUnknown>,
    P1: windows_core::Param<windows_core::IUnknown>,
{
    windows_core::link!("shlwapi.dll" "system" fn IUnknown_SetSite(punk : * mut core::ffi::c_void, punksite : * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe { IUnknown_SetSite(punk.param().abi(), punksite.param().abi()).ok() }
}
#[inline]
pub unsafe fn ImportPrivacySettings<P0>(pszfilename: P0, pfparseprivacypreferences: *mut windows_core::BOOL, pfparsepersiterules: *mut windows_core::BOOL) -> windows_core::BOOL
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shdocvw.dll" "system" fn ImportPrivacySettings(pszfilename : windows_core::PCWSTR, pfparseprivacypreferences : *mut windows_core::BOOL, pfparsepersiterules : *mut windows_core::BOOL) -> windows_core::BOOL);
    unsafe { ImportPrivacySettings(pszfilename.param().abi(), pfparseprivacypreferences as _, pfparsepersiterules as _) }
}
#[inline]
pub unsafe fn InitNetworkAddressControl() -> windows_core::BOOL {
    windows_core::link!("shell32.dll" "system" fn InitNetworkAddressControl() -> windows_core::BOOL);
    unsafe { InitNetworkAddressControl() }
}
#[cfg(all(feature = "Win32_System_Com_StructuredStorage", feature = "Win32_System_Variant", feature = "Win32_UI_Shell_Common"))]
#[inline]
pub unsafe fn InitPropVariantFromStrRet(pstrret: *mut Common::STRRET, pidl: Option<*const Common::ITEMIDLIST>, ppropvar: *mut super::super::System::Com::StructuredStorage::PROPVARIANT) -> windows_core::Result<()> {
    windows_core::link!("propsys.dll" "system" fn InitPropVariantFromStrRet(pstrret : *mut Common:: STRRET, pidl : *const Common:: ITEMIDLIST, ppropvar : *mut super::super::System::Com::StructuredStorage:: PROPVARIANT) -> windows_core::HRESULT);
    unsafe { InitPropVariantFromStrRet(pstrret as _, pidl.unwrap_or(core::mem::zeroed()) as _, core::mem::transmute(ppropvar)).ok() }
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant", feature = "Win32_UI_Shell_Common"))]
#[inline]
pub unsafe fn InitVariantFromStrRet(pstrret: *const Common::STRRET, pidl: *const Common::ITEMIDLIST) -> windows_core::Result<super::super::System::Variant::VARIANT> {
    windows_core::link!("propsys.dll" "system" fn InitVariantFromStrRet(pstrret : *const Common:: STRRET, pidl : *const Common:: ITEMIDLIST, pvar : *mut super::super::System::Variant:: VARIANT) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        InitVariantFromStrRet(pstrret, pidl, &mut result__).map(|| core::mem::transmute(result__))
    }
}
#[inline]
pub unsafe fn IntlStrEqWorkerA<P1, P2>(fcasesens: bool, lpstring1: P1, lpstring2: P2, nchar: i32) -> windows_core::BOOL
where
    P1: windows_core::Param<windows_core::PCSTR>,
    P2: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn IntlStrEqWorkerA(fcasesens : windows_core::BOOL, lpstring1 : windows_core::PCSTR, lpstring2 : windows_core::PCSTR, nchar : i32) -> windows_core::BOOL);
    unsafe { IntlStrEqWorkerA(fcasesens.into(), lpstring1.param().abi(), lpstring2.param().abi(), nchar) }
}
#[inline]
pub unsafe fn IntlStrEqWorkerW<P1, P2>(fcasesens: bool, lpstring1: P1, lpstring2: P2, nchar: i32) -> windows_core::BOOL
where
    P1: windows_core::Param<windows_core::PCWSTR>,
    P2: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn IntlStrEqWorkerW(fcasesens : windows_core::BOOL, lpstring1 : windows_core::PCWSTR, lpstring2 : windows_core::PCWSTR, nchar : i32) -> windows_core::BOOL);
    unsafe { IntlStrEqWorkerW(fcasesens.into(), lpstring1.param().abi(), lpstring2.param().abi(), nchar) }
}
#[inline]
pub unsafe fn IsCharSpaceA(wch: i8) -> windows_core::BOOL {
    windows_core::link!("shlwapi.dll" "system" fn IsCharSpaceA(wch : i8) -> windows_core::BOOL);
    unsafe { IsCharSpaceA(wch) }
}
#[inline]
pub unsafe fn IsCharSpaceW(wch: u16) -> windows_core::BOOL {
    windows_core::link!("shlwapi.dll" "system" fn IsCharSpaceW(wch : u16) -> windows_core::BOOL);
    unsafe { IsCharSpaceW(wch) }
}
#[inline]
pub unsafe fn IsInternetESCEnabled() -> windows_core::BOOL {
    windows_core::link!("shlwapi.dll" "system" fn IsInternetESCEnabled() -> windows_core::BOOL);
    unsafe { IsInternetESCEnabled() }
}
#[inline]
pub unsafe fn IsLFNDriveA<P0>(pszpath: P0) -> windows_core::BOOL
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shell32.dll" "system" fn IsLFNDriveA(pszpath : windows_core::PCSTR) -> windows_core::BOOL);
    unsafe { IsLFNDriveA(pszpath.param().abi()) }
}
#[inline]
pub unsafe fn IsLFNDriveW<P0>(pszpath: P0) -> windows_core::BOOL
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shell32.dll" "system" fn IsLFNDriveW(pszpath : windows_core::PCWSTR) -> windows_core::BOOL);
    unsafe { IsLFNDriveW(pszpath.param().abi()) }
}
#[inline]
pub unsafe fn IsNetDrive(idrive: i32) -> i32 {
    windows_core::link!("shell32.dll" "system" fn IsNetDrive(idrive : i32) -> i32);
    unsafe { IsNetDrive(idrive) }
}
#[inline]
pub unsafe fn IsOS(dwos: OS) -> windows_core::BOOL {
    windows_core::link!("shlwapi.dll" "system" fn IsOS(dwos : OS) -> windows_core::BOOL);
    unsafe { IsOS(dwos) }
}
#[inline]
pub unsafe fn IsUserAnAdmin() -> windows_core::BOOL {
    windows_core::link!("shell32.dll" "system" fn IsUserAnAdmin() -> windows_core::BOOL);
    unsafe { IsUserAnAdmin() }
}
#[inline]
pub unsafe fn LoadUserProfileA(htoken: super::super::Foundation::HANDLE, lpprofileinfo: *mut PROFILEINFOA) -> windows_core::Result<()> {
    windows_core::link!("userenv.dll" "system" fn LoadUserProfileA(htoken : super::super::Foundation:: HANDLE, lpprofileinfo : *mut PROFILEINFOA) -> windows_core::BOOL);
    unsafe { LoadUserProfileA(htoken, lpprofileinfo as _).ok() }
}
#[inline]
pub unsafe fn LoadUserProfileW(htoken: super::super::Foundation::HANDLE, lpprofileinfo: *mut PROFILEINFOW) -> windows_core::Result<()> {
    windows_core::link!("userenv.dll" "system" fn LoadUserProfileW(htoken : super::super::Foundation:: HANDLE, lpprofileinfo : *mut PROFILEINFOW) -> windows_core::BOOL);
    unsafe { LoadUserProfileW(htoken, lpprofileinfo as _).ok() }
}
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn OleSaveToStreamEx<P0, P1>(piunk: P0, pistm: P1, fcleardirty: bool) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::IUnknown>,
    P1: windows_core::Param<super::super::System::Com::IStream>,
{
    windows_core::link!("hlink.dll" "system" fn OleSaveToStreamEx(piunk : * mut core::ffi::c_void, pistm : * mut core::ffi::c_void, fcleardirty : windows_core::BOOL) -> windows_core::HRESULT);
    unsafe { OleSaveToStreamEx(piunk.param().abi(), pistm.param().abi(), fcleardirty.into()).ok() }
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Registry"))]
#[inline]
pub unsafe fn OpenRegStream<P1, P2>(hkey: super::super::System::Registry::HKEY, pszsubkey: P1, pszvalue: P2, grfmode: u32) -> Option<super::super::System::Com::IStream>
where
    P1: windows_core::Param<windows_core::PCWSTR>,
    P2: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shell32.dll" "system" fn OpenRegStream(hkey : super::super::System::Registry:: HKEY, pszsubkey : windows_core::PCWSTR, pszvalue : windows_core::PCWSTR, grfmode : u32) -> Option < super::super::System::Com:: IStream >);
    unsafe { OpenRegStream(hkey, pszsubkey.param().abi(), pszvalue.param().abi(), grfmode) }
}
#[inline]
pub unsafe fn ParseURLA<P0>(pcszurl: P0, ppu: *mut PARSEDURLA) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn ParseURLA(pcszurl : windows_core::PCSTR, ppu : *mut PARSEDURLA) -> windows_core::HRESULT);
    unsafe { ParseURLA(pcszurl.param().abi(), ppu as _).ok() }
}
#[inline]
pub unsafe fn ParseURLW<P0>(pcszurl: P0, ppu: *mut PARSEDURLW) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn ParseURLW(pcszurl : windows_core::PCWSTR, ppu : *mut PARSEDURLW) -> windows_core::HRESULT);
    unsafe { ParseURLW(pcszurl.param().abi(), ppu as _).ok() }
}
#[inline]
pub unsafe fn PathAddBackslashA(pszpath: &mut [u8; 260]) -> windows_core::PSTR {
    windows_core::link!("shlwapi.dll" "system" fn PathAddBackslashA(pszpath : windows_core::PSTR) -> windows_core::PSTR);
    unsafe { PathAddBackslashA(core::mem::transmute(pszpath.as_ptr())) }
}
#[inline]
pub unsafe fn PathAddBackslashW(pszpath: &mut [u16; 260]) -> windows_core::PWSTR {
    windows_core::link!("shlwapi.dll" "system" fn PathAddBackslashW(pszpath : windows_core::PWSTR) -> windows_core::PWSTR);
    unsafe { PathAddBackslashW(core::mem::transmute(pszpath.as_ptr())) }
}
#[inline]
pub unsafe fn PathAddExtensionA<P1>(pszpath: &mut [u8; 260], pszext: P1) -> windows_core::BOOL
where
    P1: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn PathAddExtensionA(pszpath : windows_core::PSTR, pszext : windows_core::PCSTR) -> windows_core::BOOL);
    unsafe { PathAddExtensionA(core::mem::transmute(pszpath.as_ptr()), pszext.param().abi()) }
}
#[inline]
pub unsafe fn PathAddExtensionW<P1>(pszpath: &mut [u16; 260], pszext: P1) -> windows_core::BOOL
where
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn PathAddExtensionW(pszpath : windows_core::PWSTR, pszext : windows_core::PCWSTR) -> windows_core::BOOL);
    unsafe { PathAddExtensionW(core::mem::transmute(pszpath.as_ptr()), pszext.param().abi()) }
}
#[inline]
pub unsafe fn PathAllocCanonicalize<P0>(pszpathin: P0, dwflags: PATHCCH_OPTIONS) -> windows_core::Result<windows_core::PWSTR>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("api-ms-win-core-path-l1-1-0.dll" "system" fn PathAllocCanonicalize(pszpathin : windows_core::PCWSTR, dwflags : PATHCCH_OPTIONS, ppszpathout : *mut windows_core::PWSTR) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        PathAllocCanonicalize(pszpathin.param().abi(), dwflags, &mut result__).map(|| result__)
    }
}
#[inline]
pub unsafe fn PathAllocCombine<P0, P1>(pszpathin: P0, pszmore: P1, dwflags: PATHCCH_OPTIONS) -> windows_core::Result<windows_core::PWSTR>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("api-ms-win-core-path-l1-1-0.dll" "system" fn PathAllocCombine(pszpathin : windows_core::PCWSTR, pszmore : windows_core::PCWSTR, dwflags : PATHCCH_OPTIONS, ppszpathout : *mut windows_core::PWSTR) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        PathAllocCombine(pszpathin.param().abi(), pszmore.param().abi(), dwflags, &mut result__).map(|| result__)
    }
}
#[inline]
pub unsafe fn PathAppendA<P1>(pszpath: &mut [u8; 260], pszmore: P1) -> windows_core::BOOL
where
    P1: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn PathAppendA(pszpath : windows_core::PSTR, pszmore : windows_core::PCSTR) -> windows_core::BOOL);
    unsafe { PathAppendA(core::mem::transmute(pszpath.as_ptr()), pszmore.param().abi()) }
}
#[inline]
pub unsafe fn PathAppendW<P1>(pszpath: &mut [u16; 260], pszmore: P1) -> windows_core::BOOL
where
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn PathAppendW(pszpath : windows_core::PWSTR, pszmore : windows_core::PCWSTR) -> windows_core::BOOL);
    unsafe { PathAppendW(core::mem::transmute(pszpath.as_ptr()), pszmore.param().abi()) }
}
#[inline]
pub unsafe fn PathBuildRootA(pszroot: &mut [u8; 4], idrive: i32) -> windows_core::PSTR {
    windows_core::link!("shlwapi.dll" "system" fn PathBuildRootA(pszroot : windows_core::PSTR, idrive : i32) -> windows_core::PSTR);
    unsafe { PathBuildRootA(core::mem::transmute(pszroot.as_ptr()), idrive) }
}
#[inline]
pub unsafe fn PathBuildRootW(pszroot: &mut [u16; 4], idrive: i32) -> windows_core::PWSTR {
    windows_core::link!("shlwapi.dll" "system" fn PathBuildRootW(pszroot : windows_core::PWSTR, idrive : i32) -> windows_core::PWSTR);
    unsafe { PathBuildRootW(core::mem::transmute(pszroot.as_ptr()), idrive) }
}
#[inline]
pub unsafe fn PathCanonicalizeA<P1>(pszbuf: &mut [u8; 260], pszpath: P1) -> windows_core::Result<()>
where
    P1: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn PathCanonicalizeA(pszbuf : windows_core::PSTR, pszpath : windows_core::PCSTR) -> windows_core::BOOL);
    unsafe { PathCanonicalizeA(core::mem::transmute(pszbuf.as_ptr()), pszpath.param().abi()).ok() }
}
#[inline]
pub unsafe fn PathCanonicalizeW<P1>(pszbuf: &mut [u16; 260], pszpath: P1) -> windows_core::Result<()>
where
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn PathCanonicalizeW(pszbuf : windows_core::PWSTR, pszpath : windows_core::PCWSTR) -> windows_core::BOOL);
    unsafe { PathCanonicalizeW(core::mem::transmute(pszbuf.as_ptr()), pszpath.param().abi()).ok() }
}
#[inline]
pub unsafe fn PathCchAddBackslash(pszpath: &mut [u16]) -> windows_core::HRESULT {
    windows_core::link!("api-ms-win-core-path-l1-1-0.dll" "system" fn PathCchAddBackslash(pszpath : windows_core::PWSTR, cchpath : usize) -> windows_core::HRESULT);
    unsafe { PathCchAddBackslash(core::mem::transmute(pszpath.as_ptr()), pszpath.len().try_into().unwrap()) }
}
#[inline]
pub unsafe fn PathCchAddBackslashEx(pszpath: &mut [u16], ppszend: Option<*mut windows_core::PWSTR>, pcchremaining: Option<*mut usize>) -> windows_core::HRESULT {
    windows_core::link!("api-ms-win-core-path-l1-1-0.dll" "system" fn PathCchAddBackslashEx(pszpath : windows_core::PWSTR, cchpath : usize, ppszend : *mut windows_core::PWSTR, pcchremaining : *mut usize) -> windows_core::HRESULT);
    unsafe { PathCchAddBackslashEx(core::mem::transmute(pszpath.as_ptr()), pszpath.len().try_into().unwrap(), ppszend.unwrap_or(core::mem::zeroed()) as _, pcchremaining.unwrap_or(core::mem::zeroed()) as _) }
}
#[inline]
pub unsafe fn PathCchAddExtension<P2>(pszpath: &mut [u16], pszext: P2) -> windows_core::Result<()>
where
    P2: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("api-ms-win-core-path-l1-1-0.dll" "system" fn PathCchAddExtension(pszpath : windows_core::PWSTR, cchpath : usize, pszext : windows_core::PCWSTR) -> windows_core::HRESULT);
    unsafe { PathCchAddExtension(core::mem::transmute(pszpath.as_ptr()), pszpath.len().try_into().unwrap(), pszext.param().abi()).ok() }
}
#[inline]
pub unsafe fn PathCchAppend<P2>(pszpath: &mut [u16], pszmore: P2) -> windows_core::Result<()>
where
    P2: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("api-ms-win-core-path-l1-1-0.dll" "system" fn PathCchAppend(pszpath : windows_core::PWSTR, cchpath : usize, pszmore : windows_core::PCWSTR) -> windows_core::HRESULT);
    unsafe { PathCchAppend(core::mem::transmute(pszpath.as_ptr()), pszpath.len().try_into().unwrap(), pszmore.param().abi()).ok() }
}
#[inline]
pub unsafe fn PathCchAppendEx<P2>(pszpath: &mut [u16], pszmore: P2, dwflags: PATHCCH_OPTIONS) -> windows_core::Result<()>
where
    P2: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("api-ms-win-core-path-l1-1-0.dll" "system" fn PathCchAppendEx(pszpath : windows_core::PWSTR, cchpath : usize, pszmore : windows_core::PCWSTR, dwflags : PATHCCH_OPTIONS) -> windows_core::HRESULT);
    unsafe { PathCchAppendEx(core::mem::transmute(pszpath.as_ptr()), pszpath.len().try_into().unwrap(), pszmore.param().abi(), dwflags).ok() }
}
#[inline]
pub unsafe fn PathCchCanonicalize<P2>(pszpathout: &mut [u16], pszpathin: P2) -> windows_core::Result<()>
where
    P2: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("api-ms-win-core-path-l1-1-0.dll" "system" fn PathCchCanonicalize(pszpathout : windows_core::PWSTR, cchpathout : usize, pszpathin : windows_core::PCWSTR) -> windows_core::HRESULT);
    unsafe { PathCchCanonicalize(core::mem::transmute(pszpathout.as_ptr()), pszpathout.len().try_into().unwrap(), pszpathin.param().abi()).ok() }
}
#[inline]
pub unsafe fn PathCchCanonicalizeEx<P2>(pszpathout: &mut [u16], pszpathin: P2, dwflags: PATHCCH_OPTIONS) -> windows_core::Result<()>
where
    P2: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("api-ms-win-core-path-l1-1-0.dll" "system" fn PathCchCanonicalizeEx(pszpathout : windows_core::PWSTR, cchpathout : usize, pszpathin : windows_core::PCWSTR, dwflags : PATHCCH_OPTIONS) -> windows_core::HRESULT);
    unsafe { PathCchCanonicalizeEx(core::mem::transmute(pszpathout.as_ptr()), pszpathout.len().try_into().unwrap(), pszpathin.param().abi(), dwflags).ok() }
}
#[inline]
pub unsafe fn PathCchCombine<P2, P3>(pszpathout: &mut [u16], pszpathin: P2, pszmore: P3) -> windows_core::Result<()>
where
    P2: windows_core::Param<windows_core::PCWSTR>,
    P3: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("api-ms-win-core-path-l1-1-0.dll" "system" fn PathCchCombine(pszpathout : windows_core::PWSTR, cchpathout : usize, pszpathin : windows_core::PCWSTR, pszmore : windows_core::PCWSTR) -> windows_core::HRESULT);
    unsafe { PathCchCombine(core::mem::transmute(pszpathout.as_ptr()), pszpathout.len().try_into().unwrap(), pszpathin.param().abi(), pszmore.param().abi()).ok() }
}
#[inline]
pub unsafe fn PathCchCombineEx<P2, P3>(pszpathout: &mut [u16], pszpathin: P2, pszmore: P3, dwflags: PATHCCH_OPTIONS) -> windows_core::Result<()>
where
    P2: windows_core::Param<windows_core::PCWSTR>,
    P3: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("api-ms-win-core-path-l1-1-0.dll" "system" fn PathCchCombineEx(pszpathout : windows_core::PWSTR, cchpathout : usize, pszpathin : windows_core::PCWSTR, pszmore : windows_core::PCWSTR, dwflags : PATHCCH_OPTIONS) -> windows_core::HRESULT);
    unsafe { PathCchCombineEx(core::mem::transmute(pszpathout.as_ptr()), pszpathout.len().try_into().unwrap(), pszpathin.param().abi(), pszmore.param().abi(), dwflags).ok() }
}
#[inline]
pub unsafe fn PathCchFindExtension<P0>(pszpath: P0, cchpath: usize) -> windows_core::Result<windows_core::PCWSTR>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("api-ms-win-core-path-l1-1-0.dll" "system" fn PathCchFindExtension(pszpath : windows_core::PCWSTR, cchpath : usize, ppszext : *mut windows_core::PCWSTR) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        PathCchFindExtension(pszpath.param().abi(), cchpath, &mut result__).map(|| result__)
    }
}
#[inline]
pub unsafe fn PathCchIsRoot<P0>(pszpath: P0) -> windows_core::BOOL
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("api-ms-win-core-path-l1-1-0.dll" "system" fn PathCchIsRoot(pszpath : windows_core::PCWSTR) -> windows_core::BOOL);
    unsafe { PathCchIsRoot(pszpath.param().abi()) }
}
#[inline]
pub unsafe fn PathCchRemoveBackslash(pszpath: &mut [u16]) -> windows_core::HRESULT {
    windows_core::link!("api-ms-win-core-path-l1-1-0.dll" "system" fn PathCchRemoveBackslash(pszpath : windows_core::PWSTR, cchpath : usize) -> windows_core::HRESULT);
    unsafe { PathCchRemoveBackslash(core::mem::transmute(pszpath.as_ptr()), pszpath.len().try_into().unwrap()) }
}
#[inline]
pub unsafe fn PathCchRemoveBackslashEx(pszpath: windows_core::PWSTR, cchpath: usize, ppszend: Option<*mut windows_core::PWSTR>, pcchremaining: Option<*mut usize>) -> windows_core::Result<()> {
    windows_core::link!("api-ms-win-core-path-l1-1-0.dll" "system" fn PathCchRemoveBackslashEx(pszpath : windows_core::PWSTR, cchpath : usize, ppszend : *mut windows_core::PWSTR, pcchremaining : *mut usize) -> windows_core::HRESULT);
    unsafe { PathCchRemoveBackslashEx(core::mem::transmute(pszpath), cchpath, ppszend.unwrap_or(core::mem::zeroed()) as _, pcchremaining.unwrap_or(core::mem::zeroed()) as _).ok() }
}
#[inline]
pub unsafe fn PathCchRemoveExtension(pszpath: windows_core::PWSTR, cchpath: usize) -> windows_core::Result<()> {
    windows_core::link!("api-ms-win-core-path-l1-1-0.dll" "system" fn PathCchRemoveExtension(pszpath : windows_core::PWSTR, cchpath : usize) -> windows_core::HRESULT);
    unsafe { PathCchRemoveExtension(core::mem::transmute(pszpath), cchpath).ok() }
}
#[inline]
pub unsafe fn PathCchRemoveFileSpec(pszpath: windows_core::PWSTR, cchpath: usize) -> windows_core::Result<()> {
    windows_core::link!("api-ms-win-core-path-l1-1-0.dll" "system" fn PathCchRemoveFileSpec(pszpath : windows_core::PWSTR, cchpath : usize) -> windows_core::HRESULT);
    unsafe { PathCchRemoveFileSpec(core::mem::transmute(pszpath), cchpath).ok() }
}
#[inline]
pub unsafe fn PathCchRenameExtension<P2>(pszpath: &mut [u16], pszext: P2) -> windows_core::Result<()>
where
    P2: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("api-ms-win-core-path-l1-1-0.dll" "system" fn PathCchRenameExtension(pszpath : windows_core::PWSTR, cchpath : usize, pszext : windows_core::PCWSTR) -> windows_core::HRESULT);
    unsafe { PathCchRenameExtension(core::mem::transmute(pszpath.as_ptr()), pszpath.len().try_into().unwrap(), pszext.param().abi()).ok() }
}
#[inline]
pub unsafe fn PathCchSkipRoot<P0>(pszpath: P0) -> windows_core::Result<windows_core::PCWSTR>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("api-ms-win-core-path-l1-1-0.dll" "system" fn PathCchSkipRoot(pszpath : windows_core::PCWSTR, ppszrootend : *mut windows_core::PCWSTR) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        PathCchSkipRoot(pszpath.param().abi(), &mut result__).map(|| result__)
    }
}
#[inline]
pub unsafe fn PathCchStripPrefix(pszpath: &mut [u16]) -> windows_core::HRESULT {
    windows_core::link!("api-ms-win-core-path-l1-1-0.dll" "system" fn PathCchStripPrefix(pszpath : windows_core::PWSTR, cchpath : usize) -> windows_core::HRESULT);
    unsafe { PathCchStripPrefix(core::mem::transmute(pszpath.as_ptr()), pszpath.len().try_into().unwrap()) }
}
#[inline]
pub unsafe fn PathCchStripToRoot(pszpath: windows_core::PWSTR, cchpath: usize) -> windows_core::HRESULT {
    windows_core::link!("api-ms-win-core-path-l1-1-0.dll" "system" fn PathCchStripToRoot(pszpath : windows_core::PWSTR, cchpath : usize) -> windows_core::HRESULT);
    unsafe { PathCchStripToRoot(core::mem::transmute(pszpath), cchpath) }
}
#[inline]
pub unsafe fn PathCleanupSpec<P0>(pszdir: P0, pszspec: windows_core::PWSTR) -> i32
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shell32.dll" "system" fn PathCleanupSpec(pszdir : windows_core::PCWSTR, pszspec : windows_core::PWSTR) -> i32);
    unsafe { PathCleanupSpec(pszdir.param().abi(), core::mem::transmute(pszspec)) }
}
#[inline]
pub unsafe fn PathCombineA<P1, P2>(pszdest: &mut [u8; 260], pszdir: P1, pszfile: P2) -> windows_core::PSTR
where
    P1: windows_core::Param<windows_core::PCSTR>,
    P2: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn PathCombineA(pszdest : windows_core::PSTR, pszdir : windows_core::PCSTR, pszfile : windows_core::PCSTR) -> windows_core::PSTR);
    unsafe { PathCombineA(core::mem::transmute(pszdest.as_ptr()), pszdir.param().abi(), pszfile.param().abi()) }
}
#[inline]
pub unsafe fn PathCombineW<P1, P2>(pszdest: &mut [u16; 260], pszdir: P1, pszfile: P2) -> windows_core::PWSTR
where
    P1: windows_core::Param<windows_core::PCWSTR>,
    P2: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn PathCombineW(pszdest : windows_core::PWSTR, pszdir : windows_core::PCWSTR, pszfile : windows_core::PCWSTR) -> windows_core::PWSTR);
    unsafe { PathCombineW(core::mem::transmute(pszdest.as_ptr()), pszdir.param().abi(), pszfile.param().abi()) }
}
#[inline]
pub unsafe fn PathCommonPrefixA<P0, P1>(pszfile1: P0, pszfile2: P1, achpath: Option<&mut [u8; 260]>) -> i32
where
    P0: windows_core::Param<windows_core::PCSTR>,
    P1: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn PathCommonPrefixA(pszfile1 : windows_core::PCSTR, pszfile2 : windows_core::PCSTR, achpath : windows_core::PSTR) -> i32);
    unsafe { PathCommonPrefixA(pszfile1.param().abi(), pszfile2.param().abi(), core::mem::transmute(achpath.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr()))) }
}
#[inline]
pub unsafe fn PathCommonPrefixW<P0, P1>(pszfile1: P0, pszfile2: P1, achpath: Option<&mut [u16; 260]>) -> i32
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn PathCommonPrefixW(pszfile1 : windows_core::PCWSTR, pszfile2 : windows_core::PCWSTR, achpath : windows_core::PWSTR) -> i32);
    unsafe { PathCommonPrefixW(pszfile1.param().abi(), pszfile2.param().abi(), core::mem::transmute(achpath.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr()))) }
}
#[cfg(feature = "Win32_Graphics_Gdi")]
#[inline]
pub unsafe fn PathCompactPathA(hdc: Option<super::super::Graphics::Gdi::HDC>, pszpath: &mut [u8; 260], dx: u32) -> windows_core::BOOL {
    windows_core::link!("shlwapi.dll" "system" fn PathCompactPathA(hdc : super::super::Graphics::Gdi:: HDC, pszpath : windows_core::PSTR, dx : u32) -> windows_core::BOOL);
    unsafe { PathCompactPathA(hdc.unwrap_or(core::mem::zeroed()) as _, core::mem::transmute(pszpath.as_ptr()), dx) }
}
#[inline]
pub unsafe fn PathCompactPathExA<P1>(pszout: &mut [u8], pszsrc: P1, dwflags: u32) -> windows_core::BOOL
where
    P1: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn PathCompactPathExA(pszout : windows_core::PSTR, pszsrc : windows_core::PCSTR, cchmax : u32, dwflags : u32) -> windows_core::BOOL);
    unsafe { PathCompactPathExA(core::mem::transmute(pszout.as_ptr()), pszsrc.param().abi(), pszout.len().try_into().unwrap(), dwflags) }
}
#[inline]
pub unsafe fn PathCompactPathExW<P1>(pszout: &mut [u16], pszsrc: P1, dwflags: u32) -> windows_core::BOOL
where
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn PathCompactPathExW(pszout : windows_core::PWSTR, pszsrc : windows_core::PCWSTR, cchmax : u32, dwflags : u32) -> windows_core::BOOL);
    unsafe { PathCompactPathExW(core::mem::transmute(pszout.as_ptr()), pszsrc.param().abi(), pszout.len().try_into().unwrap(), dwflags) }
}
#[cfg(feature = "Win32_Graphics_Gdi")]
#[inline]
pub unsafe fn PathCompactPathW(hdc: Option<super::super::Graphics::Gdi::HDC>, pszpath: &mut [u16; 260], dx: u32) -> windows_core::BOOL {
    windows_core::link!("shlwapi.dll" "system" fn PathCompactPathW(hdc : super::super::Graphics::Gdi:: HDC, pszpath : windows_core::PWSTR, dx : u32) -> windows_core::BOOL);
    unsafe { PathCompactPathW(hdc.unwrap_or(core::mem::zeroed()) as _, core::mem::transmute(pszpath.as_ptr()), dx) }
}
#[inline]
pub unsafe fn PathCreateFromUrlA<P0>(pszurl: P0, pszpath: windows_core::PSTR, pcchpath: *mut u32, dwflags: u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn PathCreateFromUrlA(pszurl : windows_core::PCSTR, pszpath : windows_core::PSTR, pcchpath : *mut u32, dwflags : u32) -> windows_core::HRESULT);
    unsafe { PathCreateFromUrlA(pszurl.param().abi(), core::mem::transmute(pszpath), pcchpath as _, dwflags).ok() }
}
#[inline]
pub unsafe fn PathCreateFromUrlAlloc<P0>(pszin: P0, ppszout: *mut windows_core::PWSTR, dwflags: u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn PathCreateFromUrlAlloc(pszin : windows_core::PCWSTR, ppszout : *mut windows_core::PWSTR, dwflags : u32) -> windows_core::HRESULT);
    unsafe { PathCreateFromUrlAlloc(pszin.param().abi(), ppszout as _, dwflags).ok() }
}
#[inline]
pub unsafe fn PathCreateFromUrlW<P0>(pszurl: P0, pszpath: windows_core::PWSTR, pcchpath: *mut u32, dwflags: u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn PathCreateFromUrlW(pszurl : windows_core::PCWSTR, pszpath : windows_core::PWSTR, pcchpath : *mut u32, dwflags : u32) -> windows_core::HRESULT);
    unsafe { PathCreateFromUrlW(pszurl.param().abi(), core::mem::transmute(pszpath), pcchpath as _, dwflags).ok() }
}
#[inline]
pub unsafe fn PathFileExistsA<P0>(pszpath: P0) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn PathFileExistsA(pszpath : windows_core::PCSTR) -> windows_core::BOOL);
    unsafe { PathFileExistsA(pszpath.param().abi()).ok() }
}
#[inline]
pub unsafe fn PathFileExistsW<P0>(pszpath: P0) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn PathFileExistsW(pszpath : windows_core::PCWSTR) -> windows_core::BOOL);
    unsafe { PathFileExistsW(pszpath.param().abi()).ok() }
}
#[inline]
pub unsafe fn PathFindExtensionA<P0>(pszpath: P0) -> windows_core::PSTR
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn PathFindExtensionA(pszpath : windows_core::PCSTR) -> windows_core::PSTR);
    unsafe { PathFindExtensionA(pszpath.param().abi()) }
}
#[inline]
pub unsafe fn PathFindExtensionW<P0>(pszpath: P0) -> windows_core::PWSTR
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn PathFindExtensionW(pszpath : windows_core::PCWSTR) -> windows_core::PWSTR);
    unsafe { PathFindExtensionW(pszpath.param().abi()) }
}
#[inline]
pub unsafe fn PathFindFileNameA<P0>(pszpath: P0) -> windows_core::PSTR
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn PathFindFileNameA(pszpath : windows_core::PCSTR) -> windows_core::PSTR);
    unsafe { PathFindFileNameA(pszpath.param().abi()) }
}
#[inline]
pub unsafe fn PathFindFileNameW<P0>(pszpath: P0) -> windows_core::PWSTR
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn PathFindFileNameW(pszpath : windows_core::PCWSTR) -> windows_core::PWSTR);
    unsafe { PathFindFileNameW(pszpath.param().abi()) }
}
#[inline]
pub unsafe fn PathFindNextComponentA<P0>(pszpath: P0) -> windows_core::PSTR
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn PathFindNextComponentA(pszpath : windows_core::PCSTR) -> windows_core::PSTR);
    unsafe { PathFindNextComponentA(pszpath.param().abi()) }
}
#[inline]
pub unsafe fn PathFindNextComponentW<P0>(pszpath: P0) -> windows_core::PWSTR
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn PathFindNextComponentW(pszpath : windows_core::PCWSTR) -> windows_core::PWSTR);
    unsafe { PathFindNextComponentW(pszpath.param().abi()) }
}
#[inline]
pub unsafe fn PathFindOnPathA(pszpath: &mut [u8; 260], ppszotherdirs: Option<*const *const i8>) -> windows_core::BOOL {
    windows_core::link!("shlwapi.dll" "system" fn PathFindOnPathA(pszpath : windows_core::PSTR, ppszotherdirs : *const *const i8) -> windows_core::BOOL);
    unsafe { PathFindOnPathA(core::mem::transmute(pszpath.as_ptr()), ppszotherdirs.unwrap_or(core::mem::zeroed()) as _) }
}
#[inline]
pub unsafe fn PathFindOnPathW(pszpath: &mut [u16; 260], ppszotherdirs: Option<*const *const u16>) -> windows_core::BOOL {
    windows_core::link!("shlwapi.dll" "system" fn PathFindOnPathW(pszpath : windows_core::PWSTR, ppszotherdirs : *const *const u16) -> windows_core::BOOL);
    unsafe { PathFindOnPathW(core::mem::transmute(pszpath.as_ptr()), ppszotherdirs.unwrap_or(core::mem::zeroed()) as _) }
}
#[inline]
pub unsafe fn PathFindSuffixArrayA<P0>(pszpath: P0, apszsuffix: &[windows_core::PCSTR]) -> windows_core::PCSTR
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn PathFindSuffixArrayA(pszpath : windows_core::PCSTR, apszsuffix : *const windows_core::PCSTR, iarraysize : i32) -> windows_core::PCSTR);
    unsafe { PathFindSuffixArrayA(pszpath.param().abi(), core::mem::transmute(apszsuffix.as_ptr()), apszsuffix.len().try_into().unwrap()) }
}
#[inline]
pub unsafe fn PathFindSuffixArrayW<P0>(pszpath: P0, apszsuffix: &[windows_core::PCWSTR]) -> windows_core::PCWSTR
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn PathFindSuffixArrayW(pszpath : windows_core::PCWSTR, apszsuffix : *const windows_core::PCWSTR, iarraysize : i32) -> windows_core::PCWSTR);
    unsafe { PathFindSuffixArrayW(pszpath.param().abi(), core::mem::transmute(apszsuffix.as_ptr()), apszsuffix.len().try_into().unwrap()) }
}
#[inline]
pub unsafe fn PathGetArgsA<P0>(pszpath: P0) -> windows_core::PSTR
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn PathGetArgsA(pszpath : windows_core::PCSTR) -> windows_core::PSTR);
    unsafe { PathGetArgsA(pszpath.param().abi()) }
}
#[inline]
pub unsafe fn PathGetArgsW<P0>(pszpath: P0) -> windows_core::PWSTR
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn PathGetArgsW(pszpath : windows_core::PCWSTR) -> windows_core::PWSTR);
    unsafe { PathGetArgsW(pszpath.param().abi()) }
}
#[inline]
pub unsafe fn PathGetCharTypeA(ch: u8) -> u32 {
    windows_core::link!("shlwapi.dll" "system" fn PathGetCharTypeA(ch : u8) -> u32);
    unsafe { PathGetCharTypeA(ch) }
}
#[inline]
pub unsafe fn PathGetCharTypeW(ch: u16) -> u32 {
    windows_core::link!("shlwapi.dll" "system" fn PathGetCharTypeW(ch : u16) -> u32);
    unsafe { PathGetCharTypeW(ch) }
}
#[inline]
pub unsafe fn PathGetDriveNumberA<P0>(pszpath: P0) -> i32
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn PathGetDriveNumberA(pszpath : windows_core::PCSTR) -> i32);
    unsafe { PathGetDriveNumberA(pszpath.param().abi()) }
}
#[inline]
pub unsafe fn PathGetDriveNumberW<P0>(pszpath: P0) -> i32
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn PathGetDriveNumberW(pszpath : windows_core::PCWSTR) -> i32);
    unsafe { PathGetDriveNumberW(pszpath.param().abi()) }
}
#[inline]
pub unsafe fn PathGetShortPath(pszlongpath: &mut [u16; 260]) {
    windows_core::link!("shell32.dll" "system" fn PathGetShortPath(pszlongpath : windows_core::PWSTR));
    unsafe { PathGetShortPath(core::mem::transmute(pszlongpath.as_ptr())) }
}
#[inline]
pub unsafe fn PathIsContentTypeA<P0, P1>(pszpath: P0, pszcontenttype: P1) -> windows_core::BOOL
where
    P0: windows_core::Param<windows_core::PCSTR>,
    P1: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn PathIsContentTypeA(pszpath : windows_core::PCSTR, pszcontenttype : windows_core::PCSTR) -> windows_core::BOOL);
    unsafe { PathIsContentTypeA(pszpath.param().abi(), pszcontenttype.param().abi()) }
}
#[inline]
pub unsafe fn PathIsContentTypeW<P0, P1>(pszpath: P0, pszcontenttype: P1) -> windows_core::BOOL
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn PathIsContentTypeW(pszpath : windows_core::PCWSTR, pszcontenttype : windows_core::PCWSTR) -> windows_core::BOOL);
    unsafe { PathIsContentTypeW(pszpath.param().abi(), pszcontenttype.param().abi()) }
}
#[inline]
pub unsafe fn PathIsDirectoryA<P0>(pszpath: P0) -> windows_core::BOOL
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn PathIsDirectoryA(pszpath : windows_core::PCSTR) -> windows_core::BOOL);
    unsafe { PathIsDirectoryA(pszpath.param().abi()) }
}
#[inline]
pub unsafe fn PathIsDirectoryEmptyA<P0>(pszpath: P0) -> windows_core::BOOL
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn PathIsDirectoryEmptyA(pszpath : windows_core::PCSTR) -> windows_core::BOOL);
    unsafe { PathIsDirectoryEmptyA(pszpath.param().abi()) }
}
#[inline]
pub unsafe fn PathIsDirectoryEmptyW<P0>(pszpath: P0) -> windows_core::BOOL
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn PathIsDirectoryEmptyW(pszpath : windows_core::PCWSTR) -> windows_core::BOOL);
    unsafe { PathIsDirectoryEmptyW(pszpath.param().abi()) }
}
#[inline]
pub unsafe fn PathIsDirectoryW<P0>(pszpath: P0) -> windows_core::BOOL
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn PathIsDirectoryW(pszpath : windows_core::PCWSTR) -> windows_core::BOOL);
    unsafe { PathIsDirectoryW(pszpath.param().abi()) }
}
#[inline]
pub unsafe fn PathIsExe<P0>(pszpath: P0) -> windows_core::BOOL
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shell32.dll" "system" fn PathIsExe(pszpath : windows_core::PCWSTR) -> windows_core::BOOL);
    unsafe { PathIsExe(pszpath.param().abi()) }
}
#[inline]
pub unsafe fn PathIsFileSpecA<P0>(pszpath: P0) -> windows_core::BOOL
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn PathIsFileSpecA(pszpath : windows_core::PCSTR) -> windows_core::BOOL);
    unsafe { PathIsFileSpecA(pszpath.param().abi()) }
}
#[inline]
pub unsafe fn PathIsFileSpecW<P0>(pszpath: P0) -> windows_core::BOOL
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn PathIsFileSpecW(pszpath : windows_core::PCWSTR) -> windows_core::BOOL);
    unsafe { PathIsFileSpecW(pszpath.param().abi()) }
}
#[inline]
pub unsafe fn PathIsLFNFileSpecA<P0>(pszname: P0) -> windows_core::BOOL
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn PathIsLFNFileSpecA(pszname : windows_core::PCSTR) -> windows_core::BOOL);
    unsafe { PathIsLFNFileSpecA(pszname.param().abi()) }
}
#[inline]
pub unsafe fn PathIsLFNFileSpecW<P0>(pszname: P0) -> windows_core::BOOL
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn PathIsLFNFileSpecW(pszname : windows_core::PCWSTR) -> windows_core::BOOL);
    unsafe { PathIsLFNFileSpecW(pszname.param().abi()) }
}
#[inline]
pub unsafe fn PathIsNetworkPathA<P0>(pszpath: P0) -> windows_core::BOOL
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn PathIsNetworkPathA(pszpath : windows_core::PCSTR) -> windows_core::BOOL);
    unsafe { PathIsNetworkPathA(pszpath.param().abi()) }
}
#[inline]
pub unsafe fn PathIsNetworkPathW<P0>(pszpath: P0) -> windows_core::BOOL
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn PathIsNetworkPathW(pszpath : windows_core::PCWSTR) -> windows_core::BOOL);
    unsafe { PathIsNetworkPathW(pszpath.param().abi()) }
}
#[inline]
pub unsafe fn PathIsPrefixA<P0, P1>(pszprefix: P0, pszpath: P1) -> windows_core::BOOL
where
    P0: windows_core::Param<windows_core::PCSTR>,
    P1: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn PathIsPrefixA(pszprefix : windows_core::PCSTR, pszpath : windows_core::PCSTR) -> windows_core::BOOL);
    unsafe { PathIsPrefixA(pszprefix.param().abi(), pszpath.param().abi()) }
}
#[inline]
pub unsafe fn PathIsPrefixW<P0, P1>(pszprefix: P0, pszpath: P1) -> windows_core::BOOL
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn PathIsPrefixW(pszprefix : windows_core::PCWSTR, pszpath : windows_core::PCWSTR) -> windows_core::BOOL);
    unsafe { PathIsPrefixW(pszprefix.param().abi(), pszpath.param().abi()) }
}
#[inline]
pub unsafe fn PathIsRelativeA<P0>(pszpath: P0) -> windows_core::BOOL
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn PathIsRelativeA(pszpath : windows_core::PCSTR) -> windows_core::BOOL);
    unsafe { PathIsRelativeA(pszpath.param().abi()) }
}
#[inline]
pub unsafe fn PathIsRelativeW<P0>(pszpath: P0) -> windows_core::BOOL
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn PathIsRelativeW(pszpath : windows_core::PCWSTR) -> windows_core::BOOL);
    unsafe { PathIsRelativeW(pszpath.param().abi()) }
}
#[inline]
pub unsafe fn PathIsRootA<P0>(pszpath: P0) -> windows_core::BOOL
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn PathIsRootA(pszpath : windows_core::PCSTR) -> windows_core::BOOL);
    unsafe { PathIsRootA(pszpath.param().abi()) }
}
#[inline]
pub unsafe fn PathIsRootW<P0>(pszpath: P0) -> windows_core::BOOL
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn PathIsRootW(pszpath : windows_core::PCWSTR) -> windows_core::BOOL);
    unsafe { PathIsRootW(pszpath.param().abi()) }
}
#[inline]
pub unsafe fn PathIsSameRootA<P0, P1>(pszpath1: P0, pszpath2: P1) -> windows_core::BOOL
where
    P0: windows_core::Param<windows_core::PCSTR>,
    P1: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn PathIsSameRootA(pszpath1 : windows_core::PCSTR, pszpath2 : windows_core::PCSTR) -> windows_core::BOOL);
    unsafe { PathIsSameRootA(pszpath1.param().abi(), pszpath2.param().abi()) }
}
#[inline]
pub unsafe fn PathIsSameRootW<P0, P1>(pszpath1: P0, pszpath2: P1) -> windows_core::BOOL
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn PathIsSameRootW(pszpath1 : windows_core::PCWSTR, pszpath2 : windows_core::PCWSTR) -> windows_core::BOOL);
    unsafe { PathIsSameRootW(pszpath1.param().abi(), pszpath2.param().abi()) }
}
#[inline]
pub unsafe fn PathIsSlowA<P0>(pszfile: P0, dwattr: u32) -> windows_core::BOOL
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shell32.dll" "system" fn PathIsSlowA(pszfile : windows_core::PCSTR, dwattr : u32) -> windows_core::BOOL);
    unsafe { PathIsSlowA(pszfile.param().abi(), dwattr) }
}
#[inline]
pub unsafe fn PathIsSlowW<P0>(pszfile: P0, dwattr: u32) -> windows_core::BOOL
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shell32.dll" "system" fn PathIsSlowW(pszfile : windows_core::PCWSTR, dwattr : u32) -> windows_core::BOOL);
    unsafe { PathIsSlowW(pszfile.param().abi(), dwattr) }
}
#[inline]
pub unsafe fn PathIsSystemFolderA<P0>(pszpath: P0, dwattrb: u32) -> windows_core::BOOL
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn PathIsSystemFolderA(pszpath : windows_core::PCSTR, dwattrb : u32) -> windows_core::BOOL);
    unsafe { PathIsSystemFolderA(pszpath.param().abi(), dwattrb) }
}
#[inline]
pub unsafe fn PathIsSystemFolderW<P0>(pszpath: P0, dwattrb: u32) -> windows_core::BOOL
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn PathIsSystemFolderW(pszpath : windows_core::PCWSTR, dwattrb : u32) -> windows_core::BOOL);
    unsafe { PathIsSystemFolderW(pszpath.param().abi(), dwattrb) }
}
#[inline]
pub unsafe fn PathIsUNCA<P0>(pszpath: P0) -> windows_core::BOOL
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn PathIsUNCA(pszpath : windows_core::PCSTR) -> windows_core::BOOL);
    unsafe { PathIsUNCA(pszpath.param().abi()) }
}
#[inline]
pub unsafe fn PathIsUNCEx<P0>(pszpath: P0, ppszserver: Option<*mut windows_core::PCWSTR>) -> windows_core::BOOL
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("api-ms-win-core-path-l1-1-0.dll" "system" fn PathIsUNCEx(pszpath : windows_core::PCWSTR, ppszserver : *mut windows_core::PCWSTR) -> windows_core::BOOL);
    unsafe { PathIsUNCEx(pszpath.param().abi(), ppszserver.unwrap_or(core::mem::zeroed()) as _) }
}
#[inline]
pub unsafe fn PathIsUNCServerA<P0>(pszpath: P0) -> windows_core::BOOL
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn PathIsUNCServerA(pszpath : windows_core::PCSTR) -> windows_core::BOOL);
    unsafe { PathIsUNCServerA(pszpath.param().abi()) }
}
#[inline]
pub unsafe fn PathIsUNCServerShareA<P0>(pszpath: P0) -> windows_core::BOOL
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn PathIsUNCServerShareA(pszpath : windows_core::PCSTR) -> windows_core::BOOL);
    unsafe { PathIsUNCServerShareA(pszpath.param().abi()) }
}
#[inline]
pub unsafe fn PathIsUNCServerShareW<P0>(pszpath: P0) -> windows_core::BOOL
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn PathIsUNCServerShareW(pszpath : windows_core::PCWSTR) -> windows_core::BOOL);
    unsafe { PathIsUNCServerShareW(pszpath.param().abi()) }
}
#[inline]
pub unsafe fn PathIsUNCServerW<P0>(pszpath: P0) -> windows_core::BOOL
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn PathIsUNCServerW(pszpath : windows_core::PCWSTR) -> windows_core::BOOL);
    unsafe { PathIsUNCServerW(pszpath.param().abi()) }
}
#[inline]
pub unsafe fn PathIsUNCW<P0>(pszpath: P0) -> windows_core::BOOL
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn PathIsUNCW(pszpath : windows_core::PCWSTR) -> windows_core::BOOL);
    unsafe { PathIsUNCW(pszpath.param().abi()) }
}
#[inline]
pub unsafe fn PathIsURLA<P0>(pszpath: P0) -> windows_core::BOOL
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn PathIsURLA(pszpath : windows_core::PCSTR) -> windows_core::BOOL);
    unsafe { PathIsURLA(pszpath.param().abi()) }
}
#[inline]
pub unsafe fn PathIsURLW<P0>(pszpath: P0) -> windows_core::BOOL
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn PathIsURLW(pszpath : windows_core::PCWSTR) -> windows_core::BOOL);
    unsafe { PathIsURLW(pszpath.param().abi()) }
}
#[inline]
pub unsafe fn PathMakePrettyA(pszpath: windows_core::PSTR) -> windows_core::BOOL {
    windows_core::link!("shlwapi.dll" "system" fn PathMakePrettyA(pszpath : windows_core::PSTR) -> windows_core::BOOL);
    unsafe { PathMakePrettyA(core::mem::transmute(pszpath)) }
}
#[inline]
pub unsafe fn PathMakePrettyW(pszpath: windows_core::PWSTR) -> windows_core::BOOL {
    windows_core::link!("shlwapi.dll" "system" fn PathMakePrettyW(pszpath : windows_core::PWSTR) -> windows_core::BOOL);
    unsafe { PathMakePrettyW(core::mem::transmute(pszpath)) }
}
#[inline]
pub unsafe fn PathMakeSystemFolderA<P0>(pszpath: P0) -> windows_core::BOOL
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn PathMakeSystemFolderA(pszpath : windows_core::PCSTR) -> windows_core::BOOL);
    unsafe { PathMakeSystemFolderA(pszpath.param().abi()) }
}
#[inline]
pub unsafe fn PathMakeSystemFolderW<P0>(pszpath: P0) -> windows_core::BOOL
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn PathMakeSystemFolderW(pszpath : windows_core::PCWSTR) -> windows_core::BOOL);
    unsafe { PathMakeSystemFolderW(pszpath.param().abi()) }
}
#[inline]
pub unsafe fn PathMakeUniqueName<P2, P3, P4>(pszuniquename: &mut [u16], psztemplate: P2, pszlongplate: P3, pszdir: P4) -> windows_core::BOOL
where
    P2: windows_core::Param<windows_core::PCWSTR>,
    P3: windows_core::Param<windows_core::PCWSTR>,
    P4: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shell32.dll" "system" fn PathMakeUniqueName(pszuniquename : windows_core::PWSTR, cchmax : u32, psztemplate : windows_core::PCWSTR, pszlongplate : windows_core::PCWSTR, pszdir : windows_core::PCWSTR) -> windows_core::BOOL);
    unsafe { PathMakeUniqueName(core::mem::transmute(pszuniquename.as_ptr()), pszuniquename.len().try_into().unwrap(), psztemplate.param().abi(), pszlongplate.param().abi(), pszdir.param().abi()) }
}
#[inline]
pub unsafe fn PathMatchSpecA<P0, P1>(pszfile: P0, pszspec: P1) -> windows_core::BOOL
where
    P0: windows_core::Param<windows_core::PCSTR>,
    P1: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn PathMatchSpecA(pszfile : windows_core::PCSTR, pszspec : windows_core::PCSTR) -> windows_core::BOOL);
    unsafe { PathMatchSpecA(pszfile.param().abi(), pszspec.param().abi()) }
}
#[inline]
pub unsafe fn PathMatchSpecExA<P0, P1>(pszfile: P0, pszspec: P1, dwflags: u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCSTR>,
    P1: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn PathMatchSpecExA(pszfile : windows_core::PCSTR, pszspec : windows_core::PCSTR, dwflags : u32) -> windows_core::HRESULT);
    unsafe { PathMatchSpecExA(pszfile.param().abi(), pszspec.param().abi(), dwflags).ok() }
}
#[inline]
pub unsafe fn PathMatchSpecExW<P0, P1>(pszfile: P0, pszspec: P1, dwflags: u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn PathMatchSpecExW(pszfile : windows_core::PCWSTR, pszspec : windows_core::PCWSTR, dwflags : u32) -> windows_core::HRESULT);
    unsafe { PathMatchSpecExW(pszfile.param().abi(), pszspec.param().abi(), dwflags).ok() }
}
#[inline]
pub unsafe fn PathMatchSpecW<P0, P1>(pszfile: P0, pszspec: P1) -> windows_core::BOOL
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn PathMatchSpecW(pszfile : windows_core::PCWSTR, pszspec : windows_core::PCWSTR) -> windows_core::BOOL);
    unsafe { PathMatchSpecW(pszfile.param().abi(), pszspec.param().abi()) }
}
#[inline]
pub unsafe fn PathParseIconLocationA(psziconfile: windows_core::PSTR) -> i32 {
    windows_core::link!("shlwapi.dll" "system" fn PathParseIconLocationA(psziconfile : windows_core::PSTR) -> i32);
    unsafe { PathParseIconLocationA(core::mem::transmute(psziconfile)) }
}
#[inline]
pub unsafe fn PathParseIconLocationW(psziconfile: windows_core::PWSTR) -> i32 {
    windows_core::link!("shlwapi.dll" "system" fn PathParseIconLocationW(psziconfile : windows_core::PWSTR) -> i32);
    unsafe { PathParseIconLocationW(core::mem::transmute(psziconfile)) }
}
#[inline]
pub unsafe fn PathQualify(psz: windows_core::PWSTR) {
    windows_core::link!("shell32.dll" "system" fn PathQualify(psz : windows_core::PWSTR));
    unsafe { PathQualify(core::mem::transmute(psz)) }
}
#[inline]
pub unsafe fn PathQuoteSpacesA(lpsz: &mut [u8; 260]) -> windows_core::BOOL {
    windows_core::link!("shlwapi.dll" "system" fn PathQuoteSpacesA(lpsz : windows_core::PSTR) -> windows_core::BOOL);
    unsafe { PathQuoteSpacesA(core::mem::transmute(lpsz.as_ptr())) }
}
#[inline]
pub unsafe fn PathQuoteSpacesW(lpsz: &mut [u16; 260]) -> windows_core::BOOL {
    windows_core::link!("shlwapi.dll" "system" fn PathQuoteSpacesW(lpsz : windows_core::PWSTR) -> windows_core::BOOL);
    unsafe { PathQuoteSpacesW(core::mem::transmute(lpsz.as_ptr())) }
}
#[inline]
pub unsafe fn PathRelativePathToA<P1, P3>(pszpath: &mut [u8; 260], pszfrom: P1, dwattrfrom: u32, pszto: P3, dwattrto: u32) -> windows_core::BOOL
where
    P1: windows_core::Param<windows_core::PCSTR>,
    P3: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn PathRelativePathToA(pszpath : windows_core::PSTR, pszfrom : windows_core::PCSTR, dwattrfrom : u32, pszto : windows_core::PCSTR, dwattrto : u32) -> windows_core::BOOL);
    unsafe { PathRelativePathToA(core::mem::transmute(pszpath.as_ptr()), pszfrom.param().abi(), dwattrfrom, pszto.param().abi(), dwattrto) }
}
#[inline]
pub unsafe fn PathRelativePathToW<P1, P3>(pszpath: &mut [u16; 260], pszfrom: P1, dwattrfrom: u32, pszto: P3, dwattrto: u32) -> windows_core::BOOL
where
    P1: windows_core::Param<windows_core::PCWSTR>,
    P3: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn PathRelativePathToW(pszpath : windows_core::PWSTR, pszfrom : windows_core::PCWSTR, dwattrfrom : u32, pszto : windows_core::PCWSTR, dwattrto : u32) -> windows_core::BOOL);
    unsafe { PathRelativePathToW(core::mem::transmute(pszpath.as_ptr()), pszfrom.param().abi(), dwattrfrom, pszto.param().abi(), dwattrto) }
}
#[inline]
pub unsafe fn PathRemoveArgsA(pszpath: windows_core::PSTR) {
    windows_core::link!("shlwapi.dll" "system" fn PathRemoveArgsA(pszpath : windows_core::PSTR));
    unsafe { PathRemoveArgsA(core::mem::transmute(pszpath)) }
}
#[inline]
pub unsafe fn PathRemoveArgsW(pszpath: windows_core::PWSTR) {
    windows_core::link!("shlwapi.dll" "system" fn PathRemoveArgsW(pszpath : windows_core::PWSTR));
    unsafe { PathRemoveArgsW(core::mem::transmute(pszpath)) }
}
#[inline]
pub unsafe fn PathRemoveBackslashA(pszpath: windows_core::PSTR) -> windows_core::PSTR {
    windows_core::link!("shlwapi.dll" "system" fn PathRemoveBackslashA(pszpath : windows_core::PSTR) -> windows_core::PSTR);
    unsafe { PathRemoveBackslashA(core::mem::transmute(pszpath)) }
}
#[inline]
pub unsafe fn PathRemoveBackslashW(pszpath: windows_core::PWSTR) -> windows_core::PWSTR {
    windows_core::link!("shlwapi.dll" "system" fn PathRemoveBackslashW(pszpath : windows_core::PWSTR) -> windows_core::PWSTR);
    unsafe { PathRemoveBackslashW(core::mem::transmute(pszpath)) }
}
#[inline]
pub unsafe fn PathRemoveBlanksA(pszpath: windows_core::PSTR) {
    windows_core::link!("shlwapi.dll" "system" fn PathRemoveBlanksA(pszpath : windows_core::PSTR));
    unsafe { PathRemoveBlanksA(core::mem::transmute(pszpath)) }
}
#[inline]
pub unsafe fn PathRemoveBlanksW(pszpath: windows_core::PWSTR) {
    windows_core::link!("shlwapi.dll" "system" fn PathRemoveBlanksW(pszpath : windows_core::PWSTR));
    unsafe { PathRemoveBlanksW(core::mem::transmute(pszpath)) }
}
#[inline]
pub unsafe fn PathRemoveExtensionA(pszpath: windows_core::PSTR) {
    windows_core::link!("shlwapi.dll" "system" fn PathRemoveExtensionA(pszpath : windows_core::PSTR));
    unsafe { PathRemoveExtensionA(core::mem::transmute(pszpath)) }
}
#[inline]
pub unsafe fn PathRemoveExtensionW(pszpath: windows_core::PWSTR) {
    windows_core::link!("shlwapi.dll" "system" fn PathRemoveExtensionW(pszpath : windows_core::PWSTR));
    unsafe { PathRemoveExtensionW(core::mem::transmute(pszpath)) }
}
#[inline]
pub unsafe fn PathRemoveFileSpecA(pszpath: windows_core::PSTR) -> windows_core::BOOL {
    windows_core::link!("shlwapi.dll" "system" fn PathRemoveFileSpecA(pszpath : windows_core::PSTR) -> windows_core::BOOL);
    unsafe { PathRemoveFileSpecA(core::mem::transmute(pszpath)) }
}
#[inline]
pub unsafe fn PathRemoveFileSpecW(pszpath: windows_core::PWSTR) -> windows_core::BOOL {
    windows_core::link!("shlwapi.dll" "system" fn PathRemoveFileSpecW(pszpath : windows_core::PWSTR) -> windows_core::BOOL);
    unsafe { PathRemoveFileSpecW(core::mem::transmute(pszpath)) }
}
#[inline]
pub unsafe fn PathRenameExtensionA<P1>(pszpath: &mut [u8; 260], pszext: P1) -> windows_core::BOOL
where
    P1: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn PathRenameExtensionA(pszpath : windows_core::PSTR, pszext : windows_core::PCSTR) -> windows_core::BOOL);
    unsafe { PathRenameExtensionA(core::mem::transmute(pszpath.as_ptr()), pszext.param().abi()) }
}
#[inline]
pub unsafe fn PathRenameExtensionW<P1>(pszpath: &mut [u16; 260], pszext: P1) -> windows_core::BOOL
where
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn PathRenameExtensionW(pszpath : windows_core::PWSTR, pszext : windows_core::PCWSTR) -> windows_core::BOOL);
    unsafe { PathRenameExtensionW(core::mem::transmute(pszpath.as_ptr()), pszext.param().abi()) }
}
#[inline]
pub unsafe fn PathResolve(pszpath: &mut [u16; 260], dirs: Option<*const *const u16>, fflags: PRF_FLAGS) -> i32 {
    windows_core::link!("shell32.dll" "system" fn PathResolve(pszpath : windows_core::PWSTR, dirs : *const *const u16, fflags : u32) -> i32);
    unsafe { PathResolve(core::mem::transmute(pszpath.as_ptr()), dirs.unwrap_or(core::mem::zeroed()) as _, fflags.0 as _) }
}
#[inline]
pub unsafe fn PathSearchAndQualifyA<P0>(pszpath: P0, pszbuf: &mut [u8]) -> windows_core::BOOL
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn PathSearchAndQualifyA(pszpath : windows_core::PCSTR, pszbuf : windows_core::PSTR, cchbuf : u32) -> windows_core::BOOL);
    unsafe { PathSearchAndQualifyA(pszpath.param().abi(), core::mem::transmute(pszbuf.as_ptr()), pszbuf.len().try_into().unwrap()) }
}
#[inline]
pub unsafe fn PathSearchAndQualifyW<P0>(pszpath: P0, pszbuf: &mut [u16]) -> windows_core::BOOL
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn PathSearchAndQualifyW(pszpath : windows_core::PCWSTR, pszbuf : windows_core::PWSTR, cchbuf : u32) -> windows_core::BOOL);
    unsafe { PathSearchAndQualifyW(pszpath.param().abi(), core::mem::transmute(pszbuf.as_ptr()), pszbuf.len().try_into().unwrap()) }
}
#[inline]
pub unsafe fn PathSetDlgItemPathA<P2>(hdlg: super::super::Foundation::HWND, id: i32, pszpath: P2)
where
    P2: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn PathSetDlgItemPathA(hdlg : super::super::Foundation:: HWND, id : i32, pszpath : windows_core::PCSTR));
    unsafe { PathSetDlgItemPathA(hdlg, id, pszpath.param().abi()) }
}
#[inline]
pub unsafe fn PathSetDlgItemPathW<P2>(hdlg: super::super::Foundation::HWND, id: i32, pszpath: P2)
where
    P2: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn PathSetDlgItemPathW(hdlg : super::super::Foundation:: HWND, id : i32, pszpath : windows_core::PCWSTR));
    unsafe { PathSetDlgItemPathW(hdlg, id, pszpath.param().abi()) }
}
#[inline]
pub unsafe fn PathSkipRootA<P0>(pszpath: P0) -> windows_core::PSTR
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn PathSkipRootA(pszpath : windows_core::PCSTR) -> windows_core::PSTR);
    unsafe { PathSkipRootA(pszpath.param().abi()) }
}
#[inline]
pub unsafe fn PathSkipRootW<P0>(pszpath: P0) -> windows_core::PWSTR
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn PathSkipRootW(pszpath : windows_core::PCWSTR) -> windows_core::PWSTR);
    unsafe { PathSkipRootW(pszpath.param().abi()) }
}
#[inline]
pub unsafe fn PathStripPathA(pszpath: windows_core::PSTR) {
    windows_core::link!("shlwapi.dll" "system" fn PathStripPathA(pszpath : windows_core::PSTR));
    unsafe { PathStripPathA(core::mem::transmute(pszpath)) }
}
#[inline]
pub unsafe fn PathStripPathW(pszpath: windows_core::PWSTR) {
    windows_core::link!("shlwapi.dll" "system" fn PathStripPathW(pszpath : windows_core::PWSTR));
    unsafe { PathStripPathW(core::mem::transmute(pszpath)) }
}
#[inline]
pub unsafe fn PathStripToRootA(pszpath: windows_core::PSTR) -> windows_core::BOOL {
    windows_core::link!("shlwapi.dll" "system" fn PathStripToRootA(pszpath : windows_core::PSTR) -> windows_core::BOOL);
    unsafe { PathStripToRootA(core::mem::transmute(pszpath)) }
}
#[inline]
pub unsafe fn PathStripToRootW(pszpath: windows_core::PWSTR) -> windows_core::BOOL {
    windows_core::link!("shlwapi.dll" "system" fn PathStripToRootW(pszpath : windows_core::PWSTR) -> windows_core::BOOL);
    unsafe { PathStripToRootW(core::mem::transmute(pszpath)) }
}
#[inline]
pub unsafe fn PathUnExpandEnvStringsA<P0>(pszpath: P0, pszbuf: &mut [u8]) -> windows_core::BOOL
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn PathUnExpandEnvStringsA(pszpath : windows_core::PCSTR, pszbuf : windows_core::PSTR, cchbuf : u32) -> windows_core::BOOL);
    unsafe { PathUnExpandEnvStringsA(pszpath.param().abi(), core::mem::transmute(pszbuf.as_ptr()), pszbuf.len().try_into().unwrap()) }
}
#[inline]
pub unsafe fn PathUnExpandEnvStringsW<P0>(pszpath: P0, pszbuf: &mut [u16]) -> windows_core::BOOL
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn PathUnExpandEnvStringsW(pszpath : windows_core::PCWSTR, pszbuf : windows_core::PWSTR, cchbuf : u32) -> windows_core::BOOL);
    unsafe { PathUnExpandEnvStringsW(pszpath.param().abi(), core::mem::transmute(pszbuf.as_ptr()), pszbuf.len().try_into().unwrap()) }
}
#[inline]
pub unsafe fn PathUndecorateA(pszpath: windows_core::PSTR) {
    windows_core::link!("shlwapi.dll" "system" fn PathUndecorateA(pszpath : windows_core::PSTR));
    unsafe { PathUndecorateA(core::mem::transmute(pszpath)) }
}
#[inline]
pub unsafe fn PathUndecorateW(pszpath: windows_core::PWSTR) {
    windows_core::link!("shlwapi.dll" "system" fn PathUndecorateW(pszpath : windows_core::PWSTR));
    unsafe { PathUndecorateW(core::mem::transmute(pszpath)) }
}
#[inline]
pub unsafe fn PathUnmakeSystemFolderA<P0>(pszpath: P0) -> windows_core::BOOL
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn PathUnmakeSystemFolderA(pszpath : windows_core::PCSTR) -> windows_core::BOOL);
    unsafe { PathUnmakeSystemFolderA(pszpath.param().abi()) }
}
#[inline]
pub unsafe fn PathUnmakeSystemFolderW<P0>(pszpath: P0) -> windows_core::BOOL
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn PathUnmakeSystemFolderW(pszpath : windows_core::PCWSTR) -> windows_core::BOOL);
    unsafe { PathUnmakeSystemFolderW(pszpath.param().abi()) }
}
#[inline]
pub unsafe fn PathUnquoteSpacesA(lpsz: windows_core::PSTR) -> windows_core::BOOL {
    windows_core::link!("shlwapi.dll" "system" fn PathUnquoteSpacesA(lpsz : windows_core::PSTR) -> windows_core::BOOL);
    unsafe { PathUnquoteSpacesA(core::mem::transmute(lpsz)) }
}
#[inline]
pub unsafe fn PathUnquoteSpacesW(lpsz: windows_core::PWSTR) -> windows_core::BOOL {
    windows_core::link!("shlwapi.dll" "system" fn PathUnquoteSpacesW(lpsz : windows_core::PWSTR) -> windows_core::BOOL);
    unsafe { PathUnquoteSpacesW(core::mem::transmute(lpsz)) }
}
#[inline]
pub unsafe fn PathYetAnotherMakeUniqueName<P1, P2, P3>(pszuniquename: &mut [u16; 260], pszpath: P1, pszshort: P2, pszfilespec: P3) -> windows_core::BOOL
where
    P1: windows_core::Param<windows_core::PCWSTR>,
    P2: windows_core::Param<windows_core::PCWSTR>,
    P3: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shell32.dll" "system" fn PathYetAnotherMakeUniqueName(pszuniquename : windows_core::PWSTR, pszpath : windows_core::PCWSTR, pszshort : windows_core::PCWSTR, pszfilespec : windows_core::PCWSTR) -> windows_core::BOOL);
    unsafe { PathYetAnotherMakeUniqueName(core::mem::transmute(pszuniquename.as_ptr()), pszpath.param().abi(), pszshort.param().abi(), pszfilespec.param().abi()) }
}
#[inline]
pub unsafe fn PickIconDlg(hwnd: Option<super::super::Foundation::HWND>, psziconpath: &mut [u16], piiconindex: Option<*mut i32>) -> i32 {
    windows_core::link!("shell32.dll" "system" fn PickIconDlg(hwnd : super::super::Foundation:: HWND, psziconpath : windows_core::PWSTR, cchiconpath : u32, piiconindex : *mut i32) -> i32);
    unsafe { PickIconDlg(hwnd.unwrap_or(core::mem::zeroed()) as _, core::mem::transmute(psziconpath.as_ptr()), psziconpath.len().try_into().unwrap(), piiconindex.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(all(feature = "Win32_System_Com_StructuredStorage", feature = "Win32_System_Variant", feature = "Win32_UI_Shell_Common"))]
#[inline]
pub unsafe fn PropVariantToStrRet(propvar: *const super::super::System::Com::StructuredStorage::PROPVARIANT, pstrret: *mut Common::STRRET) -> windows_core::Result<()> {
    windows_core::link!("propsys.dll" "system" fn PropVariantToStrRet(propvar : *const super::super::System::Com::StructuredStorage:: PROPVARIANT, pstrret : *mut Common:: STRRET) -> windows_core::HRESULT);
    unsafe { PropVariantToStrRet(core::mem::transmute(propvar), pstrret as _).ok() }
}
#[inline]
pub unsafe fn QISearch<T>(that: *mut core::ffi::c_void, pqit: *const QITAB) -> windows_core::Result<T>
where
    T: windows_core::Interface,
{
    windows_core::link!("shlwapi.dll" "system" fn QISearch(that : *mut core::ffi::c_void, pqit : *const QITAB, riid : *const windows_core::GUID, ppv : *mut *mut core::ffi::c_void) -> windows_core::HRESULT);
    let mut result__ = core::ptr::null_mut();
    unsafe { QISearch(that as _, pqit, &T::IID, &mut result__).and_then(|| windows_core::Type::from_abi(result__)) }
}
#[inline]
pub unsafe fn ReadCabinetState(pcs: *mut CABINETSTATE, clength: i32) -> windows_core::BOOL {
    windows_core::link!("shell32.dll" "system" fn ReadCabinetState(pcs : *mut CABINETSTATE, clength : i32) -> windows_core::BOOL);
    unsafe { ReadCabinetState(pcs as _, clength) }
}
#[inline]
pub unsafe fn RealDriveType(idrive: i32, foktohitnet: bool) -> i32 {
    windows_core::link!("shell32.dll" "system" fn RealDriveType(idrive : i32, foktohitnet : windows_core::BOOL) -> i32);
    unsafe { RealDriveType(idrive, foktohitnet.into()) }
}
#[inline]
pub unsafe fn RegisterAppConstrainedChangeNotification(routine: PAPPCONSTRAIN_CHANGE_ROUTINE, context: Option<*const core::ffi::c_void>, registration: *mut PAPPCONSTRAIN_REGISTRATION) -> u32 {
    windows_core::link!("api-ms-win-core-psm-appnotify-l1-1-1.dll" "system" fn RegisterAppConstrainedChangeNotification(routine : PAPPCONSTRAIN_CHANGE_ROUTINE, context : *const core::ffi::c_void, registration : *mut PAPPCONSTRAIN_REGISTRATION) -> u32);
    unsafe { RegisterAppConstrainedChangeNotification(routine, context.unwrap_or(core::mem::zeroed()) as _, registration as _) }
}
#[inline]
pub unsafe fn RegisterAppStateChangeNotification(routine: PAPPSTATE_CHANGE_ROUTINE, context: Option<*const core::ffi::c_void>, registration: *mut PAPPSTATE_REGISTRATION) -> u32 {
    windows_core::link!("api-ms-win-core-psm-appnotify-l1-1-0.dll" "system" fn RegisterAppStateChangeNotification(routine : PAPPSTATE_CHANGE_ROUTINE, context : *const core::ffi::c_void, registration : *mut PAPPSTATE_REGISTRATION) -> u32);
    unsafe { RegisterAppStateChangeNotification(routine, context.unwrap_or(core::mem::zeroed()) as _, registration as _) }
}
#[inline]
pub unsafe fn RegisterScaleChangeEvent(hevent: super::super::Foundation::HANDLE) -> windows_core::Result<usize> {
    windows_core::link!("api-ms-win-shcore-scaling-l1-1-1.dll" "system" fn RegisterScaleChangeEvent(hevent : super::super::Foundation:: HANDLE, pdwcookie : *mut usize) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        RegisterScaleChangeEvent(hevent, &mut result__).map(|| result__)
    }
}
#[inline]
pub unsafe fn RegisterScaleChangeNotifications(displaydevice: DISPLAY_DEVICE_TYPE, hwndnotify: super::super::Foundation::HWND, umsgnotify: u32) -> windows_core::Result<u32> {
    windows_core::link!("api-ms-win-shcore-scaling-l1-1-0.dll" "system" fn RegisterScaleChangeNotifications(displaydevice : DISPLAY_DEVICE_TYPE, hwndnotify : super::super::Foundation:: HWND, umsgnotify : u32, pdwcookie : *mut u32) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        RegisterScaleChangeNotifications(displaydevice, hwndnotify, umsgnotify, &mut result__).map(|| result__)
    }
}
#[inline]
pub unsafe fn RemoveWindowSubclass(hwnd: super::super::Foundation::HWND, pfnsubclass: SUBCLASSPROC, uidsubclass: usize) -> windows_core::BOOL {
    windows_core::link!("comctl32.dll" "system" fn RemoveWindowSubclass(hwnd : super::super::Foundation:: HWND, pfnsubclass : SUBCLASSPROC, uidsubclass : usize) -> windows_core::BOOL);
    unsafe { RemoveWindowSubclass(hwnd, pfnsubclass, uidsubclass) }
}
#[inline]
pub unsafe fn RestartDialog<P1>(hwnd: Option<super::super::Foundation::HWND>, pszprompt: P1, dwreturn: u32) -> i32
where
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shell32.dll" "system" fn RestartDialog(hwnd : super::super::Foundation:: HWND, pszprompt : windows_core::PCWSTR, dwreturn : u32) -> i32);
    unsafe { RestartDialog(hwnd.unwrap_or(core::mem::zeroed()) as _, pszprompt.param().abi(), dwreturn) }
}
#[inline]
pub unsafe fn RestartDialogEx<P1>(hwnd: Option<super::super::Foundation::HWND>, pszprompt: P1, dwreturn: u32, dwreasoncode: u32) -> i32
where
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shell32.dll" "system" fn RestartDialogEx(hwnd : super::super::Foundation:: HWND, pszprompt : windows_core::PCWSTR, dwreturn : u32, dwreasoncode : u32) -> i32);
    unsafe { RestartDialogEx(hwnd.unwrap_or(core::mem::zeroed()) as _, pszprompt.param().abi(), dwreturn, dwreasoncode) }
}
#[inline]
pub unsafe fn RevokeScaleChangeNotifications(displaydevice: DISPLAY_DEVICE_TYPE, dwcookie: u32) -> windows_core::Result<()> {
    windows_core::link!("api-ms-win-shcore-scaling-l1-1-0.dll" "system" fn RevokeScaleChangeNotifications(displaydevice : DISPLAY_DEVICE_TYPE, dwcookie : u32) -> windows_core::HRESULT);
    unsafe { RevokeScaleChangeNotifications(displaydevice, dwcookie).ok() }
}
#[cfg(feature = "Win32_UI_Controls")]
#[inline]
pub unsafe fn SHAddFromPropSheetExtArray(hpsxa: HPSXA, lpfnaddpage: super::Controls::LPFNSVADDPROPSHEETPAGE, lparam: super::super::Foundation::LPARAM) -> u32 {
    windows_core::link!("shell32.dll" "system" fn SHAddFromPropSheetExtArray(hpsxa : HPSXA, lpfnaddpage : super::Controls:: LPFNSVADDPROPSHEETPAGE, lparam : super::super::Foundation:: LPARAM) -> u32);
    unsafe { SHAddFromPropSheetExtArray(hpsxa, lpfnaddpage, lparam) }
}
#[inline]
pub unsafe fn SHAddToRecentDocs(uflags: u32, pv: Option<*const core::ffi::c_void>) {
    windows_core::link!("shell32.dll" "system" fn SHAddToRecentDocs(uflags : u32, pv : *const core::ffi::c_void));
    unsafe { SHAddToRecentDocs(uflags, pv.unwrap_or(core::mem::zeroed()) as _) }
}
#[inline]
pub unsafe fn SHAlloc(cb: usize) -> *mut core::ffi::c_void {
    windows_core::link!("shell32.dll" "system" fn SHAlloc(cb : usize) -> *mut core::ffi::c_void);
    unsafe { SHAlloc(cb) }
}
#[inline]
pub unsafe fn SHAllocShared(pvdata: Option<*const core::ffi::c_void>, dwsize: u32, dwprocessid: u32) -> super::super::Foundation::HANDLE {
    windows_core::link!("shlwapi.dll" "system" fn SHAllocShared(pvdata : *const core::ffi::c_void, dwsize : u32, dwprocessid : u32) -> super::super::Foundation:: HANDLE);
    unsafe { SHAllocShared(pvdata.unwrap_or(core::mem::zeroed()) as _, dwsize, dwprocessid) }
}
#[inline]
pub unsafe fn SHAnsiToAnsi<P0>(pszsrc: P0, pszdst: &mut [u8]) -> i32
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn SHAnsiToAnsi(pszsrc : windows_core::PCSTR, pszdst : windows_core::PSTR, cchbuf : i32) -> i32);
    unsafe { SHAnsiToAnsi(pszsrc.param().abi(), core::mem::transmute(pszdst.as_ptr()), pszdst.len().try_into().unwrap()) }
}
#[inline]
pub unsafe fn SHAnsiToUnicode<P0>(pszsrc: P0, pwszdst: &mut [u16]) -> i32
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn SHAnsiToUnicode(pszsrc : windows_core::PCSTR, pwszdst : windows_core::PWSTR, cwchbuf : i32) -> i32);
    unsafe { SHAnsiToUnicode(pszsrc.param().abi(), core::mem::transmute(pwszdst.as_ptr()), pwszdst.len().try_into().unwrap()) }
}
#[inline]
pub unsafe fn SHAppBarMessage(dwmessage: u32, pdata: *mut APPBARDATA) -> usize {
    windows_core::link!("shell32.dll" "system" fn SHAppBarMessage(dwmessage : u32, pdata : *mut APPBARDATA) -> usize);
    unsafe { SHAppBarMessage(dwmessage, pdata as _) }
}
#[inline]
pub unsafe fn SHAssocEnumHandlers<P0>(pszextra: P0, affilter: ASSOC_FILTER) -> windows_core::Result<IEnumAssocHandlers>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shell32.dll" "system" fn SHAssocEnumHandlers(pszextra : windows_core::PCWSTR, affilter : ASSOC_FILTER, ppenumhandler : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        SHAssocEnumHandlers(pszextra.param().abi(), affilter, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn SHAssocEnumHandlersForProtocolByApplication<P0, T>(protocol: P0) -> windows_core::Result<T>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    T: windows_core::Interface,
{
    windows_core::link!("shell32.dll" "system" fn SHAssocEnumHandlersForProtocolByApplication(protocol : windows_core::PCWSTR, riid : *const windows_core::GUID, enumhandlers : *mut *mut core::ffi::c_void) -> windows_core::HRESULT);
    let mut result__ = core::ptr::null_mut();
    unsafe { SHAssocEnumHandlersForProtocolByApplication(protocol.param().abi(), &T::IID, &mut result__).and_then(|| windows_core::Type::from_abi(result__)) }
}
#[inline]
pub unsafe fn SHAutoComplete(hwndedit: super::super::Foundation::HWND, dwflags: SHELL_AUTOCOMPLETE_FLAGS) -> windows_core::Result<()> {
    windows_core::link!("shlwapi.dll" "system" fn SHAutoComplete(hwndedit : super::super::Foundation:: HWND, dwflags : SHELL_AUTOCOMPLETE_FLAGS) -> windows_core::HRESULT);
    unsafe { SHAutoComplete(hwndedit, dwflags).ok() }
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn SHBindToFolderIDListParent<P0, T>(psfroot: P0, pidl: *const Common::ITEMIDLIST, ppidllast: Option<*mut *mut Common::ITEMIDLIST>) -> windows_core::Result<T>
where
    P0: windows_core::Param<IShellFolder>,
    T: windows_core::Interface,
{
    windows_core::link!("shell32.dll" "system" fn SHBindToFolderIDListParent(psfroot : * mut core::ffi::c_void, pidl : *const Common:: ITEMIDLIST, riid : *const windows_core::GUID, ppv : *mut *mut core::ffi::c_void, ppidllast : *mut *mut Common:: ITEMIDLIST) -> windows_core::HRESULT);
    let mut result__ = core::ptr::null_mut();
    unsafe { SHBindToFolderIDListParent(psfroot.param().abi(), pidl, &T::IID, &mut result__, ppidllast.unwrap_or(core::mem::zeroed()) as _).and_then(|| windows_core::Type::from_abi(result__)) }
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_UI_Shell_Common"))]
#[inline]
pub unsafe fn SHBindToFolderIDListParentEx<P0, P2, T>(psfroot: P0, pidl: *const Common::ITEMIDLIST, ppbc: P2, ppidllast: Option<*mut *mut Common::ITEMIDLIST>) -> windows_core::Result<T>
where
    P0: windows_core::Param<IShellFolder>,
    P2: windows_core::Param<super::super::System::Com::IBindCtx>,
    T: windows_core::Interface,
{
    windows_core::link!("shell32.dll" "system" fn SHBindToFolderIDListParentEx(psfroot : * mut core::ffi::c_void, pidl : *const Common:: ITEMIDLIST, ppbc : * mut core::ffi::c_void, riid : *const windows_core::GUID, ppv : *mut *mut core::ffi::c_void, ppidllast : *mut *mut Common:: ITEMIDLIST) -> windows_core::HRESULT);
    let mut result__ = core::ptr::null_mut();
    unsafe { SHBindToFolderIDListParentEx(psfroot.param().abi(), pidl, ppbc.param().abi(), &T::IID, &mut result__, ppidllast.unwrap_or(core::mem::zeroed()) as _).and_then(|| windows_core::Type::from_abi(result__)) }
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_UI_Shell_Common"))]
#[inline]
pub unsafe fn SHBindToObject<P0, P2, T>(psf: P0, pidl: *const Common::ITEMIDLIST, pbc: P2) -> windows_core::Result<T>
where
    P0: windows_core::Param<IShellFolder>,
    P2: windows_core::Param<super::super::System::Com::IBindCtx>,
    T: windows_core::Interface,
{
    windows_core::link!("shell32.dll" "system" fn SHBindToObject(psf : * mut core::ffi::c_void, pidl : *const Common:: ITEMIDLIST, pbc : * mut core::ffi::c_void, riid : *const windows_core::GUID, ppv : *mut *mut core::ffi::c_void) -> windows_core::HRESULT);
    let mut result__ = core::ptr::null_mut();
    unsafe { SHBindToObject(psf.param().abi(), pidl, pbc.param().abi(), &T::IID, &mut result__).and_then(|| windows_core::Type::from_abi(result__)) }
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn SHBindToParent<T>(pidl: *const Common::ITEMIDLIST, ppidllast: Option<*mut *mut Common::ITEMIDLIST>) -> windows_core::Result<T>
where
    T: windows_core::Interface,
{
    windows_core::link!("shell32.dll" "system" fn SHBindToParent(pidl : *const Common:: ITEMIDLIST, riid : *const windows_core::GUID, ppv : *mut *mut core::ffi::c_void, ppidllast : *mut *mut Common:: ITEMIDLIST) -> windows_core::HRESULT);
    let mut result__ = core::ptr::null_mut();
    unsafe { SHBindToParent(pidl, &T::IID, &mut result__, ppidllast.unwrap_or(core::mem::zeroed()) as _).and_then(|| windows_core::Type::from_abi(result__)) }
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn SHBrowseForFolderA(lpbi: *const BROWSEINFOA) -> *mut Common::ITEMIDLIST {
    windows_core::link!("shell32.dll" "system" fn SHBrowseForFolderA(lpbi : *const BROWSEINFOA) -> *mut Common:: ITEMIDLIST);
    unsafe { SHBrowseForFolderA(lpbi) }
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn SHBrowseForFolderW(lpbi: *const BROWSEINFOW) -> *mut Common::ITEMIDLIST {
    windows_core::link!("shell32.dll" "system" fn SHBrowseForFolderW(lpbi : *const BROWSEINFOW) -> *mut Common:: ITEMIDLIST);
    unsafe { SHBrowseForFolderW(lpbi) }
}
#[inline]
pub unsafe fn SHCLSIDFromString<P0>(psz: P0) -> windows_core::Result<windows_core::GUID>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shell32.dll" "system" fn SHCLSIDFromString(psz : windows_core::PCWSTR, pclsid : *mut windows_core::GUID) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        SHCLSIDFromString(psz.param().abi(), &mut result__).map(|| result__)
    }
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn SHChangeNotification_Lock(hchange: super::super::Foundation::HANDLE, dwprocid: u32, pppidl: Option<*mut *mut *mut Common::ITEMIDLIST>, plevent: Option<*mut i32>) -> super::super::Foundation::HANDLE {
    windows_core::link!("shell32.dll" "system" fn SHChangeNotification_Lock(hchange : super::super::Foundation:: HANDLE, dwprocid : u32, pppidl : *mut *mut *mut Common:: ITEMIDLIST, plevent : *mut i32) -> super::super::Foundation:: HANDLE);
    unsafe { SHChangeNotification_Lock(hchange, dwprocid, pppidl.unwrap_or(core::mem::zeroed()) as _, plevent.unwrap_or(core::mem::zeroed()) as _) }
}
#[inline]
pub unsafe fn SHChangeNotification_Unlock(hlock: super::super::Foundation::HANDLE) -> windows_core::BOOL {
    windows_core::link!("shell32.dll" "system" fn SHChangeNotification_Unlock(hlock : super::super::Foundation:: HANDLE) -> windows_core::BOOL);
    unsafe { SHChangeNotification_Unlock(hlock) }
}
#[inline]
pub unsafe fn SHChangeNotify(weventid: SHCNE_ID, uflags: SHCNF_FLAGS, dwitem1: Option<*const core::ffi::c_void>, dwitem2: Option<*const core::ffi::c_void>) {
    windows_core::link!("shell32.dll" "system" fn SHChangeNotify(weventid : i32, uflags : SHCNF_FLAGS, dwitem1 : *const core::ffi::c_void, dwitem2 : *const core::ffi::c_void));
    unsafe { SHChangeNotify(weventid.0 as _, uflags, dwitem1.unwrap_or(core::mem::zeroed()) as _, dwitem2.unwrap_or(core::mem::zeroed()) as _) }
}
#[inline]
pub unsafe fn SHChangeNotifyDeregister(ulid: u32) -> windows_core::BOOL {
    windows_core::link!("shell32.dll" "system" fn SHChangeNotifyDeregister(ulid : u32) -> windows_core::BOOL);
    unsafe { SHChangeNotifyDeregister(ulid) }
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn SHChangeNotifyRegister(hwnd: super::super::Foundation::HWND, fsources: SHCNRF_SOURCE, fevents: i32, wmsg: u32, centries: i32, pshcne: *const SHChangeNotifyEntry) -> u32 {
    windows_core::link!("shell32.dll" "system" fn SHChangeNotifyRegister(hwnd : super::super::Foundation:: HWND, fsources : SHCNRF_SOURCE, fevents : i32, wmsg : u32, centries : i32, pshcne : *const SHChangeNotifyEntry) -> u32);
    unsafe { SHChangeNotifyRegister(hwnd, fsources, fevents, wmsg, centries, pshcne) }
}
#[inline]
pub unsafe fn SHChangeNotifyRegisterThread(status: SCNRT_STATUS) {
    windows_core::link!("shell32.dll" "system" fn SHChangeNotifyRegisterThread(status : SCNRT_STATUS));
    unsafe { SHChangeNotifyRegisterThread(status) }
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn SHCloneSpecialIDList(hwnd: Option<super::super::Foundation::HWND>, csidl: i32, fcreate: bool) -> *mut Common::ITEMIDLIST {
    windows_core::link!("shell32.dll" "system" fn SHCloneSpecialIDList(hwnd : super::super::Foundation:: HWND, csidl : i32, fcreate : windows_core::BOOL) -> *mut Common:: ITEMIDLIST);
    unsafe { SHCloneSpecialIDList(hwnd.unwrap_or(core::mem::zeroed()) as _, csidl, fcreate.into()) }
}
#[inline]
pub unsafe fn SHCoCreateInstance<P0, P2, T>(pszclsid: P0, pclsid: Option<*const windows_core::GUID>, punkouter: P2) -> windows_core::Result<T>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P2: windows_core::Param<windows_core::IUnknown>,
    T: windows_core::Interface,
{
    windows_core::link!("shell32.dll" "system" fn SHCoCreateInstance(pszclsid : windows_core::PCWSTR, pclsid : *const windows_core::GUID, punkouter : * mut core::ffi::c_void, riid : *const windows_core::GUID, ppv : *mut *mut core::ffi::c_void) -> windows_core::HRESULT);
    let mut result__ = core::ptr::null_mut();
    unsafe { SHCoCreateInstance(pszclsid.param().abi(), pclsid.unwrap_or(core::mem::zeroed()) as _, punkouter.param().abi(), &T::IID, &mut result__).and_then(|| windows_core::Type::from_abi(result__)) }
}
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn SHCopyKeyA<P1>(hkeysrc: super::super::System::Registry::HKEY, pszsrcsubkey: P1, hkeydest: super::super::System::Registry::HKEY, freserved: Option<u32>) -> super::super::Foundation::WIN32_ERROR
where
    P1: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn SHCopyKeyA(hkeysrc : super::super::System::Registry:: HKEY, pszsrcsubkey : windows_core::PCSTR, hkeydest : super::super::System::Registry:: HKEY, freserved : u32) -> super::super::Foundation:: WIN32_ERROR);
    unsafe { SHCopyKeyA(hkeysrc, pszsrcsubkey.param().abi(), hkeydest, freserved.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn SHCopyKeyW<P1>(hkeysrc: super::super::System::Registry::HKEY, pszsrcsubkey: P1, hkeydest: super::super::System::Registry::HKEY, freserved: Option<u32>) -> super::super::Foundation::WIN32_ERROR
where
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn SHCopyKeyW(hkeysrc : super::super::System::Registry:: HKEY, pszsrcsubkey : windows_core::PCWSTR, hkeydest : super::super::System::Registry:: HKEY, freserved : u32) -> super::super::Foundation:: WIN32_ERROR);
    unsafe { SHCopyKeyW(hkeysrc, pszsrcsubkey.param().abi(), hkeydest, freserved.unwrap_or(core::mem::zeroed()) as _) }
}
#[inline]
pub unsafe fn SHCreateAssociationRegistration<T>() -> windows_core::Result<T>
where
    T: windows_core::Interface,
{
    windows_core::link!("shell32.dll" "system" fn SHCreateAssociationRegistration(riid : *const windows_core::GUID, ppv : *mut *mut core::ffi::c_void) -> windows_core::HRESULT);
    let mut result__ = core::ptr::null_mut();
    unsafe { SHCreateAssociationRegistration(&T::IID, &mut result__).and_then(|| windows_core::Type::from_abi(result__)) }
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_UI_Shell_Common"))]
#[inline]
pub unsafe fn SHCreateDataObject<P3, T>(pidlfolder: Option<*const Common::ITEMIDLIST>, apidl: Option<&[*const Common::ITEMIDLIST]>, pdtinner: P3) -> windows_core::Result<T>
where
    P3: windows_core::Param<super::super::System::Com::IDataObject>,
    T: windows_core::Interface,
{
    windows_core::link!("shell32.dll" "system" fn SHCreateDataObject(pidlfolder : *const Common:: ITEMIDLIST, cidl : u32, apidl : *const *const Common:: ITEMIDLIST, pdtinner : * mut core::ffi::c_void, riid : *const windows_core::GUID, ppv : *mut *mut core::ffi::c_void) -> windows_core::HRESULT);
    let mut result__ = core::ptr::null_mut();
    unsafe { SHCreateDataObject(pidlfolder.unwrap_or(core::mem::zeroed()) as _, apidl.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(apidl.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), pdtinner.param().abi(), &T::IID, &mut result__).and_then(|| windows_core::Type::from_abi(result__)) }
}
#[cfg(all(feature = "Win32_System_Registry", feature = "Win32_UI_Shell_Common"))]
#[inline]
pub unsafe fn SHCreateDefaultContextMenu<T>(pdcm: *const DEFCONTEXTMENU) -> windows_core::Result<T>
where
    T: windows_core::Interface,
{
    windows_core::link!("shell32.dll" "system" fn SHCreateDefaultContextMenu(pdcm : *const DEFCONTEXTMENU, riid : *const windows_core::GUID, ppv : *mut *mut core::ffi::c_void) -> windows_core::HRESULT);
    let mut result__ = core::ptr::null_mut();
    unsafe { SHCreateDefaultContextMenu(core::mem::transmute(pdcm), &T::IID, &mut result__).and_then(|| windows_core::Type::from_abi(result__)) }
}
#[inline]
pub unsafe fn SHCreateDefaultExtractIcon<T>() -> windows_core::Result<T>
where
    T: windows_core::Interface,
{
    windows_core::link!("shell32.dll" "system" fn SHCreateDefaultExtractIcon(riid : *const windows_core::GUID, ppv : *mut *mut core::ffi::c_void) -> windows_core::HRESULT);
    let mut result__ = core::ptr::null_mut();
    unsafe { SHCreateDefaultExtractIcon(&T::IID, &mut result__).and_then(|| windows_core::Type::from_abi(result__)) }
}
#[inline]
pub unsafe fn SHCreateDefaultPropertiesOp<P0>(psi: P0) -> windows_core::Result<IFileOperation>
where
    P0: windows_core::Param<IShellItem>,
{
    windows_core::link!("shell32.dll" "system" fn SHCreateDefaultPropertiesOp(psi : * mut core::ffi::c_void, ppfileop : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        SHCreateDefaultPropertiesOp(psi.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn SHCreateDirectory<P1>(hwnd: Option<super::super::Foundation::HWND>, pszpath: P1) -> i32
where
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shell32.dll" "system" fn SHCreateDirectory(hwnd : super::super::Foundation:: HWND, pszpath : windows_core::PCWSTR) -> i32);
    unsafe { SHCreateDirectory(hwnd.unwrap_or(core::mem::zeroed()) as _, pszpath.param().abi()) }
}
#[cfg(feature = "Win32_Security")]
#[inline]
pub unsafe fn SHCreateDirectoryExA<P1>(hwnd: Option<super::super::Foundation::HWND>, pszpath: P1, psa: Option<*const super::super::Security::SECURITY_ATTRIBUTES>) -> i32
where
    P1: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shell32.dll" "system" fn SHCreateDirectoryExA(hwnd : super::super::Foundation:: HWND, pszpath : windows_core::PCSTR, psa : *const super::super::Security:: SECURITY_ATTRIBUTES) -> i32);
    unsafe { SHCreateDirectoryExA(hwnd.unwrap_or(core::mem::zeroed()) as _, pszpath.param().abi(), psa.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(feature = "Win32_Security")]
#[inline]
pub unsafe fn SHCreateDirectoryExW<P1>(hwnd: Option<super::super::Foundation::HWND>, pszpath: P1, psa: Option<*const super::super::Security::SECURITY_ATTRIBUTES>) -> i32
where
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shell32.dll" "system" fn SHCreateDirectoryExW(hwnd : super::super::Foundation:: HWND, pszpath : windows_core::PCWSTR, psa : *const super::super::Security:: SECURITY_ATTRIBUTES) -> i32);
    unsafe { SHCreateDirectoryExW(hwnd.unwrap_or(core::mem::zeroed()) as _, pszpath.param().abi(), psa.unwrap_or(core::mem::zeroed()) as _) }
}
#[inline]
pub unsafe fn SHCreateFileExtractIconW<P0, T>(pszfile: P0, dwfileattributes: u32) -> windows_core::Result<T>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    T: windows_core::Interface,
{
    windows_core::link!("shell32.dll" "system" fn SHCreateFileExtractIconW(pszfile : windows_core::PCWSTR, dwfileattributes : u32, riid : *const windows_core::GUID, ppv : *mut *mut core::ffi::c_void) -> windows_core::HRESULT);
    let mut result__ = core::ptr::null_mut();
    unsafe { SHCreateFileExtractIconW(pszfile.param().abi(), dwfileattributes, &T::IID, &mut result__).and_then(|| windows_core::Type::from_abi(result__)) }
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn SHCreateItemFromIDList<T>(pidl: *const Common::ITEMIDLIST) -> windows_core::Result<T>
where
    T: windows_core::Interface,
{
    windows_core::link!("shell32.dll" "system" fn SHCreateItemFromIDList(pidl : *const Common:: ITEMIDLIST, riid : *const windows_core::GUID, ppv : *mut *mut core::ffi::c_void) -> windows_core::HRESULT);
    let mut result__ = core::ptr::null_mut();
    unsafe { SHCreateItemFromIDList(pidl, &T::IID, &mut result__).and_then(|| windows_core::Type::from_abi(result__)) }
}
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn SHCreateItemFromParsingName<P0, P1, T>(pszpath: P0, pbc: P1) -> windows_core::Result<T>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<super::super::System::Com::IBindCtx>,
    T: windows_core::Interface,
{
    windows_core::link!("shell32.dll" "system" fn SHCreateItemFromParsingName(pszpath : windows_core::PCWSTR, pbc : * mut core::ffi::c_void, riid : *const windows_core::GUID, ppv : *mut *mut core::ffi::c_void) -> windows_core::HRESULT);
    let mut result__ = core::ptr::null_mut();
    unsafe { SHCreateItemFromParsingName(pszpath.param().abi(), pbc.param().abi(), &T::IID, &mut result__).and_then(|| windows_core::Type::from_abi(result__)) }
}
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn SHCreateItemFromRelativeName<P0, P1, P2, T>(psiparent: P0, pszname: P1, pbc: P2) -> windows_core::Result<T>
where
    P0: windows_core::Param<IShellItem>,
    P1: windows_core::Param<windows_core::PCWSTR>,
    P2: windows_core::Param<super::super::System::Com::IBindCtx>,
    T: windows_core::Interface,
{
    windows_core::link!("shell32.dll" "system" fn SHCreateItemFromRelativeName(psiparent : * mut core::ffi::c_void, pszname : windows_core::PCWSTR, pbc : * mut core::ffi::c_void, riid : *const windows_core::GUID, ppv : *mut *mut core::ffi::c_void) -> windows_core::HRESULT);
    let mut result__ = core::ptr::null_mut();
    unsafe { SHCreateItemFromRelativeName(psiparent.param().abi(), pszname.param().abi(), pbc.param().abi(), &T::IID, &mut result__).and_then(|| windows_core::Type::from_abi(result__)) }
}
#[inline]
pub unsafe fn SHCreateItemInKnownFolder<P2, T>(kfid: *const windows_core::GUID, dwkfflags: KNOWN_FOLDER_FLAG, pszitem: P2) -> windows_core::Result<T>
where
    P2: windows_core::Param<windows_core::PCWSTR>,
    T: windows_core::Interface,
{
    windows_core::link!("shell32.dll" "system" fn SHCreateItemInKnownFolder(kfid : *const windows_core::GUID, dwkfflags : u32, pszitem : windows_core::PCWSTR, riid : *const windows_core::GUID, ppv : *mut *mut core::ffi::c_void) -> windows_core::HRESULT);
    let mut result__ = core::ptr::null_mut();
    unsafe { SHCreateItemInKnownFolder(kfid, dwkfflags.0 as _, pszitem.param().abi(), &T::IID, &mut result__).and_then(|| windows_core::Type::from_abi(result__)) }
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn SHCreateItemWithParent<P1, T>(pidlparent: Option<*const Common::ITEMIDLIST>, psfparent: P1, pidl: *const Common::ITEMIDLIST) -> windows_core::Result<T>
where
    P1: windows_core::Param<IShellFolder>,
    T: windows_core::Interface,
{
    windows_core::link!("shell32.dll" "system" fn SHCreateItemWithParent(pidlparent : *const Common:: ITEMIDLIST, psfparent : * mut core::ffi::c_void, pidl : *const Common:: ITEMIDLIST, riid : *const windows_core::GUID, ppvitem : *mut *mut core::ffi::c_void) -> windows_core::HRESULT);
    let mut result__ = core::ptr::null_mut();
    unsafe { SHCreateItemWithParent(pidlparent.unwrap_or(core::mem::zeroed()) as _, psfparent.param().abi(), pidl, &T::IID, &mut result__).and_then(|| windows_core::Type::from_abi(result__)) }
}
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn SHCreateMemStream(pinit: Option<&[u8]>) -> Option<super::super::System::Com::IStream> {
    windows_core::link!("shlwapi.dll" "system" fn SHCreateMemStream(pinit : *const u8, cbinit : u32) -> Option < super::super::System::Com:: IStream >);
    unsafe { SHCreateMemStream(core::mem::transmute(pinit.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), pinit.as_deref().map_or(0, |slice| slice.len().try_into().unwrap())) }
}
#[cfg(all(feature = "Win32_Security", feature = "Win32_System_Threading"))]
#[inline]
pub unsafe fn SHCreateProcessAsUserW(pscpi: *mut SHCREATEPROCESSINFOW) -> windows_core::Result<()> {
    windows_core::link!("shell32.dll" "system" fn SHCreateProcessAsUserW(pscpi : *mut SHCREATEPROCESSINFOW) -> windows_core::BOOL);
    unsafe { SHCreateProcessAsUserW(pscpi as _).ok() }
}
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn SHCreatePropSheetExtArray<P1>(hkey: super::super::System::Registry::HKEY, pszsubkey: P1, max_iface: u32) -> HPSXA
where
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shell32.dll" "system" fn SHCreatePropSheetExtArray(hkey : super::super::System::Registry:: HKEY, pszsubkey : windows_core::PCWSTR, max_iface : u32) -> HPSXA);
    unsafe { SHCreatePropSheetExtArray(hkey, pszsubkey.param().abi(), max_iface) }
}
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn SHCreateQueryCancelAutoPlayMoniker() -> windows_core::Result<super::super::System::Com::IMoniker> {
    windows_core::link!("shell32.dll" "system" fn SHCreateQueryCancelAutoPlayMoniker(ppmoniker : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        SHCreateQueryCancelAutoPlayMoniker(&mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[cfg(feature = "Win32_System_Ole")]
#[inline]
pub unsafe fn SHCreateShellFolderView(pcsfv: *const SFV_CREATE) -> windows_core::Result<IShellView> {
    windows_core::link!("shell32.dll" "system" fn SHCreateShellFolderView(pcsfv : *const SFV_CREATE, ppsv : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        SHCreateShellFolderView(core::mem::transmute(pcsfv), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[cfg(all(feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
#[inline]
pub unsafe fn SHCreateShellFolderViewEx(pcsfv: *const CSFV) -> windows_core::Result<IShellView> {
    windows_core::link!("shell32.dll" "system" fn SHCreateShellFolderViewEx(pcsfv : *const CSFV, ppsv : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        SHCreateShellFolderViewEx(core::mem::transmute(pcsfv), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn SHCreateShellItem<P1>(pidlparent: Option<*const Common::ITEMIDLIST>, psfparent: P1, pidl: *const Common::ITEMIDLIST) -> windows_core::Result<IShellItem>
where
    P1: windows_core::Param<IShellFolder>,
{
    windows_core::link!("shell32.dll" "system" fn SHCreateShellItem(pidlparent : *const Common:: ITEMIDLIST, psfparent : * mut core::ffi::c_void, pidl : *const Common:: ITEMIDLIST, ppsi : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        SHCreateShellItem(pidlparent.unwrap_or(core::mem::zeroed()) as _, psfparent.param().abi(), pidl, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn SHCreateShellItemArray<P1>(pidlparent: Option<*const Common::ITEMIDLIST>, psf: P1, ppidl: Option<&[*const Common::ITEMIDLIST]>) -> windows_core::Result<IShellItemArray>
where
    P1: windows_core::Param<IShellFolder>,
{
    windows_core::link!("shell32.dll" "system" fn SHCreateShellItemArray(pidlparent : *const Common:: ITEMIDLIST, psf : * mut core::ffi::c_void, cidl : u32, ppidl : *const *const Common:: ITEMIDLIST, ppsiitemarray : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        SHCreateShellItemArray(pidlparent.unwrap_or(core::mem::zeroed()) as _, psf.param().abi(), ppidl.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(ppidl.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn SHCreateShellItemArrayFromDataObject<P0, T>(pdo: P0) -> windows_core::Result<T>
where
    P0: windows_core::Param<super::super::System::Com::IDataObject>,
    T: windows_core::Interface,
{
    windows_core::link!("shell32.dll" "system" fn SHCreateShellItemArrayFromDataObject(pdo : * mut core::ffi::c_void, riid : *const windows_core::GUID, ppv : *mut *mut core::ffi::c_void) -> windows_core::HRESULT);
    let mut result__ = core::ptr::null_mut();
    unsafe { SHCreateShellItemArrayFromDataObject(pdo.param().abi(), &T::IID, &mut result__).and_then(|| windows_core::Type::from_abi(result__)) }
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn SHCreateShellItemArrayFromIDLists(rgpidl: &[*const Common::ITEMIDLIST]) -> windows_core::Result<IShellItemArray> {
    windows_core::link!("shell32.dll" "system" fn SHCreateShellItemArrayFromIDLists(cidl : u32, rgpidl : *const *const Common:: ITEMIDLIST, ppsiitemarray : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        SHCreateShellItemArrayFromIDLists(rgpidl.len().try_into().unwrap(), core::mem::transmute(rgpidl.as_ptr()), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn SHCreateShellItemArrayFromShellItem<P0, T>(psi: P0) -> windows_core::Result<T>
where
    P0: windows_core::Param<IShellItem>,
    T: windows_core::Interface,
{
    windows_core::link!("shell32.dll" "system" fn SHCreateShellItemArrayFromShellItem(psi : * mut core::ffi::c_void, riid : *const windows_core::GUID, ppv : *mut *mut core::ffi::c_void) -> windows_core::HRESULT);
    let mut result__ = core::ptr::null_mut();
    unsafe { SHCreateShellItemArrayFromShellItem(psi.param().abi(), &T::IID, &mut result__).and_then(|| windows_core::Type::from_abi(result__)) }
}
#[cfg(feature = "Win32_Graphics_Gdi")]
#[inline]
pub unsafe fn SHCreateShellPalette(hdc: Option<super::super::Graphics::Gdi::HDC>) -> super::super::Graphics::Gdi::HPALETTE {
    windows_core::link!("shlwapi.dll" "system" fn SHCreateShellPalette(hdc : super::super::Graphics::Gdi:: HDC) -> super::super::Graphics::Gdi:: HPALETTE);
    unsafe { SHCreateShellPalette(hdc.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn SHCreateStdEnumFmtEtc(afmt: &[super::super::System::Com::FORMATETC]) -> windows_core::Result<super::super::System::Com::IEnumFORMATETC> {
    windows_core::link!("shell32.dll" "system" fn SHCreateStdEnumFmtEtc(cfmt : u32, afmt : *const super::super::System::Com:: FORMATETC, ppenumformatetc : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        SHCreateStdEnumFmtEtc(afmt.len().try_into().unwrap(), core::mem::transmute(afmt.as_ptr()), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn SHCreateStreamOnFileA<P0>(pszfile: P0, grfmode: u32) -> windows_core::Result<super::super::System::Com::IStream>
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn SHCreateStreamOnFileA(pszfile : windows_core::PCSTR, grfmode : u32, ppstm : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        SHCreateStreamOnFileA(pszfile.param().abi(), grfmode, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn SHCreateStreamOnFileEx<P0, P4>(pszfile: P0, grfmode: u32, dwattributes: u32, fcreate: bool, pstmtemplate: P4) -> windows_core::Result<super::super::System::Com::IStream>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P4: windows_core::Param<super::super::System::Com::IStream>,
{
    windows_core::link!("shlwapi.dll" "system" fn SHCreateStreamOnFileEx(pszfile : windows_core::PCWSTR, grfmode : u32, dwattributes : u32, fcreate : windows_core::BOOL, pstmtemplate : * mut core::ffi::c_void, ppstm : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        SHCreateStreamOnFileEx(pszfile.param().abi(), grfmode, dwattributes, fcreate.into(), pstmtemplate.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn SHCreateStreamOnFileW<P0>(pszfile: P0, grfmode: u32) -> windows_core::Result<super::super::System::Com::IStream>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn SHCreateStreamOnFileW(pszfile : windows_core::PCWSTR, grfmode : u32, ppstm : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        SHCreateStreamOnFileW(pszfile.param().abi(), grfmode, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[cfg(feature = "Win32_System_Threading")]
#[inline]
pub unsafe fn SHCreateThread(pfnthreadproc: super::super::System::Threading::LPTHREAD_START_ROUTINE, pdata: Option<*const core::ffi::c_void>, flags: u32, pfncallback: super::super::System::Threading::LPTHREAD_START_ROUTINE) -> windows_core::Result<()> {
    windows_core::link!("shlwapi.dll" "system" fn SHCreateThread(pfnthreadproc : super::super::System::Threading:: LPTHREAD_START_ROUTINE, pdata : *const core::ffi::c_void, flags : u32, pfncallback : super::super::System::Threading:: LPTHREAD_START_ROUTINE) -> windows_core::BOOL);
    unsafe { SHCreateThread(pfnthreadproc, pdata.unwrap_or(core::mem::zeroed()) as _, flags, pfncallback).ok() }
}
#[inline]
pub unsafe fn SHCreateThreadRef(pcref: *mut i32, ppunk: *mut Option<windows_core::IUnknown>) -> windows_core::Result<()> {
    windows_core::link!("shlwapi.dll" "system" fn SHCreateThreadRef(pcref : *mut i32, ppunk : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe { SHCreateThreadRef(pcref as _, core::mem::transmute(ppunk)).ok() }
}
#[cfg(feature = "Win32_System_Threading")]
#[inline]
pub unsafe fn SHCreateThreadWithHandle(pfnthreadproc: super::super::System::Threading::LPTHREAD_START_ROUTINE, pdata: Option<*const core::ffi::c_void>, flags: u32, pfncallback: super::super::System::Threading::LPTHREAD_START_ROUTINE, phandle: Option<*mut super::super::Foundation::HANDLE>) -> windows_core::Result<()> {
    windows_core::link!("shlwapi.dll" "system" fn SHCreateThreadWithHandle(pfnthreadproc : super::super::System::Threading:: LPTHREAD_START_ROUTINE, pdata : *const core::ffi::c_void, flags : u32, pfncallback : super::super::System::Threading:: LPTHREAD_START_ROUTINE, phandle : *mut super::super::Foundation:: HANDLE) -> windows_core::BOOL);
    unsafe { SHCreateThreadWithHandle(pfnthreadproc, pdata.unwrap_or(core::mem::zeroed()) as _, flags, pfncallback, phandle.unwrap_or(core::mem::zeroed()) as _).ok() }
}
#[cfg(feature = "Win32_UI_WindowsAndMessaging")]
#[inline]
pub unsafe fn SHDefExtractIconA<P0>(psziconfile: P0, iindex: i32, uflags: u32, phiconlarge: Option<*mut super::WindowsAndMessaging::HICON>, phiconsmall: Option<*mut super::WindowsAndMessaging::HICON>, niconsize: u32) -> windows_core::HRESULT
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shell32.dll" "system" fn SHDefExtractIconA(psziconfile : windows_core::PCSTR, iindex : i32, uflags : u32, phiconlarge : *mut super::WindowsAndMessaging:: HICON, phiconsmall : *mut super::WindowsAndMessaging:: HICON, niconsize : u32) -> windows_core::HRESULT);
    unsafe { SHDefExtractIconA(psziconfile.param().abi(), iindex, uflags, phiconlarge.unwrap_or(core::mem::zeroed()) as _, phiconsmall.unwrap_or(core::mem::zeroed()) as _, niconsize) }
}
#[cfg(feature = "Win32_UI_WindowsAndMessaging")]
#[inline]
pub unsafe fn SHDefExtractIconW<P0>(psziconfile: P0, iindex: i32, uflags: u32, phiconlarge: Option<*mut super::WindowsAndMessaging::HICON>, phiconsmall: Option<*mut super::WindowsAndMessaging::HICON>, niconsize: u32) -> windows_core::HRESULT
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shell32.dll" "system" fn SHDefExtractIconW(psziconfile : windows_core::PCWSTR, iindex : i32, uflags : u32, phiconlarge : *mut super::WindowsAndMessaging:: HICON, phiconsmall : *mut super::WindowsAndMessaging:: HICON, niconsize : u32) -> windows_core::HRESULT);
    unsafe { SHDefExtractIconW(psziconfile.param().abi(), iindex, uflags, phiconlarge.unwrap_or(core::mem::zeroed()) as _, phiconsmall.unwrap_or(core::mem::zeroed()) as _, niconsize) }
}
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn SHDeleteEmptyKeyA<P1>(hkey: super::super::System::Registry::HKEY, pszsubkey: P1) -> super::super::Foundation::WIN32_ERROR
where
    P1: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn SHDeleteEmptyKeyA(hkey : super::super::System::Registry:: HKEY, pszsubkey : windows_core::PCSTR) -> super::super::Foundation:: WIN32_ERROR);
    unsafe { SHDeleteEmptyKeyA(hkey, pszsubkey.param().abi()) }
}
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn SHDeleteEmptyKeyW<P1>(hkey: super::super::System::Registry::HKEY, pszsubkey: P1) -> super::super::Foundation::WIN32_ERROR
where
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn SHDeleteEmptyKeyW(hkey : super::super::System::Registry:: HKEY, pszsubkey : windows_core::PCWSTR) -> super::super::Foundation:: WIN32_ERROR);
    unsafe { SHDeleteEmptyKeyW(hkey, pszsubkey.param().abi()) }
}
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn SHDeleteKeyA<P1>(hkey: super::super::System::Registry::HKEY, pszsubkey: P1) -> super::super::Foundation::WIN32_ERROR
where
    P1: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn SHDeleteKeyA(hkey : super::super::System::Registry:: HKEY, pszsubkey : windows_core::PCSTR) -> super::super::Foundation:: WIN32_ERROR);
    unsafe { SHDeleteKeyA(hkey, pszsubkey.param().abi()) }
}
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn SHDeleteKeyW<P1>(hkey: super::super::System::Registry::HKEY, pszsubkey: P1) -> super::super::Foundation::WIN32_ERROR
where
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn SHDeleteKeyW(hkey : super::super::System::Registry:: HKEY, pszsubkey : windows_core::PCWSTR) -> super::super::Foundation:: WIN32_ERROR);
    unsafe { SHDeleteKeyW(hkey, pszsubkey.param().abi()) }
}
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn SHDeleteValueA<P1, P2>(hkey: super::super::System::Registry::HKEY, pszsubkey: P1, pszvalue: P2) -> super::super::Foundation::WIN32_ERROR
where
    P1: windows_core::Param<windows_core::PCSTR>,
    P2: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn SHDeleteValueA(hkey : super::super::System::Registry:: HKEY, pszsubkey : windows_core::PCSTR, pszvalue : windows_core::PCSTR) -> super::super::Foundation:: WIN32_ERROR);
    unsafe { SHDeleteValueA(hkey, pszsubkey.param().abi(), pszvalue.param().abi()) }
}
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn SHDeleteValueW<P1, P2>(hkey: super::super::System::Registry::HKEY, pszsubkey: P1, pszvalue: P2) -> super::super::Foundation::WIN32_ERROR
where
    P1: windows_core::Param<windows_core::PCWSTR>,
    P2: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn SHDeleteValueW(hkey : super::super::System::Registry:: HKEY, pszsubkey : windows_core::PCWSTR, pszvalue : windows_core::PCWSTR) -> super::super::Foundation:: WIN32_ERROR);
    unsafe { SHDeleteValueW(hkey, pszsubkey.param().abi(), pszvalue.param().abi()) }
}
#[inline]
pub unsafe fn SHDestroyPropSheetExtArray(hpsxa: HPSXA) {
    windows_core::link!("shell32.dll" "system" fn SHDestroyPropSheetExtArray(hpsxa : HPSXA));
    unsafe { SHDestroyPropSheetExtArray(hpsxa) }
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
#[inline]
pub unsafe fn SHDoDragDrop<P1, P2>(hwnd: Option<super::super::Foundation::HWND>, pdata: P1, pdsrc: P2, dweffect: super::super::System::Ole::DROPEFFECT) -> windows_core::Result<super::super::System::Ole::DROPEFFECT>
where
    P1: windows_core::Param<super::super::System::Com::IDataObject>,
    P2: windows_core::Param<super::super::System::Ole::IDropSource>,
{
    windows_core::link!("shell32.dll" "system" fn SHDoDragDrop(hwnd : super::super::Foundation:: HWND, pdata : * mut core::ffi::c_void, pdsrc : * mut core::ffi::c_void, dweffect : super::super::System::Ole:: DROPEFFECT, pdweffect : *mut super::super::System::Ole:: DROPEFFECT) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        SHDoDragDrop(hwnd.unwrap_or(core::mem::zeroed()) as _, pdata.param().abi(), pdsrc.param().abi(), dweffect, &mut result__).map(|| result__)
    }
}
#[inline]
pub unsafe fn SHEmptyRecycleBinA<P1>(hwnd: Option<super::super::Foundation::HWND>, pszrootpath: P1, dwflags: u32) -> windows_core::Result<()>
where
    P1: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shell32.dll" "system" fn SHEmptyRecycleBinA(hwnd : super::super::Foundation:: HWND, pszrootpath : windows_core::PCSTR, dwflags : u32) -> windows_core::HRESULT);
    unsafe { SHEmptyRecycleBinA(hwnd.unwrap_or(core::mem::zeroed()) as _, pszrootpath.param().abi(), dwflags).ok() }
}
#[inline]
pub unsafe fn SHEmptyRecycleBinW<P1>(hwnd: Option<super::super::Foundation::HWND>, pszrootpath: P1, dwflags: u32) -> windows_core::Result<()>
where
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shell32.dll" "system" fn SHEmptyRecycleBinW(hwnd : super::super::Foundation:: HWND, pszrootpath : windows_core::PCWSTR, dwflags : u32) -> windows_core::HRESULT);
    unsafe { SHEmptyRecycleBinW(hwnd.unwrap_or(core::mem::zeroed()) as _, pszrootpath.param().abi(), dwflags).ok() }
}
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn SHEnumKeyExA(hkey: super::super::System::Registry::HKEY, dwindex: u32, pszname: windows_core::PSTR, pcchname: *mut u32) -> super::super::Foundation::WIN32_ERROR {
    windows_core::link!("shlwapi.dll" "system" fn SHEnumKeyExA(hkey : super::super::System::Registry:: HKEY, dwindex : u32, pszname : windows_core::PSTR, pcchname : *mut u32) -> super::super::Foundation:: WIN32_ERROR);
    unsafe { SHEnumKeyExA(hkey, dwindex, core::mem::transmute(pszname), pcchname as _) }
}
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn SHEnumKeyExW(hkey: super::super::System::Registry::HKEY, dwindex: u32, pszname: windows_core::PWSTR, pcchname: *mut u32) -> super::super::Foundation::WIN32_ERROR {
    windows_core::link!("shlwapi.dll" "system" fn SHEnumKeyExW(hkey : super::super::System::Registry:: HKEY, dwindex : u32, pszname : windows_core::PWSTR, pcchname : *mut u32) -> super::super::Foundation:: WIN32_ERROR);
    unsafe { SHEnumKeyExW(hkey, dwindex, core::mem::transmute(pszname), pcchname as _) }
}
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn SHEnumValueA(hkey: super::super::System::Registry::HKEY, dwindex: u32, pszvaluename: Option<windows_core::PSTR>, pcchvaluename: Option<*mut u32>, pdwtype: Option<*mut u32>, pvdata: Option<*mut core::ffi::c_void>, pcbdata: Option<*mut u32>) -> super::super::Foundation::WIN32_ERROR {
    windows_core::link!("shlwapi.dll" "system" fn SHEnumValueA(hkey : super::super::System::Registry:: HKEY, dwindex : u32, pszvaluename : windows_core::PSTR, pcchvaluename : *mut u32, pdwtype : *mut u32, pvdata : *mut core::ffi::c_void, pcbdata : *mut u32) -> super::super::Foundation:: WIN32_ERROR);
    unsafe { SHEnumValueA(hkey, dwindex, pszvaluename.unwrap_or(core::mem::zeroed()) as _, pcchvaluename.unwrap_or(core::mem::zeroed()) as _, pdwtype.unwrap_or(core::mem::zeroed()) as _, pvdata.unwrap_or(core::mem::zeroed()) as _, pcbdata.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn SHEnumValueW(hkey: super::super::System::Registry::HKEY, dwindex: u32, pszvaluename: Option<windows_core::PWSTR>, pcchvaluename: Option<*mut u32>, pdwtype: Option<*mut u32>, pvdata: Option<*mut core::ffi::c_void>, pcbdata: Option<*mut u32>) -> super::super::Foundation::WIN32_ERROR {
    windows_core::link!("shlwapi.dll" "system" fn SHEnumValueW(hkey : super::super::System::Registry:: HKEY, dwindex : u32, pszvaluename : windows_core::PWSTR, pcchvaluename : *mut u32, pdwtype : *mut u32, pvdata : *mut core::ffi::c_void, pcbdata : *mut u32) -> super::super::Foundation:: WIN32_ERROR);
    unsafe { SHEnumValueW(hkey, dwindex, pszvaluename.unwrap_or(core::mem::zeroed()) as _, pcchvaluename.unwrap_or(core::mem::zeroed()) as _, pdwtype.unwrap_or(core::mem::zeroed()) as _, pvdata.unwrap_or(core::mem::zeroed()) as _, pcbdata.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn SHEnumerateUnreadMailAccountsW(hkeyuser: Option<super::super::System::Registry::HKEY>, dwindex: u32, pszmailaddress: &mut [u16]) -> windows_core::Result<()> {
    windows_core::link!("shell32.dll" "system" fn SHEnumerateUnreadMailAccountsW(hkeyuser : super::super::System::Registry:: HKEY, dwindex : u32, pszmailaddress : windows_core::PWSTR, cchmailaddress : i32) -> windows_core::HRESULT);
    unsafe { SHEnumerateUnreadMailAccountsW(hkeyuser.unwrap_or(core::mem::zeroed()) as _, dwindex, core::mem::transmute(pszmailaddress.as_ptr()), pszmailaddress.len().try_into().unwrap()).ok() }
}
#[inline]
pub unsafe fn SHEvaluateSystemCommandTemplate<P0>(pszcmdtemplate: P0, ppszapplication: *mut windows_core::PWSTR, ppszcommandline: Option<*mut windows_core::PWSTR>, ppszparameters: Option<*mut windows_core::PWSTR>) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shell32.dll" "system" fn SHEvaluateSystemCommandTemplate(pszcmdtemplate : windows_core::PCWSTR, ppszapplication : *mut windows_core::PWSTR, ppszcommandline : *mut windows_core::PWSTR, ppszparameters : *mut windows_core::PWSTR) -> windows_core::HRESULT);
    unsafe { SHEvaluateSystemCommandTemplate(pszcmdtemplate.param().abi(), ppszapplication as _, ppszcommandline.unwrap_or(core::mem::zeroed()) as _, ppszparameters.unwrap_or(core::mem::zeroed()) as _).ok() }
}
#[inline]
pub unsafe fn SHFileOperationA(lpfileop: *mut SHFILEOPSTRUCTA) -> i32 {
    windows_core::link!("shell32.dll" "system" fn SHFileOperationA(lpfileop : *mut SHFILEOPSTRUCTA) -> i32);
    unsafe { SHFileOperationA(lpfileop as _) }
}
#[inline]
pub unsafe fn SHFileOperationW(lpfileop: *mut SHFILEOPSTRUCTW) -> i32 {
    windows_core::link!("shell32.dll" "system" fn SHFileOperationW(lpfileop : *mut SHFILEOPSTRUCTW) -> i32);
    unsafe { SHFileOperationW(lpfileop as _) }
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn SHFindFiles(pidlfolder: Option<*const Common::ITEMIDLIST>, pidlsavefile: Option<*const Common::ITEMIDLIST>) -> windows_core::BOOL {
    windows_core::link!("shell32.dll" "system" fn SHFindFiles(pidlfolder : *const Common:: ITEMIDLIST, pidlsavefile : *const Common:: ITEMIDLIST) -> windows_core::BOOL);
    unsafe { SHFindFiles(pidlfolder.unwrap_or(core::mem::zeroed()) as _, pidlsavefile.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(feature = "Win32_UI_WindowsAndMessaging")]
#[inline]
pub unsafe fn SHFind_InitMenuPopup(hmenu: super::WindowsAndMessaging::HMENU, hwndowner: Option<super::super::Foundation::HWND>, idcmdfirst: u32, idcmdlast: u32) -> Option<IContextMenu> {
    windows_core::link!("shell32.dll" "system" fn SHFind_InitMenuPopup(hmenu : super::WindowsAndMessaging:: HMENU, hwndowner : super::super::Foundation:: HWND, idcmdfirst : u32, idcmdlast : u32) -> Option < IContextMenu >);
    unsafe { SHFind_InitMenuPopup(hmenu, hwndowner.unwrap_or(core::mem::zeroed()) as _, idcmdfirst, idcmdlast) }
}
#[inline]
pub unsafe fn SHFlushSFCache() {
    windows_core::link!("shell32.dll" "system" fn SHFlushSFCache());
    unsafe { SHFlushSFCache() }
}
#[inline]
pub unsafe fn SHFormatDateTimeA(pft: *const super::super::Foundation::FILETIME, pdwflags: Option<*mut u32>, pszbuf: &mut [u8]) -> i32 {
    windows_core::link!("shlwapi.dll" "system" fn SHFormatDateTimeA(pft : *const super::super::Foundation:: FILETIME, pdwflags : *mut u32, pszbuf : windows_core::PSTR, cchbuf : u32) -> i32);
    unsafe { SHFormatDateTimeA(pft, pdwflags.unwrap_or(core::mem::zeroed()) as _, core::mem::transmute(pszbuf.as_ptr()), pszbuf.len().try_into().unwrap()) }
}
#[inline]
pub unsafe fn SHFormatDateTimeW(pft: *const super::super::Foundation::FILETIME, pdwflags: Option<*mut u32>, pszbuf: &mut [u16]) -> i32 {
    windows_core::link!("shlwapi.dll" "system" fn SHFormatDateTimeW(pft : *const super::super::Foundation:: FILETIME, pdwflags : *mut u32, pszbuf : windows_core::PWSTR, cchbuf : u32) -> i32);
    unsafe { SHFormatDateTimeW(pft, pdwflags.unwrap_or(core::mem::zeroed()) as _, core::mem::transmute(pszbuf.as_ptr()), pszbuf.len().try_into().unwrap()) }
}
#[inline]
pub unsafe fn SHFormatDrive(hwnd: super::super::Foundation::HWND, drive: u32, fmtid: SHFMT_ID, options: SHFMT_OPT) -> u32 {
    windows_core::link!("shell32.dll" "system" fn SHFormatDrive(hwnd : super::super::Foundation:: HWND, drive : u32, fmtid : SHFMT_ID, options : u32) -> u32);
    unsafe { SHFormatDrive(hwnd, drive, fmtid, options.0 as _) }
}
#[inline]
pub unsafe fn SHFree(pv: Option<*const core::ffi::c_void>) {
    windows_core::link!("shell32.dll" "system" fn SHFree(pv : *const core::ffi::c_void));
    unsafe { SHFree(pv.unwrap_or(core::mem::zeroed()) as _) }
}
#[inline]
pub unsafe fn SHFreeNameMappings(hnamemappings: Option<super::super::Foundation::HANDLE>) {
    windows_core::link!("shell32.dll" "system" fn SHFreeNameMappings(hnamemappings : super::super::Foundation:: HANDLE));
    unsafe { SHFreeNameMappings(hnamemappings.unwrap_or(core::mem::zeroed()) as _) }
}
#[inline]
pub unsafe fn SHFreeShared(hdata: super::super::Foundation::HANDLE, dwprocessid: u32) -> windows_core::Result<()> {
    windows_core::link!("shlwapi.dll" "system" fn SHFreeShared(hdata : super::super::Foundation:: HANDLE, dwprocessid : u32) -> windows_core::BOOL);
    unsafe { SHFreeShared(hdata, dwprocessid).ok() }
}
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn SHGetAttributesFromDataObject<P0>(pdo: P0, dwattributemask: u32, pdwattributes: Option<*mut u32>, pcitems: Option<*mut u32>) -> windows_core::HRESULT
where
    P0: windows_core::Param<super::super::System::Com::IDataObject>,
{
    windows_core::link!("shell32.dll" "system" fn SHGetAttributesFromDataObject(pdo : * mut core::ffi::c_void, dwattributemask : u32, pdwattributes : *mut u32, pcitems : *mut u32) -> windows_core::HRESULT);
    unsafe { SHGetAttributesFromDataObject(pdo.param().abi(), dwattributemask, pdwattributes.unwrap_or(core::mem::zeroed()) as _, pcitems.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn SHGetDataFromIDListA<P0>(psf: P0, pidl: *const Common::ITEMIDLIST, nformat: SHGDFIL_FORMAT, pv: *mut core::ffi::c_void, cb: i32) -> windows_core::Result<()>
where
    P0: windows_core::Param<IShellFolder>,
{
    windows_core::link!("shell32.dll" "system" fn SHGetDataFromIDListA(psf : * mut core::ffi::c_void, pidl : *const Common:: ITEMIDLIST, nformat : SHGDFIL_FORMAT, pv : *mut core::ffi::c_void, cb : i32) -> windows_core::HRESULT);
    unsafe { SHGetDataFromIDListA(psf.param().abi(), pidl, nformat, pv as _, cb).ok() }
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn SHGetDataFromIDListW<P0>(psf: P0, pidl: *const Common::ITEMIDLIST, nformat: SHGDFIL_FORMAT, pv: *mut core::ffi::c_void, cb: i32) -> windows_core::Result<()>
where
    P0: windows_core::Param<IShellFolder>,
{
    windows_core::link!("shell32.dll" "system" fn SHGetDataFromIDListW(psf : * mut core::ffi::c_void, pidl : *const Common:: ITEMIDLIST, nformat : SHGDFIL_FORMAT, pv : *mut core::ffi::c_void, cb : i32) -> windows_core::HRESULT);
    unsafe { SHGetDataFromIDListW(psf.param().abi(), pidl, nformat, pv as _, cb).ok() }
}
#[inline]
pub unsafe fn SHGetDesktopFolder() -> windows_core::Result<IShellFolder> {
    windows_core::link!("shell32.dll" "system" fn SHGetDesktopFolder(ppshf : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        SHGetDesktopFolder(&mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn SHGetDiskFreeSpaceExA<P0>(pszdirectoryname: P0, pulfreebytesavailabletocaller: Option<*mut u64>, pultotalnumberofbytes: Option<*mut u64>, pultotalnumberoffreebytes: Option<*mut u64>) -> windows_core::BOOL
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shell32.dll" "system" fn SHGetDiskFreeSpaceExA(pszdirectoryname : windows_core::PCSTR, pulfreebytesavailabletocaller : *mut u64, pultotalnumberofbytes : *mut u64, pultotalnumberoffreebytes : *mut u64) -> windows_core::BOOL);
    unsafe { SHGetDiskFreeSpaceExA(pszdirectoryname.param().abi(), pulfreebytesavailabletocaller.unwrap_or(core::mem::zeroed()) as _, pultotalnumberofbytes.unwrap_or(core::mem::zeroed()) as _, pultotalnumberoffreebytes.unwrap_or(core::mem::zeroed()) as _) }
}
#[inline]
pub unsafe fn SHGetDiskFreeSpaceExW<P0>(pszdirectoryname: P0, pulfreebytesavailabletocaller: Option<*mut u64>, pultotalnumberofbytes: Option<*mut u64>, pultotalnumberoffreebytes: Option<*mut u64>) -> windows_core::BOOL
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shell32.dll" "system" fn SHGetDiskFreeSpaceExW(pszdirectoryname : windows_core::PCWSTR, pulfreebytesavailabletocaller : *mut u64, pultotalnumberofbytes : *mut u64, pultotalnumberoffreebytes : *mut u64) -> windows_core::BOOL);
    unsafe { SHGetDiskFreeSpaceExW(pszdirectoryname.param().abi(), pulfreebytesavailabletocaller.unwrap_or(core::mem::zeroed()) as _, pultotalnumberofbytes.unwrap_or(core::mem::zeroed()) as _, pultotalnumberoffreebytes.unwrap_or(core::mem::zeroed()) as _) }
}
#[inline]
pub unsafe fn SHGetDriveMedia<P0>(pszdrive: P0) -> windows_core::Result<u32>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shell32.dll" "system" fn SHGetDriveMedia(pszdrive : windows_core::PCWSTR, pdwmediacontent : *mut u32) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        SHGetDriveMedia(pszdrive.param().abi(), &mut result__).map(|| result__)
    }
}
#[cfg(all(feature = "Win32_Storage_FileSystem", feature = "Win32_UI_WindowsAndMessaging"))]
#[inline]
pub unsafe fn SHGetFileInfoA<P0>(pszpath: P0, dwfileattributes: super::super::Storage::FileSystem::FILE_FLAGS_AND_ATTRIBUTES, psfi: Option<*mut SHFILEINFOA>, cbfileinfo: u32, uflags: SHGFI_FLAGS) -> usize
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shell32.dll" "system" fn SHGetFileInfoA(pszpath : windows_core::PCSTR, dwfileattributes : super::super::Storage::FileSystem:: FILE_FLAGS_AND_ATTRIBUTES, psfi : *mut SHFILEINFOA, cbfileinfo : u32, uflags : SHGFI_FLAGS) -> usize);
    unsafe { SHGetFileInfoA(pszpath.param().abi(), dwfileattributes, psfi.unwrap_or(core::mem::zeroed()) as _, cbfileinfo, uflags) }
}
#[cfg(all(feature = "Win32_Storage_FileSystem", feature = "Win32_UI_WindowsAndMessaging"))]
#[inline]
pub unsafe fn SHGetFileInfoW<P0>(pszpath: P0, dwfileattributes: super::super::Storage::FileSystem::FILE_FLAGS_AND_ATTRIBUTES, psfi: Option<*mut SHFILEINFOW>, cbfileinfo: u32, uflags: SHGFI_FLAGS) -> usize
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shell32.dll" "system" fn SHGetFileInfoW(pszpath : windows_core::PCWSTR, dwfileattributes : super::super::Storage::FileSystem:: FILE_FLAGS_AND_ATTRIBUTES, psfi : *mut SHFILEINFOW, cbfileinfo : u32, uflags : SHGFI_FLAGS) -> usize);
    unsafe { SHGetFileInfoW(pszpath.param().abi(), dwfileattributes, psfi.unwrap_or(core::mem::zeroed()) as _, cbfileinfo, uflags) }
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn SHGetFolderLocation(hwnd: Option<super::super::Foundation::HWND>, csidl: i32, htoken: Option<super::super::Foundation::HANDLE>, dwflags: u32) -> windows_core::Result<*mut Common::ITEMIDLIST> {
    windows_core::link!("shell32.dll" "system" fn SHGetFolderLocation(hwnd : super::super::Foundation:: HWND, csidl : i32, htoken : super::super::Foundation:: HANDLE, dwflags : u32, ppidl : *mut *mut Common:: ITEMIDLIST) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        SHGetFolderLocation(hwnd.unwrap_or(core::mem::zeroed()) as _, csidl, htoken.unwrap_or(core::mem::zeroed()) as _, dwflags, &mut result__).map(|| result__)
    }
}
#[inline]
pub unsafe fn SHGetFolderPathA(hwnd: Option<super::super::Foundation::HWND>, csidl: i32, htoken: Option<super::super::Foundation::HANDLE>, dwflags: u32, pszpath: &mut [u8; 260]) -> windows_core::Result<()> {
    windows_core::link!("shell32.dll" "system" fn SHGetFolderPathA(hwnd : super::super::Foundation:: HWND, csidl : i32, htoken : super::super::Foundation:: HANDLE, dwflags : u32, pszpath : windows_core::PSTR) -> windows_core::HRESULT);
    unsafe { SHGetFolderPathA(hwnd.unwrap_or(core::mem::zeroed()) as _, csidl, htoken.unwrap_or(core::mem::zeroed()) as _, dwflags, core::mem::transmute(pszpath.as_ptr())).ok() }
}
#[inline]
pub unsafe fn SHGetFolderPathAndSubDirA<P4>(hwnd: Option<super::super::Foundation::HWND>, csidl: i32, htoken: Option<super::super::Foundation::HANDLE>, dwflags: u32, pszsubdir: P4, pszpath: &mut [u8; 260]) -> windows_core::Result<()>
where
    P4: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shell32.dll" "system" fn SHGetFolderPathAndSubDirA(hwnd : super::super::Foundation:: HWND, csidl : i32, htoken : super::super::Foundation:: HANDLE, dwflags : u32, pszsubdir : windows_core::PCSTR, pszpath : windows_core::PSTR) -> windows_core::HRESULT);
    unsafe { SHGetFolderPathAndSubDirA(hwnd.unwrap_or(core::mem::zeroed()) as _, csidl, htoken.unwrap_or(core::mem::zeroed()) as _, dwflags, pszsubdir.param().abi(), core::mem::transmute(pszpath.as_ptr())).ok() }
}
#[inline]
pub unsafe fn SHGetFolderPathAndSubDirW<P4>(hwnd: Option<super::super::Foundation::HWND>, csidl: i32, htoken: Option<super::super::Foundation::HANDLE>, dwflags: u32, pszsubdir: P4, pszpath: &mut [u16; 260]) -> windows_core::Result<()>
where
    P4: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shell32.dll" "system" fn SHGetFolderPathAndSubDirW(hwnd : super::super::Foundation:: HWND, csidl : i32, htoken : super::super::Foundation:: HANDLE, dwflags : u32, pszsubdir : windows_core::PCWSTR, pszpath : windows_core::PWSTR) -> windows_core::HRESULT);
    unsafe { SHGetFolderPathAndSubDirW(hwnd.unwrap_or(core::mem::zeroed()) as _, csidl, htoken.unwrap_or(core::mem::zeroed()) as _, dwflags, pszsubdir.param().abi(), core::mem::transmute(pszpath.as_ptr())).ok() }
}
#[inline]
pub unsafe fn SHGetFolderPathW(hwnd: Option<super::super::Foundation::HWND>, csidl: i32, htoken: Option<super::super::Foundation::HANDLE>, dwflags: u32, pszpath: &mut [u16; 260]) -> windows_core::Result<()> {
    windows_core::link!("shell32.dll" "system" fn SHGetFolderPathW(hwnd : super::super::Foundation:: HWND, csidl : i32, htoken : super::super::Foundation:: HANDLE, dwflags : u32, pszpath : windows_core::PWSTR) -> windows_core::HRESULT);
    unsafe { SHGetFolderPathW(hwnd.unwrap_or(core::mem::zeroed()) as _, csidl, htoken.unwrap_or(core::mem::zeroed()) as _, dwflags, core::mem::transmute(pszpath.as_ptr())).ok() }
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn SHGetIDListFromObject<P0>(punk: P0) -> windows_core::Result<*mut Common::ITEMIDLIST>
where
    P0: windows_core::Param<windows_core::IUnknown>,
{
    windows_core::link!("shell32.dll" "system" fn SHGetIDListFromObject(punk : * mut core::ffi::c_void, ppidl : *mut *mut Common:: ITEMIDLIST) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        SHGetIDListFromObject(punk.param().abi(), &mut result__).map(|| result__)
    }
}
#[inline]
pub unsafe fn SHGetIconOverlayIndexA<P0>(psziconpath: P0, iiconindex: i32) -> i32
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shell32.dll" "system" fn SHGetIconOverlayIndexA(psziconpath : windows_core::PCSTR, iiconindex : i32) -> i32);
    unsafe { SHGetIconOverlayIndexA(psziconpath.param().abi(), iiconindex) }
}
#[inline]
pub unsafe fn SHGetIconOverlayIndexW<P0>(psziconpath: P0, iiconindex: i32) -> i32
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shell32.dll" "system" fn SHGetIconOverlayIndexW(psziconpath : windows_core::PCWSTR, iiconindex : i32) -> i32);
    unsafe { SHGetIconOverlayIndexW(psziconpath.param().abi(), iiconindex) }
}
#[inline]
pub unsafe fn SHGetImageList<T>(iimagelist: i32) -> windows_core::Result<T>
where
    T: windows_core::Interface,
{
    windows_core::link!("shell32.dll" "system" fn SHGetImageList(iimagelist : i32, riid : *const windows_core::GUID, ppvobj : *mut *mut core::ffi::c_void) -> windows_core::HRESULT);
    let mut result__ = core::ptr::null_mut();
    unsafe { SHGetImageList(iimagelist, &T::IID, &mut result__).and_then(|| windows_core::Type::from_abi(result__)) }
}
#[inline]
pub unsafe fn SHGetInstanceExplorer() -> windows_core::Result<windows_core::IUnknown> {
    windows_core::link!("shell32.dll" "system" fn SHGetInstanceExplorer(ppunk : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        SHGetInstanceExplorer(&mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn SHGetInverseCMAP(pbmap: &mut [u8]) -> windows_core::Result<()> {
    windows_core::link!("shlwapi.dll" "system" fn SHGetInverseCMAP(pbmap : *mut u8, cbmap : u32) -> windows_core::HRESULT);
    unsafe { SHGetInverseCMAP(core::mem::transmute(pbmap.as_ptr()), pbmap.len().try_into().unwrap()).ok() }
}
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn SHGetItemFromDataObject<P0, T>(pdtobj: P0, dwflags: DATAOBJ_GET_ITEM_FLAGS) -> windows_core::Result<T>
where
    P0: windows_core::Param<super::super::System::Com::IDataObject>,
    T: windows_core::Interface,
{
    windows_core::link!("shell32.dll" "system" fn SHGetItemFromDataObject(pdtobj : * mut core::ffi::c_void, dwflags : DATAOBJ_GET_ITEM_FLAGS, riid : *const windows_core::GUID, ppv : *mut *mut core::ffi::c_void) -> windows_core::HRESULT);
    let mut result__ = core::ptr::null_mut();
    unsafe { SHGetItemFromDataObject(pdtobj.param().abi(), dwflags, &T::IID, &mut result__).and_then(|| windows_core::Type::from_abi(result__)) }
}
#[inline]
pub unsafe fn SHGetItemFromObject<P0, T>(punk: P0) -> windows_core::Result<T>
where
    P0: windows_core::Param<windows_core::IUnknown>,
    T: windows_core::Interface,
{
    windows_core::link!("shell32.dll" "system" fn SHGetItemFromObject(punk : * mut core::ffi::c_void, riid : *const windows_core::GUID, ppv : *mut *mut core::ffi::c_void) -> windows_core::HRESULT);
    let mut result__ = core::ptr::null_mut();
    unsafe { SHGetItemFromObject(punk.param().abi(), &T::IID, &mut result__).and_then(|| windows_core::Type::from_abi(result__)) }
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn SHGetKnownFolderIDList(rfid: *const windows_core::GUID, dwflags: u32, htoken: Option<super::super::Foundation::HANDLE>) -> windows_core::Result<*mut Common::ITEMIDLIST> {
    windows_core::link!("shell32.dll" "system" fn SHGetKnownFolderIDList(rfid : *const windows_core::GUID, dwflags : u32, htoken : super::super::Foundation:: HANDLE, ppidl : *mut *mut Common:: ITEMIDLIST) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        SHGetKnownFolderIDList(rfid, dwflags, htoken.unwrap_or(core::mem::zeroed()) as _, &mut result__).map(|| result__)
    }
}
#[inline]
pub unsafe fn SHGetKnownFolderItem<T>(rfid: *const windows_core::GUID, flags: KNOWN_FOLDER_FLAG, htoken: Option<super::super::Foundation::HANDLE>) -> windows_core::Result<T>
where
    T: windows_core::Interface,
{
    windows_core::link!("shell32.dll" "system" fn SHGetKnownFolderItem(rfid : *const windows_core::GUID, flags : KNOWN_FOLDER_FLAG, htoken : super::super::Foundation:: HANDLE, riid : *const windows_core::GUID, ppv : *mut *mut core::ffi::c_void) -> windows_core::HRESULT);
    let mut result__ = core::ptr::null_mut();
    unsafe { SHGetKnownFolderItem(rfid, flags, htoken.unwrap_or(core::mem::zeroed()) as _, &T::IID, &mut result__).and_then(|| windows_core::Type::from_abi(result__)) }
}
#[inline]
pub unsafe fn SHGetKnownFolderPath(rfid: *const windows_core::GUID, dwflags: KNOWN_FOLDER_FLAG, htoken: Option<super::super::Foundation::HANDLE>) -> windows_core::Result<windows_core::PWSTR> {
    windows_core::link!("shell32.dll" "system" fn SHGetKnownFolderPath(rfid : *const windows_core::GUID, dwflags : u32, htoken : super::super::Foundation:: HANDLE, ppszpath : *mut windows_core::PWSTR) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        SHGetKnownFolderPath(rfid, dwflags.0 as _, htoken.unwrap_or(core::mem::zeroed()) as _, &mut result__).map(|| result__)
    }
}
#[inline]
pub unsafe fn SHGetLocalizedName<P0>(pszpath: P0, pszresmodule: &mut [u16], pidsres: *mut i32) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shell32.dll" "system" fn SHGetLocalizedName(pszpath : windows_core::PCWSTR, pszresmodule : windows_core::PWSTR, cch : u32, pidsres : *mut i32) -> windows_core::HRESULT);
    unsafe { SHGetLocalizedName(pszpath.param().abi(), core::mem::transmute(pszresmodule.as_ptr()), pszresmodule.len().try_into().unwrap(), pidsres as _).ok() }
}
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn SHGetMalloc() -> windows_core::Result<super::super::System::Com::IMalloc> {
    windows_core::link!("shell32.dll" "system" fn SHGetMalloc(ppmalloc : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        SHGetMalloc(&mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn SHGetNameFromIDList(pidl: *const Common::ITEMIDLIST, sigdnname: SIGDN) -> windows_core::Result<windows_core::PWSTR> {
    windows_core::link!("shell32.dll" "system" fn SHGetNameFromIDList(pidl : *const Common:: ITEMIDLIST, sigdnname : SIGDN, ppszname : *mut windows_core::PWSTR) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        SHGetNameFromIDList(pidl, sigdnname, &mut result__).map(|| result__)
    }
}
#[inline]
pub unsafe fn SHGetNewLinkInfoA<P0, P1>(pszlinkto: P0, pszdir: P1, pszname: &mut [u8; 260], pfmustcopy: *mut windows_core::BOOL, uflags: u32) -> windows_core::BOOL
where
    P0: windows_core::Param<windows_core::PCSTR>,
    P1: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shell32.dll" "system" fn SHGetNewLinkInfoA(pszlinkto : windows_core::PCSTR, pszdir : windows_core::PCSTR, pszname : windows_core::PSTR, pfmustcopy : *mut windows_core::BOOL, uflags : u32) -> windows_core::BOOL);
    unsafe { SHGetNewLinkInfoA(pszlinkto.param().abi(), pszdir.param().abi(), core::mem::transmute(pszname.as_ptr()), pfmustcopy as _, uflags) }
}
#[inline]
pub unsafe fn SHGetNewLinkInfoW<P0, P1>(pszlinkto: P0, pszdir: P1, pszname: &mut [u16; 260], pfmustcopy: *mut windows_core::BOOL, uflags: u32) -> windows_core::BOOL
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shell32.dll" "system" fn SHGetNewLinkInfoW(pszlinkto : windows_core::PCWSTR, pszdir : windows_core::PCWSTR, pszname : windows_core::PWSTR, pfmustcopy : *mut windows_core::BOOL, uflags : u32) -> windows_core::BOOL);
    unsafe { SHGetNewLinkInfoW(pszlinkto.param().abi(), pszdir.param().abi(), core::mem::transmute(pszname.as_ptr()), pfmustcopy as _, uflags) }
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn SHGetPathFromIDListA(pidl: *const Common::ITEMIDLIST, pszpath: &mut [u8; 260]) -> windows_core::BOOL {
    windows_core::link!("shell32.dll" "system" fn SHGetPathFromIDListA(pidl : *const Common:: ITEMIDLIST, pszpath : windows_core::PSTR) -> windows_core::BOOL);
    unsafe { SHGetPathFromIDListA(pidl, core::mem::transmute(pszpath.as_ptr())) }
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn SHGetPathFromIDListEx(pidl: *const Common::ITEMIDLIST, pszpath: &mut [u16], uopts: GPFIDL_FLAGS) -> windows_core::BOOL {
    windows_core::link!("shell32.dll" "system" fn SHGetPathFromIDListEx(pidl : *const Common:: ITEMIDLIST, pszpath : windows_core::PWSTR, cchpath : u32, uopts : GPFIDL_FLAGS) -> windows_core::BOOL);
    unsafe { SHGetPathFromIDListEx(pidl, core::mem::transmute(pszpath.as_ptr()), pszpath.len().try_into().unwrap(), uopts) }
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn SHGetPathFromIDListW(pidl: *const Common::ITEMIDLIST, pszpath: &mut [u16; 260]) -> windows_core::BOOL {
    windows_core::link!("shell32.dll" "system" fn SHGetPathFromIDListW(pidl : *const Common:: ITEMIDLIST, pszpath : windows_core::PWSTR) -> windows_core::BOOL);
    unsafe { SHGetPathFromIDListW(pidl, core::mem::transmute(pszpath.as_ptr())) }
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn SHGetRealIDL<P0>(psf: P0, pidlsimple: *const Common::ITEMIDLIST) -> windows_core::Result<*mut Common::ITEMIDLIST>
where
    P0: windows_core::Param<IShellFolder>,
{
    windows_core::link!("shell32.dll" "system" fn SHGetRealIDL(psf : * mut core::ffi::c_void, pidlsimple : *const Common:: ITEMIDLIST, ppidlreal : *mut *mut Common:: ITEMIDLIST) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        SHGetRealIDL(psf.param().abi(), pidlsimple, &mut result__).map(|| result__)
    }
}
#[inline]
pub unsafe fn SHGetSetFolderCustomSettings<P1>(pfcs: *mut SHFOLDERCUSTOMSETTINGS, pszpath: P1, dwreadwrite: u32) -> windows_core::Result<()>
where
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shell32.dll" "system" fn SHGetSetFolderCustomSettings(pfcs : *mut SHFOLDERCUSTOMSETTINGS, pszpath : windows_core::PCWSTR, dwreadwrite : u32) -> windows_core::HRESULT);
    unsafe { SHGetSetFolderCustomSettings(pfcs as _, pszpath.param().abi(), dwreadwrite).ok() }
}
#[inline]
pub unsafe fn SHGetSetSettings(lpss: Option<*mut SHELLSTATEA>, dwmask: SSF_MASK, bset: bool) {
    windows_core::link!("shell32.dll" "system" fn SHGetSetSettings(lpss : *mut SHELLSTATEA, dwmask : SSF_MASK, bset : windows_core::BOOL));
    unsafe { SHGetSetSettings(lpss.unwrap_or(core::mem::zeroed()) as _, dwmask, bset.into()) }
}
#[inline]
pub unsafe fn SHGetSettings(psfs: *mut SHELLFLAGSTATE, dwmask: u32) {
    windows_core::link!("shell32.dll" "system" fn SHGetSettings(psfs : *mut SHELLFLAGSTATE, dwmask : u32));
    unsafe { SHGetSettings(psfs as _, dwmask) }
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn SHGetSpecialFolderLocation(hwnd: Option<super::super::Foundation::HWND>, csidl: i32) -> windows_core::Result<*mut Common::ITEMIDLIST> {
    windows_core::link!("shell32.dll" "system" fn SHGetSpecialFolderLocation(hwnd : super::super::Foundation:: HWND, csidl : i32, ppidl : *mut *mut Common:: ITEMIDLIST) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        SHGetSpecialFolderLocation(hwnd.unwrap_or(core::mem::zeroed()) as _, csidl, &mut result__).map(|| result__)
    }
}
#[inline]
pub unsafe fn SHGetSpecialFolderPathA(hwnd: Option<super::super::Foundation::HWND>, pszpath: &mut [u8; 260], csidl: i32, fcreate: bool) -> windows_core::BOOL {
    windows_core::link!("shell32.dll" "system" fn SHGetSpecialFolderPathA(hwnd : super::super::Foundation:: HWND, pszpath : windows_core::PSTR, csidl : i32, fcreate : windows_core::BOOL) -> windows_core::BOOL);
    unsafe { SHGetSpecialFolderPathA(hwnd.unwrap_or(core::mem::zeroed()) as _, core::mem::transmute(pszpath.as_ptr()), csidl, fcreate.into()) }
}
#[inline]
pub unsafe fn SHGetSpecialFolderPathW(hwnd: Option<super::super::Foundation::HWND>, pszpath: &mut [u16; 260], csidl: i32, fcreate: bool) -> windows_core::BOOL {
    windows_core::link!("shell32.dll" "system" fn SHGetSpecialFolderPathW(hwnd : super::super::Foundation:: HWND, pszpath : windows_core::PWSTR, csidl : i32, fcreate : windows_core::BOOL) -> windows_core::BOOL);
    unsafe { SHGetSpecialFolderPathW(hwnd.unwrap_or(core::mem::zeroed()) as _, core::mem::transmute(pszpath.as_ptr()), csidl, fcreate.into()) }
}
#[cfg(feature = "Win32_UI_WindowsAndMessaging")]
#[inline]
pub unsafe fn SHGetStockIconInfo(siid: SHSTOCKICONID, uflags: SHGSI_FLAGS, psii: *mut SHSTOCKICONINFO) -> windows_core::Result<()> {
    windows_core::link!("shell32.dll" "system" fn SHGetStockIconInfo(siid : SHSTOCKICONID, uflags : SHGSI_FLAGS, psii : *mut SHSTOCKICONINFO) -> windows_core::HRESULT);
    unsafe { SHGetStockIconInfo(siid, uflags, psii as _).ok() }
}
#[cfg(all(feature = "Win32_System_Com_StructuredStorage", feature = "Win32_System_Variant"))]
#[inline]
pub unsafe fn SHGetTemporaryPropertyForItem<P0>(psi: P0, propkey: *const super::super::Foundation::PROPERTYKEY) -> windows_core::Result<super::super::System::Com::StructuredStorage::PROPVARIANT>
where
    P0: windows_core::Param<IShellItem>,
{
    windows_core::link!("shell32.dll" "system" fn SHGetTemporaryPropertyForItem(psi : * mut core::ffi::c_void, propkey : *const super::super::Foundation:: PROPERTYKEY, ppropvar : *mut super::super::System::Com::StructuredStorage:: PROPVARIANT) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        SHGetTemporaryPropertyForItem(psi.param().abi(), propkey, &mut result__).map(|| core::mem::transmute(result__))
    }
}
#[inline]
pub unsafe fn SHGetThreadRef() -> windows_core::Result<windows_core::IUnknown> {
    windows_core::link!("shlwapi.dll" "system" fn SHGetThreadRef(ppunk : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        SHGetThreadRef(&mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn SHGetUnreadMailCountW<P1>(hkeyuser: Option<super::super::System::Registry::HKEY>, pszmailaddress: P1, pdwcount: Option<*mut u32>, pfiletime: Option<*mut super::super::Foundation::FILETIME>, pszshellexecutecommand: Option<&mut [u16]>) -> windows_core::Result<()>
where
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shell32.dll" "system" fn SHGetUnreadMailCountW(hkeyuser : super::super::System::Registry:: HKEY, pszmailaddress : windows_core::PCWSTR, pdwcount : *mut u32, pfiletime : *mut super::super::Foundation:: FILETIME, pszshellexecutecommand : windows_core::PWSTR, cchshellexecutecommand : i32) -> windows_core::HRESULT);
    unsafe { SHGetUnreadMailCountW(hkeyuser.unwrap_or(core::mem::zeroed()) as _, pszmailaddress.param().abi(), pdwcount.unwrap_or(core::mem::zeroed()) as _, pfiletime.unwrap_or(core::mem::zeroed()) as _, core::mem::transmute(pszshellexecutecommand.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), pszshellexecutecommand.as_deref().map_or(0, |slice| slice.len().try_into().unwrap())).ok() }
}
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn SHGetValueA<P1, P2>(hkey: super::super::System::Registry::HKEY, pszsubkey: P1, pszvalue: P2, pdwtype: Option<*mut u32>, pvdata: Option<*mut core::ffi::c_void>, pcbdata: Option<*mut u32>) -> super::super::Foundation::WIN32_ERROR
where
    P1: windows_core::Param<windows_core::PCSTR>,
    P2: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn SHGetValueA(hkey : super::super::System::Registry:: HKEY, pszsubkey : windows_core::PCSTR, pszvalue : windows_core::PCSTR, pdwtype : *mut u32, pvdata : *mut core::ffi::c_void, pcbdata : *mut u32) -> super::super::Foundation:: WIN32_ERROR);
    unsafe { SHGetValueA(hkey, pszsubkey.param().abi(), pszvalue.param().abi(), pdwtype.unwrap_or(core::mem::zeroed()) as _, pvdata.unwrap_or(core::mem::zeroed()) as _, pcbdata.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn SHGetValueW<P1, P2>(hkey: super::super::System::Registry::HKEY, pszsubkey: P1, pszvalue: P2, pdwtype: Option<*mut u32>, pvdata: Option<*mut core::ffi::c_void>, pcbdata: Option<*mut u32>) -> super::super::Foundation::WIN32_ERROR
where
    P1: windows_core::Param<windows_core::PCWSTR>,
    P2: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn SHGetValueW(hkey : super::super::System::Registry:: HKEY, pszsubkey : windows_core::PCWSTR, pszvalue : windows_core::PCWSTR, pdwtype : *mut u32, pvdata : *mut core::ffi::c_void, pcbdata : *mut u32) -> super::super::Foundation:: WIN32_ERROR);
    unsafe { SHGetValueW(hkey, pszsubkey.param().abi(), pszvalue.param().abi(), pdwtype.unwrap_or(core::mem::zeroed()) as _, pvdata.unwrap_or(core::mem::zeroed()) as _, pcbdata.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn SHGetViewStatePropertyBag<P1, T>(pidl: Option<*const Common::ITEMIDLIST>, pszbagname: P1, dwflags: u32) -> windows_core::Result<T>
where
    P1: windows_core::Param<windows_core::PCWSTR>,
    T: windows_core::Interface,
{
    windows_core::link!("shlwapi.dll" "system" fn SHGetViewStatePropertyBag(pidl : *const Common:: ITEMIDLIST, pszbagname : windows_core::PCWSTR, dwflags : u32, riid : *const windows_core::GUID, ppv : *mut *mut core::ffi::c_void) -> windows_core::HRESULT);
    let mut result__ = core::ptr::null_mut();
    unsafe { SHGetViewStatePropertyBag(pidl.unwrap_or(core::mem::zeroed()) as _, pszbagname.param().abi(), dwflags, &T::IID, &mut result__).and_then(|| windows_core::Type::from_abi(result__)) }
}
#[inline]
pub unsafe fn SHGlobalCounterDecrement(id: SHGLOBALCOUNTER) -> i32 {
    windows_core::link!("shlwapi.dll" "system" fn SHGlobalCounterDecrement(id : SHGLOBALCOUNTER) -> i32);
    unsafe { SHGlobalCounterDecrement(id) }
}
#[inline]
pub unsafe fn SHGlobalCounterGetValue(id: SHGLOBALCOUNTER) -> i32 {
    windows_core::link!("shlwapi.dll" "system" fn SHGlobalCounterGetValue(id : SHGLOBALCOUNTER) -> i32);
    unsafe { SHGlobalCounterGetValue(id) }
}
#[inline]
pub unsafe fn SHGlobalCounterIncrement(id: SHGLOBALCOUNTER) -> i32 {
    windows_core::link!("shlwapi.dll" "system" fn SHGlobalCounterIncrement(id : SHGLOBALCOUNTER) -> i32);
    unsafe { SHGlobalCounterIncrement(id) }
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn SHHandleUpdateImage(pidlextra: *const Common::ITEMIDLIST) -> i32 {
    windows_core::link!("shell32.dll" "system" fn SHHandleUpdateImage(pidlextra : *const Common:: ITEMIDLIST) -> i32);
    unsafe { SHHandleUpdateImage(pidlextra) }
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn SHILCreateFromPath<P0>(pszpath: P0, ppidl: *mut *mut Common::ITEMIDLIST, rgfinout: Option<*mut u32>) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shell32.dll" "system" fn SHILCreateFromPath(pszpath : windows_core::PCWSTR, ppidl : *mut *mut Common:: ITEMIDLIST, rgfinout : *mut u32) -> windows_core::HRESULT);
    unsafe { SHILCreateFromPath(pszpath.param().abi(), ppidl as _, rgfinout.unwrap_or(core::mem::zeroed()) as _).ok() }
}
#[inline]
pub unsafe fn SHInvokePrinterCommandA<P2, P3>(hwnd: Option<super::super::Foundation::HWND>, uaction: u32, lpbuf1: P2, lpbuf2: P3, fmodal: bool) -> windows_core::BOOL
where
    P2: windows_core::Param<windows_core::PCSTR>,
    P3: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shell32.dll" "system" fn SHInvokePrinterCommandA(hwnd : super::super::Foundation:: HWND, uaction : u32, lpbuf1 : windows_core::PCSTR, lpbuf2 : windows_core::PCSTR, fmodal : windows_core::BOOL) -> windows_core::BOOL);
    unsafe { SHInvokePrinterCommandA(hwnd.unwrap_or(core::mem::zeroed()) as _, uaction, lpbuf1.param().abi(), lpbuf2.param().abi(), fmodal.into()) }
}
#[inline]
pub unsafe fn SHInvokePrinterCommandW<P2, P3>(hwnd: Option<super::super::Foundation::HWND>, uaction: u32, lpbuf1: P2, lpbuf2: P3, fmodal: bool) -> windows_core::BOOL
where
    P2: windows_core::Param<windows_core::PCWSTR>,
    P3: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shell32.dll" "system" fn SHInvokePrinterCommandW(hwnd : super::super::Foundation:: HWND, uaction : u32, lpbuf1 : windows_core::PCWSTR, lpbuf2 : windows_core::PCWSTR, fmodal : windows_core::BOOL) -> windows_core::BOOL);
    unsafe { SHInvokePrinterCommandW(hwnd.unwrap_or(core::mem::zeroed()) as _, uaction, lpbuf1.param().abi(), lpbuf2.param().abi(), fmodal.into()) }
}
#[inline]
pub unsafe fn SHIsFileAvailableOffline<P0>(pwszpath: P0, pdwstatus: Option<*mut u32>) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shell32.dll" "system" fn SHIsFileAvailableOffline(pwszpath : windows_core::PCWSTR, pdwstatus : *mut u32) -> windows_core::HRESULT);
    unsafe { SHIsFileAvailableOffline(pwszpath.param().abi(), pdwstatus.unwrap_or(core::mem::zeroed()) as _).ok() }
}
#[inline]
pub unsafe fn SHIsLowMemoryMachine(dwtype: u32) -> windows_core::BOOL {
    windows_core::link!("shlwapi.dll" "system" fn SHIsLowMemoryMachine(dwtype : u32) -> windows_core::BOOL);
    unsafe { SHIsLowMemoryMachine(dwtype) }
}
#[inline]
pub unsafe fn SHLimitInputEdit<P1>(hwndedit: super::super::Foundation::HWND, psf: P1) -> windows_core::Result<()>
where
    P1: windows_core::Param<IShellFolder>,
{
    windows_core::link!("shell32.dll" "system" fn SHLimitInputEdit(hwndedit : super::super::Foundation:: HWND, psf : * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe { SHLimitInputEdit(hwndedit, psf.param().abi()).ok() }
}
#[inline]
pub unsafe fn SHLoadInProc(rclsid: *const windows_core::GUID) -> windows_core::Result<()> {
    windows_core::link!("shell32.dll" "system" fn SHLoadInProc(rclsid : *const windows_core::GUID) -> windows_core::HRESULT);
    unsafe { SHLoadInProc(rclsid).ok() }
}
#[inline]
pub unsafe fn SHLoadIndirectString<P0>(pszsource: P0, pszoutbuf: &mut [u16], ppvreserved: Option<*const *const core::ffi::c_void>) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn SHLoadIndirectString(pszsource : windows_core::PCWSTR, pszoutbuf : windows_core::PWSTR, cchoutbuf : u32, ppvreserved : *const *const core::ffi::c_void) -> windows_core::HRESULT);
    unsafe { SHLoadIndirectString(pszsource.param().abi(), core::mem::transmute(pszoutbuf.as_ptr()), pszoutbuf.len().try_into().unwrap(), ppvreserved.unwrap_or(core::mem::zeroed()) as _).ok() }
}
#[inline]
pub unsafe fn SHLoadNonloadedIconOverlayIdentifiers() -> windows_core::Result<()> {
    windows_core::link!("shell32.dll" "system" fn SHLoadNonloadedIconOverlayIdentifiers() -> windows_core::HRESULT);
    unsafe { SHLoadNonloadedIconOverlayIdentifiers().ok() }
}
#[inline]
pub unsafe fn SHLockShared(hdata: super::super::Foundation::HANDLE, dwprocessid: u32) -> *mut core::ffi::c_void {
    windows_core::link!("shlwapi.dll" "system" fn SHLockShared(hdata : super::super::Foundation:: HANDLE, dwprocessid : u32) -> *mut core::ffi::c_void);
    unsafe { SHLockShared(hdata, dwprocessid) }
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn SHMapPIDLToSystemImageListIndex<P0>(pshf: P0, pidl: *const Common::ITEMIDLIST, piindexsel: Option<*mut i32>) -> i32
where
    P0: windows_core::Param<IShellFolder>,
{
    windows_core::link!("shell32.dll" "system" fn SHMapPIDLToSystemImageListIndex(pshf : * mut core::ffi::c_void, pidl : *const Common:: ITEMIDLIST, piindexsel : *mut i32) -> i32);
    unsafe { SHMapPIDLToSystemImageListIndex(pshf.param().abi(), pidl, piindexsel.unwrap_or(core::mem::zeroed()) as _) }
}
#[inline]
pub unsafe fn SHMessageBoxCheckA<P1, P2, P5>(hwnd: Option<super::super::Foundation::HWND>, psztext: P1, pszcaption: P2, utype: u32, idefault: i32, pszregval: P5) -> i32
where
    P1: windows_core::Param<windows_core::PCSTR>,
    P2: windows_core::Param<windows_core::PCSTR>,
    P5: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn SHMessageBoxCheckA(hwnd : super::super::Foundation:: HWND, psztext : windows_core::PCSTR, pszcaption : windows_core::PCSTR, utype : u32, idefault : i32, pszregval : windows_core::PCSTR) -> i32);
    unsafe { SHMessageBoxCheckA(hwnd.unwrap_or(core::mem::zeroed()) as _, psztext.param().abi(), pszcaption.param().abi(), utype, idefault, pszregval.param().abi()) }
}
#[inline]
pub unsafe fn SHMessageBoxCheckW<P1, P2, P5>(hwnd: Option<super::super::Foundation::HWND>, psztext: P1, pszcaption: P2, utype: u32, idefault: i32, pszregval: P5) -> i32
where
    P1: windows_core::Param<windows_core::PCWSTR>,
    P2: windows_core::Param<windows_core::PCWSTR>,
    P5: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn SHMessageBoxCheckW(hwnd : super::super::Foundation:: HWND, psztext : windows_core::PCWSTR, pszcaption : windows_core::PCWSTR, utype : u32, idefault : i32, pszregval : windows_core::PCWSTR) -> i32);
    unsafe { SHMessageBoxCheckW(hwnd.unwrap_or(core::mem::zeroed()) as _, psztext.param().abi(), pszcaption.param().abi(), utype, idefault, pszregval.param().abi()) }
}
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn SHMultiFileProperties<P0>(pdtobj: P0, dwflags: u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<super::super::System::Com::IDataObject>,
{
    windows_core::link!("shell32.dll" "system" fn SHMultiFileProperties(pdtobj : * mut core::ffi::c_void, dwflags : u32) -> windows_core::HRESULT);
    unsafe { SHMultiFileProperties(pdtobj.param().abi(), dwflags).ok() }
}
#[inline]
pub unsafe fn SHObjectProperties<P2, P3>(hwnd: Option<super::super::Foundation::HWND>, shopobjecttype: SHOP_TYPE, pszobjectname: P2, pszpropertypage: P3) -> windows_core::BOOL
where
    P2: windows_core::Param<windows_core::PCWSTR>,
    P3: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shell32.dll" "system" fn SHObjectProperties(hwnd : super::super::Foundation:: HWND, shopobjecttype : u32, pszobjectname : windows_core::PCWSTR, pszpropertypage : windows_core::PCWSTR) -> windows_core::BOOL);
    unsafe { SHObjectProperties(hwnd.unwrap_or(core::mem::zeroed()) as _, shopobjecttype.0 as _, pszobjectname.param().abi(), pszpropertypage.param().abi()) }
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn SHOpenFolderAndSelectItems(pidlfolder: *const Common::ITEMIDLIST, apidl: Option<&[*const Common::ITEMIDLIST]>, dwflags: u32) -> windows_core::Result<()> {
    windows_core::link!("shell32.dll" "system" fn SHOpenFolderAndSelectItems(pidlfolder : *const Common:: ITEMIDLIST, cidl : u32, apidl : *const *const Common:: ITEMIDLIST, dwflags : u32) -> windows_core::HRESULT);
    unsafe { SHOpenFolderAndSelectItems(pidlfolder, apidl.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(apidl.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), dwflags).ok() }
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Registry"))]
#[inline]
pub unsafe fn SHOpenPropSheetW<P0, P4, P5, P6>(pszcaption: P0, ahkeys: Option<&[super::super::System::Registry::HKEY]>, pclsiddefault: Option<*const windows_core::GUID>, pdtobj: P4, psb: P5, pstartpage: P6) -> windows_core::BOOL
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P4: windows_core::Param<super::super::System::Com::IDataObject>,
    P5: windows_core::Param<IShellBrowser>,
    P6: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shell32.dll" "system" fn SHOpenPropSheetW(pszcaption : windows_core::PCWSTR, ahkeys : *const super::super::System::Registry:: HKEY, ckeys : u32, pclsiddefault : *const windows_core::GUID, pdtobj : * mut core::ffi::c_void, psb : * mut core::ffi::c_void, pstartpage : windows_core::PCWSTR) -> windows_core::BOOL);
    unsafe { SHOpenPropSheetW(pszcaption.param().abi(), core::mem::transmute(ahkeys.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), ahkeys.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), pclsiddefault.unwrap_or(core::mem::zeroed()) as _, pdtobj.param().abi(), psb.param().abi(), pstartpage.param().abi()) }
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Registry"))]
#[inline]
pub unsafe fn SHOpenRegStream2A<P1, P2>(hkey: super::super::System::Registry::HKEY, pszsubkey: P1, pszvalue: P2, grfmode: u32) -> Option<super::super::System::Com::IStream>
where
    P1: windows_core::Param<windows_core::PCSTR>,
    P2: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn SHOpenRegStream2A(hkey : super::super::System::Registry:: HKEY, pszsubkey : windows_core::PCSTR, pszvalue : windows_core::PCSTR, grfmode : u32) -> Option < super::super::System::Com:: IStream >);
    unsafe { SHOpenRegStream2A(hkey, pszsubkey.param().abi(), pszvalue.param().abi(), grfmode) }
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Registry"))]
#[inline]
pub unsafe fn SHOpenRegStream2W<P1, P2>(hkey: super::super::System::Registry::HKEY, pszsubkey: P1, pszvalue: P2, grfmode: u32) -> Option<super::super::System::Com::IStream>
where
    P1: windows_core::Param<windows_core::PCWSTR>,
    P2: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn SHOpenRegStream2W(hkey : super::super::System::Registry:: HKEY, pszsubkey : windows_core::PCWSTR, pszvalue : windows_core::PCWSTR, grfmode : u32) -> Option < super::super::System::Com:: IStream >);
    unsafe { SHOpenRegStream2W(hkey, pszsubkey.param().abi(), pszvalue.param().abi(), grfmode) }
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Registry"))]
#[inline]
pub unsafe fn SHOpenRegStreamA<P1, P2>(hkey: super::super::System::Registry::HKEY, pszsubkey: P1, pszvalue: P2, grfmode: u32) -> Option<super::super::System::Com::IStream>
where
    P1: windows_core::Param<windows_core::PCSTR>,
    P2: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn SHOpenRegStreamA(hkey : super::super::System::Registry:: HKEY, pszsubkey : windows_core::PCSTR, pszvalue : windows_core::PCSTR, grfmode : u32) -> Option < super::super::System::Com:: IStream >);
    unsafe { SHOpenRegStreamA(hkey, pszsubkey.param().abi(), pszvalue.param().abi(), grfmode) }
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Registry"))]
#[inline]
pub unsafe fn SHOpenRegStreamW<P1, P2>(hkey: super::super::System::Registry::HKEY, pszsubkey: P1, pszvalue: P2, grfmode: u32) -> Option<super::super::System::Com::IStream>
where
    P1: windows_core::Param<windows_core::PCWSTR>,
    P2: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn SHOpenRegStreamW(hkey : super::super::System::Registry:: HKEY, pszsubkey : windows_core::PCWSTR, pszvalue : windows_core::PCWSTR, grfmode : u32) -> Option < super::super::System::Com:: IStream >);
    unsafe { SHOpenRegStreamW(hkey, pszsubkey.param().abi(), pszvalue.param().abi(), grfmode) }
}
#[inline]
pub unsafe fn SHOpenWithDialog(hwndparent: Option<super::super::Foundation::HWND>, poainfo: *const OPENASINFO) -> windows_core::Result<()> {
    windows_core::link!("shell32.dll" "system" fn SHOpenWithDialog(hwndparent : super::super::Foundation:: HWND, poainfo : *const OPENASINFO) -> windows_core::HRESULT);
    unsafe { SHOpenWithDialog(hwndparent.unwrap_or(core::mem::zeroed()) as _, poainfo).ok() }
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_UI_Shell_Common"))]
#[inline]
pub unsafe fn SHParseDisplayName<P0, P1>(pszname: P0, pbc: P1, ppidl: *mut *mut Common::ITEMIDLIST, sfgaoin: u32, psfgaoout: Option<*mut u32>) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<super::super::System::Com::IBindCtx>,
{
    windows_core::link!("shell32.dll" "system" fn SHParseDisplayName(pszname : windows_core::PCWSTR, pbc : * mut core::ffi::c_void, ppidl : *mut *mut Common:: ITEMIDLIST, sfgaoin : u32, psfgaoout : *mut u32) -> windows_core::HRESULT);
    unsafe { SHParseDisplayName(pszname.param().abi(), pbc.param().abi(), ppidl as _, sfgaoin, psfgaoout.unwrap_or(core::mem::zeroed()) as _).ok() }
}
#[inline]
pub unsafe fn SHPathPrepareForWriteA<P1, P2>(hwnd: Option<super::super::Foundation::HWND>, punkenablemodless: P1, pszpath: P2, dwflags: u32) -> windows_core::Result<()>
where
    P1: windows_core::Param<windows_core::IUnknown>,
    P2: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shell32.dll" "system" fn SHPathPrepareForWriteA(hwnd : super::super::Foundation:: HWND, punkenablemodless : * mut core::ffi::c_void, pszpath : windows_core::PCSTR, dwflags : u32) -> windows_core::HRESULT);
    unsafe { SHPathPrepareForWriteA(hwnd.unwrap_or(core::mem::zeroed()) as _, punkenablemodless.param().abi(), pszpath.param().abi(), dwflags).ok() }
}
#[inline]
pub unsafe fn SHPathPrepareForWriteW<P1, P2>(hwnd: Option<super::super::Foundation::HWND>, punkenablemodless: P1, pszpath: P2, dwflags: u32) -> windows_core::Result<()>
where
    P1: windows_core::Param<windows_core::IUnknown>,
    P2: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shell32.dll" "system" fn SHPathPrepareForWriteW(hwnd : super::super::Foundation:: HWND, punkenablemodless : * mut core::ffi::c_void, pszpath : windows_core::PCWSTR, dwflags : u32) -> windows_core::HRESULT);
    unsafe { SHPathPrepareForWriteW(hwnd.unwrap_or(core::mem::zeroed()) as _, punkenablemodless.param().abi(), pszpath.param().abi(), dwflags).ok() }
}
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn SHQueryInfoKeyA(hkey: super::super::System::Registry::HKEY, pcsubkeys: Option<*mut u32>, pcchmaxsubkeylen: Option<*mut u32>, pcvalues: Option<*mut u32>, pcchmaxvaluenamelen: Option<*mut u32>) -> super::super::Foundation::WIN32_ERROR {
    windows_core::link!("shlwapi.dll" "system" fn SHQueryInfoKeyA(hkey : super::super::System::Registry:: HKEY, pcsubkeys : *mut u32, pcchmaxsubkeylen : *mut u32, pcvalues : *mut u32, pcchmaxvaluenamelen : *mut u32) -> super::super::Foundation:: WIN32_ERROR);
    unsafe { SHQueryInfoKeyA(hkey, pcsubkeys.unwrap_or(core::mem::zeroed()) as _, pcchmaxsubkeylen.unwrap_or(core::mem::zeroed()) as _, pcvalues.unwrap_or(core::mem::zeroed()) as _, pcchmaxvaluenamelen.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn SHQueryInfoKeyW(hkey: super::super::System::Registry::HKEY, pcsubkeys: Option<*mut u32>, pcchmaxsubkeylen: Option<*mut u32>, pcvalues: Option<*mut u32>, pcchmaxvaluenamelen: Option<*mut u32>) -> super::super::Foundation::WIN32_ERROR {
    windows_core::link!("shlwapi.dll" "system" fn SHQueryInfoKeyW(hkey : super::super::System::Registry:: HKEY, pcsubkeys : *mut u32, pcchmaxsubkeylen : *mut u32, pcvalues : *mut u32, pcchmaxvaluenamelen : *mut u32) -> super::super::Foundation:: WIN32_ERROR);
    unsafe { SHQueryInfoKeyW(hkey, pcsubkeys.unwrap_or(core::mem::zeroed()) as _, pcchmaxsubkeylen.unwrap_or(core::mem::zeroed()) as _, pcvalues.unwrap_or(core::mem::zeroed()) as _, pcchmaxvaluenamelen.unwrap_or(core::mem::zeroed()) as _) }
}
#[inline]
pub unsafe fn SHQueryRecycleBinA<P0>(pszrootpath: P0, pshqueryrbinfo: *mut SHQUERYRBINFO) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shell32.dll" "system" fn SHQueryRecycleBinA(pszrootpath : windows_core::PCSTR, pshqueryrbinfo : *mut SHQUERYRBINFO) -> windows_core::HRESULT);
    unsafe { SHQueryRecycleBinA(pszrootpath.param().abi(), pshqueryrbinfo as _).ok() }
}
#[inline]
pub unsafe fn SHQueryRecycleBinW<P0>(pszrootpath: P0, pshqueryrbinfo: *mut SHQUERYRBINFO) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shell32.dll" "system" fn SHQueryRecycleBinW(pszrootpath : windows_core::PCWSTR, pshqueryrbinfo : *mut SHQUERYRBINFO) -> windows_core::HRESULT);
    unsafe { SHQueryRecycleBinW(pszrootpath.param().abi(), pshqueryrbinfo as _).ok() }
}
#[inline]
pub unsafe fn SHQueryUserNotificationState() -> windows_core::Result<QUERY_USER_NOTIFICATION_STATE> {
    windows_core::link!("shell32.dll" "system" fn SHQueryUserNotificationState(pquns : *mut QUERY_USER_NOTIFICATION_STATE) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        SHQueryUserNotificationState(&mut result__).map(|| result__)
    }
}
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn SHQueryValueExA<P1>(hkey: super::super::System::Registry::HKEY, pszvalue: P1, pdwreserved: Option<*const u32>, pdwtype: Option<*mut u32>, pvdata: Option<*mut core::ffi::c_void>, pcbdata: Option<*mut u32>) -> super::super::Foundation::WIN32_ERROR
where
    P1: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn SHQueryValueExA(hkey : super::super::System::Registry:: HKEY, pszvalue : windows_core::PCSTR, pdwreserved : *const u32, pdwtype : *mut u32, pvdata : *mut core::ffi::c_void, pcbdata : *mut u32) -> super::super::Foundation:: WIN32_ERROR);
    unsafe { SHQueryValueExA(hkey, pszvalue.param().abi(), pdwreserved.unwrap_or(core::mem::zeroed()) as _, pdwtype.unwrap_or(core::mem::zeroed()) as _, pvdata.unwrap_or(core::mem::zeroed()) as _, pcbdata.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn SHQueryValueExW<P1>(hkey: super::super::System::Registry::HKEY, pszvalue: P1, pdwreserved: Option<*const u32>, pdwtype: Option<*mut u32>, pvdata: Option<*mut core::ffi::c_void>, pcbdata: Option<*mut u32>) -> super::super::Foundation::WIN32_ERROR
where
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn SHQueryValueExW(hkey : super::super::System::Registry:: HKEY, pszvalue : windows_core::PCWSTR, pdwreserved : *const u32, pdwtype : *mut u32, pvdata : *mut core::ffi::c_void, pcbdata : *mut u32) -> super::super::Foundation:: WIN32_ERROR);
    unsafe { SHQueryValueExW(hkey, pszvalue.param().abi(), pdwreserved.unwrap_or(core::mem::zeroed()) as _, pdwtype.unwrap_or(core::mem::zeroed()) as _, pvdata.unwrap_or(core::mem::zeroed()) as _, pcbdata.unwrap_or(core::mem::zeroed()) as _) }
}
#[inline]
pub unsafe fn SHRegCloseUSKey(huskey: isize) -> super::super::Foundation::WIN32_ERROR {
    windows_core::link!("shlwapi.dll" "system" fn SHRegCloseUSKey(huskey : isize) -> super::super::Foundation:: WIN32_ERROR);
    unsafe { SHRegCloseUSKey(huskey) }
}
#[inline]
pub unsafe fn SHRegCreateUSKeyA<P0>(pszpath: P0, samdesired: u32, hrelativeuskey: Option<isize>, phnewuskey: *mut isize, dwflags: u32) -> super::super::Foundation::WIN32_ERROR
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn SHRegCreateUSKeyA(pszpath : windows_core::PCSTR, samdesired : u32, hrelativeuskey : isize, phnewuskey : *mut isize, dwflags : u32) -> super::super::Foundation:: WIN32_ERROR);
    unsafe { SHRegCreateUSKeyA(pszpath.param().abi(), samdesired, hrelativeuskey.unwrap_or(core::mem::zeroed()) as _, phnewuskey as _, dwflags) }
}
#[inline]
pub unsafe fn SHRegCreateUSKeyW<P0>(pwzpath: P0, samdesired: u32, hrelativeuskey: Option<isize>, phnewuskey: *mut isize, dwflags: u32) -> super::super::Foundation::WIN32_ERROR
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn SHRegCreateUSKeyW(pwzpath : windows_core::PCWSTR, samdesired : u32, hrelativeuskey : isize, phnewuskey : *mut isize, dwflags : u32) -> super::super::Foundation:: WIN32_ERROR);
    unsafe { SHRegCreateUSKeyW(pwzpath.param().abi(), samdesired, hrelativeuskey.unwrap_or(core::mem::zeroed()) as _, phnewuskey as _, dwflags) }
}
#[inline]
pub unsafe fn SHRegDeleteEmptyUSKeyA<P1>(huskey: isize, pszsubkey: P1, delregflags: SHREGDEL_FLAGS) -> super::super::Foundation::WIN32_ERROR
where
    P1: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn SHRegDeleteEmptyUSKeyA(huskey : isize, pszsubkey : windows_core::PCSTR, delregflags : SHREGDEL_FLAGS) -> super::super::Foundation:: WIN32_ERROR);
    unsafe { SHRegDeleteEmptyUSKeyA(huskey, pszsubkey.param().abi(), delregflags) }
}
#[inline]
pub unsafe fn SHRegDeleteEmptyUSKeyW<P1>(huskey: isize, pwzsubkey: P1, delregflags: SHREGDEL_FLAGS) -> super::super::Foundation::WIN32_ERROR
where
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn SHRegDeleteEmptyUSKeyW(huskey : isize, pwzsubkey : windows_core::PCWSTR, delregflags : SHREGDEL_FLAGS) -> super::super::Foundation:: WIN32_ERROR);
    unsafe { SHRegDeleteEmptyUSKeyW(huskey, pwzsubkey.param().abi(), delregflags) }
}
#[inline]
pub unsafe fn SHRegDeleteUSValueA<P1>(huskey: isize, pszvalue: P1, delregflags: SHREGDEL_FLAGS) -> super::super::Foundation::WIN32_ERROR
where
    P1: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn SHRegDeleteUSValueA(huskey : isize, pszvalue : windows_core::PCSTR, delregflags : SHREGDEL_FLAGS) -> super::super::Foundation:: WIN32_ERROR);
    unsafe { SHRegDeleteUSValueA(huskey, pszvalue.param().abi(), delregflags) }
}
#[inline]
pub unsafe fn SHRegDeleteUSValueW<P1>(huskey: isize, pwzvalue: P1, delregflags: SHREGDEL_FLAGS) -> super::super::Foundation::WIN32_ERROR
where
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn SHRegDeleteUSValueW(huskey : isize, pwzvalue : windows_core::PCWSTR, delregflags : SHREGDEL_FLAGS) -> super::super::Foundation:: WIN32_ERROR);
    unsafe { SHRegDeleteUSValueW(huskey, pwzvalue.param().abi(), delregflags) }
}
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn SHRegDuplicateHKey(hkey: super::super::System::Registry::HKEY) -> super::super::System::Registry::HKEY {
    windows_core::link!("shlwapi.dll" "system" fn SHRegDuplicateHKey(hkey : super::super::System::Registry:: HKEY) -> super::super::System::Registry:: HKEY);
    unsafe { SHRegDuplicateHKey(hkey) }
}
#[inline]
pub unsafe fn SHRegEnumUSKeyA(huskey: isize, dwindex: u32, pszname: windows_core::PSTR, pcchname: *mut u32, enumregflags: SHREGENUM_FLAGS) -> super::super::Foundation::WIN32_ERROR {
    windows_core::link!("shlwapi.dll" "system" fn SHRegEnumUSKeyA(huskey : isize, dwindex : u32, pszname : windows_core::PSTR, pcchname : *mut u32, enumregflags : SHREGENUM_FLAGS) -> super::super::Foundation:: WIN32_ERROR);
    unsafe { SHRegEnumUSKeyA(huskey, dwindex, core::mem::transmute(pszname), pcchname as _, enumregflags) }
}
#[inline]
pub unsafe fn SHRegEnumUSKeyW(huskey: isize, dwindex: u32, pwzname: windows_core::PWSTR, pcchname: *mut u32, enumregflags: SHREGENUM_FLAGS) -> super::super::Foundation::WIN32_ERROR {
    windows_core::link!("shlwapi.dll" "system" fn SHRegEnumUSKeyW(huskey : isize, dwindex : u32, pwzname : windows_core::PWSTR, pcchname : *mut u32, enumregflags : SHREGENUM_FLAGS) -> super::super::Foundation:: WIN32_ERROR);
    unsafe { SHRegEnumUSKeyW(huskey, dwindex, core::mem::transmute(pwzname), pcchname as _, enumregflags) }
}
#[inline]
pub unsafe fn SHRegEnumUSValueA(huskey: isize, dwindex: u32, pszvaluename: windows_core::PSTR, pcchvaluename: *mut u32, pdwtype: Option<*mut u32>, pvdata: Option<*mut core::ffi::c_void>, pcbdata: Option<*mut u32>, enumregflags: SHREGENUM_FLAGS) -> super::super::Foundation::WIN32_ERROR {
    windows_core::link!("shlwapi.dll" "system" fn SHRegEnumUSValueA(huskey : isize, dwindex : u32, pszvaluename : windows_core::PSTR, pcchvaluename : *mut u32, pdwtype : *mut u32, pvdata : *mut core::ffi::c_void, pcbdata : *mut u32, enumregflags : SHREGENUM_FLAGS) -> super::super::Foundation:: WIN32_ERROR);
    unsafe { SHRegEnumUSValueA(huskey, dwindex, core::mem::transmute(pszvaluename), pcchvaluename as _, pdwtype.unwrap_or(core::mem::zeroed()) as _, pvdata.unwrap_or(core::mem::zeroed()) as _, pcbdata.unwrap_or(core::mem::zeroed()) as _, enumregflags) }
}
#[inline]
pub unsafe fn SHRegEnumUSValueW(huskey: isize, dwindex: u32, pszvaluename: windows_core::PWSTR, pcchvaluename: *mut u32, pdwtype: Option<*mut u32>, pvdata: Option<*mut core::ffi::c_void>, pcbdata: Option<*mut u32>, enumregflags: SHREGENUM_FLAGS) -> super::super::Foundation::WIN32_ERROR {
    windows_core::link!("shlwapi.dll" "system" fn SHRegEnumUSValueW(huskey : isize, dwindex : u32, pszvaluename : windows_core::PWSTR, pcchvaluename : *mut u32, pdwtype : *mut u32, pvdata : *mut core::ffi::c_void, pcbdata : *mut u32, enumregflags : SHREGENUM_FLAGS) -> super::super::Foundation:: WIN32_ERROR);
    unsafe { SHRegEnumUSValueW(huskey, dwindex, core::mem::transmute(pszvaluename), pcchvaluename as _, pdwtype.unwrap_or(core::mem::zeroed()) as _, pvdata.unwrap_or(core::mem::zeroed()) as _, pcbdata.unwrap_or(core::mem::zeroed()) as _, enumregflags) }
}
#[inline]
pub unsafe fn SHRegGetBoolUSValueA<P0, P1>(pszsubkey: P0, pszvalue: P1, fignorehkcu: bool, fdefault: bool) -> windows_core::BOOL
where
    P0: windows_core::Param<windows_core::PCSTR>,
    P1: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn SHRegGetBoolUSValueA(pszsubkey : windows_core::PCSTR, pszvalue : windows_core::PCSTR, fignorehkcu : windows_core::BOOL, fdefault : windows_core::BOOL) -> windows_core::BOOL);
    unsafe { SHRegGetBoolUSValueA(pszsubkey.param().abi(), pszvalue.param().abi(), fignorehkcu.into(), fdefault.into()) }
}
#[inline]
pub unsafe fn SHRegGetBoolUSValueW<P0, P1>(pszsubkey: P0, pszvalue: P1, fignorehkcu: bool, fdefault: bool) -> windows_core::BOOL
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn SHRegGetBoolUSValueW(pszsubkey : windows_core::PCWSTR, pszvalue : windows_core::PCWSTR, fignorehkcu : windows_core::BOOL, fdefault : windows_core::BOOL) -> windows_core::BOOL);
    unsafe { SHRegGetBoolUSValueW(pszsubkey.param().abi(), pszvalue.param().abi(), fignorehkcu.into(), fdefault.into()) }
}
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn SHRegGetIntW<P1>(hk: super::super::System::Registry::HKEY, pwzkey: P1, idefault: i32) -> i32
where
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn SHRegGetIntW(hk : super::super::System::Registry:: HKEY, pwzkey : windows_core::PCWSTR, idefault : i32) -> i32);
    unsafe { SHRegGetIntW(hk, pwzkey.param().abi(), idefault) }
}
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn SHRegGetPathA<P1, P2>(hkey: super::super::System::Registry::HKEY, pcszsubkey: P1, pcszvalue: P2, pszpath: &mut [u8; 260], dwflags: u32) -> super::super::Foundation::WIN32_ERROR
where
    P1: windows_core::Param<windows_core::PCSTR>,
    P2: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn SHRegGetPathA(hkey : super::super::System::Registry:: HKEY, pcszsubkey : windows_core::PCSTR, pcszvalue : windows_core::PCSTR, pszpath : windows_core::PSTR, dwflags : u32) -> super::super::Foundation:: WIN32_ERROR);
    unsafe { SHRegGetPathA(hkey, pcszsubkey.param().abi(), pcszvalue.param().abi(), core::mem::transmute(pszpath.as_ptr()), dwflags) }
}
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn SHRegGetPathW<P1, P2>(hkey: super::super::System::Registry::HKEY, pcszsubkey: P1, pcszvalue: P2, pszpath: &mut [u16; 260], dwflags: u32) -> super::super::Foundation::WIN32_ERROR
where
    P1: windows_core::Param<windows_core::PCWSTR>,
    P2: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn SHRegGetPathW(hkey : super::super::System::Registry:: HKEY, pcszsubkey : windows_core::PCWSTR, pcszvalue : windows_core::PCWSTR, pszpath : windows_core::PWSTR, dwflags : u32) -> super::super::Foundation:: WIN32_ERROR);
    unsafe { SHRegGetPathW(hkey, pcszsubkey.param().abi(), pcszvalue.param().abi(), core::mem::transmute(pszpath.as_ptr()), dwflags) }
}
#[inline]
pub unsafe fn SHRegGetUSValueA<P0, P1>(pszsubkey: P0, pszvalue: P1, pdwtype: Option<*mut u32>, pvdata: Option<*mut core::ffi::c_void>, pcbdata: Option<*mut u32>, fignorehkcu: bool, pvdefaultdata: Option<*const core::ffi::c_void>, dwdefaultdatasize: u32) -> super::super::Foundation::WIN32_ERROR
where
    P0: windows_core::Param<windows_core::PCSTR>,
    P1: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn SHRegGetUSValueA(pszsubkey : windows_core::PCSTR, pszvalue : windows_core::PCSTR, pdwtype : *mut u32, pvdata : *mut core::ffi::c_void, pcbdata : *mut u32, fignorehkcu : windows_core::BOOL, pvdefaultdata : *const core::ffi::c_void, dwdefaultdatasize : u32) -> super::super::Foundation:: WIN32_ERROR);
    unsafe { SHRegGetUSValueA(pszsubkey.param().abi(), pszvalue.param().abi(), pdwtype.unwrap_or(core::mem::zeroed()) as _, pvdata.unwrap_or(core::mem::zeroed()) as _, pcbdata.unwrap_or(core::mem::zeroed()) as _, fignorehkcu.into(), pvdefaultdata.unwrap_or(core::mem::zeroed()) as _, dwdefaultdatasize) }
}
#[inline]
pub unsafe fn SHRegGetUSValueW<P0, P1>(pszsubkey: P0, pszvalue: P1, pdwtype: Option<*mut u32>, pvdata: Option<*mut core::ffi::c_void>, pcbdata: Option<*mut u32>, fignorehkcu: bool, pvdefaultdata: Option<*const core::ffi::c_void>, dwdefaultdatasize: u32) -> super::super::Foundation::WIN32_ERROR
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn SHRegGetUSValueW(pszsubkey : windows_core::PCWSTR, pszvalue : windows_core::PCWSTR, pdwtype : *mut u32, pvdata : *mut core::ffi::c_void, pcbdata : *mut u32, fignorehkcu : windows_core::BOOL, pvdefaultdata : *const core::ffi::c_void, dwdefaultdatasize : u32) -> super::super::Foundation:: WIN32_ERROR);
    unsafe { SHRegGetUSValueW(pszsubkey.param().abi(), pszvalue.param().abi(), pdwtype.unwrap_or(core::mem::zeroed()) as _, pvdata.unwrap_or(core::mem::zeroed()) as _, pcbdata.unwrap_or(core::mem::zeroed()) as _, fignorehkcu.into(), pvdefaultdata.unwrap_or(core::mem::zeroed()) as _, dwdefaultdatasize) }
}
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn SHRegGetValueA<P1, P2>(hkey: super::super::System::Registry::HKEY, pszsubkey: P1, pszvalue: P2, srrfflags: i32, pdwtype: Option<*mut u32>, pvdata: Option<*mut core::ffi::c_void>, pcbdata: Option<*mut u32>) -> super::super::Foundation::WIN32_ERROR
where
    P1: windows_core::Param<windows_core::PCSTR>,
    P2: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn SHRegGetValueA(hkey : super::super::System::Registry:: HKEY, pszsubkey : windows_core::PCSTR, pszvalue : windows_core::PCSTR, srrfflags : i32, pdwtype : *mut u32, pvdata : *mut core::ffi::c_void, pcbdata : *mut u32) -> super::super::Foundation:: WIN32_ERROR);
    unsafe { SHRegGetValueA(hkey, pszsubkey.param().abi(), pszvalue.param().abi(), srrfflags, pdwtype.unwrap_or(core::mem::zeroed()) as _, pvdata.unwrap_or(core::mem::zeroed()) as _, pcbdata.unwrap_or(core::mem::zeroed()) as _) }
}
#[inline]
pub unsafe fn SHRegGetValueFromHKCUHKLM<P0, P1>(pwszkey: P0, pwszvalue: P1, srrfflags: i32, pdwtype: Option<*mut u32>, pvdata: Option<*mut core::ffi::c_void>, pcbdata: Option<*mut u32>) -> super::super::Foundation::WIN32_ERROR
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn SHRegGetValueFromHKCUHKLM(pwszkey : windows_core::PCWSTR, pwszvalue : windows_core::PCWSTR, srrfflags : i32, pdwtype : *mut u32, pvdata : *mut core::ffi::c_void, pcbdata : *mut u32) -> super::super::Foundation:: WIN32_ERROR);
    unsafe { SHRegGetValueFromHKCUHKLM(pwszkey.param().abi(), pwszvalue.param().abi(), srrfflags, pdwtype.unwrap_or(core::mem::zeroed()) as _, pvdata.unwrap_or(core::mem::zeroed()) as _, pcbdata.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn SHRegGetValueW<P1, P2>(hkey: super::super::System::Registry::HKEY, pszsubkey: P1, pszvalue: P2, srrfflags: i32, pdwtype: Option<*mut u32>, pvdata: Option<*mut core::ffi::c_void>, pcbdata: Option<*mut u32>) -> super::super::Foundation::WIN32_ERROR
where
    P1: windows_core::Param<windows_core::PCWSTR>,
    P2: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn SHRegGetValueW(hkey : super::super::System::Registry:: HKEY, pszsubkey : windows_core::PCWSTR, pszvalue : windows_core::PCWSTR, srrfflags : i32, pdwtype : *mut u32, pvdata : *mut core::ffi::c_void, pcbdata : *mut u32) -> super::super::Foundation:: WIN32_ERROR);
    unsafe { SHRegGetValueW(hkey, pszsubkey.param().abi(), pszvalue.param().abi(), srrfflags, pdwtype.unwrap_or(core::mem::zeroed()) as _, pvdata.unwrap_or(core::mem::zeroed()) as _, pcbdata.unwrap_or(core::mem::zeroed()) as _) }
}
#[inline]
pub unsafe fn SHRegOpenUSKeyA<P0>(pszpath: P0, samdesired: u32, hrelativeuskey: Option<isize>, phnewuskey: *mut isize, fignorehkcu: bool) -> super::super::Foundation::WIN32_ERROR
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn SHRegOpenUSKeyA(pszpath : windows_core::PCSTR, samdesired : u32, hrelativeuskey : isize, phnewuskey : *mut isize, fignorehkcu : windows_core::BOOL) -> super::super::Foundation:: WIN32_ERROR);
    unsafe { SHRegOpenUSKeyA(pszpath.param().abi(), samdesired, hrelativeuskey.unwrap_or(core::mem::zeroed()) as _, phnewuskey as _, fignorehkcu.into()) }
}
#[inline]
pub unsafe fn SHRegOpenUSKeyW<P0>(pwzpath: P0, samdesired: u32, hrelativeuskey: Option<isize>, phnewuskey: *mut isize, fignorehkcu: bool) -> super::super::Foundation::WIN32_ERROR
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn SHRegOpenUSKeyW(pwzpath : windows_core::PCWSTR, samdesired : u32, hrelativeuskey : isize, phnewuskey : *mut isize, fignorehkcu : windows_core::BOOL) -> super::super::Foundation:: WIN32_ERROR);
    unsafe { SHRegOpenUSKeyW(pwzpath.param().abi(), samdesired, hrelativeuskey.unwrap_or(core::mem::zeroed()) as _, phnewuskey as _, fignorehkcu.into()) }
}
#[inline]
pub unsafe fn SHRegQueryInfoUSKeyA(huskey: isize, pcsubkeys: Option<*mut u32>, pcchmaxsubkeylen: Option<*mut u32>, pcvalues: Option<*mut u32>, pcchmaxvaluenamelen: Option<*mut u32>, enumregflags: SHREGENUM_FLAGS) -> super::super::Foundation::WIN32_ERROR {
    windows_core::link!("shlwapi.dll" "system" fn SHRegQueryInfoUSKeyA(huskey : isize, pcsubkeys : *mut u32, pcchmaxsubkeylen : *mut u32, pcvalues : *mut u32, pcchmaxvaluenamelen : *mut u32, enumregflags : SHREGENUM_FLAGS) -> super::super::Foundation:: WIN32_ERROR);
    unsafe { SHRegQueryInfoUSKeyA(huskey, pcsubkeys.unwrap_or(core::mem::zeroed()) as _, pcchmaxsubkeylen.unwrap_or(core::mem::zeroed()) as _, pcvalues.unwrap_or(core::mem::zeroed()) as _, pcchmaxvaluenamelen.unwrap_or(core::mem::zeroed()) as _, enumregflags) }
}
#[inline]
pub unsafe fn SHRegQueryInfoUSKeyW(huskey: isize, pcsubkeys: Option<*mut u32>, pcchmaxsubkeylen: Option<*mut u32>, pcvalues: Option<*mut u32>, pcchmaxvaluenamelen: Option<*mut u32>, enumregflags: SHREGENUM_FLAGS) -> super::super::Foundation::WIN32_ERROR {
    windows_core::link!("shlwapi.dll" "system" fn SHRegQueryInfoUSKeyW(huskey : isize, pcsubkeys : *mut u32, pcchmaxsubkeylen : *mut u32, pcvalues : *mut u32, pcchmaxvaluenamelen : *mut u32, enumregflags : SHREGENUM_FLAGS) -> super::super::Foundation:: WIN32_ERROR);
    unsafe { SHRegQueryInfoUSKeyW(huskey, pcsubkeys.unwrap_or(core::mem::zeroed()) as _, pcchmaxsubkeylen.unwrap_or(core::mem::zeroed()) as _, pcvalues.unwrap_or(core::mem::zeroed()) as _, pcchmaxvaluenamelen.unwrap_or(core::mem::zeroed()) as _, enumregflags) }
}
#[inline]
pub unsafe fn SHRegQueryUSValueA<P1>(huskey: isize, pszvalue: P1, pdwtype: Option<*mut u32>, pvdata: Option<*mut core::ffi::c_void>, pcbdata: Option<*mut u32>, fignorehkcu: bool, pvdefaultdata: Option<*const core::ffi::c_void>, dwdefaultdatasize: Option<u32>) -> super::super::Foundation::WIN32_ERROR
where
    P1: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn SHRegQueryUSValueA(huskey : isize, pszvalue : windows_core::PCSTR, pdwtype : *mut u32, pvdata : *mut core::ffi::c_void, pcbdata : *mut u32, fignorehkcu : windows_core::BOOL, pvdefaultdata : *const core::ffi::c_void, dwdefaultdatasize : u32) -> super::super::Foundation:: WIN32_ERROR);
    unsafe { SHRegQueryUSValueA(huskey, pszvalue.param().abi(), pdwtype.unwrap_or(core::mem::zeroed()) as _, pvdata.unwrap_or(core::mem::zeroed()) as _, pcbdata.unwrap_or(core::mem::zeroed()) as _, fignorehkcu.into(), pvdefaultdata.unwrap_or(core::mem::zeroed()) as _, dwdefaultdatasize.unwrap_or(core::mem::zeroed()) as _) }
}
#[inline]
pub unsafe fn SHRegQueryUSValueW<P1>(huskey: isize, pszvalue: P1, pdwtype: Option<*mut u32>, pvdata: Option<*mut core::ffi::c_void>, pcbdata: Option<*mut u32>, fignorehkcu: bool, pvdefaultdata: Option<*const core::ffi::c_void>, dwdefaultdatasize: Option<u32>) -> super::super::Foundation::WIN32_ERROR
where
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn SHRegQueryUSValueW(huskey : isize, pszvalue : windows_core::PCWSTR, pdwtype : *mut u32, pvdata : *mut core::ffi::c_void, pcbdata : *mut u32, fignorehkcu : windows_core::BOOL, pvdefaultdata : *const core::ffi::c_void, dwdefaultdatasize : u32) -> super::super::Foundation:: WIN32_ERROR);
    unsafe { SHRegQueryUSValueW(huskey, pszvalue.param().abi(), pdwtype.unwrap_or(core::mem::zeroed()) as _, pvdata.unwrap_or(core::mem::zeroed()) as _, pcbdata.unwrap_or(core::mem::zeroed()) as _, fignorehkcu.into(), pvdefaultdata.unwrap_or(core::mem::zeroed()) as _, dwdefaultdatasize.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn SHRegSetPathA<P1, P2, P3>(hkey: super::super::System::Registry::HKEY, pcszsubkey: P1, pcszvalue: P2, pcszpath: P3, dwflags: u32) -> super::super::Foundation::WIN32_ERROR
where
    P1: windows_core::Param<windows_core::PCSTR>,
    P2: windows_core::Param<windows_core::PCSTR>,
    P3: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn SHRegSetPathA(hkey : super::super::System::Registry:: HKEY, pcszsubkey : windows_core::PCSTR, pcszvalue : windows_core::PCSTR, pcszpath : windows_core::PCSTR, dwflags : u32) -> super::super::Foundation:: WIN32_ERROR);
    unsafe { SHRegSetPathA(hkey, pcszsubkey.param().abi(), pcszvalue.param().abi(), pcszpath.param().abi(), dwflags) }
}
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn SHRegSetPathW<P1, P2, P3>(hkey: super::super::System::Registry::HKEY, pcszsubkey: P1, pcszvalue: P2, pcszpath: P3, dwflags: u32) -> super::super::Foundation::WIN32_ERROR
where
    P1: windows_core::Param<windows_core::PCWSTR>,
    P2: windows_core::Param<windows_core::PCWSTR>,
    P3: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn SHRegSetPathW(hkey : super::super::System::Registry:: HKEY, pcszsubkey : windows_core::PCWSTR, pcszvalue : windows_core::PCWSTR, pcszpath : windows_core::PCWSTR, dwflags : u32) -> super::super::Foundation:: WIN32_ERROR);
    unsafe { SHRegSetPathW(hkey, pcszsubkey.param().abi(), pcszvalue.param().abi(), pcszpath.param().abi(), dwflags) }
}
#[inline]
pub unsafe fn SHRegSetUSValueA<P0, P1>(pszsubkey: P0, pszvalue: P1, dwtype: u32, pvdata: Option<*const core::ffi::c_void>, cbdata: Option<u32>, dwflags: Option<u32>) -> super::super::Foundation::WIN32_ERROR
where
    P0: windows_core::Param<windows_core::PCSTR>,
    P1: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn SHRegSetUSValueA(pszsubkey : windows_core::PCSTR, pszvalue : windows_core::PCSTR, dwtype : u32, pvdata : *const core::ffi::c_void, cbdata : u32, dwflags : u32) -> super::super::Foundation:: WIN32_ERROR);
    unsafe { SHRegSetUSValueA(pszsubkey.param().abi(), pszvalue.param().abi(), dwtype, pvdata.unwrap_or(core::mem::zeroed()) as _, cbdata.unwrap_or(core::mem::zeroed()) as _, dwflags.unwrap_or(core::mem::zeroed()) as _) }
}
#[inline]
pub unsafe fn SHRegSetUSValueW<P0, P1>(pwzsubkey: P0, pwzvalue: P1, dwtype: u32, pvdata: Option<*const core::ffi::c_void>, cbdata: Option<u32>, dwflags: Option<u32>) -> super::super::Foundation::WIN32_ERROR
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn SHRegSetUSValueW(pwzsubkey : windows_core::PCWSTR, pwzvalue : windows_core::PCWSTR, dwtype : u32, pvdata : *const core::ffi::c_void, cbdata : u32, dwflags : u32) -> super::super::Foundation:: WIN32_ERROR);
    unsafe { SHRegSetUSValueW(pwzsubkey.param().abi(), pwzvalue.param().abi(), dwtype, pvdata.unwrap_or(core::mem::zeroed()) as _, cbdata.unwrap_or(core::mem::zeroed()) as _, dwflags.unwrap_or(core::mem::zeroed()) as _) }
}
#[inline]
pub unsafe fn SHRegWriteUSValueA<P1>(huskey: isize, pszvalue: P1, dwtype: u32, pvdata: *const core::ffi::c_void, cbdata: u32, dwflags: u32) -> super::super::Foundation::WIN32_ERROR
where
    P1: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn SHRegWriteUSValueA(huskey : isize, pszvalue : windows_core::PCSTR, dwtype : u32, pvdata : *const core::ffi::c_void, cbdata : u32, dwflags : u32) -> super::super::Foundation:: WIN32_ERROR);
    unsafe { SHRegWriteUSValueA(huskey, pszvalue.param().abi(), dwtype, pvdata, cbdata, dwflags) }
}
#[inline]
pub unsafe fn SHRegWriteUSValueW<P1>(huskey: isize, pwzvalue: P1, dwtype: u32, pvdata: *const core::ffi::c_void, cbdata: u32, dwflags: u32) -> super::super::Foundation::WIN32_ERROR
where
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn SHRegWriteUSValueW(huskey : isize, pwzvalue : windows_core::PCWSTR, dwtype : u32, pvdata : *const core::ffi::c_void, cbdata : u32, dwflags : u32) -> super::super::Foundation:: WIN32_ERROR);
    unsafe { SHRegWriteUSValueW(huskey, pwzvalue.param().abi(), dwtype, pvdata, cbdata, dwflags) }
}
#[inline]
pub unsafe fn SHReleaseThreadRef() -> windows_core::Result<()> {
    windows_core::link!("shlwapi.dll" "system" fn SHReleaseThreadRef() -> windows_core::HRESULT);
    unsafe { SHReleaseThreadRef().ok() }
}
#[inline]
pub unsafe fn SHRemoveLocalizedName<P0>(pszpath: P0) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shell32.dll" "system" fn SHRemoveLocalizedName(pszpath : windows_core::PCWSTR) -> windows_core::HRESULT);
    unsafe { SHRemoveLocalizedName(pszpath.param().abi()).ok() }
}
#[cfg(feature = "Win32_UI_Controls")]
#[inline]
pub unsafe fn SHReplaceFromPropSheetExtArray(hpsxa: HPSXA, upageid: u32, lpfnreplacewith: super::Controls::LPFNSVADDPROPSHEETPAGE, lparam: super::super::Foundation::LPARAM) -> u32 {
    windows_core::link!("shell32.dll" "system" fn SHReplaceFromPropSheetExtArray(hpsxa : HPSXA, upageid : u32, lpfnreplacewith : super::Controls:: LPFNSVADDPROPSHEETPAGE, lparam : super::super::Foundation:: LPARAM) -> u32);
    unsafe { SHReplaceFromPropSheetExtArray(hpsxa, upageid, lpfnreplacewith, lparam) }
}
#[inline]
pub unsafe fn SHResolveLibrary<P0>(psilibrary: P0) -> windows_core::Result<()>
where
    P0: windows_core::Param<IShellItem>,
{
    windows_core::link!("shell32.dll" "system" fn SHResolveLibrary(psilibrary : * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe { SHResolveLibrary(psilibrary.param().abi()).ok() }
}
#[inline]
pub unsafe fn SHRestricted(rest: RESTRICTIONS) -> u32 {
    windows_core::link!("shell32.dll" "system" fn SHRestricted(rest : RESTRICTIONS) -> u32);
    unsafe { SHRestricted(rest) }
}
#[inline]
pub unsafe fn SHSendMessageBroadcastA(umsg: u32, wparam: super::super::Foundation::WPARAM, lparam: super::super::Foundation::LPARAM) -> super::super::Foundation::LRESULT {
    windows_core::link!("shlwapi.dll" "system" fn SHSendMessageBroadcastA(umsg : u32, wparam : super::super::Foundation:: WPARAM, lparam : super::super::Foundation:: LPARAM) -> super::super::Foundation:: LRESULT);
    unsafe { SHSendMessageBroadcastA(umsg, wparam, lparam) }
}
#[inline]
pub unsafe fn SHSendMessageBroadcastW(umsg: u32, wparam: super::super::Foundation::WPARAM, lparam: super::super::Foundation::LPARAM) -> super::super::Foundation::LRESULT {
    windows_core::link!("shlwapi.dll" "system" fn SHSendMessageBroadcastW(umsg : u32, wparam : super::super::Foundation:: WPARAM, lparam : super::super::Foundation:: LPARAM) -> super::super::Foundation:: LRESULT);
    unsafe { SHSendMessageBroadcastW(umsg, wparam, lparam) }
}
#[inline]
pub unsafe fn SHSetDefaultProperties<P1, P3>(hwnd: Option<super::super::Foundation::HWND>, psi: P1, dwfileopflags: u32, pfops: P3) -> windows_core::Result<()>
where
    P1: windows_core::Param<IShellItem>,
    P3: windows_core::Param<IFileOperationProgressSink>,
{
    windows_core::link!("shell32.dll" "system" fn SHSetDefaultProperties(hwnd : super::super::Foundation:: HWND, psi : * mut core::ffi::c_void, dwfileopflags : u32, pfops : * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe { SHSetDefaultProperties(hwnd.unwrap_or(core::mem::zeroed()) as _, psi.param().abi(), dwfileopflags, pfops.param().abi()).ok() }
}
#[inline]
pub unsafe fn SHSetFolderPathA<P3>(csidl: i32, htoken: Option<super::super::Foundation::HANDLE>, dwflags: u32, pszpath: P3) -> windows_core::Result<()>
where
    P3: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shell32.dll" "system" fn SHSetFolderPathA(csidl : i32, htoken : super::super::Foundation:: HANDLE, dwflags : u32, pszpath : windows_core::PCSTR) -> windows_core::HRESULT);
    unsafe { SHSetFolderPathA(csidl, htoken.unwrap_or(core::mem::zeroed()) as _, dwflags, pszpath.param().abi()).ok() }
}
#[inline]
pub unsafe fn SHSetFolderPathW<P3>(csidl: i32, htoken: Option<super::super::Foundation::HANDLE>, dwflags: u32, pszpath: P3) -> windows_core::Result<()>
where
    P3: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shell32.dll" "system" fn SHSetFolderPathW(csidl : i32, htoken : super::super::Foundation:: HANDLE, dwflags : u32, pszpath : windows_core::PCWSTR) -> windows_core::HRESULT);
    unsafe { SHSetFolderPathW(csidl, htoken.unwrap_or(core::mem::zeroed()) as _, dwflags, pszpath.param().abi()).ok() }
}
#[inline]
pub unsafe fn SHSetInstanceExplorer<P0>(punk: P0)
where
    P0: windows_core::Param<windows_core::IUnknown>,
{
    windows_core::link!("shell32.dll" "system" fn SHSetInstanceExplorer(punk : * mut core::ffi::c_void));
    unsafe { SHSetInstanceExplorer(punk.param().abi()) }
}
#[inline]
pub unsafe fn SHSetKnownFolderPath<P3>(rfid: *const windows_core::GUID, dwflags: u32, htoken: Option<super::super::Foundation::HANDLE>, pszpath: P3) -> windows_core::Result<()>
where
    P3: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shell32.dll" "system" fn SHSetKnownFolderPath(rfid : *const windows_core::GUID, dwflags : u32, htoken : super::super::Foundation:: HANDLE, pszpath : windows_core::PCWSTR) -> windows_core::HRESULT);
    unsafe { SHSetKnownFolderPath(rfid, dwflags, htoken.unwrap_or(core::mem::zeroed()) as _, pszpath.param().abi()).ok() }
}
#[inline]
pub unsafe fn SHSetLocalizedName<P0, P1>(pszpath: P0, pszresmodule: P1, idsres: i32) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shell32.dll" "system" fn SHSetLocalizedName(pszpath : windows_core::PCWSTR, pszresmodule : windows_core::PCWSTR, idsres : i32) -> windows_core::HRESULT);
    unsafe { SHSetLocalizedName(pszpath.param().abi(), pszresmodule.param().abi(), idsres).ok() }
}
#[cfg(all(feature = "Win32_System_Com_StructuredStorage", feature = "Win32_System_Variant"))]
#[inline]
pub unsafe fn SHSetTemporaryPropertyForItem<P0>(psi: P0, propkey: *const super::super::Foundation::PROPERTYKEY, propvar: *const super::super::System::Com::StructuredStorage::PROPVARIANT) -> windows_core::Result<()>
where
    P0: windows_core::Param<IShellItem>,
{
    windows_core::link!("shell32.dll" "system" fn SHSetTemporaryPropertyForItem(psi : * mut core::ffi::c_void, propkey : *const super::super::Foundation:: PROPERTYKEY, propvar : *const super::super::System::Com::StructuredStorage:: PROPVARIANT) -> windows_core::HRESULT);
    unsafe { SHSetTemporaryPropertyForItem(psi.param().abi(), propkey, core::mem::transmute(propvar)).ok() }
}
#[inline]
pub unsafe fn SHSetThreadRef<P0>(punk: P0) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::IUnknown>,
{
    windows_core::link!("shlwapi.dll" "system" fn SHSetThreadRef(punk : * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe { SHSetThreadRef(punk.param().abi()).ok() }
}
#[inline]
pub unsafe fn SHSetUnreadMailCountW<P0, P2>(pszmailaddress: P0, dwcount: u32, pszshellexecutecommand: P2) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P2: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shell32.dll" "system" fn SHSetUnreadMailCountW(pszmailaddress : windows_core::PCWSTR, dwcount : u32, pszshellexecutecommand : windows_core::PCWSTR) -> windows_core::HRESULT);
    unsafe { SHSetUnreadMailCountW(pszmailaddress.param().abi(), dwcount, pszshellexecutecommand.param().abi()).ok() }
}
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn SHSetValueA<P1, P2>(hkey: super::super::System::Registry::HKEY, pszsubkey: P1, pszvalue: P2, dwtype: u32, pvdata: Option<*const core::ffi::c_void>, cbdata: u32) -> i32
where
    P1: windows_core::Param<windows_core::PCSTR>,
    P2: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn SHSetValueA(hkey : super::super::System::Registry:: HKEY, pszsubkey : windows_core::PCSTR, pszvalue : windows_core::PCSTR, dwtype : u32, pvdata : *const core::ffi::c_void, cbdata : u32) -> i32);
    unsafe { SHSetValueA(hkey, pszsubkey.param().abi(), pszvalue.param().abi(), dwtype, pvdata.unwrap_or(core::mem::zeroed()) as _, cbdata) }
}
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn SHSetValueW<P1, P2>(hkey: super::super::System::Registry::HKEY, pszsubkey: P1, pszvalue: P2, dwtype: u32, pvdata: Option<*const core::ffi::c_void>, cbdata: u32) -> i32
where
    P1: windows_core::Param<windows_core::PCWSTR>,
    P2: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn SHSetValueW(hkey : super::super::System::Registry:: HKEY, pszsubkey : windows_core::PCWSTR, pszvalue : windows_core::PCWSTR, dwtype : u32, pvdata : *const core::ffi::c_void, cbdata : u32) -> i32);
    unsafe { SHSetValueW(hkey, pszsubkey.param().abi(), pszvalue.param().abi(), dwtype, pvdata.unwrap_or(core::mem::zeroed()) as _, cbdata) }
}
#[inline]
pub unsafe fn SHShellFolderView_Message(hwndmain: super::super::Foundation::HWND, umsg: u32, lparam: super::super::Foundation::LPARAM) -> super::super::Foundation::LRESULT {
    windows_core::link!("shell32.dll" "system" fn SHShellFolderView_Message(hwndmain : super::super::Foundation:: HWND, umsg : u32, lparam : super::super::Foundation:: LPARAM) -> super::super::Foundation:: LRESULT);
    unsafe { SHShellFolderView_Message(hwndmain, umsg, lparam) }
}
#[inline]
pub unsafe fn SHShowManageLibraryUI<P0, P2, P3>(psilibrary: P0, hwndowner: super::super::Foundation::HWND, psztitle: P2, pszinstruction: P3, lmdoptions: LIBRARYMANAGEDIALOGOPTIONS) -> windows_core::Result<()>
where
    P0: windows_core::Param<IShellItem>,
    P2: windows_core::Param<windows_core::PCWSTR>,
    P3: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shell32.dll" "system" fn SHShowManageLibraryUI(psilibrary : * mut core::ffi::c_void, hwndowner : super::super::Foundation:: HWND, psztitle : windows_core::PCWSTR, pszinstruction : windows_core::PCWSTR, lmdoptions : LIBRARYMANAGEDIALOGOPTIONS) -> windows_core::HRESULT);
    unsafe { SHShowManageLibraryUI(psilibrary.param().abi(), hwndowner, psztitle.param().abi(), pszinstruction.param().abi(), lmdoptions).ok() }
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn SHSimpleIDListFromPath<P0>(pszpath: P0) -> *mut Common::ITEMIDLIST
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shell32.dll" "system" fn SHSimpleIDListFromPath(pszpath : windows_core::PCWSTR) -> *mut Common:: ITEMIDLIST);
    unsafe { SHSimpleIDListFromPath(pszpath.param().abi()) }
}
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn SHSkipJunction<P0>(pbc: P0, pclsid: *const windows_core::GUID) -> windows_core::BOOL
where
    P0: windows_core::Param<super::super::System::Com::IBindCtx>,
{
    windows_core::link!("shlwapi.dll" "system" fn SHSkipJunction(pbc : * mut core::ffi::c_void, pclsid : *const windows_core::GUID) -> windows_core::BOOL);
    unsafe { SHSkipJunction(pbc.param().abi(), pclsid) }
}
#[inline]
pub unsafe fn SHStartNetConnectionDialogW<P1>(hwnd: Option<super::super::Foundation::HWND>, pszremotename: P1, dwtype: u32) -> windows_core::Result<()>
where
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shell32.dll" "system" fn SHStartNetConnectionDialogW(hwnd : super::super::Foundation:: HWND, pszremotename : windows_core::PCWSTR, dwtype : u32) -> windows_core::HRESULT);
    unsafe { SHStartNetConnectionDialogW(hwnd.unwrap_or(core::mem::zeroed()) as _, pszremotename.param().abi(), dwtype).ok() }
}
#[inline]
pub unsafe fn SHStrDupA<P0>(psz: P0) -> windows_core::Result<windows_core::PWSTR>
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn SHStrDupA(psz : windows_core::PCSTR, ppwsz : *mut windows_core::PWSTR) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        SHStrDupA(psz.param().abi(), &mut result__).map(|| result__)
    }
}
#[inline]
pub unsafe fn SHStrDupW<P0>(psz: P0) -> windows_core::Result<windows_core::PWSTR>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn SHStrDupW(psz : windows_core::PCWSTR, ppwsz : *mut windows_core::PWSTR) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        SHStrDupW(psz.param().abi(), &mut result__).map(|| result__)
    }
}
#[inline]
pub unsafe fn SHStripMneumonicA(pszmenu: windows_core::PSTR) -> i8 {
    windows_core::link!("shlwapi.dll" "system" fn SHStripMneumonicA(pszmenu : windows_core::PSTR) -> i8);
    unsafe { SHStripMneumonicA(core::mem::transmute(pszmenu)) }
}
#[inline]
pub unsafe fn SHStripMneumonicW(pszmenu: windows_core::PWSTR) -> u16 {
    windows_core::link!("shlwapi.dll" "system" fn SHStripMneumonicW(pszmenu : windows_core::PWSTR) -> u16);
    unsafe { SHStripMneumonicW(core::mem::transmute(pszmenu)) }
}
#[inline]
pub unsafe fn SHTestTokenMembership(htoken: Option<super::super::Foundation::HANDLE>, ulrid: u32) -> windows_core::BOOL {
    windows_core::link!("shell32.dll" "system" fn SHTestTokenMembership(htoken : super::super::Foundation:: HANDLE, ulrid : u32) -> windows_core::BOOL);
    unsafe { SHTestTokenMembership(htoken.unwrap_or(core::mem::zeroed()) as _, ulrid) }
}
#[inline]
pub unsafe fn SHUnicodeToAnsi<P0>(pwszsrc: P0, pszdst: &mut [u8]) -> i32
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn SHUnicodeToAnsi(pwszsrc : windows_core::PCWSTR, pszdst : windows_core::PSTR, cchbuf : i32) -> i32);
    unsafe { SHUnicodeToAnsi(pwszsrc.param().abi(), core::mem::transmute(pszdst.as_ptr()), pszdst.len().try_into().unwrap()) }
}
#[inline]
pub unsafe fn SHUnicodeToUnicode<P0>(pwzsrc: P0, pwzdst: &mut [u16]) -> i32
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn SHUnicodeToUnicode(pwzsrc : windows_core::PCWSTR, pwzdst : windows_core::PWSTR, cwchbuf : i32) -> i32);
    unsafe { SHUnicodeToUnicode(pwzsrc.param().abi(), core::mem::transmute(pwzdst.as_ptr()), pwzdst.len().try_into().unwrap()) }
}
#[inline]
pub unsafe fn SHUnlockShared(pvdata: *const core::ffi::c_void) -> windows_core::Result<()> {
    windows_core::link!("shlwapi.dll" "system" fn SHUnlockShared(pvdata : *const core::ffi::c_void) -> windows_core::BOOL);
    unsafe { SHUnlockShared(pvdata).ok() }
}
#[inline]
pub unsafe fn SHUpdateImageA<P0>(pszhashitem: P0, iindex: i32, uflags: u32, iimageindex: i32)
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shell32.dll" "system" fn SHUpdateImageA(pszhashitem : windows_core::PCSTR, iindex : i32, uflags : u32, iimageindex : i32));
    unsafe { SHUpdateImageA(pszhashitem.param().abi(), iindex, uflags, iimageindex) }
}
#[inline]
pub unsafe fn SHUpdateImageW<P0>(pszhashitem: P0, iindex: i32, uflags: u32, iimageindex: i32)
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shell32.dll" "system" fn SHUpdateImageW(pszhashitem : windows_core::PCWSTR, iindex : i32, uflags : u32, iimageindex : i32));
    unsafe { SHUpdateImageW(pszhashitem.param().abi(), iindex, uflags, iimageindex) }
}
#[inline]
pub unsafe fn SHValidateUNC(hwndowner: Option<super::super::Foundation::HWND>, pszfile: windows_core::PWSTR, fconnect: VALIDATEUNC_OPTION) -> windows_core::BOOL {
    windows_core::link!("shell32.dll" "system" fn SHValidateUNC(hwndowner : super::super::Foundation:: HWND, pszfile : windows_core::PWSTR, fconnect : u32) -> windows_core::BOOL);
    unsafe { SHValidateUNC(hwndowner.unwrap_or(core::mem::zeroed()) as _, core::mem::transmute(pszfile), fconnect.0 as _) }
}
#[inline]
pub unsafe fn SetCurrentProcessExplicitAppUserModelID<P0>(appid: P0) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shell32.dll" "system" fn SetCurrentProcessExplicitAppUserModelID(appid : windows_core::PCWSTR) -> windows_core::HRESULT);
    unsafe { SetCurrentProcessExplicitAppUserModelID(appid.param().abi()).ok() }
}
#[cfg(feature = "Win32_UI_WindowsAndMessaging")]
#[inline]
pub unsafe fn SetMenuContextHelpId(param0: super::WindowsAndMessaging::HMENU, param1: u32) -> windows_core::Result<()> {
    windows_core::link!("user32.dll" "system" fn SetMenuContextHelpId(param0 : super::WindowsAndMessaging:: HMENU, param1 : u32) -> windows_core::BOOL);
    unsafe { SetMenuContextHelpId(param0, param1).ok() }
}
#[inline]
pub unsafe fn SetWindowContextHelpId(param0: super::super::Foundation::HWND, param1: u32) -> windows_core::Result<()> {
    windows_core::link!("user32.dll" "system" fn SetWindowContextHelpId(param0 : super::super::Foundation:: HWND, param1 : u32) -> windows_core::BOOL);
    unsafe { SetWindowContextHelpId(param0, param1).ok() }
}
#[inline]
pub unsafe fn SetWindowSubclass(hwnd: super::super::Foundation::HWND, pfnsubclass: SUBCLASSPROC, uidsubclass: usize, dwrefdata: usize) -> windows_core::BOOL {
    windows_core::link!("comctl32.dll" "system" fn SetWindowSubclass(hwnd : super::super::Foundation:: HWND, pfnsubclass : SUBCLASSPROC, uidsubclass : usize, dwrefdata : usize) -> windows_core::BOOL);
    unsafe { SetWindowSubclass(hwnd, pfnsubclass, uidsubclass, dwrefdata) }
}
#[cfg(feature = "Win32_UI_WindowsAndMessaging")]
#[inline]
pub unsafe fn ShellAboutA<P1, P2>(hwnd: Option<super::super::Foundation::HWND>, szapp: P1, szotherstuff: P2, hicon: Option<super::WindowsAndMessaging::HICON>) -> i32
where
    P1: windows_core::Param<windows_core::PCSTR>,
    P2: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shell32.dll" "system" fn ShellAboutA(hwnd : super::super::Foundation:: HWND, szapp : windows_core::PCSTR, szotherstuff : windows_core::PCSTR, hicon : super::WindowsAndMessaging:: HICON) -> i32);
    unsafe { ShellAboutA(hwnd.unwrap_or(core::mem::zeroed()) as _, szapp.param().abi(), szotherstuff.param().abi(), hicon.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(feature = "Win32_UI_WindowsAndMessaging")]
#[inline]
pub unsafe fn ShellAboutW<P1, P2>(hwnd: Option<super::super::Foundation::HWND>, szapp: P1, szotherstuff: P2, hicon: Option<super::WindowsAndMessaging::HICON>) -> i32
where
    P1: windows_core::Param<windows_core::PCWSTR>,
    P2: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shell32.dll" "system" fn ShellAboutW(hwnd : super::super::Foundation:: HWND, szapp : windows_core::PCWSTR, szotherstuff : windows_core::PCWSTR, hicon : super::WindowsAndMessaging:: HICON) -> i32);
    unsafe { ShellAboutW(hwnd.unwrap_or(core::mem::zeroed()) as _, szapp.param().abi(), szotherstuff.param().abi(), hicon.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(feature = "Win32_UI_WindowsAndMessaging")]
#[inline]
pub unsafe fn ShellExecuteA<P1, P2, P3, P4>(hwnd: Option<super::super::Foundation::HWND>, lpoperation: P1, lpfile: P2, lpparameters: P3, lpdirectory: P4, nshowcmd: super::WindowsAndMessaging::SHOW_WINDOW_CMD) -> super::super::Foundation::HINSTANCE
where
    P1: windows_core::Param<windows_core::PCSTR>,
    P2: windows_core::Param<windows_core::PCSTR>,
    P3: windows_core::Param<windows_core::PCSTR>,
    P4: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shell32.dll" "system" fn ShellExecuteA(hwnd : super::super::Foundation:: HWND, lpoperation : windows_core::PCSTR, lpfile : windows_core::PCSTR, lpparameters : windows_core::PCSTR, lpdirectory : windows_core::PCSTR, nshowcmd : super::WindowsAndMessaging:: SHOW_WINDOW_CMD) -> super::super::Foundation:: HINSTANCE);
    unsafe { ShellExecuteA(hwnd.unwrap_or(core::mem::zeroed()) as _, lpoperation.param().abi(), lpfile.param().abi(), lpparameters.param().abi(), lpdirectory.param().abi(), nshowcmd) }
}
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn ShellExecuteExA(pexecinfo: *mut SHELLEXECUTEINFOA) -> windows_core::Result<()> {
    windows_core::link!("shell32.dll" "system" fn ShellExecuteExA(pexecinfo : *mut SHELLEXECUTEINFOA) -> windows_core::BOOL);
    unsafe { ShellExecuteExA(pexecinfo as _).ok() }
}
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn ShellExecuteExW(pexecinfo: *mut SHELLEXECUTEINFOW) -> windows_core::Result<()> {
    windows_core::link!("shell32.dll" "system" fn ShellExecuteExW(pexecinfo : *mut SHELLEXECUTEINFOW) -> windows_core::BOOL);
    unsafe { ShellExecuteExW(pexecinfo as _).ok() }
}
#[cfg(feature = "Win32_UI_WindowsAndMessaging")]
#[inline]
pub unsafe fn ShellExecuteW<P1, P2, P3, P4>(hwnd: Option<super::super::Foundation::HWND>, lpoperation: P1, lpfile: P2, lpparameters: P3, lpdirectory: P4, nshowcmd: super::WindowsAndMessaging::SHOW_WINDOW_CMD) -> super::super::Foundation::HINSTANCE
where
    P1: windows_core::Param<windows_core::PCWSTR>,
    P2: windows_core::Param<windows_core::PCWSTR>,
    P3: windows_core::Param<windows_core::PCWSTR>,
    P4: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shell32.dll" "system" fn ShellExecuteW(hwnd : super::super::Foundation:: HWND, lpoperation : windows_core::PCWSTR, lpfile : windows_core::PCWSTR, lpparameters : windows_core::PCWSTR, lpdirectory : windows_core::PCWSTR, nshowcmd : super::WindowsAndMessaging:: SHOW_WINDOW_CMD) -> super::super::Foundation:: HINSTANCE);
    unsafe { ShellExecuteW(hwnd.unwrap_or(core::mem::zeroed()) as _, lpoperation.param().abi(), lpfile.param().abi(), lpparameters.param().abi(), lpdirectory.param().abi(), nshowcmd) }
}
#[cfg(feature = "Win32_UI_WindowsAndMessaging")]
#[inline]
pub unsafe fn ShellMessageBoxA<P2, P3>(happinst: Option<super::super::Foundation::HINSTANCE>, hwnd: Option<super::super::Foundation::HWND>, lpctext: P2, lpctitle: P3, fustyle: super::WindowsAndMessaging::MESSAGEBOX_STYLE) -> i32
where
    P2: windows_core::Param<windows_core::PCSTR>,
    P3: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "C" fn ShellMessageBoxA(happinst : super::super::Foundation:: HINSTANCE, hwnd : super::super::Foundation:: HWND, lpctext : windows_core::PCSTR, lpctitle : windows_core::PCSTR, fustyle : super::WindowsAndMessaging:: MESSAGEBOX_STYLE) -> i32);
    unsafe { ShellMessageBoxA(happinst.unwrap_or(core::mem::zeroed()) as _, hwnd.unwrap_or(core::mem::zeroed()) as _, lpctext.param().abi(), lpctitle.param().abi(), fustyle) }
}
#[cfg(feature = "Win32_UI_WindowsAndMessaging")]
#[inline]
pub unsafe fn ShellMessageBoxW<P2, P3>(happinst: Option<super::super::Foundation::HINSTANCE>, hwnd: Option<super::super::Foundation::HWND>, lpctext: P2, lpctitle: P3, fustyle: super::WindowsAndMessaging::MESSAGEBOX_STYLE) -> i32
where
    P2: windows_core::Param<windows_core::PCWSTR>,
    P3: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "C" fn ShellMessageBoxW(happinst : super::super::Foundation:: HINSTANCE, hwnd : super::super::Foundation:: HWND, lpctext : windows_core::PCWSTR, lpctitle : windows_core::PCWSTR, fustyle : super::WindowsAndMessaging:: MESSAGEBOX_STYLE) -> i32);
    unsafe { ShellMessageBoxW(happinst.unwrap_or(core::mem::zeroed()) as _, hwnd.unwrap_or(core::mem::zeroed()) as _, lpctext.param().abi(), lpctitle.param().abi(), fustyle) }
}
#[inline]
pub unsafe fn Shell_GetCachedImageIndex<P0>(pwsziconpath: P0, iiconindex: i32, uiconflags: u32) -> i32
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shell32.dll" "system" fn Shell_GetCachedImageIndex(pwsziconpath : windows_core::PCWSTR, iiconindex : i32, uiconflags : u32) -> i32);
    unsafe { Shell_GetCachedImageIndex(pwsziconpath.param().abi(), iiconindex, uiconflags) }
}
#[inline]
pub unsafe fn Shell_GetCachedImageIndexA<P0>(psziconpath: P0, iiconindex: i32, uiconflags: u32) -> i32
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shell32.dll" "system" fn Shell_GetCachedImageIndexA(psziconpath : windows_core::PCSTR, iiconindex : i32, uiconflags : u32) -> i32);
    unsafe { Shell_GetCachedImageIndexA(psziconpath.param().abi(), iiconindex, uiconflags) }
}
#[inline]
pub unsafe fn Shell_GetCachedImageIndexW<P0>(psziconpath: P0, iiconindex: i32, uiconflags: u32) -> i32
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shell32.dll" "system" fn Shell_GetCachedImageIndexW(psziconpath : windows_core::PCWSTR, iiconindex : i32, uiconflags : u32) -> i32);
    unsafe { Shell_GetCachedImageIndexW(psziconpath.param().abi(), iiconindex, uiconflags) }
}
#[cfg(feature = "Win32_UI_Controls")]
#[inline]
pub unsafe fn Shell_GetImageLists(phiml: Option<*mut super::Controls::HIMAGELIST>, phimlsmall: Option<*mut super::Controls::HIMAGELIST>) -> windows_core::BOOL {
    windows_core::link!("shell32.dll" "system" fn Shell_GetImageLists(phiml : *mut super::Controls:: HIMAGELIST, phimlsmall : *mut super::Controls:: HIMAGELIST) -> windows_core::BOOL);
    unsafe { Shell_GetImageLists(phiml.unwrap_or(core::mem::zeroed()) as _, phimlsmall.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(feature = "Win32_UI_WindowsAndMessaging")]
#[inline]
pub unsafe fn Shell_MergeMenus(hmdst: super::WindowsAndMessaging::HMENU, hmsrc: super::WindowsAndMessaging::HMENU, uinsert: u32, uidadjust: u32, uidadjustmax: u32, uflags: MM_FLAGS) -> u32 {
    windows_core::link!("shell32.dll" "system" fn Shell_MergeMenus(hmdst : super::WindowsAndMessaging:: HMENU, hmsrc : super::WindowsAndMessaging:: HMENU, uinsert : u32, uidadjust : u32, uidadjustmax : u32, uflags : MM_FLAGS) -> u32);
    unsafe { Shell_MergeMenus(hmdst, hmsrc, uinsert, uidadjust, uidadjustmax, uflags) }
}
#[cfg(feature = "Win32_UI_WindowsAndMessaging")]
#[inline]
pub unsafe fn Shell_NotifyIconA(dwmessage: NOTIFY_ICON_MESSAGE, lpdata: *const NOTIFYICONDATAA) -> windows_core::BOOL {
    windows_core::link!("shell32.dll" "system" fn Shell_NotifyIconA(dwmessage : NOTIFY_ICON_MESSAGE, lpdata : *const NOTIFYICONDATAA) -> windows_core::BOOL);
    unsafe { Shell_NotifyIconA(dwmessage, lpdata) }
}
#[inline]
pub unsafe fn Shell_NotifyIconGetRect(identifier: *const NOTIFYICONIDENTIFIER) -> windows_core::Result<super::super::Foundation::RECT> {
    windows_core::link!("shell32.dll" "system" fn Shell_NotifyIconGetRect(identifier : *const NOTIFYICONIDENTIFIER, iconlocation : *mut super::super::Foundation:: RECT) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        Shell_NotifyIconGetRect(identifier, &mut result__).map(|| result__)
    }
}
#[cfg(feature = "Win32_UI_WindowsAndMessaging")]
#[inline]
pub unsafe fn Shell_NotifyIconW(dwmessage: NOTIFY_ICON_MESSAGE, lpdata: *const NOTIFYICONDATAW) -> windows_core::BOOL {
    windows_core::link!("shell32.dll" "system" fn Shell_NotifyIconW(dwmessage : NOTIFY_ICON_MESSAGE, lpdata : *const NOTIFYICONDATAW) -> windows_core::BOOL);
    unsafe { Shell_NotifyIconW(dwmessage, lpdata) }
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn SignalFileOpen(pidl: *const Common::ITEMIDLIST) -> windows_core::BOOL {
    windows_core::link!("shell32.dll" "system" fn SignalFileOpen(pidl : *const Common:: ITEMIDLIST) -> windows_core::BOOL);
    unsafe { SignalFileOpen(pidl) }
}
#[cfg(feature = "Win32_System_Com_Urlmon")]
#[inline]
pub unsafe fn SoftwareUpdateMessageBox<P1>(hwnd: Option<super::super::Foundation::HWND>, pszdistunit: P1, dwflags: u32, psdi: Option<*mut super::super::System::Com::Urlmon::SOFTDISTINFO>) -> u32
where
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shdocvw.dll" "system" fn SoftwareUpdateMessageBox(hwnd : super::super::Foundation:: HWND, pszdistunit : windows_core::PCWSTR, dwflags : u32, psdi : *mut super::super::System::Com::Urlmon:: SOFTDISTINFO) -> u32);
    unsafe { SoftwareUpdateMessageBox(hwnd.unwrap_or(core::mem::zeroed()) as _, pszdistunit.param().abi(), dwflags, psdi.unwrap_or(core::mem::zeroed()) as _) }
}
#[cfg(feature = "Win32_System_Com_StructuredStorage")]
#[inline]
pub unsafe fn StgMakeUniqueName<P0, P1, T>(pstgparent: P0, pszfilespec: P1, grfmode: u32) -> windows_core::Result<T>
where
    P0: windows_core::Param<super::super::System::Com::StructuredStorage::IStorage>,
    P1: windows_core::Param<windows_core::PCWSTR>,
    T: windows_core::Interface,
{
    windows_core::link!("shell32.dll" "system" fn StgMakeUniqueName(pstgparent : * mut core::ffi::c_void, pszfilespec : windows_core::PCWSTR, grfmode : u32, riid : *const windows_core::GUID, ppv : *mut *mut core::ffi::c_void) -> windows_core::HRESULT);
    let mut result__ = core::ptr::null_mut();
    unsafe { StgMakeUniqueName(pstgparent.param().abi(), pszfilespec.param().abi(), grfmode, &T::IID, &mut result__).and_then(|| windows_core::Type::from_abi(result__)) }
}
#[inline]
pub unsafe fn StrCSpnA<P0, P1>(pszstr: P0, pszset: P1) -> i32
where
    P0: windows_core::Param<windows_core::PCSTR>,
    P1: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn StrCSpnA(pszstr : windows_core::PCSTR, pszset : windows_core::PCSTR) -> i32);
    unsafe { StrCSpnA(pszstr.param().abi(), pszset.param().abi()) }
}
#[inline]
pub unsafe fn StrCSpnIA<P0, P1>(pszstr: P0, pszset: P1) -> i32
where
    P0: windows_core::Param<windows_core::PCSTR>,
    P1: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn StrCSpnIA(pszstr : windows_core::PCSTR, pszset : windows_core::PCSTR) -> i32);
    unsafe { StrCSpnIA(pszstr.param().abi(), pszset.param().abi()) }
}
#[inline]
pub unsafe fn StrCSpnIW<P0, P1>(pszstr: P0, pszset: P1) -> i32
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn StrCSpnIW(pszstr : windows_core::PCWSTR, pszset : windows_core::PCWSTR) -> i32);
    unsafe { StrCSpnIW(pszstr.param().abi(), pszset.param().abi()) }
}
#[inline]
pub unsafe fn StrCSpnW<P0, P1>(pszstr: P0, pszset: P1) -> i32
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn StrCSpnW(pszstr : windows_core::PCWSTR, pszset : windows_core::PCWSTR) -> i32);
    unsafe { StrCSpnW(pszstr.param().abi(), pszset.param().abi()) }
}
#[inline]
pub unsafe fn StrCatBuffA<P1>(pszdest: &mut [u8], pszsrc: P1) -> windows_core::PSTR
where
    P1: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn StrCatBuffA(pszdest : windows_core::PSTR, pszsrc : windows_core::PCSTR, cchdestbuffsize : i32) -> windows_core::PSTR);
    unsafe { StrCatBuffA(core::mem::transmute(pszdest.as_ptr()), pszsrc.param().abi(), pszdest.len().try_into().unwrap()) }
}
#[inline]
pub unsafe fn StrCatBuffW<P1>(pszdest: &mut [u16], pszsrc: P1) -> windows_core::PWSTR
where
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn StrCatBuffW(pszdest : windows_core::PWSTR, pszsrc : windows_core::PCWSTR, cchdestbuffsize : i32) -> windows_core::PWSTR);
    unsafe { StrCatBuffW(core::mem::transmute(pszdest.as_ptr()), pszsrc.param().abi(), pszdest.len().try_into().unwrap()) }
}
#[inline]
pub unsafe fn StrCatChainW<P3>(pszdst: &mut [u16], ichat: u32, pszsrc: P3) -> u32
where
    P3: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn StrCatChainW(pszdst : windows_core::PWSTR, cchdst : u32, ichat : u32, pszsrc : windows_core::PCWSTR) -> u32);
    unsafe { StrCatChainW(core::mem::transmute(pszdst.as_ptr()), pszdst.len().try_into().unwrap(), ichat, pszsrc.param().abi()) }
}
#[inline]
pub unsafe fn StrCatW<P1>(psz1: windows_core::PWSTR, psz2: P1) -> windows_core::PWSTR
where
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn StrCatW(psz1 : windows_core::PWSTR, psz2 : windows_core::PCWSTR) -> windows_core::PWSTR);
    unsafe { StrCatW(core::mem::transmute(psz1), psz2.param().abi()) }
}
#[inline]
pub unsafe fn StrChrA<P0>(pszstart: P0, wmatch: u16) -> windows_core::PSTR
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn StrChrA(pszstart : windows_core::PCSTR, wmatch : u16) -> windows_core::PSTR);
    unsafe { StrChrA(pszstart.param().abi(), wmatch) }
}
#[inline]
pub unsafe fn StrChrIA<P0>(pszstart: P0, wmatch: u16) -> windows_core::PSTR
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn StrChrIA(pszstart : windows_core::PCSTR, wmatch : u16) -> windows_core::PSTR);
    unsafe { StrChrIA(pszstart.param().abi(), wmatch) }
}
#[inline]
pub unsafe fn StrChrIW<P0>(pszstart: P0, wmatch: u16) -> windows_core::PWSTR
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn StrChrIW(pszstart : windows_core::PCWSTR, wmatch : u16) -> windows_core::PWSTR);
    unsafe { StrChrIW(pszstart.param().abi(), wmatch) }
}
#[inline]
pub unsafe fn StrChrNIW<P0>(pszstart: P0, wmatch: u16, cchmax: u32) -> windows_core::PWSTR
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn StrChrNIW(pszstart : windows_core::PCWSTR, wmatch : u16, cchmax : u32) -> windows_core::PWSTR);
    unsafe { StrChrNIW(pszstart.param().abi(), wmatch, cchmax) }
}
#[inline]
pub unsafe fn StrChrNW<P0>(pszstart: P0, wmatch: u16, cchmax: u32) -> windows_core::PWSTR
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn StrChrNW(pszstart : windows_core::PCWSTR, wmatch : u16, cchmax : u32) -> windows_core::PWSTR);
    unsafe { StrChrNW(pszstart.param().abi(), wmatch, cchmax) }
}
#[inline]
pub unsafe fn StrChrW<P0>(pszstart: P0, wmatch: u16) -> windows_core::PWSTR
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn StrChrW(pszstart : windows_core::PCWSTR, wmatch : u16) -> windows_core::PWSTR);
    unsafe { StrChrW(pszstart.param().abi(), wmatch) }
}
#[inline]
pub unsafe fn StrCmpCA<P0, P1>(pszstr1: P0, pszstr2: P1) -> i32
where
    P0: windows_core::Param<windows_core::PCSTR>,
    P1: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn StrCmpCA(pszstr1 : windows_core::PCSTR, pszstr2 : windows_core::PCSTR) -> i32);
    unsafe { StrCmpCA(pszstr1.param().abi(), pszstr2.param().abi()) }
}
#[inline]
pub unsafe fn StrCmpCW<P0, P1>(pszstr1: P0, pszstr2: P1) -> i32
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn StrCmpCW(pszstr1 : windows_core::PCWSTR, pszstr2 : windows_core::PCWSTR) -> i32);
    unsafe { StrCmpCW(pszstr1.param().abi(), pszstr2.param().abi()) }
}
#[inline]
pub unsafe fn StrCmpICA<P0, P1>(pszstr1: P0, pszstr2: P1) -> i32
where
    P0: windows_core::Param<windows_core::PCSTR>,
    P1: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn StrCmpICA(pszstr1 : windows_core::PCSTR, pszstr2 : windows_core::PCSTR) -> i32);
    unsafe { StrCmpICA(pszstr1.param().abi(), pszstr2.param().abi()) }
}
#[inline]
pub unsafe fn StrCmpICW<P0, P1>(pszstr1: P0, pszstr2: P1) -> i32
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn StrCmpICW(pszstr1 : windows_core::PCWSTR, pszstr2 : windows_core::PCWSTR) -> i32);
    unsafe { StrCmpICW(pszstr1.param().abi(), pszstr2.param().abi()) }
}
#[inline]
pub unsafe fn StrCmpIW<P0, P1>(psz1: P0, psz2: P1) -> i32
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn StrCmpIW(psz1 : windows_core::PCWSTR, psz2 : windows_core::PCWSTR) -> i32);
    unsafe { StrCmpIW(psz1.param().abi(), psz2.param().abi()) }
}
#[inline]
pub unsafe fn StrCmpLogicalW<P0, P1>(psz1: P0, psz2: P1) -> i32
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn StrCmpLogicalW(psz1 : windows_core::PCWSTR, psz2 : windows_core::PCWSTR) -> i32);
    unsafe { StrCmpLogicalW(psz1.param().abi(), psz2.param().abi()) }
}
#[inline]
pub unsafe fn StrCmpNA<P0, P1>(psz1: P0, psz2: P1, nchar: i32) -> i32
where
    P0: windows_core::Param<windows_core::PCSTR>,
    P1: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn StrCmpNA(psz1 : windows_core::PCSTR, psz2 : windows_core::PCSTR, nchar : i32) -> i32);
    unsafe { StrCmpNA(psz1.param().abi(), psz2.param().abi(), nchar) }
}
#[inline]
pub unsafe fn StrCmpNCA<P0, P1>(pszstr1: P0, pszstr2: P1, nchar: i32) -> i32
where
    P0: windows_core::Param<windows_core::PCSTR>,
    P1: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn StrCmpNCA(pszstr1 : windows_core::PCSTR, pszstr2 : windows_core::PCSTR, nchar : i32) -> i32);
    unsafe { StrCmpNCA(pszstr1.param().abi(), pszstr2.param().abi(), nchar) }
}
#[inline]
pub unsafe fn StrCmpNCW<P0, P1>(pszstr1: P0, pszstr2: P1, nchar: i32) -> i32
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn StrCmpNCW(pszstr1 : windows_core::PCWSTR, pszstr2 : windows_core::PCWSTR, nchar : i32) -> i32);
    unsafe { StrCmpNCW(pszstr1.param().abi(), pszstr2.param().abi(), nchar) }
}
#[inline]
pub unsafe fn StrCmpNIA<P0, P1>(psz1: P0, psz2: P1, nchar: i32) -> i32
where
    P0: windows_core::Param<windows_core::PCSTR>,
    P1: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn StrCmpNIA(psz1 : windows_core::PCSTR, psz2 : windows_core::PCSTR, nchar : i32) -> i32);
    unsafe { StrCmpNIA(psz1.param().abi(), psz2.param().abi(), nchar) }
}
#[inline]
pub unsafe fn StrCmpNICA<P0, P1>(pszstr1: P0, pszstr2: P1, nchar: i32) -> i32
where
    P0: windows_core::Param<windows_core::PCSTR>,
    P1: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn StrCmpNICA(pszstr1 : windows_core::PCSTR, pszstr2 : windows_core::PCSTR, nchar : i32) -> i32);
    unsafe { StrCmpNICA(pszstr1.param().abi(), pszstr2.param().abi(), nchar) }
}
#[inline]
pub unsafe fn StrCmpNICW<P0, P1>(pszstr1: P0, pszstr2: P1, nchar: i32) -> i32
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn StrCmpNICW(pszstr1 : windows_core::PCWSTR, pszstr2 : windows_core::PCWSTR, nchar : i32) -> i32);
    unsafe { StrCmpNICW(pszstr1.param().abi(), pszstr2.param().abi(), nchar) }
}
#[inline]
pub unsafe fn StrCmpNIW<P0, P1>(psz1: P0, psz2: P1, nchar: i32) -> i32
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn StrCmpNIW(psz1 : windows_core::PCWSTR, psz2 : windows_core::PCWSTR, nchar : i32) -> i32);
    unsafe { StrCmpNIW(psz1.param().abi(), psz2.param().abi(), nchar) }
}
#[inline]
pub unsafe fn StrCmpNW<P0, P1>(psz1: P0, psz2: P1, nchar: i32) -> i32
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn StrCmpNW(psz1 : windows_core::PCWSTR, psz2 : windows_core::PCWSTR, nchar : i32) -> i32);
    unsafe { StrCmpNW(psz1.param().abi(), psz2.param().abi(), nchar) }
}
#[inline]
pub unsafe fn StrCmpW<P0, P1>(psz1: P0, psz2: P1) -> i32
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn StrCmpW(psz1 : windows_core::PCWSTR, psz2 : windows_core::PCWSTR) -> i32);
    unsafe { StrCmpW(psz1.param().abi(), psz2.param().abi()) }
}
#[inline]
pub unsafe fn StrCpyNW<P1>(pszdst: &mut [u16], pszsrc: P1) -> windows_core::PWSTR
where
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn StrCpyNW(pszdst : windows_core::PWSTR, pszsrc : windows_core::PCWSTR, cchmax : i32) -> windows_core::PWSTR);
    unsafe { StrCpyNW(core::mem::transmute(pszdst.as_ptr()), pszsrc.param().abi(), pszdst.len().try_into().unwrap()) }
}
#[inline]
pub unsafe fn StrCpyW<P1>(psz1: windows_core::PWSTR, psz2: P1) -> windows_core::PWSTR
where
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn StrCpyW(psz1 : windows_core::PWSTR, psz2 : windows_core::PCWSTR) -> windows_core::PWSTR);
    unsafe { StrCpyW(core::mem::transmute(psz1), psz2.param().abi()) }
}
#[inline]
pub unsafe fn StrDupA<P0>(pszsrch: P0) -> windows_core::PSTR
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn StrDupA(pszsrch : windows_core::PCSTR) -> windows_core::PSTR);
    unsafe { StrDupA(pszsrch.param().abi()) }
}
#[inline]
pub unsafe fn StrDupW<P0>(pszsrch: P0) -> windows_core::PWSTR
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn StrDupW(pszsrch : windows_core::PCWSTR) -> windows_core::PWSTR);
    unsafe { StrDupW(pszsrch.param().abi()) }
}
#[inline]
pub unsafe fn StrFormatByteSize64A(qdw: i64, pszbuf: &mut [u8]) -> windows_core::PSTR {
    windows_core::link!("shlwapi.dll" "system" fn StrFormatByteSize64A(qdw : i64, pszbuf : windows_core::PSTR, cchbuf : u32) -> windows_core::PSTR);
    unsafe { StrFormatByteSize64A(qdw, core::mem::transmute(pszbuf.as_ptr()), pszbuf.len().try_into().unwrap()) }
}
#[inline]
pub unsafe fn StrFormatByteSizeA(dw: u32, pszbuf: &mut [u8]) -> windows_core::PSTR {
    windows_core::link!("shlwapi.dll" "system" fn StrFormatByteSizeA(dw : u32, pszbuf : windows_core::PSTR, cchbuf : u32) -> windows_core::PSTR);
    unsafe { StrFormatByteSizeA(dw, core::mem::transmute(pszbuf.as_ptr()), pszbuf.len().try_into().unwrap()) }
}
#[inline]
pub unsafe fn StrFormatByteSizeEx(ull: u64, flags: SFBS_FLAGS, pszbuf: &mut [u16]) -> windows_core::Result<()> {
    windows_core::link!("shlwapi.dll" "system" fn StrFormatByteSizeEx(ull : u64, flags : SFBS_FLAGS, pszbuf : windows_core::PWSTR, cchbuf : u32) -> windows_core::HRESULT);
    unsafe { StrFormatByteSizeEx(ull, flags, core::mem::transmute(pszbuf.as_ptr()), pszbuf.len().try_into().unwrap()).ok() }
}
#[inline]
pub unsafe fn StrFormatByteSizeW(qdw: i64, pszbuf: &mut [u16]) -> windows_core::PWSTR {
    windows_core::link!("shlwapi.dll" "system" fn StrFormatByteSizeW(qdw : i64, pszbuf : windows_core::PWSTR, cchbuf : u32) -> windows_core::PWSTR);
    unsafe { StrFormatByteSizeW(qdw, core::mem::transmute(pszbuf.as_ptr()), pszbuf.len().try_into().unwrap()) }
}
#[inline]
pub unsafe fn StrFormatKBSizeA(qdw: i64, pszbuf: &mut [u8]) -> windows_core::PSTR {
    windows_core::link!("shlwapi.dll" "system" fn StrFormatKBSizeA(qdw : i64, pszbuf : windows_core::PSTR, cchbuf : u32) -> windows_core::PSTR);
    unsafe { StrFormatKBSizeA(qdw, core::mem::transmute(pszbuf.as_ptr()), pszbuf.len().try_into().unwrap()) }
}
#[inline]
pub unsafe fn StrFormatKBSizeW(qdw: i64, pszbuf: &mut [u16]) -> windows_core::PWSTR {
    windows_core::link!("shlwapi.dll" "system" fn StrFormatKBSizeW(qdw : i64, pszbuf : windows_core::PWSTR, cchbuf : u32) -> windows_core::PWSTR);
    unsafe { StrFormatKBSizeW(qdw, core::mem::transmute(pszbuf.as_ptr()), pszbuf.len().try_into().unwrap()) }
}
#[inline]
pub unsafe fn StrFromTimeIntervalA(pszout: &mut [u8], dwtimems: u32, digits: i32) -> i32 {
    windows_core::link!("shlwapi.dll" "system" fn StrFromTimeIntervalA(pszout : windows_core::PSTR, cchmax : u32, dwtimems : u32, digits : i32) -> i32);
    unsafe { StrFromTimeIntervalA(core::mem::transmute(pszout.as_ptr()), pszout.len().try_into().unwrap(), dwtimems, digits) }
}
#[inline]
pub unsafe fn StrFromTimeIntervalW(pszout: &mut [u16], dwtimems: u32, digits: i32) -> i32 {
    windows_core::link!("shlwapi.dll" "system" fn StrFromTimeIntervalW(pszout : windows_core::PWSTR, cchmax : u32, dwtimems : u32, digits : i32) -> i32);
    unsafe { StrFromTimeIntervalW(core::mem::transmute(pszout.as_ptr()), pszout.len().try_into().unwrap(), dwtimems, digits) }
}
#[inline]
pub unsafe fn StrIsIntlEqualA<P1, P2>(fcasesens: bool, pszstring1: P1, pszstring2: P2, nchar: i32) -> windows_core::BOOL
where
    P1: windows_core::Param<windows_core::PCSTR>,
    P2: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn StrIsIntlEqualA(fcasesens : windows_core::BOOL, pszstring1 : windows_core::PCSTR, pszstring2 : windows_core::PCSTR, nchar : i32) -> windows_core::BOOL);
    unsafe { StrIsIntlEqualA(fcasesens.into(), pszstring1.param().abi(), pszstring2.param().abi(), nchar) }
}
#[inline]
pub unsafe fn StrIsIntlEqualW<P1, P2>(fcasesens: bool, pszstring1: P1, pszstring2: P2, nchar: i32) -> windows_core::BOOL
where
    P1: windows_core::Param<windows_core::PCWSTR>,
    P2: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn StrIsIntlEqualW(fcasesens : windows_core::BOOL, pszstring1 : windows_core::PCWSTR, pszstring2 : windows_core::PCWSTR, nchar : i32) -> windows_core::BOOL);
    unsafe { StrIsIntlEqualW(fcasesens.into(), pszstring1.param().abi(), pszstring2.param().abi(), nchar) }
}
#[inline]
pub unsafe fn StrNCatA<P1>(psz1: &mut [u8], psz2: P1) -> windows_core::PSTR
where
    P1: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn StrNCatA(psz1 : windows_core::PSTR, psz2 : windows_core::PCSTR, cchmax : i32) -> windows_core::PSTR);
    unsafe { StrNCatA(core::mem::transmute(psz1.as_ptr()), psz2.param().abi(), psz1.len().try_into().unwrap()) }
}
#[inline]
pub unsafe fn StrNCatW<P1>(psz1: &mut [u16], psz2: P1) -> windows_core::PWSTR
where
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn StrNCatW(psz1 : windows_core::PWSTR, psz2 : windows_core::PCWSTR, cchmax : i32) -> windows_core::PWSTR);
    unsafe { StrNCatW(core::mem::transmute(psz1.as_ptr()), psz2.param().abi(), psz1.len().try_into().unwrap()) }
}
#[inline]
pub unsafe fn StrPBrkA<P0, P1>(psz: P0, pszset: P1) -> windows_core::PSTR
where
    P0: windows_core::Param<windows_core::PCSTR>,
    P1: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn StrPBrkA(psz : windows_core::PCSTR, pszset : windows_core::PCSTR) -> windows_core::PSTR);
    unsafe { StrPBrkA(psz.param().abi(), pszset.param().abi()) }
}
#[inline]
pub unsafe fn StrPBrkW<P0, P1>(psz: P0, pszset: P1) -> windows_core::PWSTR
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn StrPBrkW(psz : windows_core::PCWSTR, pszset : windows_core::PCWSTR) -> windows_core::PWSTR);
    unsafe { StrPBrkW(psz.param().abi(), pszset.param().abi()) }
}
#[inline]
pub unsafe fn StrRChrA<P0, P1>(pszstart: P0, pszend: P1, wmatch: u16) -> windows_core::PSTR
where
    P0: windows_core::Param<windows_core::PCSTR>,
    P1: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn StrRChrA(pszstart : windows_core::PCSTR, pszend : windows_core::PCSTR, wmatch : u16) -> windows_core::PSTR);
    unsafe { StrRChrA(pszstart.param().abi(), pszend.param().abi(), wmatch) }
}
#[inline]
pub unsafe fn StrRChrIA<P0, P1>(pszstart: P0, pszend: P1, wmatch: u16) -> windows_core::PSTR
where
    P0: windows_core::Param<windows_core::PCSTR>,
    P1: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn StrRChrIA(pszstart : windows_core::PCSTR, pszend : windows_core::PCSTR, wmatch : u16) -> windows_core::PSTR);
    unsafe { StrRChrIA(pszstart.param().abi(), pszend.param().abi(), wmatch) }
}
#[inline]
pub unsafe fn StrRChrIW<P0, P1>(pszstart: P0, pszend: P1, wmatch: u16) -> windows_core::PWSTR
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn StrRChrIW(pszstart : windows_core::PCWSTR, pszend : windows_core::PCWSTR, wmatch : u16) -> windows_core::PWSTR);
    unsafe { StrRChrIW(pszstart.param().abi(), pszend.param().abi(), wmatch) }
}
#[inline]
pub unsafe fn StrRChrW<P0, P1>(pszstart: P0, pszend: P1, wmatch: u16) -> windows_core::PWSTR
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn StrRChrW(pszstart : windows_core::PCWSTR, pszend : windows_core::PCWSTR, wmatch : u16) -> windows_core::PWSTR);
    unsafe { StrRChrW(pszstart.param().abi(), pszend.param().abi(), wmatch) }
}
#[inline]
pub unsafe fn StrRStrIA<P0, P1, P2>(pszsource: P0, pszlast: P1, pszsrch: P2) -> windows_core::PSTR
where
    P0: windows_core::Param<windows_core::PCSTR>,
    P1: windows_core::Param<windows_core::PCSTR>,
    P2: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn StrRStrIA(pszsource : windows_core::PCSTR, pszlast : windows_core::PCSTR, pszsrch : windows_core::PCSTR) -> windows_core::PSTR);
    unsafe { StrRStrIA(pszsource.param().abi(), pszlast.param().abi(), pszsrch.param().abi()) }
}
#[inline]
pub unsafe fn StrRStrIW<P0, P1, P2>(pszsource: P0, pszlast: P1, pszsrch: P2) -> windows_core::PWSTR
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
    P2: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn StrRStrIW(pszsource : windows_core::PCWSTR, pszlast : windows_core::PCWSTR, pszsrch : windows_core::PCWSTR) -> windows_core::PWSTR);
    unsafe { StrRStrIW(pszsource.param().abi(), pszlast.param().abi(), pszsrch.param().abi()) }
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn StrRetToBSTR(pstr: *mut Common::STRRET, pidl: Option<*const Common::ITEMIDLIST>, pbstr: *mut windows_core::BSTR) -> windows_core::Result<()> {
    windows_core::link!("shlwapi.dll" "system" fn StrRetToBSTR(pstr : *mut Common:: STRRET, pidl : *const Common:: ITEMIDLIST, pbstr : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe { StrRetToBSTR(pstr as _, pidl.unwrap_or(core::mem::zeroed()) as _, core::mem::transmute(pbstr)).ok() }
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn StrRetToBufA(pstr: *mut Common::STRRET, pidl: Option<*const Common::ITEMIDLIST>, pszbuf: &mut [u8]) -> windows_core::Result<()> {
    windows_core::link!("shlwapi.dll" "system" fn StrRetToBufA(pstr : *mut Common:: STRRET, pidl : *const Common:: ITEMIDLIST, pszbuf : windows_core::PSTR, cchbuf : u32) -> windows_core::HRESULT);
    unsafe { StrRetToBufA(pstr as _, pidl.unwrap_or(core::mem::zeroed()) as _, core::mem::transmute(pszbuf.as_ptr()), pszbuf.len().try_into().unwrap()).ok() }
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn StrRetToBufW(pstr: *mut Common::STRRET, pidl: Option<*const Common::ITEMIDLIST>, pszbuf: &mut [u16]) -> windows_core::Result<()> {
    windows_core::link!("shlwapi.dll" "system" fn StrRetToBufW(pstr : *mut Common:: STRRET, pidl : *const Common:: ITEMIDLIST, pszbuf : windows_core::PWSTR, cchbuf : u32) -> windows_core::HRESULT);
    unsafe { StrRetToBufW(pstr as _, pidl.unwrap_or(core::mem::zeroed()) as _, core::mem::transmute(pszbuf.as_ptr()), pszbuf.len().try_into().unwrap()).ok() }
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn StrRetToStrA(pstr: *mut Common::STRRET, pidl: Option<*const Common::ITEMIDLIST>, ppsz: *mut windows_core::PSTR) -> windows_core::Result<()> {
    windows_core::link!("shlwapi.dll" "system" fn StrRetToStrA(pstr : *mut Common:: STRRET, pidl : *const Common:: ITEMIDLIST, ppsz : *mut windows_core::PSTR) -> windows_core::HRESULT);
    unsafe { StrRetToStrA(pstr as _, pidl.unwrap_or(core::mem::zeroed()) as _, ppsz as _).ok() }
}
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn StrRetToStrW(pstr: *mut Common::STRRET, pidl: Option<*const Common::ITEMIDLIST>, ppsz: *mut windows_core::PWSTR) -> windows_core::Result<()> {
    windows_core::link!("shlwapi.dll" "system" fn StrRetToStrW(pstr : *mut Common:: STRRET, pidl : *const Common:: ITEMIDLIST, ppsz : *mut windows_core::PWSTR) -> windows_core::HRESULT);
    unsafe { StrRetToStrW(pstr as _, pidl.unwrap_or(core::mem::zeroed()) as _, ppsz as _).ok() }
}
#[inline]
pub unsafe fn StrSpnA<P0, P1>(psz: P0, pszset: P1) -> i32
where
    P0: windows_core::Param<windows_core::PCSTR>,
    P1: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn StrSpnA(psz : windows_core::PCSTR, pszset : windows_core::PCSTR) -> i32);
    unsafe { StrSpnA(psz.param().abi(), pszset.param().abi()) }
}
#[inline]
pub unsafe fn StrSpnW<P0, P1>(psz: P0, pszset: P1) -> i32
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn StrSpnW(psz : windows_core::PCWSTR, pszset : windows_core::PCWSTR) -> i32);
    unsafe { StrSpnW(psz.param().abi(), pszset.param().abi()) }
}
#[inline]
pub unsafe fn StrStrA<P0, P1>(pszfirst: P0, pszsrch: P1) -> windows_core::PSTR
where
    P0: windows_core::Param<windows_core::PCSTR>,
    P1: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn StrStrA(pszfirst : windows_core::PCSTR, pszsrch : windows_core::PCSTR) -> windows_core::PSTR);
    unsafe { StrStrA(pszfirst.param().abi(), pszsrch.param().abi()) }
}
#[inline]
pub unsafe fn StrStrIA<P0, P1>(pszfirst: P0, pszsrch: P1) -> windows_core::PSTR
where
    P0: windows_core::Param<windows_core::PCSTR>,
    P1: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn StrStrIA(pszfirst : windows_core::PCSTR, pszsrch : windows_core::PCSTR) -> windows_core::PSTR);
    unsafe { StrStrIA(pszfirst.param().abi(), pszsrch.param().abi()) }
}
#[inline]
pub unsafe fn StrStrIW<P0, P1>(pszfirst: P0, pszsrch: P1) -> windows_core::PWSTR
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn StrStrIW(pszfirst : windows_core::PCWSTR, pszsrch : windows_core::PCWSTR) -> windows_core::PWSTR);
    unsafe { StrStrIW(pszfirst.param().abi(), pszsrch.param().abi()) }
}
#[inline]
pub unsafe fn StrStrNIW<P0, P1>(pszfirst: P0, pszsrch: P1, cchmax: u32) -> windows_core::PWSTR
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn StrStrNIW(pszfirst : windows_core::PCWSTR, pszsrch : windows_core::PCWSTR, cchmax : u32) -> windows_core::PWSTR);
    unsafe { StrStrNIW(pszfirst.param().abi(), pszsrch.param().abi(), cchmax) }
}
#[inline]
pub unsafe fn StrStrNW<P0, P1>(pszfirst: P0, pszsrch: P1, cchmax: u32) -> windows_core::PWSTR
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn StrStrNW(pszfirst : windows_core::PCWSTR, pszsrch : windows_core::PCWSTR, cchmax : u32) -> windows_core::PWSTR);
    unsafe { StrStrNW(pszfirst.param().abi(), pszsrch.param().abi(), cchmax) }
}
#[inline]
pub unsafe fn StrStrW<P0, P1>(pszfirst: P0, pszsrch: P1) -> windows_core::PWSTR
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn StrStrW(pszfirst : windows_core::PCWSTR, pszsrch : windows_core::PCWSTR) -> windows_core::PWSTR);
    unsafe { StrStrW(pszfirst.param().abi(), pszsrch.param().abi()) }
}
#[inline]
pub unsafe fn StrToInt64ExA<P0>(pszstring: P0, dwflags: i32, pllret: *mut i64) -> windows_core::BOOL
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn StrToInt64ExA(pszstring : windows_core::PCSTR, dwflags : i32, pllret : *mut i64) -> windows_core::BOOL);
    unsafe { StrToInt64ExA(pszstring.param().abi(), dwflags, pllret as _) }
}
#[inline]
pub unsafe fn StrToInt64ExW<P0>(pszstring: P0, dwflags: i32, pllret: *mut i64) -> windows_core::BOOL
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn StrToInt64ExW(pszstring : windows_core::PCWSTR, dwflags : i32, pllret : *mut i64) -> windows_core::BOOL);
    unsafe { StrToInt64ExW(pszstring.param().abi(), dwflags, pllret as _) }
}
#[inline]
pub unsafe fn StrToIntA<P0>(pszsrc: P0) -> i32
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn StrToIntA(pszsrc : windows_core::PCSTR) -> i32);
    unsafe { StrToIntA(pszsrc.param().abi()) }
}
#[inline]
pub unsafe fn StrToIntExA<P0>(pszstring: P0, dwflags: i32, piret: *mut i32) -> windows_core::BOOL
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn StrToIntExA(pszstring : windows_core::PCSTR, dwflags : i32, piret : *mut i32) -> windows_core::BOOL);
    unsafe { StrToIntExA(pszstring.param().abi(), dwflags, piret as _) }
}
#[inline]
pub unsafe fn StrToIntExW<P0>(pszstring: P0, dwflags: i32, piret: *mut i32) -> windows_core::BOOL
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn StrToIntExW(pszstring : windows_core::PCWSTR, dwflags : i32, piret : *mut i32) -> windows_core::BOOL);
    unsafe { StrToIntExW(pszstring.param().abi(), dwflags, piret as _) }
}
#[inline]
pub unsafe fn StrToIntW<P0>(pszsrc: P0) -> i32
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn StrToIntW(pszsrc : windows_core::PCWSTR) -> i32);
    unsafe { StrToIntW(pszsrc.param().abi()) }
}
#[inline]
pub unsafe fn StrTrimA<P1>(psz: windows_core::PSTR, psztrimchars: P1) -> windows_core::BOOL
where
    P1: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn StrTrimA(psz : windows_core::PSTR, psztrimchars : windows_core::PCSTR) -> windows_core::BOOL);
    unsafe { StrTrimA(core::mem::transmute(psz), psztrimchars.param().abi()) }
}
#[inline]
pub unsafe fn StrTrimW<P1>(psz: windows_core::PWSTR, psztrimchars: P1) -> windows_core::BOOL
where
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn StrTrimW(psz : windows_core::PWSTR, psztrimchars : windows_core::PCWSTR) -> windows_core::BOOL);
    unsafe { StrTrimW(core::mem::transmute(psz), psztrimchars.param().abi()) }
}
#[inline]
pub unsafe fn UnloadUserProfile(htoken: super::super::Foundation::HANDLE, hprofile: super::super::Foundation::HANDLE) -> windows_core::Result<()> {
    windows_core::link!("userenv.dll" "system" fn UnloadUserProfile(htoken : super::super::Foundation:: HANDLE, hprofile : super::super::Foundation:: HANDLE) -> windows_core::BOOL);
    unsafe { UnloadUserProfile(htoken, hprofile).ok() }
}
#[inline]
pub unsafe fn UnregisterAppConstrainedChangeNotification(registration: PAPPCONSTRAIN_REGISTRATION) {
    windows_core::link!("api-ms-win-core-psm-appnotify-l1-1-1.dll" "system" fn UnregisterAppConstrainedChangeNotification(registration : PAPPCONSTRAIN_REGISTRATION));
    unsafe { UnregisterAppConstrainedChangeNotification(registration) }
}
#[inline]
pub unsafe fn UnregisterAppStateChangeNotification(registration: PAPPSTATE_REGISTRATION) {
    windows_core::link!("api-ms-win-core-psm-appnotify-l1-1-0.dll" "system" fn UnregisterAppStateChangeNotification(registration : PAPPSTATE_REGISTRATION));
    unsafe { UnregisterAppStateChangeNotification(registration) }
}
#[inline]
pub unsafe fn UnregisterScaleChangeEvent(dwcookie: usize) -> windows_core::Result<()> {
    windows_core::link!("api-ms-win-shcore-scaling-l1-1-1.dll" "system" fn UnregisterScaleChangeEvent(dwcookie : usize) -> windows_core::HRESULT);
    unsafe { UnregisterScaleChangeEvent(dwcookie).ok() }
}
#[inline]
pub unsafe fn UrlApplySchemeA<P0>(pszin: P0, pszout: windows_core::PSTR, pcchout: *mut u32, dwflags: u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn UrlApplySchemeA(pszin : windows_core::PCSTR, pszout : windows_core::PSTR, pcchout : *mut u32, dwflags : u32) -> windows_core::HRESULT);
    unsafe { UrlApplySchemeA(pszin.param().abi(), core::mem::transmute(pszout), pcchout as _, dwflags).ok() }
}
#[inline]
pub unsafe fn UrlApplySchemeW<P0>(pszin: P0, pszout: windows_core::PWSTR, pcchout: *mut u32, dwflags: u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn UrlApplySchemeW(pszin : windows_core::PCWSTR, pszout : windows_core::PWSTR, pcchout : *mut u32, dwflags : u32) -> windows_core::HRESULT);
    unsafe { UrlApplySchemeW(pszin.param().abi(), core::mem::transmute(pszout), pcchout as _, dwflags).ok() }
}
#[inline]
pub unsafe fn UrlCanonicalizeA<P0>(pszurl: P0, pszcanonicalized: windows_core::PSTR, pcchcanonicalized: *mut u32, dwflags: u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn UrlCanonicalizeA(pszurl : windows_core::PCSTR, pszcanonicalized : windows_core::PSTR, pcchcanonicalized : *mut u32, dwflags : u32) -> windows_core::HRESULT);
    unsafe { UrlCanonicalizeA(pszurl.param().abi(), core::mem::transmute(pszcanonicalized), pcchcanonicalized as _, dwflags).ok() }
}
#[inline]
pub unsafe fn UrlCanonicalizeW<P0>(pszurl: P0, pszcanonicalized: windows_core::PWSTR, pcchcanonicalized: *mut u32, dwflags: u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn UrlCanonicalizeW(pszurl : windows_core::PCWSTR, pszcanonicalized : windows_core::PWSTR, pcchcanonicalized : *mut u32, dwflags : u32) -> windows_core::HRESULT);
    unsafe { UrlCanonicalizeW(pszurl.param().abi(), core::mem::transmute(pszcanonicalized), pcchcanonicalized as _, dwflags).ok() }
}
#[inline]
pub unsafe fn UrlCombineA<P0, P1>(pszbase: P0, pszrelative: P1, pszcombined: Option<windows_core::PSTR>, pcchcombined: *mut u32, dwflags: u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCSTR>,
    P1: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn UrlCombineA(pszbase : windows_core::PCSTR, pszrelative : windows_core::PCSTR, pszcombined : windows_core::PSTR, pcchcombined : *mut u32, dwflags : u32) -> windows_core::HRESULT);
    unsafe { UrlCombineA(pszbase.param().abi(), pszrelative.param().abi(), pszcombined.unwrap_or(core::mem::zeroed()) as _, pcchcombined as _, dwflags).ok() }
}
#[inline]
pub unsafe fn UrlCombineW<P0, P1>(pszbase: P0, pszrelative: P1, pszcombined: Option<windows_core::PWSTR>, pcchcombined: *mut u32, dwflags: u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn UrlCombineW(pszbase : windows_core::PCWSTR, pszrelative : windows_core::PCWSTR, pszcombined : windows_core::PWSTR, pcchcombined : *mut u32, dwflags : u32) -> windows_core::HRESULT);
    unsafe { UrlCombineW(pszbase.param().abi(), pszrelative.param().abi(), pszcombined.unwrap_or(core::mem::zeroed()) as _, pcchcombined as _, dwflags).ok() }
}
#[inline]
pub unsafe fn UrlCompareA<P0, P1>(psz1: P0, psz2: P1, fignoreslash: bool) -> i32
where
    P0: windows_core::Param<windows_core::PCSTR>,
    P1: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn UrlCompareA(psz1 : windows_core::PCSTR, psz2 : windows_core::PCSTR, fignoreslash : windows_core::BOOL) -> i32);
    unsafe { UrlCompareA(psz1.param().abi(), psz2.param().abi(), fignoreslash.into()) }
}
#[inline]
pub unsafe fn UrlCompareW<P0, P1>(psz1: P0, psz2: P1, fignoreslash: bool) -> i32
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn UrlCompareW(psz1 : windows_core::PCWSTR, psz2 : windows_core::PCWSTR, fignoreslash : windows_core::BOOL) -> i32);
    unsafe { UrlCompareW(psz1.param().abi(), psz2.param().abi(), fignoreslash.into()) }
}
#[inline]
pub unsafe fn UrlCreateFromPathA<P0>(pszpath: P0, pszurl: windows_core::PSTR, pcchurl: *mut u32, dwflags: u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn UrlCreateFromPathA(pszpath : windows_core::PCSTR, pszurl : windows_core::PSTR, pcchurl : *mut u32, dwflags : u32) -> windows_core::HRESULT);
    unsafe { UrlCreateFromPathA(pszpath.param().abi(), core::mem::transmute(pszurl), pcchurl as _, dwflags).ok() }
}
#[inline]
pub unsafe fn UrlCreateFromPathW<P0>(pszpath: P0, pszurl: windows_core::PWSTR, pcchurl: *mut u32, dwflags: u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn UrlCreateFromPathW(pszpath : windows_core::PCWSTR, pszurl : windows_core::PWSTR, pcchurl : *mut u32, dwflags : u32) -> windows_core::HRESULT);
    unsafe { UrlCreateFromPathW(pszpath.param().abi(), core::mem::transmute(pszurl), pcchurl as _, dwflags).ok() }
}
#[inline]
pub unsafe fn UrlEscapeA<P0>(pszurl: P0, pszescaped: windows_core::PSTR, pcchescaped: *mut u32, dwflags: u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn UrlEscapeA(pszurl : windows_core::PCSTR, pszescaped : windows_core::PSTR, pcchescaped : *mut u32, dwflags : u32) -> windows_core::HRESULT);
    unsafe { UrlEscapeA(pszurl.param().abi(), core::mem::transmute(pszescaped), pcchescaped as _, dwflags).ok() }
}
#[inline]
pub unsafe fn UrlEscapeW<P0>(pszurl: P0, pszescaped: windows_core::PWSTR, pcchescaped: *mut u32, dwflags: u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn UrlEscapeW(pszurl : windows_core::PCWSTR, pszescaped : windows_core::PWSTR, pcchescaped : *mut u32, dwflags : u32) -> windows_core::HRESULT);
    unsafe { UrlEscapeW(pszurl.param().abi(), core::mem::transmute(pszescaped), pcchescaped as _, dwflags).ok() }
}
#[inline]
pub unsafe fn UrlFixupW<P0>(pcszurl: P0, psztranslatedurl: &mut [u16]) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn UrlFixupW(pcszurl : windows_core::PCWSTR, psztranslatedurl : windows_core::PWSTR, cchmax : u32) -> windows_core::HRESULT);
    unsafe { UrlFixupW(pcszurl.param().abi(), core::mem::transmute(psztranslatedurl.as_ptr()), psztranslatedurl.len().try_into().unwrap()).ok() }
}
#[inline]
pub unsafe fn UrlGetLocationA<P0>(pszurl: P0) -> windows_core::PCSTR
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn UrlGetLocationA(pszurl : windows_core::PCSTR) -> windows_core::PCSTR);
    unsafe { UrlGetLocationA(pszurl.param().abi()) }
}
#[inline]
pub unsafe fn UrlGetLocationW<P0>(pszurl: P0) -> windows_core::PCWSTR
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn UrlGetLocationW(pszurl : windows_core::PCWSTR) -> windows_core::PCWSTR);
    unsafe { UrlGetLocationW(pszurl.param().abi()) }
}
#[inline]
pub unsafe fn UrlGetPartA<P0>(pszin: P0, pszout: windows_core::PSTR, pcchout: *mut u32, dwpart: u32, dwflags: u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn UrlGetPartA(pszin : windows_core::PCSTR, pszout : windows_core::PSTR, pcchout : *mut u32, dwpart : u32, dwflags : u32) -> windows_core::HRESULT);
    unsafe { UrlGetPartA(pszin.param().abi(), core::mem::transmute(pszout), pcchout as _, dwpart, dwflags).ok() }
}
#[inline]
pub unsafe fn UrlGetPartW<P0>(pszin: P0, pszout: windows_core::PWSTR, pcchout: *mut u32, dwpart: u32, dwflags: u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn UrlGetPartW(pszin : windows_core::PCWSTR, pszout : windows_core::PWSTR, pcchout : *mut u32, dwpart : u32, dwflags : u32) -> windows_core::HRESULT);
    unsafe { UrlGetPartW(pszin.param().abi(), core::mem::transmute(pszout), pcchout as _, dwpart, dwflags).ok() }
}
#[inline]
pub unsafe fn UrlHashA<P0>(pszurl: P0, pbhash: &mut [u8]) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn UrlHashA(pszurl : windows_core::PCSTR, pbhash : *mut u8, cbhash : u32) -> windows_core::HRESULT);
    unsafe { UrlHashA(pszurl.param().abi(), core::mem::transmute(pbhash.as_ptr()), pbhash.len().try_into().unwrap()).ok() }
}
#[inline]
pub unsafe fn UrlHashW<P0>(pszurl: P0, pbhash: &mut [u8]) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn UrlHashW(pszurl : windows_core::PCWSTR, pbhash : *mut u8, cbhash : u32) -> windows_core::HRESULT);
    unsafe { UrlHashW(pszurl.param().abi(), core::mem::transmute(pbhash.as_ptr()), pbhash.len().try_into().unwrap()).ok() }
}
#[inline]
pub unsafe fn UrlIsA<P0>(pszurl: P0, urlis: URLIS) -> windows_core::BOOL
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn UrlIsA(pszurl : windows_core::PCSTR, urlis : URLIS) -> windows_core::BOOL);
    unsafe { UrlIsA(pszurl.param().abi(), urlis) }
}
#[inline]
pub unsafe fn UrlIsNoHistoryA<P0>(pszurl: P0) -> windows_core::BOOL
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn UrlIsNoHistoryA(pszurl : windows_core::PCSTR) -> windows_core::BOOL);
    unsafe { UrlIsNoHistoryA(pszurl.param().abi()) }
}
#[inline]
pub unsafe fn UrlIsNoHistoryW<P0>(pszurl: P0) -> windows_core::BOOL
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn UrlIsNoHistoryW(pszurl : windows_core::PCWSTR) -> windows_core::BOOL);
    unsafe { UrlIsNoHistoryW(pszurl.param().abi()) }
}
#[inline]
pub unsafe fn UrlIsOpaqueA<P0>(pszurl: P0) -> windows_core::BOOL
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn UrlIsOpaqueA(pszurl : windows_core::PCSTR) -> windows_core::BOOL);
    unsafe { UrlIsOpaqueA(pszurl.param().abi()) }
}
#[inline]
pub unsafe fn UrlIsOpaqueW<P0>(pszurl: P0) -> windows_core::BOOL
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn UrlIsOpaqueW(pszurl : windows_core::PCWSTR) -> windows_core::BOOL);
    unsafe { UrlIsOpaqueW(pszurl.param().abi()) }
}
#[inline]
pub unsafe fn UrlIsW<P0>(pszurl: P0, urlis: URLIS) -> windows_core::BOOL
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn UrlIsW(pszurl : windows_core::PCWSTR, urlis : URLIS) -> windows_core::BOOL);
    unsafe { UrlIsW(pszurl.param().abi(), urlis) }
}
#[inline]
pub unsafe fn UrlUnescapeA(pszurl: windows_core::PSTR, pszunescaped: Option<windows_core::PSTR>, pcchunescaped: Option<*mut u32>, dwflags: u32) -> windows_core::Result<()> {
    windows_core::link!("shlwapi.dll" "system" fn UrlUnescapeA(pszurl : windows_core::PSTR, pszunescaped : windows_core::PSTR, pcchunescaped : *mut u32, dwflags : u32) -> windows_core::HRESULT);
    unsafe { UrlUnescapeA(core::mem::transmute(pszurl), pszunescaped.unwrap_or(core::mem::zeroed()) as _, pcchunescaped.unwrap_or(core::mem::zeroed()) as _, dwflags).ok() }
}
#[inline]
pub unsafe fn UrlUnescapeW(pszurl: windows_core::PWSTR, pszunescaped: Option<windows_core::PWSTR>, pcchunescaped: Option<*mut u32>, dwflags: u32) -> windows_core::Result<()> {
    windows_core::link!("shlwapi.dll" "system" fn UrlUnescapeW(pszurl : windows_core::PWSTR, pszunescaped : windows_core::PWSTR, pcchunescaped : *mut u32, dwflags : u32) -> windows_core::HRESULT);
    unsafe { UrlUnescapeW(core::mem::transmute(pszurl), pszunescaped.unwrap_or(core::mem::zeroed()) as _, pcchunescaped.unwrap_or(core::mem::zeroed()) as _, dwflags).ok() }
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant", feature = "Win32_UI_Shell_Common"))]
#[inline]
pub unsafe fn VariantToStrRet(varin: *const super::super::System::Variant::VARIANT, pstrret: *mut Common::STRRET) -> windows_core::Result<()> {
    windows_core::link!("propsys.dll" "system" fn VariantToStrRet(varin : *const super::super::System::Variant:: VARIANT, pstrret : *mut Common:: STRRET) -> windows_core::HRESULT);
    unsafe { VariantToStrRet(core::mem::transmute(varin), pstrret as _).ok() }
}
#[inline]
pub unsafe fn WhichPlatform() -> u32 {
    windows_core::link!("shlwapi.dll" "system" fn WhichPlatform() -> u32);
    unsafe { WhichPlatform() }
}
#[inline]
pub unsafe fn Win32DeleteFile<P0>(pszpath: P0) -> windows_core::BOOL
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shell32.dll" "system" fn Win32DeleteFile(pszpath : windows_core::PCWSTR) -> windows_core::BOOL);
    unsafe { Win32DeleteFile(pszpath.param().abi()) }
}
#[inline]
pub unsafe fn WinHelpA<P1>(hwndmain: Option<super::super::Foundation::HWND>, lpszhelp: P1, ucommand: u32, dwdata: usize) -> windows_core::Result<()>
where
    P1: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("user32.dll" "system" fn WinHelpA(hwndmain : super::super::Foundation:: HWND, lpszhelp : windows_core::PCSTR, ucommand : u32, dwdata : usize) -> windows_core::BOOL);
    unsafe { WinHelpA(hwndmain.unwrap_or(core::mem::zeroed()) as _, lpszhelp.param().abi(), ucommand, dwdata).ok() }
}
#[inline]
pub unsafe fn WinHelpW<P1>(hwndmain: Option<super::super::Foundation::HWND>, lpszhelp: P1, ucommand: u32, dwdata: usize) -> windows_core::Result<()>
where
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("user32.dll" "system" fn WinHelpW(hwndmain : super::super::Foundation:: HWND, lpszhelp : windows_core::PCWSTR, ucommand : u32, dwdata : usize) -> windows_core::BOOL);
    unsafe { WinHelpW(hwndmain.unwrap_or(core::mem::zeroed()) as _, lpszhelp.param().abi(), ucommand, dwdata).ok() }
}
#[inline]
pub unsafe fn WriteCabinetState(pcs: *const CABINETSTATE) -> windows_core::BOOL {
    windows_core::link!("shell32.dll" "system" fn WriteCabinetState(pcs : *const CABINETSTATE) -> windows_core::BOOL);
    unsafe { WriteCabinetState(pcs) }
}
#[inline]
pub unsafe fn wnsprintfA<P2>(pszdest: &mut [u8], pszfmt: P2) -> i32
where
    P2: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "C" fn wnsprintfA(pszdest : windows_core::PSTR, cchdest : i32, pszfmt : windows_core::PCSTR) -> i32);
    unsafe { wnsprintfA(core::mem::transmute(pszdest.as_ptr()), pszdest.len().try_into().unwrap(), pszfmt.param().abi()) }
}
#[inline]
pub unsafe fn wnsprintfW<P2>(pszdest: &mut [u16], pszfmt: P2) -> i32
where
    P2: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "C" fn wnsprintfW(pszdest : windows_core::PWSTR, cchdest : i32, pszfmt : windows_core::PCWSTR) -> i32);
    unsafe { wnsprintfW(core::mem::transmute(pszdest.as_ptr()), pszdest.len().try_into().unwrap(), pszfmt.param().abi()) }
}
#[inline]
pub unsafe fn wvnsprintfA<P2>(pszdest: &mut [u8], pszfmt: P2, arglist: *const i8) -> i32
where
    P2: windows_core::Param<windows_core::PCSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn wvnsprintfA(pszdest : windows_core::PSTR, cchdest : i32, pszfmt : windows_core::PCSTR, arglist : *const i8) -> i32);
    unsafe { wvnsprintfA(core::mem::transmute(pszdest.as_ptr()), pszdest.len().try_into().unwrap(), pszfmt.param().abi(), arglist) }
}
#[inline]
pub unsafe fn wvnsprintfW<P2>(pszdest: &mut [u16], pszfmt: P2, arglist: *const i8) -> i32
where
    P2: windows_core::Param<windows_core::PCWSTR>,
{
    windows_core::link!("shlwapi.dll" "system" fn wvnsprintfW(pszdest : windows_core::PWSTR, cchdest : i32, pszfmt : windows_core::PCWSTR, arglist : *const i8) -> i32);
    unsafe { wvnsprintfW(core::mem::transmute(pszdest.as_ptr()), pszdest.len().try_into().unwrap(), pszfmt.param().abi(), arglist) }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AASHELLMENUFILENAME {
    pub cbTotal: i16,
    pub rgbReserved: [u8; 12],
    pub szFileName: [u16; 1],
}
impl Default for AASHELLMENUFILENAME {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AASHELLMENUITEM {
    pub lpReserved1: *mut core::ffi::c_void,
    pub iReserved: i32,
    pub uiReserved: u32,
    pub lpName: *mut AASHELLMENUFILENAME,
    pub psz: windows_core::PWSTR,
}
impl Default for AASHELLMENUITEM {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const ABE_BOTTOM: u32 = 3u32;
pub const ABE_LEFT: u32 = 0u32;
pub const ABE_RIGHT: u32 = 2u32;
pub const ABE_TOP: u32 = 1u32;
pub const ABM_ACTIVATE: u32 = 6u32;
pub const ABM_GETAUTOHIDEBAR: u32 = 7u32;
pub const ABM_GETAUTOHIDEBAREX: u32 = 11u32;
pub const ABM_GETSTATE: u32 = 4u32;
pub const ABM_GETTASKBARPOS: u32 = 5u32;
pub const ABM_NEW: u32 = 0u32;
pub const ABM_QUERYPOS: u32 = 2u32;
pub const ABM_REMOVE: u32 = 1u32;
pub const ABM_SETAUTOHIDEBAR: u32 = 8u32;
pub const ABM_SETAUTOHIDEBAREX: u32 = 12u32;
pub const ABM_SETPOS: u32 = 3u32;
pub const ABM_SETSTATE: u32 = 10u32;
pub const ABM_WINDOWPOSCHANGED: u32 = 9u32;
pub const ABN_FULLSCREENAPP: u32 = 2u32;
pub const ABN_POSCHANGED: u32 = 1u32;
pub const ABN_STATECHANGE: u32 = 0u32;
pub const ABN_WINDOWARRANGE: u32 = 3u32;
pub const ABS_ALWAYSONTOP: u32 = 2u32;
pub const ABS_AUTOHIDE: u32 = 1u32;
pub const ACDD_VISIBLE: u32 = 1u32;
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct ACENUMOPTION(pub i32);
pub const ACEO_FIRSTUNUSED: ACENUMOPTION = ACENUMOPTION(65536i32);
pub const ACEO_MOSTRECENTFIRST: ACENUMOPTION = ACENUMOPTION(1i32);
pub const ACEO_NONE: ACENUMOPTION = ACENUMOPTION(0i32);
pub const ACLO_CURRENTDIR: AUTOCOMPLETELISTOPTIONS = AUTOCOMPLETELISTOPTIONS(1i32);
pub const ACLO_DESKTOP: AUTOCOMPLETELISTOPTIONS = AUTOCOMPLETELISTOPTIONS(4i32);
pub const ACLO_FAVORITES: AUTOCOMPLETELISTOPTIONS = AUTOCOMPLETELISTOPTIONS(8i32);
pub const ACLO_FILESYSDIRS: AUTOCOMPLETELISTOPTIONS = AUTOCOMPLETELISTOPTIONS(32i32);
pub const ACLO_FILESYSONLY: AUTOCOMPLETELISTOPTIONS = AUTOCOMPLETELISTOPTIONS(16i32);
pub const ACLO_MYCOMPUTER: AUTOCOMPLETELISTOPTIONS = AUTOCOMPLETELISTOPTIONS(2i32);
pub const ACLO_NONE: AUTOCOMPLETELISTOPTIONS = AUTOCOMPLETELISTOPTIONS(0i32);
pub const ACLO_VIRTUALNAMESPACE: AUTOCOMPLETELISTOPTIONS = AUTOCOMPLETELISTOPTIONS(64i32);
pub const ACO_AUTOAPPEND: AUTOCOMPLETEOPTIONS = AUTOCOMPLETEOPTIONS(2i32);
pub const ACO_AUTOSUGGEST: AUTOCOMPLETEOPTIONS = AUTOCOMPLETEOPTIONS(1i32);
pub const ACO_FILTERPREFIXES: AUTOCOMPLETEOPTIONS = AUTOCOMPLETEOPTIONS(8i32);
pub const ACO_NONE: AUTOCOMPLETEOPTIONS = AUTOCOMPLETEOPTIONS(0i32);
pub const ACO_NOPREFIXFILTERING: AUTOCOMPLETEOPTIONS = AUTOCOMPLETEOPTIONS(256i32);
pub const ACO_RTLREADING: AUTOCOMPLETEOPTIONS = AUTOCOMPLETEOPTIONS(64i32);
pub const ACO_SEARCH: AUTOCOMPLETEOPTIONS = AUTOCOMPLETEOPTIONS(4i32);
pub const ACO_UPDOWNKEYDROPSLIST: AUTOCOMPLETEOPTIONS = AUTOCOMPLETEOPTIONS(32i32);
pub const ACO_USETAB: AUTOCOMPLETEOPTIONS = AUTOCOMPLETEOPTIONS(16i32);
pub const ACO_WORD_FILTER: AUTOCOMPLETEOPTIONS = AUTOCOMPLETEOPTIONS(128i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct ACTIVATEOPTIONS(pub i32);
impl ACTIVATEOPTIONS {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl core::ops::BitOr for ACTIVATEOPTIONS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl core::ops::BitAnd for ACTIVATEOPTIONS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl core::ops::BitOrAssign for ACTIVATEOPTIONS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl core::ops::BitAndAssign for ACTIVATEOPTIONS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl core::ops::Not for ACTIVATEOPTIONS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
pub const ADDURL_SILENT: u32 = 1u32;
pub const ADE_LEFT: ADJACENT_DISPLAY_EDGES = ADJACENT_DISPLAY_EDGES(1i32);
pub const ADE_NONE: ADJACENT_DISPLAY_EDGES = ADJACENT_DISPLAY_EDGES(0i32);
pub const ADE_RIGHT: ADJACENT_DISPLAY_EDGES = ADJACENT_DISPLAY_EDGES(2i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct ADJACENT_DISPLAY_EDGES(pub i32);
impl ADJACENT_DISPLAY_EDGES {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl core::ops::BitOr for ADJACENT_DISPLAY_EDGES {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl core::ops::BitAnd for ADJACENT_DISPLAY_EDGES {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl core::ops::BitOrAssign for ADJACENT_DISPLAY_EDGES {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl core::ops::BitAndAssign for ADJACENT_DISPLAY_EDGES {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl core::ops::Not for ADJACENT_DISPLAY_EDGES {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
pub const ADLT_FREQUENT: APPDOCLISTTYPE = APPDOCLISTTYPE(1i32);
pub const ADLT_RECENT: APPDOCLISTTYPE = APPDOCLISTTYPE(0i32);
pub const AD_APPLY_BUFFERED_REFRESH: u32 = 16u32;
pub const AD_APPLY_DYNAMICREFRESH: u32 = 32u32;
pub const AD_APPLY_FORCE: u32 = 8u32;
pub const AD_APPLY_HTMLGEN: u32 = 2u32;
pub const AD_APPLY_REFRESH: u32 = 4u32;
pub const AD_APPLY_SAVE: u32 = 1u32;
pub const AD_GETWP_BMP: u32 = 0u32;
pub const AD_GETWP_IMAGE: u32 = 1u32;
pub const AD_GETWP_LAST_APPLIED: u32 = 2u32;
pub const AHE_DESKTOP: AHE_TYPE = AHE_TYPE(0i32);
pub const AHE_IMMERSIVE: AHE_TYPE = AHE_TYPE(1i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct AHE_TYPE(pub i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct AHTYPE(pub i32);
impl AHTYPE {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl core::ops::BitOr for AHTYPE {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl core::ops::BitAnd for AHTYPE {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl core::ops::BitOrAssign for AHTYPE {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl core::ops::BitAndAssign for AHTYPE {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl core::ops::Not for AHTYPE {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
pub const AHTYPE_ANY_APPLICATION: AHTYPE = AHTYPE(16i32);
pub const AHTYPE_ANY_PROGID: AHTYPE = AHTYPE(512i32);
pub const AHTYPE_APPLICATION: AHTYPE = AHTYPE(128i32);
pub const AHTYPE_CLASS_APPLICATION: AHTYPE = AHTYPE(256i32);
pub const AHTYPE_MACHINEDEFAULT: AHTYPE = AHTYPE(32i32);
pub const AHTYPE_PROGID: AHTYPE = AHTYPE(64i32);
pub const AHTYPE_UNDEFINED: AHTYPE = AHTYPE(0i32);
pub const AHTYPE_USER_APPLICATION: AHTYPE = AHTYPE(8i32);
pub const AIM_COMMENTS: APPINFODATAFLAGS = APPINFODATAFLAGS(32768i32);
pub const AIM_CONTACT: APPINFODATAFLAGS = APPINFODATAFLAGS(16384i32);
pub const AIM_DISPLAYNAME: APPINFODATAFLAGS = APPINFODATAFLAGS(1i32);
pub const AIM_HELPLINK: APPINFODATAFLAGS = APPINFODATAFLAGS(512i32);
pub const AIM_IMAGE: APPINFODATAFLAGS = APPINFODATAFLAGS(131072i32);
pub const AIM_INSTALLDATE: APPINFODATAFLAGS = APPINFODATAFLAGS(4096i32);
pub const AIM_INSTALLLOCATION: APPINFODATAFLAGS = APPINFODATAFLAGS(1024i32);
pub const AIM_INSTALLSOURCE: APPINFODATAFLAGS = APPINFODATAFLAGS(2048i32);
pub const AIM_LANGUAGE: APPINFODATAFLAGS = APPINFODATAFLAGS(64i32);
pub const AIM_PRODUCTID: APPINFODATAFLAGS = APPINFODATAFLAGS(8i32);
pub const AIM_PUBLISHER: APPINFODATAFLAGS = APPINFODATAFLAGS(4i32);
pub const AIM_READMEURL: APPINFODATAFLAGS = APPINFODATAFLAGS(262144i32);
pub const AIM_REGISTEREDCOMPANY: APPINFODATAFLAGS = APPINFODATAFLAGS(32i32);
pub const AIM_REGISTEREDOWNER: APPINFODATAFLAGS = APPINFODATAFLAGS(16i32);
pub const AIM_SUPPORTTELEPHONE: APPINFODATAFLAGS = APPINFODATAFLAGS(256i32);
pub const AIM_SUPPORTURL: APPINFODATAFLAGS = APPINFODATAFLAGS(128i32);
pub const AIM_UPDATEINFOURL: APPINFODATAFLAGS = APPINFODATAFLAGS(524288i32);
pub const AIM_VERSION: APPINFODATAFLAGS = APPINFODATAFLAGS(2i32);
pub const AL_EFFECTIVE: ASSOCIATIONLEVEL = ASSOCIATIONLEVEL(1i32);
pub const AL_MACHINE: ASSOCIATIONLEVEL = ASSOCIATIONLEVEL(0i32);
pub const AL_USER: ASSOCIATIONLEVEL = ASSOCIATIONLEVEL(2i32);
pub const AO_DESIGNMODE: ACTIVATEOPTIONS = ACTIVATEOPTIONS(1i32);
pub const AO_NOERRORUI: ACTIVATEOPTIONS = ACTIVATEOPTIONS(2i32);
pub const AO_NONE: ACTIVATEOPTIONS = ACTIVATEOPTIONS(0i32);
pub const AO_NOSPLASHSCREEN: ACTIVATEOPTIONS = ACTIVATEOPTIONS(4i32);
pub const AO_PRELAUNCH: ACTIVATEOPTIONS = ACTIVATEOPTIONS(33554432i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct APPACTIONFLAGS(pub i32);
pub const APPACTION_ADDLATER: APPACTIONFLAGS = APPACTIONFLAGS(256i32);
pub const APPACTION_CANGETSIZE: APPACTIONFLAGS = APPACTIONFLAGS(32i32);
pub const APPACTION_INSTALL: APPACTIONFLAGS = APPACTIONFLAGS(1i32);
pub const APPACTION_MODIFY: APPACTIONFLAGS = APPACTIONFLAGS(4i32);
pub const APPACTION_MODIFYREMOVE: APPACTIONFLAGS = APPACTIONFLAGS(128i32);
pub const APPACTION_REPAIR: APPACTIONFLAGS = APPACTIONFLAGS(8i32);
pub const APPACTION_UNINSTALL: APPACTIONFLAGS = APPACTIONFLAGS(2i32);
pub const APPACTION_UNSCHEDULE: APPACTIONFLAGS = APPACTIONFLAGS(512i32);
pub const APPACTION_UPGRADE: APPACTIONFLAGS = APPACTIONFLAGS(16i32);
#[repr(C, packed(1))]
#[cfg(target_arch = "x86")]
#[derive(Clone, Copy, Default)]
pub struct APPBARDATA {
    pub cbSize: u32,
    pub hWnd: super::super::Foundation::HWND,
    pub uCallbackMessage: u32,
    pub uEdge: u32,
    pub rc: super::super::Foundation::RECT,
    pub lParam: super::super::Foundation::LPARAM,
}
#[repr(C)]
#[cfg(any(target_arch = "aarch64", target_arch = "arm64ec", target_arch = "x86_64"))]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct APPBARDATA {
    pub cbSize: u32,
    pub hWnd: super::super::Foundation::HWND,
    pub uCallbackMessage: u32,
    pub uEdge: u32,
    pub rc: super::super::Foundation::RECT,
    pub lParam: super::super::Foundation::LPARAM,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct APPCATEGORYINFO {
    pub Locale: u32,
    pub pszDescription: windows_core::PWSTR,
    pub AppCategoryId: windows_core::GUID,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct APPCATEGORYINFOLIST {
    pub cCategory: u32,
    pub pCategoryInfo: *mut APPCATEGORYINFO,
}
impl Default for APPCATEGORYINFOLIST {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct APPDOCLISTTYPE(pub i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct APPINFODATA {
    pub cbSize: u32,
    pub dwMask: u32,
    pub pszDisplayName: windows_core::PWSTR,
    pub pszVersion: windows_core::PWSTR,
    pub pszPublisher: windows_core::PWSTR,
    pub pszProductID: windows_core::PWSTR,
    pub pszRegisteredOwner: windows_core::PWSTR,
    pub pszRegisteredCompany: windows_core::PWSTR,
    pub pszLanguage: windows_core::PWSTR,
    pub pszSupportUrl: windows_core::PWSTR,
    pub pszSupportTelephone: windows_core::PWSTR,
    pub pszHelpLink: windows_core::PWSTR,
    pub pszInstallLocation: windows_core::PWSTR,
    pub pszInstallSource: windows_core::PWSTR,
    pub pszInstallDate: windows_core::PWSTR,
    pub pszContact: windows_core::PWSTR,
    pub pszComments: windows_core::PWSTR,
    pub pszImage: windows_core::PWSTR,
    pub pszReadmeUrl: windows_core::PWSTR,
    pub pszUpdateInfoUrl: windows_core::PWSTR,
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct APPINFODATAFLAGS(pub i32);
pub type APPLET_PROC = Option<unsafe extern "system" fn(hwndcpl: super::super::Foundation::HWND, msg: u32, lparam1: super::super::Foundation::LPARAM, lparam2: super::super::Foundation::LPARAM) -> i32>;
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct APPLICATION_VIEW_MIN_WIDTH(pub i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct APPLICATION_VIEW_ORIENTATION(pub i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct APPLICATION_VIEW_SIZE_PREFERENCE(pub i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct APPLICATION_VIEW_STATE(pub i32);
pub const APPNAMEBUFFERLEN: u32 = 40u32;
pub const ARCONTENT_AUDIOCD: u32 = 4u32;
pub const ARCONTENT_AUTOPLAYMUSIC: u32 = 256u32;
pub const ARCONTENT_AUTOPLAYPIX: u32 = 128u32;
pub const ARCONTENT_AUTOPLAYVIDEO: u32 = 512u32;
pub const ARCONTENT_AUTORUNINF: u32 = 2u32;
pub const ARCONTENT_BLANKBD: u32 = 8192u32;
pub const ARCONTENT_BLANKCD: u32 = 16u32;
pub const ARCONTENT_BLANKDVD: u32 = 32u32;
pub const ARCONTENT_BLURAY: u32 = 16384u32;
pub const ARCONTENT_CAMERASTORAGE: u32 = 32768u32;
pub const ARCONTENT_CUSTOMEVENT: u32 = 65536u32;
pub const ARCONTENT_DVDAUDIO: u32 = 4096u32;
pub const ARCONTENT_DVDMOVIE: u32 = 8u32;
pub const ARCONTENT_MASK: u32 = 131070u32;
pub const ARCONTENT_NONE: u32 = 0u32;
pub const ARCONTENT_PHASE_FINAL: u32 = 1073741824u32;
pub const ARCONTENT_PHASE_MASK: u32 = 1879048192u32;
pub const ARCONTENT_PHASE_PRESNIFF: u32 = 268435456u32;
pub const ARCONTENT_PHASE_SNIFFING: u32 = 536870912u32;
pub const ARCONTENT_PHASE_UNKNOWN: u32 = 0u32;
pub const ARCONTENT_SVCD: u32 = 2048u32;
pub const ARCONTENT_UNKNOWNCONTENT: u32 = 64u32;
pub const ARCONTENT_VCD: u32 = 1024u32;
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct ASSOCCLASS(pub i32);
pub const ASSOCCLASS_APP_KEY: ASSOCCLASS = ASSOCCLASS(5i32);
pub const ASSOCCLASS_APP_STR: ASSOCCLASS = ASSOCCLASS(6i32);
pub const ASSOCCLASS_CLSID_KEY: ASSOCCLASS = ASSOCCLASS(3i32);
pub const ASSOCCLASS_CLSID_STR: ASSOCCLASS = ASSOCCLASS(4i32);
pub const ASSOCCLASS_FIXED_PROGID_STR: ASSOCCLASS = ASSOCCLASS(10i32);
pub const ASSOCCLASS_FOLDER: ASSOCCLASS = ASSOCCLASS(8i32);
pub const ASSOCCLASS_PROGID_KEY: ASSOCCLASS = ASSOCCLASS(1i32);
pub const ASSOCCLASS_PROGID_STR: ASSOCCLASS = ASSOCCLASS(2i32);
pub const ASSOCCLASS_PROTOCOL_STR: ASSOCCLASS = ASSOCCLASS(11i32);
pub const ASSOCCLASS_SHELL_KEY: ASSOCCLASS = ASSOCCLASS(0i32);
pub const ASSOCCLASS_STAR: ASSOCCLASS = ASSOCCLASS(9i32);
pub const ASSOCCLASS_SYSTEM_STR: ASSOCCLASS = ASSOCCLASS(7i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct ASSOCDATA(pub i32);
pub const ASSOCDATA_EDITFLAGS: ASSOCDATA = ASSOCDATA(5i32);
pub const ASSOCDATA_HASPERUSERASSOC: ASSOCDATA = ASSOCDATA(4i32);
pub const ASSOCDATA_MAX: ASSOCDATA = ASSOCDATA(7i32);
pub const ASSOCDATA_MSIDESCRIPTOR: ASSOCDATA = ASSOCDATA(1i32);
pub const ASSOCDATA_NOACTIVATEHANDLER: ASSOCDATA = ASSOCDATA(2i32);
pub const ASSOCDATA_UNUSED1: ASSOCDATA = ASSOCDATA(3i32);
pub const ASSOCDATA_VALUE: ASSOCDATA = ASSOCDATA(6i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct ASSOCENUM(pub i32);
pub const ASSOCENUM_NONE: ASSOCENUM = ASSOCENUM(0i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct ASSOCF(pub u32);
impl ASSOCF {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl core::ops::BitOr for ASSOCF {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl core::ops::BitAnd for ASSOCF {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl core::ops::BitOrAssign for ASSOCF {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl core::ops::BitAndAssign for ASSOCF {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl core::ops::Not for ASSOCF {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
pub const ASSOCF_APP_TO_APP: ASSOCF = ASSOCF(65536u32);
pub const ASSOCF_IGNOREBASECLASS: ASSOCF = ASSOCF(512u32);
pub const ASSOCF_INIT_BYEXENAME: ASSOCF = ASSOCF(2u32);
pub const ASSOCF_INIT_DEFAULTTOFOLDER: ASSOCF = ASSOCF(8u32);
pub const ASSOCF_INIT_DEFAULTTOSTAR: ASSOCF = ASSOCF(4u32);
pub const ASSOCF_INIT_FIXED_PROGID: ASSOCF = ASSOCF(2048u32);
pub const ASSOCF_INIT_FOR_FILE: ASSOCF = ASSOCF(8192u32);
pub const ASSOCF_INIT_IGNOREUNKNOWN: ASSOCF = ASSOCF(1024u32);
pub const ASSOCF_INIT_NOREMAPCLSID: ASSOCF = ASSOCF(1u32);
pub const ASSOCF_IS_FULL_URI: ASSOCF = ASSOCF(16384u32);
pub const ASSOCF_IS_PROTOCOL: ASSOCF = ASSOCF(4096u32);
pub const ASSOCF_NOFIXUPS: ASSOCF = ASSOCF(256u32);
pub const ASSOCF_NONE: ASSOCF = ASSOCF(0u32);
pub const ASSOCF_NOTRUNCATE: ASSOCF = ASSOCF(32u32);
pub const ASSOCF_NOUSERSETTINGS: ASSOCF = ASSOCF(16u32);
pub const ASSOCF_OPEN_BYEXENAME: ASSOCF = ASSOCF(2u32);
pub const ASSOCF_PER_MACHINE_ONLY: ASSOCF = ASSOCF(32768u32);
pub const ASSOCF_REMAPRUNDLL: ASSOCF = ASSOCF(128u32);
pub const ASSOCF_VERIFY: ASSOCF = ASSOCF(64u32);
#[repr(C, packed(1))]
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_System_Registry")]
#[derive(Clone, Copy, Default)]
pub struct ASSOCIATIONELEMENT {
    pub ac: ASSOCCLASS,
    pub hkClass: super::super::System::Registry::HKEY,
    pub pszClass: windows_core::PCWSTR,
}
#[repr(C)]
#[cfg(any(target_arch = "aarch64", target_arch = "arm64ec", target_arch = "x86_64"))]
#[cfg(feature = "Win32_System_Registry")]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct ASSOCIATIONELEMENT {
    pub ac: ASSOCCLASS,
    pub hkClass: super::super::System::Registry::HKEY,
    pub pszClass: windows_core::PCWSTR,
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct ASSOCIATIONLEVEL(pub i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct ASSOCIATIONTYPE(pub i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct ASSOCKEY(pub i32);
pub const ASSOCKEY_APP: ASSOCKEY = ASSOCKEY(2i32);
pub const ASSOCKEY_BASECLASS: ASSOCKEY = ASSOCKEY(4i32);
pub const ASSOCKEY_CLASS: ASSOCKEY = ASSOCKEY(3i32);
pub const ASSOCKEY_MAX: ASSOCKEY = ASSOCKEY(5i32);
pub const ASSOCKEY_SHELLEXECCLASS: ASSOCKEY = ASSOCKEY(1i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct ASSOCSTR(pub i32);
pub const ASSOCSTR_APPICONREFERENCE: ASSOCSTR = ASSOCSTR(23i32);
pub const ASSOCSTR_APPID: ASSOCSTR = ASSOCSTR(21i32);
pub const ASSOCSTR_APPPUBLISHER: ASSOCSTR = ASSOCSTR(22i32);
pub const ASSOCSTR_COMMAND: ASSOCSTR = ASSOCSTR(1i32);
pub const ASSOCSTR_CONTENTTYPE: ASSOCSTR = ASSOCSTR(14i32);
pub const ASSOCSTR_DDEAPPLICATION: ASSOCSTR = ASSOCSTR(9i32);
pub const ASSOCSTR_DDECOMMAND: ASSOCSTR = ASSOCSTR(7i32);
pub const ASSOCSTR_DDEIFEXEC: ASSOCSTR = ASSOCSTR(8i32);
pub const ASSOCSTR_DDETOPIC: ASSOCSTR = ASSOCSTR(10i32);
pub const ASSOCSTR_DEFAULTICON: ASSOCSTR = ASSOCSTR(15i32);
pub const ASSOCSTR_DELEGATEEXECUTE: ASSOCSTR = ASSOCSTR(18i32);
pub const ASSOCSTR_DROPTARGET: ASSOCSTR = ASSOCSTR(17i32);
pub const ASSOCSTR_EXECUTABLE: ASSOCSTR = ASSOCSTR(2i32);
pub const ASSOCSTR_FRIENDLYAPPNAME: ASSOCSTR = ASSOCSTR(4i32);
pub const ASSOCSTR_FRIENDLYDOCNAME: ASSOCSTR = ASSOCSTR(3i32);
pub const ASSOCSTR_INFOTIP: ASSOCSTR = ASSOCSTR(11i32);
pub const ASSOCSTR_MAX: ASSOCSTR = ASSOCSTR(24i32);
pub const ASSOCSTR_NOOPEN: ASSOCSTR = ASSOCSTR(5i32);
pub const ASSOCSTR_PROGID: ASSOCSTR = ASSOCSTR(20i32);
pub const ASSOCSTR_QUICKTIP: ASSOCSTR = ASSOCSTR(12i32);
pub const ASSOCSTR_SHELLEXTENSION: ASSOCSTR = ASSOCSTR(16i32);
pub const ASSOCSTR_SHELLNEWVALUE: ASSOCSTR = ASSOCSTR(6i32);
pub const ASSOCSTR_SUPPORTED_URI_PROTOCOLS: ASSOCSTR = ASSOCSTR(19i32);
pub const ASSOCSTR_TILEINFO: ASSOCSTR = ASSOCSTR(13i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct ASSOC_FILTER(pub i32);
impl ASSOC_FILTER {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl core::ops::BitOr for ASSOC_FILTER {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl core::ops::BitAnd for ASSOC_FILTER {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl core::ops::BitOrAssign for ASSOC_FILTER {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl core::ops::BitAndAssign for ASSOC_FILTER {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl core::ops::Not for ASSOC_FILTER {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
pub const ASSOC_FILTER_NONE: ASSOC_FILTER = ASSOC_FILTER(0i32);
pub const ASSOC_FILTER_RECOMMENDED: ASSOC_FILTER = ASSOC_FILTER(1i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct ATTACHMENT_ACTION(pub i32);
pub const ATTACHMENT_ACTION_CANCEL: ATTACHMENT_ACTION = ATTACHMENT_ACTION(0i32);
pub const ATTACHMENT_ACTION_EXEC: ATTACHMENT_ACTION = ATTACHMENT_ACTION(2i32);
pub const ATTACHMENT_ACTION_SAVE: ATTACHMENT_ACTION = ATTACHMENT_ACTION(1i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct ATTACHMENT_PROMPT(pub i32);
pub const ATTACHMENT_PROMPT_EXEC: ATTACHMENT_PROMPT = ATTACHMENT_PROMPT(2i32);
pub const ATTACHMENT_PROMPT_EXEC_OR_SAVE: ATTACHMENT_PROMPT = ATTACHMENT_PROMPT(3i32);
pub const ATTACHMENT_PROMPT_NONE: ATTACHMENT_PROMPT = ATTACHMENT_PROMPT(0i32);
pub const ATTACHMENT_PROMPT_SAVE: ATTACHMENT_PROMPT = ATTACHMENT_PROMPT(1i32);
pub const AT_FILEEXTENSION: ASSOCIATIONTYPE = ASSOCIATIONTYPE(0i32);
pub const AT_MIMETYPE: ASSOCIATIONTYPE = ASSOCIATIONTYPE(3i32);
pub const AT_STARTMENUCLIENT: ASSOCIATIONTYPE = ASSOCIATIONTYPE(2i32);
pub const AT_URLPROTOCOL: ASSOCIATIONTYPE = ASSOCIATIONTYPE(1i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct AUTOCOMPLETELISTOPTIONS(pub i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct AUTOCOMPLETEOPTIONS(pub i32);
#[repr(C, packed(1))]
#[derive(Clone, Copy)]
pub struct AUTO_SCROLL_DATA {
    pub iNextSample: i32,
    pub dwLastScroll: u32,
    pub bFull: windows_core::BOOL,
    pub pts: [super::super::Foundation::POINT; 3],
    pub dwTimes: [u32; 3],
}
impl Default for AUTO_SCROLL_DATA {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const AVMW_320: APPLICATION_VIEW_MIN_WIDTH = APPLICATION_VIEW_MIN_WIDTH(1i32);
pub const AVMW_500: APPLICATION_VIEW_MIN_WIDTH = APPLICATION_VIEW_MIN_WIDTH(2i32);
pub const AVMW_DEFAULT: APPLICATION_VIEW_MIN_WIDTH = APPLICATION_VIEW_MIN_WIDTH(0i32);
pub const AVO_LANDSCAPE: APPLICATION_VIEW_ORIENTATION = APPLICATION_VIEW_ORIENTATION(0i32);
pub const AVO_PORTRAIT: APPLICATION_VIEW_ORIENTATION = APPLICATION_VIEW_ORIENTATION(1i32);
pub const AVSP_CUSTOM: APPLICATION_VIEW_SIZE_PREFERENCE = APPLICATION_VIEW_SIZE_PREFERENCE(6i32);
pub const AVSP_DEFAULT: APPLICATION_VIEW_SIZE_PREFERENCE = APPLICATION_VIEW_SIZE_PREFERENCE(0i32);
pub const AVSP_USE_HALF: APPLICATION_VIEW_SIZE_PREFERENCE = APPLICATION_VIEW_SIZE_PREFERENCE(2i32);
pub const AVSP_USE_LESS: APPLICATION_VIEW_SIZE_PREFERENCE = APPLICATION_VIEW_SIZE_PREFERENCE(1i32);
pub const AVSP_USE_MINIMUM: APPLICATION_VIEW_SIZE_PREFERENCE = APPLICATION_VIEW_SIZE_PREFERENCE(4i32);
pub const AVSP_USE_MORE: APPLICATION_VIEW_SIZE_PREFERENCE = APPLICATION_VIEW_SIZE_PREFERENCE(3i32);
pub const AVSP_USE_NONE: APPLICATION_VIEW_SIZE_PREFERENCE = APPLICATION_VIEW_SIZE_PREFERENCE(5i32);
pub const AVS_FILLED: APPLICATION_VIEW_STATE = APPLICATION_VIEW_STATE(1i32);
pub const AVS_FULLSCREEN_LANDSCAPE: APPLICATION_VIEW_STATE = APPLICATION_VIEW_STATE(0i32);
pub const AVS_FULLSCREEN_PORTRAIT: APPLICATION_VIEW_STATE = APPLICATION_VIEW_STATE(3i32);
pub const AVS_SNAPPED: APPLICATION_VIEW_STATE = APPLICATION_VIEW_STATE(2i32);
pub const AccessibilityDockingService: windows_core::GUID = windows_core::GUID::from_u128(0x29ce1d46_b481_4aa0_a08a_d3ebc8aca402);
pub const AllowSmallerSize: ThumbnailStreamCacheOptions = ThumbnailStreamCacheOptions(4i32);
pub const AlphabeticalCategorizer: windows_core::GUID = windows_core::GUID::from_u128(0x3c2654c6_7372_4f6b_b310_55d6128f49d2);
pub const AppShellVerbHandler: windows_core::GUID = windows_core::GUID::from_u128(0x4ed3a719_cea8_4bd9_910d_e252f997afc2);
pub const AppStartupLink: windows_core::GUID = windows_core::GUID::from_u128(0x273eb5e7_88b0_4843_bfef_e2c81d43aae5);
pub const AppVisibility: windows_core::GUID = windows_core::GUID::from_u128(0x7e5fe3d9_985f_4908_91f9_ee19f9fd1514);
pub const ApplicationActivationManager: windows_core::GUID = windows_core::GUID::from_u128(0x45ba127d_10a8_46ea_8ab7_56ea9078943c);
pub const ApplicationAssociationRegistration: windows_core::GUID = windows_core::GUID::from_u128(0x591209c7_767b_42b2_9fba_44ee4615f2c7);
pub const ApplicationAssociationRegistrationUI: windows_core::GUID = windows_core::GUID::from_u128(0x1968106d_f3b5_44cf_890e_116fcb9ecef1);
pub const ApplicationDesignModeSettings: windows_core::GUID = windows_core::GUID::from_u128(0x958a6fb5_dcb2_4faf_aafd_7fb054ad1a3b);
pub const ApplicationDestinations: windows_core::GUID = windows_core::GUID::from_u128(0x86c14003_4d6b_4ef3_a7b4_0506663b2e68);
pub const ApplicationDocumentLists: windows_core::GUID = windows_core::GUID::from_u128(0x86bec222_30f2_47e0_9f25_60d11cd75c28);
pub const AttachmentServices: windows_core::GUID = windows_core::GUID::from_u128(0x4125dd96_e03a_4103_8f70_e0597d803b9c);
#[repr(C)]
#[cfg(feature = "Win32_UI_Shell_Common")]
#[derive(Clone, Debug, PartialEq)]
pub struct BANDINFOSFB {
    pub dwMask: u32,
    pub dwStateMask: u32,
    pub dwState: u32,
    pub crBkgnd: super::super::Foundation::COLORREF,
    pub crBtnLt: super::super::Foundation::COLORREF,
    pub crBtnDk: super::super::Foundation::COLORREF,
    pub wViewMode: u16,
    pub wAlign: u16,
    pub psf: core::mem::ManuallyDrop<Option<IShellFolder>>,
    pub pidl: *mut Common::ITEMIDLIST,
}
#[cfg(feature = "Win32_UI_Shell_Common")]
impl Default for BANDINFOSFB {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct BANDSITECID(pub i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct BANDSITEINFO {
    pub dwMask: u32,
    pub dwState: u32,
    pub dwStyle: u32,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct BANNER_NOTIFICATION {
    pub event: BANNER_NOTIFICATION_EVENT,
    pub providerIdentity: windows_core::PCWSTR,
    pub contentId: windows_core::PCWSTR,
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct BANNER_NOTIFICATION_EVENT(pub i32);
#[repr(C)]
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
#[derive(Clone, Debug, PartialEq)]
pub struct BASEBROWSERDATALH {
    pub _hwnd: super::super::Foundation::HWND,
    pub _ptl: core::mem::ManuallyDrop<Option<ITravelLog>>,
    pub _phlf: core::mem::ManuallyDrop<Option<IHlinkFrame>>,
    pub _pautoWB2: core::mem::ManuallyDrop<Option<IWebBrowser2>>,
    pub _pautoEDS: core::mem::ManuallyDrop<Option<IExpDispSupport>>,
    pub _pautoSS: core::mem::ManuallyDrop<Option<IShellService>>,
    pub _eSecureLockIcon: i32,
    pub _bitfield: u32,
    pub _uActivateState: u32,
    pub _pidlViewState: *mut Common::ITEMIDLIST,
    pub _pctView: core::mem::ManuallyDrop<Option<super::super::System::Ole::IOleCommandTarget>>,
    pub _pidlCur: *mut Common::ITEMIDLIST,
    pub _psv: core::mem::ManuallyDrop<Option<IShellView>>,
    pub _psf: core::mem::ManuallyDrop<Option<IShellFolder>>,
    pub _hwndView: super::super::Foundation::HWND,
    pub _pszTitleCur: windows_core::PWSTR,
    pub _pidlPending: *mut Common::ITEMIDLIST,
    pub _psvPending: core::mem::ManuallyDrop<Option<IShellView>>,
    pub _psfPending: core::mem::ManuallyDrop<Option<IShellFolder>>,
    pub _hwndViewPending: super::super::Foundation::HWND,
    pub _pszTitlePending: windows_core::PWSTR,
    pub _fIsViewMSHTML: windows_core::BOOL,
    pub _fPrivacyImpacted: windows_core::BOOL,
    pub _clsidView: windows_core::GUID,
    pub _clsidViewPending: windows_core::GUID,
    pub _hwndFrame: super::super::Foundation::HWND,
    pub _lPhishingFilterStatus: i32,
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
impl Default for BASEBROWSERDATALH {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
#[derive(Clone, Debug, PartialEq)]
pub struct BASEBROWSERDATAXP {
    pub _hwnd: super::super::Foundation::HWND,
    pub _ptl: core::mem::ManuallyDrop<Option<ITravelLog>>,
    pub _phlf: core::mem::ManuallyDrop<Option<IHlinkFrame>>,
    pub _pautoWB2: core::mem::ManuallyDrop<Option<IWebBrowser2>>,
    pub _pautoEDS: core::mem::ManuallyDrop<Option<IExpDispSupportXP>>,
    pub _pautoSS: core::mem::ManuallyDrop<Option<IShellService>>,
    pub _eSecureLockIcon: i32,
    pub _bitfield: u32,
    pub _uActivateState: u32,
    pub _pidlViewState: *mut Common::ITEMIDLIST,
    pub _pctView: core::mem::ManuallyDrop<Option<super::super::System::Ole::IOleCommandTarget>>,
    pub _pidlCur: *mut Common::ITEMIDLIST,
    pub _psv: core::mem::ManuallyDrop<Option<IShellView>>,
    pub _psf: core::mem::ManuallyDrop<Option<IShellFolder>>,
    pub _hwndView: super::super::Foundation::HWND,
    pub _pszTitleCur: windows_core::PWSTR,
    pub _pidlPending: *mut Common::ITEMIDLIST,
    pub _psvPending: core::mem::ManuallyDrop<Option<IShellView>>,
    pub _psfPending: core::mem::ManuallyDrop<Option<IShellFolder>>,
    pub _hwndViewPending: super::super::Foundation::HWND,
    pub _pszTitlePending: windows_core::PWSTR,
    pub _fIsViewMSHTML: windows_core::BOOL,
    pub _fPrivacyImpacted: windows_core::BOOL,
    pub _clsidView: windows_core::GUID,
    pub _clsidViewPending: windows_core::GUID,
    pub _hwndFrame: super::super::Foundation::HWND,
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
impl Default for BASEBROWSERDATAXP {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub type BFFCALLBACK = Option<unsafe extern "system" fn(hwnd: super::super::Foundation::HWND, umsg: u32, lparam: super::super::Foundation::LPARAM, lpdata: super::super::Foundation::LPARAM) -> i32>;
pub const BFFM_ENABLEOK: u32 = 1125u32;
pub const BFFM_INITIALIZED: u32 = 1u32;
pub const BFFM_IUNKNOWN: u32 = 5u32;
pub const BFFM_SELCHANGED: u32 = 2u32;
pub const BFFM_SETEXPANDED: u32 = 1130u32;
pub const BFFM_SETOKTEXT: u32 = 1129u32;
pub const BFFM_SETSELECTION: u32 = 1127u32;
pub const BFFM_SETSELECTIONA: u32 = 1126u32;
pub const BFFM_SETSELECTIONW: u32 = 1127u32;
pub const BFFM_SETSTATUSTEXT: u32 = 1128u32;
pub const BFFM_SETSTATUSTEXTA: u32 = 1124u32;
pub const BFFM_SETSTATUSTEXTW: u32 = 1128u32;
pub const BFFM_VALIDATEFAILED: u32 = 4u32;
pub const BFFM_VALIDATEFAILEDA: u32 = 3u32;
pub const BFFM_VALIDATEFAILEDW: u32 = 4u32;
pub const BFO_ADD_IE_TOCAPTIONBAR: _BROWSERFRAMEOPTIONS = _BROWSERFRAMEOPTIONS(512i32);
pub const BFO_BOTH_OPTIONS: _BROWSERFRAMEOPTIONS = _BROWSERFRAMEOPTIONS(4i32);
pub const BFO_BROWSER_PERSIST_SETTINGS: _BROWSERFRAMEOPTIONS = _BROWSERFRAMEOPTIONS(1i32);
pub const BFO_BROWSE_NO_IN_NEW_PROCESS: _BROWSERFRAMEOPTIONS = _BROWSERFRAMEOPTIONS(16i32);
pub const BFO_ENABLE_HYPERLINK_TRACKING: _BROWSERFRAMEOPTIONS = _BROWSERFRAMEOPTIONS(32i32);
pub const BFO_GO_HOME_PAGE: _BROWSERFRAMEOPTIONS = _BROWSERFRAMEOPTIONS(16384i32);
pub const BFO_NONE: _BROWSERFRAMEOPTIONS = _BROWSERFRAMEOPTIONS(0i32);
pub const BFO_NO_PARENT_FOLDER_SUPPORT: _BROWSERFRAMEOPTIONS = _BROWSERFRAMEOPTIONS(4096i32);
pub const BFO_NO_REOPEN_NEXT_RESTART: _BROWSERFRAMEOPTIONS = _BROWSERFRAMEOPTIONS(8192i32);
pub const BFO_PREFER_IEPROCESS: _BROWSERFRAMEOPTIONS = _BROWSERFRAMEOPTIONS(32768i32);
pub const BFO_QUERY_ALL: _BROWSERFRAMEOPTIONS = _BROWSERFRAMEOPTIONS(-1i32);
pub const BFO_RENAME_FOLDER_OPTIONS_TOINTERNET: _BROWSERFRAMEOPTIONS = _BROWSERFRAMEOPTIONS(2i32);
pub const BFO_SHOW_NAVIGATION_CANCELLED: _BROWSERFRAMEOPTIONS = _BROWSERFRAMEOPTIONS(65536i32);
pub const BFO_SUBSTITUE_INTERNET_START_PAGE: _BROWSERFRAMEOPTIONS = _BROWSERFRAMEOPTIONS(128i32);
pub const BFO_USE_DIALUP_REF: _BROWSERFRAMEOPTIONS = _BROWSERFRAMEOPTIONS(1024i32);
pub const BFO_USE_IE_LOGOBANDING: _BROWSERFRAMEOPTIONS = _BROWSERFRAMEOPTIONS(256i32);
pub const BFO_USE_IE_OFFLINE_SUPPORT: _BROWSERFRAMEOPTIONS = _BROWSERFRAMEOPTIONS(64i32);
pub const BFO_USE_IE_STATUSBAR: _BROWSERFRAMEOPTIONS = _BROWSERFRAMEOPTIONS(131072i32);
pub const BFO_USE_IE_TOOLBAR: _BROWSERFRAMEOPTIONS = _BROWSERFRAMEOPTIONS(2048i32);
pub const BHID_AssociationArray: windows_core::GUID = windows_core::GUID::from_u128(0xbea9ef17_82f1_4f60_9284_4f8db75c3be9);
pub const BHID_DataObject: windows_core::GUID = windows_core::GUID::from_u128(0xb8c0bd9f_ed24_455c_83e6_d5390c4fe8c4);
pub const BHID_EnumAssocHandlers: windows_core::GUID = windows_core::GUID::from_u128(0xb8ab0b9c_c2ec_4f7a_918d_314900e6280a);
pub const BHID_EnumItems: windows_core::GUID = windows_core::GUID::from_u128(0x94f60519_2850_4924_aa5a_d15e84868039);
pub const BHID_FilePlaceholder: windows_core::GUID = windows_core::GUID::from_u128(0x8677dceb_aae0_4005_8d3d_547fa852f825);
pub const BHID_Filter: windows_core::GUID = windows_core::GUID::from_u128(0x38d08778_f557_4690_9ebf_ba54706ad8f7);
pub const BHID_LinkTargetItem: windows_core::GUID = windows_core::GUID::from_u128(0x3981e228_f559_11d3_8e3a_00c04f6837d5);
pub const BHID_PropertyStore: windows_core::GUID = windows_core::GUID::from_u128(0x0384e1a4_1523_439c_a4c8_ab911052f586);
pub const BHID_RandomAccessStream: windows_core::GUID = windows_core::GUID::from_u128(0xf16fc93b_77ae_4cfe_bda7_a866eea6878d);
pub const BHID_SFObject: windows_core::GUID = windows_core::GUID::from_u128(0x3981e224_f559_11d3_8e3a_00c04f6837d5);
pub const BHID_SFUIObject: windows_core::GUID = windows_core::GUID::from_u128(0x3981e225_f559_11d3_8e3a_00c04f6837d5);
pub const BHID_SFViewObject: windows_core::GUID = windows_core::GUID::from_u128(0x3981e226_f559_11d3_8e3a_00c04f6837d5);
pub const BHID_Storage: windows_core::GUID = windows_core::GUID::from_u128(0x3981e227_f559_11d3_8e3a_00c04f6837d5);
pub const BHID_StorageEnum: windows_core::GUID = windows_core::GUID::from_u128(0x4621a4e3_f0d6_4773_8a9c_46e77b174840);
pub const BHID_StorageItem: windows_core::GUID = windows_core::GUID::from_u128(0x404e2109_77d2_4699_a5a0_4fdf10db9837);
pub const BHID_Stream: windows_core::GUID = windows_core::GUID::from_u128(0x1cebb3ab_7c10_499a_a417_92ca16c4cb83);
pub const BHID_ThumbnailHandler: windows_core::GUID = windows_core::GUID::from_u128(0x7b2e650a_8e20_4f4a_b09e_6597afc72fb0);
pub const BHID_Transfer: windows_core::GUID = windows_core::GUID::from_u128(0xd5e346a1_f753_4932_b403_4574800e2498);
pub const BIF_BROWSEFILEJUNCTIONS: u32 = 65536u32;
pub const BIF_BROWSEFORCOMPUTER: u32 = 4096u32;
pub const BIF_BROWSEFORPRINTER: u32 = 8192u32;
pub const BIF_BROWSEINCLUDEFILES: u32 = 16384u32;
pub const BIF_BROWSEINCLUDEURLS: u32 = 128u32;
pub const BIF_DONTGOBELOWDOMAIN: u32 = 2u32;
pub const BIF_EDITBOX: u32 = 16u32;
pub const BIF_NEWDIALOGSTYLE: u32 = 64u32;
pub const BIF_NONEWFOLDERBUTTON: u32 = 512u32;
pub const BIF_NOTRANSLATETARGETS: u32 = 1024u32;
pub const BIF_PREFER_INTERNET_SHORTCUT: _BROWSERFRAMEOPTIONS = _BROWSERFRAMEOPTIONS(8i32);
pub const BIF_RETURNFSANCESTORS: u32 = 8u32;
pub const BIF_RETURNONLYFSDIRS: u32 = 1u32;
pub const BIF_SHAREABLE: u32 = 32768u32;
pub const BIF_STATUSTEXT: u32 = 4u32;
pub const BIF_UAHINT: u32 = 256u32;
pub const BIF_VALIDATE: u32 = 32u32;
pub const BIND_INTERRUPTABLE: u32 = 4294967295u32;
pub const BMICON_LARGE: i32 = 0i32;
pub const BMICON_SMALL: i32 = 1i32;
pub const BNE_Button1Clicked: BANNER_NOTIFICATION_EVENT = BANNER_NOTIFICATION_EVENT(4i32);
pub const BNE_Button2Clicked: BANNER_NOTIFICATION_EVENT = BANNER_NOTIFICATION_EVENT(5i32);
pub const BNE_Closed: BANNER_NOTIFICATION_EVENT = BANNER_NOTIFICATION_EVENT(2i32);
pub const BNE_Dismissed: BANNER_NOTIFICATION_EVENT = BANNER_NOTIFICATION_EVENT(3i32);
pub const BNE_Hovered: BANNER_NOTIFICATION_EVENT = BANNER_NOTIFICATION_EVENT(1i32);
pub const BNE_Rendered: BANNER_NOTIFICATION_EVENT = BANNER_NOTIFICATION_EVENT(0i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct BNSTATE(pub i32);
pub const BNS_BEGIN_NAVIGATE: BNSTATE = BNSTATE(1i32);
pub const BNS_NAVIGATE: BNSTATE = BNSTATE(2i32);
pub const BNS_NORMAL: BNSTATE = BNSTATE(0i32);
#[repr(C)]
#[cfg(feature = "Win32_UI_Shell_Common")]
#[derive(Clone, Copy, Debug)]
pub struct BROWSEINFOA {
    pub hwndOwner: super::super::Foundation::HWND,
    pub pidlRoot: *mut Common::ITEMIDLIST,
    pub pszDisplayName: windows_core::PSTR,
    pub lpszTitle: windows_core::PCSTR,
    pub ulFlags: u32,
    pub lpfn: BFFCALLBACK,
    pub lParam: super::super::Foundation::LPARAM,
    pub iImage: i32,
}
#[cfg(feature = "Win32_UI_Shell_Common")]
impl Default for BROWSEINFOA {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(feature = "Win32_UI_Shell_Common")]
#[derive(Clone, Copy, Debug)]
pub struct BROWSEINFOW {
    pub hwndOwner: super::super::Foundation::HWND,
    pub pidlRoot: *mut Common::ITEMIDLIST,
    pub pszDisplayName: windows_core::PWSTR,
    pub lpszTitle: windows_core::PCWSTR,
    pub ulFlags: u32,
    pub lpfn: BFFCALLBACK,
    pub lParam: super::super::Foundation::LPARAM,
    pub iImage: i32,
}
#[cfg(feature = "Win32_UI_Shell_Common")]
impl Default for BROWSEINFOW {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const BSF_CANMAXIMIZE: u32 = 1024u32;
pub const BSF_DELEGATEDNAVIGATION: u32 = 65536u32;
pub const BSF_DONTSHOWNAVCANCELPAGE: u32 = 16384u32;
pub const BSF_FEEDNAVIGATION: u32 = 524288u32;
pub const BSF_FEEDSUBSCRIBED: u32 = 1048576u32;
pub const BSF_HTMLNAVCANCELED: u32 = 8192u32;
pub const BSF_MERGEDMENUS: u32 = 262144u32;
pub const BSF_NAVNOHISTORY: u32 = 4096u32;
pub const BSF_NOLOCALFILEWARNING: u32 = 16u32;
pub const BSF_REGISTERASDROPTARGET: u32 = 1u32;
pub const BSF_RESIZABLE: u32 = 512u32;
pub const BSF_SETNAVIGATABLECODEPAGE: u32 = 32768u32;
pub const BSF_THEATERMODE: u32 = 2u32;
pub const BSF_TOPBROWSER: u32 = 2048u32;
pub const BSF_TRUSTEDFORACTIVEX: u32 = 131072u32;
pub const BSF_UISETBYAUTOMATION: u32 = 256u32;
pub const BSID_BANDADDED: BANDSITECID = BANDSITECID(0i32);
pub const BSID_BANDREMOVED: BANDSITECID = BANDSITECID(1i32);
pub const BSIM_STATE: u32 = 1u32;
pub const BSIM_STYLE: u32 = 2u32;
pub const BSIS_ALWAYSGRIPPER: u32 = 2u32;
pub const BSIS_AUTOGRIPPER: u32 = 0u32;
pub const BSIS_FIXEDORDER: u32 = 1024u32;
pub const BSIS_LEFTALIGN: u32 = 4u32;
pub const BSIS_LOCKED: u32 = 256u32;
pub const BSIS_NOCAPTION: u32 = 64u32;
pub const BSIS_NOCONTEXTMENU: u32 = 16u32;
pub const BSIS_NODROPTARGET: u32 = 32u32;
pub const BSIS_NOGRIPPER: u32 = 1u32;
pub const BSIS_PREFERNOLINEBREAK: u32 = 128u32;
pub const BSIS_PRESERVEORDERDURINGLAYOUT: u32 = 512u32;
pub const BSIS_SINGLECLICK: u32 = 8u32;
pub const BSSF_NOTITLE: u32 = 2u32;
pub const BSSF_UNDELETEABLE: u32 = 4096u32;
pub const BSSF_VISIBLE: u32 = 1u32;
pub const BUFFLEN: u32 = 255u32;
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct BrowserNavConstants(pub i32);
#[repr(C, packed(1))]
#[derive(Clone, Copy, Default)]
pub struct CABINETSTATE {
    pub cLength: u16,
    pub nVersion: u16,
    pub _bitfield: i32,
    pub fMenuEnumFilter: u32,
}
pub const CABINETSTATE_VERSION: u32 = 2u32;
pub const CAMERAROLL_E_NO_DOWNSAMPLING_REQUIRED: windows_core::HRESULT = windows_core::HRESULT(0x80270120_u32 as _);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct CATEGORYINFO_FLAGS(pub i32);
impl CATEGORYINFO_FLAGS {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl core::ops::BitOr for CATEGORYINFO_FLAGS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl core::ops::BitAnd for CATEGORYINFO_FLAGS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl core::ops::BitOrAssign for CATEGORYINFO_FLAGS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl core::ops::BitAndAssign for CATEGORYINFO_FLAGS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl core::ops::Not for CATEGORYINFO_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct CATEGORY_INFO {
    pub cif: CATEGORYINFO_FLAGS,
    pub wszName: [u16; 260],
}
impl Default for CATEGORY_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const CATID_BrowsableShellExt: windows_core::GUID = windows_core::GUID::from_u128(0x00021490_0000_0000_c000_000000000046);
pub const CATID_BrowseInPlace: windows_core::GUID = windows_core::GUID::from_u128(0x00021491_0000_0000_c000_000000000046);
pub const CATID_CommBand: windows_core::GUID = windows_core::GUID::from_u128(0x00021494_0000_0000_c000_000000000046);
pub const CATID_DeskBand: windows_core::GUID = windows_core::GUID::from_u128(0x00021492_0000_0000_c000_000000000046);
pub const CATID_FilePlaceholderMergeHandler: windows_core::GUID = windows_core::GUID::from_u128(0x3e9c9a51_d4aa_4870_b47c_7424b491f1cc);
pub const CATID_InfoBand: windows_core::GUID = windows_core::GUID::from_u128(0x00021493_0000_0000_c000_000000000046);
pub const CATID_LocationFactory: windows_core::GUID = windows_core::GUID::from_u128(0x965c4d51_8b76_4e57_80b7_564d2ea4b55e);
pub const CATID_LocationProvider: windows_core::GUID = windows_core::GUID::from_u128(0x1b3ca474_2614_414b_b813_1aceca3e3dd8);
pub const CATID_SearchableApplication: windows_core::GUID = windows_core::GUID::from_u128(0x366c292a_d9b3_4dbf_bb70_e62ec3d0bbbf);
pub const CATINFO_COLLAPSED: CATEGORYINFO_FLAGS = CATEGORYINFO_FLAGS(1i32);
pub const CATINFO_EXPANDED: CATEGORYINFO_FLAGS = CATEGORYINFO_FLAGS(4i32);
pub const CATINFO_HIDDEN: CATEGORYINFO_FLAGS = CATEGORYINFO_FLAGS(2i32);
pub const CATINFO_NOHEADER: CATEGORYINFO_FLAGS = CATEGORYINFO_FLAGS(8i32);
pub const CATINFO_NOHEADERCOUNT: CATEGORYINFO_FLAGS = CATEGORYINFO_FLAGS(32i32);
pub const CATINFO_NORMAL: CATEGORYINFO_FLAGS = CATEGORYINFO_FLAGS(0i32);
pub const CATINFO_NOTCOLLAPSIBLE: CATEGORYINFO_FLAGS = CATEGORYINFO_FLAGS(16i32);
pub const CATINFO_SEPARATE_IMAGES: CATEGORYINFO_FLAGS = CATEGORYINFO_FLAGS(128i32);
pub const CATINFO_SHOWEMPTY: CATEGORYINFO_FLAGS = CATEGORYINFO_FLAGS(256i32);
pub const CATINFO_SUBSETTED: CATEGORYINFO_FLAGS = CATEGORYINFO_FLAGS(64i32);
pub const CATSORT_DEFAULT: CATSORT_FLAGS = CATSORT_FLAGS(0i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct CATSORT_FLAGS(pub i32);
impl CATSORT_FLAGS {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl core::ops::BitOr for CATSORT_FLAGS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl core::ops::BitAnd for CATSORT_FLAGS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl core::ops::BitOrAssign for CATSORT_FLAGS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl core::ops::BitAndAssign for CATSORT_FLAGS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl core::ops::Not for CATSORT_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
pub const CATSORT_NAME: CATSORT_FLAGS = CATSORT_FLAGS(1i32);
pub const CDB2GVF_ADDSHIELD: u32 = 64u32;
pub const CDB2GVF_ALLOWPREVIEWPANE: u32 = 4u32;
pub const CDB2GVF_ISFILESAVE: u32 = 2u32;
pub const CDB2GVF_ISFOLDERPICKER: u32 = 32u32;
pub const CDB2GVF_NOINCLUDEITEM: u32 = 16u32;
pub const CDB2GVF_NOSELECTVERB: u32 = 8u32;
pub const CDB2GVF_SHOWALLFILES: u32 = 1u32;
pub const CDB2N_CONTEXTMENU_DONE: u32 = 1u32;
pub const CDB2N_CONTEXTMENU_START: u32 = 2u32;
pub const CDBE_RET_DEFAULT: CDBURNINGEXTENSIONRET = CDBURNINGEXTENSIONRET(0i32);
pub const CDBE_RET_DONTRUNOTHEREXTS: CDBURNINGEXTENSIONRET = CDBURNINGEXTENSIONRET(1i32);
pub const CDBE_RET_STOPWIZARD: CDBURNINGEXTENSIONRET = CDBURNINGEXTENSIONRET(2i32);
pub const CDBE_TYPE_ALL: _CDBE_ACTIONS = _CDBE_ACTIONS(-1i32);
pub const CDBE_TYPE_DATA: _CDBE_ACTIONS = _CDBE_ACTIONS(2i32);
pub const CDBE_TYPE_MUSIC: _CDBE_ACTIONS = _CDBE_ACTIONS(1i32);
pub const CDBOSC_KILLFOCUS: u32 = 1u32;
pub const CDBOSC_RENAME: u32 = 3u32;
pub const CDBOSC_SELCHANGE: u32 = 2u32;
pub const CDBOSC_SETFOCUS: u32 = 0u32;
pub const CDBOSC_STATECHANGE: u32 = 4u32;
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct CDBURNINGEXTENSIONRET(pub i32);
pub const CDBurn: windows_core::GUID = windows_core::GUID::from_u128(0xfbeb8a05_beee_4442_804e_409d6c4515e9);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct CDCONTROLSTATEF(pub i32);
impl CDCONTROLSTATEF {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl core::ops::BitOr for CDCONTROLSTATEF {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl core::ops::BitAnd for CDCONTROLSTATEF {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl core::ops::BitOrAssign for CDCONTROLSTATEF {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl core::ops::BitAndAssign for CDCONTROLSTATEF {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl core::ops::Not for CDCONTROLSTATEF {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
pub const CDCS_ENABLED: CDCONTROLSTATEF = CDCONTROLSTATEF(1i32);
pub const CDCS_ENABLEDVISIBLE: CDCONTROLSTATEF = CDCONTROLSTATEF(3i32);
pub const CDCS_INACTIVE: CDCONTROLSTATEF = CDCONTROLSTATEF(0i32);
pub const CDCS_VISIBLE: CDCONTROLSTATEF = CDCONTROLSTATEF(2i32);
pub const CFSTR_AUTOPLAY_SHELLIDLISTS: windows_core::PCWSTR = windows_core::w!("Autoplay Enumerated IDList Array");
pub const CFSTR_DROPDESCRIPTION: windows_core::PCWSTR = windows_core::w!("DropDescription");
pub const CFSTR_FILECONTENTS: windows_core::PCWSTR = windows_core::w!("FileContents");
pub const CFSTR_FILEDESCRIPTOR: windows_core::PCWSTR = windows_core::w!("FileGroupDescriptorW");
pub const CFSTR_FILEDESCRIPTORA: windows_core::PCWSTR = windows_core::w!("FileGroupDescriptor");
pub const CFSTR_FILEDESCRIPTORW: windows_core::PCWSTR = windows_core::w!("FileGroupDescriptorW");
pub const CFSTR_FILENAME: windows_core::PCWSTR = windows_core::w!("FileNameW");
pub const CFSTR_FILENAMEA: windows_core::PCWSTR = windows_core::w!("FileName");
pub const CFSTR_FILENAMEMAP: windows_core::PCWSTR = windows_core::w!("FileNameMapW");
pub const CFSTR_FILENAMEMAPA: windows_core::PCWSTR = windows_core::w!("FileNameMap");
pub const CFSTR_FILENAMEMAPW: windows_core::PCWSTR = windows_core::w!("FileNameMapW");
pub const CFSTR_FILENAMEW: windows_core::PCWSTR = windows_core::w!("FileNameW");
pub const CFSTR_FILE_ATTRIBUTES_ARRAY: windows_core::PCWSTR = windows_core::w!("File Attributes Array");
pub const CFSTR_INDRAGLOOP: windows_core::PCWSTR = windows_core::w!("InShellDragLoop");
pub const CFSTR_INETURL: windows_core::PCWSTR = windows_core::w!("UniformResourceLocatorW");
pub const CFSTR_INETURLA: windows_core::PCWSTR = windows_core::w!("UniformResourceLocator");
pub const CFSTR_INETURLW: windows_core::PCWSTR = windows_core::w!("UniformResourceLocatorW");
pub const CFSTR_INVOKECOMMAND_DROPPARAM: windows_core::PCWSTR = windows_core::w!("InvokeCommand DropParam");
pub const CFSTR_LOGICALPERFORMEDDROPEFFECT: windows_core::PCWSTR = windows_core::w!("Logical Performed DropEffect");
pub const CFSTR_MOUNTEDVOLUME: windows_core::PCWSTR = windows_core::w!("MountedVolume");
pub const CFSTR_NETRESOURCES: windows_core::PCWSTR = windows_core::w!("Net Resource");
pub const CFSTR_PASTESUCCEEDED: windows_core::PCWSTR = windows_core::w!("Paste Succeeded");
pub const CFSTR_PERFORMEDDROPEFFECT: windows_core::PCWSTR = windows_core::w!("Performed DropEffect");
pub const CFSTR_PERSISTEDDATAOBJECT: windows_core::PCWSTR = windows_core::w!("PersistedDataObject");
pub const CFSTR_PREFERREDDROPEFFECT: windows_core::PCWSTR = windows_core::w!("Preferred DropEffect");
pub const CFSTR_PRINTERGROUP: windows_core::PCWSTR = windows_core::w!("PrinterFriendlyName");
pub const CFSTR_SHELLDROPHANDLER: windows_core::PCWSTR = windows_core::w!("DropHandlerCLSID");
pub const CFSTR_SHELLIDLIST: windows_core::PCWSTR = windows_core::w!("Shell IDList Array");
pub const CFSTR_SHELLIDLISTOFFSET: windows_core::PCWSTR = windows_core::w!("Shell Object Offsets");
pub const CFSTR_SHELLURL: windows_core::PCWSTR = windows_core::w!("UniformResourceLocator");
pub const CFSTR_TARGETCLSID: windows_core::PCWSTR = windows_core::w!("TargetCLSID");
pub const CFSTR_UNTRUSTEDDRAGDROP: windows_core::PCWSTR = windows_core::w!("UntrustedDragDrop");
pub const CFSTR_ZONEIDENTIFIER: windows_core::PCWSTR = windows_core::w!("ZoneIdentifier");
pub const CGID_DefView: windows_core::GUID = windows_core::GUID::from_u128(0x4af07f10_d231_11d0_b942_00a0c90312e1);
pub const CGID_Explorer: windows_core::GUID = windows_core::GUID::from_u128(0x000214d0_0000_0000_c000_000000000046);
pub const CGID_ExplorerBarDoc: windows_core::GUID = windows_core::GUID::from_u128(0x000214d3_0000_0000_c000_000000000046);
pub const CGID_MENUDESKBAR: windows_core::GUID = windows_core::GUID::from_u128(0x5c9f0a12_959e_11d0_a3a4_00a0c9082636);
pub const CGID_ShellDocView: windows_core::GUID = windows_core::GUID::from_u128(0x000214d1_0000_0000_c000_000000000046);
pub const CGID_ShellServiceObject: windows_core::GUID = windows_core::GUID::from_u128(0x000214d2_0000_0000_c000_000000000046);
pub const CGID_ShortCut: windows_core::GUID = windows_core::GUID::from_u128(0x93a68750_951a_11d1_946f_000000000000);
#[repr(C, packed(1))]
#[derive(Clone, Copy)]
pub struct CIDA {
    pub cidl: u32,
    pub aoffset: [u32; 1],
}
impl Default for CIDA {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::define_interface!(CIE4ConnectionPoint, CIE4ConnectionPoint_Vtbl, 0);
#[cfg(feature = "Win32_System_Com")]
impl core::ops::Deref for CIE4ConnectionPoint {
    type Target = super::super::System::Com::IConnectionPoint;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::interface_hierarchy!(CIE4ConnectionPoint, windows_core::IUnknown, super::super::System::Com::IConnectionPoint);
#[cfg(feature = "Win32_System_Com")]
impl CIE4ConnectionPoint {
    #[cfg(all(feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub unsafe fn DoInvokeIE4(&self, pf: *mut windows_core::BOOL, ppv: *mut *mut core::ffi::c_void, dispid: i32, pdispparams: *mut super::super::System::Com::DISPPARAMS) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).DoInvokeIE4)(windows_core::Interface::as_raw(self), pf as _, ppv as _, dispid, pdispparams as _).ok() }
    }
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn DoInvokePIDLIE4(&self, dispid: i32, pidl: *mut Common::ITEMIDLIST, fcancancel: bool) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).DoInvokePIDLIE4)(windows_core::Interface::as_raw(self), dispid, pidl as _, fcancancel.into()).ok() }
    }
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct CIE4ConnectionPoint_Vtbl {
    pub base__: super::super::System::Com::IConnectionPoint_Vtbl,
    #[cfg(all(feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub DoInvokeIE4: unsafe extern "system" fn(*mut core::ffi::c_void, *mut windows_core::BOOL, *mut *mut core::ffi::c_void, i32, *mut super::super::System::Com::DISPPARAMS) -> windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_System_Ole", feature = "Win32_System_Variant")))]
    DoInvokeIE4: usize,
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub DoInvokePIDLIE4: unsafe extern "system" fn(*mut core::ffi::c_void, i32, *mut Common::ITEMIDLIST, windows_core::BOOL) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_Common"))]
    DoInvokePIDLIE4: usize,
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant", feature = "Win32_UI_Shell_Common"))]
pub trait CIE4ConnectionPoint_Impl: super::super::System::Com::IConnectionPoint_Impl {
    fn DoInvokeIE4(&self, pf: *mut windows_core::BOOL, ppv: *mut *mut core::ffi::c_void, dispid: i32, pdispparams: *mut super::super::System::Com::DISPPARAMS) -> windows_core::Result<()>;
    fn DoInvokePIDLIE4(&self, dispid: i32, pidl: *mut Common::ITEMIDLIST, fcancancel: windows_core::BOOL) -> windows_core::Result<()>;
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant", feature = "Win32_UI_Shell_Common"))]
impl CIE4ConnectionPoint_Vtbl {
    pub const fn new<Identity: CIE4ConnectionPoint_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn DoInvokeIE4<Identity: CIE4ConnectionPoint_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pf: *mut windows_core::BOOL, ppv: *mut *mut core::ffi::c_void, dispid: i32, pdispparams: *mut super::super::System::Com::DISPPARAMS) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                CIE4ConnectionPoint_Impl::DoInvokeIE4(this, core::mem::transmute_copy(&pf), core::mem::transmute_copy(&ppv), core::mem::transmute_copy(&dispid), core::mem::transmute_copy(&pdispparams)).into()
            }
        }
        unsafe extern "system" fn DoInvokePIDLIE4<Identity: CIE4ConnectionPoint_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dispid: i32, pidl: *mut Common::ITEMIDLIST, fcancancel: windows_core::BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                CIE4ConnectionPoint_Impl::DoInvokePIDLIE4(this, core::mem::transmute_copy(&dispid), core::mem::transmute_copy(&pidl), core::mem::transmute_copy(&fcancancel)).into()
            }
        }
        Self {
            base__: super::super::System::Com::IConnectionPoint_Vtbl::new::<Identity, OFFSET>(),
            DoInvokeIE4: DoInvokeIE4::<Identity, OFFSET>,
            DoInvokePIDLIE4: DoInvokePIDLIE4::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<CIE4ConnectionPoint as windows_core::Interface>::IID || iid == &<super::super::System::Com::IConnectionPoint as windows_core::Interface>::IID
    }
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant", feature = "Win32_UI_Shell_Common"))]
impl windows_core::RuntimeName for CIE4ConnectionPoint {}
pub const CLOSEPROPS_DISCARD: u32 = 1u32;
pub const CLOSEPROPS_NONE: u32 = 0u32;
pub const CLSID_ACLCustomMRU: windows_core::GUID = windows_core::GUID::from_u128(0x6935db93_21e8_4ccc_beb9_9fe3c77a297a);
pub const CLSID_ACLHistory: windows_core::GUID = windows_core::GUID::from_u128(0x00bb2764_6a77_11d0_a535_00c04fd7d062);
pub const CLSID_ACLMRU: windows_core::GUID = windows_core::GUID::from_u128(0x6756a641_de71_11d0_831b_00aa005b4383);
pub const CLSID_ACLMulti: windows_core::GUID = windows_core::GUID::from_u128(0x00bb2765_6a77_11d0_a535_00c04fd7d062);
pub const CLSID_ACListISF: windows_core::GUID = windows_core::GUID::from_u128(0x03c036f1_a186_11d0_824a_00aa005b4383);
pub const CLSID_ActiveDesktop: windows_core::GUID = windows_core::GUID::from_u128(0x75048700_ef1f_11d0_9888_006097deacf9);
pub const CLSID_AutoComplete: windows_core::GUID = windows_core::GUID::from_u128(0x00bb2763_6a77_11d0_a535_00c04fd7d062);
pub const CLSID_CAnchorBrowsePropertyPage: windows_core::GUID = windows_core::GUID::from_u128(0x3050f3bb_98b5_11cf_bb82_00aa00bdce0b);
pub const CLSID_CDocBrowsePropertyPage: windows_core::GUID = windows_core::GUID::from_u128(0x3050f3b4_98b5_11cf_bb82_00aa00bdce0b);
pub const CLSID_CFSIconOverlayManager: windows_core::GUID = windows_core::GUID::from_u128(0x63b51f81_c868_11d0_999c_00c04fd655e1);
pub const CLSID_CImageBrowsePropertyPage: windows_core::GUID = windows_core::GUID::from_u128(0x3050f3b3_98b5_11cf_bb82_00aa00bdce0b);
pub const CLSID_CURLSearchHook: windows_core::GUID = windows_core::GUID::from_u128(0xcfbfae00_17a6_11d0_99cb_00c04fd64497);
pub const CLSID_CUrlHistory: windows_core::GUID = windows_core::GUID::from_u128(0x3c374a40_bae4_11cf_bf7d_00aa006946ee);
pub const CLSID_CUrlHistoryBoth: windows_core::GUID = windows_core::GUID::from_u128(0x6659983c_8476_4eb4_b78c_e5968f326ba0);
pub const CLSID_ControlPanel: windows_core::GUID = windows_core::GUID::from_u128(0x21ec2020_3aea_1069_a2dd_08002b30309d);
pub const CLSID_DarwinAppPublisher: windows_core::GUID = windows_core::GUID::from_u128(0xcfccc7a0_a282_11d1_9082_006008059382);
pub const CLSID_DocHostUIHandler: windows_core::GUID = windows_core::GUID::from_u128(0x7057e952_bd1b_11d1_8919_00c04fc2c836);
pub const CLSID_DragDropHelper: windows_core::GUID = windows_core::GUID::from_u128(0x4657278a_411b_11d2_839a_00c04fd918d0);
pub const CLSID_FileTypes: windows_core::GUID = windows_core::GUID::from_u128(0xb091e540_83e3_11cf_a713_0020afd79762);
pub const CLSID_FolderItemsMultiLevel: windows_core::GUID = windows_core::GUID::from_u128(0x53c74826_ab99_4d33_aca4_3117f51d3788);
pub const CLSID_FolderShortcut: windows_core::GUID = windows_core::GUID::from_u128(0x0afaced1_e828_11d1_9187_b532f1e9575d);
pub const CLSID_HWShellExecute: windows_core::GUID = windows_core::GUID::from_u128(0xffb8655f_81b9_4fce_b89c_9a6ba76d13e7);
pub const CLSID_ISFBand: windows_core::GUID = windows_core::GUID::from_u128(0xd82be2b0_5764_11d0_a96e_00c04fd705a2);
pub const CLSID_Internet: windows_core::GUID = windows_core::GUID::from_u128(0x871c5380_42a0_1069_a2ea_08002b30309d);
pub const CLSID_InternetButtons: windows_core::GUID = windows_core::GUID::from_u128(0x1e796980_9cc5_11d1_a83f_00c04fc99d61);
pub const CLSID_InternetShortcut: windows_core::GUID = windows_core::GUID::from_u128(0xfbf23b40_e3f0_101b_8488_00aa003e56f8);
pub const CLSID_LinkColumnProvider: windows_core::GUID = windows_core::GUID::from_u128(0x24f14f02_7b1c_11d1_838f_0000f80461cf);
pub const CLSID_MSOButtons: windows_core::GUID = windows_core::GUID::from_u128(0x178f34b8_a282_11d2_86c5_00c04f8eea99);
pub const CLSID_MenuBand: windows_core::GUID = windows_core::GUID::from_u128(0x5b4dae26_b807_11d0_9815_00c04fd91972);
pub const CLSID_MenuBandSite: windows_core::GUID = windows_core::GUID::from_u128(0xe13ef4e4_d2f2_11d0_9816_00c04fd91972);
pub const CLSID_MenuToolbarBase: windows_core::GUID = windows_core::GUID::from_u128(0x40b96610_b522_11d1_b3b4_00aa006efde7);
pub const CLSID_MyComputer: windows_core::GUID = windows_core::GUID::from_u128(0x20d04fe0_3aea_1069_a2d8_08002b30309d);
pub const CLSID_MyDocuments: windows_core::GUID = windows_core::GUID::from_u128(0x450d8fba_ad25_11d0_98a8_0800361b1103);
pub const CLSID_NetworkDomain: windows_core::GUID = windows_core::GUID::from_u128(0x46e06680_4bf0_11d1_83ee_00a0c90dc849);
pub const CLSID_NetworkServer: windows_core::GUID = windows_core::GUID::from_u128(0xc0542a90_4bf0_11d1_83ee_00a0c90dc849);
pub const CLSID_NetworkShare: windows_core::GUID = windows_core::GUID::from_u128(0x54a754c0_4bf0_11d1_83ee_00a0c90dc849);
pub const CLSID_NewMenu: windows_core::GUID = windows_core::GUID::from_u128(0xd969a300_e7ff_11d0_a93b_00a0c90f2719);
pub const CLSID_Printers: windows_core::GUID = windows_core::GUID::from_u128(0x2227a280_3aea_1069_a2de_08002b30309d);
pub const CLSID_ProgressDialog: windows_core::GUID = windows_core::GUID::from_u128(0xf8383852_fcd3_11d1_a6b9_006097df5bd4);
pub const CLSID_QueryAssociations: windows_core::GUID = windows_core::GUID::from_u128(0xa07034fd_6caa_4954_ac3f_97a27216f98a);
pub const CLSID_QuickLinks: windows_core::GUID = windows_core::GUID::from_u128(0x0e5cbf21_d15f_11d0_8301_00aa005b4383);
pub const CLSID_RecycleBin: windows_core::GUID = windows_core::GUID::from_u128(0x645ff040_5081_101b_9f08_00aa002f954e);
pub const CLSID_ShellFldSetExt: windows_core::GUID = windows_core::GUID::from_u128(0x6d5313c0_8c62_11d1_b2cd_006097df8c11);
pub const CLSID_ShellThumbnailDiskCache: windows_core::GUID = windows_core::GUID::from_u128(0x1ebdcf80_a200_11d0_a3a4_00c04fd706ec);
pub const CLSID_ToolbarExtButtons: windows_core::GUID = windows_core::GUID::from_u128(0x2ce4b5d8_a28f_11d2_86c5_00c04f8eea99);
pub const CMDID_INTSHORTCUTCREATE: i32 = 1i32;
pub const CMDSTR_NEWFOLDER: windows_core::PCWSTR = windows_core::w!("NewFolder");
pub const CMDSTR_NEWFOLDERA: windows_core::PCSTR = windows_core::s!("NewFolder");
pub const CMDSTR_NEWFOLDERW: windows_core::PCWSTR = windows_core::w!("NewFolder");
pub const CMDSTR_VIEWDETAILS: windows_core::PCWSTR = windows_core::w!("ViewDetails");
pub const CMDSTR_VIEWDETAILSA: windows_core::PCSTR = windows_core::s!("ViewDetails");
pub const CMDSTR_VIEWDETAILSW: windows_core::PCWSTR = windows_core::w!("ViewDetails");
pub const CMDSTR_VIEWLIST: windows_core::PCWSTR = windows_core::w!("ViewList");
pub const CMDSTR_VIEWLISTA: windows_core::PCSTR = windows_core::s!("ViewList");
pub const CMDSTR_VIEWLISTW: windows_core::PCWSTR = windows_core::w!("ViewList");
pub const CMF_ASYNCVERBSTATE: u32 = 1024u32;
pub const CMF_CANRENAME: u32 = 16u32;
pub const CMF_DEFAULTONLY: u32 = 1u32;
pub const CMF_DISABLEDVERBS: u32 = 512u32;
pub const CMF_DONOTPICKDEFAULT: u32 = 8192u32;
pub const CMF_EXPLORE: u32 = 4u32;
pub const CMF_EXTENDEDVERBS: u32 = 256u32;
pub const CMF_INCLUDESTATIC: u32 = 64u32;
pub const CMF_ITEMMENU: u32 = 128u32;
pub const CMF_NODEFAULT: u32 = 32u32;
pub const CMF_NORMAL: u32 = 0u32;
pub const CMF_NOVERBS: u32 = 8u32;
pub const CMF_OPTIMIZEFORINVOKE: u32 = 2048u32;
pub const CMF_RESERVED: u32 = 4294901760u32;
pub const CMF_SYNCCASCADEMENU: u32 = 4096u32;
pub const CMF_VERBSONLY: u32 = 2u32;
pub const CMIC_MASK_CONTROL_DOWN: u32 = 1073741824u32;
pub const CMIC_MASK_PTINVOKE: u32 = 536870912u32;
pub const CMIC_MASK_SHIFT_DOWN: u32 = 268435456u32;
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct CMINVOKECOMMANDINFO {
    pub cbSize: u32,
    pub fMask: u32,
    pub hwnd: super::super::Foundation::HWND,
    pub lpVerb: windows_core::PCSTR,
    pub lpParameters: windows_core::PCSTR,
    pub lpDirectory: windows_core::PCSTR,
    pub nShow: i32,
    pub dwHotKey: u32,
    pub hIcon: super::super::Foundation::HANDLE,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct CMINVOKECOMMANDINFOEX {
    pub cbSize: u32,
    pub fMask: u32,
    pub hwnd: super::super::Foundation::HWND,
    pub lpVerb: windows_core::PCSTR,
    pub lpParameters: windows_core::PCSTR,
    pub lpDirectory: windows_core::PCSTR,
    pub nShow: i32,
    pub dwHotKey: u32,
    pub hIcon: super::super::Foundation::HANDLE,
    pub lpTitle: windows_core::PCSTR,
    pub lpVerbW: windows_core::PCWSTR,
    pub lpParametersW: windows_core::PCWSTR,
    pub lpDirectoryW: windows_core::PCWSTR,
    pub lpTitleW: windows_core::PCWSTR,
    pub ptInvoke: super::super::Foundation::POINT,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct CMINVOKECOMMANDINFOEX_REMOTE {
    pub cbSize: u32,
    pub fMask: u32,
    pub hwnd: super::super::Foundation::HWND,
    pub lpVerbString: windows_core::PCSTR,
    pub lpParameters: windows_core::PCSTR,
    pub lpDirectory: windows_core::PCSTR,
    pub nShow: i32,
    pub dwHotKey: u32,
    pub lpTitle: windows_core::PCSTR,
    pub lpVerbWString: windows_core::PCWSTR,
    pub lpParametersW: windows_core::PCWSTR,
    pub lpDirectoryW: windows_core::PCWSTR,
    pub lpTitleW: windows_core::PCWSTR,
    pub ptInvoke: super::super::Foundation::POINT,
    pub lpVerbInt: u32,
    pub lpVerbWInt: u32,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct CM_COLUMNINFO {
    pub cbSize: u32,
    pub dwMask: u32,
    pub dwState: u32,
    pub uWidth: u32,
    pub uDefaultWidth: u32,
    pub uIdealWidth: u32,
    pub wszName: [u16; 80],
}
impl Default for CM_COLUMNINFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const CM_ENUM_ALL: CM_ENUM_FLAGS = CM_ENUM_FLAGS(1i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct CM_ENUM_FLAGS(pub i32);
impl CM_ENUM_FLAGS {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl core::ops::BitOr for CM_ENUM_FLAGS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl core::ops::BitAnd for CM_ENUM_FLAGS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl core::ops::BitOrAssign for CM_ENUM_FLAGS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl core::ops::BitAndAssign for CM_ENUM_FLAGS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl core::ops::Not for CM_ENUM_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
pub const CM_ENUM_VISIBLE: CM_ENUM_FLAGS = CM_ENUM_FLAGS(2i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct CM_MASK(pub i32);
impl CM_MASK {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl core::ops::BitOr for CM_MASK {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl core::ops::BitAnd for CM_MASK {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl core::ops::BitOrAssign for CM_MASK {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl core::ops::BitAndAssign for CM_MASK {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl core::ops::Not for CM_MASK {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
pub const CM_MASK_DEFAULTWIDTH: CM_MASK = CM_MASK(2i32);
pub const CM_MASK_IDEALWIDTH: CM_MASK = CM_MASK(4i32);
pub const CM_MASK_NAME: CM_MASK = CM_MASK(8i32);
pub const CM_MASK_STATE: CM_MASK = CM_MASK(16i32);
pub const CM_MASK_WIDTH: CM_MASK = CM_MASK(1i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct CM_SET_WIDTH_VALUE(pub i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct CM_STATE(pub i32);
impl CM_STATE {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl core::ops::BitOr for CM_STATE {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl core::ops::BitAnd for CM_STATE {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl core::ops::BitOrAssign for CM_STATE {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl core::ops::BitAndAssign for CM_STATE {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl core::ops::Not for CM_STATE {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
pub const CM_STATE_ALWAYSVISIBLE: CM_STATE = CM_STATE(8i32);
pub const CM_STATE_FIXEDWIDTH: CM_STATE = CM_STATE(2i32);
pub const CM_STATE_NONE: CM_STATE = CM_STATE(0i32);
pub const CM_STATE_NOSORTBYFOLDERNESS: CM_STATE = CM_STATE(4i32);
pub const CM_STATE_VISIBLE: CM_STATE = CM_STATE(1i32);
pub const CM_WIDTH_AUTOSIZE: CM_SET_WIDTH_VALUE = CM_SET_WIDTH_VALUE(-2i32);
pub const CM_WIDTH_USEDEFAULT: CM_SET_WIDTH_VALUE = CM_SET_WIDTH_VALUE(-1i32);
pub const COMPONENT_DEFAULT_LEFT: u32 = 65535u32;
pub const COMPONENT_DEFAULT_TOP: u32 = 65535u32;
pub const COMPONENT_TOP: u32 = 1073741823u32;
pub const COMP_ELEM_CHECKED: u32 = 2u32;
pub const COMP_ELEM_CURITEMSTATE: u32 = 16384u32;
pub const COMP_ELEM_DIRTY: u32 = 4u32;
pub const COMP_ELEM_FRIENDLYNAME: u32 = 1024u32;
pub const COMP_ELEM_NOSCROLL: u32 = 8u32;
pub const COMP_ELEM_ORIGINAL_CSI: u32 = 4096u32;
pub const COMP_ELEM_POS_LEFT: u32 = 16u32;
pub const COMP_ELEM_POS_TOP: u32 = 32u32;
pub const COMP_ELEM_POS_ZINDEX: u32 = 256u32;
pub const COMP_ELEM_RESTORED_CSI: u32 = 8192u32;
pub const COMP_ELEM_SIZE_HEIGHT: u32 = 128u32;
pub const COMP_ELEM_SIZE_WIDTH: u32 = 64u32;
pub const COMP_ELEM_SOURCE: u32 = 512u32;
pub const COMP_ELEM_SUBSCRIBEDURL: u32 = 2048u32;
pub const COMP_ELEM_TYPE: u32 = 1u32;
pub const COMP_TYPE_CFHTML: u32 = 4u32;
pub const COMP_TYPE_CONTROL: u32 = 3u32;
pub const COMP_TYPE_HTMLDOC: u32 = 0u32;
pub const COMP_TYPE_MAX: u32 = 4u32;
pub const COMP_TYPE_PICTURE: u32 = 1u32;
pub const COMP_TYPE_WEBSITE: u32 = 2u32;
#[repr(C)]
#[derive(Clone, Debug, Default, PartialEq)]
pub struct CONFIRM_CONFLICT_ITEM {
    pub pShellItem: core::mem::ManuallyDrop<Option<IShellItem2>>,
    pub pszOriginalName: windows_core::PWSTR,
    pub pszAlternateName: windows_core::PWSTR,
    pub pszLocationShort: windows_core::PWSTR,
    pub pszLocationFull: windows_core::PWSTR,
    pub nType: SYNCMGR_CONFLICT_ITEM_TYPE,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct CONFIRM_CONFLICT_RESULT_INFO {
    pub pszNewName: windows_core::PWSTR,
    pub iItemIndex: u32,
}
pub const CONFLICT_RESOLUTION_CLSID_KEY: windows_core::PCWSTR = windows_core::w!("ConflictResolutionCLSID");
pub const COPYENGINE_E_ACCESSDENIED_READONLY: windows_core::HRESULT = windows_core::HRESULT(0x8027003F_u32 as _);
pub const COPYENGINE_E_ACCESS_DENIED_DEST: windows_core::HRESULT = windows_core::HRESULT(0x80270022_u32 as _);
pub const COPYENGINE_E_ACCESS_DENIED_SRC: windows_core::HRESULT = windows_core::HRESULT(0x80270021_u32 as _);
pub const COPYENGINE_E_ALREADY_EXISTS_FOLDER: windows_core::HRESULT = windows_core::HRESULT(0x8027002C_u32 as _);
pub const COPYENGINE_E_ALREADY_EXISTS_NORMAL: windows_core::HRESULT = windows_core::HRESULT(0x80270029_u32 as _);
pub const COPYENGINE_E_ALREADY_EXISTS_READONLY: windows_core::HRESULT = windows_core::HRESULT(0x8027002A_u32 as _);
pub const COPYENGINE_E_ALREADY_EXISTS_SYSTEM: windows_core::HRESULT = windows_core::HRESULT(0x8027002B_u32 as _);
pub const COPYENGINE_E_BLOCKED_BY_DLP_POLICY: windows_core::HRESULT = windows_core::HRESULT(0x8027004E_u32 as _);
pub const COPYENGINE_E_BLOCKED_BY_EDP_FOR_REMOVABLE_DRIVE: windows_core::HRESULT = windows_core::HRESULT(0x8027004A_u32 as _);
pub const COPYENGINE_E_BLOCKED_BY_EDP_POLICY: windows_core::HRESULT = windows_core::HRESULT(0x80270048_u32 as _);
pub const COPYENGINE_E_CANCELLED: windows_core::HRESULT = windows_core::HRESULT(0x80270001_u32 as _);
pub const COPYENGINE_E_CANNOT_MOVE_FROM_RECYCLE_BIN: windows_core::HRESULT = windows_core::HRESULT(0x80270043_u32 as _);
pub const COPYENGINE_E_CANNOT_MOVE_SHARED_FOLDER: windows_core::HRESULT = windows_core::HRESULT(0x80270044_u32 as _);
pub const COPYENGINE_E_CANT_REACH_SOURCE: windows_core::HRESULT = windows_core::HRESULT(0x80270035_u32 as _);
pub const COPYENGINE_E_DEST_IS_RO_CD: windows_core::HRESULT = windows_core::HRESULT(0x8027000F_u32 as _);
pub const COPYENGINE_E_DEST_IS_RO_DVD: windows_core::HRESULT = windows_core::HRESULT(0x80270012_u32 as _);
pub const COPYENGINE_E_DEST_IS_RW_CD: windows_core::HRESULT = windows_core::HRESULT(0x80270010_u32 as _);
pub const COPYENGINE_E_DEST_IS_RW_DVD: windows_core::HRESULT = windows_core::HRESULT(0x80270013_u32 as _);
pub const COPYENGINE_E_DEST_IS_R_CD: windows_core::HRESULT = windows_core::HRESULT(0x80270011_u32 as _);
pub const COPYENGINE_E_DEST_IS_R_DVD: windows_core::HRESULT = windows_core::HRESULT(0x80270014_u32 as _);
pub const COPYENGINE_E_DEST_SAME_TREE: windows_core::HRESULT = windows_core::HRESULT(0x8027000A_u32 as _);
pub const COPYENGINE_E_DEST_SUBTREE: windows_core::HRESULT = windows_core::HRESULT(0x80270009_u32 as _);
pub const COPYENGINE_E_DIFF_DIR: windows_core::HRESULT = windows_core::HRESULT(0x80270004_u32 as _);
pub const COPYENGINE_E_DIR_NOT_EMPTY: windows_core::HRESULT = windows_core::HRESULT(0x8027003D_u32 as _);
pub const COPYENGINE_E_DISK_FULL: windows_core::HRESULT = windows_core::HRESULT(0x80270032_u32 as _);
pub const COPYENGINE_E_DISK_FULL_CLEAN: windows_core::HRESULT = windows_core::HRESULT(0x80270033_u32 as _);
pub const COPYENGINE_E_EA_LOSS: windows_core::HRESULT = windows_core::HRESULT(0x8027002E_u32 as _);
pub const COPYENGINE_E_EA_NOT_SUPPORTED: windows_core::HRESULT = windows_core::HRESULT(0x80270034_u32 as _);
pub const COPYENGINE_E_ENCRYPTION_LOSS: windows_core::HRESULT = windows_core::HRESULT(0x80270031_u32 as _);
pub const COPYENGINE_E_FAT_MAX_IN_ROOT: windows_core::HRESULT = windows_core::HRESULT(0x8027003E_u32 as _);
pub const COPYENGINE_E_FILE_IS_FLD_DEST: windows_core::HRESULT = windows_core::HRESULT(0x8027000C_u32 as _);
pub const COPYENGINE_E_FILE_TOO_LARGE: windows_core::HRESULT = windows_core::HRESULT(0x8027000D_u32 as _);
pub const COPYENGINE_E_FLD_IS_FILE_DEST: windows_core::HRESULT = windows_core::HRESULT(0x8027000B_u32 as _);
pub const COPYENGINE_E_INTERNET_ITEM_STORAGE_PROVIDER_ERROR: windows_core::HRESULT = windows_core::HRESULT(0x80270045_u32 as _);
pub const COPYENGINE_E_INTERNET_ITEM_STORAGE_PROVIDER_PAUSED: windows_core::HRESULT = windows_core::HRESULT(0x80270046_u32 as _);
pub const COPYENGINE_E_INTERNET_ITEM_UNAVAILABLE: windows_core::HRESULT = windows_core::HRESULT(0x80270042_u32 as _);
pub const COPYENGINE_E_INVALID_FILES_DEST: windows_core::HRESULT = windows_core::HRESULT(0x8027001C_u32 as _);
pub const COPYENGINE_E_INVALID_FILES_SRC: windows_core::HRESULT = windows_core::HRESULT(0x8027001B_u32 as _);
pub const COPYENGINE_E_MANY_SRC_1_DEST: windows_core::HRESULT = windows_core::HRESULT(0x80270005_u32 as _);
pub const COPYENGINE_E_NET_DISCONNECT_DEST: windows_core::HRESULT = windows_core::HRESULT(0x80270026_u32 as _);
pub const COPYENGINE_E_NET_DISCONNECT_SRC: windows_core::HRESULT = windows_core::HRESULT(0x80270025_u32 as _);
pub const COPYENGINE_E_NEWFILE_NAME_TOO_LONG: windows_core::HRESULT = windows_core::HRESULT(0x8027003B_u32 as _);
pub const COPYENGINE_E_NEWFOLDER_NAME_TOO_LONG: windows_core::HRESULT = windows_core::HRESULT(0x8027003C_u32 as _);
pub const COPYENGINE_E_PATH_NOT_FOUND_DEST: windows_core::HRESULT = windows_core::HRESULT(0x80270024_u32 as _);
pub const COPYENGINE_E_PATH_NOT_FOUND_SRC: windows_core::HRESULT = windows_core::HRESULT(0x80270023_u32 as _);
pub const COPYENGINE_E_PATH_TOO_DEEP_DEST: windows_core::HRESULT = windows_core::HRESULT(0x8027001E_u32 as _);
pub const COPYENGINE_E_PATH_TOO_DEEP_SRC: windows_core::HRESULT = windows_core::HRESULT(0x8027001D_u32 as _);
pub const COPYENGINE_E_PROPERTIES_LOSS: windows_core::HRESULT = windows_core::HRESULT(0x80270030_u32 as _);
pub const COPYENGINE_E_PROPERTY_LOSS: windows_core::HRESULT = windows_core::HRESULT(0x8027002F_u32 as _);
pub const COPYENGINE_E_RECYCLE_BIN_NOT_FOUND: windows_core::HRESULT = windows_core::HRESULT(0x8027003A_u32 as _);
pub const COPYENGINE_E_RECYCLE_FORCE_NUKE: windows_core::HRESULT = windows_core::HRESULT(0x80270036_u32 as _);
pub const COPYENGINE_E_RECYCLE_PATH_TOO_LONG: windows_core::HRESULT = windows_core::HRESULT(0x80270038_u32 as _);
pub const COPYENGINE_E_RECYCLE_SIZE_TOO_BIG: windows_core::HRESULT = windows_core::HRESULT(0x80270037_u32 as _);
pub const COPYENGINE_E_RECYCLE_UNKNOWN_ERROR: windows_core::HRESULT = windows_core::HRESULT(0x80270035_u32 as _);
pub const COPYENGINE_E_REDIRECTED_TO_WEBPAGE: windows_core::HRESULT = windows_core::HRESULT(0x80270040_u32 as _);
pub const COPYENGINE_E_REMOVABLE_FULL: windows_core::HRESULT = windows_core::HRESULT(0x8027000E_u32 as _);
pub const COPYENGINE_E_REQUIRES_EDP_CONSENT: windows_core::HRESULT = windows_core::HRESULT(0x80270047_u32 as _);
pub const COPYENGINE_E_REQUIRES_EDP_CONSENT_FOR_REMOVABLE_DRIVE: windows_core::HRESULT = windows_core::HRESULT(0x80270049_u32 as _);
pub const COPYENGINE_E_REQUIRES_ELEVATION: windows_core::HRESULT = windows_core::HRESULT(0x80270002_u32 as _);
pub const COPYENGINE_E_RMS_BLOCKED_BY_EDP_FOR_REMOVABLE_DRIVE: windows_core::HRESULT = windows_core::HRESULT(0x8027004C_u32 as _);
pub const COPYENGINE_E_RMS_REQUIRES_EDP_CONSENT_FOR_REMOVABLE_DRIVE: windows_core::HRESULT = windows_core::HRESULT(0x8027004B_u32 as _);
pub const COPYENGINE_E_ROOT_DIR_DEST: windows_core::HRESULT = windows_core::HRESULT(0x80270020_u32 as _);
pub const COPYENGINE_E_ROOT_DIR_SRC: windows_core::HRESULT = windows_core::HRESULT(0x8027001F_u32 as _);
pub const COPYENGINE_E_SAME_FILE: windows_core::HRESULT = windows_core::HRESULT(0x80270003_u32 as _);
pub const COPYENGINE_E_SERVER_BAD_FILE_TYPE: windows_core::HRESULT = windows_core::HRESULT(0x80270041_u32 as _);
pub const COPYENGINE_E_SHARING_VIOLATION_DEST: windows_core::HRESULT = windows_core::HRESULT(0x80270028_u32 as _);
pub const COPYENGINE_E_SHARING_VIOLATION_SRC: windows_core::HRESULT = windows_core::HRESULT(0x80270027_u32 as _);
pub const COPYENGINE_E_SILENT_FAIL_BY_DLP_POLICY: windows_core::HRESULT = windows_core::HRESULT(0x8027004F_u32 as _);
pub const COPYENGINE_E_SRC_IS_RO_CD: windows_core::HRESULT = windows_core::HRESULT(0x80270015_u32 as _);
pub const COPYENGINE_E_SRC_IS_RO_DVD: windows_core::HRESULT = windows_core::HRESULT(0x80270018_u32 as _);
pub const COPYENGINE_E_SRC_IS_RW_CD: windows_core::HRESULT = windows_core::HRESULT(0x80270016_u32 as _);
pub const COPYENGINE_E_SRC_IS_RW_DVD: windows_core::HRESULT = windows_core::HRESULT(0x80270019_u32 as _);
pub const COPYENGINE_E_SRC_IS_R_CD: windows_core::HRESULT = windows_core::HRESULT(0x80270017_u32 as _);
pub const COPYENGINE_E_SRC_IS_R_DVD: windows_core::HRESULT = windows_core::HRESULT(0x8027001A_u32 as _);
pub const COPYENGINE_E_STREAM_LOSS: windows_core::HRESULT = windows_core::HRESULT(0x8027002D_u32 as _);
pub const COPYENGINE_E_USER_CANCELLED: windows_core::HRESULT = windows_core::HRESULT(0x80270000_u32 as _);
pub const COPYENGINE_E_WARNED_BY_DLP_POLICY: windows_core::HRESULT = windows_core::HRESULT(0x8027004D_u32 as _);
pub const COPYENGINE_S_ALREADY_DONE: windows_core::HRESULT = windows_core::HRESULT(0x27000A_u32 as _);
pub const COPYENGINE_S_CLOSE_PROGRAM: windows_core::HRESULT = windows_core::HRESULT(0x27000D_u32 as _);
pub const COPYENGINE_S_COLLISIONRESOLVED: windows_core::HRESULT = windows_core::HRESULT(0x27000E_u32 as _);
pub const COPYENGINE_S_DONT_PROCESS_CHILDREN: windows_core::HRESULT = windows_core::HRESULT(0x270008_u32 as _);
pub const COPYENGINE_S_KEEP_BOTH: windows_core::HRESULT = windows_core::HRESULT(0x27000C_u32 as _);
pub const COPYENGINE_S_MERGE: windows_core::HRESULT = windows_core::HRESULT(0x270006_u32 as _);
pub const COPYENGINE_S_NOT_HANDLED: windows_core::HRESULT = windows_core::HRESULT(0x270003_u32 as _);
pub const COPYENGINE_S_PENDING: windows_core::HRESULT = windows_core::HRESULT(0x27000B_u32 as _);
pub const COPYENGINE_S_PENDING_DELETE: windows_core::HRESULT = windows_core::HRESULT(0x270010_u32 as _);
pub const COPYENGINE_S_PROGRESS_PAUSE: windows_core::HRESULT = windows_core::HRESULT(0x27000F_u32 as _);
pub const COPYENGINE_S_USER_IGNORED: windows_core::HRESULT = windows_core::HRESULT(0x270005_u32 as _);
pub const COPYENGINE_S_USER_RETRY: windows_core::HRESULT = windows_core::HRESULT(0x270004_u32 as _);
pub const COPYENGINE_S_YES: windows_core::HRESULT = windows_core::HRESULT(0x270001_u32 as _);
pub const CPAO_EMPTY_CONNECTED: CREDENTIAL_PROVIDER_ACCOUNT_OPTIONS = CREDENTIAL_PROVIDER_ACCOUNT_OPTIONS(2i32);
pub const CPAO_EMPTY_LOCAL: CREDENTIAL_PROVIDER_ACCOUNT_OPTIONS = CREDENTIAL_PROVIDER_ACCOUNT_OPTIONS(1i32);
pub const CPAO_NONE: CREDENTIAL_PROVIDER_ACCOUNT_OPTIONS = CREDENTIAL_PROVIDER_ACCOUNT_OPTIONS(0i32);
pub const CPCFO_ENABLE_PASSWORD_REVEAL: CREDENTIAL_PROVIDER_CREDENTIAL_FIELD_OPTIONS = CREDENTIAL_PROVIDER_CREDENTIAL_FIELD_OPTIONS(1i32);
pub const CPCFO_ENABLE_TOUCH_KEYBOARD_AUTO_INVOKE: CREDENTIAL_PROVIDER_CREDENTIAL_FIELD_OPTIONS = CREDENTIAL_PROVIDER_CREDENTIAL_FIELD_OPTIONS(4i32);
pub const CPCFO_IS_EMAIL_ADDRESS: CREDENTIAL_PROVIDER_CREDENTIAL_FIELD_OPTIONS = CREDENTIAL_PROVIDER_CREDENTIAL_FIELD_OPTIONS(2i32);
pub const CPCFO_NONE: CREDENTIAL_PROVIDER_CREDENTIAL_FIELD_OPTIONS = CREDENTIAL_PROVIDER_CREDENTIAL_FIELD_OPTIONS(0i32);
pub const CPCFO_NUMBERS_ONLY: CREDENTIAL_PROVIDER_CREDENTIAL_FIELD_OPTIONS = CREDENTIAL_PROVIDER_CREDENTIAL_FIELD_OPTIONS(8i32);
pub const CPCFO_SHOW_ENGLISH_KEYBOARD: CREDENTIAL_PROVIDER_CREDENTIAL_FIELD_OPTIONS = CREDENTIAL_PROVIDER_CREDENTIAL_FIELD_OPTIONS(16i32);
pub const CPFG_CREDENTIAL_PROVIDER_LABEL: windows_core::GUID = windows_core::GUID::from_u128(0x286bbff3_bad4_438f_b007_79b7267c3d48);
pub const CPFG_CREDENTIAL_PROVIDER_LOGO: windows_core::GUID = windows_core::GUID::from_u128(0x2d837775_f6cd_464e_a745_482fd0b47493);
pub const CPFG_LOGON_PASSWORD: windows_core::GUID = windows_core::GUID::from_u128(0x60624cfa_a477_47b1_8a8e_3a4a19981827);
pub const CPFG_LOGON_USERNAME: windows_core::GUID = windows_core::GUID::from_u128(0xda15bbe8_954d_4fd3_b0f4_1fb5b90b174b);
pub const CPFG_SMARTCARD_PIN: windows_core::GUID = windows_core::GUID::from_u128(0x4fe5263b_9181_46c1_b0a4_9dedd4db7dea);
pub const CPFG_SMARTCARD_USERNAME: windows_core::GUID = windows_core::GUID::from_u128(0x3e1ecf69_568c_4d96_9d59_46444174e2d6);
pub const CPFG_STANDALONE_SUBMIT_BUTTON: windows_core::GUID = windows_core::GUID::from_u128(0x0b7b0ad8_cc36_4d59_802b_82f714fa7022);
pub const CPFG_STYLE_LINK_AS_BUTTON: windows_core::GUID = windows_core::GUID::from_u128(0x088fa508_94a6_4430_a4cb_6fc6e3c0b9e2);
pub const CPFIS_DISABLED: CREDENTIAL_PROVIDER_FIELD_INTERACTIVE_STATE = CREDENTIAL_PROVIDER_FIELD_INTERACTIVE_STATE(2i32);
pub const CPFIS_FOCUSED: CREDENTIAL_PROVIDER_FIELD_INTERACTIVE_STATE = CREDENTIAL_PROVIDER_FIELD_INTERACTIVE_STATE(3i32);
pub const CPFIS_NONE: CREDENTIAL_PROVIDER_FIELD_INTERACTIVE_STATE = CREDENTIAL_PROVIDER_FIELD_INTERACTIVE_STATE(0i32);
pub const CPFIS_READONLY: CREDENTIAL_PROVIDER_FIELD_INTERACTIVE_STATE = CREDENTIAL_PROVIDER_FIELD_INTERACTIVE_STATE(1i32);
pub const CPFS_DISPLAY_IN_BOTH: CREDENTIAL_PROVIDER_FIELD_STATE = CREDENTIAL_PROVIDER_FIELD_STATE(3i32);
pub const CPFS_DISPLAY_IN_DESELECTED_TILE: CREDENTIAL_PROVIDER_FIELD_STATE = CREDENTIAL_PROVIDER_FIELD_STATE(2i32);
pub const CPFS_DISPLAY_IN_SELECTED_TILE: CREDENTIAL_PROVIDER_FIELD_STATE = CREDENTIAL_PROVIDER_FIELD_STATE(1i32);
pub const CPFS_HIDDEN: CREDENTIAL_PROVIDER_FIELD_STATE = CREDENTIAL_PROVIDER_FIELD_STATE(0i32);
pub const CPFT_CHECKBOX: CREDENTIAL_PROVIDER_FIELD_TYPE = CREDENTIAL_PROVIDER_FIELD_TYPE(7i32);
pub const CPFT_COMBOBOX: CREDENTIAL_PROVIDER_FIELD_TYPE = CREDENTIAL_PROVIDER_FIELD_TYPE(8i32);
pub const CPFT_COMMAND_LINK: CREDENTIAL_PROVIDER_FIELD_TYPE = CREDENTIAL_PROVIDER_FIELD_TYPE(3i32);
pub const CPFT_EDIT_TEXT: CREDENTIAL_PROVIDER_FIELD_TYPE = CREDENTIAL_PROVIDER_FIELD_TYPE(4i32);
pub const CPFT_INVALID: CREDENTIAL_PROVIDER_FIELD_TYPE = CREDENTIAL_PROVIDER_FIELD_TYPE(0i32);
pub const CPFT_LARGE_TEXT: CREDENTIAL_PROVIDER_FIELD_TYPE = CREDENTIAL_PROVIDER_FIELD_TYPE(1i32);
pub const CPFT_PASSWORD_TEXT: CREDENTIAL_PROVIDER_FIELD_TYPE = CREDENTIAL_PROVIDER_FIELD_TYPE(5i32);
pub const CPFT_SMALL_TEXT: CREDENTIAL_PROVIDER_FIELD_TYPE = CREDENTIAL_PROVIDER_FIELD_TYPE(2i32);
pub const CPFT_SUBMIT_BUTTON: CREDENTIAL_PROVIDER_FIELD_TYPE = CREDENTIAL_PROVIDER_FIELD_TYPE(9i32);
pub const CPFT_TILE_IMAGE: CREDENTIAL_PROVIDER_FIELD_TYPE = CREDENTIAL_PROVIDER_FIELD_TYPE(6i32);
pub const CPGSR_NO_CREDENTIAL_FINISHED: CREDENTIAL_PROVIDER_GET_SERIALIZATION_RESPONSE = CREDENTIAL_PROVIDER_GET_SERIALIZATION_RESPONSE(1i32);
pub const CPGSR_NO_CREDENTIAL_NOT_FINISHED: CREDENTIAL_PROVIDER_GET_SERIALIZATION_RESPONSE = CREDENTIAL_PROVIDER_GET_SERIALIZATION_RESPONSE(0i32);
pub const CPGSR_RETURN_CREDENTIAL_FINISHED: CREDENTIAL_PROVIDER_GET_SERIALIZATION_RESPONSE = CREDENTIAL_PROVIDER_GET_SERIALIZATION_RESPONSE(2i32);
pub const CPGSR_RETURN_NO_CREDENTIAL_FINISHED: CREDENTIAL_PROVIDER_GET_SERIALIZATION_RESPONSE = CREDENTIAL_PROVIDER_GET_SERIALIZATION_RESPONSE(3i32);
#[repr(C, packed(1))]
#[derive(Clone, Copy, Default)]
pub struct CPLINFO {
    pub idIcon: i32,
    pub idName: i32,
    pub idInfo: i32,
    pub lData: isize,
}
pub const CPLPAGE_DISPLAY_BACKGROUND: u32 = 1u32;
pub const CPLPAGE_KEYBOARD_SPEED: u32 = 1u32;
pub const CPLPAGE_MOUSE_BUTTONS: u32 = 1u32;
pub const CPLPAGE_MOUSE_PTRMOTION: u32 = 2u32;
pub const CPLPAGE_MOUSE_WHEEL: u32 = 3u32;
pub const CPL_DBLCLK: u32 = 5u32;
pub const CPL_DYNAMIC_RES: u32 = 0u32;
pub const CPL_EXIT: u32 = 7u32;
pub const CPL_GETCOUNT: u32 = 2u32;
pub const CPL_INIT: u32 = 1u32;
pub const CPL_INQUIRE: u32 = 3u32;
pub const CPL_NEWINQUIRE: u32 = 8u32;
pub const CPL_SELECT: u32 = 4u32;
pub const CPL_SETUP: u32 = 200u32;
pub const CPL_STARTWPARMS: u32 = 10u32;
pub const CPL_STARTWPARMSA: u32 = 9u32;
pub const CPL_STARTWPARMSW: u32 = 10u32;
pub const CPL_STOP: u32 = 6u32;
pub const CPSI_ERROR: CREDENTIAL_PROVIDER_STATUS_ICON = CREDENTIAL_PROVIDER_STATUS_ICON(1i32);
pub const CPSI_NONE: CREDENTIAL_PROVIDER_STATUS_ICON = CREDENTIAL_PROVIDER_STATUS_ICON(0i32);
pub const CPSI_SUCCESS: CREDENTIAL_PROVIDER_STATUS_ICON = CREDENTIAL_PROVIDER_STATUS_ICON(3i32);
pub const CPSI_WARNING: CREDENTIAL_PROVIDER_STATUS_ICON = CREDENTIAL_PROVIDER_STATUS_ICON(2i32);
pub const CPUS_CHANGE_PASSWORD: CREDENTIAL_PROVIDER_USAGE_SCENARIO = CREDENTIAL_PROVIDER_USAGE_SCENARIO(3i32);
pub const CPUS_CREDUI: CREDENTIAL_PROVIDER_USAGE_SCENARIO = CREDENTIAL_PROVIDER_USAGE_SCENARIO(4i32);
pub const CPUS_INVALID: CREDENTIAL_PROVIDER_USAGE_SCENARIO = CREDENTIAL_PROVIDER_USAGE_SCENARIO(0i32);
pub const CPUS_LOGON: CREDENTIAL_PROVIDER_USAGE_SCENARIO = CREDENTIAL_PROVIDER_USAGE_SCENARIO(1i32);
pub const CPUS_PLAP: CREDENTIAL_PROVIDER_USAGE_SCENARIO = CREDENTIAL_PROVIDER_USAGE_SCENARIO(5i32);
pub const CPUS_UNLOCK_WORKSTATION: CREDENTIAL_PROVIDER_USAGE_SCENARIO = CREDENTIAL_PROVIDER_USAGE_SCENARIO(2i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct CPVIEW(pub i32);
pub const CPVIEW_ALLITEMS: CPVIEW = CPVIEW(0i32);
pub const CPVIEW_CATEGORY: CPVIEW = CPVIEW(1i32);
pub const CPVIEW_CLASSIC: CPVIEW = CPVIEW(0i32);
pub const CPVIEW_HOME: CPVIEW = CPVIEW(1i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct CREDENTIAL_PROVIDER_ACCOUNT_OPTIONS(pub i32);
impl CREDENTIAL_PROVIDER_ACCOUNT_OPTIONS {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl core::ops::BitOr for CREDENTIAL_PROVIDER_ACCOUNT_OPTIONS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl core::ops::BitAnd for CREDENTIAL_PROVIDER_ACCOUNT_OPTIONS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl core::ops::BitOrAssign for CREDENTIAL_PROVIDER_ACCOUNT_OPTIONS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl core::ops::BitAndAssign for CREDENTIAL_PROVIDER_ACCOUNT_OPTIONS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl core::ops::Not for CREDENTIAL_PROVIDER_ACCOUNT_OPTIONS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct CREDENTIAL_PROVIDER_CREDENTIAL_FIELD_OPTIONS(pub i32);
impl CREDENTIAL_PROVIDER_CREDENTIAL_FIELD_OPTIONS {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl core::ops::BitOr for CREDENTIAL_PROVIDER_CREDENTIAL_FIELD_OPTIONS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl core::ops::BitAnd for CREDENTIAL_PROVIDER_CREDENTIAL_FIELD_OPTIONS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl core::ops::BitOrAssign for CREDENTIAL_PROVIDER_CREDENTIAL_FIELD_OPTIONS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl core::ops::BitAndAssign for CREDENTIAL_PROVIDER_CREDENTIAL_FIELD_OPTIONS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl core::ops::Not for CREDENTIAL_PROVIDER_CREDENTIAL_FIELD_OPTIONS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct CREDENTIAL_PROVIDER_CREDENTIAL_SERIALIZATION {
    pub ulAuthenticationPackage: u32,
    pub clsidCredentialProvider: windows_core::GUID,
    pub cbSerialization: u32,
    pub rgbSerialization: *mut u8,
}
impl Default for CREDENTIAL_PROVIDER_CREDENTIAL_SERIALIZATION {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct CREDENTIAL_PROVIDER_FIELD_DESCRIPTOR {
    pub dwFieldID: u32,
    pub cpft: CREDENTIAL_PROVIDER_FIELD_TYPE,
    pub pszLabel: windows_core::PWSTR,
    pub guidFieldType: windows_core::GUID,
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct CREDENTIAL_PROVIDER_FIELD_INTERACTIVE_STATE(pub i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct CREDENTIAL_PROVIDER_FIELD_STATE(pub i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct CREDENTIAL_PROVIDER_FIELD_TYPE(pub i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct CREDENTIAL_PROVIDER_GET_SERIALIZATION_RESPONSE(pub i32);
pub const CREDENTIAL_PROVIDER_NO_DEFAULT: u32 = 4294967295u32;
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct CREDENTIAL_PROVIDER_STATUS_ICON(pub i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct CREDENTIAL_PROVIDER_USAGE_SCENARIO(pub i32);
pub const CSC_NAVIGATEBACK: CommandStateChangeConstants = CommandStateChangeConstants(2i32);
pub const CSC_NAVIGATEFORWARD: CommandStateChangeConstants = CommandStateChangeConstants(1i32);
pub const CSC_UPDATECOMMANDS: CommandStateChangeConstants = CommandStateChangeConstants(-1i32);
#[repr(C)]
#[cfg(all(feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
#[derive(Clone, Debug)]
pub struct CSFV {
    pub cbSize: u32,
    pub pshf: core::mem::ManuallyDrop<Option<IShellFolder>>,
    pub psvOuter: core::mem::ManuallyDrop<Option<IShellView>>,
    pub pidl: *mut Common::ITEMIDLIST,
    pub lEvents: i32,
    pub pfnCallback: LPFNVIEWCALLBACK,
    pub fvm: FOLDERVIEWMODE,
}
#[cfg(all(feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
impl Default for CSFV {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const CSIDL_ADMINTOOLS: u32 = 48u32;
pub const CSIDL_ALTSTARTUP: u32 = 29u32;
pub const CSIDL_APPDATA: u32 = 26u32;
pub const CSIDL_BITBUCKET: u32 = 10u32;
pub const CSIDL_CDBURN_AREA: u32 = 59u32;
pub const CSIDL_COMMON_ADMINTOOLS: u32 = 47u32;
pub const CSIDL_COMMON_ALTSTARTUP: u32 = 30u32;
pub const CSIDL_COMMON_APPDATA: u32 = 35u32;
pub const CSIDL_COMMON_DESKTOPDIRECTORY: u32 = 25u32;
pub const CSIDL_COMMON_DOCUMENTS: u32 = 46u32;
pub const CSIDL_COMMON_FAVORITES: u32 = 31u32;
pub const CSIDL_COMMON_MUSIC: u32 = 53u32;
pub const CSIDL_COMMON_OEM_LINKS: u32 = 58u32;
pub const CSIDL_COMMON_PICTURES: u32 = 54u32;
pub const CSIDL_COMMON_PROGRAMS: u32 = 23u32;
pub const CSIDL_COMMON_STARTMENU: u32 = 22u32;
pub const CSIDL_COMMON_STARTUP: u32 = 24u32;
pub const CSIDL_COMMON_TEMPLATES: u32 = 45u32;
pub const CSIDL_COMMON_VIDEO: u32 = 55u32;
pub const CSIDL_COMPUTERSNEARME: u32 = 61u32;
pub const CSIDL_CONNECTIONS: u32 = 49u32;
pub const CSIDL_CONTROLS: u32 = 3u32;
pub const CSIDL_COOKIES: u32 = 33u32;
pub const CSIDL_DESKTOP: u32 = 0u32;
pub const CSIDL_DESKTOPDIRECTORY: u32 = 16u32;
pub const CSIDL_DRIVES: u32 = 17u32;
pub const CSIDL_FAVORITES: u32 = 6u32;
pub const CSIDL_FLAG_CREATE: u32 = 32768u32;
pub const CSIDL_FLAG_DONT_UNEXPAND: u32 = 8192u32;
pub const CSIDL_FLAG_DONT_VERIFY: u32 = 16384u32;
pub const CSIDL_FLAG_MASK: u32 = 65280u32;
pub const CSIDL_FLAG_NO_ALIAS: u32 = 4096u32;
pub const CSIDL_FLAG_PER_USER_INIT: u32 = 2048u32;
pub const CSIDL_FLAG_PFTI_TRACKTARGET: u32 = 16384u32;
pub const CSIDL_FONTS: u32 = 20u32;
pub const CSIDL_HISTORY: u32 = 34u32;
pub const CSIDL_INTERNET: u32 = 1u32;
pub const CSIDL_INTERNET_CACHE: u32 = 32u32;
pub const CSIDL_LOCAL_APPDATA: u32 = 28u32;
pub const CSIDL_MYDOCUMENTS: u32 = 5u32;
pub const CSIDL_MYMUSIC: u32 = 13u32;
pub const CSIDL_MYPICTURES: u32 = 39u32;
pub const CSIDL_MYVIDEO: u32 = 14u32;
pub const CSIDL_NETHOOD: u32 = 19u32;
pub const CSIDL_NETWORK: u32 = 18u32;
pub const CSIDL_PERSONAL: u32 = 5u32;
pub const CSIDL_PRINTERS: u32 = 4u32;
pub const CSIDL_PRINTHOOD: u32 = 27u32;
pub const CSIDL_PROFILE: u32 = 40u32;
pub const CSIDL_PROGRAMS: u32 = 2u32;
pub const CSIDL_PROGRAM_FILES: u32 = 38u32;
pub const CSIDL_PROGRAM_FILESX86: u32 = 42u32;
pub const CSIDL_PROGRAM_FILES_COMMON: u32 = 43u32;
pub const CSIDL_PROGRAM_FILES_COMMONX86: u32 = 44u32;
pub const CSIDL_RECENT: u32 = 8u32;
pub const CSIDL_RESOURCES: u32 = 56u32;
pub const CSIDL_RESOURCES_LOCALIZED: u32 = 57u32;
pub const CSIDL_SENDTO: u32 = 9u32;
pub const CSIDL_STARTMENU: u32 = 11u32;
pub const CSIDL_STARTUP: u32 = 7u32;
pub const CSIDL_SYSTEM: u32 = 37u32;
pub const CSIDL_SYSTEMX86: u32 = 41u32;
pub const CSIDL_TEMPLATES: u32 = 21u32;
pub const CSIDL_WINDOWS: u32 = 36u32;
pub const CScriptErrorList: windows_core::GUID = windows_core::GUID::from_u128(0xefd01300_160f_11d2_bb2e_00805ff7efca);
pub const CTF_COINIT: i32 = 8i32;
pub const CTF_COINIT_MTA: i32 = 4096i32;
pub const CTF_COINIT_STA: i32 = 8i32;
pub const CTF_FREELIBANDEXIT: i32 = 16i32;
pub const CTF_INHERITWOW64: i32 = 256i32;
pub const CTF_INSIST: i32 = 1i32;
pub const CTF_KEYBOARD_LOCALE: i32 = 1024i32;
pub const CTF_NOADDREFLIB: i32 = 8192i32;
pub const CTF_OLEINITIALIZE: i32 = 2048i32;
pub const CTF_PROCESS_REF: i32 = 4i32;
pub const CTF_REF_COUNTED: i32 = 32i32;
pub const CTF_THREAD_REF: i32 = 2i32;
pub const CTF_UNUSED: i32 = 128i32;
pub const CTF_WAIT_ALLOWCOM: i32 = 64i32;
pub const CTF_WAIT_NO_REENTRANCY: i32 = 512i32;
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct CommandStateChangeConstants(pub i32);
pub const ConflictFolder: windows_core::GUID = windows_core::GUID::from_u128(0x289978ac_a101_4341_a817_21eba7fd046d);
#[repr(C, packed(1))]
#[derive(Clone, Copy, Default)]
pub struct DATABLOCK_HEADER {
    pub cbSize: u32,
    pub dwSignature: u32,
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DATAOBJ_GET_ITEM_FLAGS(pub i32);
impl DATAOBJ_GET_ITEM_FLAGS {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl core::ops::BitOr for DATAOBJ_GET_ITEM_FLAGS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl core::ops::BitAnd for DATAOBJ_GET_ITEM_FLAGS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl core::ops::BitOrAssign for DATAOBJ_GET_ITEM_FLAGS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl core::ops::BitAndAssign for DATAOBJ_GET_ITEM_FLAGS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl core::ops::Not for DATAOBJ_GET_ITEM_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
pub const DBCID_CLSIDOFBAR: i32 = 2i32;
pub const DBCID_EMPTY: i32 = 0i32;
pub const DBCID_GETBAR: i32 = 4i32;
pub const DBCID_ONDRAG: i32 = 1i32;
pub const DBCID_RESIZE: i32 = 3i32;
pub const DBCID_UPDATESIZE: i32 = 5i32;
pub const DBC_GS_IDEAL: u32 = 0u32;
pub const DBC_GS_SIZEDOWN: u32 = 1u32;
pub const DBC_HIDE: u32 = 0u32;
pub const DBC_SHOW: u32 = 1u32;
pub const DBC_SHOWOBSCURE: u32 = 2u32;
pub const DBID_BANDINFOCHANGED: DESKBANDCID = DESKBANDCID(0i32);
pub const DBID_DELAYINIT: DESKBANDCID = DESKBANDCID(4i32);
pub const DBID_FINISHINIT: DESKBANDCID = DESKBANDCID(5i32);
pub const DBID_MAXIMIZEBAND: DESKBANDCID = DESKBANDCID(2i32);
pub const DBID_PERMITAUTOHIDE: DESKBANDCID = DESKBANDCID(7i32);
pub const DBID_PUSHCHEVRON: DESKBANDCID = DESKBANDCID(3i32);
pub const DBID_SETWINDOWTHEME: DESKBANDCID = DESKBANDCID(6i32);
pub const DBID_SHOWONLY: DESKBANDCID = DESKBANDCID(1i32);
pub const DBIF_VIEWMODE_FLOATING: u32 = 2u32;
pub const DBIF_VIEWMODE_NORMAL: u32 = 0u32;
pub const DBIF_VIEWMODE_TRANSPARENT: u32 = 4u32;
pub const DBIF_VIEWMODE_VERTICAL: u32 = 1u32;
pub const DBIMF_ADDTOFRONT: u32 = 512u32;
pub const DBIMF_ALWAYSGRIPPER: u32 = 4096u32;
pub const DBIMF_BKCOLOR: u32 = 64u32;
pub const DBIMF_BREAK: u32 = 256u32;
pub const DBIMF_DEBOSSED: u32 = 32u32;
pub const DBIMF_FIXED: u32 = 1u32;
pub const DBIMF_FIXEDBMP: u32 = 4u32;
pub const DBIMF_NOGRIPPER: u32 = 2048u32;
pub const DBIMF_NOMARGINS: u32 = 8192u32;
pub const DBIMF_NORMAL: u32 = 0u32;
pub const DBIMF_TOPALIGN: u32 = 1024u32;
pub const DBIMF_UNDELETEABLE: u32 = 16u32;
pub const DBIMF_USECHEVRON: u32 = 128u32;
pub const DBIMF_VARIABLEHEIGHT: u32 = 8u32;
pub const DBIM_ACTUAL: u32 = 8u32;
pub const DBIM_BKCOLOR: u32 = 64u32;
pub const DBIM_INTEGRAL: u32 = 4u32;
pub const DBIM_MAXSIZE: u32 = 2u32;
pub const DBIM_MINSIZE: u32 = 1u32;
pub const DBIM_MODEFLAGS: u32 = 32u32;
pub const DBIM_TITLE: u32 = 16u32;
pub const DBPC_SELECTFIRST: u32 = 4294967295u32;
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DEFAULTSAVEFOLDERTYPE(pub i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DEFAULT_FOLDER_MENU_RESTRICTIONS(pub i32);
impl DEFAULT_FOLDER_MENU_RESTRICTIONS {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl core::ops::BitOr for DEFAULT_FOLDER_MENU_RESTRICTIONS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl core::ops::BitAnd for DEFAULT_FOLDER_MENU_RESTRICTIONS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl core::ops::BitOrAssign for DEFAULT_FOLDER_MENU_RESTRICTIONS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl core::ops::BitAndAssign for DEFAULT_FOLDER_MENU_RESTRICTIONS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl core::ops::Not for DEFAULT_FOLDER_MENU_RESTRICTIONS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[repr(C)]
#[cfg(all(feature = "Win32_System_Registry", feature = "Win32_UI_Shell_Common"))]
#[derive(Clone, Debug, PartialEq)]
pub struct DEFCONTEXTMENU {
    pub hwnd: super::super::Foundation::HWND,
    pub pcmcb: core::mem::ManuallyDrop<Option<IContextMenuCB>>,
    pub pidlFolder: *mut Common::ITEMIDLIST,
    pub psf: core::mem::ManuallyDrop<Option<IShellFolder>>,
    pub cidl: u32,
    pub apidl: *mut *mut Common::ITEMIDLIST,
    pub punkAssociationInfo: core::mem::ManuallyDrop<Option<windows_core::IUnknown>>,
    pub cKeys: u32,
    pub aKeys: *const super::super::System::Registry::HKEY,
}
#[cfg(all(feature = "Win32_System_Registry", feature = "Win32_UI_Shell_Common"))]
impl Default for DEFCONTEXTMENU {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const DEFSHAREID_PUBLIC: DEF_SHARE_ID = DEF_SHARE_ID(2i32);
pub const DEFSHAREID_USERS: DEF_SHARE_ID = DEF_SHARE_ID(1i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DEF_SHARE_ID(pub i32);
#[repr(C, packed(1))]
#[derive(Clone, Copy)]
pub struct DELEGATEITEMID {
    pub cbSize: u16,
    pub wOuter: u16,
    pub cbInner: u16,
    pub rgb: [u8; 1],
}
impl Default for DELEGATEITEMID {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DESKBANDCID(pub i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DESKBANDINFO {
    pub dwMask: u32,
    pub ptMinSize: super::super::Foundation::POINTL,
    pub ptMaxSize: super::super::Foundation::POINTL,
    pub ptIntegral: super::super::Foundation::POINTL,
    pub ptActual: super::super::Foundation::POINTL,
    pub wszTitle: [u16; 256],
    pub dwModeFlags: u32,
    pub crBkgnd: super::super::Foundation::COLORREF,
}
impl Default for DESKBANDINFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DESKTOP_SLIDESHOW_DIRECTION(pub i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DESKTOP_SLIDESHOW_OPTIONS(pub i32);
impl DESKTOP_SLIDESHOW_OPTIONS {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl core::ops::BitOr for DESKTOP_SLIDESHOW_OPTIONS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl core::ops::BitAnd for DESKTOP_SLIDESHOW_OPTIONS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl core::ops::BitOrAssign for DESKTOP_SLIDESHOW_OPTIONS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl core::ops::BitAndAssign for DESKTOP_SLIDESHOW_OPTIONS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl core::ops::Not for DESKTOP_SLIDESHOW_OPTIONS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DESKTOP_SLIDESHOW_STATE(pub i32);
impl DESKTOP_SLIDESHOW_STATE {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl core::ops::BitOr for DESKTOP_SLIDESHOW_STATE {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl core::ops::BitAnd for DESKTOP_SLIDESHOW_STATE {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl core::ops::BitOrAssign for DESKTOP_SLIDESHOW_STATE {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl core::ops::BitAndAssign for DESKTOP_SLIDESHOW_STATE {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl core::ops::Not for DESKTOP_SLIDESHOW_STATE {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DESKTOP_WALLPAPER_POSITION(pub i32);
#[repr(C)]
#[cfg(feature = "Win32_UI_Shell_Common")]
#[derive(Clone, Copy)]
pub struct DETAILSINFO {
    pub pidl: *mut Common::ITEMIDLIST,
    pub fmt: i32,
    pub cxChar: i32,
    pub str: Common::STRRET,
    pub iImage: i32,
}
#[cfg(feature = "Win32_UI_Shell_Common")]
impl Default for DETAILSINFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const DEVICE_IMMERSIVE: DISPLAY_DEVICE_TYPE = DISPLAY_DEVICE_TYPE(1i32);
pub const DEVICE_PRIMARY: DISPLAY_DEVICE_TYPE = DISPLAY_DEVICE_TYPE(0i32);
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::define_interface!(DFConstraint, DFConstraint_Vtbl, 0x4a3df050_23bd_11d2_939f_00a0c91eedba);
#[cfg(feature = "Win32_System_Com")]
impl core::ops::Deref for DFConstraint {
    type Target = super::super::System::Com::IDispatch;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::interface_hierarchy!(DFConstraint, windows_core::IUnknown, super::super::System::Com::IDispatch);
#[cfg(feature = "Win32_System_Com")]
impl DFConstraint {
    pub unsafe fn Name(&self) -> windows_core::Result<windows_core::BSTR> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).Name)(windows_core::Interface::as_raw(self), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    #[cfg(all(feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub unsafe fn Value(&self) -> windows_core::Result<super::super::System::Variant::VARIANT> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).Value)(windows_core::Interface::as_raw(self), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct DFConstraint_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
    pub Name: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(all(feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub Value: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::System::Variant::VARIANT) -> windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_System_Ole", feature = "Win32_System_Variant")))]
    Value: usize,
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
pub trait DFConstraint_Impl: super::super::System::Com::IDispatch_Impl {
    fn Name(&self) -> windows_core::Result<windows_core::BSTR>;
    fn Value(&self) -> windows_core::Result<super::super::System::Variant::VARIANT>;
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl DFConstraint_Vtbl {
    pub const fn new<Identity: DFConstraint_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn Name<Identity: DFConstraint_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbs: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match DFConstraint_Impl::Name(this) {
                    Ok(ok__) => {
                        pbs.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn Value<Identity: DFConstraint_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pv: *mut super::super::System::Variant::VARIANT) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match DFConstraint_Impl::Value(this) {
                    Ok(ok__) => {
                        pv.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self { base__: super::super::System::Com::IDispatch_Vtbl::new::<Identity, OFFSET>(), Name: Name::<Identity, OFFSET>, Value: Value::<Identity, OFFSET> }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<DFConstraint as windows_core::Interface>::IID || iid == &<super::super::System::Com::IDispatch as windows_core::Interface>::IID
    }
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl windows_core::RuntimeName for DFConstraint {}
#[repr(C)]
#[derive(Clone, Debug, PartialEq)]
pub struct DFMICS {
    pub cbSize: u32,
    pub fMask: u32,
    pub lParam: super::super::Foundation::LPARAM,
    pub idCmdFirst: u32,
    pub idDefMax: u32,
    pub pici: *mut CMINVOKECOMMANDINFO,
    pub punkSite: core::mem::ManuallyDrop<Option<windows_core::IUnknown>>,
}
impl Default for DFMICS {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const DFMR_DEFAULT: DEFAULT_FOLDER_MENU_RESTRICTIONS = DEFAULT_FOLDER_MENU_RESTRICTIONS(0i32);
pub const DFMR_NO_ASYNC_VERBS: DEFAULT_FOLDER_MENU_RESTRICTIONS = DEFAULT_FOLDER_MENU_RESTRICTIONS(1024i32);
pub const DFMR_NO_NATIVECPU_VERBS: DEFAULT_FOLDER_MENU_RESTRICTIONS = DEFAULT_FOLDER_MENU_RESTRICTIONS(2048i32);
pub const DFMR_NO_NONWOW_VERBS: DEFAULT_FOLDER_MENU_RESTRICTIONS = DEFAULT_FOLDER_MENU_RESTRICTIONS(4096i32);
pub const DFMR_NO_RESOURCE_VERBS: DEFAULT_FOLDER_MENU_RESTRICTIONS = DEFAULT_FOLDER_MENU_RESTRICTIONS(32i32);
pub const DFMR_NO_STATIC_VERBS: DEFAULT_FOLDER_MENU_RESTRICTIONS = DEFAULT_FOLDER_MENU_RESTRICTIONS(8i32);
pub const DFMR_OPTIN_HANDLERS_ONLY: DEFAULT_FOLDER_MENU_RESTRICTIONS = DEFAULT_FOLDER_MENU_RESTRICTIONS(64i32);
pub const DFMR_RESOURCE_AND_FOLDER_VERBS_ONLY: DEFAULT_FOLDER_MENU_RESTRICTIONS = DEFAULT_FOLDER_MENU_RESTRICTIONS(128i32);
pub const DFMR_STATIC_VERBS_ONLY: DEFAULT_FOLDER_MENU_RESTRICTIONS = DEFAULT_FOLDER_MENU_RESTRICTIONS(16i32);
pub const DFMR_USE_SPECIFIED_HANDLERS: DEFAULT_FOLDER_MENU_RESTRICTIONS = DEFAULT_FOLDER_MENU_RESTRICTIONS(256i32);
pub const DFMR_USE_SPECIFIED_VERBS: DEFAULT_FOLDER_MENU_RESTRICTIONS = DEFAULT_FOLDER_MENU_RESTRICTIONS(512i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DFM_CMD(pub i32);
pub const DFM_CMD_COPY: DFM_CMD = DFM_CMD(-3i32);
pub const DFM_CMD_DELETE: DFM_CMD = DFM_CMD(-1i32);
pub const DFM_CMD_LINK: DFM_CMD = DFM_CMD(-4i32);
pub const DFM_CMD_MODALPROP: DFM_CMD = DFM_CMD(-12i32);
pub const DFM_CMD_MOVE: DFM_CMD = DFM_CMD(-2i32);
pub const DFM_CMD_NEWFOLDER: DFM_CMD = DFM_CMD(-6i32);
pub const DFM_CMD_PASTE: DFM_CMD = DFM_CMD(-7i32);
pub const DFM_CMD_PASTELINK: DFM_CMD = DFM_CMD(-10i32);
pub const DFM_CMD_PASTESPECIAL: DFM_CMD = DFM_CMD(-11i32);
pub const DFM_CMD_PROPERTIES: DFM_CMD = DFM_CMD(-5i32);
pub const DFM_CMD_RENAME: DFM_CMD = DFM_CMD(-13i32);
pub const DFM_CMD_VIEWDETAILS: DFM_CMD = DFM_CMD(-9i32);
pub const DFM_CMD_VIEWLIST: DFM_CMD = DFM_CMD(-8i32);
pub const DFM_GETDEFSTATICID: DFM_MESSAGE_ID = DFM_MESSAGE_ID(14i32);
pub const DFM_GETHELPTEXT: DFM_MESSAGE_ID = DFM_MESSAGE_ID(5i32);
pub const DFM_GETHELPTEXTW: DFM_MESSAGE_ID = DFM_MESSAGE_ID(11i32);
pub const DFM_GETVERBA: DFM_MESSAGE_ID = DFM_MESSAGE_ID(16i32);
pub const DFM_GETVERBW: DFM_MESSAGE_ID = DFM_MESSAGE_ID(15i32);
pub const DFM_INVOKECOMMAND: DFM_MESSAGE_ID = DFM_MESSAGE_ID(2i32);
pub const DFM_INVOKECOMMANDEX: DFM_MESSAGE_ID = DFM_MESSAGE_ID(12i32);
pub const DFM_MAPCOMMANDNAME: DFM_MESSAGE_ID = DFM_MESSAGE_ID(13i32);
pub const DFM_MERGECONTEXTMENU: DFM_MESSAGE_ID = DFM_MESSAGE_ID(1i32);
pub const DFM_MERGECONTEXTMENU_BOTTOM: DFM_MESSAGE_ID = DFM_MESSAGE_ID(17i32);
pub const DFM_MERGECONTEXTMENU_TOP: DFM_MESSAGE_ID = DFM_MESSAGE_ID(10i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DFM_MESSAGE_ID(pub i32);
pub const DFM_MODIFYQCMFLAGS: DFM_MESSAGE_ID = DFM_MESSAGE_ID(18i32);
pub const DFM_VALIDATECMD: DFM_MESSAGE_ID = DFM_MESSAGE_ID(9i32);
pub const DFM_WM_DRAWITEM: DFM_MESSAGE_ID = DFM_MESSAGE_ID(7i32);
pub const DFM_WM_INITMENUPOPUP: DFM_MESSAGE_ID = DFM_MESSAGE_ID(8i32);
pub const DFM_WM_MEASUREITEM: DFM_MESSAGE_ID = DFM_MESSAGE_ID(6i32);
pub const DISPID_BEGINDRAG: u32 = 204u32;
pub const DISPID_CHECKSTATECHANGED: u32 = 209u32;
pub const DISPID_COLUMNSCHANGED: u32 = 212u32;
pub const DISPID_CONTENTSCHANGED: u32 = 207u32;
pub const DISPID_CTRLMOUSEWHEEL: u32 = 213u32;
pub const DISPID_DEFAULTVERBINVOKED: u32 = 203u32;
pub const DISPID_ENTERPRESSED: u32 = 200u32;
pub const DISPID_ENTERPRISEIDCHANGED: u32 = 224u32;
pub const DISPID_EXPLORERWINDOWREADY: u32 = 221u32;
pub const DISPID_FILELISTENUMDONE: u32 = 201u32;
pub const DISPID_FILTERINVOKED: u32 = 218u32;
pub const DISPID_FOCUSCHANGED: u32 = 208u32;
pub const DISPID_FOLDERCHANGED: u32 = 217u32;
pub const DISPID_IADCCTL_DEFAULTCAT: u32 = 262u32;
pub const DISPID_IADCCTL_DIRTY: u32 = 256u32;
pub const DISPID_IADCCTL_FORCEX86: u32 = 259u32;
pub const DISPID_IADCCTL_ONDOMAIN: u32 = 261u32;
pub const DISPID_IADCCTL_PUBCAT: u32 = 257u32;
pub const DISPID_IADCCTL_SHOWPOSTSETUP: u32 = 260u32;
pub const DISPID_IADCCTL_SORT: u32 = 258u32;
pub const DISPID_ICONSIZECHANGED: u32 = 215u32;
pub const DISPID_INITIALENUMERATIONDONE: u32 = 223u32;
pub const DISPID_NOITEMSTATE_CHANGED: u32 = 206u32;
pub const DISPID_ORDERCHANGED: u32 = 210u32;
pub const DISPID_SEARCHCOMMAND_ABORT: u32 = 3u32;
pub const DISPID_SEARCHCOMMAND_COMPLETE: u32 = 2u32;
pub const DISPID_SEARCHCOMMAND_ERROR: u32 = 6u32;
pub const DISPID_SEARCHCOMMAND_PROGRESSTEXT: u32 = 5u32;
pub const DISPID_SEARCHCOMMAND_RESTORE: u32 = 7u32;
pub const DISPID_SEARCHCOMMAND_START: u32 = 1u32;
pub const DISPID_SEARCHCOMMAND_UPDATE: u32 = 4u32;
pub const DISPID_SELECTEDITEMCHANGED: u32 = 220u32;
pub const DISPID_SELECTIONCHANGED: u32 = 200u32;
pub const DISPID_SORTDONE: u32 = 214u32;
pub const DISPID_UPDATEIMAGE: u32 = 222u32;
pub const DISPID_VERBINVOKED: u32 = 202u32;
pub const DISPID_VIEWMODECHANGED: u32 = 205u32;
pub const DISPID_VIEWPAINTDONE: u32 = 211u32;
pub const DISPID_WORDWHEELEDITED: u32 = 219u32;
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DISPLAY_DEVICE_TYPE(pub i32);
pub const DI_GETDRAGIMAGE: windows_core::PCWSTR = windows_core::w!("ShellGetDragImage");
pub const DLG_SCRNSAVECONFIGURE: u32 = 2003u32;
pub type DLLGETVERSIONPROC = Option<unsafe extern "system" fn(param0: *mut DLLVERSIONINFO) -> windows_core::HRESULT>;
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct DLLVERSIONINFO {
    pub cbSize: u32,
    pub dwMajorVersion: u32,
    pub dwMinorVersion: u32,
    pub dwBuildNumber: u32,
    pub dwPlatformID: u32,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct DLLVERSIONINFO2 {
    pub info1: DLLVERSIONINFO,
    pub dwFlags: u32,
    pub ullVersion: u64,
}
pub const DLLVER_BUILD_MASK: u64 = 4294901760u64;
pub const DLLVER_MAJOR_MASK: u64 = 18446462598732840960u64;
pub const DLLVER_MINOR_MASK: u64 = 281470681743360u64;
pub const DLLVER_PLATFORM_NT: u32 = 2u32;
pub const DLLVER_PLATFORM_WINDOWS: u32 = 1u32;
pub const DLLVER_QFE_MASK: u64 = 65535u64;
pub const DOGIF_DEFAULT: DATAOBJ_GET_ITEM_FLAGS = DATAOBJ_GET_ITEM_FLAGS(0i32);
pub const DOGIF_NO_HDROP: DATAOBJ_GET_ITEM_FLAGS = DATAOBJ_GET_ITEM_FLAGS(2i32);
pub const DOGIF_NO_URL: DATAOBJ_GET_ITEM_FLAGS = DATAOBJ_GET_ITEM_FLAGS(4i32);
pub const DOGIF_ONLY_IF_ONE: DATAOBJ_GET_ITEM_FLAGS = DATAOBJ_GET_ITEM_FLAGS(8i32);
pub const DOGIF_TRAVERSE_LINK: DATAOBJ_GET_ITEM_FLAGS = DATAOBJ_GET_ITEM_FLAGS(1i32);
#[repr(C, packed(1))]
#[cfg(target_arch = "x86")]
#[derive(Clone, Copy, Default)]
pub struct DRAGINFOA {
    pub uSize: u32,
    pub pt: super::super::Foundation::POINT,
    pub fNC: windows_core::BOOL,
    pub lpFileList: windows_core::PSTR,
    pub grfKeyState: u32,
}
#[repr(C)]
#[cfg(any(target_arch = "aarch64", target_arch = "arm64ec", target_arch = "x86_64"))]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct DRAGINFOA {
    pub uSize: u32,
    pub pt: super::super::Foundation::POINT,
    pub fNC: windows_core::BOOL,
    pub lpFileList: windows_core::PSTR,
    pub grfKeyState: u32,
}
#[repr(C, packed(1))]
#[cfg(target_arch = "x86")]
#[derive(Clone, Copy, Default)]
pub struct DRAGINFOW {
    pub uSize: u32,
    pub pt: super::super::Foundation::POINT,
    pub fNC: windows_core::BOOL,
    pub lpFileList: windows_core::PWSTR,
    pub grfKeyState: u32,
}
#[repr(C)]
#[cfg(any(target_arch = "aarch64", target_arch = "arm64ec", target_arch = "x86_64"))]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct DRAGINFOW {
    pub uSize: u32,
    pub pt: super::super::Foundation::POINT,
    pub fNC: windows_core::BOOL,
    pub lpFileList: windows_core::PWSTR,
    pub grfKeyState: u32,
}
#[repr(C, packed(1))]
#[derive(Clone, Copy)]
pub struct DROPDESCRIPTION {
    pub r#type: DROPIMAGETYPE,
    pub szMessage: [u16; 260],
    pub szInsert: [u16; 260],
}
impl Default for DROPDESCRIPTION {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C, packed(1))]
#[derive(Clone, Copy, Default)]
pub struct DROPFILES {
    pub pFiles: u32,
    pub pt: super::super::Foundation::POINT,
    pub fNC: windows_core::BOOL,
    pub fWide: windows_core::BOOL,
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DROPIMAGETYPE(pub i32);
pub const DROPIMAGE_COPY: DROPIMAGETYPE = DROPIMAGETYPE(1i32);
pub const DROPIMAGE_INVALID: DROPIMAGETYPE = DROPIMAGETYPE(-1i32);
pub const DROPIMAGE_LABEL: DROPIMAGETYPE = DROPIMAGETYPE(6i32);
pub const DROPIMAGE_LINK: DROPIMAGETYPE = DROPIMAGETYPE(4i32);
pub const DROPIMAGE_MOVE: DROPIMAGETYPE = DROPIMAGETYPE(2i32);
pub const DROPIMAGE_NOIMAGE: DROPIMAGETYPE = DROPIMAGETYPE(8i32);
pub const DROPIMAGE_NONE: DROPIMAGETYPE = DROPIMAGETYPE(0i32);
pub const DROPIMAGE_WARNING: DROPIMAGETYPE = DROPIMAGETYPE(7i32);
pub const DSD_BACKWARD: DESKTOP_SLIDESHOW_DIRECTION = DESKTOP_SLIDESHOW_DIRECTION(1i32);
pub const DSD_FORWARD: DESKTOP_SLIDESHOW_DIRECTION = DESKTOP_SLIDESHOW_DIRECTION(0i32);
pub const DSFT_DETECT: DEFAULTSAVEFOLDERTYPE = DEFAULTSAVEFOLDERTYPE(1i32);
pub const DSFT_PRIVATE: DEFAULTSAVEFOLDERTYPE = DEFAULTSAVEFOLDERTYPE(2i32);
pub const DSFT_PUBLIC: DEFAULTSAVEFOLDERTYPE = DEFAULTSAVEFOLDERTYPE(3i32);
pub const DSH_ALLOWDROPDESCRIPTIONTEXT: DSH_FLAGS = DSH_FLAGS(1i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DSH_FLAGS(pub i32);
impl DSH_FLAGS {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl core::ops::BitOr for DSH_FLAGS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl core::ops::BitAnd for DSH_FLAGS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl core::ops::BitOrAssign for DSH_FLAGS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl core::ops::BitAndAssign for DSH_FLAGS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl core::ops::Not for DSH_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
pub const DSO_SHUFFLEIMAGES: DESKTOP_SLIDESHOW_OPTIONS = DESKTOP_SLIDESHOW_OPTIONS(1i32);
pub const DSS_DISABLED_BY_REMOTE_SESSION: DESKTOP_SLIDESHOW_STATE = DESKTOP_SLIDESHOW_STATE(4i32);
pub const DSS_ENABLED: DESKTOP_SLIDESHOW_STATE = DESKTOP_SLIDESHOW_STATE(1i32);
pub const DSS_SLIDESHOW: DESKTOP_SLIDESHOW_STATE = DESKTOP_SLIDESHOW_STATE(2i32);
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::define_interface!(DShellFolderViewEvents, DShellFolderViewEvents_Vtbl, 0x62112aa2_ebe4_11cf_a5fb_0020afe7292d);
#[cfg(feature = "Win32_System_Com")]
impl core::ops::Deref for DShellFolderViewEvents {
    type Target = super::super::System::Com::IDispatch;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::interface_hierarchy!(DShellFolderViewEvents, windows_core::IUnknown, super::super::System::Com::IDispatch);
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct DShellFolderViewEvents_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
pub trait DShellFolderViewEvents_Impl: super::super::System::Com::IDispatch_Impl {}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl DShellFolderViewEvents_Vtbl {
    pub const fn new<Identity: DShellFolderViewEvents_Impl, const OFFSET: isize>() -> Self {
        Self { base__: super::super::System::Com::IDispatch_Vtbl::new::<Identity, OFFSET>() }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<DShellFolderViewEvents as windows_core::Interface>::IID || iid == &<super::super::System::Com::IDispatch as windows_core::Interface>::IID
    }
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl windows_core::RuntimeName for DShellFolderViewEvents {}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::define_interface!(DShellNameSpaceEvents, DShellNameSpaceEvents_Vtbl, 0x55136806_b2de_11d1_b9f2_00a0c98bc547);
#[cfg(feature = "Win32_System_Com")]
impl core::ops::Deref for DShellNameSpaceEvents {
    type Target = super::super::System::Com::IDispatch;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::interface_hierarchy!(DShellNameSpaceEvents, windows_core::IUnknown, super::super::System::Com::IDispatch);
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct DShellNameSpaceEvents_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
pub trait DShellNameSpaceEvents_Impl: super::super::System::Com::IDispatch_Impl {}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl DShellNameSpaceEvents_Vtbl {
    pub const fn new<Identity: DShellNameSpaceEvents_Impl, const OFFSET: isize>() -> Self {
        Self { base__: super::super::System::Com::IDispatch_Vtbl::new::<Identity, OFFSET>() }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<DShellNameSpaceEvents as windows_core::Interface>::IID || iid == &<super::super::System::Com::IDispatch as windows_core::Interface>::IID
    }
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl windows_core::RuntimeName for DShellNameSpaceEvents {}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::define_interface!(DShellWindowsEvents, DShellWindowsEvents_Vtbl, 0xfe4106e0_399a_11d0_a48c_00a0c90a8f39);
#[cfg(feature = "Win32_System_Com")]
impl core::ops::Deref for DShellWindowsEvents {
    type Target = super::super::System::Com::IDispatch;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::interface_hierarchy!(DShellWindowsEvents, windows_core::IUnknown, super::super::System::Com::IDispatch);
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct DShellWindowsEvents_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
pub trait DShellWindowsEvents_Impl: super::super::System::Com::IDispatch_Impl {}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl DShellWindowsEvents_Vtbl {
    pub const fn new<Identity: DShellWindowsEvents_Impl, const OFFSET: isize>() -> Self {
        Self { base__: super::super::System::Com::IDispatch_Vtbl::new::<Identity, OFFSET>() }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<DShellWindowsEvents as windows_core::Interface>::IID || iid == &<super::super::System::Com::IDispatch as windows_core::Interface>::IID
    }
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl windows_core::RuntimeName for DShellWindowsEvents {}
pub const DVASPECT_COPY: u32 = 3u32;
pub const DVASPECT_LINK: u32 = 4u32;
pub const DVASPECT_SHORTNAME: u32 = 2u32;
pub const DWFAF_AUTOHIDE: u32 = 16u32;
pub const DWFAF_GROUP1: u32 = 2u32;
pub const DWFAF_GROUP2: u32 = 4u32;
pub const DWFAF_HIDDEN: u32 = 1u32;
pub const DWFRF_DELETECONFIGDATA: u32 = 1u32;
pub const DWFRF_NORMAL: u32 = 0u32;
pub const DWPOS_CENTER: DESKTOP_WALLPAPER_POSITION = DESKTOP_WALLPAPER_POSITION(0i32);
pub const DWPOS_FILL: DESKTOP_WALLPAPER_POSITION = DESKTOP_WALLPAPER_POSITION(4i32);
pub const DWPOS_FIT: DESKTOP_WALLPAPER_POSITION = DESKTOP_WALLPAPER_POSITION(3i32);
pub const DWPOS_SPAN: DESKTOP_WALLPAPER_POSITION = DESKTOP_WALLPAPER_POSITION(5i32);
pub const DWPOS_STRETCH: DESKTOP_WALLPAPER_POSITION = DESKTOP_WALLPAPER_POSITION(2i32);
pub const DWPOS_TILE: DESKTOP_WALLPAPER_POSITION = DESKTOP_WALLPAPER_POSITION(1i32);
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::define_interface!(DWebBrowserEvents, DWebBrowserEvents_Vtbl, 0xeab22ac2_30c1_11cf_a7eb_0000c05bae0b);
#[cfg(feature = "Win32_System_Com")]
impl core::ops::Deref for DWebBrowserEvents {
    type Target = super::super::System::Com::IDispatch;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::interface_hierarchy!(DWebBrowserEvents, windows_core::IUnknown, super::super::System::Com::IDispatch);
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct DWebBrowserEvents_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
pub trait DWebBrowserEvents_Impl: super::super::System::Com::IDispatch_Impl {}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl DWebBrowserEvents_Vtbl {
    pub const fn new<Identity: DWebBrowserEvents_Impl, const OFFSET: isize>() -> Self {
        Self { base__: super::super::System::Com::IDispatch_Vtbl::new::<Identity, OFFSET>() }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<DWebBrowserEvents as windows_core::Interface>::IID || iid == &<super::super::System::Com::IDispatch as windows_core::Interface>::IID
    }
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl windows_core::RuntimeName for DWebBrowserEvents {}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::define_interface!(DWebBrowserEvents2, DWebBrowserEvents2_Vtbl, 0x34a715a0_6587_11d0_924a_0020afc7ac4d);
#[cfg(feature = "Win32_System_Com")]
impl core::ops::Deref for DWebBrowserEvents2 {
    type Target = super::super::System::Com::IDispatch;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::interface_hierarchy!(DWebBrowserEvents2, windows_core::IUnknown, super::super::System::Com::IDispatch);
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct DWebBrowserEvents2_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
pub trait DWebBrowserEvents2_Impl: super::super::System::Com::IDispatch_Impl {}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl DWebBrowserEvents2_Vtbl {
    pub const fn new<Identity: DWebBrowserEvents2_Impl, const OFFSET: isize>() -> Self {
        Self { base__: super::super::System::Com::IDispatch_Vtbl::new::<Identity, OFFSET>() }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<DWebBrowserEvents2 as windows_core::Interface>::IID || iid == &<super::super::System::Com::IDispatch as windows_core::Interface>::IID
    }
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl windows_core::RuntimeName for DWebBrowserEvents2 {}
pub const DefFolderMenu: windows_core::GUID = windows_core::GUID::from_u128(0xc63382be_7933_48d0_9ac8_85fb46be2fdd);
pub const DesktopGadget: windows_core::GUID = windows_core::GUID::from_u128(0x924ccc1b_6562_4c85_8657_d177925222b6);
pub const DesktopWallpaper: windows_core::GUID = windows_core::GUID::from_u128(0xc2cf3110_460e_4fc1_b9d0_8a1c0c9cc4bd);
pub const DestinationList: windows_core::GUID = windows_core::GUID::from_u128(0x77f10cf0_3db5_4966_b520_b7c54fd35ed6);
pub const DocPropShellExtension: windows_core::GUID = windows_core::GUID::from_u128(0x883373c3_bf89_11d1_be35_080036b11a03);
pub const DriveSizeCategorizer: windows_core::GUID = windows_core::GUID::from_u128(0x94357b53_ca29_4b78_83ae_e8fe7409134f);
pub const DriveTypeCategorizer: windows_core::GUID = windows_core::GUID::from_u128(0xb0a8f3cf_4333_4bab_8873_1ccb1cada48b);
pub const EBF_NODROPTARGET: EXPLORER_BROWSER_FILL_FLAGS = EXPLORER_BROWSER_FILL_FLAGS(512i32);
pub const EBF_NONE: EXPLORER_BROWSER_FILL_FLAGS = EXPLORER_BROWSER_FILL_FLAGS(0i32);
pub const EBF_SELECTFROMDATAOBJECT: EXPLORER_BROWSER_FILL_FLAGS = EXPLORER_BROWSER_FILL_FLAGS(256i32);
pub const EBO_ALWAYSNAVIGATE: EXPLORER_BROWSER_OPTIONS = EXPLORER_BROWSER_OPTIONS(4i32);
pub const EBO_HTMLSHAREPOINTVIEW: EXPLORER_BROWSER_OPTIONS = EXPLORER_BROWSER_OPTIONS(32i32);
pub const EBO_NAVIGATEONCE: EXPLORER_BROWSER_OPTIONS = EXPLORER_BROWSER_OPTIONS(1i32);
pub const EBO_NOBORDER: EXPLORER_BROWSER_OPTIONS = EXPLORER_BROWSER_OPTIONS(64i32);
pub const EBO_NONE: EXPLORER_BROWSER_OPTIONS = EXPLORER_BROWSER_OPTIONS(0i32);
pub const EBO_NOPERSISTVIEWSTATE: EXPLORER_BROWSER_OPTIONS = EXPLORER_BROWSER_OPTIONS(128i32);
pub const EBO_NOTRAVELLOG: EXPLORER_BROWSER_OPTIONS = EXPLORER_BROWSER_OPTIONS(8i32);
pub const EBO_NOWRAPPERWINDOW: EXPLORER_BROWSER_OPTIONS = EXPLORER_BROWSER_OPTIONS(16i32);
pub const EBO_SHOWFRAMES: EXPLORER_BROWSER_OPTIONS = EXPLORER_BROWSER_OPTIONS(2i32);
pub const ECF_AUTOMENUICONS: _EXPCMDFLAGS = _EXPCMDFLAGS(512i32);
pub const ECF_DEFAULT: _EXPCMDFLAGS = _EXPCMDFLAGS(0i32);
pub const ECF_HASLUASHIELD: _EXPCMDFLAGS = _EXPCMDFLAGS(16i32);
pub const ECF_HASSPLITBUTTON: _EXPCMDFLAGS = _EXPCMDFLAGS(2i32);
pub const ECF_HASSUBCOMMANDS: _EXPCMDFLAGS = _EXPCMDFLAGS(1i32);
pub const ECF_HIDELABEL: _EXPCMDFLAGS = _EXPCMDFLAGS(4i32);
pub const ECF_ISDROPDOWN: _EXPCMDFLAGS = _EXPCMDFLAGS(128i32);
pub const ECF_ISSEPARATOR: _EXPCMDFLAGS = _EXPCMDFLAGS(8i32);
pub const ECF_SEPARATORAFTER: _EXPCMDFLAGS = _EXPCMDFLAGS(64i32);
pub const ECF_SEPARATORBEFORE: _EXPCMDFLAGS = _EXPCMDFLAGS(32i32);
pub const ECF_TOGGLEABLE: _EXPCMDFLAGS = _EXPCMDFLAGS(256i32);
pub const ECHUIM_DESKTOP: EC_HOST_UI_MODE = EC_HOST_UI_MODE(0i32);
pub const ECHUIM_IMMERSIVE: EC_HOST_UI_MODE = EC_HOST_UI_MODE(1i32);
pub const ECHUIM_SYSTEM_LAUNCHER: EC_HOST_UI_MODE = EC_HOST_UI_MODE(2i32);
pub const ECS_CHECKBOX: _EXPCMDSTATE = _EXPCMDSTATE(4i32);
pub const ECS_CHECKED: _EXPCMDSTATE = _EXPCMDSTATE(8i32);
pub const ECS_DISABLED: _EXPCMDSTATE = _EXPCMDSTATE(1i32);
pub const ECS_ENABLED: _EXPCMDSTATE = _EXPCMDSTATE(0i32);
pub const ECS_HIDDEN: _EXPCMDSTATE = _EXPCMDSTATE(2i32);
pub const ECS_RADIOCHECK: _EXPCMDSTATE = _EXPCMDSTATE(16i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct EC_HOST_UI_MODE(pub i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct EDGE_GESTURE_KIND(pub i32);
pub const EGK_KEYBOARD: EDGE_GESTURE_KIND = EDGE_GESTURE_KIND(1i32);
pub const EGK_MOUSE: EDGE_GESTURE_KIND = EDGE_GESTURE_KIND(2i32);
pub const EGK_TOUCH: EDGE_GESTURE_KIND = EDGE_GESTURE_KIND(0i32);
pub const EPS_DEFAULT_OFF: _EXPLORERPANESTATE = _EXPLORERPANESTATE(2i32);
pub const EPS_DEFAULT_ON: _EXPLORERPANESTATE = _EXPLORERPANESTATE(1i32);
pub const EPS_DONTCARE: _EXPLORERPANESTATE = _EXPLORERPANESTATE(0i32);
pub const EPS_FORCE: _EXPLORERPANESTATE = _EXPLORERPANESTATE(131072i32);
pub const EPS_INITIALSTATE: _EXPLORERPANESTATE = _EXPLORERPANESTATE(65536i32);
pub const EPS_STATEMASK: _EXPLORERPANESTATE = _EXPLORERPANESTATE(65535i32);
pub const EP_AdvQueryPane: windows_core::GUID = windows_core::GUID::from_u128(0xb4e9db8b_34ba_4c39_b5cc_16a1bd2c411c);
pub const EP_Commands: windows_core::GUID = windows_core::GUID::from_u128(0xd9745868_ca5f_4a76_91cd_f5a129fbb076);
pub const EP_Commands_Organize: windows_core::GUID = windows_core::GUID::from_u128(0x72e81700_e3ec_4660_bf24_3c3b7b648806);
pub const EP_Commands_View: windows_core::GUID = windows_core::GUID::from_u128(0x21f7c32d_eeaa_439b_bb51_37b96fd6a943);
pub const EP_DetailsPane: windows_core::GUID = windows_core::GUID::from_u128(0x43abf98b_89b8_472d_b9ce_e69b8229f019);
pub const EP_NavPane: windows_core::GUID = windows_core::GUID::from_u128(0xcb316b22_25f7_42b8_8a09_540d23a43c2f);
pub const EP_PreviewPane: windows_core::GUID = windows_core::GUID::from_u128(0x893c63d1_45c8_4d17_be19_223be71be365);
pub const EP_QueryPane: windows_core::GUID = windows_core::GUID::from_u128(0x65bcde4f_4f07_4f27_83a7_1afca4df7ddd);
pub const EP_Ribbon: windows_core::GUID = windows_core::GUID::from_u128(0xd27524a8_c9f2_4834_a106_df8889fd4f37);
pub const EP_StatusBar: windows_core::GUID = windows_core::GUID::from_u128(0x65fe56ce_5cfe_4bc4_ad8a_7ae3fe7e8f7c);
pub const EXECUTE_E_LAUNCH_APPLICATION: windows_core::HRESULT = windows_core::HRESULT(0x80270101_u32 as _);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct EXPLORER_BROWSER_FILL_FLAGS(pub i32);
impl EXPLORER_BROWSER_FILL_FLAGS {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl core::ops::BitOr for EXPLORER_BROWSER_FILL_FLAGS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl core::ops::BitAnd for EXPLORER_BROWSER_FILL_FLAGS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl core::ops::BitOrAssign for EXPLORER_BROWSER_FILL_FLAGS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl core::ops::BitAndAssign for EXPLORER_BROWSER_FILL_FLAGS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl core::ops::Not for EXPLORER_BROWSER_FILL_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct EXPLORER_BROWSER_OPTIONS(pub i32);
impl EXPLORER_BROWSER_OPTIONS {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl core::ops::BitOr for EXPLORER_BROWSER_OPTIONS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl core::ops::BitAnd for EXPLORER_BROWSER_OPTIONS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl core::ops::BitOrAssign for EXPLORER_BROWSER_OPTIONS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl core::ops::BitAndAssign for EXPLORER_BROWSER_OPTIONS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl core::ops::Not for EXPLORER_BROWSER_OPTIONS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
pub const EXPPS_FILETYPES: _EXPPS = _EXPPS(1i32);
pub const EXP_DARWIN_ID_SIG: u32 = 2684354566u32;
#[repr(C, packed(1))]
#[derive(Clone, Copy)]
pub struct EXP_DARWIN_LINK {
    pub dbh: DATABLOCK_HEADER,
    pub szDarwinID: [i8; 260],
    pub szwDarwinID: [u16; 260],
}
impl Default for EXP_DARWIN_LINK {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C, packed(1))]
#[derive(Clone, Copy)]
pub struct EXP_PROPERTYSTORAGE {
    pub cbSize: u32,
    pub dwSignature: u32,
    pub abPropertyStorage: [u8; 1],
}
impl Default for EXP_PROPERTYSTORAGE {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const EXP_PROPERTYSTORAGE_SIG: u32 = 2684354569u32;
#[repr(C, packed(1))]
#[derive(Clone, Copy, Default)]
pub struct EXP_SPECIAL_FOLDER {
    pub cbSize: u32,
    pub dwSignature: u32,
    pub idSpecialFolder: u32,
    pub cbOffset: u32,
}
pub const EXP_SPECIAL_FOLDER_SIG: u32 = 2684354565u32;
pub const EXP_SZ_ICON_SIG: u32 = 2684354567u32;
#[repr(C, packed(1))]
#[derive(Clone, Copy)]
pub struct EXP_SZ_LINK {
    pub cbSize: u32,
    pub dwSignature: u32,
    pub szTarget: [i8; 260],
    pub swzTarget: [u16; 260],
}
impl Default for EXP_SZ_LINK {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const EXP_SZ_LINK_SIG: u32 = 2684354561u32;
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct EXTRASEARCH {
    pub guidSearch: windows_core::GUID,
    pub wszFriendlyName: [u16; 80],
    pub wszUrl: [u16; 2084],
}
impl Default for EXTRASEARCH {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const E_ACTIVATIONDENIED_SHELLERROR: windows_core::HRESULT = windows_core::HRESULT(0x80270131_u32 as _);
pub const E_ACTIVATIONDENIED_SHELLNOTREADY: windows_core::HRESULT = windows_core::HRESULT(0x80270134_u32 as _);
pub const E_ACTIVATIONDENIED_SHELLRESTART: windows_core::HRESULT = windows_core::HRESULT(0x80270132_u32 as _);
pub const E_ACTIVATIONDENIED_UNEXPECTED: windows_core::HRESULT = windows_core::HRESULT(0x80270133_u32 as _);
pub const E_ACTIVATIONDENIED_USERCLOSE: windows_core::HRESULT = windows_core::HRESULT(0x80270130_u32 as _);
pub const E_FILE_PLACEHOLDER_NOT_INITIALIZED: windows_core::HRESULT = windows_core::HRESULT(0x80270110_u32 as _);
pub const E_FILE_PLACEHOLDER_SERVER_TIMED_OUT: windows_core::HRESULT = windows_core::HRESULT(0x80270112_u32 as _);
pub const E_FILE_PLACEHOLDER_STORAGEPROVIDER_NOT_FOUND: windows_core::HRESULT = windows_core::HRESULT(0x80270113_u32 as _);
pub const E_FILE_PLACEHOLDER_VERSION_MISMATCH: windows_core::HRESULT = windows_core::HRESULT(0x80270111_u32 as _);
pub const E_FLAGS: windows_core::HRESULT = windows_core::HRESULT(0x80041000_u32 as _);
pub const E_IMAGEFEED_CHANGEDISABLED: windows_core::HRESULT = windows_core::HRESULT(0x80270310_u32 as _);
pub const E_NOTVALIDFORANIMATEDIMAGE: windows_core::HRESULT = windows_core::HRESULT(0x80040001_u32 as _);
pub const E_PREVIEWHANDLER_CORRUPT: windows_core::HRESULT = windows_core::HRESULT(0x86420004_u32 as _);
pub const E_PREVIEWHANDLER_DRM_FAIL: windows_core::HRESULT = windows_core::HRESULT(0x86420001_u32 as _);
pub const E_PREVIEWHANDLER_NOAUTH: windows_core::HRESULT = windows_core::HRESULT(0x86420002_u32 as _);
pub const E_PREVIEWHANDLER_NOTFOUND: windows_core::HRESULT = windows_core::HRESULT(0x86420003_u32 as _);
pub const E_SHELL_EXTENSION_BLOCKED: windows_core::HRESULT = windows_core::HRESULT(0x80270301_u32 as _);
pub const E_TILE_NOTIFICATIONS_PLATFORM_FAILURE: windows_core::HRESULT = windows_core::HRESULT(0x80270249_u32 as _);
pub const E_USERTILE_CHANGEDISABLED: windows_core::HRESULT = windows_core::HRESULT(0x80270211_u32 as _);
pub const E_USERTILE_FILESIZE: windows_core::HRESULT = windows_core::HRESULT(0x80270214_u32 as _);
pub const E_USERTILE_LARGEORDYNAMIC: windows_core::HRESULT = windows_core::HRESULT(0x80270212_u32 as _);
pub const E_USERTILE_UNSUPPORTEDFILETYPE: windows_core::HRESULT = windows_core::HRESULT(0x80270210_u32 as _);
pub const E_USERTILE_VIDEOFRAMESIZE: windows_core::HRESULT = windows_core::HRESULT(0x80270213_u32 as _);
pub const EnumerableObjectCollection: windows_core::GUID = windows_core::GUID::from_u128(0x2d3468c1_36a7_43b6_ac24_d3f02fd9607a);
pub const ExecuteFolder: windows_core::GUID = windows_core::GUID::from_u128(0x11dbb47c_a525_400b_9e80_a54615a090c0);
pub const ExecuteUnknown: windows_core::GUID = windows_core::GUID::from_u128(0xe44e9428_bdbc_4987_a099_40dc8fd255e7);
pub const ExplorerBrowser: windows_core::GUID = windows_core::GUID::from_u128(0x71f96385_ddd6_48d3_a0c1_ae06e8b055fb);
pub const ExtractIfNotCached: ThumbnailStreamCacheOptions = ThumbnailStreamCacheOptions(0i32);
pub const FCIDM_BROWSERFIRST: u32 = 40960u32;
pub const FCIDM_BROWSERLAST: u32 = 48896u32;
pub const FCIDM_GLOBALFIRST: u32 = 32768u32;
pub const FCIDM_GLOBALLAST: u32 = 40959u32;
pub const FCIDM_MENU_EDIT: u32 = 32832u32;
pub const FCIDM_MENU_EXPLORE: u32 = 33104u32;
pub const FCIDM_MENU_FAVORITES: u32 = 33136u32;
pub const FCIDM_MENU_FILE: u32 = 32768u32;
pub const FCIDM_MENU_FIND: u32 = 33088u32;
pub const FCIDM_MENU_HELP: u32 = 33024u32;
pub const FCIDM_MENU_TOOLS: u32 = 32960u32;
pub const FCIDM_MENU_TOOLS_SEP_GOTO: u32 = 32961u32;
pub const FCIDM_MENU_VIEW: u32 = 32896u32;
pub const FCIDM_MENU_VIEW_SEP_OPTIONS: u32 = 32897u32;
pub const FCIDM_SHVIEWFIRST: u32 = 0u32;
pub const FCIDM_SHVIEWLAST: u32 = 32767u32;
pub const FCIDM_STATUS: u32 = 40961u32;
pub const FCIDM_TOOLBAR: u32 = 40960u32;
pub const FCSM_CLSID: u32 = 8u32;
pub const FCSM_FLAGS: u32 = 64u32;
pub const FCSM_ICONFILE: u32 = 16u32;
pub const FCSM_INFOTIP: u32 = 4u32;
pub const FCSM_LOGO: u32 = 32u32;
pub const FCSM_VIEWID: u32 = 1u32;
pub const FCSM_WEBVIEWTEMPLATE: u32 = 2u32;
pub const FCS_FLAG_DRAGDROP: u32 = 2u32;
pub const FCS_FORCEWRITE: u32 = 2u32;
pub const FCS_READ: u32 = 1u32;
pub const FCT_ADDTOEND: u32 = 4u32;
pub const FCT_CONFIGABLE: u32 = 2u32;
pub const FCT_MERGE: u32 = 1u32;
pub const FCW_INTERNETBAR: u32 = 6u32;
pub const FCW_PROGRESS: u32 = 8u32;
pub const FCW_STATUS: u32 = 1u32;
pub const FCW_TOOLBAR: u32 = 2u32;
pub const FCW_TREE: u32 = 3u32;
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct FDAP(pub i32);
pub const FDAP_BOTTOM: FDAP = FDAP(0i32);
pub const FDAP_TOP: FDAP = FDAP(1i32);
pub const FDEOR_ACCEPT: FDE_OVERWRITE_RESPONSE = FDE_OVERWRITE_RESPONSE(1i32);
pub const FDEOR_DEFAULT: FDE_OVERWRITE_RESPONSE = FDE_OVERWRITE_RESPONSE(0i32);
pub const FDEOR_REFUSE: FDE_OVERWRITE_RESPONSE = FDE_OVERWRITE_RESPONSE(2i32);
pub const FDESVR_ACCEPT: FDE_SHAREVIOLATION_RESPONSE = FDE_SHAREVIOLATION_RESPONSE(1i32);
pub const FDESVR_DEFAULT: FDE_SHAREVIOLATION_RESPONSE = FDE_SHAREVIOLATION_RESPONSE(0i32);
pub const FDESVR_REFUSE: FDE_SHAREVIOLATION_RESPONSE = FDE_SHAREVIOLATION_RESPONSE(2i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct FDE_OVERWRITE_RESPONSE(pub i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct FDE_SHAREVIOLATION_RESPONSE(pub i32);
pub const FDTF_LONGDATE: u32 = 4u32;
pub const FDTF_LONGTIME: u32 = 8u32;
pub const FDTF_LTRDATE: u32 = 256u32;
pub const FDTF_NOAUTOREADINGORDER: u32 = 1024u32;
pub const FDTF_RELATIVE: u32 = 16u32;
pub const FDTF_RTLDATE: u32 = 512u32;
pub const FDTF_SHORTDATE: u32 = 2u32;
pub const FDTF_SHORTTIME: u32 = 1u32;
pub const FD_ACCESSTIME: FD_FLAGS = FD_FLAGS(16i32);
pub const FD_ATTRIBUTES: FD_FLAGS = FD_FLAGS(4i32);
pub const FD_CLSID: FD_FLAGS = FD_FLAGS(1i32);
pub const FD_CREATETIME: FD_FLAGS = FD_FLAGS(8i32);
pub const FD_FILESIZE: FD_FLAGS = FD_FLAGS(64i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct FD_FLAGS(pub i32);
pub const FD_LINKUI: FD_FLAGS = FD_FLAGS(32768i32);
pub const FD_PROGRESSUI: FD_FLAGS = FD_FLAGS(16384i32);
pub const FD_SIZEPOINT: FD_FLAGS = FD_FLAGS(2i32);
pub const FD_UNICODE: FD_FLAGS = FD_FLAGS(-2147483648i32);
pub const FD_WRITESTIME: FD_FLAGS = FD_FLAGS(32i32);
pub const FEM_NAVIGATION: FOLDER_ENUM_MODE = FOLDER_ENUM_MODE(1i32);
pub const FEM_VIEWRESULT: FOLDER_ENUM_MODE = FOLDER_ENUM_MODE(0i32);
pub const FFFP_EXACTMATCH: FFFP_MODE = FFFP_MODE(0i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct FFFP_MODE(pub i32);
pub const FFFP_NEARESTPARENTMATCH: FFFP_MODE = FFFP_MODE(1i32);
#[repr(C, packed(1))]
#[derive(Clone, Copy)]
pub struct FILEDESCRIPTORA {
    pub dwFlags: u32,
    pub clsid: windows_core::GUID,
    pub sizel: super::super::Foundation::SIZE,
    pub pointl: super::super::Foundation::POINTL,
    pub dwFileAttributes: u32,
    pub ftCreationTime: super::super::Foundation::FILETIME,
    pub ftLastAccessTime: super::super::Foundation::FILETIME,
    pub ftLastWriteTime: super::super::Foundation::FILETIME,
    pub nFileSizeHigh: u32,
    pub nFileSizeLow: u32,
    pub cFileName: [i8; 260],
}
impl Default for FILEDESCRIPTORA {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C, packed(1))]
#[derive(Clone, Copy)]
pub struct FILEDESCRIPTORW {
    pub dwFlags: u32,
    pub clsid: windows_core::GUID,
    pub sizel: super::super::Foundation::SIZE,
    pub pointl: super::super::Foundation::POINTL,
    pub dwFileAttributes: u32,
    pub ftCreationTime: super::super::Foundation::FILETIME,
    pub ftLastAccessTime: super::super::Foundation::FILETIME,
    pub ftLastWriteTime: super::super::Foundation::FILETIME,
    pub nFileSizeHigh: u32,
    pub nFileSizeLow: u32,
    pub cFileName: [u16; 260],
}
impl Default for FILEDESCRIPTORW {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C, packed(1))]
#[derive(Clone, Copy)]
pub struct FILEGROUPDESCRIPTORA {
    pub cItems: u32,
    pub fgd: [FILEDESCRIPTORA; 1],
}
impl Default for FILEGROUPDESCRIPTORA {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C, packed(1))]
#[derive(Clone, Copy)]
pub struct FILEGROUPDESCRIPTORW {
    pub cItems: u32,
    pub fgd: [FILEDESCRIPTORW; 1],
}
impl Default for FILEGROUPDESCRIPTORW {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct FILEOPENDIALOGOPTIONS(pub u32);
impl FILEOPENDIALOGOPTIONS {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl core::ops::BitOr for FILEOPENDIALOGOPTIONS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl core::ops::BitAnd for FILEOPENDIALOGOPTIONS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl core::ops::BitOrAssign for FILEOPENDIALOGOPTIONS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl core::ops::BitAndAssign for FILEOPENDIALOGOPTIONS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl core::ops::Not for FILEOPENDIALOGOPTIONS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct FILEOPERATION_FLAGS(pub u32);
impl FILEOPERATION_FLAGS {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl core::ops::BitOr for FILEOPERATION_FLAGS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl core::ops::BitAnd for FILEOPERATION_FLAGS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl core::ops::BitOrAssign for FILEOPERATION_FLAGS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl core::ops::BitAndAssign for FILEOPERATION_FLAGS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl core::ops::Not for FILEOPERATION_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct FILETYPEATTRIBUTEFLAGS(pub i32);
impl FILETYPEATTRIBUTEFLAGS {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl core::ops::BitOr for FILETYPEATTRIBUTEFLAGS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl core::ops::BitAnd for FILETYPEATTRIBUTEFLAGS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl core::ops::BitOrAssign for FILETYPEATTRIBUTEFLAGS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl core::ops::BitAndAssign for FILETYPEATTRIBUTEFLAGS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl core::ops::Not for FILETYPEATTRIBUTEFLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[repr(C, packed(1))]
#[derive(Clone, Copy)]
pub struct FILE_ATTRIBUTES_ARRAY {
    pub cItems: u32,
    pub dwSumFileAttributes: u32,
    pub dwProductFileAttributes: u32,
    pub rgdwFileAttributes: [u32; 1],
}
impl Default for FILE_ATTRIBUTES_ARRAY {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct FILE_OPERATION_FLAGS2(pub i32);
impl FILE_OPERATION_FLAGS2 {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl core::ops::BitOr for FILE_OPERATION_FLAGS2 {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl core::ops::BitAnd for FILE_OPERATION_FLAGS2 {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl core::ops::BitOrAssign for FILE_OPERATION_FLAGS2 {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl core::ops::BitAndAssign for FILE_OPERATION_FLAGS2 {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl core::ops::Not for FILE_OPERATION_FLAGS2 {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct FILE_USAGE_TYPE(pub i32);
pub const FLVM_CONTENT: FOLDERLOGICALVIEWMODE = FOLDERLOGICALVIEWMODE(5i32);
pub const FLVM_DETAILS: FOLDERLOGICALVIEWMODE = FOLDERLOGICALVIEWMODE(1i32);
pub const FLVM_FIRST: FOLDERLOGICALVIEWMODE = FOLDERLOGICALVIEWMODE(1i32);
pub const FLVM_ICONS: FOLDERLOGICALVIEWMODE = FOLDERLOGICALVIEWMODE(3i32);
pub const FLVM_LAST: FOLDERLOGICALVIEWMODE = FOLDERLOGICALVIEWMODE(5i32);
pub const FLVM_LIST: FOLDERLOGICALVIEWMODE = FOLDERLOGICALVIEWMODE(4i32);
pub const FLVM_TILES: FOLDERLOGICALVIEWMODE = FOLDERLOGICALVIEWMODE(2i32);
pub const FLVM_UNSPECIFIED: FOLDERLOGICALVIEWMODE = FOLDERLOGICALVIEWMODE(-1i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct FLYOUT_PLACEMENT(pub i32);
pub const FMTID_Briefcase: windows_core::GUID = windows_core::GUID::from_u128(0x328d8b21_7729_4bfc_954c_902b329d56b0);
pub const FMTID_CustomImageProperties: windows_core::GUID = windows_core::GUID::from_u128(0x7ecd8b0e_c136_4a9b_9411_4ebd6673ccc3);
pub const FMTID_DRM: windows_core::GUID = windows_core::GUID::from_u128(0xaeac19e4_89ae_4508_b9b7_bb867abee2ed);
pub const FMTID_Displaced: windows_core::GUID = windows_core::GUID::from_u128(0x9b174b33_40ff_11d2_a27e_00c04fc30871);
pub const FMTID_ImageProperties: windows_core::GUID = windows_core::GUID::from_u128(0x14b81da1_0135_4d31_96d9_6cbfc9671a99);
pub const FMTID_InternetSite: windows_core::GUID = windows_core::GUID::from_u128(0x000214a1_0000_0000_c000_000000000046);
pub const FMTID_Intshcut: windows_core::GUID = windows_core::GUID::from_u128(0x000214a0_0000_0000_c000_000000000046);
pub const FMTID_LibraryProperties: windows_core::GUID = windows_core::GUID::from_u128(0x5d76b67f_9b3d_44bb_b6ae_25da4f638a67);
pub const FMTID_MUSIC: windows_core::GUID = windows_core::GUID::from_u128(0x56a3372e_ce9c_11d2_9f0e_006097c686f6);
pub const FMTID_Misc: windows_core::GUID = windows_core::GUID::from_u128(0x9b174b34_40ff_11d2_a27e_00c04fc30871);
pub const FMTID_Query: windows_core::GUID = windows_core::GUID::from_u128(0x49691c90_7e17_101a_a91c_08002b2ecda9);
pub const FMTID_ShellDetails: windows_core::GUID = windows_core::GUID::from_u128(0x28636aa6_953d_11d2_b5d6_00c04fd918d0);
pub const FMTID_Storage: windows_core::GUID = windows_core::GUID::from_u128(0xb725f130_47ef_101a_a5f1_02608c9eebac);
pub const FMTID_Volume: windows_core::GUID = windows_core::GUID::from_u128(0x9b174b35_40ff_11d2_a27e_00c04fc30871);
pub const FMTID_WebView: windows_core::GUID = windows_core::GUID::from_u128(0xf2275480_f782_4291_bd94_f13693513aec);
pub const FOF2_MERGEFOLDERSONCOLLISION: FILE_OPERATION_FLAGS2 = FILE_OPERATION_FLAGS2(1i32);
pub const FOF2_NONE: FILE_OPERATION_FLAGS2 = FILE_OPERATION_FLAGS2(0i32);
pub const FOFX_ADDUNDORECORD: FILEOPERATION_FLAGS = FILEOPERATION_FLAGS(536870912u32);
pub const FOFX_COPYASDOWNLOAD: FILEOPERATION_FLAGS = FILEOPERATION_FLAGS(1073741824u32);
pub const FOFX_DONTDISPLAYDESTPATH: FILEOPERATION_FLAGS = FILEOPERATION_FLAGS(134217728u32);
pub const FOFX_DONTDISPLAYLOCATIONS: FILEOPERATION_FLAGS = FILEOPERATION_FLAGS(2147483648u32);
pub const FOFX_DONTDISPLAYSOURCEPATH: FILEOPERATION_FLAGS = FILEOPERATION_FLAGS(67108864u32);
pub const FOFX_EARLYFAILURE: FILEOPERATION_FLAGS = FILEOPERATION_FLAGS(1048576u32);
pub const FOFX_KEEPNEWERFILE: FILEOPERATION_FLAGS = FILEOPERATION_FLAGS(4194304u32);
pub const FOFX_MOVEACLSACROSSVOLUMES: FILEOPERATION_FLAGS = FILEOPERATION_FLAGS(33554432u32);
pub const FOFX_NOCOPYHOOKS: FILEOPERATION_FLAGS = FILEOPERATION_FLAGS(8388608u32);
pub const FOFX_NOMINIMIZEBOX: FILEOPERATION_FLAGS = FILEOPERATION_FLAGS(16777216u32);
pub const FOFX_NOSKIPJUNCTIONS: FILEOPERATION_FLAGS = FILEOPERATION_FLAGS(65536u32);
pub const FOFX_PREFERHARDLINK: FILEOPERATION_FLAGS = FILEOPERATION_FLAGS(131072u32);
pub const FOFX_PRESERVEFILEEXTENSIONS: FILEOPERATION_FLAGS = FILEOPERATION_FLAGS(2097152u32);
pub const FOFX_RECYCLEONDELETE: FILEOPERATION_FLAGS = FILEOPERATION_FLAGS(524288u32);
pub const FOFX_REQUIREELEVATION: FILEOPERATION_FLAGS = FILEOPERATION_FLAGS(268435456u32);
pub const FOFX_SHOWELEVATIONPROMPT: FILEOPERATION_FLAGS = FILEOPERATION_FLAGS(262144u32);
pub const FOF_ALLOWUNDO: FILEOPERATION_FLAGS = FILEOPERATION_FLAGS(64u32);
pub const FOF_CONFIRMMOUSE: FILEOPERATION_FLAGS = FILEOPERATION_FLAGS(2u32);
pub const FOF_FILESONLY: FILEOPERATION_FLAGS = FILEOPERATION_FLAGS(128u32);
pub const FOF_MULTIDESTFILES: FILEOPERATION_FLAGS = FILEOPERATION_FLAGS(1u32);
pub const FOF_NOCONFIRMATION: FILEOPERATION_FLAGS = FILEOPERATION_FLAGS(16u32);
pub const FOF_NOCONFIRMMKDIR: FILEOPERATION_FLAGS = FILEOPERATION_FLAGS(512u32);
pub const FOF_NOCOPYSECURITYATTRIBS: FILEOPERATION_FLAGS = FILEOPERATION_FLAGS(2048u32);
pub const FOF_NOERRORUI: FILEOPERATION_FLAGS = FILEOPERATION_FLAGS(1024u32);
pub const FOF_NORECURSEREPARSE: FILEOPERATION_FLAGS = FILEOPERATION_FLAGS(32768u32);
pub const FOF_NORECURSION: FILEOPERATION_FLAGS = FILEOPERATION_FLAGS(4096u32);
pub const FOF_NO_CONNECTED_ELEMENTS: FILEOPERATION_FLAGS = FILEOPERATION_FLAGS(8192u32);
pub const FOF_NO_UI: FILEOPERATION_FLAGS = FILEOPERATION_FLAGS(1556u32);
pub const FOF_RENAMEONCOLLISION: FILEOPERATION_FLAGS = FILEOPERATION_FLAGS(8u32);
pub const FOF_SILENT: FILEOPERATION_FLAGS = FILEOPERATION_FLAGS(4u32);
pub const FOF_SIMPLEPROGRESS: FILEOPERATION_FLAGS = FILEOPERATION_FLAGS(256u32);
pub const FOF_WANTMAPPINGHANDLE: FILEOPERATION_FLAGS = FILEOPERATION_FLAGS(32u32);
pub const FOF_WANTNUKEWARNING: FILEOPERATION_FLAGS = FILEOPERATION_FLAGS(16384u32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct FOLDERFLAGS(pub i32);
impl FOLDERFLAGS {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl core::ops::BitOr for FOLDERFLAGS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl core::ops::BitAnd for FOLDERFLAGS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl core::ops::BitOrAssign for FOLDERFLAGS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl core::ops::BitAndAssign for FOLDERFLAGS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl core::ops::Not for FOLDERFLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
pub const FOLDERID_AccountPictures: windows_core::GUID = windows_core::GUID::from_u128(0x008ca0b1_55b4_4c56_b8a8_4de4b299d3be);
pub const FOLDERID_AddNewPrograms: windows_core::GUID = windows_core::GUID::from_u128(0xde61d971_5ebc_4f02_a3a9_6c82895e5c04);
pub const FOLDERID_AdminTools: windows_core::GUID = windows_core::GUID::from_u128(0x724ef170_a42d_4fef_9f26_b60e846fba4f);
pub const FOLDERID_AllAppMods: windows_core::GUID = windows_core::GUID::from_u128(0x7ad67899_66af_43ba_9156_6aad42e6c596);
pub const FOLDERID_AppCaptures: windows_core::GUID = windows_core::GUID::from_u128(0xedc0fe71_98d8_4f4a_b920_c8dc133cb165);
pub const FOLDERID_AppDataDesktop: windows_core::GUID = windows_core::GUID::from_u128(0xb2c5e279_7add_439f_b28c_c41fe1bbf672);
pub const FOLDERID_AppDataDocuments: windows_core::GUID = windows_core::GUID::from_u128(0x7be16610_1f7f_44ac_bff0_83e15f2ffca1);
pub const FOLDERID_AppDataFavorites: windows_core::GUID = windows_core::GUID::from_u128(0x7cfbefbc_de1f_45aa_b843_a542ac536cc9);
pub const FOLDERID_AppDataProgramData: windows_core::GUID = windows_core::GUID::from_u128(0x559d40a3_a036_40fa_af61_84cb430a4d34);
pub const FOLDERID_AppUpdates: windows_core::GUID = windows_core::GUID::from_u128(0xa305ce99_f527_492b_8b1a_7e76fa98d6e4);
pub const FOLDERID_ApplicationShortcuts: windows_core::GUID = windows_core::GUID::from_u128(0xa3918781_e5f2_4890_b3d9_a7e54332328c);
pub const FOLDERID_AppsFolder: windows_core::GUID = windows_core::GUID::from_u128(0x1e87508d_89c2_42f0_8a7e_645a0f50ca58);
pub const FOLDERID_CDBurning: windows_core::GUID = windows_core::GUID::from_u128(0x9e52ab10_f80d_49df_acb8_4330f5687855);
pub const FOLDERID_CameraRoll: windows_core::GUID = windows_core::GUID::from_u128(0xab5fb87b_7ce2_4f83_915d_550846c9537b);
pub const FOLDERID_CameraRollLibrary: windows_core::GUID = windows_core::GUID::from_u128(0x2b20df75_1eda_4039_8097_38798227d5b7);
pub const FOLDERID_ChangeRemovePrograms: windows_core::GUID = windows_core::GUID::from_u128(0xdf7266ac_9274_4867_8d55_3bd661de872d);
pub const FOLDERID_CommonAdminTools: windows_core::GUID = windows_core::GUID::from_u128(0xd0384e7d_bac3_4797_8f14_cba229b392b5);
pub const FOLDERID_CommonOEMLinks: windows_core::GUID = windows_core::GUID::from_u128(0xc1bae2d0_10df_4334_bedd_7aa20b227a9d);
pub const FOLDERID_CommonPrograms: windows_core::GUID = windows_core::GUID::from_u128(0x0139d44e_6afe_49f2_8690_3dafcae6ffb8);
pub const FOLDERID_CommonStartMenu: windows_core::GUID = windows_core::GUID::from_u128(0xa4115719_d62e_491d_aa7c_e74b8be3b067);
pub const FOLDERID_CommonStartMenuPlaces: windows_core::GUID = windows_core::GUID::from_u128(0xa440879f_87a0_4f7d_b700_0207b966194a);
pub const FOLDERID_CommonStartup: windows_core::GUID = windows_core::GUID::from_u128(0x82a5ea35_d9cd_47c5_9629_e15d2f714e6e);
pub const FOLDERID_CommonTemplates: windows_core::GUID = windows_core::GUID::from_u128(0xb94237e7_57ac_4347_9151_b08c6c32d1f7);
pub const FOLDERID_ComputerFolder: windows_core::GUID = windows_core::GUID::from_u128(0x0ac0837c_bbf8_452a_850d_79d08e667ca7);
pub const FOLDERID_ConflictFolder: windows_core::GUID = windows_core::GUID::from_u128(0x4bfefb45_347d_4006_a5be_ac0cb0567192);
pub const FOLDERID_ConnectionsFolder: windows_core::GUID = windows_core::GUID::from_u128(0x6f0cd92b_2e97_45d1_88ff_b0d186b8dedd);
pub const FOLDERID_Contacts: windows_core::GUID = windows_core::GUID::from_u128(0x56784854_c6cb_462b_8169_88e350acb882);
pub const FOLDERID_ControlPanelFolder: windows_core::GUID = windows_core::GUID::from_u128(0x82a74aeb_aeb4_465c_a014_d097ee346d63);
pub const FOLDERID_Cookies: windows_core::GUID = windows_core::GUID::from_u128(0x2b0f765d_c0e9_4171_908e_08a611b84ff6);
pub const FOLDERID_CurrentAppMods: windows_core::GUID = windows_core::GUID::from_u128(0x3db40b20_2a30_4dbe_917e_771dd21dd099);
pub const FOLDERID_Desktop: windows_core::GUID = windows_core::GUID::from_u128(0xb4bfcc3a_db2c_424c_b029_7fe99a87c641);
pub const FOLDERID_DevelopmentFiles: windows_core::GUID = windows_core::GUID::from_u128(0xdbe8e08e_3053_4bbc_b183_2a7b2b191e59);
pub const FOLDERID_Device: windows_core::GUID = windows_core::GUID::from_u128(0x1c2ac1dc_4358_4b6c_9733_af21156576f0);
pub const FOLDERID_DeviceMetadataStore: windows_core::GUID = windows_core::GUID::from_u128(0x5ce4a5e9_e4eb_479d_b89f_130c02886155);
pub const FOLDERID_Documents: windows_core::GUID = windows_core::GUID::from_u128(0xfdd39ad0_238f_46af_adb4_6c85480369c7);
pub const FOLDERID_DocumentsLibrary: windows_core::GUID = windows_core::GUID::from_u128(0x7b0db17d_9cd2_4a93_9733_46cc89022e7c);
pub const FOLDERID_Downloads: windows_core::GUID = windows_core::GUID::from_u128(0x374de290_123f_4565_9164_39c4925e467b);
pub const FOLDERID_Favorites: windows_core::GUID = windows_core::GUID::from_u128(0x1777f761_68ad_4d8a_87bd_30b759fa33dd);
pub const FOLDERID_Fonts: windows_core::GUID = windows_core::GUID::from_u128(0xfd228cb7_ae11_4ae3_864c_16f3910ab8fe);
pub const FOLDERID_GameTasks: windows_core::GUID = windows_core::GUID::from_u128(0x054fae61_4dd8_4787_80b6_090220c4b700);
pub const FOLDERID_Games: windows_core::GUID = windows_core::GUID::from_u128(0xcac52c1a_b53d_4edc_92d7_6b2e8ac19434);
pub const FOLDERID_History: windows_core::GUID = windows_core::GUID::from_u128(0xd9dc8a3b_b784_432e_a781_5a1130a75963);
pub const FOLDERID_HomeGroup: windows_core::GUID = windows_core::GUID::from_u128(0x52528a6b_b9e3_4add_b60d_588c2dba842d);
pub const FOLDERID_HomeGroupCurrentUser: windows_core::GUID = windows_core::GUID::from_u128(0x9b74b6a3_0dfd_4f11_9e78_5f7800f2e772);
pub const FOLDERID_ImplicitAppShortcuts: windows_core::GUID = windows_core::GUID::from_u128(0xbcb5256f_79f6_4cee_b725_dc34e402fd46);
pub const FOLDERID_InternetCache: windows_core::GUID = windows_core::GUID::from_u128(0x352481e8_33be_4251_ba85_6007caedcf9d);
pub const FOLDERID_InternetFolder: windows_core::GUID = windows_core::GUID::from_u128(0x4d9f7874_4e0c_4904_967b_40b0d20c3e4b);
pub const FOLDERID_Libraries: windows_core::GUID = windows_core::GUID::from_u128(0x1b3ea5dc_b587_4786_b4ef_bd1dc332aeae);
pub const FOLDERID_Links: windows_core::GUID = windows_core::GUID::from_u128(0xbfb9d5e0_c6a9_404c_b2b2_ae6db6af4968);
pub const FOLDERID_LocalAppData: windows_core::GUID = windows_core::GUID::from_u128(0xf1b32785_6fba_4fcf_9d55_7b8e7f157091);
pub const FOLDERID_LocalAppDataLow: windows_core::GUID = windows_core::GUID::from_u128(0xa520a1a4_1780_4ff6_bd18_167343c5af16);
pub const FOLDERID_LocalDocuments: windows_core::GUID = windows_core::GUID::from_u128(0xf42ee2d3_909f_4907_8871_4c22fc0bf756);
pub const FOLDERID_LocalDownloads: windows_core::GUID = windows_core::GUID::from_u128(0x7d83ee9b_2244_4e70_b1f5_5393042af1e4);
pub const FOLDERID_LocalMusic: windows_core::GUID = windows_core::GUID::from_u128(0xa0c69a99_21c8_4671_8703_7934162fcf1d);
pub const FOLDERID_LocalPictures: windows_core::GUID = windows_core::GUID::from_u128(0x0ddd015d_b06c_45d5_8c4c_f59713854639);
pub const FOLDERID_LocalStorage: windows_core::GUID = windows_core::GUID::from_u128(0xb3eb08d3_a1f3_496b_865a_42b536cda0ec);
pub const FOLDERID_LocalVideos: windows_core::GUID = windows_core::GUID::from_u128(0x35286a68_3c57_41a1_bbb1_0eae73d76c95);
pub const FOLDERID_LocalizedResourcesDir: windows_core::GUID = windows_core::GUID::from_u128(0x2a00375e_224c_49de_b8d1_440df7ef3ddc);
pub const FOLDERID_Music: windows_core::GUID = windows_core::GUID::from_u128(0x4bd8d571_6d19_48d3_be97_422220080e43);
pub const FOLDERID_MusicLibrary: windows_core::GUID = windows_core::GUID::from_u128(0x2112ab0a_c86a_4ffe_a368_0de96e47012e);
pub const FOLDERID_NetHood: windows_core::GUID = windows_core::GUID::from_u128(0xc5abbf53_e17f_4121_8900_86626fc2c973);
pub const FOLDERID_NetworkFolder: windows_core::GUID = windows_core::GUID::from_u128(0xd20beec4_5ca8_4905_ae3b_bf251ea09b53);
pub const FOLDERID_Objects3D: windows_core::GUID = windows_core::GUID::from_u128(0x31c0dd25_9439_4f12_bf41_7ff4eda38722);
pub const FOLDERID_OneDrive: windows_core::GUID = windows_core::GUID::from_u128(0xa52bba46_e9e1_435f_b3d9_28daa648c0f6);
pub const FOLDERID_OriginalImages: windows_core::GUID = windows_core::GUID::from_u128(0x2c36c0aa_5812_4b87_bfd0_4cd0dfb19b39);
pub const FOLDERID_PhotoAlbums: windows_core::GUID = windows_core::GUID::from_u128(0x69d2cf90_fc33_4fb7_9a0c_ebb0f0fcb43c);
pub const FOLDERID_Pictures: windows_core::GUID = windows_core::GUID::from_u128(0x33e28130_4e1e_4676_835a_98395c3bc3bb);
pub const FOLDERID_PicturesLibrary: windows_core::GUID = windows_core::GUID::from_u128(0xa990ae9f_a03b_4e80_94bc_9912d7504104);
pub const FOLDERID_Playlists: windows_core::GUID = windows_core::GUID::from_u128(0xde92c1c7_837f_4f69_a3bb_86e631204a23);
pub const FOLDERID_PrintHood: windows_core::GUID = windows_core::GUID::from_u128(0x9274bd8d_cfd1_41c3_b35e_b13f55a758f4);
pub const FOLDERID_PrintersFolder: windows_core::GUID = windows_core::GUID::from_u128(0x76fc4e2d_d6ad_4519_a663_37bd56068185);
pub const FOLDERID_Profile: windows_core::GUID = windows_core::GUID::from_u128(0x5e6c858f_0e22_4760_9afe_ea3317b67173);
pub const FOLDERID_ProgramData: windows_core::GUID = windows_core::GUID::from_u128(0x62ab5d82_fdc1_4dc3_a9dd_070d1d495d97);
pub const FOLDERID_ProgramFiles: windows_core::GUID = windows_core::GUID::from_u128(0x905e63b6_c1bf_494e_b29c_65b732d3d21a);
pub const FOLDERID_ProgramFilesCommon: windows_core::GUID = windows_core::GUID::from_u128(0xf7f1ed05_9f6d_47a2_aaae_29d317c6f066);
pub const FOLDERID_ProgramFilesCommonX64: windows_core::GUID = windows_core::GUID::from_u128(0x6365d5a7_0f0d_45e5_87f6_0da56b6a4f7d);
pub const FOLDERID_ProgramFilesCommonX86: windows_core::GUID = windows_core::GUID::from_u128(0xde974d24_d9c6_4d3e_bf91_f4455120b917);
pub const FOLDERID_ProgramFilesX64: windows_core::GUID = windows_core::GUID::from_u128(0x6d809377_6af0_444b_8957_a3773f02200e);
pub const FOLDERID_ProgramFilesX86: windows_core::GUID = windows_core::GUID::from_u128(0x7c5a40ef_a0fb_4bfc_874a_c0f2e0b9fa8e);
pub const FOLDERID_Programs: windows_core::GUID = windows_core::GUID::from_u128(0xa77f5d77_2e2b_44c3_a6a2_aba601054a51);
pub const FOLDERID_Public: windows_core::GUID = windows_core::GUID::from_u128(0xdfdf76a2_c82a_4d63_906a_5644ac457385);
pub const FOLDERID_PublicDesktop: windows_core::GUID = windows_core::GUID::from_u128(0xc4aa340d_f20f_4863_afef_f87ef2e6ba25);
pub const FOLDERID_PublicDocuments: windows_core::GUID = windows_core::GUID::from_u128(0xed4824af_dce4_45a8_81e2_fc7965083634);
pub const FOLDERID_PublicDownloads: windows_core::GUID = windows_core::GUID::from_u128(0x3d644c9b_1fb8_4f30_9b45_f670235f79c0);
pub const FOLDERID_PublicGameTasks: windows_core::GUID = windows_core::GUID::from_u128(0xdebf2536_e1a8_4c59_b6a2_414586476aea);
pub const FOLDERID_PublicLibraries: windows_core::GUID = windows_core::GUID::from_u128(0x48daf80b_e6cf_4f4e_b800_0e69d84ee384);
pub const FOLDERID_PublicMusic: windows_core::GUID = windows_core::GUID::from_u128(0x3214fab5_9757_4298_bb61_92a9deaa44ff);
pub const FOLDERID_PublicPictures: windows_core::GUID = windows_core::GUID::from_u128(0xb6ebfb86_6907_413c_9af7_4fc2abf07cc5);
pub const FOLDERID_PublicRingtones: windows_core::GUID = windows_core::GUID::from_u128(0xe555ab60_153b_4d17_9f04_a5fe99fc15ec);
pub const FOLDERID_PublicUserTiles: windows_core::GUID = windows_core::GUID::from_u128(0x0482af6c_08f1_4c34_8c90_e17ec98b1e17);
pub const FOLDERID_PublicVideos: windows_core::GUID = windows_core::GUID::from_u128(0x2400183a_6185_49fb_a2d8_4a392a602ba3);
pub const FOLDERID_QuickLaunch: windows_core::GUID = windows_core::GUID::from_u128(0x52a4f021_7b75_48a9_9f6b_4b87a210bc8f);
pub const FOLDERID_Recent: windows_core::GUID = windows_core::GUID::from_u128(0xae50c081_ebd2_438a_8655_8a092e34987a);
pub const FOLDERID_RecordedCalls: windows_core::GUID = windows_core::GUID::from_u128(0x2f8b40c2_83ed_48ee_b383_a1f157ec6f9a);
pub const FOLDERID_RecordedTVLibrary: windows_core::GUID = windows_core::GUID::from_u128(0x1a6fdba2_f42d_4358_a798_b74d745926c5);
pub const FOLDERID_RecycleBinFolder: windows_core::GUID = windows_core::GUID::from_u128(0xb7534046_3ecb_4c18_be4e_64cd4cb7d6ac);
pub const FOLDERID_ResourceDir: windows_core::GUID = windows_core::GUID::from_u128(0x8ad10c31_2adb_4296_a8f7_e4701232c972);
pub const FOLDERID_RetailDemo: windows_core::GUID = windows_core::GUID::from_u128(0x12d4c69e_24ad_4923_be19_31321c43a767);
pub const FOLDERID_Ringtones: windows_core::GUID = windows_core::GUID::from_u128(0xc870044b_f49e_4126_a9c3_b52a1ff411e8);
pub const FOLDERID_RoamedTileImages: windows_core::GUID = windows_core::GUID::from_u128(0xaaa8d5a5_f1d6_4259_baa8_78e7ef60835e);
pub const FOLDERID_RoamingAppData: windows_core::GUID = windows_core::GUID::from_u128(0x3eb685db_65f9_4cf6_a03a_e3ef65729f3d);
pub const FOLDERID_RoamingTiles: windows_core::GUID = windows_core::GUID::from_u128(0x00bcfc5a_ed94_4e48_96a1_3f6217f21990);
pub const FOLDERID_SEARCH_CSC: windows_core::GUID = windows_core::GUID::from_u128(0xee32e446_31ca_4aba_814f_a5ebd2fd6d5e);
pub const FOLDERID_SEARCH_MAPI: windows_core::GUID = windows_core::GUID::from_u128(0x98ec0e18_2098_4d44_8644_66979315a281);
pub const FOLDERID_SampleMusic: windows_core::GUID = windows_core::GUID::from_u128(0xb250c668_f57d_4ee1_a63c_290ee7d1aa1f);
pub const FOLDERID_SamplePictures: windows_core::GUID = windows_core::GUID::from_u128(0xc4900540_2379_4c75_844b_64e6faf8716b);
pub const FOLDERID_SamplePlaylists: windows_core::GUID = windows_core::GUID::from_u128(0x15ca69b3_30ee_49c1_ace1_6b5ec372afb5);
pub const FOLDERID_SampleVideos: windows_core::GUID = windows_core::GUID::from_u128(0x859ead94_2e85_48ad_a71a_0969cb56a6cd);
pub const FOLDERID_SavedGames: windows_core::GUID = windows_core::GUID::from_u128(0x4c5c32ff_bb9d_43b0_b5b4_2d72e54eaaa4);
pub const FOLDERID_SavedPictures: windows_core::GUID = windows_core::GUID::from_u128(0x3b193882_d3ad_4eab_965a_69829d1fb59f);
pub const FOLDERID_SavedPicturesLibrary: windows_core::GUID = windows_core::GUID::from_u128(0xe25b5812_be88_4bd9_94b0_29233477b6c3);
pub const FOLDERID_SavedSearches: windows_core::GUID = windows_core::GUID::from_u128(0x7d1d3a04_debb_4115_95cf_2f29da2920da);
pub const FOLDERID_Screenshots: windows_core::GUID = windows_core::GUID::from_u128(0xb7bede81_df94_4682_a7d8_57a52620b86f);
pub const FOLDERID_SearchHistory: windows_core::GUID = windows_core::GUID::from_u128(0x0d4c3db6_03a3_462f_a0e6_08924c41b5d4);
pub const FOLDERID_SearchHome: windows_core::GUID = windows_core::GUID::from_u128(0x190337d1_b8ca_4121_a639_6d472d16972a);
pub const FOLDERID_SearchTemplates: windows_core::GUID = windows_core::GUID::from_u128(0x7e636bfe_dfa9_4d5e_b456_d7b39851d8a9);
pub const FOLDERID_SendTo: windows_core::GUID = windows_core::GUID::from_u128(0x8983036c_27c0_404b_8f08_102d10dcfd74);
pub const FOLDERID_SidebarDefaultParts: windows_core::GUID = windows_core::GUID::from_u128(0x7b396e54_9ec5_4300_be0a_2482ebae1a26);
pub const FOLDERID_SidebarParts: windows_core::GUID = windows_core::GUID::from_u128(0xa75d362e_50fc_4fb7_ac2c_a8beaa314493);
pub const FOLDERID_SkyDrive: windows_core::GUID = windows_core::GUID::from_u128(0xa52bba46_e9e1_435f_b3d9_28daa648c0f6);
pub const FOLDERID_SkyDriveCameraRoll: windows_core::GUID = windows_core::GUID::from_u128(0x767e6811_49cb_4273_87c2_20f355e1085b);
pub const FOLDERID_SkyDriveDocuments: windows_core::GUID = windows_core::GUID::from_u128(0x24d89e24_2f19_4534_9dde_6a6671fbb8fe);
pub const FOLDERID_SkyDriveMusic: windows_core::GUID = windows_core::GUID::from_u128(0xc3f2459e_80d6_45dc_bfef_1f769f2be730);
pub const FOLDERID_SkyDrivePictures: windows_core::GUID = windows_core::GUID::from_u128(0x339719b5_8c47_4894_94c2_d8f77add44a6);
pub const FOLDERID_StartMenu: windows_core::GUID = windows_core::GUID::from_u128(0x625b53c3_ab48_4ec1_ba1f_a1ef4146fc19);
pub const FOLDERID_StartMenuAllPrograms: windows_core::GUID = windows_core::GUID::from_u128(0xf26305ef_6948_40b9_b255_81453d09c785);
pub const FOLDERID_Startup: windows_core::GUID = windows_core::GUID::from_u128(0xb97d20bb_f46a_4c97_ba10_5e3608430854);
pub const FOLDERID_SyncManagerFolder: windows_core::GUID = windows_core::GUID::from_u128(0x43668bf8_c14e_49b2_97c9_747784d784b7);
pub const FOLDERID_SyncResultsFolder: windows_core::GUID = windows_core::GUID::from_u128(0x289a9a43_be44_4057_a41b_587a76d7e7f9);
pub const FOLDERID_SyncSetupFolder: windows_core::GUID = windows_core::GUID::from_u128(0x0f214138_b1d3_4a90_bba9_27cbc0c5389a);
pub const FOLDERID_System: windows_core::GUID = windows_core::GUID::from_u128(0x1ac14e77_02e7_4e5d_b744_2eb1ae5198b7);
pub const FOLDERID_SystemX86: windows_core::GUID = windows_core::GUID::from_u128(0xd65231b0_b2f1_4857_a4ce_a8e7c6ea7d27);
pub const FOLDERID_Templates: windows_core::GUID = windows_core::GUID::from_u128(0xa63293e8_664e_48db_a079_df759e0509f7);
pub const FOLDERID_UserPinned: windows_core::GUID = windows_core::GUID::from_u128(0x9e3995ab_1f9c_4f13_b827_48b24b6c7174);
pub const FOLDERID_UserProfiles: windows_core::GUID = windows_core::GUID::from_u128(0x0762d272_c50a_4bb0_a382_697dcd729b80);
pub const FOLDERID_UserProgramFiles: windows_core::GUID = windows_core::GUID::from_u128(0x5cd7aee2_2219_4a67_b85d_6c9ce15660cb);
pub const FOLDERID_UserProgramFilesCommon: windows_core::GUID = windows_core::GUID::from_u128(0xbcbd3057_ca5c_4622_b42d_bc56db0ae516);
pub const FOLDERID_UsersFiles: windows_core::GUID = windows_core::GUID::from_u128(0xf3ce0f7c_4901_4acc_8648_d5d44b04ef8f);
pub const FOLDERID_UsersLibraries: windows_core::GUID = windows_core::GUID::from_u128(0xa302545d_deff_464b_abe8_61c8648d939b);
pub const FOLDERID_Videos: windows_core::GUID = windows_core::GUID::from_u128(0x18989b1d_99b5_455b_841c_ab7c74e4ddfc);
pub const FOLDERID_VideosLibrary: windows_core::GUID = windows_core::GUID::from_u128(0x491e922f_5643_4af4_a7eb_4e7a138d8174);
pub const FOLDERID_Windows: windows_core::GUID = windows_core::GUID::from_u128(0xf38bf404_1d43_42f2_9305_67de0b28fc23);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct FOLDERLOGICALVIEWMODE(pub i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct FOLDERSETDATA {
    pub _fs: FOLDERSETTINGS,
    pub _vidRestore: windows_core::GUID,
    pub _dwViewPriority: u32,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct FOLDERSETTINGS {
    pub ViewMode: u32,
    pub fFlags: u32,
}
pub const FOLDERTYPEID_AccountPictures: windows_core::GUID = windows_core::GUID::from_u128(0xdb2a5d8f_06e6_4007_aba6_af877d526ea6);
pub const FOLDERTYPEID_Communications: windows_core::GUID = windows_core::GUID::from_u128(0x91475fe5_586b_4eba_8d75_d17434b8cdf6);
pub const FOLDERTYPEID_CompressedFolder: windows_core::GUID = windows_core::GUID::from_u128(0x80213e82_bcfd_4c4f_8817_bb27601267a9);
pub const FOLDERTYPEID_Contacts: windows_core::GUID = windows_core::GUID::from_u128(0xde2b70ec_9bf7_4a93_bd3d_243f7881d492);
pub const FOLDERTYPEID_ControlPanelCategory: windows_core::GUID = windows_core::GUID::from_u128(0xde4f0660_fa10_4b8f_a494_068b20b22307);
pub const FOLDERTYPEID_ControlPanelClassic: windows_core::GUID = windows_core::GUID::from_u128(0x0c3794f3_b545_43aa_a329_c37430c58d2a);
pub const FOLDERTYPEID_Documents: windows_core::GUID = windows_core::GUID::from_u128(0x7d49d726_3c21_4f05_99aa_fdc2c9474656);
pub const FOLDERTYPEID_Downloads: windows_core::GUID = windows_core::GUID::from_u128(0x885a186e_a440_4ada_812b_db871b942259);
pub const FOLDERTYPEID_Games: windows_core::GUID = windows_core::GUID::from_u128(0xb689b0d0_76d3_4cbb_87f7_585d0e0ce070);
pub const FOLDERTYPEID_Generic: windows_core::GUID = windows_core::GUID::from_u128(0x5c4f28b5_f869_4e84_8e60_f11db97c5cc7);
pub const FOLDERTYPEID_GenericLibrary: windows_core::GUID = windows_core::GUID::from_u128(0x5f4eab9a_6833_4f61_899d_31cf46979d49);
pub const FOLDERTYPEID_GenericSearchResults: windows_core::GUID = windows_core::GUID::from_u128(0x7fde1a1e_8b31_49a5_93b8_6be14cfa4943);
pub const FOLDERTYPEID_Invalid: windows_core::GUID = windows_core::GUID::from_u128(0x57807898_8c4f_4462_bb63_71042380b109);
pub const FOLDERTYPEID_Music: windows_core::GUID = windows_core::GUID::from_u128(0x94d6ddcc_4a68_4175_a374_bd584a510b78);
pub const FOLDERTYPEID_NetworkExplorer: windows_core::GUID = windows_core::GUID::from_u128(0x25cc242b_9a7c_4f51_80e0_7a2928febe42);
pub const FOLDERTYPEID_OpenSearch: windows_core::GUID = windows_core::GUID::from_u128(0x8faf9629_1980_46ff_8023_9dceab9c3ee3);
pub const FOLDERTYPEID_OtherUsers: windows_core::GUID = windows_core::GUID::from_u128(0xb337fd00_9dd5_4635_a6d4_da33fd102b7a);
pub const FOLDERTYPEID_Pictures: windows_core::GUID = windows_core::GUID::from_u128(0xb3690e58_e961_423b_b687_386ebfd83239);
pub const FOLDERTYPEID_Printers: windows_core::GUID = windows_core::GUID::from_u128(0x2c7bbec6_c844_4a0a_91fa_cef6f59cfda1);
pub const FOLDERTYPEID_PublishedItems: windows_core::GUID = windows_core::GUID::from_u128(0x7f2f5b96_ff74_41da_afd8_1c78a5f3aea2);
pub const FOLDERTYPEID_RecordedTV: windows_core::GUID = windows_core::GUID::from_u128(0x5557a28f_5da6_4f83_8809_c2c98a11a6fa);
pub const FOLDERTYPEID_RecycleBin: windows_core::GUID = windows_core::GUID::from_u128(0xd6d9e004_cd87_442b_9d57_5e0aeb4f6f72);
pub const FOLDERTYPEID_SavedGames: windows_core::GUID = windows_core::GUID::from_u128(0xd0363307_28cb_4106_9f23_2956e3e5e0e7);
pub const FOLDERTYPEID_SearchConnector: windows_core::GUID = windows_core::GUID::from_u128(0x982725ee_6f47_479e_b447_812bfa7d2e8f);
pub const FOLDERTYPEID_SearchHome: windows_core::GUID = windows_core::GUID::from_u128(0x834d8a44_0974_4ed6_866e_f203d80b3810);
pub const FOLDERTYPEID_Searches: windows_core::GUID = windows_core::GUID::from_u128(0x0b0ba2e3_405f_415e_a6ee_cad625207853);
pub const FOLDERTYPEID_SoftwareExplorer: windows_core::GUID = windows_core::GUID::from_u128(0xd674391b_52d9_4e07_834e_67c98610f39d);
pub const FOLDERTYPEID_StartMenu: windows_core::GUID = windows_core::GUID::from_u128(0xef87b4cb_f2ce_4785_8658_4ca6c63e38c6);
pub const FOLDERTYPEID_StorageProviderDocuments: windows_core::GUID = windows_core::GUID::from_u128(0xdd61bd66_70e8_48dd_9655_65c5e1aac2d1);
pub const FOLDERTYPEID_StorageProviderGeneric: windows_core::GUID = windows_core::GUID::from_u128(0x4f01ebc5_2385_41f2_a28e_2c5c91fb56e0);
pub const FOLDERTYPEID_StorageProviderMusic: windows_core::GUID = windows_core::GUID::from_u128(0x672ecd7e_af04_4399_875c_0290845b6247);
pub const FOLDERTYPEID_StorageProviderPictures: windows_core::GUID = windows_core::GUID::from_u128(0x71d642a9_f2b1_42cd_ad92_eb9300c7cc0a);
pub const FOLDERTYPEID_StorageProviderVideos: windows_core::GUID = windows_core::GUID::from_u128(0x51294da1_d7b1_485b_9e9a_17cffe33e187);
pub const FOLDERTYPEID_UserFiles: windows_core::GUID = windows_core::GUID::from_u128(0xcd0fc69b_71e2_46e5_9690_5bcd9f57aab3);
pub const FOLDERTYPEID_UsersLibraries: windows_core::GUID = windows_core::GUID::from_u128(0xc4d98f09_6124_4fe0_9942_826416082da9);
pub const FOLDERTYPEID_Videos: windows_core::GUID = windows_core::GUID::from_u128(0x5fa96407_7e77_483c_ac93_691d05850de8);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct FOLDERVIEWMODE(pub i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct FOLDERVIEWOPTIONS(pub i32);
impl FOLDERVIEWOPTIONS {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl core::ops::BitOr for FOLDERVIEWOPTIONS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl core::ops::BitAnd for FOLDERVIEWOPTIONS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl core::ops::BitOrAssign for FOLDERVIEWOPTIONS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl core::ops::BitAndAssign for FOLDERVIEWOPTIONS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl core::ops::Not for FOLDERVIEWOPTIONS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct FOLDER_ENUM_MODE(pub i32);
pub const FOS_ALLNONSTORAGEITEMS: FILEOPENDIALOGOPTIONS = FILEOPENDIALOGOPTIONS(128u32);
pub const FOS_ALLOWMULTISELECT: FILEOPENDIALOGOPTIONS = FILEOPENDIALOGOPTIONS(512u32);
pub const FOS_CREATEPROMPT: FILEOPENDIALOGOPTIONS = FILEOPENDIALOGOPTIONS(8192u32);
pub const FOS_DEFAULTNOMINIMODE: FILEOPENDIALOGOPTIONS = FILEOPENDIALOGOPTIONS(536870912u32);
pub const FOS_DONTADDTORECENT: FILEOPENDIALOGOPTIONS = FILEOPENDIALOGOPTIONS(33554432u32);
pub const FOS_FILEMUSTEXIST: FILEOPENDIALOGOPTIONS = FILEOPENDIALOGOPTIONS(4096u32);
pub const FOS_FORCEFILESYSTEM: FILEOPENDIALOGOPTIONS = FILEOPENDIALOGOPTIONS(64u32);
pub const FOS_FORCEPREVIEWPANEON: FILEOPENDIALOGOPTIONS = FILEOPENDIALOGOPTIONS(1073741824u32);
pub const FOS_FORCESHOWHIDDEN: FILEOPENDIALOGOPTIONS = FILEOPENDIALOGOPTIONS(268435456u32);
pub const FOS_HIDEMRUPLACES: FILEOPENDIALOGOPTIONS = FILEOPENDIALOGOPTIONS(131072u32);
pub const FOS_HIDEPINNEDPLACES: FILEOPENDIALOGOPTIONS = FILEOPENDIALOGOPTIONS(262144u32);
pub const FOS_NOCHANGEDIR: FILEOPENDIALOGOPTIONS = FILEOPENDIALOGOPTIONS(8u32);
pub const FOS_NODEREFERENCELINKS: FILEOPENDIALOGOPTIONS = FILEOPENDIALOGOPTIONS(1048576u32);
pub const FOS_NOREADONLYRETURN: FILEOPENDIALOGOPTIONS = FILEOPENDIALOGOPTIONS(32768u32);
pub const FOS_NOTESTFILECREATE: FILEOPENDIALOGOPTIONS = FILEOPENDIALOGOPTIONS(65536u32);
pub const FOS_NOVALIDATE: FILEOPENDIALOGOPTIONS = FILEOPENDIALOGOPTIONS(256u32);
pub const FOS_OKBUTTONNEEDSINTERACTION: FILEOPENDIALOGOPTIONS = FILEOPENDIALOGOPTIONS(2097152u32);
pub const FOS_OVERWRITEPROMPT: FILEOPENDIALOGOPTIONS = FILEOPENDIALOGOPTIONS(2u32);
pub const FOS_PATHMUSTEXIST: FILEOPENDIALOGOPTIONS = FILEOPENDIALOGOPTIONS(2048u32);
pub const FOS_PICKFOLDERS: FILEOPENDIALOGOPTIONS = FILEOPENDIALOGOPTIONS(32u32);
pub const FOS_SHAREAWARE: FILEOPENDIALOGOPTIONS = FILEOPENDIALOGOPTIONS(16384u32);
pub const FOS_STRICTFILETYPES: FILEOPENDIALOGOPTIONS = FILEOPENDIALOGOPTIONS(4u32);
pub const FOS_SUPPORTSTREAMABLEITEMS: FILEOPENDIALOGOPTIONS = FILEOPENDIALOGOPTIONS(2147483648u32);
pub const FO_COPY: u32 = 2u32;
pub const FO_DELETE: u32 = 3u32;
pub const FO_MOVE: u32 = 1u32;
pub const FO_RENAME: u32 = 4u32;
pub const FP_ABOVE: FLYOUT_PLACEMENT = FLYOUT_PLACEMENT(1i32);
pub const FP_BELOW: FLYOUT_PLACEMENT = FLYOUT_PLACEMENT(2i32);
pub const FP_DEFAULT: FLYOUT_PLACEMENT = FLYOUT_PLACEMENT(0i32);
pub const FP_LEFT: FLYOUT_PLACEMENT = FLYOUT_PLACEMENT(3i32);
pub const FP_RIGHT: FLYOUT_PLACEMENT = FLYOUT_PLACEMENT(4i32);
pub const FSCopyHandler: windows_core::GUID = windows_core::GUID::from_u128(0xd197380a_0a79_4dc8_a033_ed882c2fa14b);
pub const FTA_AlwaysUnsafe: FILETYPEATTRIBUTEFLAGS = FILETYPEATTRIBUTEFLAGS(131072i32);
pub const FTA_AlwaysUseDirectInvoke: FILETYPEATTRIBUTEFLAGS = FILETYPEATTRIBUTEFLAGS(4194304i32);
pub const FTA_Exclude: FILETYPEATTRIBUTEFLAGS = FILETYPEATTRIBUTEFLAGS(1i32);
pub const FTA_HasExtension: FILETYPEATTRIBUTEFLAGS = FILETYPEATTRIBUTEFLAGS(4i32);
pub const FTA_NoDDE: FILETYPEATTRIBUTEFLAGS = FILETYPEATTRIBUTEFLAGS(8192i32);
pub const FTA_NoEdit: FILETYPEATTRIBUTEFLAGS = FILETYPEATTRIBUTEFLAGS(8i32);
pub const FTA_NoEditDesc: FILETYPEATTRIBUTEFLAGS = FILETYPEATTRIBUTEFLAGS(256i32);
pub const FTA_NoEditDflt: FILETYPEATTRIBUTEFLAGS = FILETYPEATTRIBUTEFLAGS(1024i32);
pub const FTA_NoEditIcon: FILETYPEATTRIBUTEFLAGS = FILETYPEATTRIBUTEFLAGS(512i32);
pub const FTA_NoEditMIME: FILETYPEATTRIBUTEFLAGS = FILETYPEATTRIBUTEFLAGS(32768i32);
pub const FTA_NoEditVerb: FILETYPEATTRIBUTEFLAGS = FILETYPEATTRIBUTEFLAGS(64i32);
pub const FTA_NoEditVerbCmd: FILETYPEATTRIBUTEFLAGS = FILETYPEATTRIBUTEFLAGS(2048i32);
pub const FTA_NoEditVerbExe: FILETYPEATTRIBUTEFLAGS = FILETYPEATTRIBUTEFLAGS(4096i32);
pub const FTA_NoNewVerb: FILETYPEATTRIBUTEFLAGS = FILETYPEATTRIBUTEFLAGS(32i32);
pub const FTA_NoRecentDocs: FILETYPEATTRIBUTEFLAGS = FILETYPEATTRIBUTEFLAGS(1048576i32);
pub const FTA_NoRemove: FILETYPEATTRIBUTEFLAGS = FILETYPEATTRIBUTEFLAGS(16i32);
pub const FTA_NoRemoveVerb: FILETYPEATTRIBUTEFLAGS = FILETYPEATTRIBUTEFLAGS(128i32);
pub const FTA_None: FILETYPEATTRIBUTEFLAGS = FILETYPEATTRIBUTEFLAGS(0i32);
pub const FTA_OpenIsSafe: FILETYPEATTRIBUTEFLAGS = FILETYPEATTRIBUTEFLAGS(65536i32);
pub const FTA_SafeForElevation: FILETYPEATTRIBUTEFLAGS = FILETYPEATTRIBUTEFLAGS(2097152i32);
pub const FTA_Show: FILETYPEATTRIBUTEFLAGS = FILETYPEATTRIBUTEFLAGS(2i32);
pub const FUT_EDITING: FILE_USAGE_TYPE = FILE_USAGE_TYPE(1i32);
pub const FUT_GENERIC: FILE_USAGE_TYPE = FILE_USAGE_TYPE(2i32);
pub const FUT_PLAYING: FILE_USAGE_TYPE = FILE_USAGE_TYPE(0i32);
pub const FVM_AUTO: FOLDERVIEWMODE = FOLDERVIEWMODE(-1i32);
pub const FVM_CONTENT: FOLDERVIEWMODE = FOLDERVIEWMODE(8i32);
pub const FVM_DETAILS: FOLDERVIEWMODE = FOLDERVIEWMODE(4i32);
pub const FVM_FIRST: FOLDERVIEWMODE = FOLDERVIEWMODE(1i32);
pub const FVM_ICON: FOLDERVIEWMODE = FOLDERVIEWMODE(1i32);
pub const FVM_LAST: FOLDERVIEWMODE = FOLDERVIEWMODE(8i32);
pub const FVM_LIST: FOLDERVIEWMODE = FOLDERVIEWMODE(3i32);
pub const FVM_SMALLICON: FOLDERVIEWMODE = FOLDERVIEWMODE(2i32);
pub const FVM_THUMBNAIL: FOLDERVIEWMODE = FOLDERVIEWMODE(5i32);
pub const FVM_THUMBSTRIP: FOLDERVIEWMODE = FOLDERVIEWMODE(7i32);
pub const FVM_TILE: FOLDERVIEWMODE = FOLDERVIEWMODE(6i32);
pub const FVO_CUSTOMORDERING: FOLDERVIEWOPTIONS = FOLDERVIEWOPTIONS(4i32);
pub const FVO_CUSTOMPOSITION: FOLDERVIEWOPTIONS = FOLDERVIEWOPTIONS(2i32);
pub const FVO_DEFAULT: FOLDERVIEWOPTIONS = FOLDERVIEWOPTIONS(0i32);
pub const FVO_NOANIMATIONS: FOLDERVIEWOPTIONS = FOLDERVIEWOPTIONS(16i32);
pub const FVO_NOSCROLLTIPS: FOLDERVIEWOPTIONS = FOLDERVIEWOPTIONS(32i32);
pub const FVO_SUPPORTHYPERLINKS: FOLDERVIEWOPTIONS = FOLDERVIEWOPTIONS(8i32);
pub const FVO_VISTALAYOUT: FOLDERVIEWOPTIONS = FOLDERVIEWOPTIONS(1i32);
pub const FVSIF_CANVIEWIT: u32 = 1073741824u32;
pub const FVSIF_NEWFAILED: u32 = 134217728u32;
pub const FVSIF_NEWFILE: u32 = 2147483648u32;
pub const FVSIF_PINNED: u32 = 2u32;
pub const FVSIF_RECT: u32 = 1u32;
pub const FVST_EMPTYTEXT: FVTEXTTYPE = FVTEXTTYPE(0i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct FVTEXTTYPE(pub i32);
pub const FWF_ABBREVIATEDNAMES: FOLDERFLAGS = FOLDERFLAGS(2i32);
pub const FWF_ALIGNLEFT: FOLDERFLAGS = FOLDERFLAGS(2048i32);
pub const FWF_ALLOWRTLREADING: FOLDERFLAGS = FOLDERFLAGS(-2147483648i32);
pub const FWF_AUTOARRANGE: FOLDERFLAGS = FOLDERFLAGS(1i32);
pub const FWF_AUTOCHECKSELECT: FOLDERFLAGS = FOLDERFLAGS(134217728i32);
pub const FWF_BESTFITWINDOW: FOLDERFLAGS = FOLDERFLAGS(16i32);
pub const FWF_CHECKSELECT: FOLDERFLAGS = FOLDERFLAGS(262144i32);
pub const FWF_DESKTOP: FOLDERFLAGS = FOLDERFLAGS(32i32);
pub const FWF_EXTENDEDTILES: FOLDERFLAGS = FOLDERFLAGS(33554432i32);
pub const FWF_FULLROWSELECT: FOLDERFLAGS = FOLDERFLAGS(2097152i32);
pub const FWF_HIDEFILENAMES: FOLDERFLAGS = FOLDERFLAGS(131072i32);
pub const FWF_NOBROWSERVIEWSTATE: FOLDERFLAGS = FOLDERFLAGS(268435456i32);
pub const FWF_NOCLIENTEDGE: FOLDERFLAGS = FOLDERFLAGS(512i32);
pub const FWF_NOCOLUMNHEADER: FOLDERFLAGS = FOLDERFLAGS(8388608i32);
pub const FWF_NOENUMREFRESH: FOLDERFLAGS = FOLDERFLAGS(524288i32);
pub const FWF_NOFILTERS: FOLDERFLAGS = FOLDERFLAGS(4194304i32);
pub const FWF_NOGROUPING: FOLDERFLAGS = FOLDERFLAGS(1048576i32);
pub const FWF_NOHEADERINALLVIEWS: FOLDERFLAGS = FOLDERFLAGS(16777216i32);
pub const FWF_NOICONS: FOLDERFLAGS = FOLDERFLAGS(4096i32);
pub const FWF_NONE: FOLDERFLAGS = FOLDERFLAGS(0i32);
pub const FWF_NOSCROLL: FOLDERFLAGS = FOLDERFLAGS(1024i32);
pub const FWF_NOSUBFOLDERS: FOLDERFLAGS = FOLDERFLAGS(128i32);
pub const FWF_NOVISIBLE: FOLDERFLAGS = FOLDERFLAGS(16384i32);
pub const FWF_NOWEBVIEW: FOLDERFLAGS = FOLDERFLAGS(65536i32);
pub const FWF_OWNERDATA: FOLDERFLAGS = FOLDERFLAGS(8i32);
pub const FWF_SHOWSELALWAYS: FOLDERFLAGS = FOLDERFLAGS(8192i32);
pub const FWF_SINGLECLICKACTIVATE: FOLDERFLAGS = FOLDERFLAGS(32768i32);
pub const FWF_SINGLESEL: FOLDERFLAGS = FOLDERFLAGS(64i32);
pub const FWF_SNAPTOGRID: FOLDERFLAGS = FOLDERFLAGS(4i32);
pub const FWF_SUBSETGROUPS: FOLDERFLAGS = FOLDERFLAGS(536870912i32);
pub const FWF_TRANSPARENT: FOLDERFLAGS = FOLDERFLAGS(256i32);
pub const FWF_TRICHECKSELECT: FOLDERFLAGS = FOLDERFLAGS(67108864i32);
pub const FWF_USESEARCHFOLDER: FOLDERFLAGS = FOLDERFLAGS(1073741824i32);
pub const FileOpenDialog: windows_core::GUID = windows_core::GUID::from_u128(0xdc1c5a9c_e88a_4dde_a5a1_60f82a20aef7);
pub const FileOperation: windows_core::GUID = windows_core::GUID::from_u128(0x3ad05575_8857_4850_9277_11b85bdb8e09);
pub const FileSaveDialog: windows_core::GUID = windows_core::GUID::from_u128(0xc0b4e2f3_ba21_4773_8dba_335ec946eb8b);
pub const FileSearchBand: windows_core::GUID = windows_core::GUID::from_u128(0xc4ee31f3_4768_11d2_be5c_00a0c9a83da1);
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::define_interface!(Folder, Folder_Vtbl, 0xbbcbde60_c3ff_11ce_8350_444553540000);
#[cfg(feature = "Win32_System_Com")]
impl core::ops::Deref for Folder {
    type Target = super::super::System::Com::IDispatch;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::interface_hierarchy!(Folder, windows_core::IUnknown, super::super::System::Com::IDispatch);
#[cfg(feature = "Win32_System_Com")]
impl Folder {
    pub unsafe fn Title(&self) -> windows_core::Result<windows_core::BSTR> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).Title)(windows_core::Interface::as_raw(self), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub unsafe fn Application(&self) -> windows_core::Result<super::super::System::Com::IDispatch> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).Application)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn Parent(&self) -> windows_core::Result<super::super::System::Com::IDispatch> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).Parent)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn ParentFolder(&self) -> windows_core::Result<Folder> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).ParentFolder)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn Items(&self) -> windows_core::Result<FolderItems> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).Items)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn ParseName(&self, bname: &windows_core::BSTR) -> windows_core::Result<FolderItem> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).ParseName)(windows_core::Interface::as_raw(self), core::mem::transmute_copy(bname), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(all(feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub unsafe fn NewFolder(&self, bname: &windows_core::BSTR, voptions: &super::super::System::Variant::VARIANT) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).NewFolder)(windows_core::Interface::as_raw(self), core::mem::transmute_copy(bname), core::mem::transmute_copy(voptions)).ok() }
    }
    #[cfg(all(feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub unsafe fn MoveHere(&self, vitem: &super::super::System::Variant::VARIANT, voptions: &super::super::System::Variant::VARIANT) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).MoveHere)(windows_core::Interface::as_raw(self), core::mem::transmute_copy(vitem), core::mem::transmute_copy(voptions)).ok() }
    }
    #[cfg(all(feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub unsafe fn CopyHere(&self, vitem: &super::super::System::Variant::VARIANT, voptions: &super::super::System::Variant::VARIANT) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).CopyHere)(windows_core::Interface::as_raw(self), core::mem::transmute_copy(vitem), core::mem::transmute_copy(voptions)).ok() }
    }
    #[cfg(all(feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub unsafe fn GetDetailsOf(&self, vitem: &super::super::System::Variant::VARIANT, icolumn: i32) -> windows_core::Result<windows_core::BSTR> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetDetailsOf)(windows_core::Interface::as_raw(self), core::mem::transmute_copy(vitem), icolumn, &mut result__).map(|| core::mem::transmute(result__))
        }
    }
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct Folder_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
    pub Title: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub Application: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub Parent: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub ParentFolder: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub Items: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub ParseName: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(all(feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub NewFolder: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, super::super::System::Variant::VARIANT) -> windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_System_Ole", feature = "Win32_System_Variant")))]
    NewFolder: usize,
    #[cfg(all(feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub MoveHere: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::System::Variant::VARIANT, super::super::System::Variant::VARIANT) -> windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_System_Ole", feature = "Win32_System_Variant")))]
    MoveHere: usize,
    #[cfg(all(feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub CopyHere: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::System::Variant::VARIANT, super::super::System::Variant::VARIANT) -> windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_System_Ole", feature = "Win32_System_Variant")))]
    CopyHere: usize,
    #[cfg(all(feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub GetDetailsOf: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::System::Variant::VARIANT, i32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_System_Ole", feature = "Win32_System_Variant")))]
    GetDetailsOf: usize,
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
pub trait Folder_Impl: super::super::System::Com::IDispatch_Impl {
    fn Title(&self) -> windows_core::Result<windows_core::BSTR>;
    fn Application(&self) -> windows_core::Result<super::super::System::Com::IDispatch>;
    fn Parent(&self) -> windows_core::Result<super::super::System::Com::IDispatch>;
    fn ParentFolder(&self) -> windows_core::Result<Folder>;
    fn Items(&self) -> windows_core::Result<FolderItems>;
    fn ParseName(&self, bname: &windows_core::BSTR) -> windows_core::Result<FolderItem>;
    fn NewFolder(&self, bname: &windows_core::BSTR, voptions: &super::super::System::Variant::VARIANT) -> windows_core::Result<()>;
    fn MoveHere(&self, vitem: &super::super::System::Variant::VARIANT, voptions: &super::super::System::Variant::VARIANT) -> windows_core::Result<()>;
    fn CopyHere(&self, vitem: &super::super::System::Variant::VARIANT, voptions: &super::super::System::Variant::VARIANT) -> windows_core::Result<()>;
    fn GetDetailsOf(&self, vitem: &super::super::System::Variant::VARIANT, icolumn: i32) -> windows_core::Result<windows_core::BSTR>;
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl Folder_Vtbl {
    pub const fn new<Identity: Folder_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn Title<Identity: Folder_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbs: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match Folder_Impl::Title(this) {
                    Ok(ok__) => {
                        pbs.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn Application<Identity: Folder_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ppid: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match Folder_Impl::Application(this) {
                    Ok(ok__) => {
                        ppid.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn Parent<Identity: Folder_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ppid: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match Folder_Impl::Parent(this) {
                    Ok(ok__) => {
                        ppid.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn ParentFolder<Identity: Folder_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ppsf: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match Folder_Impl::ParentFolder(this) {
                    Ok(ok__) => {
                        ppsf.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn Items<Identity: Folder_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ppid: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match Folder_Impl::Items(this) {
                    Ok(ok__) => {
                        ppid.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn ParseName<Identity: Folder_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, bname: *mut core::ffi::c_void, ppid: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match Folder_Impl::ParseName(this, core::mem::transmute(&bname)) {
                    Ok(ok__) => {
                        ppid.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn NewFolder<Identity: Folder_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, bname: *mut core::ffi::c_void, voptions: super::super::System::Variant::VARIANT) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                Folder_Impl::NewFolder(this, core::mem::transmute(&bname), core::mem::transmute(&voptions)).into()
            }
        }
        unsafe extern "system" fn MoveHere<Identity: Folder_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, vitem: super::super::System::Variant::VARIANT, voptions: super::super::System::Variant::VARIANT) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                Folder_Impl::MoveHere(this, core::mem::transmute(&vitem), core::mem::transmute(&voptions)).into()
            }
        }
        unsafe extern "system" fn CopyHere<Identity: Folder_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, vitem: super::super::System::Variant::VARIANT, voptions: super::super::System::Variant::VARIANT) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                Folder_Impl::CopyHere(this, core::mem::transmute(&vitem), core::mem::transmute(&voptions)).into()
            }
        }
        unsafe extern "system" fn GetDetailsOf<Identity: Folder_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, vitem: super::super::System::Variant::VARIANT, icolumn: i32, pbs: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match Folder_Impl::GetDetailsOf(this, core::mem::transmute(&vitem), core::mem::transmute_copy(&icolumn)) {
                    Ok(ok__) => {
                        pbs.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self {
            base__: super::super::System::Com::IDispatch_Vtbl::new::<Identity, OFFSET>(),
            Title: Title::<Identity, OFFSET>,
            Application: Application::<Identity, OFFSET>,
            Parent: Parent::<Identity, OFFSET>,
            ParentFolder: ParentFolder::<Identity, OFFSET>,
            Items: Items::<Identity, OFFSET>,
            ParseName: ParseName::<Identity, OFFSET>,
            NewFolder: NewFolder::<Identity, OFFSET>,
            MoveHere: MoveHere::<Identity, OFFSET>,
            CopyHere: CopyHere::<Identity, OFFSET>,
            GetDetailsOf: GetDetailsOf::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<Folder as windows_core::Interface>::IID || iid == &<super::super::System::Com::IDispatch as windows_core::Interface>::IID
    }
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl windows_core::RuntimeName for Folder {}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::define_interface!(Folder2, Folder2_Vtbl, 0xf0d2d8ef_3890_11d2_bf8b_00c04fb93661);
#[cfg(feature = "Win32_System_Com")]
impl core::ops::Deref for Folder2 {
    type Target = Folder;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::interface_hierarchy!(Folder2, windows_core::IUnknown, super::super::System::Com::IDispatch, Folder);
#[cfg(feature = "Win32_System_Com")]
impl Folder2 {
    pub unsafe fn Self_(&self) -> windows_core::Result<FolderItem> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).Self_)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn OfflineStatus(&self) -> windows_core::Result<i32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).OfflineStatus)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn Synchronize(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).Synchronize)(windows_core::Interface::as_raw(self)).ok() }
    }
    pub unsafe fn HaveToShowWebViewBarricade(&self) -> windows_core::Result<super::super::Foundation::VARIANT_BOOL> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).HaveToShowWebViewBarricade)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn DismissedWebViewBarricade(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).DismissedWebViewBarricade)(windows_core::Interface::as_raw(self)).ok() }
    }
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct Folder2_Vtbl {
    pub base__: Folder_Vtbl,
    pub Self_: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub OfflineStatus: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub Synchronize: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub HaveToShowWebViewBarricade: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Foundation::VARIANT_BOOL) -> windows_core::HRESULT,
    pub DismissedWebViewBarricade: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
pub trait Folder2_Impl: Folder_Impl {
    fn Self_(&self) -> windows_core::Result<FolderItem>;
    fn OfflineStatus(&self) -> windows_core::Result<i32>;
    fn Synchronize(&self) -> windows_core::Result<()>;
    fn HaveToShowWebViewBarricade(&self) -> windows_core::Result<super::super::Foundation::VARIANT_BOOL>;
    fn DismissedWebViewBarricade(&self) -> windows_core::Result<()>;
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl Folder2_Vtbl {
    pub const fn new<Identity: Folder2_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn Self_<Identity: Folder2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ppfi: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match Folder2_Impl::Self_(this) {
                    Ok(ok__) => {
                        ppfi.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn OfflineStatus<Identity: Folder2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pul: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match Folder2_Impl::OfflineStatus(this) {
                    Ok(ok__) => {
                        pul.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn Synchronize<Identity: Folder2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                Folder2_Impl::Synchronize(this).into()
            }
        }
        unsafe extern "system" fn HaveToShowWebViewBarricade<Identity: Folder2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbhavetoshowwebviewbarricade: *mut super::super::Foundation::VARIANT_BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match Folder2_Impl::HaveToShowWebViewBarricade(this) {
                    Ok(ok__) => {
                        pbhavetoshowwebviewbarricade.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn DismissedWebViewBarricade<Identity: Folder2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                Folder2_Impl::DismissedWebViewBarricade(this).into()
            }
        }
        Self {
            base__: Folder_Vtbl::new::<Identity, OFFSET>(),
            Self_: Self_::<Identity, OFFSET>,
            OfflineStatus: OfflineStatus::<Identity, OFFSET>,
            Synchronize: Synchronize::<Identity, OFFSET>,
            HaveToShowWebViewBarricade: HaveToShowWebViewBarricade::<Identity, OFFSET>,
            DismissedWebViewBarricade: DismissedWebViewBarricade::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<Folder2 as windows_core::Interface>::IID || iid == &<super::super::System::Com::IDispatch as windows_core::Interface>::IID || iid == &<Folder as windows_core::Interface>::IID
    }
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl windows_core::RuntimeName for Folder2 {}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::define_interface!(Folder3, Folder3_Vtbl, 0xa7ae5f64_c4d7_4d7f_9307_4d24ee54b841);
#[cfg(feature = "Win32_System_Com")]
impl core::ops::Deref for Folder3 {
    type Target = Folder2;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::interface_hierarchy!(Folder3, windows_core::IUnknown, super::super::System::Com::IDispatch, Folder, Folder2);
#[cfg(feature = "Win32_System_Com")]
impl Folder3 {
    pub unsafe fn ShowWebViewBarricade(&self) -> windows_core::Result<super::super::Foundation::VARIANT_BOOL> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).ShowWebViewBarricade)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetShowWebViewBarricade(&self, bshowwebviewbarricade: super::super::Foundation::VARIANT_BOOL) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetShowWebViewBarricade)(windows_core::Interface::as_raw(self), bshowwebviewbarricade).ok() }
    }
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct Folder3_Vtbl {
    pub base__: Folder2_Vtbl,
    pub ShowWebViewBarricade: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Foundation::VARIANT_BOOL) -> windows_core::HRESULT,
    pub SetShowWebViewBarricade: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::VARIANT_BOOL) -> windows_core::HRESULT,
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
pub trait Folder3_Impl: Folder2_Impl {
    fn ShowWebViewBarricade(&self) -> windows_core::Result<super::super::Foundation::VARIANT_BOOL>;
    fn SetShowWebViewBarricade(&self, bshowwebviewbarricade: super::super::Foundation::VARIANT_BOOL) -> windows_core::Result<()>;
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl Folder3_Vtbl {
    pub const fn new<Identity: Folder3_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn ShowWebViewBarricade<Identity: Folder3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbshowwebviewbarricade: *mut super::super::Foundation::VARIANT_BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match Folder3_Impl::ShowWebViewBarricade(this) {
                    Ok(ok__) => {
                        pbshowwebviewbarricade.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetShowWebViewBarricade<Identity: Folder3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, bshowwebviewbarricade: super::super::Foundation::VARIANT_BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                Folder3_Impl::SetShowWebViewBarricade(this, core::mem::transmute_copy(&bshowwebviewbarricade)).into()
            }
        }
        Self {
            base__: Folder2_Vtbl::new::<Identity, OFFSET>(),
            ShowWebViewBarricade: ShowWebViewBarricade::<Identity, OFFSET>,
            SetShowWebViewBarricade: SetShowWebViewBarricade::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<Folder3 as windows_core::Interface>::IID || iid == &<super::super::System::Com::IDispatch as windows_core::Interface>::IID || iid == &<Folder as windows_core::Interface>::IID || iid == &<Folder2 as windows_core::Interface>::IID
    }
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl windows_core::RuntimeName for Folder3 {}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::define_interface!(FolderItem, FolderItem_Vtbl, 0xfac32c80_cbe4_11ce_8350_444553540000);
#[cfg(feature = "Win32_System_Com")]
impl core::ops::Deref for FolderItem {
    type Target = super::super::System::Com::IDispatch;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::interface_hierarchy!(FolderItem, windows_core::IUnknown, super::super::System::Com::IDispatch);
#[cfg(feature = "Win32_System_Com")]
impl FolderItem {
    pub unsafe fn Application(&self) -> windows_core::Result<super::super::System::Com::IDispatch> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).Application)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn Parent(&self) -> windows_core::Result<super::super::System::Com::IDispatch> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).Parent)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn Name(&self) -> windows_core::Result<windows_core::BSTR> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).Name)(windows_core::Interface::as_raw(self), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub unsafe fn SetName(&self, bs: &windows_core::BSTR) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetName)(windows_core::Interface::as_raw(self), core::mem::transmute_copy(bs)).ok() }
    }
    pub unsafe fn Path(&self) -> windows_core::Result<windows_core::BSTR> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).Path)(windows_core::Interface::as_raw(self), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub unsafe fn GetLink(&self) -> windows_core::Result<super::super::System::Com::IDispatch> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetLink)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn GetFolder(&self) -> windows_core::Result<super::super::System::Com::IDispatch> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetFolder)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn IsLink(&self) -> windows_core::Result<super::super::Foundation::VARIANT_BOOL> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).IsLink)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn IsFolder(&self) -> windows_core::Result<super::super::Foundation::VARIANT_BOOL> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).IsFolder)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn IsFileSystem(&self) -> windows_core::Result<super::super::Foundation::VARIANT_BOOL> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).IsFileSystem)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn IsBrowsable(&self) -> windows_core::Result<super::super::Foundation::VARIANT_BOOL> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).IsBrowsable)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn ModifyDate(&self) -> windows_core::Result<f64> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).ModifyDate)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetModifyDate(&self, dt: f64) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetModifyDate)(windows_core::Interface::as_raw(self), dt).ok() }
    }
    pub unsafe fn Size(&self) -> windows_core::Result<i32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).Size)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn Type(&self) -> windows_core::Result<windows_core::BSTR> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).Type)(windows_core::Interface::as_raw(self), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub unsafe fn Verbs(&self) -> windows_core::Result<FolderItemVerbs> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).Verbs)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(all(feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub unsafe fn InvokeVerb(&self, vverb: &super::super::System::Variant::VARIANT) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).InvokeVerb)(windows_core::Interface::as_raw(self), core::mem::transmute_copy(vverb)).ok() }
    }
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct FolderItem_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
    pub Application: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub Parent: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub Name: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetName: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub Path: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetLink: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetFolder: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub IsLink: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Foundation::VARIANT_BOOL) -> windows_core::HRESULT,
    pub IsFolder: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Foundation::VARIANT_BOOL) -> windows_core::HRESULT,
    pub IsFileSystem: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Foundation::VARIANT_BOOL) -> windows_core::HRESULT,
    pub IsBrowsable: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Foundation::VARIANT_BOOL) -> windows_core::HRESULT,
    pub ModifyDate: unsafe extern "system" fn(*mut core::ffi::c_void, *mut f64) -> windows_core::HRESULT,
    pub SetModifyDate: unsafe extern "system" fn(*mut core::ffi::c_void, f64) -> windows_core::HRESULT,
    pub Size: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub Type: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub Verbs: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(all(feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub InvokeVerb: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::System::Variant::VARIANT) -> windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_System_Ole", feature = "Win32_System_Variant")))]
    InvokeVerb: usize,
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
pub trait FolderItem_Impl: super::super::System::Com::IDispatch_Impl {
    fn Application(&self) -> windows_core::Result<super::super::System::Com::IDispatch>;
    fn Parent(&self) -> windows_core::Result<super::super::System::Com::IDispatch>;
    fn Name(&self) -> windows_core::Result<windows_core::BSTR>;
    fn SetName(&self, bs: &windows_core::BSTR) -> windows_core::Result<()>;
    fn Path(&self) -> windows_core::Result<windows_core::BSTR>;
    fn GetLink(&self) -> windows_core::Result<super::super::System::Com::IDispatch>;
    fn GetFolder(&self) -> windows_core::Result<super::super::System::Com::IDispatch>;
    fn IsLink(&self) -> windows_core::Result<super::super::Foundation::VARIANT_BOOL>;
    fn IsFolder(&self) -> windows_core::Result<super::super::Foundation::VARIANT_BOOL>;
    fn IsFileSystem(&self) -> windows_core::Result<super::super::Foundation::VARIANT_BOOL>;
    fn IsBrowsable(&self) -> windows_core::Result<super::super::Foundation::VARIANT_BOOL>;
    fn ModifyDate(&self) -> windows_core::Result<f64>;
    fn SetModifyDate(&self, dt: f64) -> windows_core::Result<()>;
    fn Size(&self) -> windows_core::Result<i32>;
    fn Type(&self) -> windows_core::Result<windows_core::BSTR>;
    fn Verbs(&self) -> windows_core::Result<FolderItemVerbs>;
    fn InvokeVerb(&self, vverb: &super::super::System::Variant::VARIANT) -> windows_core::Result<()>;
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl FolderItem_Vtbl {
    pub const fn new<Identity: FolderItem_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn Application<Identity: FolderItem_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ppid: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match FolderItem_Impl::Application(this) {
                    Ok(ok__) => {
                        ppid.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn Parent<Identity: FolderItem_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ppid: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match FolderItem_Impl::Parent(this) {
                    Ok(ok__) => {
                        ppid.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn Name<Identity: FolderItem_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbs: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match FolderItem_Impl::Name(this) {
                    Ok(ok__) => {
                        pbs.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetName<Identity: FolderItem_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, bs: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                FolderItem_Impl::SetName(this, core::mem::transmute(&bs)).into()
            }
        }
        unsafe extern "system" fn Path<Identity: FolderItem_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbs: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match FolderItem_Impl::Path(this) {
                    Ok(ok__) => {
                        pbs.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetLink<Identity: FolderItem_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ppid: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match FolderItem_Impl::GetLink(this) {
                    Ok(ok__) => {
                        ppid.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetFolder<Identity: FolderItem_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ppid: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match FolderItem_Impl::GetFolder(this) {
                    Ok(ok__) => {
                        ppid.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn IsLink<Identity: FolderItem_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pb: *mut super::super::Foundation::VARIANT_BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match FolderItem_Impl::IsLink(this) {
                    Ok(ok__) => {
                        pb.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn IsFolder<Identity: FolderItem_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pb: *mut super::super::Foundation::VARIANT_BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match FolderItem_Impl::IsFolder(this) {
                    Ok(ok__) => {
                        pb.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn IsFileSystem<Identity: FolderItem_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pb: *mut super::super::Foundation::VARIANT_BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match FolderItem_Impl::IsFileSystem(this) {
                    Ok(ok__) => {
                        pb.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn IsBrowsable<Identity: FolderItem_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pb: *mut super::super::Foundation::VARIANT_BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match FolderItem_Impl::IsBrowsable(this) {
                    Ok(ok__) => {
                        pb.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn ModifyDate<Identity: FolderItem_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pdt: *mut f64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match FolderItem_Impl::ModifyDate(this) {
                    Ok(ok__) => {
                        pdt.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetModifyDate<Identity: FolderItem_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dt: f64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                FolderItem_Impl::SetModifyDate(this, core::mem::transmute_copy(&dt)).into()
            }
        }
        unsafe extern "system" fn Size<Identity: FolderItem_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pul: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match FolderItem_Impl::Size(this) {
                    Ok(ok__) => {
                        pul.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn Type<Identity: FolderItem_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbs: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match FolderItem_Impl::Type(this) {
                    Ok(ok__) => {
                        pbs.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn Verbs<Identity: FolderItem_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ppfic: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match FolderItem_Impl::Verbs(this) {
                    Ok(ok__) => {
                        ppfic.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn InvokeVerb<Identity: FolderItem_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, vverb: super::super::System::Variant::VARIANT) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                FolderItem_Impl::InvokeVerb(this, core::mem::transmute(&vverb)).into()
            }
        }
        Self {
            base__: super::super::System::Com::IDispatch_Vtbl::new::<Identity, OFFSET>(),
            Application: Application::<Identity, OFFSET>,
            Parent: Parent::<Identity, OFFSET>,
            Name: Name::<Identity, OFFSET>,
            SetName: SetName::<Identity, OFFSET>,
            Path: Path::<Identity, OFFSET>,
            GetLink: GetLink::<Identity, OFFSET>,
            GetFolder: GetFolder::<Identity, OFFSET>,
            IsLink: IsLink::<Identity, OFFSET>,
            IsFolder: IsFolder::<Identity, OFFSET>,
            IsFileSystem: IsFileSystem::<Identity, OFFSET>,
            IsBrowsable: IsBrowsable::<Identity, OFFSET>,
            ModifyDate: ModifyDate::<Identity, OFFSET>,
            SetModifyDate: SetModifyDate::<Identity, OFFSET>,
            Size: Size::<Identity, OFFSET>,
            Type: Type::<Identity, OFFSET>,
            Verbs: Verbs::<Identity, OFFSET>,
            InvokeVerb: InvokeVerb::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<FolderItem as windows_core::Interface>::IID || iid == &<super::super::System::Com::IDispatch as windows_core::Interface>::IID
    }
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl windows_core::RuntimeName for FolderItem {}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::define_interface!(FolderItem2, FolderItem2_Vtbl, 0xedc817aa_92b8_11d1_b075_00c04fc33aa5);
#[cfg(feature = "Win32_System_Com")]
impl core::ops::Deref for FolderItem2 {
    type Target = FolderItem;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::interface_hierarchy!(FolderItem2, windows_core::IUnknown, super::super::System::Com::IDispatch, FolderItem);
#[cfg(feature = "Win32_System_Com")]
impl FolderItem2 {
    #[cfg(all(feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub unsafe fn InvokeVerbEx(&self, vverb: &super::super::System::Variant::VARIANT, vargs: &super::super::System::Variant::VARIANT) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).InvokeVerbEx)(windows_core::Interface::as_raw(self), core::mem::transmute_copy(vverb), core::mem::transmute_copy(vargs)).ok() }
    }
    #[cfg(all(feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub unsafe fn ExtendedProperty(&self, bstrpropname: &windows_core::BSTR) -> windows_core::Result<super::super::System::Variant::VARIANT> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).ExtendedProperty)(windows_core::Interface::as_raw(self), core::mem::transmute_copy(bstrpropname), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct FolderItem2_Vtbl {
    pub base__: FolderItem_Vtbl,
    #[cfg(all(feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub InvokeVerbEx: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::System::Variant::VARIANT, super::super::System::Variant::VARIANT) -> windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_System_Ole", feature = "Win32_System_Variant")))]
    InvokeVerbEx: usize,
    #[cfg(all(feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub ExtendedProperty: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut super::super::System::Variant::VARIANT) -> windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_System_Ole", feature = "Win32_System_Variant")))]
    ExtendedProperty: usize,
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
pub trait FolderItem2_Impl: FolderItem_Impl {
    fn InvokeVerbEx(&self, vverb: &super::super::System::Variant::VARIANT, vargs: &super::super::System::Variant::VARIANT) -> windows_core::Result<()>;
    fn ExtendedProperty(&self, bstrpropname: &windows_core::BSTR) -> windows_core::Result<super::super::System::Variant::VARIANT>;
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl FolderItem2_Vtbl {
    pub const fn new<Identity: FolderItem2_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn InvokeVerbEx<Identity: FolderItem2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, vverb: super::super::System::Variant::VARIANT, vargs: super::super::System::Variant::VARIANT) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                FolderItem2_Impl::InvokeVerbEx(this, core::mem::transmute(&vverb), core::mem::transmute(&vargs)).into()
            }
        }
        unsafe extern "system" fn ExtendedProperty<Identity: FolderItem2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, bstrpropname: *mut core::ffi::c_void, pvret: *mut super::super::System::Variant::VARIANT) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match FolderItem2_Impl::ExtendedProperty(this, core::mem::transmute(&bstrpropname)) {
                    Ok(ok__) => {
                        pvret.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self {
            base__: FolderItem_Vtbl::new::<Identity, OFFSET>(),
            InvokeVerbEx: InvokeVerbEx::<Identity, OFFSET>,
            ExtendedProperty: ExtendedProperty::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<FolderItem2 as windows_core::Interface>::IID || iid == &<super::super::System::Com::IDispatch as windows_core::Interface>::IID || iid == &<FolderItem as windows_core::Interface>::IID
    }
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl windows_core::RuntimeName for FolderItem2 {}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::define_interface!(FolderItemVerb, FolderItemVerb_Vtbl, 0x08ec3e00_50b0_11cf_960c_0080c7f4ee85);
#[cfg(feature = "Win32_System_Com")]
impl core::ops::Deref for FolderItemVerb {
    type Target = super::super::System::Com::IDispatch;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::interface_hierarchy!(FolderItemVerb, windows_core::IUnknown, super::super::System::Com::IDispatch);
#[cfg(feature = "Win32_System_Com")]
impl FolderItemVerb {
    pub unsafe fn Application(&self) -> windows_core::Result<super::super::System::Com::IDispatch> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).Application)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn Parent(&self) -> windows_core::Result<super::super::System::Com::IDispatch> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).Parent)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn Name(&self) -> windows_core::Result<windows_core::BSTR> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).Name)(windows_core::Interface::as_raw(self), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub unsafe fn DoIt(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).DoIt)(windows_core::Interface::as_raw(self)).ok() }
    }
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct FolderItemVerb_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
    pub Application: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub Parent: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub Name: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub DoIt: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
pub trait FolderItemVerb_Impl: super::super::System::Com::IDispatch_Impl {
    fn Application(&self) -> windows_core::Result<super::super::System::Com::IDispatch>;
    fn Parent(&self) -> windows_core::Result<super::super::System::Com::IDispatch>;
    fn Name(&self) -> windows_core::Result<windows_core::BSTR>;
    fn DoIt(&self) -> windows_core::Result<()>;
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl FolderItemVerb_Vtbl {
    pub const fn new<Identity: FolderItemVerb_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn Application<Identity: FolderItemVerb_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ppid: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match FolderItemVerb_Impl::Application(this) {
                    Ok(ok__) => {
                        ppid.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn Parent<Identity: FolderItemVerb_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ppid: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match FolderItemVerb_Impl::Parent(this) {
                    Ok(ok__) => {
                        ppid.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn Name<Identity: FolderItemVerb_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbs: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match FolderItemVerb_Impl::Name(this) {
                    Ok(ok__) => {
                        pbs.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn DoIt<Identity: FolderItemVerb_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                FolderItemVerb_Impl::DoIt(this).into()
            }
        }
        Self {
            base__: super::super::System::Com::IDispatch_Vtbl::new::<Identity, OFFSET>(),
            Application: Application::<Identity, OFFSET>,
            Parent: Parent::<Identity, OFFSET>,
            Name: Name::<Identity, OFFSET>,
            DoIt: DoIt::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<FolderItemVerb as windows_core::Interface>::IID || iid == &<super::super::System::Com::IDispatch as windows_core::Interface>::IID
    }
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl windows_core::RuntimeName for FolderItemVerb {}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::define_interface!(FolderItemVerbs, FolderItemVerbs_Vtbl, 0x1f8352c0_50b0_11cf_960c_0080c7f4ee85);
#[cfg(feature = "Win32_System_Com")]
impl core::ops::Deref for FolderItemVerbs {
    type Target = super::super::System::Com::IDispatch;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::interface_hierarchy!(FolderItemVerbs, windows_core::IUnknown, super::super::System::Com::IDispatch);
#[cfg(feature = "Win32_System_Com")]
impl FolderItemVerbs {
    pub unsafe fn Count(&self) -> windows_core::Result<i32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).Count)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn Application(&self) -> windows_core::Result<super::super::System::Com::IDispatch> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).Application)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn Parent(&self) -> windows_core::Result<super::super::System::Com::IDispatch> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).Parent)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(all(feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub unsafe fn Item(&self, index: &super::super::System::Variant::VARIANT) -> windows_core::Result<FolderItemVerb> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).Item)(windows_core::Interface::as_raw(self), core::mem::transmute_copy(index), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn _NewEnum(&self) -> windows_core::Result<windows_core::IUnknown> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self)._NewEnum)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct FolderItemVerbs_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
    pub Count: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub Application: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub Parent: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(all(feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub Item: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::System::Variant::VARIANT, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_System_Ole", feature = "Win32_System_Variant")))]
    Item: usize,
    pub _NewEnum: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
pub trait FolderItemVerbs_Impl: super::super::System::Com::IDispatch_Impl {
    fn Count(&self) -> windows_core::Result<i32>;
    fn Application(&self) -> windows_core::Result<super::super::System::Com::IDispatch>;
    fn Parent(&self) -> windows_core::Result<super::super::System::Com::IDispatch>;
    fn Item(&self, index: &super::super::System::Variant::VARIANT) -> windows_core::Result<FolderItemVerb>;
    fn _NewEnum(&self) -> windows_core::Result<windows_core::IUnknown>;
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl FolderItemVerbs_Vtbl {
    pub const fn new<Identity: FolderItemVerbs_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn Count<Identity: FolderItemVerbs_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, plcount: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match FolderItemVerbs_Impl::Count(this) {
                    Ok(ok__) => {
                        plcount.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn Application<Identity: FolderItemVerbs_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ppid: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match FolderItemVerbs_Impl::Application(this) {
                    Ok(ok__) => {
                        ppid.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn Parent<Identity: FolderItemVerbs_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ppid: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match FolderItemVerbs_Impl::Parent(this) {
                    Ok(ok__) => {
                        ppid.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn Item<Identity: FolderItemVerbs_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, index: super::super::System::Variant::VARIANT, ppid: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match FolderItemVerbs_Impl::Item(this, core::mem::transmute(&index)) {
                    Ok(ok__) => {
                        ppid.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn _NewEnum<Identity: FolderItemVerbs_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ppunk: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match FolderItemVerbs_Impl::_NewEnum(this) {
                    Ok(ok__) => {
                        ppunk.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self {
            base__: super::super::System::Com::IDispatch_Vtbl::new::<Identity, OFFSET>(),
            Count: Count::<Identity, OFFSET>,
            Application: Application::<Identity, OFFSET>,
            Parent: Parent::<Identity, OFFSET>,
            Item: Item::<Identity, OFFSET>,
            _NewEnum: _NewEnum::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<FolderItemVerbs as windows_core::Interface>::IID || iid == &<super::super::System::Com::IDispatch as windows_core::Interface>::IID
    }
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl windows_core::RuntimeName for FolderItemVerbs {}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::define_interface!(FolderItems, FolderItems_Vtbl, 0x744129e0_cbe5_11ce_8350_444553540000);
#[cfg(feature = "Win32_System_Com")]
impl core::ops::Deref for FolderItems {
    type Target = super::super::System::Com::IDispatch;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::interface_hierarchy!(FolderItems, windows_core::IUnknown, super::super::System::Com::IDispatch);
#[cfg(feature = "Win32_System_Com")]
impl FolderItems {
    pub unsafe fn Count(&self) -> windows_core::Result<i32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).Count)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn Application(&self) -> windows_core::Result<super::super::System::Com::IDispatch> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).Application)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn Parent(&self) -> windows_core::Result<super::super::System::Com::IDispatch> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).Parent)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(all(feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub unsafe fn Item(&self, index: &super::super::System::Variant::VARIANT) -> windows_core::Result<FolderItem> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).Item)(windows_core::Interface::as_raw(self), core::mem::transmute_copy(index), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn _NewEnum(&self) -> windows_core::Result<windows_core::IUnknown> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self)._NewEnum)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct FolderItems_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
    pub Count: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub Application: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub Parent: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(all(feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub Item: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::System::Variant::VARIANT, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_System_Ole", feature = "Win32_System_Variant")))]
    Item: usize,
    pub _NewEnum: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
pub trait FolderItems_Impl: super::super::System::Com::IDispatch_Impl {
    fn Count(&self) -> windows_core::Result<i32>;
    fn Application(&self) -> windows_core::Result<super::super::System::Com::IDispatch>;
    fn Parent(&self) -> windows_core::Result<super::super::System::Com::IDispatch>;
    fn Item(&self, index: &super::super::System::Variant::VARIANT) -> windows_core::Result<FolderItem>;
    fn _NewEnum(&self) -> windows_core::Result<windows_core::IUnknown>;
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl FolderItems_Vtbl {
    pub const fn new<Identity: FolderItems_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn Count<Identity: FolderItems_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, plcount: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match FolderItems_Impl::Count(this) {
                    Ok(ok__) => {
                        plcount.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn Application<Identity: FolderItems_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ppid: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match FolderItems_Impl::Application(this) {
                    Ok(ok__) => {
                        ppid.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn Parent<Identity: FolderItems_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ppid: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match FolderItems_Impl::Parent(this) {
                    Ok(ok__) => {
                        ppid.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn Item<Identity: FolderItems_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, index: super::super::System::Variant::VARIANT, ppid: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match FolderItems_Impl::Item(this, core::mem::transmute(&index)) {
                    Ok(ok__) => {
                        ppid.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn _NewEnum<Identity: FolderItems_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ppunk: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match FolderItems_Impl::_NewEnum(this) {
                    Ok(ok__) => {
                        ppunk.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self {
            base__: super::super::System::Com::IDispatch_Vtbl::new::<Identity, OFFSET>(),
            Count: Count::<Identity, OFFSET>,
            Application: Application::<Identity, OFFSET>,
            Parent: Parent::<Identity, OFFSET>,
            Item: Item::<Identity, OFFSET>,
            _NewEnum: _NewEnum::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<FolderItems as windows_core::Interface>::IID || iid == &<super::super::System::Com::IDispatch as windows_core::Interface>::IID
    }
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl windows_core::RuntimeName for FolderItems {}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::define_interface!(FolderItems2, FolderItems2_Vtbl, 0xc94f0ad0_f363_11d2_a327_00c04f8eec7f);
#[cfg(feature = "Win32_System_Com")]
impl core::ops::Deref for FolderItems2 {
    type Target = FolderItems;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::interface_hierarchy!(FolderItems2, windows_core::IUnknown, super::super::System::Com::IDispatch, FolderItems);
#[cfg(feature = "Win32_System_Com")]
impl FolderItems2 {
    #[cfg(all(feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub unsafe fn InvokeVerbEx(&self, vverb: &super::super::System::Variant::VARIANT, vargs: &super::super::System::Variant::VARIANT) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).InvokeVerbEx)(windows_core::Interface::as_raw(self), core::mem::transmute_copy(vverb), core::mem::transmute_copy(vargs)).ok() }
    }
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct FolderItems2_Vtbl {
    pub base__: FolderItems_Vtbl,
    #[cfg(all(feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub InvokeVerbEx: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::System::Variant::VARIANT, super::super::System::Variant::VARIANT) -> windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_System_Ole", feature = "Win32_System_Variant")))]
    InvokeVerbEx: usize,
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
pub trait FolderItems2_Impl: FolderItems_Impl {
    fn InvokeVerbEx(&self, vverb: &super::super::System::Variant::VARIANT, vargs: &super::super::System::Variant::VARIANT) -> windows_core::Result<()>;
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl FolderItems2_Vtbl {
    pub const fn new<Identity: FolderItems2_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn InvokeVerbEx<Identity: FolderItems2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, vverb: super::super::System::Variant::VARIANT, vargs: super::super::System::Variant::VARIANT) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                FolderItems2_Impl::InvokeVerbEx(this, core::mem::transmute(&vverb), core::mem::transmute(&vargs)).into()
            }
        }
        Self { base__: FolderItems_Vtbl::new::<Identity, OFFSET>(), InvokeVerbEx: InvokeVerbEx::<Identity, OFFSET> }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<FolderItems2 as windows_core::Interface>::IID || iid == &<super::super::System::Com::IDispatch as windows_core::Interface>::IID || iid == &<FolderItems as windows_core::Interface>::IID
    }
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl windows_core::RuntimeName for FolderItems2 {}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::define_interface!(FolderItems3, FolderItems3_Vtbl, 0xeaa7c309_bbec_49d5_821d_64d966cb667f);
#[cfg(feature = "Win32_System_Com")]
impl core::ops::Deref for FolderItems3 {
    type Target = FolderItems2;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::interface_hierarchy!(FolderItems3, windows_core::IUnknown, super::super::System::Com::IDispatch, FolderItems, FolderItems2);
#[cfg(feature = "Win32_System_Com")]
impl FolderItems3 {
    pub unsafe fn Filter(&self, grfflags: i32, bstrfilespec: &windows_core::BSTR) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).Filter)(windows_core::Interface::as_raw(self), grfflags, core::mem::transmute_copy(bstrfilespec)).ok() }
    }
    pub unsafe fn Verbs(&self) -> windows_core::Result<FolderItemVerbs> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).Verbs)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct FolderItems3_Vtbl {
    pub base__: FolderItems2_Vtbl,
    pub Filter: unsafe extern "system" fn(*mut core::ffi::c_void, i32, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub Verbs: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
pub trait FolderItems3_Impl: FolderItems2_Impl {
    fn Filter(&self, grfflags: i32, bstrfilespec: &windows_core::BSTR) -> windows_core::Result<()>;
    fn Verbs(&self) -> windows_core::Result<FolderItemVerbs>;
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl FolderItems3_Vtbl {
    pub const fn new<Identity: FolderItems3_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn Filter<Identity: FolderItems3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, grfflags: i32, bstrfilespec: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                FolderItems3_Impl::Filter(this, core::mem::transmute_copy(&grfflags), core::mem::transmute(&bstrfilespec)).into()
            }
        }
        unsafe extern "system" fn Verbs<Identity: FolderItems3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ppfic: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match FolderItems3_Impl::Verbs(this) {
                    Ok(ok__) => {
                        ppfic.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self { base__: FolderItems2_Vtbl::new::<Identity, OFFSET>(), Filter: Filter::<Identity, OFFSET>, Verbs: Verbs::<Identity, OFFSET> }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<FolderItems3 as windows_core::Interface>::IID || iid == &<super::super::System::Com::IDispatch as windows_core::Interface>::IID || iid == &<FolderItems as windows_core::Interface>::IID || iid == &<FolderItems2 as windows_core::Interface>::IID
    }
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl windows_core::RuntimeName for FolderItems3 {}
pub const FolderViewHost: windows_core::GUID = windows_core::GUID::from_u128(0x20b1cb23_6968_4eb9_b7d4_a66d00d07cee);
pub const FrameworkInputPane: windows_core::GUID = windows_core::GUID::from_u128(0xd5120aa3_46ba_44c5_822d_ca8092c1fc72);
pub const FreeSpaceCategorizer: windows_core::GUID = windows_core::GUID::from_u128(0xb5607793_24ac_44c7_82e2_831726aa6cb7);
pub const GADOF_DIRTY: u32 = 1u32;
pub const GCS_HELPTEXT: u32 = 5u32;
pub const GCS_HELPTEXTA: u32 = 1u32;
pub const GCS_HELPTEXTW: u32 = 5u32;
pub const GCS_UNICODE: u32 = 4u32;
pub const GCS_VALIDATE: u32 = 6u32;
pub const GCS_VALIDATEA: u32 = 2u32;
pub const GCS_VALIDATEW: u32 = 6u32;
pub const GCS_VERB: u32 = 4u32;
pub const GCS_VERBA: u32 = 0u32;
pub const GCS_VERBICONW: u32 = 20u32;
pub const GCS_VERBW: u32 = 4u32;
pub const GCT_INVALID: u32 = 0u32;
pub const GCT_LFNCHAR: u32 = 1u32;
pub const GCT_SEPARATOR: u32 = 8u32;
pub const GCT_SHORTCHAR: u32 = 2u32;
pub const GCT_WILD: u32 = 4u32;
pub const GETPROPS_NONE: u32 = 0u32;
pub const GIL_ASYNC: u32 = 32u32;
pub const GIL_CHECKSHIELD: u32 = 512u32;
pub const GIL_DEFAULTICON: u32 = 64u32;
pub const GIL_DONTCACHE: u32 = 16u32;
pub const GIL_FORCENOSHIELD: u32 = 1024u32;
pub const GIL_FORSHELL: u32 = 2u32;
pub const GIL_FORSHORTCUT: u32 = 128u32;
pub const GIL_NOTFILENAME: u32 = 8u32;
pub const GIL_OPENICON: u32 = 1u32;
pub const GIL_PERCLASS: u32 = 4u32;
pub const GIL_PERINSTANCE: u32 = 2u32;
pub const GIL_SHIELD: u32 = 512u32;
pub const GIL_SIMULATEDOC: u32 = 1u32;
pub const GLOBALCOUNTER_APPLICATION_DESTINATIONS: SHGLOBALCOUNTER = SHGLOBALCOUNTER(12i32);
pub const GLOBALCOUNTER_APPROVEDSITES: SHGLOBALCOUNTER = SHGLOBALCOUNTER(4i32);
pub const GLOBALCOUNTER_APPSFOLDER_FILETYPEASSOCIATION_COUNTER: SHGLOBALCOUNTER = SHGLOBALCOUNTER(55i32);
pub const GLOBALCOUNTER_APP_ITEMS_STATE_STORE_CACHE: SHGLOBALCOUNTER = SHGLOBALCOUNTER(53i32);
pub const GLOBALCOUNTER_ASSOCCHANGED: SHGLOBALCOUNTER = SHGLOBALCOUNTER(52i32);
pub const GLOBALCOUNTER_BANNERS_DATAMODEL_CACHE_MACHINEWIDE: SHGLOBALCOUNTER = SHGLOBALCOUNTER(58i32);
pub const GLOBALCOUNTER_BITBUCKETNUMDELETERS: SHGLOBALCOUNTER = SHGLOBALCOUNTER(14i32);
pub const GLOBALCOUNTER_COMMONPLACES_LIST_CACHE: SHGLOBALCOUNTER = SHGLOBALCOUNTER(50i32);
pub const GLOBALCOUNTER_FOLDERDEFINITION_CACHE: SHGLOBALCOUNTER = SHGLOBALCOUNTER(49i32);
pub const GLOBALCOUNTER_FOLDERSETTINGSCHANGE: SHGLOBALCOUNTER = SHGLOBALCOUNTER(2i32);
pub const GLOBALCOUNTER_IEONLY_SESSIONS: SHGLOBALCOUNTER = SHGLOBALCOUNTER(11i32);
pub const GLOBALCOUNTER_IESESSIONS: SHGLOBALCOUNTER = SHGLOBALCOUNTER(10i32);
pub const GLOBALCOUNTER_INTERNETTOOLBAR_LAYOUT: SHGLOBALCOUNTER = SHGLOBALCOUNTER(48i32);
pub const GLOBALCOUNTER_MAXIMUMVALUE: SHGLOBALCOUNTER = SHGLOBALCOUNTER(59i32);
pub const GLOBALCOUNTER_OVERLAYMANAGER: SHGLOBALCOUNTER = SHGLOBALCOUNTER(8i32);
pub const GLOBALCOUNTER_PRIVATE_PROFILE_CACHE: SHGLOBALCOUNTER = SHGLOBALCOUNTER(47i32);
pub const GLOBALCOUNTER_PRIVATE_PROFILE_CACHE_MACHINEWIDE: SHGLOBALCOUNTER = SHGLOBALCOUNTER(51i32);
pub const GLOBALCOUNTER_QUERYASSOCIATIONS: SHGLOBALCOUNTER = SHGLOBALCOUNTER(9i32);
pub const GLOBALCOUNTER_RATINGS: SHGLOBALCOUNTER = SHGLOBALCOUNTER(3i32);
pub const GLOBALCOUNTER_RATINGS_STATECOUNTER: SHGLOBALCOUNTER = SHGLOBALCOUNTER(46i32);
pub const GLOBALCOUNTER_RECYCLEBINCORRUPTED: SHGLOBALCOUNTER = SHGLOBALCOUNTER(45i32);
pub const GLOBALCOUNTER_RECYCLEBINENUM: SHGLOBALCOUNTER = SHGLOBALCOUNTER(44i32);
pub const GLOBALCOUNTER_RECYCLEDIRTYCOUNT_DRIVE_A: SHGLOBALCOUNTER = SHGLOBALCOUNTER(16i32);
pub const GLOBALCOUNTER_RECYCLEDIRTYCOUNT_DRIVE_B: SHGLOBALCOUNTER = SHGLOBALCOUNTER(17i32);
pub const GLOBALCOUNTER_RECYCLEDIRTYCOUNT_DRIVE_C: SHGLOBALCOUNTER = SHGLOBALCOUNTER(18i32);
pub const GLOBALCOUNTER_RECYCLEDIRTYCOUNT_DRIVE_D: SHGLOBALCOUNTER = SHGLOBALCOUNTER(19i32);
pub const GLOBALCOUNTER_RECYCLEDIRTYCOUNT_DRIVE_E: SHGLOBALCOUNTER = SHGLOBALCOUNTER(20i32);
pub const GLOBALCOUNTER_RECYCLEDIRTYCOUNT_DRIVE_F: SHGLOBALCOUNTER = SHGLOBALCOUNTER(21i32);
pub const GLOBALCOUNTER_RECYCLEDIRTYCOUNT_DRIVE_G: SHGLOBALCOUNTER = SHGLOBALCOUNTER(22i32);
pub const GLOBALCOUNTER_RECYCLEDIRTYCOUNT_DRIVE_H: SHGLOBALCOUNTER = SHGLOBALCOUNTER(23i32);
pub const GLOBALCOUNTER_RECYCLEDIRTYCOUNT_DRIVE_I: SHGLOBALCOUNTER = SHGLOBALCOUNTER(24i32);
pub const GLOBALCOUNTER_RECYCLEDIRTYCOUNT_DRIVE_J: SHGLOBALCOUNTER = SHGLOBALCOUNTER(25i32);
pub const GLOBALCOUNTER_RECYCLEDIRTYCOUNT_DRIVE_K: SHGLOBALCOUNTER = SHGLOBALCOUNTER(26i32);
pub const GLOBALCOUNTER_RECYCLEDIRTYCOUNT_DRIVE_L: SHGLOBALCOUNTER = SHGLOBALCOUNTER(27i32);
pub const GLOBALCOUNTER_RECYCLEDIRTYCOUNT_DRIVE_M: SHGLOBALCOUNTER = SHGLOBALCOUNTER(28i32);
pub const GLOBALCOUNTER_RECYCLEDIRTYCOUNT_DRIVE_N: SHGLOBALCOUNTER = SHGLOBALCOUNTER(29i32);
pub const GLOBALCOUNTER_RECYCLEDIRTYCOUNT_DRIVE_O: SHGLOBALCOUNTER = SHGLOBALCOUNTER(30i32);
pub const GLOBALCOUNTER_RECYCLEDIRTYCOUNT_DRIVE_P: SHGLOBALCOUNTER = SHGLOBALCOUNTER(31i32);
pub const GLOBALCOUNTER_RECYCLEDIRTYCOUNT_DRIVE_Q: SHGLOBALCOUNTER = SHGLOBALCOUNTER(32i32);
pub const GLOBALCOUNTER_RECYCLEDIRTYCOUNT_DRIVE_R: SHGLOBALCOUNTER = SHGLOBALCOUNTER(33i32);
pub const GLOBALCOUNTER_RECYCLEDIRTYCOUNT_DRIVE_S: SHGLOBALCOUNTER = SHGLOBALCOUNTER(34i32);
pub const GLOBALCOUNTER_RECYCLEDIRTYCOUNT_DRIVE_T: SHGLOBALCOUNTER = SHGLOBALCOUNTER(35i32);
pub const GLOBALCOUNTER_RECYCLEDIRTYCOUNT_DRIVE_U: SHGLOBALCOUNTER = SHGLOBALCOUNTER(36i32);
pub const GLOBALCOUNTER_RECYCLEDIRTYCOUNT_DRIVE_V: SHGLOBALCOUNTER = SHGLOBALCOUNTER(37i32);
pub const GLOBALCOUNTER_RECYCLEDIRTYCOUNT_DRIVE_W: SHGLOBALCOUNTER = SHGLOBALCOUNTER(38i32);
pub const GLOBALCOUNTER_RECYCLEDIRTYCOUNT_DRIVE_X: SHGLOBALCOUNTER = SHGLOBALCOUNTER(39i32);
pub const GLOBALCOUNTER_RECYCLEDIRTYCOUNT_DRIVE_Y: SHGLOBALCOUNTER = SHGLOBALCOUNTER(40i32);
pub const GLOBALCOUNTER_RECYCLEDIRTYCOUNT_DRIVE_Z: SHGLOBALCOUNTER = SHGLOBALCOUNTER(41i32);
pub const GLOBALCOUNTER_RECYCLEDIRTYCOUNT_SHARES: SHGLOBALCOUNTER = SHGLOBALCOUNTER(15i32);
pub const GLOBALCOUNTER_RESTRICTIONS: SHGLOBALCOUNTER = SHGLOBALCOUNTER(5i32);
pub const GLOBALCOUNTER_SEARCHMANAGER: SHGLOBALCOUNTER = SHGLOBALCOUNTER(0i32);
pub const GLOBALCOUNTER_SEARCHOPTIONS: SHGLOBALCOUNTER = SHGLOBALCOUNTER(1i32);
pub const GLOBALCOUNTER_SETTINGSYNC_ENABLED: SHGLOBALCOUNTER = SHGLOBALCOUNTER(54i32);
pub const GLOBALCOUNTER_SHELLSETTINGSCHANGED: SHGLOBALCOUNTER = SHGLOBALCOUNTER(6i32);
pub const GLOBALCOUNTER_SYNC_ENGINE_INFORMATION_CACHE_MACHINEWIDE: SHGLOBALCOUNTER = SHGLOBALCOUNTER(57i32);
pub const GLOBALCOUNTER_SYSTEMPIDLCHANGE: SHGLOBALCOUNTER = SHGLOBALCOUNTER(7i32);
pub const GLOBALCOUNTER_USERINFOCHANGED: SHGLOBALCOUNTER = SHGLOBALCOUNTER(56i32);
pub const GPFIDL_ALTNAME: GPFIDL_FLAGS = GPFIDL_FLAGS(1u32);
pub const GPFIDL_DEFAULT: GPFIDL_FLAGS = GPFIDL_FLAGS(0u32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct GPFIDL_FLAGS(pub u32);
pub const GPFIDL_UNCPRINTER: GPFIDL_FLAGS = GPFIDL_FLAGS(2u32);
pub const GenericCredentialProvider: windows_core::GUID = windows_core::GUID::from_u128(0x25cbb996_92ed_457e_b28c_4774084bd562);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq)]
pub struct HDROP(pub *mut core::ffi::c_void);
impl HDROP {
    pub fn is_invalid(&self) -> bool {
        self.0 == -1 as _ || self.0 == 0 as _
    }
}
impl Default for HDROP {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct HELPINFO {
    pub cbSize: u32,
    pub iContextType: HELP_INFO_TYPE,
    pub iCtrlId: i32,
    pub hItemHandle: super::super::Foundation::HANDLE,
    pub dwContextId: usize,
    pub MousePos: super::super::Foundation::POINT,
}
pub const HELPINFO_MENUITEM: HELP_INFO_TYPE = HELP_INFO_TYPE(2i32);
pub const HELPINFO_WINDOW: HELP_INFO_TYPE = HELP_INFO_TYPE(1i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct HELPWININFOA {
    pub wStructSize: i32,
    pub x: i32,
    pub y: i32,
    pub dx: i32,
    pub dy: i32,
    pub wMax: i32,
    pub rgchMember: [i8; 2],
}
impl Default for HELPWININFOA {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct HELPWININFOW {
    pub wStructSize: i32,
    pub x: i32,
    pub y: i32,
    pub dx: i32,
    pub dy: i32,
    pub wMax: i32,
    pub rgchMember: [u16; 2],
}
impl Default for HELPWININFOW {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct HELP_INFO_TYPE(pub i32);
pub const HGSC_DOCUMENTSLIBRARY: HOMEGROUPSHARINGCHOICES = HOMEGROUPSHARINGCHOICES(8i32);
pub const HGSC_MUSICLIBRARY: HOMEGROUPSHARINGCHOICES = HOMEGROUPSHARINGCHOICES(1i32);
pub const HGSC_NONE: HOMEGROUPSHARINGCHOICES = HOMEGROUPSHARINGCHOICES(0i32);
pub const HGSC_PICTURESLIBRARY: HOMEGROUPSHARINGCHOICES = HOMEGROUPSHARINGCHOICES(2i32);
pub const HGSC_PRINTERS: HOMEGROUPSHARINGCHOICES = HOMEGROUPSHARINGCHOICES(16i32);
pub const HGSC_VIDEOSLIBRARY: HOMEGROUPSHARINGCHOICES = HOMEGROUPSHARINGCHOICES(4i32);
pub const HLBWIF_DOCWNDMAXIMIZED: HLBWIF_FLAGS = HLBWIF_FLAGS(8i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct HLBWIF_FLAGS(pub i32);
impl HLBWIF_FLAGS {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl core::ops::BitOr for HLBWIF_FLAGS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl core::ops::BitAnd for HLBWIF_FLAGS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl core::ops::BitOrAssign for HLBWIF_FLAGS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl core::ops::BitAndAssign for HLBWIF_FLAGS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl core::ops::Not for HLBWIF_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
pub const HLBWIF_FRAMEWNDMAXIMIZED: HLBWIF_FLAGS = HLBWIF_FLAGS(4i32);
pub const HLBWIF_HASDOCWNDINFO: HLBWIF_FLAGS = HLBWIF_FLAGS(2i32);
pub const HLBWIF_HASFRAMEWNDINFO: HLBWIF_FLAGS = HLBWIF_FLAGS(1i32);
pub const HLBWIF_HASWEBTOOLBARINFO: HLBWIF_FLAGS = HLBWIF_FLAGS(16i32);
pub const HLBWIF_WEBTOOLBARHIDDEN: HLBWIF_FLAGS = HLBWIF_FLAGS(32i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct HLBWINFO {
    pub cbSize: u32,
    pub grfHLBWIF: u32,
    pub rcFramePos: super::super::Foundation::RECT,
    pub rcDocPos: super::super::Foundation::RECT,
    pub hltbinfo: HLTBINFO,
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct HLFNAMEF(pub i32);
impl HLFNAMEF {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl core::ops::BitOr for HLFNAMEF {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl core::ops::BitAnd for HLFNAMEF {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl core::ops::BitOrAssign for HLFNAMEF {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl core::ops::BitAndAssign for HLFNAMEF {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl core::ops::Not for HLFNAMEF {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
pub const HLFNAMEF_DEFAULT: HLFNAMEF = HLFNAMEF(0i32);
pub const HLFNAMEF_TRYCACHE: HLFNAMEF = HLFNAMEF(1i32);
pub const HLFNAMEF_TRYFULLTARGET: HLFNAMEF = HLFNAMEF(4i32);
pub const HLFNAMEF_TRYPRETTYTARGET: HLFNAMEF = HLFNAMEF(2i32);
pub const HLFNAMEF_TRYWIN95SHORTCUT: HLFNAMEF = HLFNAMEF(8i32);
pub const HLID_CURRENT: HLID_INFO = HLID_INFO(4294967293u32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct HLID_INFO(pub u32);
pub const HLID_INVALID: HLID_INFO = HLID_INFO(0u32);
pub const HLID_NEXT: HLID_INFO = HLID_INFO(4294967294u32);
pub const HLID_PREVIOUS: HLID_INFO = HLID_INFO(4294967295u32);
pub const HLID_STACKBOTTOM: HLID_INFO = HLID_INFO(4294967292u32);
pub const HLID_STACKTOP: HLID_INFO = HLID_INFO(4294967291u32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct HLINKGETREF(pub i32);
pub const HLINKGETREF_ABSOLUTE: HLINKGETREF = HLINKGETREF(1i32);
pub const HLINKGETREF_DEFAULT: HLINKGETREF = HLINKGETREF(0i32);
pub const HLINKGETREF_RELATIVE: HLINKGETREF = HLINKGETREF(2i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct HLINKMISC(pub i32);
pub const HLINKMISC_RELATIVE: HLINKMISC = HLINKMISC(1i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct HLINKSETF(pub i32);
pub const HLINKSETF_LOCATION: HLINKSETF = HLINKSETF(2i32);
pub const HLINKSETF_TARGET: HLINKSETF = HLINKSETF(1i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct HLINKWHICHMK(pub i32);
pub const HLINKWHICHMK_BASE: HLINKWHICHMK = HLINKWHICHMK(2i32);
pub const HLINKWHICHMK_CONTAINER: HLINKWHICHMK = HLINKWHICHMK(1i32);
pub const HLINK_E_FIRST: windows_core::HRESULT = windows_core::HRESULT(0x80040100_u32 as _);
pub const HLINK_S_DONTHIDE: i32 = 262400i32;
pub const HLINK_S_FIRST: windows_core::HRESULT = windows_core::HRESULT(0x40100_u32 as _);
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct HLITEM {
    pub uHLID: u32,
    pub pwzFriendlyName: windows_core::PWSTR,
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct HLNF(pub u32);
impl HLNF {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl core::ops::BitOr for HLNF {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl core::ops::BitAnd for HLNF {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl core::ops::BitOrAssign for HLNF {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl core::ops::BitAndAssign for HLNF {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl core::ops::Not for HLNF {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
pub const HLNF_ALLOW_AUTONAVIGATE: u32 = 536870912u32;
pub const HLNF_CALLERUNTRUSTED: u32 = 2097152u32;
pub const HLNF_CREATENOHISTORY: HLNF = HLNF(32u32);
pub const HLNF_DISABLEWINDOWRESTRICTIONS: u32 = 8388608u32;
pub const HLNF_EXTERNALNAVIGATE: u32 = 268435456u32;
pub const HLNF_INTERNALJUMP: HLNF = HLNF(1u32);
pub const HLNF_NAVIGATINGBACK: HLNF = HLNF(4u32);
pub const HLNF_NAVIGATINGFORWARD: HLNF = HLNF(8u32);
pub const HLNF_NAVIGATINGTOSTACKITEM: HLNF = HLNF(16u32);
pub const HLNF_NEWWINDOWSMANAGED: u32 = 2147483648u32;
pub const HLNF_OPENINNEWWINDOW: HLNF = HLNF(2u32);
pub const HLNF_TRUSTEDFORACTIVEX: u32 = 4194304u32;
pub const HLNF_TRUSTFIRSTDOWNLOAD: u32 = 16777216u32;
pub const HLNF_UNTRUSTEDFORDOWNLOAD: u32 = 33554432u32;
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct HLQF_INFO(pub i32);
pub const HLQF_ISCURRENT: HLQF_INFO = HLQF_INFO(2i32);
pub const HLQF_ISVALID: HLQF_INFO = HLQF_INFO(1i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct HLSHORTCUTF(pub i32);
pub const HLSHORTCUTF_DEFAULT: HLSHORTCUTF = HLSHORTCUTF(0i32);
pub const HLSHORTCUTF_DONTACTUALLYCREATE: HLSHORTCUTF = HLSHORTCUTF(1i32);
pub const HLSHORTCUTF_MAYUSEEXISTINGSHORTCUT: HLSHORTCUTF = HLSHORTCUTF(8i32);
pub const HLSHORTCUTF_USEFILENAMEFROMFRIENDLYNAME: HLSHORTCUTF = HLSHORTCUTF(2i32);
pub const HLSHORTCUTF_USEUNIQUEFILENAME: HLSHORTCUTF = HLSHORTCUTF(4i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct HLSR(pub i32);
pub const HLSR_HISTORYFOLDER: HLSR = HLSR(2i32);
pub const HLSR_HOME: HLSR = HLSR(0i32);
pub const HLSR_SEARCHPAGE: HLSR = HLSR(1i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct HLTBINFO {
    pub uDockType: u32,
    pub rcTbPos: super::super::Foundation::RECT,
}
pub const HLTB_DOCKEDBOTTOM: HLTB_INFO = HLTB_INFO(3i32);
pub const HLTB_DOCKEDLEFT: HLTB_INFO = HLTB_INFO(0i32);
pub const HLTB_DOCKEDRIGHT: HLTB_INFO = HLTB_INFO(2i32);
pub const HLTB_DOCKEDTOP: HLTB_INFO = HLTB_INFO(1i32);
pub const HLTB_FLOATING: HLTB_INFO = HLTB_INFO(4i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct HLTB_INFO(pub i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct HLTRANSLATEF(pub i32);
pub const HLTRANSLATEF_DEFAULT: HLTRANSLATEF = HLTRANSLATEF(0i32);
pub const HLTRANSLATEF_DONTAPPLYDEFAULTPREFIX: HLTRANSLATEF = HLTRANSLATEF(1i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct HOMEGROUPSHARINGCHOICES(pub i32);
impl HOMEGROUPSHARINGCHOICES {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl core::ops::BitOr for HOMEGROUPSHARINGCHOICES {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl core::ops::BitAnd for HOMEGROUPSHARINGCHOICES {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl core::ops::BitOrAssign for HOMEGROUPSHARINGCHOICES {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl core::ops::BitAndAssign for HOMEGROUPSHARINGCHOICES {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl core::ops::Not for HOMEGROUPSHARINGCHOICES {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
pub const HOMEGROUP_SECURITY_GROUP: windows_core::PCWSTR = windows_core::w!("HomeUsers");
pub const HOMEGROUP_SECURITY_GROUP_MULTI: windows_core::PCWSTR = windows_core::w!("HUG");
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq)]
pub struct HPSXA(pub *mut core::ffi::c_void);
impl HPSXA {
    pub fn is_invalid(&self) -> bool {
        self.0 == -1 as _ || self.0 == 0 as _
    }
}
impl windows_core::Free for HPSXA {
    #[inline]
    unsafe fn free(&mut self) {
        if !self.is_invalid() {
            windows_core::link!("shell32.dll" "system" fn SHDestroyPropSheetExtArray(hpsxa : *mut core::ffi::c_void));
            unsafe {
                SHDestroyPropSheetExtArray(self.0);
            }
        }
    }
}
impl Default for HPSXA {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const HideInputPaneAnimationCoordinator: windows_core::GUID = windows_core::GUID::from_u128(0x384742b1_2a77_4cb3_8cf8_1136f5e17e59);
pub const HomeGroup: windows_core::GUID = windows_core::GUID::from_u128(0xde77ba04_3c92_4d11_a1a5_42352a53e0e3);
windows_core::imp::define_interface!(IACList, IACList_Vtbl, 0x77a130b0_94fd_11d0_a544_00c04fd7d062);
windows_core::imp::interface_hierarchy!(IACList, windows_core::IUnknown);
impl IACList {
    pub unsafe fn Expand<P0>(&self, pszexpand: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).Expand)(windows_core::Interface::as_raw(self), pszexpand.param().abi()).ok() }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IACList_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub Expand: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
}
pub trait IACList_Impl: windows_core::IUnknownImpl {
    fn Expand(&self, pszexpand: &windows_core::PCWSTR) -> windows_core::Result<()>;
}
impl IACList_Vtbl {
    pub const fn new<Identity: IACList_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn Expand<Identity: IACList_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pszexpand: windows_core::PCWSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IACList_Impl::Expand(this, core::mem::transmute(&pszexpand)).into()
            }
        }
        Self { base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(), Expand: Expand::<Identity, OFFSET> }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IACList as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IACList {}
windows_core::imp::define_interface!(IACList2, IACList2_Vtbl, 0x470141a0_5186_11d2_bbb6_0060977b464c);
impl core::ops::Deref for IACList2 {
    type Target = IACList;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IACList2, windows_core::IUnknown, IACList);
impl IACList2 {
    pub unsafe fn SetOptions(&self, dwflag: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetOptions)(windows_core::Interface::as_raw(self), dwflag).ok() }
    }
    pub unsafe fn GetOptions(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetOptions)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IACList2_Vtbl {
    pub base__: IACList_Vtbl,
    pub SetOptions: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetOptions: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
}
pub trait IACList2_Impl: IACList_Impl {
    fn SetOptions(&self, dwflag: u32) -> windows_core::Result<()>;
    fn GetOptions(&self) -> windows_core::Result<u32>;
}
impl IACList2_Vtbl {
    pub const fn new<Identity: IACList2_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn SetOptions<Identity: IACList2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwflag: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IACList2_Impl::SetOptions(this, core::mem::transmute_copy(&dwflag)).into()
            }
        }
        unsafe extern "system" fn GetOptions<Identity: IACList2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pdwflag: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IACList2_Impl::GetOptions(this) {
                    Ok(ok__) => {
                        pdwflag.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self { base__: IACList_Vtbl::new::<Identity, OFFSET>(), SetOptions: SetOptions::<Identity, OFFSET>, GetOptions: GetOptions::<Identity, OFFSET> }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IACList2 as windows_core::Interface>::IID || iid == &<IACList as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IACList2 {}
windows_core::imp::define_interface!(IAccessibilityDockingService, IAccessibilityDockingService_Vtbl, 0x8849dc22_cedf_4c95_998d_051419dd3f76);
windows_core::imp::interface_hierarchy!(IAccessibilityDockingService, windows_core::IUnknown);
impl IAccessibilityDockingService {
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn GetAvailableSize(&self, hmonitor: super::super::Graphics::Gdi::HMONITOR, pcxfixed: *mut u32, pcymax: *mut u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetAvailableSize)(windows_core::Interface::as_raw(self), hmonitor, pcxfixed as _, pcymax as _).ok() }
    }
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn DockWindow<P3>(&self, hwnd: super::super::Foundation::HWND, hmonitor: super::super::Graphics::Gdi::HMONITOR, cyrequested: u32, pcallback: P3) -> windows_core::Result<()>
    where
        P3: windows_core::Param<IAccessibilityDockingServiceCallback>,
    {
        unsafe { (windows_core::Interface::vtable(self).DockWindow)(windows_core::Interface::as_raw(self), hwnd, hmonitor, cyrequested, pcallback.param().abi()).ok() }
    }
    pub unsafe fn UndockWindow(&self, hwnd: super::super::Foundation::HWND) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).UndockWindow)(windows_core::Interface::as_raw(self), hwnd).ok() }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAccessibilityDockingService_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub GetAvailableSize: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Graphics::Gdi::HMONITOR, *mut u32, *mut u32) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))]
    GetAvailableSize: usize,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub DockWindow: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::HWND, super::super::Graphics::Gdi::HMONITOR, u32, *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))]
    DockWindow: usize,
    pub UndockWindow: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::HWND) -> windows_core::HRESULT,
}
#[cfg(feature = "Win32_Graphics_Gdi")]
pub trait IAccessibilityDockingService_Impl: windows_core::IUnknownImpl {
    fn GetAvailableSize(&self, hmonitor: super::super::Graphics::Gdi::HMONITOR, pcxfixed: *mut u32, pcymax: *mut u32) -> windows_core::Result<()>;
    fn DockWindow(&self, hwnd: super::super::Foundation::HWND, hmonitor: super::super::Graphics::Gdi::HMONITOR, cyrequested: u32, pcallback: windows_core::Ref<IAccessibilityDockingServiceCallback>) -> windows_core::Result<()>;
    fn UndockWindow(&self, hwnd: super::super::Foundation::HWND) -> windows_core::Result<()>;
}
#[cfg(feature = "Win32_Graphics_Gdi")]
impl IAccessibilityDockingService_Vtbl {
    pub const fn new<Identity: IAccessibilityDockingService_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetAvailableSize<Identity: IAccessibilityDockingService_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, hmonitor: super::super::Graphics::Gdi::HMONITOR, pcxfixed: *mut u32, pcymax: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAccessibilityDockingService_Impl::GetAvailableSize(this, core::mem::transmute_copy(&hmonitor), core::mem::transmute_copy(&pcxfixed), core::mem::transmute_copy(&pcymax)).into()
            }
        }
        unsafe extern "system" fn DockWindow<Identity: IAccessibilityDockingService_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, hwnd: super::super::Foundation::HWND, hmonitor: super::super::Graphics::Gdi::HMONITOR, cyrequested: u32, pcallback: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAccessibilityDockingService_Impl::DockWindow(this, core::mem::transmute_copy(&hwnd), core::mem::transmute_copy(&hmonitor), core::mem::transmute_copy(&cyrequested), core::mem::transmute_copy(&pcallback)).into()
            }
        }
        unsafe extern "system" fn UndockWindow<Identity: IAccessibilityDockingService_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, hwnd: super::super::Foundation::HWND) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAccessibilityDockingService_Impl::UndockWindow(this, core::mem::transmute_copy(&hwnd)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            GetAvailableSize: GetAvailableSize::<Identity, OFFSET>,
            DockWindow: DockWindow::<Identity, OFFSET>,
            UndockWindow: UndockWindow::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAccessibilityDockingService as windows_core::Interface>::IID
    }
}
#[cfg(feature = "Win32_Graphics_Gdi")]
impl windows_core::RuntimeName for IAccessibilityDockingService {}
windows_core::imp::define_interface!(IAccessibilityDockingServiceCallback, IAccessibilityDockingServiceCallback_Vtbl, 0x157733fd_a592_42e5_b594_248468c5a81b);
windows_core::imp::interface_hierarchy!(IAccessibilityDockingServiceCallback, windows_core::IUnknown);
impl IAccessibilityDockingServiceCallback {
    pub unsafe fn Undocked(&self, undockreason: UNDOCK_REASON) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).Undocked)(windows_core::Interface::as_raw(self), undockreason).ok() }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAccessibilityDockingServiceCallback_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub Undocked: unsafe extern "system" fn(*mut core::ffi::c_void, UNDOCK_REASON) -> windows_core::HRESULT,
}
pub trait IAccessibilityDockingServiceCallback_Impl: windows_core::IUnknownImpl {
    fn Undocked(&self, undockreason: UNDOCK_REASON) -> windows_core::Result<()>;
}
impl IAccessibilityDockingServiceCallback_Vtbl {
    pub const fn new<Identity: IAccessibilityDockingServiceCallback_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn Undocked<Identity: IAccessibilityDockingServiceCallback_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, undockreason: UNDOCK_REASON) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAccessibilityDockingServiceCallback_Impl::Undocked(this, core::mem::transmute_copy(&undockreason)).into()
            }
        }
        Self { base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(), Undocked: Undocked::<Identity, OFFSET> }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAccessibilityDockingServiceCallback as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IAccessibilityDockingServiceCallback {}
windows_core::imp::define_interface!(IAccessibleObject, IAccessibleObject_Vtbl, 0x95a391c5_9ed4_4c28_8401_ab9e06719e11);
windows_core::imp::interface_hierarchy!(IAccessibleObject, windows_core::IUnknown);
impl IAccessibleObject {
    pub unsafe fn SetAccessibleName<P0>(&self, pszname: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).SetAccessibleName)(windows_core::Interface::as_raw(self), pszname.param().abi()).ok() }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAccessibleObject_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub SetAccessibleName: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
}
pub trait IAccessibleObject_Impl: windows_core::IUnknownImpl {
    fn SetAccessibleName(&self, pszname: &windows_core::PCWSTR) -> windows_core::Result<()>;
}
impl IAccessibleObject_Vtbl {
    pub const fn new<Identity: IAccessibleObject_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn SetAccessibleName<Identity: IAccessibleObject_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pszname: windows_core::PCWSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAccessibleObject_Impl::SetAccessibleName(this, core::mem::transmute(&pszname)).into()
            }
        }
        Self { base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(), SetAccessibleName: SetAccessibleName::<Identity, OFFSET> }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAccessibleObject as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IAccessibleObject {}
windows_core::imp::define_interface!(IActionProgress, IActionProgress_Vtbl, 0x49ff1173_eadc_446d_9285_156453a6431c);
windows_core::imp::interface_hierarchy!(IActionProgress, windows_core::IUnknown);
impl IActionProgress {
    pub unsafe fn Begin(&self, action: SPACTION, flags: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).Begin)(windows_core::Interface::as_raw(self), action, flags).ok() }
    }
    pub unsafe fn UpdateProgress(&self, ulcompleted: u64, ultotal: u64) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).UpdateProgress)(windows_core::Interface::as_raw(self), ulcompleted, ultotal).ok() }
    }
    pub unsafe fn UpdateText<P1>(&self, sptext: SPTEXT, psztext: P1, fmaycompact: bool) -> windows_core::Result<()>
    where
        P1: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).UpdateText)(windows_core::Interface::as_raw(self), sptext, psztext.param().abi(), fmaycompact.into()).ok() }
    }
    pub unsafe fn QueryCancel(&self) -> windows_core::Result<windows_core::BOOL> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).QueryCancel)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn ResetCancel(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).ResetCancel)(windows_core::Interface::as_raw(self)).ok() }
    }
    pub unsafe fn End(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).End)(windows_core::Interface::as_raw(self)).ok() }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IActionProgress_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub Begin: unsafe extern "system" fn(*mut core::ffi::c_void, SPACTION, u32) -> windows_core::HRESULT,
    pub UpdateProgress: unsafe extern "system" fn(*mut core::ffi::c_void, u64, u64) -> windows_core::HRESULT,
    pub UpdateText: unsafe extern "system" fn(*mut core::ffi::c_void, SPTEXT, windows_core::PCWSTR, windows_core::BOOL) -> windows_core::HRESULT,
    pub QueryCancel: unsafe extern "system" fn(*mut core::ffi::c_void, *mut windows_core::BOOL) -> windows_core::HRESULT,
    pub ResetCancel: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub End: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
}
pub trait IActionProgress_Impl: windows_core::IUnknownImpl {
    fn Begin(&self, action: SPACTION, flags: u32) -> windows_core::Result<()>;
    fn UpdateProgress(&self, ulcompleted: u64, ultotal: u64) -> windows_core::Result<()>;
    fn UpdateText(&self, sptext: SPTEXT, psztext: &windows_core::PCWSTR, fmaycompact: windows_core::BOOL) -> windows_core::Result<()>;
    fn QueryCancel(&self) -> windows_core::Result<windows_core::BOOL>;
    fn ResetCancel(&self) -> windows_core::Result<()>;
    fn End(&self) -> windows_core::Result<()>;
}
impl IActionProgress_Vtbl {
    pub const fn new<Identity: IActionProgress_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn Begin<Identity: IActionProgress_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, action: SPACTION, flags: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IActionProgress_Impl::Begin(this, core::mem::transmute_copy(&action), core::mem::transmute_copy(&flags)).into()
            }
        }
        unsafe extern "system" fn UpdateProgress<Identity: IActionProgress_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ulcompleted: u64, ultotal: u64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IActionProgress_Impl::UpdateProgress(this, core::mem::transmute_copy(&ulcompleted), core::mem::transmute_copy(&ultotal)).into()
            }
        }
        unsafe extern "system" fn UpdateText<Identity: IActionProgress_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, sptext: SPTEXT, psztext: windows_core::PCWSTR, fmaycompact: windows_core::BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IActionProgress_Impl::UpdateText(this, core::mem::transmute_copy(&sptext), core::mem::transmute(&psztext), core::mem::transmute_copy(&fmaycompact)).into()
            }
        }
        unsafe extern "system" fn QueryCancel<Identity: IActionProgress_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pfcancelled: *mut windows_core::BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IActionProgress_Impl::QueryCancel(this) {
                    Ok(ok__) => {
                        pfcancelled.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn ResetCancel<Identity: IActionProgress_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IActionProgress_Impl::ResetCancel(this).into()
            }
        }
        unsafe extern "system" fn End<Identity: IActionProgress_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IActionProgress_Impl::End(this).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            Begin: Begin::<Identity, OFFSET>,
            UpdateProgress: UpdateProgress::<Identity, OFFSET>,
            UpdateText: UpdateText::<Identity, OFFSET>,
            QueryCancel: QueryCancel::<Identity, OFFSET>,
            ResetCancel: ResetCancel::<Identity, OFFSET>,
            End: End::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IActionProgress as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IActionProgress {}
windows_core::imp::define_interface!(IActionProgressDialog, IActionProgressDialog_Vtbl, 0x49ff1172_eadc_446d_9285_156453a6431c);
windows_core::imp::interface_hierarchy!(IActionProgressDialog, windows_core::IUnknown);
impl IActionProgressDialog {
    pub unsafe fn Initialize<P1, P2>(&self, flags: u32, psztitle: P1, pszcancel: P2) -> windows_core::Result<()>
    where
        P1: windows_core::Param<windows_core::PCWSTR>,
        P2: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).Initialize)(windows_core::Interface::as_raw(self), flags, psztitle.param().abi(), pszcancel.param().abi()).ok() }
    }
    pub unsafe fn Stop(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).Stop)(windows_core::Interface::as_raw(self)).ok() }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IActionProgressDialog_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub Initialize: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCWSTR, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub Stop: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
}
pub trait IActionProgressDialog_Impl: windows_core::IUnknownImpl {
    fn Initialize(&self, flags: u32, psztitle: &windows_core::PCWSTR, pszcancel: &windows_core::PCWSTR) -> windows_core::Result<()>;
    fn Stop(&self) -> windows_core::Result<()>;
}
impl IActionProgressDialog_Vtbl {
    pub const fn new<Identity: IActionProgressDialog_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn Initialize<Identity: IActionProgressDialog_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, flags: u32, psztitle: windows_core::PCWSTR, pszcancel: windows_core::PCWSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IActionProgressDialog_Impl::Initialize(this, core::mem::transmute_copy(&flags), core::mem::transmute(&psztitle), core::mem::transmute(&pszcancel)).into()
            }
        }
        unsafe extern "system" fn Stop<Identity: IActionProgressDialog_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IActionProgressDialog_Impl::Stop(this).into()
            }
        }
        Self { base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(), Initialize: Initialize::<Identity, OFFSET>, Stop: Stop::<Identity, OFFSET> }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IActionProgressDialog as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IActionProgressDialog {}
windows_core::imp::define_interface!(IAppActivationUIInfo, IAppActivationUIInfo_Vtbl, 0xabad189d_9fa3_4278_b3ca_8ca448a88dcb);
windows_core::imp::interface_hierarchy!(IAppActivationUIInfo, windows_core::IUnknown);
impl IAppActivationUIInfo {
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn GetMonitor(&self) -> windows_core::Result<super::super::Graphics::Gdi::HMONITOR> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetMonitor)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetInvokePoint(&self) -> windows_core::Result<super::super::Foundation::POINT> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetInvokePoint)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetShowCommand(&self) -> windows_core::Result<i32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetShowCommand)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetShowUI(&self) -> windows_core::Result<windows_core::BOOL> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetShowUI)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetKeyState(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetKeyState)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAppActivationUIInfo_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub GetMonitor: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Graphics::Gdi::HMONITOR) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))]
    GetMonitor: usize,
    pub GetInvokePoint: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Foundation::POINT) -> windows_core::HRESULT,
    pub GetShowCommand: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub GetShowUI: unsafe extern "system" fn(*mut core::ffi::c_void, *mut windows_core::BOOL) -> windows_core::HRESULT,
    pub GetKeyState: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
}
#[cfg(feature = "Win32_Graphics_Gdi")]
pub trait IAppActivationUIInfo_Impl: windows_core::IUnknownImpl {
    fn GetMonitor(&self) -> windows_core::Result<super::super::Graphics::Gdi::HMONITOR>;
    fn GetInvokePoint(&self) -> windows_core::Result<super::super::Foundation::POINT>;
    fn GetShowCommand(&self) -> windows_core::Result<i32>;
    fn GetShowUI(&self) -> windows_core::Result<windows_core::BOOL>;
    fn GetKeyState(&self) -> windows_core::Result<u32>;
}
#[cfg(feature = "Win32_Graphics_Gdi")]
impl IAppActivationUIInfo_Vtbl {
    pub const fn new<Identity: IAppActivationUIInfo_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetMonitor<Identity: IAppActivationUIInfo_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, value: *mut super::super::Graphics::Gdi::HMONITOR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAppActivationUIInfo_Impl::GetMonitor(this) {
                    Ok(ok__) => {
                        value.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetInvokePoint<Identity: IAppActivationUIInfo_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, value: *mut super::super::Foundation::POINT) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAppActivationUIInfo_Impl::GetInvokePoint(this) {
                    Ok(ok__) => {
                        value.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetShowCommand<Identity: IAppActivationUIInfo_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, value: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAppActivationUIInfo_Impl::GetShowCommand(this) {
                    Ok(ok__) => {
                        value.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetShowUI<Identity: IAppActivationUIInfo_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, value: *mut windows_core::BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAppActivationUIInfo_Impl::GetShowUI(this) {
                    Ok(ok__) => {
                        value.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetKeyState<Identity: IAppActivationUIInfo_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, value: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAppActivationUIInfo_Impl::GetKeyState(this) {
                    Ok(ok__) => {
                        value.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            GetMonitor: GetMonitor::<Identity, OFFSET>,
            GetInvokePoint: GetInvokePoint::<Identity, OFFSET>,
            GetShowCommand: GetShowCommand::<Identity, OFFSET>,
            GetShowUI: GetShowUI::<Identity, OFFSET>,
            GetKeyState: GetKeyState::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAppActivationUIInfo as windows_core::Interface>::IID
    }
}
#[cfg(feature = "Win32_Graphics_Gdi")]
impl windows_core::RuntimeName for IAppActivationUIInfo {}
windows_core::imp::define_interface!(IAppPublisher, IAppPublisher_Vtbl, 0x07250a10_9cf9_11d1_9076_006008059382);
windows_core::imp::interface_hierarchy!(IAppPublisher, windows_core::IUnknown);
impl IAppPublisher {
    pub unsafe fn GetNumberOfCategories(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetNumberOfCategories)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetCategories(&self) -> windows_core::Result<APPCATEGORYINFOLIST> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetCategories)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetNumberOfApps(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetNumberOfApps)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn EnumApps(&self, pappcategoryid: *const windows_core::GUID) -> windows_core::Result<IEnumPublishedApps> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).EnumApps)(windows_core::Interface::as_raw(self), pappcategoryid, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAppPublisher_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetNumberOfCategories: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetCategories: unsafe extern "system" fn(*mut core::ffi::c_void, *mut APPCATEGORYINFOLIST) -> windows_core::HRESULT,
    pub GetNumberOfApps: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub EnumApps: unsafe extern "system" fn(*mut core::ffi::c_void, *const windows_core::GUID, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
pub trait IAppPublisher_Impl: windows_core::IUnknownImpl {
    fn GetNumberOfCategories(&self) -> windows_core::Result<u32>;
    fn GetCategories(&self) -> windows_core::Result<APPCATEGORYINFOLIST>;
    fn GetNumberOfApps(&self) -> windows_core::Result<u32>;
    fn EnumApps(&self, pappcategoryid: *const windows_core::GUID) -> windows_core::Result<IEnumPublishedApps>;
}
impl IAppPublisher_Vtbl {
    pub const fn new<Identity: IAppPublisher_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetNumberOfCategories<Identity: IAppPublisher_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pdwcat: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAppPublisher_Impl::GetNumberOfCategories(this) {
                    Ok(ok__) => {
                        pdwcat.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetCategories<Identity: IAppPublisher_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pappcategorylist: *mut APPCATEGORYINFOLIST) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAppPublisher_Impl::GetCategories(this) {
                    Ok(ok__) => {
                        pappcategorylist.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetNumberOfApps<Identity: IAppPublisher_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pdwapps: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAppPublisher_Impl::GetNumberOfApps(this) {
                    Ok(ok__) => {
                        pdwapps.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn EnumApps<Identity: IAppPublisher_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pappcategoryid: *const windows_core::GUID, ppepa: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAppPublisher_Impl::EnumApps(this, core::mem::transmute_copy(&pappcategoryid)) {
                    Ok(ok__) => {
                        ppepa.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            GetNumberOfCategories: GetNumberOfCategories::<Identity, OFFSET>,
            GetCategories: GetCategories::<Identity, OFFSET>,
            GetNumberOfApps: GetNumberOfApps::<Identity, OFFSET>,
            EnumApps: EnumApps::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAppPublisher as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IAppPublisher {}
windows_core::imp::define_interface!(IAppVisibility, IAppVisibility_Vtbl, 0x2246ea2d_caea_4444_a3c4_6de827e44313);
windows_core::imp::interface_hierarchy!(IAppVisibility, windows_core::IUnknown);
impl IAppVisibility {
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn GetAppVisibilityOnMonitor(&self, hmonitor: super::super::Graphics::Gdi::HMONITOR) -> windows_core::Result<MONITOR_APP_VISIBILITY> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetAppVisibilityOnMonitor)(windows_core::Interface::as_raw(self), hmonitor, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn IsLauncherVisible(&self) -> windows_core::Result<windows_core::BOOL> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).IsLauncherVisible)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn Advise<P0>(&self, pcallback: P0) -> windows_core::Result<u32>
    where
        P0: windows_core::Param<IAppVisibilityEvents>,
    {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).Advise)(windows_core::Interface::as_raw(self), pcallback.param().abi(), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn Unadvise(&self, dwcookie: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).Unadvise)(windows_core::Interface::as_raw(self), dwcookie).ok() }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAppVisibility_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub GetAppVisibilityOnMonitor: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Graphics::Gdi::HMONITOR, *mut MONITOR_APP_VISIBILITY) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))]
    GetAppVisibilityOnMonitor: usize,
    pub IsLauncherVisible: unsafe extern "system" fn(*mut core::ffi::c_void, *mut windows_core::BOOL) -> windows_core::HRESULT,
    pub Advise: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub Unadvise: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
}
#[cfg(feature = "Win32_Graphics_Gdi")]
pub trait IAppVisibility_Impl: windows_core::IUnknownImpl {
    fn GetAppVisibilityOnMonitor(&self, hmonitor: super::super::Graphics::Gdi::HMONITOR) -> windows_core::Result<MONITOR_APP_VISIBILITY>;
    fn IsLauncherVisible(&self) -> windows_core::Result<windows_core::BOOL>;
    fn Advise(&self, pcallback: windows_core::Ref<IAppVisibilityEvents>) -> windows_core::Result<u32>;
    fn Unadvise(&self, dwcookie: u32) -> windows_core::Result<()>;
}
#[cfg(feature = "Win32_Graphics_Gdi")]
impl IAppVisibility_Vtbl {
    pub const fn new<Identity: IAppVisibility_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetAppVisibilityOnMonitor<Identity: IAppVisibility_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, hmonitor: super::super::Graphics::Gdi::HMONITOR, pmode: *mut MONITOR_APP_VISIBILITY) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAppVisibility_Impl::GetAppVisibilityOnMonitor(this, core::mem::transmute_copy(&hmonitor)) {
                    Ok(ok__) => {
                        pmode.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn IsLauncherVisible<Identity: IAppVisibility_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pfvisible: *mut windows_core::BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAppVisibility_Impl::IsLauncherVisible(this) {
                    Ok(ok__) => {
                        pfvisible.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn Advise<Identity: IAppVisibility_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pcallback: *mut core::ffi::c_void, pdwcookie: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAppVisibility_Impl::Advise(this, core::mem::transmute_copy(&pcallback)) {
                    Ok(ok__) => {
                        pdwcookie.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn Unadvise<Identity: IAppVisibility_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwcookie: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAppVisibility_Impl::Unadvise(this, core::mem::transmute_copy(&dwcookie)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            GetAppVisibilityOnMonitor: GetAppVisibilityOnMonitor::<Identity, OFFSET>,
            IsLauncherVisible: IsLauncherVisible::<Identity, OFFSET>,
            Advise: Advise::<Identity, OFFSET>,
            Unadvise: Unadvise::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAppVisibility as windows_core::Interface>::IID
    }
}
#[cfg(feature = "Win32_Graphics_Gdi")]
impl windows_core::RuntimeName for IAppVisibility {}
windows_core::imp::define_interface!(IAppVisibilityEvents, IAppVisibilityEvents_Vtbl, 0x6584ce6b_7d82_49c2_89c9_c6bc02ba8c38);
windows_core::imp::interface_hierarchy!(IAppVisibilityEvents, windows_core::IUnknown);
impl IAppVisibilityEvents {
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn AppVisibilityOnMonitorChanged(&self, hmonitor: super::super::Graphics::Gdi::HMONITOR, previousmode: MONITOR_APP_VISIBILITY, currentmode: MONITOR_APP_VISIBILITY) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).AppVisibilityOnMonitorChanged)(windows_core::Interface::as_raw(self), hmonitor, previousmode, currentmode).ok() }
    }
    pub unsafe fn LauncherVisibilityChange(&self, currentvisiblestate: bool) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).LauncherVisibilityChange)(windows_core::Interface::as_raw(self), currentvisiblestate.into()).ok() }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAppVisibilityEvents_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub AppVisibilityOnMonitorChanged: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Graphics::Gdi::HMONITOR, MONITOR_APP_VISIBILITY, MONITOR_APP_VISIBILITY) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))]
    AppVisibilityOnMonitorChanged: usize,
    pub LauncherVisibilityChange: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::BOOL) -> windows_core::HRESULT,
}
#[cfg(feature = "Win32_Graphics_Gdi")]
pub trait IAppVisibilityEvents_Impl: windows_core::IUnknownImpl {
    fn AppVisibilityOnMonitorChanged(&self, hmonitor: super::super::Graphics::Gdi::HMONITOR, previousmode: MONITOR_APP_VISIBILITY, currentmode: MONITOR_APP_VISIBILITY) -> windows_core::Result<()>;
    fn LauncherVisibilityChange(&self, currentvisiblestate: windows_core::BOOL) -> windows_core::Result<()>;
}
#[cfg(feature = "Win32_Graphics_Gdi")]
impl IAppVisibilityEvents_Vtbl {
    pub const fn new<Identity: IAppVisibilityEvents_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn AppVisibilityOnMonitorChanged<Identity: IAppVisibilityEvents_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, hmonitor: super::super::Graphics::Gdi::HMONITOR, previousmode: MONITOR_APP_VISIBILITY, currentmode: MONITOR_APP_VISIBILITY) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAppVisibilityEvents_Impl::AppVisibilityOnMonitorChanged(this, core::mem::transmute_copy(&hmonitor), core::mem::transmute_copy(&previousmode), core::mem::transmute_copy(&currentmode)).into()
            }
        }
        unsafe extern "system" fn LauncherVisibilityChange<Identity: IAppVisibilityEvents_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, currentvisiblestate: windows_core::BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAppVisibilityEvents_Impl::LauncherVisibilityChange(this, core::mem::transmute_copy(&currentvisiblestate)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            AppVisibilityOnMonitorChanged: AppVisibilityOnMonitorChanged::<Identity, OFFSET>,
            LauncherVisibilityChange: LauncherVisibilityChange::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAppVisibilityEvents as windows_core::Interface>::IID
    }
}
#[cfg(feature = "Win32_Graphics_Gdi")]
impl windows_core::RuntimeName for IAppVisibilityEvents {}
windows_core::imp::define_interface!(IApplicationActivationManager, IApplicationActivationManager_Vtbl, 0x2e941141_7f97_4756_ba1d_9decde894a3d);
windows_core::imp::interface_hierarchy!(IApplicationActivationManager, windows_core::IUnknown);
impl IApplicationActivationManager {
    pub unsafe fn ActivateApplication<P0, P1>(&self, appusermodelid: P0, arguments: P1, options: ACTIVATEOPTIONS) -> windows_core::Result<u32>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
        P1: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).ActivateApplication)(windows_core::Interface::as_raw(self), appusermodelid.param().abi(), arguments.param().abi(), options, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn ActivateForFile<P0, P1, P2>(&self, appusermodelid: P0, itemarray: P1, verb: P2) -> windows_core::Result<u32>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
        P1: windows_core::Param<IShellItemArray>,
        P2: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).ActivateForFile)(windows_core::Interface::as_raw(self), appusermodelid.param().abi(), itemarray.param().abi(), verb.param().abi(), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn ActivateForProtocol<P0, P1>(&self, appusermodelid: P0, itemarray: P1) -> windows_core::Result<u32>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
        P1: windows_core::Param<IShellItemArray>,
    {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).ActivateForProtocol)(windows_core::Interface::as_raw(self), appusermodelid.param().abi(), itemarray.param().abi(), &mut result__).map(|| result__)
        }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IApplicationActivationManager_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub ActivateApplication: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, windows_core::PCWSTR, ACTIVATEOPTIONS, *mut u32) -> windows_core::HRESULT,
    pub ActivateForFile: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, *mut core::ffi::c_void, windows_core::PCWSTR, *mut u32) -> windows_core::HRESULT,
    pub ActivateForProtocol: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, *mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
}
pub trait IApplicationActivationManager_Impl: windows_core::IUnknownImpl {
    fn ActivateApplication(&self, appusermodelid: &windows_core::PCWSTR, arguments: &windows_core::PCWSTR, options: ACTIVATEOPTIONS) -> windows_core::Result<u32>;
    fn ActivateForFile(&self, appusermodelid: &windows_core::PCWSTR, itemarray: windows_core::Ref<IShellItemArray>, verb: &windows_core::PCWSTR) -> windows_core::Result<u32>;
    fn ActivateForProtocol(&self, appusermodelid: &windows_core::PCWSTR, itemarray: windows_core::Ref<IShellItemArray>) -> windows_core::Result<u32>;
}
impl IApplicationActivationManager_Vtbl {
    pub const fn new<Identity: IApplicationActivationManager_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn ActivateApplication<Identity: IApplicationActivationManager_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, appusermodelid: windows_core::PCWSTR, arguments: windows_core::PCWSTR, options: ACTIVATEOPTIONS, processid: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IApplicationActivationManager_Impl::ActivateApplication(this, core::mem::transmute(&appusermodelid), core::mem::transmute(&arguments), core::mem::transmute_copy(&options)) {
                    Ok(ok__) => {
                        processid.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn ActivateForFile<Identity: IApplicationActivationManager_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, appusermodelid: windows_core::PCWSTR, itemarray: *mut core::ffi::c_void, verb: windows_core::PCWSTR, processid: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IApplicationActivationManager_Impl::ActivateForFile(this, core::mem::transmute(&appusermodelid), core::mem::transmute_copy(&itemarray), core::mem::transmute(&verb)) {
                    Ok(ok__) => {
                        processid.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn ActivateForProtocol<Identity: IApplicationActivationManager_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, appusermodelid: windows_core::PCWSTR, itemarray: *mut core::ffi::c_void, processid: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IApplicationActivationManager_Impl::ActivateForProtocol(this, core::mem::transmute(&appusermodelid), core::mem::transmute_copy(&itemarray)) {
                    Ok(ok__) => {
                        processid.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            ActivateApplication: ActivateApplication::<Identity, OFFSET>,
            ActivateForFile: ActivateForFile::<Identity, OFFSET>,
            ActivateForProtocol: ActivateForProtocol::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IApplicationActivationManager as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IApplicationActivationManager {}
windows_core::imp::define_interface!(IApplicationAssociationRegistration, IApplicationAssociationRegistration_Vtbl, 0x4e530b0a_e611_4c77_a3ac_9031d022281b);
windows_core::imp::interface_hierarchy!(IApplicationAssociationRegistration, windows_core::IUnknown);
impl IApplicationAssociationRegistration {
    pub unsafe fn QueryCurrentDefault<P0>(&self, pszquery: P0, atquerytype: ASSOCIATIONTYPE, alquerylevel: ASSOCIATIONLEVEL) -> windows_core::Result<windows_core::PWSTR>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).QueryCurrentDefault)(windows_core::Interface::as_raw(self), pszquery.param().abi(), atquerytype, alquerylevel, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn QueryAppIsDefault<P0, P3>(&self, pszquery: P0, atquerytype: ASSOCIATIONTYPE, alquerylevel: ASSOCIATIONLEVEL, pszappregistryname: P3) -> windows_core::Result<windows_core::BOOL>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
        P3: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).QueryAppIsDefault)(windows_core::Interface::as_raw(self), pszquery.param().abi(), atquerytype, alquerylevel, pszappregistryname.param().abi(), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn QueryAppIsDefaultAll<P1>(&self, alquerylevel: ASSOCIATIONLEVEL, pszappregistryname: P1) -> windows_core::Result<windows_core::BOOL>
    where
        P1: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).QueryAppIsDefaultAll)(windows_core::Interface::as_raw(self), alquerylevel, pszappregistryname.param().abi(), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetAppAsDefault<P0, P1>(&self, pszappregistryname: P0, pszset: P1, atsettype: ASSOCIATIONTYPE) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
        P1: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).SetAppAsDefault)(windows_core::Interface::as_raw(self), pszappregistryname.param().abi(), pszset.param().abi(), atsettype).ok() }
    }
    pub unsafe fn SetAppAsDefaultAll<P0>(&self, pszappregistryname: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).SetAppAsDefaultAll)(windows_core::Interface::as_raw(self), pszappregistryname.param().abi()).ok() }
    }
    pub unsafe fn ClearUserAssociations(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).ClearUserAssociations)(windows_core::Interface::as_raw(self)).ok() }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IApplicationAssociationRegistration_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub QueryCurrentDefault: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, ASSOCIATIONTYPE, ASSOCIATIONLEVEL, *mut windows_core::PWSTR) -> windows_core::HRESULT,
    pub QueryAppIsDefault: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, ASSOCIATIONTYPE, ASSOCIATIONLEVEL, windows_core::PCWSTR, *mut windows_core::BOOL) -> windows_core::HRESULT,
    pub QueryAppIsDefaultAll: unsafe extern "system" fn(*mut core::ffi::c_void, ASSOCIATIONLEVEL, windows_core::PCWSTR, *mut windows_core::BOOL) -> windows_core::HRESULT,
    pub SetAppAsDefault: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, windows_core::PCWSTR, ASSOCIATIONTYPE) -> windows_core::HRESULT,
    pub SetAppAsDefaultAll: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub ClearUserAssociations: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
}
pub trait IApplicationAssociationRegistration_Impl: windows_core::IUnknownImpl {
    fn QueryCurrentDefault(&self, pszquery: &windows_core::PCWSTR, atquerytype: ASSOCIATIONTYPE, alquerylevel: ASSOCIATIONLEVEL) -> windows_core::Result<windows_core::PWSTR>;
    fn QueryAppIsDefault(&self, pszquery: &windows_core::PCWSTR, atquerytype: ASSOCIATIONTYPE, alquerylevel: ASSOCIATIONLEVEL, pszappregistryname: &windows_core::PCWSTR) -> windows_core::Result<windows_core::BOOL>;
    fn QueryAppIsDefaultAll(&self, alquerylevel: ASSOCIATIONLEVEL, pszappregistryname: &windows_core::PCWSTR) -> windows_core::Result<windows_core::BOOL>;
    fn SetAppAsDefault(&self, pszappregistryname: &windows_core::PCWSTR, pszset: &windows_core::PCWSTR, atsettype: ASSOCIATIONTYPE) -> windows_core::Result<()>;
    fn SetAppAsDefaultAll(&self, pszappregistryname: &windows_core::PCWSTR) -> windows_core::Result<()>;
    fn ClearUserAssociations(&self) -> windows_core::Result<()>;
}
impl IApplicationAssociationRegistration_Vtbl {
    pub const fn new<Identity: IApplicationAssociationRegistration_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn QueryCurrentDefault<Identity: IApplicationAssociationRegistration_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pszquery: windows_core::PCWSTR, atquerytype: ASSOCIATIONTYPE, alquerylevel: ASSOCIATIONLEVEL, ppszassociation: *mut windows_core::PWSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IApplicationAssociationRegistration_Impl::QueryCurrentDefault(this, core::mem::transmute(&pszquery), core::mem::transmute_copy(&atquerytype), core::mem::transmute_copy(&alquerylevel)) {
                    Ok(ok__) => {
                        ppszassociation.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn QueryAppIsDefault<Identity: IApplicationAssociationRegistration_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pszquery: windows_core::PCWSTR, atquerytype: ASSOCIATIONTYPE, alquerylevel: ASSOCIATIONLEVEL, pszappregistryname: windows_core::PCWSTR, pfdefault: *mut windows_core::BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IApplicationAssociationRegistration_Impl::QueryAppIsDefault(this, core::mem::transmute(&pszquery), core::mem::transmute_copy(&atquerytype), core::mem::transmute_copy(&alquerylevel), core::mem::transmute(&pszappregistryname)) {
                    Ok(ok__) => {
                        pfdefault.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn QueryAppIsDefaultAll<Identity: IApplicationAssociationRegistration_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, alquerylevel: ASSOCIATIONLEVEL, pszappregistryname: windows_core::PCWSTR, pfdefault: *mut windows_core::BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IApplicationAssociationRegistration_Impl::QueryAppIsDefaultAll(this, core::mem::transmute_copy(&alquerylevel), core::mem::transmute(&pszappregistryname)) {
                    Ok(ok__) => {
                        pfdefault.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetAppAsDefault<Identity: IApplicationAssociationRegistration_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pszappregistryname: windows_core::PCWSTR, pszset: windows_core::PCWSTR, atsettype: ASSOCIATIONTYPE) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IApplicationAssociationRegistration_Impl::SetAppAsDefault(this, core::mem::transmute(&pszappregistryname), core::mem::transmute(&pszset), core::mem::transmute_copy(&atsettype)).into()
            }
        }
        unsafe extern "system" fn SetAppAsDefaultAll<Identity: IApplicationAssociationRegistration_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pszappregistryname: windows_core::PCWSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IApplicationAssociationRegistration_Impl::SetAppAsDefaultAll(this, core::mem::transmute(&pszappregistryname)).into()
            }
        }
        unsafe extern "system" fn ClearUserAssociations<Identity: IApplicationAssociationRegistration_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IApplicationAssociationRegistration_Impl::ClearUserAssociations(this).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            QueryCurrentDefault: QueryCurrentDefault::<Identity, OFFSET>,
            QueryAppIsDefault: QueryAppIsDefault::<Identity, OFFSET>,
            QueryAppIsDefaultAll: QueryAppIsDefaultAll::<Identity, OFFSET>,
            SetAppAsDefault: SetAppAsDefault::<Identity, OFFSET>,
            SetAppAsDefaultAll: SetAppAsDefaultAll::<Identity, OFFSET>,
            ClearUserAssociations: ClearUserAssociations::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IApplicationAssociationRegistration as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IApplicationAssociationRegistration {}
windows_core::imp::define_interface!(IApplicationAssociationRegistrationUI, IApplicationAssociationRegistrationUI_Vtbl, 0x1f76a169_f994_40ac_8fc8_0959e8874710);
windows_core::imp::interface_hierarchy!(IApplicationAssociationRegistrationUI, windows_core::IUnknown);
impl IApplicationAssociationRegistrationUI {
    pub unsafe fn LaunchAdvancedAssociationUI<P0>(&self, pszappregistryname: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).LaunchAdvancedAssociationUI)(windows_core::Interface::as_raw(self), pszappregistryname.param().abi()).ok() }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IApplicationAssociationRegistrationUI_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub LaunchAdvancedAssociationUI: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
}
pub trait IApplicationAssociationRegistrationUI_Impl: windows_core::IUnknownImpl {
    fn LaunchAdvancedAssociationUI(&self, pszappregistryname: &windows_core::PCWSTR) -> windows_core::Result<()>;
}
impl IApplicationAssociationRegistrationUI_Vtbl {
    pub const fn new<Identity: IApplicationAssociationRegistrationUI_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn LaunchAdvancedAssociationUI<Identity: IApplicationAssociationRegistrationUI_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pszappregistryname: windows_core::PCWSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IApplicationAssociationRegistrationUI_Impl::LaunchAdvancedAssociationUI(this, core::mem::transmute(&pszappregistryname)).into()
            }
        }
        Self { base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(), LaunchAdvancedAssociationUI: LaunchAdvancedAssociationUI::<Identity, OFFSET> }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IApplicationAssociationRegistrationUI as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IApplicationAssociationRegistrationUI {}
windows_core::imp::define_interface!(IApplicationDesignModeSettings, IApplicationDesignModeSettings_Vtbl, 0x2a3dee9a_e31d_46d6_8508_bcc597db3557);
windows_core::imp::interface_hierarchy!(IApplicationDesignModeSettings, windows_core::IUnknown);
impl IApplicationDesignModeSettings {
    pub unsafe fn SetNativeDisplaySize(&self, nativedisplaysizepixels: super::super::Foundation::SIZE) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetNativeDisplaySize)(windows_core::Interface::as_raw(self), core::mem::transmute(nativedisplaysizepixels)).ok() }
    }
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn SetScaleFactor(&self, scalefactor: Common::DEVICE_SCALE_FACTOR) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetScaleFactor)(windows_core::Interface::as_raw(self), scalefactor).ok() }
    }
    pub unsafe fn SetApplicationViewState(&self, viewstate: APPLICATION_VIEW_STATE) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetApplicationViewState)(windows_core::Interface::as_raw(self), viewstate).ok() }
    }
    pub unsafe fn ComputeApplicationSize(&self) -> windows_core::Result<super::super::Foundation::SIZE> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).ComputeApplicationSize)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn IsApplicationViewStateSupported(&self, viewstate: APPLICATION_VIEW_STATE, nativedisplaysizepixels: super::super::Foundation::SIZE, scalefactor: Common::DEVICE_SCALE_FACTOR) -> windows_core::Result<windows_core::BOOL> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).IsApplicationViewStateSupported)(windows_core::Interface::as_raw(self), viewstate, core::mem::transmute(nativedisplaysizepixels), scalefactor, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn TriggerEdgeGesture(&self, edgegesturekind: EDGE_GESTURE_KIND) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).TriggerEdgeGesture)(windows_core::Interface::as_raw(self), edgegesturekind).ok() }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IApplicationDesignModeSettings_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub SetNativeDisplaySize: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::SIZE) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub SetScaleFactor: unsafe extern "system" fn(*mut core::ffi::c_void, Common::DEVICE_SCALE_FACTOR) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_Common"))]
    SetScaleFactor: usize,
    pub SetApplicationViewState: unsafe extern "system" fn(*mut core::ffi::c_void, APPLICATION_VIEW_STATE) -> windows_core::HRESULT,
    pub ComputeApplicationSize: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Foundation::SIZE) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub IsApplicationViewStateSupported: unsafe extern "system" fn(*mut core::ffi::c_void, APPLICATION_VIEW_STATE, super::super::Foundation::SIZE, Common::DEVICE_SCALE_FACTOR, *mut windows_core::BOOL) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_Common"))]
    IsApplicationViewStateSupported: usize,
    pub TriggerEdgeGesture: unsafe extern "system" fn(*mut core::ffi::c_void, EDGE_GESTURE_KIND) -> windows_core::HRESULT,
}
#[cfg(feature = "Win32_UI_Shell_Common")]
pub trait IApplicationDesignModeSettings_Impl: windows_core::IUnknownImpl {
    fn SetNativeDisplaySize(&self, nativedisplaysizepixels: &super::super::Foundation::SIZE) -> windows_core::Result<()>;
    fn SetScaleFactor(&self, scalefactor: Common::DEVICE_SCALE_FACTOR) -> windows_core::Result<()>;
    fn SetApplicationViewState(&self, viewstate: APPLICATION_VIEW_STATE) -> windows_core::Result<()>;
    fn ComputeApplicationSize(&self) -> windows_core::Result<super::super::Foundation::SIZE>;
    fn IsApplicationViewStateSupported(&self, viewstate: APPLICATION_VIEW_STATE, nativedisplaysizepixels: &super::super::Foundation::SIZE, scalefactor: Common::DEVICE_SCALE_FACTOR) -> windows_core::Result<windows_core::BOOL>;
    fn TriggerEdgeGesture(&self, edgegesturekind: EDGE_GESTURE_KIND) -> windows_core::Result<()>;
}
#[cfg(feature = "Win32_UI_Shell_Common")]
impl IApplicationDesignModeSettings_Vtbl {
    pub const fn new<Identity: IApplicationDesignModeSettings_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn SetNativeDisplaySize<Identity: IApplicationDesignModeSettings_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, nativedisplaysizepixels: super::super::Foundation::SIZE) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IApplicationDesignModeSettings_Impl::SetNativeDisplaySize(this, core::mem::transmute(&nativedisplaysizepixels)).into()
            }
        }
        unsafe extern "system" fn SetScaleFactor<Identity: IApplicationDesignModeSettings_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, scalefactor: Common::DEVICE_SCALE_FACTOR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IApplicationDesignModeSettings_Impl::SetScaleFactor(this, core::mem::transmute_copy(&scalefactor)).into()
            }
        }
        unsafe extern "system" fn SetApplicationViewState<Identity: IApplicationDesignModeSettings_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, viewstate: APPLICATION_VIEW_STATE) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IApplicationDesignModeSettings_Impl::SetApplicationViewState(this, core::mem::transmute_copy(&viewstate)).into()
            }
        }
        unsafe extern "system" fn ComputeApplicationSize<Identity: IApplicationDesignModeSettings_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, applicationsizepixels: *mut super::super::Foundation::SIZE) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IApplicationDesignModeSettings_Impl::ComputeApplicationSize(this) {
                    Ok(ok__) => {
                        applicationsizepixels.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn IsApplicationViewStateSupported<Identity: IApplicationDesignModeSettings_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, viewstate: APPLICATION_VIEW_STATE, nativedisplaysizepixels: super::super::Foundation::SIZE, scalefactor: Common::DEVICE_SCALE_FACTOR, supported: *mut windows_core::BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IApplicationDesignModeSettings_Impl::IsApplicationViewStateSupported(this, core::mem::transmute_copy(&viewstate), core::mem::transmute(&nativedisplaysizepixels), core::mem::transmute_copy(&scalefactor)) {
                    Ok(ok__) => {
                        supported.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn TriggerEdgeGesture<Identity: IApplicationDesignModeSettings_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, edgegesturekind: EDGE_GESTURE_KIND) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IApplicationDesignModeSettings_Impl::TriggerEdgeGesture(this, core::mem::transmute_copy(&edgegesturekind)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            SetNativeDisplaySize: SetNativeDisplaySize::<Identity, OFFSET>,
            SetScaleFactor: SetScaleFactor::<Identity, OFFSET>,
            SetApplicationViewState: SetApplicationViewState::<Identity, OFFSET>,
            ComputeApplicationSize: ComputeApplicationSize::<Identity, OFFSET>,
            IsApplicationViewStateSupported: IsApplicationViewStateSupported::<Identity, OFFSET>,
            TriggerEdgeGesture: TriggerEdgeGesture::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IApplicationDesignModeSettings as windows_core::Interface>::IID
    }
}
#[cfg(feature = "Win32_UI_Shell_Common")]
impl windows_core::RuntimeName for IApplicationDesignModeSettings {}
windows_core::imp::define_interface!(IApplicationDesignModeSettings2, IApplicationDesignModeSettings2_Vtbl, 0x490514e1_675a_4d6e_a58d_e54901b4ca2f);
impl core::ops::Deref for IApplicationDesignModeSettings2 {
    type Target = IApplicationDesignModeSettings;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IApplicationDesignModeSettings2, windows_core::IUnknown, IApplicationDesignModeSettings);
impl IApplicationDesignModeSettings2 {
    pub unsafe fn SetNativeDisplayOrientation(&self, nativedisplayorientation: NATIVE_DISPLAY_ORIENTATION) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetNativeDisplayOrientation)(windows_core::Interface::as_raw(self), nativedisplayorientation).ok() }
    }
    pub unsafe fn SetApplicationViewOrientation(&self, vieworientation: APPLICATION_VIEW_ORIENTATION) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetApplicationViewOrientation)(windows_core::Interface::as_raw(self), vieworientation).ok() }
    }
    pub unsafe fn SetAdjacentDisplayEdges(&self, adjacentdisplayedges: ADJACENT_DISPLAY_EDGES) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetAdjacentDisplayEdges)(windows_core::Interface::as_raw(self), adjacentdisplayedges).ok() }
    }
    pub unsafe fn SetIsOnLockScreen(&self, isonlockscreen: bool) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetIsOnLockScreen)(windows_core::Interface::as_raw(self), isonlockscreen.into()).ok() }
    }
    pub unsafe fn SetApplicationViewMinWidth(&self, viewminwidth: APPLICATION_VIEW_MIN_WIDTH) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetApplicationViewMinWidth)(windows_core::Interface::as_raw(self), viewminwidth).ok() }
    }
    pub unsafe fn GetApplicationSizeBounds(&self, minapplicationsizepixels: *mut super::super::Foundation::SIZE, maxapplicationsizepixels: *mut super::super::Foundation::SIZE) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetApplicationSizeBounds)(windows_core::Interface::as_raw(self), minapplicationsizepixels as _, maxapplicationsizepixels as _).ok() }
    }
    pub unsafe fn GetApplicationViewOrientation(&self, applicationsizepixels: super::super::Foundation::SIZE) -> windows_core::Result<APPLICATION_VIEW_ORIENTATION> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetApplicationViewOrientation)(windows_core::Interface::as_raw(self), core::mem::transmute(applicationsizepixels), &mut result__).map(|| result__)
        }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IApplicationDesignModeSettings2_Vtbl {
    pub base__: IApplicationDesignModeSettings_Vtbl,
    pub SetNativeDisplayOrientation: unsafe extern "system" fn(*mut core::ffi::c_void, NATIVE_DISPLAY_ORIENTATION) -> windows_core::HRESULT,
    pub SetApplicationViewOrientation: unsafe extern "system" fn(*mut core::ffi::c_void, APPLICATION_VIEW_ORIENTATION) -> windows_core::HRESULT,
    pub SetAdjacentDisplayEdges: unsafe extern "system" fn(*mut core::ffi::c_void, ADJACENT_DISPLAY_EDGES) -> windows_core::HRESULT,
    pub SetIsOnLockScreen: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::BOOL) -> windows_core::HRESULT,
    pub SetApplicationViewMinWidth: unsafe extern "system" fn(*mut core::ffi::c_void, APPLICATION_VIEW_MIN_WIDTH) -> windows_core::HRESULT,
    pub GetApplicationSizeBounds: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Foundation::SIZE, *mut super::super::Foundation::SIZE) -> windows_core::HRESULT,
    pub GetApplicationViewOrientation: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::SIZE, *mut APPLICATION_VIEW_ORIENTATION) -> windows_core::HRESULT,
}
#[cfg(feature = "Win32_UI_Shell_Common")]
pub trait IApplicationDesignModeSettings2_Impl: IApplicationDesignModeSettings_Impl {
    fn SetNativeDisplayOrientation(&self, nativedisplayorientation: NATIVE_DISPLAY_ORIENTATION) -> windows_core::Result<()>;
    fn SetApplicationViewOrientation(&self, vieworientation: APPLICATION_VIEW_ORIENTATION) -> windows_core::Result<()>;
    fn SetAdjacentDisplayEdges(&self, adjacentdisplayedges: ADJACENT_DISPLAY_EDGES) -> windows_core::Result<()>;
    fn SetIsOnLockScreen(&self, isonlockscreen: windows_core::BOOL) -> windows_core::Result<()>;
    fn SetApplicationViewMinWidth(&self, viewminwidth: APPLICATION_VIEW_MIN_WIDTH) -> windows_core::Result<()>;
    fn GetApplicationSizeBounds(&self, minapplicationsizepixels: *mut super::super::Foundation::SIZE, maxapplicationsizepixels: *mut super::super::Foundation::SIZE) -> windows_core::Result<()>;
    fn GetApplicationViewOrientation(&self, applicationsizepixels: &super::super::Foundation::SIZE) -> windows_core::Result<APPLICATION_VIEW_ORIENTATION>;
}
#[cfg(feature = "Win32_UI_Shell_Common")]
impl IApplicationDesignModeSettings2_Vtbl {
    pub const fn new<Identity: IApplicationDesignModeSettings2_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn SetNativeDisplayOrientation<Identity: IApplicationDesignModeSettings2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, nativedisplayorientation: NATIVE_DISPLAY_ORIENTATION) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IApplicationDesignModeSettings2_Impl::SetNativeDisplayOrientation(this, core::mem::transmute_copy(&nativedisplayorientation)).into()
            }
        }
        unsafe extern "system" fn SetApplicationViewOrientation<Identity: IApplicationDesignModeSettings2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, vieworientation: APPLICATION_VIEW_ORIENTATION) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IApplicationDesignModeSettings2_Impl::SetApplicationViewOrientation(this, core::mem::transmute_copy(&vieworientation)).into()
            }
        }
        unsafe extern "system" fn SetAdjacentDisplayEdges<Identity: IApplicationDesignModeSettings2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, adjacentdisplayedges: ADJACENT_DISPLAY_EDGES) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IApplicationDesignModeSettings2_Impl::SetAdjacentDisplayEdges(this, core::mem::transmute_copy(&adjacentdisplayedges)).into()
            }
        }
        unsafe extern "system" fn SetIsOnLockScreen<Identity: IApplicationDesignModeSettings2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, isonlockscreen: windows_core::BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IApplicationDesignModeSettings2_Impl::SetIsOnLockScreen(this, core::mem::transmute_copy(&isonlockscreen)).into()
            }
        }
        unsafe extern "system" fn SetApplicationViewMinWidth<Identity: IApplicationDesignModeSettings2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, viewminwidth: APPLICATION_VIEW_MIN_WIDTH) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IApplicationDesignModeSettings2_Impl::SetApplicationViewMinWidth(this, core::mem::transmute_copy(&viewminwidth)).into()
            }
        }
        unsafe extern "system" fn GetApplicationSizeBounds<Identity: IApplicationDesignModeSettings2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, minapplicationsizepixels: *mut super::super::Foundation::SIZE, maxapplicationsizepixels: *mut super::super::Foundation::SIZE) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IApplicationDesignModeSettings2_Impl::GetApplicationSizeBounds(this, core::mem::transmute_copy(&minapplicationsizepixels), core::mem::transmute_copy(&maxapplicationsizepixels)).into()
            }
        }
        unsafe extern "system" fn GetApplicationViewOrientation<Identity: IApplicationDesignModeSettings2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, applicationsizepixels: super::super::Foundation::SIZE, vieworientation: *mut APPLICATION_VIEW_ORIENTATION) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IApplicationDesignModeSettings2_Impl::GetApplicationViewOrientation(this, core::mem::transmute(&applicationsizepixels)) {
                    Ok(ok__) => {
                        vieworientation.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self {
            base__: IApplicationDesignModeSettings_Vtbl::new::<Identity, OFFSET>(),
            SetNativeDisplayOrientation: SetNativeDisplayOrientation::<Identity, OFFSET>,
            SetApplicationViewOrientation: SetApplicationViewOrientation::<Identity, OFFSET>,
            SetAdjacentDisplayEdges: SetAdjacentDisplayEdges::<Identity, OFFSET>,
            SetIsOnLockScreen: SetIsOnLockScreen::<Identity, OFFSET>,
            SetApplicationViewMinWidth: SetApplicationViewMinWidth::<Identity, OFFSET>,
            GetApplicationSizeBounds: GetApplicationSizeBounds::<Identity, OFFSET>,
            GetApplicationViewOrientation: GetApplicationViewOrientation::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IApplicationDesignModeSettings2 as windows_core::Interface>::IID || iid == &<IApplicationDesignModeSettings as windows_core::Interface>::IID
    }
}
#[cfg(feature = "Win32_UI_Shell_Common")]
impl windows_core::RuntimeName for IApplicationDesignModeSettings2 {}
windows_core::imp::define_interface!(IApplicationDestinations, IApplicationDestinations_Vtbl, 0x12337d35_94c6_48a0_bce7_6a9c69d4d600);
windows_core::imp::interface_hierarchy!(IApplicationDestinations, windows_core::IUnknown);
impl IApplicationDestinations {
    pub unsafe fn SetAppID<P0>(&self, pszappid: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).SetAppID)(windows_core::Interface::as_raw(self), pszappid.param().abi()).ok() }
    }
    pub unsafe fn RemoveDestination<P0>(&self, punk: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::IUnknown>,
    {
        unsafe { (windows_core::Interface::vtable(self).RemoveDestination)(windows_core::Interface::as_raw(self), punk.param().abi()).ok() }
    }
    pub unsafe fn RemoveAllDestinations(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).RemoveAllDestinations)(windows_core::Interface::as_raw(self)).ok() }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IApplicationDestinations_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub SetAppID: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub RemoveDestination: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub RemoveAllDestinations: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
}
pub trait IApplicationDestinations_Impl: windows_core::IUnknownImpl {
    fn SetAppID(&self, pszappid: &windows_core::PCWSTR) -> windows_core::Result<()>;
    fn RemoveDestination(&self, punk: windows_core::Ref<windows_core::IUnknown>) -> windows_core::Result<()>;
    fn RemoveAllDestinations(&self) -> windows_core::Result<()>;
}
impl IApplicationDestinations_Vtbl {
    pub const fn new<Identity: IApplicationDestinations_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn SetAppID<Identity: IApplicationDestinations_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pszappid: windows_core::PCWSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IApplicationDestinations_Impl::SetAppID(this, core::mem::transmute(&pszappid)).into()
            }
        }
        unsafe extern "system" fn RemoveDestination<Identity: IApplicationDestinations_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, punk: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IApplicationDestinations_Impl::RemoveDestination(this, core::mem::transmute_copy(&punk)).into()
            }
        }
        unsafe extern "system" fn RemoveAllDestinations<Identity: IApplicationDestinations_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IApplicationDestinations_Impl::RemoveAllDestinations(this).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            SetAppID: SetAppID::<Identity, OFFSET>,
            RemoveDestination: RemoveDestination::<Identity, OFFSET>,
            RemoveAllDestinations: RemoveAllDestinations::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IApplicationDestinations as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IApplicationDestinations {}
windows_core::imp::define_interface!(IApplicationDocumentLists, IApplicationDocumentLists_Vtbl, 0x3c594f9f_9f30_47a1_979a_c9e83d3d0a06);
windows_core::imp::interface_hierarchy!(IApplicationDocumentLists, windows_core::IUnknown);
impl IApplicationDocumentLists {
    pub unsafe fn SetAppID<P0>(&self, pszappid: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).SetAppID)(windows_core::Interface::as_raw(self), pszappid.param().abi()).ok() }
    }
    pub unsafe fn GetList<T>(&self, listtype: APPDOCLISTTYPE, citemsdesired: u32) -> windows_core::Result<T>
    where
        T: windows_core::Interface,
    {
        let mut result__ = core::ptr::null_mut();
        unsafe { (windows_core::Interface::vtable(self).GetList)(windows_core::Interface::as_raw(self), listtype, citemsdesired, &T::IID, &mut result__).and_then(|| windows_core::Type::from_abi(result__)) }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IApplicationDocumentLists_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub SetAppID: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub GetList: unsafe extern "system" fn(*mut core::ffi::c_void, APPDOCLISTTYPE, u32, *const windows_core::GUID, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
pub trait IApplicationDocumentLists_Impl: windows_core::IUnknownImpl {
    fn SetAppID(&self, pszappid: &windows_core::PCWSTR) -> windows_core::Result<()>;
    fn GetList(&self, listtype: APPDOCLISTTYPE, citemsdesired: u32, riid: *const windows_core::GUID, ppv: *mut *mut core::ffi::c_void) -> windows_core::Result<()>;
}
impl IApplicationDocumentLists_Vtbl {
    pub const fn new<Identity: IApplicationDocumentLists_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn SetAppID<Identity: IApplicationDocumentLists_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pszappid: windows_core::PCWSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IApplicationDocumentLists_Impl::SetAppID(this, core::mem::transmute(&pszappid)).into()
            }
        }
        unsafe extern "system" fn GetList<Identity: IApplicationDocumentLists_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, listtype: APPDOCLISTTYPE, citemsdesired: u32, riid: *const windows_core::GUID, ppv: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IApplicationDocumentLists_Impl::GetList(this, core::mem::transmute_copy(&listtype), core::mem::transmute_copy(&citemsdesired), core::mem::transmute_copy(&riid), core::mem::transmute_copy(&ppv)).into()
            }
        }
        Self { base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(), SetAppID: SetAppID::<Identity, OFFSET>, GetList: GetList::<Identity, OFFSET> }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IApplicationDocumentLists as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IApplicationDocumentLists {}
windows_core::imp::define_interface!(IAssocHandler, IAssocHandler_Vtbl, 0xf04061ac_1659_4a3f_a954_775aa57fc083);
windows_core::imp::interface_hierarchy!(IAssocHandler, windows_core::IUnknown);
impl IAssocHandler {
    pub unsafe fn GetName(&self) -> windows_core::Result<windows_core::PWSTR> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetName)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetUIName(&self) -> windows_core::Result<windows_core::PWSTR> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetUIName)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetIconLocation(&self, ppszpath: *mut windows_core::PWSTR, pindex: *mut i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetIconLocation)(windows_core::Interface::as_raw(self), ppszpath as _, pindex as _).ok() }
    }
    pub unsafe fn IsRecommended(&self) -> windows_core::HRESULT {
        unsafe { (windows_core::Interface::vtable(self).IsRecommended)(windows_core::Interface::as_raw(self)) }
    }
    pub unsafe fn MakeDefault<P0>(&self, pszdescription: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).MakeDefault)(windows_core::Interface::as_raw(self), pszdescription.param().abi()).ok() }
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Invoke<P0>(&self, pdo: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::System::Com::IDataObject>,
    {
        unsafe { (windows_core::Interface::vtable(self).Invoke)(windows_core::Interface::as_raw(self), pdo.param().abi()).ok() }
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn CreateInvoker<P0>(&self, pdo: P0) -> windows_core::Result<IAssocHandlerInvoker>
    where
        P0: windows_core::Param<super::super::System::Com::IDataObject>,
    {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).CreateInvoker)(windows_core::Interface::as_raw(self), pdo.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAssocHandler_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetName: unsafe extern "system" fn(*mut core::ffi::c_void, *mut windows_core::PWSTR) -> windows_core::HRESULT,
    pub GetUIName: unsafe extern "system" fn(*mut core::ffi::c_void, *mut windows_core::PWSTR) -> windows_core::HRESULT,
    pub GetIconLocation: unsafe extern "system" fn(*mut core::ffi::c_void, *mut windows_core::PWSTR, *mut i32) -> windows_core::HRESULT,
    pub IsRecommended: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub MakeDefault: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub Invoke: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Invoke: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub CreateInvoker: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    CreateInvoker: usize,
}
#[cfg(feature = "Win32_System_Com")]
pub trait IAssocHandler_Impl: windows_core::IUnknownImpl {
    fn GetName(&self) -> windows_core::Result<windows_core::PWSTR>;
    fn GetUIName(&self) -> windows_core::Result<windows_core::PWSTR>;
    fn GetIconLocation(&self, ppszpath: *mut windows_core::PWSTR, pindex: *mut i32) -> windows_core::Result<()>;
    fn IsRecommended(&self) -> windows_core::HRESULT;
    fn MakeDefault(&self, pszdescription: &windows_core::PCWSTR) -> windows_core::Result<()>;
    fn Invoke(&self, pdo: windows_core::Ref<super::super::System::Com::IDataObject>) -> windows_core::Result<()>;
    fn CreateInvoker(&self, pdo: windows_core::Ref<super::super::System::Com::IDataObject>) -> windows_core::Result<IAssocHandlerInvoker>;
}
#[cfg(feature = "Win32_System_Com")]
impl IAssocHandler_Vtbl {
    pub const fn new<Identity: IAssocHandler_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetName<Identity: IAssocHandler_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ppsz: *mut windows_core::PWSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAssocHandler_Impl::GetName(this) {
                    Ok(ok__) => {
                        ppsz.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetUIName<Identity: IAssocHandler_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ppsz: *mut windows_core::PWSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAssocHandler_Impl::GetUIName(this) {
                    Ok(ok__) => {
                        ppsz.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetIconLocation<Identity: IAssocHandler_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ppszpath: *mut windows_core::PWSTR, pindex: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAssocHandler_Impl::GetIconLocation(this, core::mem::transmute_copy(&ppszpath), core::mem::transmute_copy(&pindex)).into()
            }
        }
        unsafe extern "system" fn IsRecommended<Identity: IAssocHandler_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAssocHandler_Impl::IsRecommended(this)
            }
        }
        unsafe extern "system" fn MakeDefault<Identity: IAssocHandler_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pszdescription: windows_core::PCWSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAssocHandler_Impl::MakeDefault(this, core::mem::transmute(&pszdescription)).into()
            }
        }
        unsafe extern "system" fn Invoke<Identity: IAssocHandler_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pdo: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAssocHandler_Impl::Invoke(this, core::mem::transmute_copy(&pdo)).into()
            }
        }
        unsafe extern "system" fn CreateInvoker<Identity: IAssocHandler_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pdo: *mut core::ffi::c_void, ppinvoker: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAssocHandler_Impl::CreateInvoker(this, core::mem::transmute_copy(&pdo)) {
                    Ok(ok__) => {
                        ppinvoker.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            GetName: GetName::<Identity, OFFSET>,
            GetUIName: GetUIName::<Identity, OFFSET>,
            GetIconLocation: GetIconLocation::<Identity, OFFSET>,
            IsRecommended: IsRecommended::<Identity, OFFSET>,
            MakeDefault: MakeDefault::<Identity, OFFSET>,
            Invoke: Invoke::<Identity, OFFSET>,
            CreateInvoker: CreateInvoker::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAssocHandler as windows_core::Interface>::IID
    }
}
#[cfg(feature = "Win32_System_Com")]
impl windows_core::RuntimeName for IAssocHandler {}
windows_core::imp::define_interface!(IAssocHandlerInvoker, IAssocHandlerInvoker_Vtbl, 0x92218cab_ecaa_4335_8133_807fd234c2ee);
windows_core::imp::interface_hierarchy!(IAssocHandlerInvoker, windows_core::IUnknown);
impl IAssocHandlerInvoker {
    pub unsafe fn SupportsSelection(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SupportsSelection)(windows_core::Interface::as_raw(self)).ok() }
    }
    pub unsafe fn Invoke(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).Invoke)(windows_core::Interface::as_raw(self)).ok() }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAssocHandlerInvoker_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub SupportsSelection: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub Invoke: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
}
pub trait IAssocHandlerInvoker_Impl: windows_core::IUnknownImpl {
    fn SupportsSelection(&self) -> windows_core::Result<()>;
    fn Invoke(&self) -> windows_core::Result<()>;
}
impl IAssocHandlerInvoker_Vtbl {
    pub const fn new<Identity: IAssocHandlerInvoker_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn SupportsSelection<Identity: IAssocHandlerInvoker_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAssocHandlerInvoker_Impl::SupportsSelection(this).into()
            }
        }
        unsafe extern "system" fn Invoke<Identity: IAssocHandlerInvoker_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAssocHandlerInvoker_Impl::Invoke(this).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            SupportsSelection: SupportsSelection::<Identity, OFFSET>,
            Invoke: Invoke::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAssocHandlerInvoker as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IAssocHandlerInvoker {}
windows_core::imp::define_interface!(IAttachmentExecute, IAttachmentExecute_Vtbl, 0x73db1241_1e85_4581_8e4f_a81e1d0f8c57);
windows_core::imp::interface_hierarchy!(IAttachmentExecute, windows_core::IUnknown);
impl IAttachmentExecute {
    pub unsafe fn SetClientTitle<P0>(&self, psztitle: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).SetClientTitle)(windows_core::Interface::as_raw(self), psztitle.param().abi()).ok() }
    }
    pub unsafe fn SetClientGuid(&self, guid: *const windows_core::GUID) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetClientGuid)(windows_core::Interface::as_raw(self), guid).ok() }
    }
    pub unsafe fn SetLocalPath<P0>(&self, pszlocalpath: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).SetLocalPath)(windows_core::Interface::as_raw(self), pszlocalpath.param().abi()).ok() }
    }
    pub unsafe fn SetFileName<P0>(&self, pszfilename: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).SetFileName)(windows_core::Interface::as_raw(self), pszfilename.param().abi()).ok() }
    }
    pub unsafe fn SetSource<P0>(&self, pszsource: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).SetSource)(windows_core::Interface::as_raw(self), pszsource.param().abi()).ok() }
    }
    pub unsafe fn SetReferrer<P0>(&self, pszreferrer: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).SetReferrer)(windows_core::Interface::as_raw(self), pszreferrer.param().abi()).ok() }
    }
    pub unsafe fn CheckPolicy(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).CheckPolicy)(windows_core::Interface::as_raw(self)).ok() }
    }
    pub unsafe fn Prompt(&self, hwnd: super::super::Foundation::HWND, prompt: ATTACHMENT_PROMPT) -> windows_core::Result<ATTACHMENT_ACTION> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).Prompt)(windows_core::Interface::as_raw(self), hwnd, prompt, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn Save(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).Save)(windows_core::Interface::as_raw(self)).ok() }
    }
    pub unsafe fn Execute<P1>(&self, hwnd: super::super::Foundation::HWND, pszverb: P1, phprocess: Option<*mut super::super::Foundation::HANDLE>) -> windows_core::Result<()>
    where
        P1: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).Execute)(windows_core::Interface::as_raw(self), hwnd, pszverb.param().abi(), phprocess.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
    pub unsafe fn SaveWithUI(&self, hwnd: super::super::Foundation::HWND) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SaveWithUI)(windows_core::Interface::as_raw(self), hwnd).ok() }
    }
    pub unsafe fn ClearClientState(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).ClearClientState)(windows_core::Interface::as_raw(self)).ok() }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAttachmentExecute_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub SetClientTitle: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub SetClientGuid: unsafe extern "system" fn(*mut core::ffi::c_void, *const windows_core::GUID) -> windows_core::HRESULT,
    pub SetLocalPath: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub SetFileName: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub SetSource: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub SetReferrer: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub CheckPolicy: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub Prompt: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::HWND, ATTACHMENT_PROMPT, *mut ATTACHMENT_ACTION) -> windows_core::HRESULT,
    pub Save: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub Execute: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::HWND, windows_core::PCWSTR, *mut super::super::Foundation::HANDLE) -> windows_core::HRESULT,
    pub SaveWithUI: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::HWND) -> windows_core::HRESULT,
    pub ClearClientState: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
}
pub trait IAttachmentExecute_Impl: windows_core::IUnknownImpl {
    fn SetClientTitle(&self, psztitle: &windows_core::PCWSTR) -> windows_core::Result<()>;
    fn SetClientGuid(&self, guid: *const windows_core::GUID) -> windows_core::Result<()>;
    fn SetLocalPath(&self, pszlocalpath: &windows_core::PCWSTR) -> windows_core::Result<()>;
    fn SetFileName(&self, pszfilename: &windows_core::PCWSTR) -> windows_core::Result<()>;
    fn SetSource(&self, pszsource: &windows_core::PCWSTR) -> windows_core::Result<()>;
    fn SetReferrer(&self, pszreferrer: &windows_core::PCWSTR) -> windows_core::Result<()>;
    fn CheckPolicy(&self) -> windows_core::Result<()>;
    fn Prompt(&self, hwnd: super::super::Foundation::HWND, prompt: ATTACHMENT_PROMPT) -> windows_core::Result<ATTACHMENT_ACTION>;
    fn Save(&self) -> windows_core::Result<()>;
    fn Execute(&self, hwnd: super::super::Foundation::HWND, pszverb: &windows_core::PCWSTR, phprocess: *mut super::super::Foundation::HANDLE) -> windows_core::Result<()>;
    fn SaveWithUI(&self, hwnd: super::super::Foundation::HWND) -> windows_core::Result<()>;
    fn ClearClientState(&self) -> windows_core::Result<()>;
}
impl IAttachmentExecute_Vtbl {
    pub const fn new<Identity: IAttachmentExecute_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn SetClientTitle<Identity: IAttachmentExecute_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, psztitle: windows_core::PCWSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAttachmentExecute_Impl::SetClientTitle(this, core::mem::transmute(&psztitle)).into()
            }
        }
        unsafe extern "system" fn SetClientGuid<Identity: IAttachmentExecute_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, guid: *const windows_core::GUID) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAttachmentExecute_Impl::SetClientGuid(this, core::mem::transmute_copy(&guid)).into()
            }
        }
        unsafe extern "system" fn SetLocalPath<Identity: IAttachmentExecute_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pszlocalpath: windows_core::PCWSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAttachmentExecute_Impl::SetLocalPath(this, core::mem::transmute(&pszlocalpath)).into()
            }
        }
        unsafe extern "system" fn SetFileName<Identity: IAttachmentExecute_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pszfilename: windows_core::PCWSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAttachmentExecute_Impl::SetFileName(this, core::mem::transmute(&pszfilename)).into()
            }
        }
        unsafe extern "system" fn SetSource<Identity: IAttachmentExecute_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pszsource: windows_core::PCWSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAttachmentExecute_Impl::SetSource(this, core::mem::transmute(&pszsource)).into()
            }
        }
        unsafe extern "system" fn SetReferrer<Identity: IAttachmentExecute_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pszreferrer: windows_core::PCWSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAttachmentExecute_Impl::SetReferrer(this, core::mem::transmute(&pszreferrer)).into()
            }
        }
        unsafe extern "system" fn CheckPolicy<Identity: IAttachmentExecute_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAttachmentExecute_Impl::CheckPolicy(this).into()
            }
        }
        unsafe extern "system" fn Prompt<Identity: IAttachmentExecute_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, hwnd: super::super::Foundation::HWND, prompt: ATTACHMENT_PROMPT, paction: *mut ATTACHMENT_ACTION) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAttachmentExecute_Impl::Prompt(this, core::mem::transmute_copy(&hwnd), core::mem::transmute_copy(&prompt)) {
                    Ok(ok__) => {
                        paction.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn Save<Identity: IAttachmentExecute_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAttachmentExecute_Impl::Save(this).into()
            }
        }
        unsafe extern "system" fn Execute<Identity: IAttachmentExecute_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, hwnd: super::super::Foundation::HWND, pszverb: windows_core::PCWSTR, phprocess: *mut super::super::Foundation::HANDLE) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAttachmentExecute_Impl::Execute(this, core::mem::transmute_copy(&hwnd), core::mem::transmute(&pszverb), core::mem::transmute_copy(&phprocess)).into()
            }
        }
        unsafe extern "system" fn SaveWithUI<Identity: IAttachmentExecute_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, hwnd: super::super::Foundation::HWND) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAttachmentExecute_Impl::SaveWithUI(this, core::mem::transmute_copy(&hwnd)).into()
            }
        }
        unsafe extern "system" fn ClearClientState<Identity: IAttachmentExecute_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAttachmentExecute_Impl::ClearClientState(this).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            SetClientTitle: SetClientTitle::<Identity, OFFSET>,
            SetClientGuid: SetClientGuid::<Identity, OFFSET>,
            SetLocalPath: SetLocalPath::<Identity, OFFSET>,
            SetFileName: SetFileName::<Identity, OFFSET>,
            SetSource: SetSource::<Identity, OFFSET>,
            SetReferrer: SetReferrer::<Identity, OFFSET>,
            CheckPolicy: CheckPolicy::<Identity, OFFSET>,
            Prompt: Prompt::<Identity, OFFSET>,
            Save: Save::<Identity, OFFSET>,
            Execute: Execute::<Identity, OFFSET>,
            SaveWithUI: SaveWithUI::<Identity, OFFSET>,
            ClearClientState: ClearClientState::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAttachmentExecute as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IAttachmentExecute {}
windows_core::imp::define_interface!(IAutoComplete, IAutoComplete_Vtbl, 0x00bb2762_6a77_11d0_a535_00c04fd7d062);
windows_core::imp::interface_hierarchy!(IAutoComplete, windows_core::IUnknown);
impl IAutoComplete {
    pub unsafe fn Init<P1, P2, P3>(&self, hwndedit: super::super::Foundation::HWND, punkacl: P1, pwszregkeypath: P2, pwszquickcomplete: P3) -> windows_core::Result<()>
    where
        P1: windows_core::Param<windows_core::IUnknown>,
        P2: windows_core::Param<windows_core::PCWSTR>,
        P3: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).Init)(windows_core::Interface::as_raw(self), hwndedit, punkacl.param().abi(), pwszregkeypath.param().abi(), pwszquickcomplete.param().abi()).ok() }
    }
    pub unsafe fn Enable(&self, fenable: bool) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).Enable)(windows_core::Interface::as_raw(self), fenable.into()).ok() }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAutoComplete_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub Init: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::HWND, *mut core::ffi::c_void, windows_core::PCWSTR, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub Enable: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::BOOL) -> windows_core::HRESULT,
}
pub trait IAutoComplete_Impl: windows_core::IUnknownImpl {
    fn Init(&self, hwndedit: super::super::Foundation::HWND, punkacl: windows_core::Ref<windows_core::IUnknown>, pwszregkeypath: &windows_core::PCWSTR, pwszquickcomplete: &windows_core::PCWSTR) -> windows_core::Result<()>;
    fn Enable(&self, fenable: windows_core::BOOL) -> windows_core::Result<()>;
}
impl IAutoComplete_Vtbl {
    pub const fn new<Identity: IAutoComplete_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn Init<Identity: IAutoComplete_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, hwndedit: super::super::Foundation::HWND, punkacl: *mut core::ffi::c_void, pwszregkeypath: windows_core::PCWSTR, pwszquickcomplete: windows_core::PCWSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAutoComplete_Impl::Init(this, core::mem::transmute_copy(&hwndedit), core::mem::transmute_copy(&punkacl), core::mem::transmute(&pwszregkeypath), core::mem::transmute(&pwszquickcomplete)).into()
            }
        }
        unsafe extern "system" fn Enable<Identity: IAutoComplete_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, fenable: windows_core::BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAutoComplete_Impl::Enable(this, core::mem::transmute_copy(&fenable)).into()
            }
        }
        Self { base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(), Init: Init::<Identity, OFFSET>, Enable: Enable::<Identity, OFFSET> }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAutoComplete as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IAutoComplete {}
windows_core::imp::define_interface!(IAutoComplete2, IAutoComplete2_Vtbl, 0xeac04bc0_3791_11d2_bb95_0060977b464c);
impl core::ops::Deref for IAutoComplete2 {
    type Target = IAutoComplete;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IAutoComplete2, windows_core::IUnknown, IAutoComplete);
impl IAutoComplete2 {
    pub unsafe fn SetOptions(&self, dwflag: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetOptions)(windows_core::Interface::as_raw(self), dwflag).ok() }
    }
    pub unsafe fn GetOptions(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetOptions)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAutoComplete2_Vtbl {
    pub base__: IAutoComplete_Vtbl,
    pub SetOptions: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetOptions: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
}
pub trait IAutoComplete2_Impl: IAutoComplete_Impl {
    fn SetOptions(&self, dwflag: u32) -> windows_core::Result<()>;
    fn GetOptions(&self) -> windows_core::Result<u32>;
}
impl IAutoComplete2_Vtbl {
    pub const fn new<Identity: IAutoComplete2_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn SetOptions<Identity: IAutoComplete2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwflag: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAutoComplete2_Impl::SetOptions(this, core::mem::transmute_copy(&dwflag)).into()
            }
        }
        unsafe extern "system" fn GetOptions<Identity: IAutoComplete2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pdwflag: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAutoComplete2_Impl::GetOptions(this) {
                    Ok(ok__) => {
                        pdwflag.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self { base__: IAutoComplete_Vtbl::new::<Identity, OFFSET>(), SetOptions: SetOptions::<Identity, OFFSET>, GetOptions: GetOptions::<Identity, OFFSET> }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAutoComplete2 as windows_core::Interface>::IID || iid == &<IAutoComplete as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IAutoComplete2 {}
windows_core::imp::define_interface!(IAutoCompleteDropDown, IAutoCompleteDropDown_Vtbl, 0x3cd141f4_3c6a_11d2_bcaa_00c04fd929db);
windows_core::imp::interface_hierarchy!(IAutoCompleteDropDown, windows_core::IUnknown);
impl IAutoCompleteDropDown {
    pub unsafe fn GetDropDownStatus(&self, pdwflags: *mut u32, ppwszstring: *mut windows_core::PWSTR) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetDropDownStatus)(windows_core::Interface::as_raw(self), pdwflags as _, ppwszstring as _).ok() }
    }
    pub unsafe fn ResetEnumerator(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).ResetEnumerator)(windows_core::Interface::as_raw(self)).ok() }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAutoCompleteDropDown_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetDropDownStatus: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, *mut windows_core::PWSTR) -> windows_core::HRESULT,
    pub ResetEnumerator: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
}
pub trait IAutoCompleteDropDown_Impl: windows_core::IUnknownImpl {
    fn GetDropDownStatus(&self, pdwflags: *mut u32, ppwszstring: *mut windows_core::PWSTR) -> windows_core::Result<()>;
    fn ResetEnumerator(&self) -> windows_core::Result<()>;
}
impl IAutoCompleteDropDown_Vtbl {
    pub const fn new<Identity: IAutoCompleteDropDown_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetDropDownStatus<Identity: IAutoCompleteDropDown_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pdwflags: *mut u32, ppwszstring: *mut windows_core::PWSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAutoCompleteDropDown_Impl::GetDropDownStatus(this, core::mem::transmute_copy(&pdwflags), core::mem::transmute_copy(&ppwszstring)).into()
            }
        }
        unsafe extern "system" fn ResetEnumerator<Identity: IAutoCompleteDropDown_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAutoCompleteDropDown_Impl::ResetEnumerator(this).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            GetDropDownStatus: GetDropDownStatus::<Identity, OFFSET>,
            ResetEnumerator: ResetEnumerator::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAutoCompleteDropDown as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IAutoCompleteDropDown {}
windows_core::imp::define_interface!(IBandHost, IBandHost_Vtbl, 0xb9075c7c_d48e_403f_ab99_d6c77a1084ac);
windows_core::imp::interface_hierarchy!(IBandHost, windows_core::IUnknown);
impl IBandHost {
    pub unsafe fn CreateBand<T>(&self, rclsidband: *const windows_core::GUID, favailable: bool, fvisible: bool) -> windows_core::Result<T>
    where
        T: windows_core::Interface,
    {
        let mut result__ = core::ptr::null_mut();
        unsafe { (windows_core::Interface::vtable(self).CreateBand)(windows_core::Interface::as_raw(self), rclsidband, favailable.into(), fvisible.into(), &T::IID, &mut result__).and_then(|| windows_core::Type::from_abi(result__)) }
    }
    pub unsafe fn SetBandAvailability(&self, rclsidband: *const windows_core::GUID, favailable: bool) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetBandAvailability)(windows_core::Interface::as_raw(self), rclsidband, favailable.into()).ok() }
    }
    pub unsafe fn DestroyBand(&self, rclsidband: *const windows_core::GUID) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).DestroyBand)(windows_core::Interface::as_raw(self), rclsidband).ok() }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IBandHost_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub CreateBand: unsafe extern "system" fn(*mut core::ffi::c_void, *const windows_core::GUID, windows_core::BOOL, windows_core::BOOL, *const windows_core::GUID, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetBandAvailability: unsafe extern "system" fn(*mut core::ffi::c_void, *const windows_core::GUID, windows_core::BOOL) -> windows_core::HRESULT,
    pub DestroyBand: unsafe extern "system" fn(*mut core::ffi::c_void, *const windows_core::GUID) -> windows_core::HRESULT,
}
pub trait IBandHost_Impl: windows_core::IUnknownImpl {
    fn CreateBand(&self, rclsidband: *const windows_core::GUID, favailable: windows_core::BOOL, fvisible: windows_core::BOOL, riid: *const windows_core::GUID, ppv: *mut *mut core::ffi::c_void) -> windows_core::Result<()>;
    fn SetBandAvailability(&self, rclsidband: *const windows_core::GUID, favailable: windows_core::BOOL) -> windows_core::Result<()>;
    fn DestroyBand(&self, rclsidband: *const windows_core::GUID) -> windows_core::Result<()>;
}
impl IBandHost_Vtbl {
    pub const fn new<Identity: IBandHost_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn CreateBand<Identity: IBandHost_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, rclsidband: *const windows_core::GUID, favailable: windows_core::BOOL, fvisible: windows_core::BOOL, riid: *const windows_core::GUID, ppv: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBandHost_Impl::CreateBand(this, core::mem::transmute_copy(&rclsidband), core::mem::transmute_copy(&favailable), core::mem::transmute_copy(&fvisible), core::mem::transmute_copy(&riid), core::mem::transmute_copy(&ppv)).into()
            }
        }
        unsafe extern "system" fn SetBandAvailability<Identity: IBandHost_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, rclsidband: *const windows_core::GUID, favailable: windows_core::BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBandHost_Impl::SetBandAvailability(this, core::mem::transmute_copy(&rclsidband), core::mem::transmute_copy(&favailable)).into()
            }
        }
        unsafe extern "system" fn DestroyBand<Identity: IBandHost_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, rclsidband: *const windows_core::GUID) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBandHost_Impl::DestroyBand(this, core::mem::transmute_copy(&rclsidband)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            CreateBand: CreateBand::<Identity, OFFSET>,
            SetBandAvailability: SetBandAvailability::<Identity, OFFSET>,
            DestroyBand: DestroyBand::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IBandHost as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IBandHost {}
windows_core::imp::define_interface!(IBandSite, IBandSite_Vtbl, 0x4cf504b0_de96_11d0_8b3f_00a0c911e8e5);
windows_core::imp::interface_hierarchy!(IBandSite, windows_core::IUnknown);
impl IBandSite {
    pub unsafe fn AddBand<P0>(&self, punk: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::IUnknown>,
    {
        unsafe { (windows_core::Interface::vtable(self).AddBand)(windows_core::Interface::as_raw(self), punk.param().abi()).ok() }
    }
    pub unsafe fn EnumBands(&self, uband: u32) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).EnumBands)(windows_core::Interface::as_raw(self), uband, &mut result__).map(|| result__)
        }
    }
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn QueryBand(&self, dwbandid: u32, ppstb: Option<*mut Option<IDeskBand>>, pdwstate: Option<*mut u32>, pszname: Option<&mut [u16]>) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).QueryBand)(windows_core::Interface::as_raw(self), dwbandid, ppstb.unwrap_or(core::mem::zeroed()) as _, pdwstate.unwrap_or(core::mem::zeroed()) as _, core::mem::transmute(pszname.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), pszname.as_deref().map_or(0, |slice| slice.len().try_into().unwrap())).ok() }
    }
    pub unsafe fn SetBandState(&self, dwbandid: u32, dwmask: u32, dwstate: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetBandState)(windows_core::Interface::as_raw(self), dwbandid, dwmask, dwstate).ok() }
    }
    pub unsafe fn RemoveBand(&self, dwbandid: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).RemoveBand)(windows_core::Interface::as_raw(self), dwbandid).ok() }
    }
    pub unsafe fn GetBandObject<T>(&self, dwbandid: u32) -> windows_core::Result<T>
    where
        T: windows_core::Interface,
    {
        let mut result__ = core::ptr::null_mut();
        unsafe { (windows_core::Interface::vtable(self).GetBandObject)(windows_core::Interface::as_raw(self), dwbandid, &T::IID, &mut result__).and_then(|| windows_core::Type::from_abi(result__)) }
    }
    pub unsafe fn SetBandSiteInfo(&self, pbsinfo: *const BANDSITEINFO) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetBandSiteInfo)(windows_core::Interface::as_raw(self), pbsinfo).ok() }
    }
    pub unsafe fn GetBandSiteInfo(&self, pbsinfo: *mut BANDSITEINFO) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetBandSiteInfo)(windows_core::Interface::as_raw(self), pbsinfo as _).ok() }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IBandSite_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub AddBand: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub EnumBands: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_System_Ole")]
    pub QueryBand: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut *mut core::ffi::c_void, *mut u32, windows_core::PWSTR, i32) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Ole"))]
    QueryBand: usize,
    pub SetBandState: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, u32) -> windows_core::HRESULT,
    pub RemoveBand: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetBandObject: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *const windows_core::GUID, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetBandSiteInfo: unsafe extern "system" fn(*mut core::ffi::c_void, *const BANDSITEINFO) -> windows_core::HRESULT,
    pub GetBandSiteInfo: unsafe extern "system" fn(*mut core::ffi::c_void, *mut BANDSITEINFO) -> windows_core::HRESULT,
}
#[cfg(feature = "Win32_System_Ole")]
pub trait IBandSite_Impl: windows_core::IUnknownImpl {
    fn AddBand(&self, punk: windows_core::Ref<windows_core::IUnknown>) -> windows_core::Result<()>;
    fn EnumBands(&self, uband: u32) -> windows_core::Result<u32>;
    fn QueryBand(&self, dwbandid: u32, ppstb: windows_core::OutRef<IDeskBand>, pdwstate: *mut u32, pszname: windows_core::PWSTR, cchname: i32) -> windows_core::Result<()>;
    fn SetBandState(&self, dwbandid: u32, dwmask: u32, dwstate: u32) -> windows_core::Result<()>;
    fn RemoveBand(&self, dwbandid: u32) -> windows_core::Result<()>;
    fn GetBandObject(&self, dwbandid: u32, riid: *const windows_core::GUID, ppv: *mut *mut core::ffi::c_void) -> windows_core::Result<()>;
    fn SetBandSiteInfo(&self, pbsinfo: *const BANDSITEINFO) -> windows_core::Result<()>;
    fn GetBandSiteInfo(&self, pbsinfo: *mut BANDSITEINFO) -> windows_core::Result<()>;
}
#[cfg(feature = "Win32_System_Ole")]
impl IBandSite_Vtbl {
    pub const fn new<Identity: IBandSite_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn AddBand<Identity: IBandSite_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, punk: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBandSite_Impl::AddBand(this, core::mem::transmute_copy(&punk)).into()
            }
        }
        unsafe extern "system" fn EnumBands<Identity: IBandSite_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, uband: u32, pdwbandid: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IBandSite_Impl::EnumBands(this, core::mem::transmute_copy(&uband)) {
                    Ok(ok__) => {
                        pdwbandid.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn QueryBand<Identity: IBandSite_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwbandid: u32, ppstb: *mut *mut core::ffi::c_void, pdwstate: *mut u32, pszname: windows_core::PWSTR, cchname: i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBandSite_Impl::QueryBand(this, core::mem::transmute_copy(&dwbandid), core::mem::transmute_copy(&ppstb), core::mem::transmute_copy(&pdwstate), core::mem::transmute_copy(&pszname), core::mem::transmute_copy(&cchname)).into()
            }
        }
        unsafe extern "system" fn SetBandState<Identity: IBandSite_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwbandid: u32, dwmask: u32, dwstate: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBandSite_Impl::SetBandState(this, core::mem::transmute_copy(&dwbandid), core::mem::transmute_copy(&dwmask), core::mem::transmute_copy(&dwstate)).into()
            }
        }
        unsafe extern "system" fn RemoveBand<Identity: IBandSite_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwbandid: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBandSite_Impl::RemoveBand(this, core::mem::transmute_copy(&dwbandid)).into()
            }
        }
        unsafe extern "system" fn GetBandObject<Identity: IBandSite_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwbandid: u32, riid: *const windows_core::GUID, ppv: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBandSite_Impl::GetBandObject(this, core::mem::transmute_copy(&dwbandid), core::mem::transmute_copy(&riid), core::mem::transmute_copy(&ppv)).into()
            }
        }
        unsafe extern "system" fn SetBandSiteInfo<Identity: IBandSite_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbsinfo: *const BANDSITEINFO) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBandSite_Impl::SetBandSiteInfo(this, core::mem::transmute_copy(&pbsinfo)).into()
            }
        }
        unsafe extern "system" fn GetBandSiteInfo<Identity: IBandSite_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbsinfo: *mut BANDSITEINFO) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBandSite_Impl::GetBandSiteInfo(this, core::mem::transmute_copy(&pbsinfo)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            AddBand: AddBand::<Identity, OFFSET>,
            EnumBands: EnumBands::<Identity, OFFSET>,
            QueryBand: QueryBand::<Identity, OFFSET>,
            SetBandState: SetBandState::<Identity, OFFSET>,
            RemoveBand: RemoveBand::<Identity, OFFSET>,
            GetBandObject: GetBandObject::<Identity, OFFSET>,
            SetBandSiteInfo: SetBandSiteInfo::<Identity, OFFSET>,
            GetBandSiteInfo: GetBandSiteInfo::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IBandSite as windows_core::Interface>::IID
    }
}
#[cfg(feature = "Win32_System_Ole")]
impl windows_core::RuntimeName for IBandSite {}
windows_core::imp::define_interface!(IBannerNotificationHandler, IBannerNotificationHandler_Vtbl, 0x8d7b2ba7_db05_46a8_823c_d2b6de08ee91);
windows_core::imp::interface_hierarchy!(IBannerNotificationHandler, windows_core::IUnknown);
impl IBannerNotificationHandler {
    pub unsafe fn OnBannerEvent(&self, notification: *const BANNER_NOTIFICATION) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).OnBannerEvent)(windows_core::Interface::as_raw(self), notification).ok() }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IBannerNotificationHandler_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub OnBannerEvent: unsafe extern "system" fn(*mut core::ffi::c_void, *const BANNER_NOTIFICATION) -> windows_core::HRESULT,
}
pub trait IBannerNotificationHandler_Impl: windows_core::IUnknownImpl {
    fn OnBannerEvent(&self, notification: *const BANNER_NOTIFICATION) -> windows_core::Result<()>;
}
impl IBannerNotificationHandler_Vtbl {
    pub const fn new<Identity: IBannerNotificationHandler_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn OnBannerEvent<Identity: IBannerNotificationHandler_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, notification: *const BANNER_NOTIFICATION) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBannerNotificationHandler_Impl::OnBannerEvent(this, core::mem::transmute_copy(&notification)).into()
            }
        }
        Self { base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(), OnBannerEvent: OnBannerEvent::<Identity, OFFSET> }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IBannerNotificationHandler as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IBannerNotificationHandler {}
windows_core::imp::define_interface!(IBanneredBar, IBanneredBar_Vtbl, 0x596a9a94_013e_11d1_8d34_00a0c90f2719);
windows_core::imp::interface_hierarchy!(IBanneredBar, windows_core::IUnknown);
impl IBanneredBar {
    pub unsafe fn SetIconSize(&self, iicon: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetIconSize)(windows_core::Interface::as_raw(self), iicon).ok() }
    }
    pub unsafe fn GetIconSize(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetIconSize)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn SetBitmap(&self, hbitmap: super::super::Graphics::Gdi::HBITMAP) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetBitmap)(windows_core::Interface::as_raw(self), hbitmap).ok() }
    }
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn GetBitmap(&self) -> windows_core::Result<super::super::Graphics::Gdi::HBITMAP> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetBitmap)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IBanneredBar_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub SetIconSize: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetIconSize: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub SetBitmap: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Graphics::Gdi::HBITMAP) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))]
    SetBitmap: usize,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub GetBitmap: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Graphics::Gdi::HBITMAP) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))]
    GetBitmap: usize,
}
#[cfg(feature = "Win32_Graphics_Gdi")]
pub trait IBanneredBar_Impl: windows_core::IUnknownImpl {
    fn SetIconSize(&self, iicon: u32) -> windows_core::Result<()>;
    fn GetIconSize(&self) -> windows_core::Result<u32>;
    fn SetBitmap(&self, hbitmap: super::super::Graphics::Gdi::HBITMAP) -> windows_core::Result<()>;
    fn GetBitmap(&self) -> windows_core::Result<super::super::Graphics::Gdi::HBITMAP>;
}
#[cfg(feature = "Win32_Graphics_Gdi")]
impl IBanneredBar_Vtbl {
    pub const fn new<Identity: IBanneredBar_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn SetIconSize<Identity: IBanneredBar_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, iicon: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBanneredBar_Impl::SetIconSize(this, core::mem::transmute_copy(&iicon)).into()
            }
        }
        unsafe extern "system" fn GetIconSize<Identity: IBanneredBar_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, piicon: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IBanneredBar_Impl::GetIconSize(this) {
                    Ok(ok__) => {
                        piicon.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetBitmap<Identity: IBanneredBar_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, hbitmap: super::super::Graphics::Gdi::HBITMAP) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBanneredBar_Impl::SetBitmap(this, core::mem::transmute_copy(&hbitmap)).into()
            }
        }
        unsafe extern "system" fn GetBitmap<Identity: IBanneredBar_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, phbitmap: *mut super::super::Graphics::Gdi::HBITMAP) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IBanneredBar_Impl::GetBitmap(this) {
                    Ok(ok__) => {
                        phbitmap.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            SetIconSize: SetIconSize::<Identity, OFFSET>,
            GetIconSize: GetIconSize::<Identity, OFFSET>,
            SetBitmap: SetBitmap::<Identity, OFFSET>,
            GetBitmap: GetBitmap::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IBanneredBar as windows_core::Interface>::IID
    }
}
#[cfg(feature = "Win32_Graphics_Gdi")]
impl windows_core::RuntimeName for IBanneredBar {}
windows_core::imp::define_interface!(IBrowserFrameOptions, IBrowserFrameOptions_Vtbl, 0x10df43c8_1dbe_11d3_8b34_006097df5bd4);
windows_core::imp::interface_hierarchy!(IBrowserFrameOptions, windows_core::IUnknown);
impl IBrowserFrameOptions {
    pub unsafe fn GetFrameOptions(&self, dwmask: u32) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetFrameOptions)(windows_core::Interface::as_raw(self), dwmask, &mut result__).map(|| result__)
        }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IBrowserFrameOptions_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetFrameOptions: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
}
pub trait IBrowserFrameOptions_Impl: windows_core::IUnknownImpl {
    fn GetFrameOptions(&self, dwmask: u32) -> windows_core::Result<u32>;
}
impl IBrowserFrameOptions_Vtbl {
    pub const fn new<Identity: IBrowserFrameOptions_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetFrameOptions<Identity: IBrowserFrameOptions_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwmask: u32, pdwoptions: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IBrowserFrameOptions_Impl::GetFrameOptions(this, core::mem::transmute_copy(&dwmask)) {
                    Ok(ok__) => {
                        pdwoptions.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self { base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(), GetFrameOptions: GetFrameOptions::<Identity, OFFSET> }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IBrowserFrameOptions as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IBrowserFrameOptions {}
windows_core::imp::define_interface!(IBrowserService, IBrowserService_Vtbl, 0x02ba3b52_0547_11d1_b833_00c04fc9b31f);
windows_core::imp::interface_hierarchy!(IBrowserService, windows_core::IUnknown);
impl IBrowserService {
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn GetParentSite(&self) -> windows_core::Result<super::super::System::Ole::IOleInPlaceSite> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetParentSite)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn SetTitle<P0, P1>(&self, psv: P0, pszname: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IShellView>,
        P1: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).SetTitle)(windows_core::Interface::as_raw(self), psv.param().abi(), pszname.param().abi()).ok() }
    }
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn GetTitle<P0>(&self, psv: P0, pszname: &mut [u16]) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IShellView>,
    {
        unsafe { (windows_core::Interface::vtable(self).GetTitle)(windows_core::Interface::as_raw(self), psv.param().abi(), core::mem::transmute(pszname.as_ptr()), pszname.len().try_into().unwrap()).ok() }
    }
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn GetOleObject(&self) -> windows_core::Result<super::super::System::Ole::IOleObject> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetOleObject)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn GetTravelLog(&self) -> windows_core::Result<ITravelLog> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetTravelLog)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn ShowControlWindow(&self, id: u32, fshow: bool) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).ShowControlWindow)(windows_core::Interface::as_raw(self), id, fshow.into()).ok() }
    }
    pub unsafe fn IsControlWindowShown(&self, id: u32) -> windows_core::Result<windows_core::BOOL> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).IsControlWindowShown)(windows_core::Interface::as_raw(self), id, &mut result__).map(|| result__)
        }
    }
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn IEGetDisplayName(&self, pidl: *const Common::ITEMIDLIST, pwszname: windows_core::PWSTR, uflags: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).IEGetDisplayName)(windows_core::Interface::as_raw(self), pidl, core::mem::transmute(pwszname), uflags).ok() }
    }
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn IEParseDisplayName<P1>(&self, uicp: u32, pwszpath: P1) -> windows_core::Result<*mut Common::ITEMIDLIST>
    where
        P1: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).IEParseDisplayName)(windows_core::Interface::as_raw(self), uicp, pwszpath.param().abi(), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn DisplayParseError<P1>(&self, hres: windows_core::HRESULT, pwszpath: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).DisplayParseError)(windows_core::Interface::as_raw(self), hres, pwszpath.param().abi()).ok() }
    }
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn NavigateToPidl(&self, pidl: *const Common::ITEMIDLIST, grfhlnf: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).NavigateToPidl)(windows_core::Interface::as_raw(self), pidl, grfhlnf).ok() }
    }
    pub unsafe fn SetNavigateState(&self, bnstate: BNSTATE) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetNavigateState)(windows_core::Interface::as_raw(self), bnstate).ok() }
    }
    pub unsafe fn GetNavigateState(&self) -> windows_core::Result<BNSTATE> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetNavigateState)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    #[cfg(all(feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
    pub unsafe fn NotifyRedirect<P0>(&self, psv: P0, pidl: *const Common::ITEMIDLIST) -> windows_core::Result<windows_core::BOOL>
    where
        P0: windows_core::Param<IShellView>,
    {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).NotifyRedirect)(windows_core::Interface::as_raw(self), psv.param().abi(), pidl, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn UpdateWindowList(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).UpdateWindowList)(windows_core::Interface::as_raw(self)).ok() }
    }
    pub unsafe fn UpdateBackForwardState(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).UpdateBackForwardState)(windows_core::Interface::as_raw(self)).ok() }
    }
    pub unsafe fn SetFlags(&self, dwflags: u32, dwflagmask: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetFlags)(windows_core::Interface::as_raw(self), dwflags, dwflagmask).ok() }
    }
    pub unsafe fn GetFlags(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetFlags)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn CanNavigateNow(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).CanNavigateNow)(windows_core::Interface::as_raw(self)).ok() }
    }
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn GetPidl(&self) -> windows_core::Result<*mut Common::ITEMIDLIST> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetPidl)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn SetReferrer(&self, pidl: *const Common::ITEMIDLIST) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetReferrer)(windows_core::Interface::as_raw(self), pidl).ok() }
    }
    pub unsafe fn GetBrowserIndex(&self) -> u32 {
        unsafe { (windows_core::Interface::vtable(self).GetBrowserIndex)(windows_core::Interface::as_raw(self)) }
    }
    pub unsafe fn GetBrowserByIndex(&self, dwid: u32) -> windows_core::Result<windows_core::IUnknown> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetBrowserByIndex)(windows_core::Interface::as_raw(self), dwid, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn GetHistoryObject(&self, ppole: *mut Option<super::super::System::Ole::IOleObject>, pstm: *mut Option<super::super::System::Com::IStream>, ppbc: *mut Option<super::super::System::Com::IBindCtx>) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetHistoryObject)(windows_core::Interface::as_raw(self), core::mem::transmute(ppole), core::mem::transmute(pstm), core::mem::transmute(ppbc)).ok() }
    }
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn SetHistoryObject<P0>(&self, pole: P0, fislocalanchor: bool) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::System::Ole::IOleObject>,
    {
        unsafe { (windows_core::Interface::vtable(self).SetHistoryObject)(windows_core::Interface::as_raw(self), pole.param().abi(), fislocalanchor.into()).ok() }
    }
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn CacheOLEServer<P0>(&self, pole: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::System::Ole::IOleObject>,
    {
        unsafe { (windows_core::Interface::vtable(self).CacheOLEServer)(windows_core::Interface::as_raw(self), pole.param().abi()).ok() }
    }
    #[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub unsafe fn GetSetCodePage(&self, pvarin: *const super::super::System::Variant::VARIANT) -> windows_core::Result<super::super::System::Variant::VARIANT> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetSetCodePage)(windows_core::Interface::as_raw(self), core::mem::transmute(pvarin), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    #[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub unsafe fn OnHttpEquiv<P0>(&self, psv: P0, fdone: bool, pvarargin: *const super::super::System::Variant::VARIANT) -> windows_core::Result<super::super::System::Variant::VARIANT>
    where
        P0: windows_core::Param<IShellView>,
    {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).OnHttpEquiv)(windows_core::Interface::as_raw(self), psv.param().abi(), fdone.into(), core::mem::transmute(pvarargin), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn GetPalette(&self) -> windows_core::Result<super::super::Graphics::Gdi::HPALETTE> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetPalette)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn RegisterWindow(&self, fforceregister: bool, swc: ShellWindowTypeConstants) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).RegisterWindow)(windows_core::Interface::as_raw(self), fforceregister.into(), swc).ok() }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IBrowserService_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_System_Ole")]
    pub GetParentSite: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Ole"))]
    GetParentSite: usize,
    #[cfg(feature = "Win32_System_Ole")]
    pub SetTitle: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Ole"))]
    SetTitle: usize,
    #[cfg(feature = "Win32_System_Ole")]
    pub GetTitle: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, windows_core::PWSTR, u32) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Ole"))]
    GetTitle: usize,
    #[cfg(feature = "Win32_System_Ole")]
    pub GetOleObject: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Ole"))]
    GetOleObject: usize,
    pub GetTravelLog: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub ShowControlWindow: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::BOOL) -> windows_core::HRESULT,
    pub IsControlWindowShown: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut windows_core::BOOL) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub IEGetDisplayName: unsafe extern "system" fn(*mut core::ffi::c_void, *const Common::ITEMIDLIST, windows_core::PWSTR, u32) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_Common"))]
    IEGetDisplayName: usize,
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub IEParseDisplayName: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCWSTR, *mut *mut Common::ITEMIDLIST) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_Common"))]
    IEParseDisplayName: usize,
    pub DisplayParseError: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::HRESULT, windows_core::PCWSTR) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub NavigateToPidl: unsafe extern "system" fn(*mut core::ffi::c_void, *const Common::ITEMIDLIST, u32) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_Common"))]
    NavigateToPidl: usize,
    pub SetNavigateState: unsafe extern "system" fn(*mut core::ffi::c_void, BNSTATE) -> windows_core::HRESULT,
    pub GetNavigateState: unsafe extern "system" fn(*mut core::ffi::c_void, *mut BNSTATE) -> windows_core::HRESULT,
    #[cfg(all(feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
    pub NotifyRedirect: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *const Common::ITEMIDLIST, *mut windows_core::BOOL) -> windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common")))]
    NotifyRedirect: usize,
    pub UpdateWindowList: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub UpdateBackForwardState: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetFlags: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32) -> windows_core::HRESULT,
    pub GetFlags: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub CanNavigateNow: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub GetPidl: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut Common::ITEMIDLIST) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_Common"))]
    GetPidl: usize,
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub SetReferrer: unsafe extern "system" fn(*mut core::ffi::c_void, *const Common::ITEMIDLIST) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_Common"))]
    SetReferrer: usize,
    pub GetBrowserIndex: unsafe extern "system" fn(*mut core::ffi::c_void) -> u32,
    pub GetBrowserByIndex: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub GetHistoryObject: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void, *mut *mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    GetHistoryObject: usize,
    #[cfg(feature = "Win32_System_Ole")]
    pub SetHistoryObject: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, windows_core::BOOL) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Ole"))]
    SetHistoryObject: usize,
    #[cfg(feature = "Win32_System_Ole")]
    pub CacheOLEServer: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Ole"))]
    CacheOLEServer: usize,
    #[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub GetSetCodePage: unsafe extern "system" fn(*mut core::ffi::c_void, *const super::super::System::Variant::VARIANT, *mut super::super::System::Variant::VARIANT) -> windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant")))]
    GetSetCodePage: usize,
    #[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub OnHttpEquiv: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, windows_core::BOOL, *const super::super::System::Variant::VARIANT, *mut super::super::System::Variant::VARIANT) -> windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant")))]
    OnHttpEquiv: usize,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub GetPalette: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Graphics::Gdi::HPALETTE) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))]
    GetPalette: usize,
    pub RegisterWindow: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::BOOL, ShellWindowTypeConstants) -> windows_core::HRESULT,
}
#[cfg(all(feature = "Win32_Graphics_Gdi", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant", feature = "Win32_UI_Shell_Common"))]
pub trait IBrowserService_Impl: windows_core::IUnknownImpl {
    fn GetParentSite(&self) -> windows_core::Result<super::super::System::Ole::IOleInPlaceSite>;
    fn SetTitle(&self, psv: windows_core::Ref<IShellView>, pszname: &windows_core::PCWSTR) -> windows_core::Result<()>;
    fn GetTitle(&self, psv: windows_core::Ref<IShellView>, pszname: windows_core::PWSTR, cchname: u32) -> windows_core::Result<()>;
    fn GetOleObject(&self) -> windows_core::Result<super::super::System::Ole::IOleObject>;
    fn GetTravelLog(&self) -> windows_core::Result<ITravelLog>;
    fn ShowControlWindow(&self, id: u32, fshow: windows_core::BOOL) -> windows_core::Result<()>;
    fn IsControlWindowShown(&self, id: u32) -> windows_core::Result<windows_core::BOOL>;
    fn IEGetDisplayName(&self, pidl: *const Common::ITEMIDLIST, pwszname: windows_core::PWSTR, uflags: u32) -> windows_core::Result<()>;
    fn IEParseDisplayName(&self, uicp: u32, pwszpath: &windows_core::PCWSTR) -> windows_core::Result<*mut Common::ITEMIDLIST>;
    fn DisplayParseError(&self, hres: windows_core::HRESULT, pwszpath: &windows_core::PCWSTR) -> windows_core::Result<()>;
    fn NavigateToPidl(&self, pidl: *const Common::ITEMIDLIST, grfhlnf: u32) -> windows_core::Result<()>;
    fn SetNavigateState(&self, bnstate: BNSTATE) -> windows_core::Result<()>;
    fn GetNavigateState(&self) -> windows_core::Result<BNSTATE>;
    fn NotifyRedirect(&self, psv: windows_core::Ref<IShellView>, pidl: *const Common::ITEMIDLIST) -> windows_core::Result<windows_core::BOOL>;
    fn UpdateWindowList(&self) -> windows_core::Result<()>;
    fn UpdateBackForwardState(&self) -> windows_core::Result<()>;
    fn SetFlags(&self, dwflags: u32, dwflagmask: u32) -> windows_core::Result<()>;
    fn GetFlags(&self) -> windows_core::Result<u32>;
    fn CanNavigateNow(&self) -> windows_core::Result<()>;
    fn GetPidl(&self) -> windows_core::Result<*mut Common::ITEMIDLIST>;
    fn SetReferrer(&self, pidl: *const Common::ITEMIDLIST) -> windows_core::Result<()>;
    fn GetBrowserIndex(&self) -> u32;
    fn GetBrowserByIndex(&self, dwid: u32) -> windows_core::Result<windows_core::IUnknown>;
    fn GetHistoryObject(&self, ppole: windows_core::OutRef<super::super::System::Ole::IOleObject>, pstm: windows_core::OutRef<super::super::System::Com::IStream>, ppbc: windows_core::OutRef<super::super::System::Com::IBindCtx>) -> windows_core::Result<()>;
    fn SetHistoryObject(&self, pole: windows_core::Ref<super::super::System::Ole::IOleObject>, fislocalanchor: windows_core::BOOL) -> windows_core::Result<()>;
    fn CacheOLEServer(&self, pole: windows_core::Ref<super::super::System::Ole::IOleObject>) -> windows_core::Result<()>;
    fn GetSetCodePage(&self, pvarin: *const super::super::System::Variant::VARIANT) -> windows_core::Result<super::super::System::Variant::VARIANT>;
    fn OnHttpEquiv(&self, psv: windows_core::Ref<IShellView>, fdone: windows_core::BOOL, pvarargin: *const super::super::System::Variant::VARIANT) -> windows_core::Result<super::super::System::Variant::VARIANT>;
    fn GetPalette(&self) -> windows_core::Result<super::super::Graphics::Gdi::HPALETTE>;
    fn RegisterWindow(&self, fforceregister: windows_core::BOOL, swc: ShellWindowTypeConstants) -> windows_core::Result<()>;
}
#[cfg(all(feature = "Win32_Graphics_Gdi", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant", feature = "Win32_UI_Shell_Common"))]
impl IBrowserService_Vtbl {
    pub const fn new<Identity: IBrowserService_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetParentSite<Identity: IBrowserService_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ppipsite: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IBrowserService_Impl::GetParentSite(this) {
                    Ok(ok__) => {
                        ppipsite.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetTitle<Identity: IBrowserService_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, psv: *mut core::ffi::c_void, pszname: windows_core::PCWSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBrowserService_Impl::SetTitle(this, core::mem::transmute_copy(&psv), core::mem::transmute(&pszname)).into()
            }
        }
        unsafe extern "system" fn GetTitle<Identity: IBrowserService_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, psv: *mut core::ffi::c_void, pszname: windows_core::PWSTR, cchname: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBrowserService_Impl::GetTitle(this, core::mem::transmute_copy(&psv), core::mem::transmute_copy(&pszname), core::mem::transmute_copy(&cchname)).into()
            }
        }
        unsafe extern "system" fn GetOleObject<Identity: IBrowserService_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ppobjv: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IBrowserService_Impl::GetOleObject(this) {
                    Ok(ok__) => {
                        ppobjv.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetTravelLog<Identity: IBrowserService_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pptl: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IBrowserService_Impl::GetTravelLog(this) {
                    Ok(ok__) => {
                        pptl.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn ShowControlWindow<Identity: IBrowserService_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, id: u32, fshow: windows_core::BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBrowserService_Impl::ShowControlWindow(this, core::mem::transmute_copy(&id), core::mem::transmute_copy(&fshow)).into()
            }
        }
        unsafe extern "system" fn IsControlWindowShown<Identity: IBrowserService_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, id: u32, pfshown: *mut windows_core::BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IBrowserService_Impl::IsControlWindowShown(this, core::mem::transmute_copy(&id)) {
                    Ok(ok__) => {
                        pfshown.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn IEGetDisplayName<Identity: IBrowserService_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pidl: *const Common::ITEMIDLIST, pwszname: windows_core::PWSTR, uflags: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBrowserService_Impl::IEGetDisplayName(this, core::mem::transmute_copy(&pidl), core::mem::transmute_copy(&pwszname), core::mem::transmute_copy(&uflags)).into()
            }
        }
        unsafe extern "system" fn IEParseDisplayName<Identity: IBrowserService_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, uicp: u32, pwszpath: windows_core::PCWSTR, ppidlout: *mut *mut Common::ITEMIDLIST) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IBrowserService_Impl::IEParseDisplayName(this, core::mem::transmute_copy(&uicp), core::mem::transmute(&pwszpath)) {
                    Ok(ok__) => {
                        ppidlout.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn DisplayParseError<Identity: IBrowserService_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, hres: windows_core::HRESULT, pwszpath: windows_core::PCWSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBrowserService_Impl::DisplayParseError(this, core::mem::transmute_copy(&hres), core::mem::transmute(&pwszpath)).into()
            }
        }
        unsafe extern "system" fn NavigateToPidl<Identity: IBrowserService_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pidl: *const Common::ITEMIDLIST, grfhlnf: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBrowserService_Impl::NavigateToPidl(this, core::mem::transmute_copy(&pidl), core::mem::transmute_copy(&grfhlnf)).into()
            }
        }
        unsafe extern "system" fn SetNavigateState<Identity: IBrowserService_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, bnstate: BNSTATE) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBrowserService_Impl::SetNavigateState(this, core::mem::transmute_copy(&bnstate)).into()
            }
        }
        unsafe extern "system" fn GetNavigateState<Identity: IBrowserService_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbnstate: *mut BNSTATE) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IBrowserService_Impl::GetNavigateState(this) {
                    Ok(ok__) => {
                        pbnstate.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn NotifyRedirect<Identity: IBrowserService_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, psv: *mut core::ffi::c_void, pidl: *const Common::ITEMIDLIST, pfdidbrowse: *mut windows_core::BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IBrowserService_Impl::NotifyRedirect(this, core::mem::transmute_copy(&psv), core::mem::transmute_copy(&pidl)) {
                    Ok(ok__) => {
                        pfdidbrowse.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn UpdateWindowList<Identity: IBrowserService_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBrowserService_Impl::UpdateWindowList(this).into()
            }
        }
        unsafe extern "system" fn UpdateBackForwardState<Identity: IBrowserService_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBrowserService_Impl::UpdateBackForwardState(this).into()
            }
        }
        unsafe extern "system" fn SetFlags<Identity: IBrowserService_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwflags: u32, dwflagmask: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBrowserService_Impl::SetFlags(this, core::mem::transmute_copy(&dwflags), core::mem::transmute_copy(&dwflagmask)).into()
            }
        }
        unsafe extern "system" fn GetFlags<Identity: IBrowserService_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pdwflags: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IBrowserService_Impl::GetFlags(this) {
                    Ok(ok__) => {
                        pdwflags.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn CanNavigateNow<Identity: IBrowserService_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBrowserService_Impl::CanNavigateNow(this).into()
            }
        }
        unsafe extern "system" fn GetPidl<Identity: IBrowserService_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ppidl: *mut *mut Common::ITEMIDLIST) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IBrowserService_Impl::GetPidl(this) {
                    Ok(ok__) => {
                        ppidl.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetReferrer<Identity: IBrowserService_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pidl: *const Common::ITEMIDLIST) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBrowserService_Impl::SetReferrer(this, core::mem::transmute_copy(&pidl)).into()
            }
        }
        unsafe extern "system" fn GetBrowserIndex<Identity: IBrowserService_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> u32 {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBrowserService_Impl::GetBrowserIndex(this)
            }
        }
        unsafe extern "system" fn GetBrowserByIndex<Identity: IBrowserService_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwid: u32, ppunk: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IBrowserService_Impl::GetBrowserByIndex(this, core::mem::transmute_copy(&dwid)) {
                    Ok(ok__) => {
                        ppunk.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetHistoryObject<Identity: IBrowserService_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ppole: *mut *mut core::ffi::c_void, pstm: *mut *mut core::ffi::c_void, ppbc: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBrowserService_Impl::GetHistoryObject(this, core::mem::transmute_copy(&ppole), core::mem::transmute_copy(&pstm), core::mem::transmute_copy(&ppbc)).into()
            }
        }
        unsafe extern "system" fn SetHistoryObject<Identity: IBrowserService_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pole: *mut core::ffi::c_void, fislocalanchor: windows_core::BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBrowserService_Impl::SetHistoryObject(this, core::mem::transmute_copy(&pole), core::mem::transmute_copy(&fislocalanchor)).into()
            }
        }
        unsafe extern "system" fn CacheOLEServer<Identity: IBrowserService_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pole: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBrowserService_Impl::CacheOLEServer(this, core::mem::transmute_copy(&pole)).into()
            }
        }
        unsafe extern "system" fn GetSetCodePage<Identity: IBrowserService_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pvarin: *const super::super::System::Variant::VARIANT, pvarout: *mut super::super::System::Variant::VARIANT) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IBrowserService_Impl::GetSetCodePage(this, core::mem::transmute_copy(&pvarin)) {
                    Ok(ok__) => {
                        pvarout.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn OnHttpEquiv<Identity: IBrowserService_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, psv: *mut core::ffi::c_void, fdone: windows_core::BOOL, pvarargin: *const super::super::System::Variant::VARIANT, pvarargout: *mut super::super::System::Variant::VARIANT) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IBrowserService_Impl::OnHttpEquiv(this, core::mem::transmute_copy(&psv), core::mem::transmute_copy(&fdone), core::mem::transmute_copy(&pvarargin)) {
                    Ok(ok__) => {
                        pvarargout.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetPalette<Identity: IBrowserService_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, hpal: *mut super::super::Graphics::Gdi::HPALETTE) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IBrowserService_Impl::GetPalette(this) {
                    Ok(ok__) => {
                        hpal.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn RegisterWindow<Identity: IBrowserService_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, fforceregister: windows_core::BOOL, swc: ShellWindowTypeConstants) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBrowserService_Impl::RegisterWindow(this, core::mem::transmute_copy(&fforceregister), core::mem::transmute_copy(&swc)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            GetParentSite: GetParentSite::<Identity, OFFSET>,
            SetTitle: SetTitle::<Identity, OFFSET>,
            GetTitle: GetTitle::<Identity, OFFSET>,
            GetOleObject: GetOleObject::<Identity, OFFSET>,
            GetTravelLog: GetTravelLog::<Identity, OFFSET>,
            ShowControlWindow: ShowControlWindow::<Identity, OFFSET>,
            IsControlWindowShown: IsControlWindowShown::<Identity, OFFSET>,
            IEGetDisplayName: IEGetDisplayName::<Identity, OFFSET>,
            IEParseDisplayName: IEParseDisplayName::<Identity, OFFSET>,
            DisplayParseError: DisplayParseError::<Identity, OFFSET>,
            NavigateToPidl: NavigateToPidl::<Identity, OFFSET>,
            SetNavigateState: SetNavigateState::<Identity, OFFSET>,
            GetNavigateState: GetNavigateState::<Identity, OFFSET>,
            NotifyRedirect: NotifyRedirect::<Identity, OFFSET>,
            UpdateWindowList: UpdateWindowList::<Identity, OFFSET>,
            UpdateBackForwardState: UpdateBackForwardState::<Identity, OFFSET>,
            SetFlags: SetFlags::<Identity, OFFSET>,
            GetFlags: GetFlags::<Identity, OFFSET>,
            CanNavigateNow: CanNavigateNow::<Identity, OFFSET>,
            GetPidl: GetPidl::<Identity, OFFSET>,
            SetReferrer: SetReferrer::<Identity, OFFSET>,
            GetBrowserIndex: GetBrowserIndex::<Identity, OFFSET>,
            GetBrowserByIndex: GetBrowserByIndex::<Identity, OFFSET>,
            GetHistoryObject: GetHistoryObject::<Identity, OFFSET>,
            SetHistoryObject: SetHistoryObject::<Identity, OFFSET>,
            CacheOLEServer: CacheOLEServer::<Identity, OFFSET>,
            GetSetCodePage: GetSetCodePage::<Identity, OFFSET>,
            OnHttpEquiv: OnHttpEquiv::<Identity, OFFSET>,
            GetPalette: GetPalette::<Identity, OFFSET>,
            RegisterWindow: RegisterWindow::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IBrowserService as windows_core::Interface>::IID
    }
}
#[cfg(all(feature = "Win32_Graphics_Gdi", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant", feature = "Win32_UI_Shell_Common"))]
impl windows_core::RuntimeName for IBrowserService {}
windows_core::imp::define_interface!(IBrowserService2, IBrowserService2_Vtbl, 0x68bd21cc_438b_11d2_a560_00a0c92dbfe8);
impl core::ops::Deref for IBrowserService2 {
    type Target = IBrowserService;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IBrowserService2, windows_core::IUnknown, IBrowserService);
impl IBrowserService2 {
    pub unsafe fn WndProcBS(&self, hwnd: super::super::Foundation::HWND, umsg: u32, wparam: super::super::Foundation::WPARAM, lparam: super::super::Foundation::LPARAM) -> super::super::Foundation::LRESULT {
        unsafe { (windows_core::Interface::vtable(self).WndProcBS)(windows_core::Interface::as_raw(self), hwnd, umsg, wparam, lparam) }
    }
    pub unsafe fn SetAsDefFolderSettings(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetAsDefFolderSettings)(windows_core::Interface::as_raw(self)).ok() }
    }
    pub unsafe fn GetViewRect(&self) -> windows_core::Result<super::super::Foundation::RECT> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetViewRect)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn OnSize(&self, wparam: super::super::Foundation::WPARAM) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).OnSize)(windows_core::Interface::as_raw(self), wparam).ok() }
    }
    #[cfg(feature = "Win32_UI_WindowsAndMessaging")]
    pub unsafe fn OnCreate(&self, pcs: *const super::WindowsAndMessaging::CREATESTRUCTW) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).OnCreate)(windows_core::Interface::as_raw(self), pcs).ok() }
    }
    pub unsafe fn OnCommand(&self, wparam: super::super::Foundation::WPARAM, lparam: super::super::Foundation::LPARAM) -> super::super::Foundation::LRESULT {
        unsafe { (windows_core::Interface::vtable(self).OnCommand)(windows_core::Interface::as_raw(self), wparam, lparam) }
    }
    pub unsafe fn OnDestroy(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).OnDestroy)(windows_core::Interface::as_raw(self)).ok() }
    }
    #[cfg(feature = "Win32_UI_Controls")]
    pub unsafe fn OnNotify(&self, pnm: *const super::Controls::NMHDR) -> super::super::Foundation::LRESULT {
        unsafe { (windows_core::Interface::vtable(self).OnNotify)(windows_core::Interface::as_raw(self), pnm) }
    }
    pub unsafe fn OnSetFocus(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).OnSetFocus)(windows_core::Interface::as_raw(self)).ok() }
    }
    pub unsafe fn OnFrameWindowActivateBS(&self, factive: bool) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).OnFrameWindowActivateBS)(windows_core::Interface::as_raw(self), factive.into()).ok() }
    }
    pub unsafe fn ReleaseShellView(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).ReleaseShellView)(windows_core::Interface::as_raw(self)).ok() }
    }
    pub unsafe fn ActivatePendingView(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).ActivatePendingView)(windows_core::Interface::as_raw(self)).ok() }
    }
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn CreateViewWindow<P0, P1>(&self, psvnew: P0, psvold: P1, prcview: *const super::super::Foundation::RECT) -> windows_core::Result<super::super::Foundation::HWND>
    where
        P0: windows_core::Param<IShellView>,
        P1: windows_core::Param<IShellView>,
    {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).CreateViewWindow)(windows_core::Interface::as_raw(self), psvnew.param().abi(), psvold.param().abi(), prcview, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn CreateBrowserPropSheetExt(&self, riid: *const windows_core::GUID, ppv: *mut *mut core::ffi::c_void) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).CreateBrowserPropSheetExt)(windows_core::Interface::as_raw(self), riid, ppv as _).ok() }
    }
    pub unsafe fn GetViewWindow(&self) -> windows_core::Result<super::super::Foundation::HWND> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetViewWindow)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    #[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
    pub unsafe fn GetBaseBrowserData(&self) -> windows_core::Result<*mut BASEBROWSERDATALH> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetBaseBrowserData)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    #[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
    pub unsafe fn PutBaseBrowserData(&self) -> *mut BASEBROWSERDATALH {
        unsafe { (windows_core::Interface::vtable(self).PutBaseBrowserData)(windows_core::Interface::as_raw(self)) }
    }
    pub unsafe fn InitializeTravelLog<P0>(&self, ptl: P0, dw: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ITravelLog>,
    {
        unsafe { (windows_core::Interface::vtable(self).InitializeTravelLog)(windows_core::Interface::as_raw(self), ptl.param().abi(), dw).ok() }
    }
    pub unsafe fn SetTopBrowser(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetTopBrowser)(windows_core::Interface::as_raw(self)).ok() }
    }
    pub unsafe fn Offline(&self, icmd: i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).Offline)(windows_core::Interface::as_raw(self), icmd).ok() }
    }
    pub unsafe fn AllowViewResize(&self, f: bool) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).AllowViewResize)(windows_core::Interface::as_raw(self), f.into()).ok() }
    }
    pub unsafe fn SetActivateState(&self, u: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetActivateState)(windows_core::Interface::as_raw(self), u).ok() }
    }
    pub unsafe fn UpdateSecureLockIcon(&self, esecurelock: i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).UpdateSecureLockIcon)(windows_core::Interface::as_raw(self), esecurelock).ok() }
    }
    pub unsafe fn InitializeDownloadManager(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).InitializeDownloadManager)(windows_core::Interface::as_raw(self)).ok() }
    }
    pub unsafe fn InitializeTransitionSite(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).InitializeTransitionSite)(windows_core::Interface::as_raw(self)).ok() }
    }
    pub unsafe fn _Initialize<P1>(&self, hwnd: super::super::Foundation::HWND, pauto: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<windows_core::IUnknown>,
    {
        unsafe { (windows_core::Interface::vtable(self)._Initialize)(windows_core::Interface::as_raw(self), hwnd, pauto.param().abi()).ok() }
    }
    pub unsafe fn _CancelPendingNavigationAsync(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self)._CancelPendingNavigationAsync)(windows_core::Interface::as_raw(self)).ok() }
    }
    pub unsafe fn _CancelPendingView(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self)._CancelPendingView)(windows_core::Interface::as_raw(self)).ok() }
    }
    pub unsafe fn _MaySaveChanges(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self)._MaySaveChanges)(windows_core::Interface::as_raw(self)).ok() }
    }
    pub unsafe fn _PauseOrResumeView(&self, fpaused: bool) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self)._PauseOrResumeView)(windows_core::Interface::as_raw(self), fpaused.into()).ok() }
    }
    pub unsafe fn _DisableModeless(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self)._DisableModeless)(windows_core::Interface::as_raw(self)).ok() }
    }
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn _NavigateToPidl2(&self, pidl: *const Common::ITEMIDLIST, grfhlnf: u32, dwflags: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self)._NavigateToPidl2)(windows_core::Interface::as_raw(self), pidl, grfhlnf, dwflags).ok() }
    }
    #[cfg(all(feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
    pub unsafe fn _TryShell2Rename<P0>(&self, psv: P0, pidlnew: *const Common::ITEMIDLIST) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IShellView>,
    {
        unsafe { (windows_core::Interface::vtable(self)._TryShell2Rename)(windows_core::Interface::as_raw(self), psv.param().abi(), pidlnew).ok() }
    }
    pub unsafe fn _SwitchActivationNow(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self)._SwitchActivationNow)(windows_core::Interface::as_raw(self)).ok() }
    }
    #[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub unsafe fn _ExecChildren<P0>(&self, punkbar: P0, fbroadcast: bool, pguidcmdgroup: Option<*const windows_core::GUID>, ncmdid: u32, ncmdexecopt: u32, pvarargin: Option<*const super::super::System::Variant::VARIANT>, pvarargout: Option<*mut super::super::System::Variant::VARIANT>) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::IUnknown>,
    {
        unsafe { (windows_core::Interface::vtable(self)._ExecChildren)(windows_core::Interface::as_raw(self), punkbar.param().abi(), fbroadcast.into(), pguidcmdgroup.unwrap_or(core::mem::zeroed()) as _, ncmdid, ncmdexecopt, pvarargin.unwrap_or(core::mem::zeroed()) as _, pvarargout.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
    pub unsafe fn _SendChildren(&self, hwndbar: super::super::Foundation::HWND, fbroadcast: bool, umsg: u32, wparam: super::super::Foundation::WPARAM, lparam: super::super::Foundation::LPARAM) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self)._SendChildren)(windows_core::Interface::as_raw(self), hwndbar, fbroadcast.into(), umsg, wparam, lparam).ok() }
    }
    pub unsafe fn GetFolderSetData(&self, pfsd: *mut FOLDERSETDATA) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetFolderSetData)(windows_core::Interface::as_raw(self), pfsd as _).ok() }
    }
    pub unsafe fn _OnFocusChange(&self, itb: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self)._OnFocusChange)(windows_core::Interface::as_raw(self), itb).ok() }
    }
    pub unsafe fn v_ShowHideChildWindows(&self, fchildonly: bool) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).v_ShowHideChildWindows)(windows_core::Interface::as_raw(self), fchildonly.into()).ok() }
    }
    pub unsafe fn _get_itbLastFocus(&self) -> u32 {
        unsafe { (windows_core::Interface::vtable(self)._get_itbLastFocus)(windows_core::Interface::as_raw(self)) }
    }
    pub unsafe fn _put_itbLastFocus(&self, itblastfocus: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self)._put_itbLastFocus)(windows_core::Interface::as_raw(self), itblastfocus).ok() }
    }
    pub unsafe fn _UIActivateView(&self, ustate: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self)._UIActivateView)(windows_core::Interface::as_raw(self), ustate).ok() }
    }
    pub unsafe fn _GetViewBorderRect(&self, prc: *mut super::super::Foundation::RECT) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self)._GetViewBorderRect)(windows_core::Interface::as_raw(self), prc as _).ok() }
    }
    pub unsafe fn _UpdateViewRectSize(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self)._UpdateViewRectSize)(windows_core::Interface::as_raw(self)).ok() }
    }
    pub unsafe fn _ResizeNextBorder(&self, itb: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self)._ResizeNextBorder)(windows_core::Interface::as_raw(self), itb).ok() }
    }
    pub unsafe fn _ResizeView(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self)._ResizeView)(windows_core::Interface::as_raw(self)).ok() }
    }
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn _GetEffectiveClientArea(&self, lprectborder: *mut super::super::Foundation::RECT, hmon: super::super::Graphics::Gdi::HMONITOR) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self)._GetEffectiveClientArea)(windows_core::Interface::as_raw(self), lprectborder as _, hmon).ok() }
    }
    #[cfg(all(feature = "Win32_System_Com", feature = "Win32_UI_Shell_Common"))]
    pub unsafe fn v_GetViewStream<P2>(&self, pidl: *mut Common::ITEMIDLIST, grfmode: u32, pwszname: P2) -> Option<super::super::System::Com::IStream>
    where
        P2: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).v_GetViewStream)(windows_core::Interface::as_raw(self), pidl as _, grfmode, pwszname.param().abi()) }
    }
    pub unsafe fn ForwardViewMsg(&self, umsg: u32, wparam: super::super::Foundation::WPARAM, lparam: super::super::Foundation::LPARAM) -> super::super::Foundation::LRESULT {
        unsafe { (windows_core::Interface::vtable(self).ForwardViewMsg)(windows_core::Interface::as_raw(self), umsg, wparam, lparam) }
    }
    #[cfg(feature = "Win32_UI_WindowsAndMessaging")]
    pub unsafe fn SetAcceleratorMenu(&self, hacc: super::WindowsAndMessaging::HACCEL) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetAcceleratorMenu)(windows_core::Interface::as_raw(self), hacc).ok() }
    }
    pub unsafe fn _GetToolbarCount(&self) -> i32 {
        unsafe { (windows_core::Interface::vtable(self)._GetToolbarCount)(windows_core::Interface::as_raw(self)) }
    }
    #[cfg(all(feature = "Win32_Graphics_Gdi", feature = "Win32_System_Ole"))]
    pub unsafe fn _GetToolbarItem(&self, itb: i32) -> *mut TOOLBARITEM {
        unsafe { (windows_core::Interface::vtable(self)._GetToolbarItem)(windows_core::Interface::as_raw(self), itb) }
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn _SaveToolbars<P0>(&self, pstm: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::System::Com::IStream>,
    {
        unsafe { (windows_core::Interface::vtable(self)._SaveToolbars)(windows_core::Interface::as_raw(self), pstm.param().abi()).ok() }
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn _LoadToolbars<P0>(&self, pstm: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::System::Com::IStream>,
    {
        unsafe { (windows_core::Interface::vtable(self)._LoadToolbars)(windows_core::Interface::as_raw(self), pstm.param().abi()).ok() }
    }
    pub unsafe fn _CloseAndReleaseToolbars(&self, fclose: bool) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self)._CloseAndReleaseToolbars)(windows_core::Interface::as_raw(self), fclose.into()).ok() }
    }
    #[cfg(all(feature = "Win32_Graphics_Gdi", feature = "Win32_System_Ole", feature = "Win32_UI_WindowsAndMessaging"))]
    pub unsafe fn v_MayGetNextToolbarFocus(&self, lpmsg: *const super::WindowsAndMessaging::MSG, itbnext: u32, citb: i32, pptbi: *mut *mut TOOLBARITEM, phwnd: *mut super::super::Foundation::HWND) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).v_MayGetNextToolbarFocus)(windows_core::Interface::as_raw(self), lpmsg, itbnext, citb, pptbi as _, phwnd as _).ok() }
    }
    pub unsafe fn _ResizeNextBorderHelper(&self, itb: u32, busehmonitor: bool) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self)._ResizeNextBorderHelper)(windows_core::Interface::as_raw(self), itb, busehmonitor.into()).ok() }
    }
    pub unsafe fn _FindTBar<P0>(&self, punksrc: P0) -> u32
    where
        P0: windows_core::Param<windows_core::IUnknown>,
    {
        unsafe { (windows_core::Interface::vtable(self)._FindTBar)(windows_core::Interface::as_raw(self), punksrc.param().abi()) }
    }
    #[cfg(all(feature = "Win32_Graphics_Gdi", feature = "Win32_System_Ole", feature = "Win32_UI_WindowsAndMessaging"))]
    pub unsafe fn _SetFocus(&self, ptbi: *const TOOLBARITEM, hwnd: super::super::Foundation::HWND, lpmsg: *const super::WindowsAndMessaging::MSG) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self)._SetFocus)(windows_core::Interface::as_raw(self), core::mem::transmute(ptbi), hwnd, lpmsg).ok() }
    }
    #[cfg(feature = "Win32_UI_WindowsAndMessaging")]
    pub unsafe fn v_MayTranslateAccelerator(&self, pmsg: *mut super::WindowsAndMessaging::MSG) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).v_MayTranslateAccelerator)(windows_core::Interface::as_raw(self), pmsg as _).ok() }
    }
    pub unsafe fn _GetBorderDWHelper<P0>(&self, punksrc: P0, lprectborder: *mut super::super::Foundation::RECT, busehmonitor: bool) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::IUnknown>,
    {
        unsafe { (windows_core::Interface::vtable(self)._GetBorderDWHelper)(windows_core::Interface::as_raw(self), punksrc.param().abi(), lprectborder as _, busehmonitor.into()).ok() }
    }
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn v_CheckZoneCrossing(&self, pidl: *const Common::ITEMIDLIST) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).v_CheckZoneCrossing)(windows_core::Interface::as_raw(self), pidl).ok() }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IBrowserService2_Vtbl {
    pub base__: IBrowserService_Vtbl,
    pub WndProcBS: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::HWND, u32, super::super::Foundation::WPARAM, super::super::Foundation::LPARAM) -> super::super::Foundation::LRESULT,
    pub SetAsDefFolderSettings: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetViewRect: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Foundation::RECT) -> windows_core::HRESULT,
    pub OnSize: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::WPARAM) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_UI_WindowsAndMessaging")]
    pub OnCreate: unsafe extern "system" fn(*mut core::ffi::c_void, *const super::WindowsAndMessaging::CREATESTRUCTW) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_WindowsAndMessaging"))]
    OnCreate: usize,
    pub OnCommand: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::WPARAM, super::super::Foundation::LPARAM) -> super::super::Foundation::LRESULT,
    pub OnDestroy: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_UI_Controls")]
    pub OnNotify: unsafe extern "system" fn(*mut core::ffi::c_void, *const super::Controls::NMHDR) -> super::super::Foundation::LRESULT,
    #[cfg(not(feature = "Win32_UI_Controls"))]
    OnNotify: usize,
    pub OnSetFocus: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub OnFrameWindowActivateBS: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::BOOL) -> windows_core::HRESULT,
    pub ReleaseShellView: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub ActivatePendingView: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_System_Ole")]
    pub CreateViewWindow: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut core::ffi::c_void, *const super::super::Foundation::RECT, *mut super::super::Foundation::HWND) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Ole"))]
    CreateViewWindow: usize,
    pub CreateBrowserPropSheetExt: unsafe extern "system" fn(*mut core::ffi::c_void, *const windows_core::GUID, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetViewWindow: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Foundation::HWND) -> windows_core::HRESULT,
    #[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
    pub GetBaseBrowserData: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut BASEBROWSERDATALH) -> windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common")))]
    GetBaseBrowserData: usize,
    #[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
    pub PutBaseBrowserData: unsafe extern "system" fn(*mut core::ffi::c_void) -> *mut BASEBROWSERDATALH,
    #[cfg(not(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common")))]
    PutBaseBrowserData: usize,
    pub InitializeTravelLog: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub SetTopBrowser: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub Offline: unsafe extern "system" fn(*mut core::ffi::c_void, i32) -> windows_core::HRESULT,
    pub AllowViewResize: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::BOOL) -> windows_core::HRESULT,
    pub SetActivateState: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub UpdateSecureLockIcon: unsafe extern "system" fn(*mut core::ffi::c_void, i32) -> windows_core::HRESULT,
    pub InitializeDownloadManager: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub InitializeTransitionSite: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub _Initialize: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::HWND, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub _CancelPendingNavigationAsync: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub _CancelPendingView: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub _MaySaveChanges: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub _PauseOrResumeView: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::BOOL) -> windows_core::HRESULT,
    pub _DisableModeless: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub _NavigateToPidl2: unsafe extern "system" fn(*mut core::ffi::c_void, *const Common::ITEMIDLIST, u32, u32) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_Common"))]
    _NavigateToPidl2: usize,
    #[cfg(all(feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
    pub _TryShell2Rename: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *const Common::ITEMIDLIST) -> windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common")))]
    _TryShell2Rename: usize,
    pub _SwitchActivationNow: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub _ExecChildren: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, windows_core::BOOL, *const windows_core::GUID, u32, u32, *const super::super::System::Variant::VARIANT, *mut super::super::System::Variant::VARIANT) -> windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant")))]
    _ExecChildren: usize,
    pub _SendChildren: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::HWND, windows_core::BOOL, u32, super::super::Foundation::WPARAM, super::super::Foundation::LPARAM) -> windows_core::HRESULT,
    pub GetFolderSetData: unsafe extern "system" fn(*mut core::ffi::c_void, *mut FOLDERSETDATA) -> windows_core::HRESULT,
    pub _OnFocusChange: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub v_ShowHideChildWindows: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::BOOL) -> windows_core::HRESULT,
    pub _get_itbLastFocus: unsafe extern "system" fn(*mut core::ffi::c_void) -> u32,
    pub _put_itbLastFocus: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub _UIActivateView: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub _GetViewBorderRect: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Foundation::RECT) -> windows_core::HRESULT,
    pub _UpdateViewRectSize: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub _ResizeNextBorder: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub _ResizeView: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub _GetEffectiveClientArea: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Foundation::RECT, super::super::Graphics::Gdi::HMONITOR) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))]
    _GetEffectiveClientArea: usize,
    #[cfg(all(feature = "Win32_System_Com", feature = "Win32_UI_Shell_Common"))]
    pub v_GetViewStream: unsafe extern "system" fn(*mut core::ffi::c_void, *mut Common::ITEMIDLIST, u32, windows_core::PCWSTR) -> Option<super::super::System::Com::IStream>,
    #[cfg(not(all(feature = "Win32_System_Com", feature = "Win32_UI_Shell_Common")))]
    v_GetViewStream: usize,
    pub ForwardViewMsg: unsafe extern "system" fn(*mut core::ffi::c_void, u32, super::super::Foundation::WPARAM, super::super::Foundation::LPARAM) -> super::super::Foundation::LRESULT,
    #[cfg(feature = "Win32_UI_WindowsAndMessaging")]
    pub SetAcceleratorMenu: unsafe extern "system" fn(*mut core::ffi::c_void, super::WindowsAndMessaging::HACCEL) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_WindowsAndMessaging"))]
    SetAcceleratorMenu: usize,
    pub _GetToolbarCount: unsafe extern "system" fn(*mut core::ffi::c_void) -> i32,
    #[cfg(all(feature = "Win32_Graphics_Gdi", feature = "Win32_System_Ole"))]
    pub _GetToolbarItem: unsafe extern "system" fn(*mut core::ffi::c_void, i32) -> *mut TOOLBARITEM,
    #[cfg(not(all(feature = "Win32_Graphics_Gdi", feature = "Win32_System_Ole")))]
    _GetToolbarItem: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub _SaveToolbars: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    _SaveToolbars: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub _LoadToolbars: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    _LoadToolbars: usize,
    pub _CloseAndReleaseToolbars: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::BOOL) -> windows_core::HRESULT,
    #[cfg(all(feature = "Win32_Graphics_Gdi", feature = "Win32_System_Ole", feature = "Win32_UI_WindowsAndMessaging"))]
    pub v_MayGetNextToolbarFocus: unsafe extern "system" fn(*mut core::ffi::c_void, *const super::WindowsAndMessaging::MSG, u32, i32, *mut *mut TOOLBARITEM, *mut super::super::Foundation::HWND) -> windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_Graphics_Gdi", feature = "Win32_System_Ole", feature = "Win32_UI_WindowsAndMessaging")))]
    v_MayGetNextToolbarFocus: usize,
    pub _ResizeNextBorderHelper: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::BOOL) -> windows_core::HRESULT,
    pub _FindTBar: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> u32,
    #[cfg(all(feature = "Win32_Graphics_Gdi", feature = "Win32_System_Ole", feature = "Win32_UI_WindowsAndMessaging"))]
    pub _SetFocus: unsafe extern "system" fn(*mut core::ffi::c_void, *const TOOLBARITEM, super::super::Foundation::HWND, *const super::WindowsAndMessaging::MSG) -> windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_Graphics_Gdi", feature = "Win32_System_Ole", feature = "Win32_UI_WindowsAndMessaging")))]
    _SetFocus: usize,
    #[cfg(feature = "Win32_UI_WindowsAndMessaging")]
    pub v_MayTranslateAccelerator: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::WindowsAndMessaging::MSG) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_WindowsAndMessaging"))]
    v_MayTranslateAccelerator: usize,
    pub _GetBorderDWHelper: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut super::super::Foundation::RECT, windows_core::BOOL) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub v_CheckZoneCrossing: unsafe extern "system" fn(*mut core::ffi::c_void, *const Common::ITEMIDLIST) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_Common"))]
    v_CheckZoneCrossing: usize,
}
#[cfg(all(feature = "Win32_Graphics_Gdi", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant", feature = "Win32_UI_Controls", feature = "Win32_UI_Shell_Common", feature = "Win32_UI_WindowsAndMessaging"))]
pub trait IBrowserService2_Impl: IBrowserService_Impl {
    fn WndProcBS(&self, hwnd: super::super::Foundation::HWND, umsg: u32, wparam: super::super::Foundation::WPARAM, lparam: super::super::Foundation::LPARAM) -> super::super::Foundation::LRESULT;
    fn SetAsDefFolderSettings(&self) -> windows_core::Result<()>;
    fn GetViewRect(&self) -> windows_core::Result<super::super::Foundation::RECT>;
    fn OnSize(&self, wparam: super::super::Foundation::WPARAM) -> windows_core::Result<()>;
    fn OnCreate(&self, pcs: *const super::WindowsAndMessaging::CREATESTRUCTW) -> windows_core::Result<()>;
    fn OnCommand(&self, wparam: super::super::Foundation::WPARAM, lparam: super::super::Foundation::LPARAM) -> super::super::Foundation::LRESULT;
    fn OnDestroy(&self) -> windows_core::Result<()>;
    fn OnNotify(&self, pnm: *const super::Controls::NMHDR) -> super::super::Foundation::LRESULT;
    fn OnSetFocus(&self) -> windows_core::Result<()>;
    fn OnFrameWindowActivateBS(&self, factive: windows_core::BOOL) -> windows_core::Result<()>;
    fn ReleaseShellView(&self) -> windows_core::Result<()>;
    fn ActivatePendingView(&self) -> windows_core::Result<()>;
    fn CreateViewWindow(&self, psvnew: windows_core::Ref<IShellView>, psvold: windows_core::Ref<IShellView>, prcview: *const super::super::Foundation::RECT) -> windows_core::Result<super::super::Foundation::HWND>;
    fn CreateBrowserPropSheetExt(&self, riid: *const windows_core::GUID, ppv: *mut *mut core::ffi::c_void) -> windows_core::Result<()>;
    fn GetViewWindow(&self) -> windows_core::Result<super::super::Foundation::HWND>;
    fn GetBaseBrowserData(&self) -> windows_core::Result<*mut BASEBROWSERDATALH>;
    fn PutBaseBrowserData(&self) -> *mut BASEBROWSERDATALH;
    fn InitializeTravelLog(&self, ptl: windows_core::Ref<ITravelLog>, dw: u32) -> windows_core::Result<()>;
    fn SetTopBrowser(&self) -> windows_core::Result<()>;
    fn Offline(&self, icmd: i32) -> windows_core::Result<()>;
    fn AllowViewResize(&self, f: windows_core::BOOL) -> windows_core::Result<()>;
    fn SetActivateState(&self, u: u32) -> windows_core::Result<()>;
    fn UpdateSecureLockIcon(&self, esecurelock: i32) -> windows_core::Result<()>;
    fn InitializeDownloadManager(&self) -> windows_core::Result<()>;
    fn InitializeTransitionSite(&self) -> windows_core::Result<()>;
    fn _Initialize(&self, hwnd: super::super::Foundation::HWND, pauto: windows_core::Ref<windows_core::IUnknown>) -> windows_core::Result<()>;
    fn _CancelPendingNavigationAsync(&self) -> windows_core::Result<()>;
    fn _CancelPendingView(&self) -> windows_core::Result<()>;
    fn _MaySaveChanges(&self) -> windows_core::Result<()>;
    fn _PauseOrResumeView(&self, fpaused: windows_core::BOOL) -> windows_core::Result<()>;
    fn _DisableModeless(&self) -> windows_core::Result<()>;
    fn _NavigateToPidl2(&self, pidl: *const Common::ITEMIDLIST, grfhlnf: u32, dwflags: u32) -> windows_core::Result<()>;
    fn _TryShell2Rename(&self, psv: windows_core::Ref<IShellView>, pidlnew: *const Common::ITEMIDLIST) -> windows_core::Result<()>;
    fn _SwitchActivationNow(&self) -> windows_core::Result<()>;
    fn _ExecChildren(&self, punkbar: windows_core::Ref<windows_core::IUnknown>, fbroadcast: windows_core::BOOL, pguidcmdgroup: *const windows_core::GUID, ncmdid: u32, ncmdexecopt: u32, pvarargin: *const super::super::System::Variant::VARIANT, pvarargout: *mut super::super::System::Variant::VARIANT) -> windows_core::Result<()>;
    fn _SendChildren(&self, hwndbar: super::super::Foundation::HWND, fbroadcast: windows_core::BOOL, umsg: u32, wparam: super::super::Foundation::WPARAM, lparam: super::super::Foundation::LPARAM) -> windows_core::Result<()>;
    fn GetFolderSetData(&self, pfsd: *mut FOLDERSETDATA) -> windows_core::Result<()>;
    fn _OnFocusChange(&self, itb: u32) -> windows_core::Result<()>;
    fn v_ShowHideChildWindows(&self, fchildonly: windows_core::BOOL) -> windows_core::Result<()>;
    fn _get_itbLastFocus(&self) -> u32;
    fn _put_itbLastFocus(&self, itblastfocus: u32) -> windows_core::Result<()>;
    fn _UIActivateView(&self, ustate: u32) -> windows_core::Result<()>;
    fn _GetViewBorderRect(&self, prc: *mut super::super::Foundation::RECT) -> windows_core::Result<()>;
    fn _UpdateViewRectSize(&self) -> windows_core::Result<()>;
    fn _ResizeNextBorder(&self, itb: u32) -> windows_core::Result<()>;
    fn _ResizeView(&self) -> windows_core::Result<()>;
    fn _GetEffectiveClientArea(&self, lprectborder: *mut super::super::Foundation::RECT, hmon: super::super::Graphics::Gdi::HMONITOR) -> windows_core::Result<()>;
    fn v_GetViewStream(&self, pidl: *mut Common::ITEMIDLIST, grfmode: u32, pwszname: &windows_core::PCWSTR) -> Option<super::super::System::Com::IStream>;
    fn ForwardViewMsg(&self, umsg: u32, wparam: super::super::Foundation::WPARAM, lparam: super::super::Foundation::LPARAM) -> super::super::Foundation::LRESULT;
    fn SetAcceleratorMenu(&self, hacc: super::WindowsAndMessaging::HACCEL) -> windows_core::Result<()>;
    fn _GetToolbarCount(&self) -> i32;
    fn _GetToolbarItem(&self, itb: i32) -> *mut TOOLBARITEM;
    fn _SaveToolbars(&self, pstm: windows_core::Ref<super::super::System::Com::IStream>) -> windows_core::Result<()>;
    fn _LoadToolbars(&self, pstm: windows_core::Ref<super::super::System::Com::IStream>) -> windows_core::Result<()>;
    fn _CloseAndReleaseToolbars(&self, fclose: windows_core::BOOL) -> windows_core::Result<()>;
    fn v_MayGetNextToolbarFocus(&self, lpmsg: *const super::WindowsAndMessaging::MSG, itbnext: u32, citb: i32, pptbi: *mut *mut TOOLBARITEM, phwnd: *mut super::super::Foundation::HWND) -> windows_core::Result<()>;
    fn _ResizeNextBorderHelper(&self, itb: u32, busehmonitor: windows_core::BOOL) -> windows_core::Result<()>;
    fn _FindTBar(&self, punksrc: windows_core::Ref<windows_core::IUnknown>) -> u32;
    fn _SetFocus(&self, ptbi: *const TOOLBARITEM, hwnd: super::super::Foundation::HWND, lpmsg: *const super::WindowsAndMessaging::MSG) -> windows_core::Result<()>;
    fn v_MayTranslateAccelerator(&self, pmsg: *mut super::WindowsAndMessaging::MSG) -> windows_core::Result<()>;
    fn _GetBorderDWHelper(&self, punksrc: windows_core::Ref<windows_core::IUnknown>, lprectborder: *mut super::super::Foundation::RECT, busehmonitor: windows_core::BOOL) -> windows_core::Result<()>;
    fn v_CheckZoneCrossing(&self, pidl: *const Common::ITEMIDLIST) -> windows_core::Result<()>;
}
#[cfg(all(feature = "Win32_Graphics_Gdi", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant", feature = "Win32_UI_Controls", feature = "Win32_UI_Shell_Common", feature = "Win32_UI_WindowsAndMessaging"))]
impl IBrowserService2_Vtbl {
    pub const fn new<Identity: IBrowserService2_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn WndProcBS<Identity: IBrowserService2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, hwnd: super::super::Foundation::HWND, umsg: u32, wparam: super::super::Foundation::WPARAM, lparam: super::super::Foundation::LPARAM) -> super::super::Foundation::LRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBrowserService2_Impl::WndProcBS(this, core::mem::transmute_copy(&hwnd), core::mem::transmute_copy(&umsg), core::mem::transmute_copy(&wparam), core::mem::transmute_copy(&lparam))
            }
        }
        unsafe extern "system" fn SetAsDefFolderSettings<Identity: IBrowserService2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBrowserService2_Impl::SetAsDefFolderSettings(this).into()
            }
        }
        unsafe extern "system" fn GetViewRect<Identity: IBrowserService2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, prc: *mut super::super::Foundation::RECT) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IBrowserService2_Impl::GetViewRect(this) {
                    Ok(ok__) => {
                        prc.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn OnSize<Identity: IBrowserService2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, wparam: super::super::Foundation::WPARAM) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBrowserService2_Impl::OnSize(this, core::mem::transmute_copy(&wparam)).into()
            }
        }
        unsafe extern "system" fn OnCreate<Identity: IBrowserService2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pcs: *const super::WindowsAndMessaging::CREATESTRUCTW) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBrowserService2_Impl::OnCreate(this, core::mem::transmute_copy(&pcs)).into()
            }
        }
        unsafe extern "system" fn OnCommand<Identity: IBrowserService2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, wparam: super::super::Foundation::WPARAM, lparam: super::super::Foundation::LPARAM) -> super::super::Foundation::LRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBrowserService2_Impl::OnCommand(this, core::mem::transmute_copy(&wparam), core::mem::transmute_copy(&lparam))
            }
        }
        unsafe extern "system" fn OnDestroy<Identity: IBrowserService2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBrowserService2_Impl::OnDestroy(this).into()
            }
        }
        unsafe extern "system" fn OnNotify<Identity: IBrowserService2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pnm: *const super::Controls::NMHDR) -> super::super::Foundation::LRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBrowserService2_Impl::OnNotify(this, core::mem::transmute_copy(&pnm))
            }
        }
        unsafe extern "system" fn OnSetFocus<Identity: IBrowserService2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBrowserService2_Impl::OnSetFocus(this).into()
            }
        }
        unsafe extern "system" fn OnFrameWindowActivateBS<Identity: IBrowserService2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, factive: windows_core::BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBrowserService2_Impl::OnFrameWindowActivateBS(this, core::mem::transmute_copy(&factive)).into()
            }
        }
        unsafe extern "system" fn ReleaseShellView<Identity: IBrowserService2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBrowserService2_Impl::ReleaseShellView(this).into()
            }
        }
        unsafe extern "system" fn ActivatePendingView<Identity: IBrowserService2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBrowserService2_Impl::ActivatePendingView(this).into()
            }
        }
        unsafe extern "system" fn CreateViewWindow<Identity: IBrowserService2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, psvnew: *mut core::ffi::c_void, psvold: *mut core::ffi::c_void, prcview: *const super::super::Foundation::RECT, phwnd: *mut super::super::Foundation::HWND) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IBrowserService2_Impl::CreateViewWindow(this, core::mem::transmute_copy(&psvnew), core::mem::transmute_copy(&psvold), core::mem::transmute_copy(&prcview)) {
                    Ok(ok__) => {
                        phwnd.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn CreateBrowserPropSheetExt<Identity: IBrowserService2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, riid: *const windows_core::GUID, ppv: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBrowserService2_Impl::CreateBrowserPropSheetExt(this, core::mem::transmute_copy(&riid), core::mem::transmute_copy(&ppv)).into()
            }
        }
        unsafe extern "system" fn GetViewWindow<Identity: IBrowserService2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, phwndview: *mut super::super::Foundation::HWND) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IBrowserService2_Impl::GetViewWindow(this) {
                    Ok(ok__) => {
                        phwndview.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetBaseBrowserData<Identity: IBrowserService2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbbd: *mut *mut BASEBROWSERDATALH) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IBrowserService2_Impl::GetBaseBrowserData(this) {
                    Ok(ok__) => {
                        pbbd.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn PutBaseBrowserData<Identity: IBrowserService2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> *mut BASEBROWSERDATALH {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBrowserService2_Impl::PutBaseBrowserData(this)
            }
        }
        unsafe extern "system" fn InitializeTravelLog<Identity: IBrowserService2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ptl: *mut core::ffi::c_void, dw: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBrowserService2_Impl::InitializeTravelLog(this, core::mem::transmute_copy(&ptl), core::mem::transmute_copy(&dw)).into()
            }
        }
        unsafe extern "system" fn SetTopBrowser<Identity: IBrowserService2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBrowserService2_Impl::SetTopBrowser(this).into()
            }
        }
        unsafe extern "system" fn Offline<Identity: IBrowserService2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, icmd: i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBrowserService2_Impl::Offline(this, core::mem::transmute_copy(&icmd)).into()
            }
        }
        unsafe extern "system" fn AllowViewResize<Identity: IBrowserService2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, f: windows_core::BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBrowserService2_Impl::AllowViewResize(this, core::mem::transmute_copy(&f)).into()
            }
        }
        unsafe extern "system" fn SetActivateState<Identity: IBrowserService2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, u: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBrowserService2_Impl::SetActivateState(this, core::mem::transmute_copy(&u)).into()
            }
        }
        unsafe extern "system" fn UpdateSecureLockIcon<Identity: IBrowserService2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, esecurelock: i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBrowserService2_Impl::UpdateSecureLockIcon(this, core::mem::transmute_copy(&esecurelock)).into()
            }
        }
        unsafe extern "system" fn InitializeDownloadManager<Identity: IBrowserService2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBrowserService2_Impl::InitializeDownloadManager(this).into()
            }
        }
        unsafe extern "system" fn InitializeTransitionSite<Identity: IBrowserService2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBrowserService2_Impl::InitializeTransitionSite(this).into()
            }
        }
        unsafe extern "system" fn _Initialize<Identity: IBrowserService2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, hwnd: super::super::Foundation::HWND, pauto: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBrowserService2_Impl::_Initialize(this, core::mem::transmute_copy(&hwnd), core::mem::transmute_copy(&pauto)).into()
            }
        }
        unsafe extern "system" fn _CancelPendingNavigationAsync<Identity: IBrowserService2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBrowserService2_Impl::_CancelPendingNavigationAsync(this).into()
            }
        }
        unsafe extern "system" fn _CancelPendingView<Identity: IBrowserService2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBrowserService2_Impl::_CancelPendingView(this).into()
            }
        }
        unsafe extern "system" fn _MaySaveChanges<Identity: IBrowserService2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBrowserService2_Impl::_MaySaveChanges(this).into()
            }
        }
        unsafe extern "system" fn _PauseOrResumeView<Identity: IBrowserService2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, fpaused: windows_core::BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBrowserService2_Impl::_PauseOrResumeView(this, core::mem::transmute_copy(&fpaused)).into()
            }
        }
        unsafe extern "system" fn _DisableModeless<Identity: IBrowserService2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBrowserService2_Impl::_DisableModeless(this).into()
            }
        }
        unsafe extern "system" fn _NavigateToPidl2<Identity: IBrowserService2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pidl: *const Common::ITEMIDLIST, grfhlnf: u32, dwflags: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBrowserService2_Impl::_NavigateToPidl2(this, core::mem::transmute_copy(&pidl), core::mem::transmute_copy(&grfhlnf), core::mem::transmute_copy(&dwflags)).into()
            }
        }
        unsafe extern "system" fn _TryShell2Rename<Identity: IBrowserService2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, psv: *mut core::ffi::c_void, pidlnew: *const Common::ITEMIDLIST) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBrowserService2_Impl::_TryShell2Rename(this, core::mem::transmute_copy(&psv), core::mem::transmute_copy(&pidlnew)).into()
            }
        }
        unsafe extern "system" fn _SwitchActivationNow<Identity: IBrowserService2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBrowserService2_Impl::_SwitchActivationNow(this).into()
            }
        }
        unsafe extern "system" fn _ExecChildren<Identity: IBrowserService2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, punkbar: *mut core::ffi::c_void, fbroadcast: windows_core::BOOL, pguidcmdgroup: *const windows_core::GUID, ncmdid: u32, ncmdexecopt: u32, pvarargin: *const super::super::System::Variant::VARIANT, pvarargout: *mut super::super::System::Variant::VARIANT) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBrowserService2_Impl::_ExecChildren(this, core::mem::transmute_copy(&punkbar), core::mem::transmute_copy(&fbroadcast), core::mem::transmute_copy(&pguidcmdgroup), core::mem::transmute_copy(&ncmdid), core::mem::transmute_copy(&ncmdexecopt), core::mem::transmute_copy(&pvarargin), core::mem::transmute_copy(&pvarargout)).into()
            }
        }
        unsafe extern "system" fn _SendChildren<Identity: IBrowserService2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, hwndbar: super::super::Foundation::HWND, fbroadcast: windows_core::BOOL, umsg: u32, wparam: super::super::Foundation::WPARAM, lparam: super::super::Foundation::LPARAM) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBrowserService2_Impl::_SendChildren(this, core::mem::transmute_copy(&hwndbar), core::mem::transmute_copy(&fbroadcast), core::mem::transmute_copy(&umsg), core::mem::transmute_copy(&wparam), core::mem::transmute_copy(&lparam)).into()
            }
        }
        unsafe extern "system" fn GetFolderSetData<Identity: IBrowserService2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pfsd: *mut FOLDERSETDATA) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBrowserService2_Impl::GetFolderSetData(this, core::mem::transmute_copy(&pfsd)).into()
            }
        }
        unsafe extern "system" fn _OnFocusChange<Identity: IBrowserService2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, itb: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBrowserService2_Impl::_OnFocusChange(this, core::mem::transmute_copy(&itb)).into()
            }
        }
        unsafe extern "system" fn v_ShowHideChildWindows<Identity: IBrowserService2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, fchildonly: windows_core::BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBrowserService2_Impl::v_ShowHideChildWindows(this, core::mem::transmute_copy(&fchildonly)).into()
            }
        }
        unsafe extern "system" fn _get_itbLastFocus<Identity: IBrowserService2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> u32 {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBrowserService2_Impl::_get_itbLastFocus(this)
            }
        }
        unsafe extern "system" fn _put_itbLastFocus<Identity: IBrowserService2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, itblastfocus: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBrowserService2_Impl::_put_itbLastFocus(this, core::mem::transmute_copy(&itblastfocus)).into()
            }
        }
        unsafe extern "system" fn _UIActivateView<Identity: IBrowserService2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ustate: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBrowserService2_Impl::_UIActivateView(this, core::mem::transmute_copy(&ustate)).into()
            }
        }
        unsafe extern "system" fn _GetViewBorderRect<Identity: IBrowserService2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, prc: *mut super::super::Foundation::RECT) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBrowserService2_Impl::_GetViewBorderRect(this, core::mem::transmute_copy(&prc)).into()
            }
        }
        unsafe extern "system" fn _UpdateViewRectSize<Identity: IBrowserService2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBrowserService2_Impl::_UpdateViewRectSize(this).into()
            }
        }
        unsafe extern "system" fn _ResizeNextBorder<Identity: IBrowserService2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, itb: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBrowserService2_Impl::_ResizeNextBorder(this, core::mem::transmute_copy(&itb)).into()
            }
        }
        unsafe extern "system" fn _ResizeView<Identity: IBrowserService2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBrowserService2_Impl::_ResizeView(this).into()
            }
        }
        unsafe extern "system" fn _GetEffectiveClientArea<Identity: IBrowserService2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, lprectborder: *mut super::super::Foundation::RECT, hmon: super::super::Graphics::Gdi::HMONITOR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBrowserService2_Impl::_GetEffectiveClientArea(this, core::mem::transmute_copy(&lprectborder), core::mem::transmute_copy(&hmon)).into()
            }
        }
        unsafe extern "system" fn v_GetViewStream<Identity: IBrowserService2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pidl: *mut Common::ITEMIDLIST, grfmode: u32, pwszname: windows_core::PCWSTR) -> Option<super::super::System::Com::IStream> {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBrowserService2_Impl::v_GetViewStream(this, core::mem::transmute_copy(&pidl), core::mem::transmute_copy(&grfmode), core::mem::transmute(&pwszname))
            }
        }
        unsafe extern "system" fn ForwardViewMsg<Identity: IBrowserService2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, umsg: u32, wparam: super::super::Foundation::WPARAM, lparam: super::super::Foundation::LPARAM) -> super::super::Foundation::LRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBrowserService2_Impl::ForwardViewMsg(this, core::mem::transmute_copy(&umsg), core::mem::transmute_copy(&wparam), core::mem::transmute_copy(&lparam))
            }
        }
        unsafe extern "system" fn SetAcceleratorMenu<Identity: IBrowserService2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, hacc: super::WindowsAndMessaging::HACCEL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBrowserService2_Impl::SetAcceleratorMenu(this, core::mem::transmute_copy(&hacc)).into()
            }
        }
        unsafe extern "system" fn _GetToolbarCount<Identity: IBrowserService2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> i32 {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBrowserService2_Impl::_GetToolbarCount(this)
            }
        }
        unsafe extern "system" fn _GetToolbarItem<Identity: IBrowserService2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, itb: i32) -> *mut TOOLBARITEM {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBrowserService2_Impl::_GetToolbarItem(this, core::mem::transmute_copy(&itb))
            }
        }
        unsafe extern "system" fn _SaveToolbars<Identity: IBrowserService2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pstm: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBrowserService2_Impl::_SaveToolbars(this, core::mem::transmute_copy(&pstm)).into()
            }
        }
        unsafe extern "system" fn _LoadToolbars<Identity: IBrowserService2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pstm: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBrowserService2_Impl::_LoadToolbars(this, core::mem::transmute_copy(&pstm)).into()
            }
        }
        unsafe extern "system" fn _CloseAndReleaseToolbars<Identity: IBrowserService2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, fclose: windows_core::BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBrowserService2_Impl::_CloseAndReleaseToolbars(this, core::mem::transmute_copy(&fclose)).into()
            }
        }
        unsafe extern "system" fn v_MayGetNextToolbarFocus<Identity: IBrowserService2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, lpmsg: *const super::WindowsAndMessaging::MSG, itbnext: u32, citb: i32, pptbi: *mut *mut TOOLBARITEM, phwnd: *mut super::super::Foundation::HWND) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBrowserService2_Impl::v_MayGetNextToolbarFocus(this, core::mem::transmute_copy(&lpmsg), core::mem::transmute_copy(&itbnext), core::mem::transmute_copy(&citb), core::mem::transmute_copy(&pptbi), core::mem::transmute_copy(&phwnd)).into()
            }
        }
        unsafe extern "system" fn _ResizeNextBorderHelper<Identity: IBrowserService2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, itb: u32, busehmonitor: windows_core::BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBrowserService2_Impl::_ResizeNextBorderHelper(this, core::mem::transmute_copy(&itb), core::mem::transmute_copy(&busehmonitor)).into()
            }
        }
        unsafe extern "system" fn _FindTBar<Identity: IBrowserService2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, punksrc: *mut core::ffi::c_void) -> u32 {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBrowserService2_Impl::_FindTBar(this, core::mem::transmute_copy(&punksrc))
            }
        }
        unsafe extern "system" fn _SetFocus<Identity: IBrowserService2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ptbi: *const TOOLBARITEM, hwnd: super::super::Foundation::HWND, lpmsg: *const super::WindowsAndMessaging::MSG) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBrowserService2_Impl::_SetFocus(this, core::mem::transmute_copy(&ptbi), core::mem::transmute_copy(&hwnd), core::mem::transmute_copy(&lpmsg)).into()
            }
        }
        unsafe extern "system" fn v_MayTranslateAccelerator<Identity: IBrowserService2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pmsg: *mut super::WindowsAndMessaging::MSG) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBrowserService2_Impl::v_MayTranslateAccelerator(this, core::mem::transmute_copy(&pmsg)).into()
            }
        }
        unsafe extern "system" fn _GetBorderDWHelper<Identity: IBrowserService2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, punksrc: *mut core::ffi::c_void, lprectborder: *mut super::super::Foundation::RECT, busehmonitor: windows_core::BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBrowserService2_Impl::_GetBorderDWHelper(this, core::mem::transmute_copy(&punksrc), core::mem::transmute_copy(&lprectborder), core::mem::transmute_copy(&busehmonitor)).into()
            }
        }
        unsafe extern "system" fn v_CheckZoneCrossing<Identity: IBrowserService2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pidl: *const Common::ITEMIDLIST) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBrowserService2_Impl::v_CheckZoneCrossing(this, core::mem::transmute_copy(&pidl)).into()
            }
        }
        Self {
            base__: IBrowserService_Vtbl::new::<Identity, OFFSET>(),
            WndProcBS: WndProcBS::<Identity, OFFSET>,
            SetAsDefFolderSettings: SetAsDefFolderSettings::<Identity, OFFSET>,
            GetViewRect: GetViewRect::<Identity, OFFSET>,
            OnSize: OnSize::<Identity, OFFSET>,
            OnCreate: OnCreate::<Identity, OFFSET>,
            OnCommand: OnCommand::<Identity, OFFSET>,
            OnDestroy: OnDestroy::<Identity, OFFSET>,
            OnNotify: OnNotify::<Identity, OFFSET>,
            OnSetFocus: OnSetFocus::<Identity, OFFSET>,
            OnFrameWindowActivateBS: OnFrameWindowActivateBS::<Identity, OFFSET>,
            ReleaseShellView: ReleaseShellView::<Identity, OFFSET>,
            ActivatePendingView: ActivatePendingView::<Identity, OFFSET>,
            CreateViewWindow: CreateViewWindow::<Identity, OFFSET>,
            CreateBrowserPropSheetExt: CreateBrowserPropSheetExt::<Identity, OFFSET>,
            GetViewWindow: GetViewWindow::<Identity, OFFSET>,
            GetBaseBrowserData: GetBaseBrowserData::<Identity, OFFSET>,
            PutBaseBrowserData: PutBaseBrowserData::<Identity, OFFSET>,
            InitializeTravelLog: InitializeTravelLog::<Identity, OFFSET>,
            SetTopBrowser: SetTopBrowser::<Identity, OFFSET>,
            Offline: Offline::<Identity, OFFSET>,
            AllowViewResize: AllowViewResize::<Identity, OFFSET>,
            SetActivateState: SetActivateState::<Identity, OFFSET>,
            UpdateSecureLockIcon: UpdateSecureLockIcon::<Identity, OFFSET>,
            InitializeDownloadManager: InitializeDownloadManager::<Identity, OFFSET>,
            InitializeTransitionSite: InitializeTransitionSite::<Identity, OFFSET>,
            _Initialize: _Initialize::<Identity, OFFSET>,
            _CancelPendingNavigationAsync: _CancelPendingNavigationAsync::<Identity, OFFSET>,
            _CancelPendingView: _CancelPendingView::<Identity, OFFSET>,
            _MaySaveChanges: _MaySaveChanges::<Identity, OFFSET>,
            _PauseOrResumeView: _PauseOrResumeView::<Identity, OFFSET>,
            _DisableModeless: _DisableModeless::<Identity, OFFSET>,
            _NavigateToPidl2: _NavigateToPidl2::<Identity, OFFSET>,
            _TryShell2Rename: _TryShell2Rename::<Identity, OFFSET>,
            _SwitchActivationNow: _SwitchActivationNow::<Identity, OFFSET>,
            _ExecChildren: _ExecChildren::<Identity, OFFSET>,
            _SendChildren: _SendChildren::<Identity, OFFSET>,
            GetFolderSetData: GetFolderSetData::<Identity, OFFSET>,
            _OnFocusChange: _OnFocusChange::<Identity, OFFSET>,
            v_ShowHideChildWindows: v_ShowHideChildWindows::<Identity, OFFSET>,
            _get_itbLastFocus: _get_itbLastFocus::<Identity, OFFSET>,
            _put_itbLastFocus: _put_itbLastFocus::<Identity, OFFSET>,
            _UIActivateView: _UIActivateView::<Identity, OFFSET>,
            _GetViewBorderRect: _GetViewBorderRect::<Identity, OFFSET>,
            _UpdateViewRectSize: _UpdateViewRectSize::<Identity, OFFSET>,
            _ResizeNextBorder: _ResizeNextBorder::<Identity, OFFSET>,
            _ResizeView: _ResizeView::<Identity, OFFSET>,
            _GetEffectiveClientArea: _GetEffectiveClientArea::<Identity, OFFSET>,
            v_GetViewStream: v_GetViewStream::<Identity, OFFSET>,
            ForwardViewMsg: ForwardViewMsg::<Identity, OFFSET>,
            SetAcceleratorMenu: SetAcceleratorMenu::<Identity, OFFSET>,
            _GetToolbarCount: _GetToolbarCount::<Identity, OFFSET>,
            _GetToolbarItem: _GetToolbarItem::<Identity, OFFSET>,
            _SaveToolbars: _SaveToolbars::<Identity, OFFSET>,
            _LoadToolbars: _LoadToolbars::<Identity, OFFSET>,
            _CloseAndReleaseToolbars: _CloseAndReleaseToolbars::<Identity, OFFSET>,
            v_MayGetNextToolbarFocus: v_MayGetNextToolbarFocus::<Identity, OFFSET>,
            _ResizeNextBorderHelper: _ResizeNextBorderHelper::<Identity, OFFSET>,
            _FindTBar: _FindTBar::<Identity, OFFSET>,
            _SetFocus: _SetFocus::<Identity, OFFSET>,
            v_MayTranslateAccelerator: v_MayTranslateAccelerator::<Identity, OFFSET>,
            _GetBorderDWHelper: _GetBorderDWHelper::<Identity, OFFSET>,
            v_CheckZoneCrossing: v_CheckZoneCrossing::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IBrowserService2 as windows_core::Interface>::IID || iid == &<IBrowserService as windows_core::Interface>::IID
    }
}
#[cfg(all(feature = "Win32_Graphics_Gdi", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant", feature = "Win32_UI_Controls", feature = "Win32_UI_Shell_Common", feature = "Win32_UI_WindowsAndMessaging"))]
impl windows_core::RuntimeName for IBrowserService2 {}
windows_core::imp::define_interface!(IBrowserService3, IBrowserService3_Vtbl, 0x27d7ce21_762d_48f3_86f3_40e2fd3749c4);
impl core::ops::Deref for IBrowserService3 {
    type Target = IBrowserService2;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IBrowserService3, windows_core::IUnknown, IBrowserService, IBrowserService2);
impl IBrowserService3 {
    pub unsafe fn _PositionViewWindow(&self, hwnd: super::super::Foundation::HWND, prc: *const super::super::Foundation::RECT) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self)._PositionViewWindow)(windows_core::Interface::as_raw(self), hwnd, prc).ok() }
    }
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn IEParseDisplayNameEx<P1>(&self, uicp: u32, pwszpath: P1, dwflags: u32) -> windows_core::Result<*mut Common::ITEMIDLIST>
    where
        P1: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).IEParseDisplayNameEx)(windows_core::Interface::as_raw(self), uicp, pwszpath.param().abi(), dwflags, &mut result__).map(|| result__)
        }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IBrowserService3_Vtbl {
    pub base__: IBrowserService2_Vtbl,
    pub _PositionViewWindow: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::HWND, *const super::super::Foundation::RECT) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub IEParseDisplayNameEx: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCWSTR, u32, *mut *mut Common::ITEMIDLIST) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_Common"))]
    IEParseDisplayNameEx: usize,
}
#[cfg(all(feature = "Win32_Graphics_Gdi", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant", feature = "Win32_UI_Controls", feature = "Win32_UI_Shell_Common", feature = "Win32_UI_WindowsAndMessaging"))]
pub trait IBrowserService3_Impl: IBrowserService2_Impl {
    fn _PositionViewWindow(&self, hwnd: super::super::Foundation::HWND, prc: *const super::super::Foundation::RECT) -> windows_core::Result<()>;
    fn IEParseDisplayNameEx(&self, uicp: u32, pwszpath: &windows_core::PCWSTR, dwflags: u32) -> windows_core::Result<*mut Common::ITEMIDLIST>;
}
#[cfg(all(feature = "Win32_Graphics_Gdi", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant", feature = "Win32_UI_Controls", feature = "Win32_UI_Shell_Common", feature = "Win32_UI_WindowsAndMessaging"))]
impl IBrowserService3_Vtbl {
    pub const fn new<Identity: IBrowserService3_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn _PositionViewWindow<Identity: IBrowserService3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, hwnd: super::super::Foundation::HWND, prc: *const super::super::Foundation::RECT) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBrowserService3_Impl::_PositionViewWindow(this, core::mem::transmute_copy(&hwnd), core::mem::transmute_copy(&prc)).into()
            }
        }
        unsafe extern "system" fn IEParseDisplayNameEx<Identity: IBrowserService3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, uicp: u32, pwszpath: windows_core::PCWSTR, dwflags: u32, ppidlout: *mut *mut Common::ITEMIDLIST) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IBrowserService3_Impl::IEParseDisplayNameEx(this, core::mem::transmute_copy(&uicp), core::mem::transmute(&pwszpath), core::mem::transmute_copy(&dwflags)) {
                    Ok(ok__) => {
                        ppidlout.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self {
            base__: IBrowserService2_Vtbl::new::<Identity, OFFSET>(),
            _PositionViewWindow: _PositionViewWindow::<Identity, OFFSET>,
            IEParseDisplayNameEx: IEParseDisplayNameEx::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IBrowserService3 as windows_core::Interface>::IID || iid == &<IBrowserService as windows_core::Interface>::IID || iid == &<IBrowserService2 as windows_core::Interface>::IID
    }
}
#[cfg(all(feature = "Win32_Graphics_Gdi", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant", feature = "Win32_UI_Controls", feature = "Win32_UI_Shell_Common", feature = "Win32_UI_WindowsAndMessaging"))]
impl windows_core::RuntimeName for IBrowserService3 {}
windows_core::imp::define_interface!(IBrowserService4, IBrowserService4_Vtbl, 0x639f1bff_e135_4096_abd8_e0f504d649a4);
impl core::ops::Deref for IBrowserService4 {
    type Target = IBrowserService3;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IBrowserService4, windows_core::IUnknown, IBrowserService, IBrowserService2, IBrowserService3);
impl IBrowserService4 {
    pub unsafe fn ActivateView(&self, fpendingview: bool) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).ActivateView)(windows_core::Interface::as_raw(self), fpendingview.into()).ok() }
    }
    pub unsafe fn SaveViewState(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SaveViewState)(windows_core::Interface::as_raw(self)).ok() }
    }
    pub unsafe fn _ResizeAllBorders(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self)._ResizeAllBorders)(windows_core::Interface::as_raw(self)).ok() }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IBrowserService4_Vtbl {
    pub base__: IBrowserService3_Vtbl,
    pub ActivateView: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::BOOL) -> windows_core::HRESULT,
    pub SaveViewState: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub _ResizeAllBorders: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
}
#[cfg(all(feature = "Win32_Graphics_Gdi", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant", feature = "Win32_UI_Controls", feature = "Win32_UI_Shell_Common", feature = "Win32_UI_WindowsAndMessaging"))]
pub trait IBrowserService4_Impl: IBrowserService3_Impl {
    fn ActivateView(&self, fpendingview: windows_core::BOOL) -> windows_core::Result<()>;
    fn SaveViewState(&self) -> windows_core::Result<()>;
    fn _ResizeAllBorders(&self) -> windows_core::Result<()>;
}
#[cfg(all(feature = "Win32_Graphics_Gdi", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant", feature = "Win32_UI_Controls", feature = "Win32_UI_Shell_Common", feature = "Win32_UI_WindowsAndMessaging"))]
impl IBrowserService4_Vtbl {
    pub const fn new<Identity: IBrowserService4_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn ActivateView<Identity: IBrowserService4_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, fpendingview: windows_core::BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBrowserService4_Impl::ActivateView(this, core::mem::transmute_copy(&fpendingview)).into()
            }
        }
        unsafe extern "system" fn SaveViewState<Identity: IBrowserService4_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBrowserService4_Impl::SaveViewState(this).into()
            }
        }
        unsafe extern "system" fn _ResizeAllBorders<Identity: IBrowserService4_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBrowserService4_Impl::_ResizeAllBorders(this).into()
            }
        }
        Self {
            base__: IBrowserService3_Vtbl::new::<Identity, OFFSET>(),
            ActivateView: ActivateView::<Identity, OFFSET>,
            SaveViewState: SaveViewState::<Identity, OFFSET>,
            _ResizeAllBorders: _ResizeAllBorders::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IBrowserService4 as windows_core::Interface>::IID || iid == &<IBrowserService as windows_core::Interface>::IID || iid == &<IBrowserService2 as windows_core::Interface>::IID || iid == &<IBrowserService3 as windows_core::Interface>::IID
    }
}
#[cfg(all(feature = "Win32_Graphics_Gdi", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant", feature = "Win32_UI_Controls", feature = "Win32_UI_Shell_Common", feature = "Win32_UI_WindowsAndMessaging"))]
impl windows_core::RuntimeName for IBrowserService4 {}
windows_core::imp::define_interface!(ICDBurn, ICDBurn_Vtbl, 0x3d73a659_e5d0_4d42_afc0_5121ba425c8d);
windows_core::imp::interface_hierarchy!(ICDBurn, windows_core::IUnknown);
impl ICDBurn {
    pub unsafe fn GetRecorderDriveLetter(&self, pszdrive: &mut [u16]) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetRecorderDriveLetter)(windows_core::Interface::as_raw(self), core::mem::transmute(pszdrive.as_ptr()), pszdrive.len().try_into().unwrap()).ok() }
    }
    pub unsafe fn Burn(&self, hwnd: super::super::Foundation::HWND) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).Burn)(windows_core::Interface::as_raw(self), hwnd).ok() }
    }
    pub unsafe fn HasRecordableDrive(&self) -> windows_core::Result<windows_core::BOOL> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).HasRecordableDrive)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ICDBurn_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetRecorderDriveLetter: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PWSTR, u32) -> windows_core::HRESULT,
    pub Burn: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::HWND) -> windows_core::HRESULT,
    pub HasRecordableDrive: unsafe extern "system" fn(*mut core::ffi::c_void, *mut windows_core::BOOL) -> windows_core::HRESULT,
}
pub trait ICDBurn_Impl: windows_core::IUnknownImpl {
    fn GetRecorderDriveLetter(&self, pszdrive: windows_core::PWSTR, cch: u32) -> windows_core::Result<()>;
    fn Burn(&self, hwnd: super::super::Foundation::HWND) -> windows_core::Result<()>;
    fn HasRecordableDrive(&self) -> windows_core::Result<windows_core::BOOL>;
}
impl ICDBurn_Vtbl {
    pub const fn new<Identity: ICDBurn_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetRecorderDriveLetter<Identity: ICDBurn_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pszdrive: windows_core::PWSTR, cch: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ICDBurn_Impl::GetRecorderDriveLetter(this, core::mem::transmute_copy(&pszdrive), core::mem::transmute_copy(&cch)).into()
            }
        }
        unsafe extern "system" fn Burn<Identity: ICDBurn_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, hwnd: super::super::Foundation::HWND) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ICDBurn_Impl::Burn(this, core::mem::transmute_copy(&hwnd)).into()
            }
        }
        unsafe extern "system" fn HasRecordableDrive<Identity: ICDBurn_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pfhasrecorder: *mut windows_core::BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match ICDBurn_Impl::HasRecordableDrive(this) {
                    Ok(ok__) => {
                        pfhasrecorder.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            GetRecorderDriveLetter: GetRecorderDriveLetter::<Identity, OFFSET>,
            Burn: Burn::<Identity, OFFSET>,
            HasRecordableDrive: HasRecordableDrive::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<ICDBurn as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for ICDBurn {}
windows_core::imp::define_interface!(ICDBurnExt, ICDBurnExt_Vtbl, 0x2271dcca_74fc_4414_8fb7_c56b05ace2d7);
windows_core::imp::interface_hierarchy!(ICDBurnExt, windows_core::IUnknown);
impl ICDBurnExt {
    pub unsafe fn GetSupportedActionTypes(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetSupportedActionTypes)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ICDBurnExt_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetSupportedActionTypes: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
}
pub trait ICDBurnExt_Impl: windows_core::IUnknownImpl {
    fn GetSupportedActionTypes(&self) -> windows_core::Result<u32>;
}
impl ICDBurnExt_Vtbl {
    pub const fn new<Identity: ICDBurnExt_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetSupportedActionTypes<Identity: ICDBurnExt_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pdwactions: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match ICDBurnExt_Impl::GetSupportedActionTypes(this) {
                    Ok(ok__) => {
                        pdwactions.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self { base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(), GetSupportedActionTypes: GetSupportedActionTypes::<Identity, OFFSET> }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<ICDBurnExt as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for ICDBurnExt {}
windows_core::imp::define_interface!(ICategorizer, ICategorizer_Vtbl, 0xa3b14589_9174_49a8_89a3_06a1ae2b9ba7);
windows_core::imp::interface_hierarchy!(ICategorizer, windows_core::IUnknown);
impl ICategorizer {
    pub unsafe fn GetDescription(&self, pszdesc: &mut [u16]) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetDescription)(windows_core::Interface::as_raw(self), core::mem::transmute(pszdesc.as_ptr()), pszdesc.len().try_into().unwrap()).ok() }
    }
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn GetCategory(&self, cidl: u32, apidl: *const *const Common::ITEMIDLIST, rgcategoryids: *mut u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetCategory)(windows_core::Interface::as_raw(self), cidl, apidl, rgcategoryids as _).ok() }
    }
    pub unsafe fn GetCategoryInfo(&self, dwcategoryid: u32, pci: *mut CATEGORY_INFO) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetCategoryInfo)(windows_core::Interface::as_raw(self), dwcategoryid, pci as _).ok() }
    }
    pub unsafe fn CompareCategory(&self, csfflags: CATSORT_FLAGS, dwcategoryid1: u32, dwcategoryid2: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).CompareCategory)(windows_core::Interface::as_raw(self), csfflags, dwcategoryid1, dwcategoryid2).ok() }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ICategorizer_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetDescription: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PWSTR, u32) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub GetCategory: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *const *const Common::ITEMIDLIST, *mut u32) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_Common"))]
    GetCategory: usize,
    pub GetCategoryInfo: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut CATEGORY_INFO) -> windows_core::HRESULT,
    pub CompareCategory: unsafe extern "system" fn(*mut core::ffi::c_void, CATSORT_FLAGS, u32, u32) -> windows_core::HRESULT,
}
#[cfg(feature = "Win32_UI_Shell_Common")]
pub trait ICategorizer_Impl: windows_core::IUnknownImpl {
    fn GetDescription(&self, pszdesc: windows_core::PWSTR, cch: u32) -> windows_core::Result<()>;
    fn GetCategory(&self, cidl: u32, apidl: *const *const Common::ITEMIDLIST, rgcategoryids: *mut u32) -> windows_core::Result<()>;
    fn GetCategoryInfo(&self, dwcategoryid: u32, pci: *mut CATEGORY_INFO) -> windows_core::Result<()>;
    fn CompareCategory(&self, csfflags: CATSORT_FLAGS, dwcategoryid1: u32, dwcategoryid2: u32) -> windows_core::Result<()>;
}
#[cfg(feature = "Win32_UI_Shell_Common")]
impl ICategorizer_Vtbl {
    pub const fn new<Identity: ICategorizer_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetDescription<Identity: ICategorizer_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pszdesc: windows_core::PWSTR, cch: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ICategorizer_Impl::GetDescription(this, core::mem::transmute_copy(&pszdesc), core::mem::transmute_copy(&cch)).into()
            }
        }
        unsafe extern "system" fn GetCategory<Identity: ICategorizer_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, cidl: u32, apidl: *const *const Common::ITEMIDLIST, rgcategoryids: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ICategorizer_Impl::GetCategory(this, core::mem::transmute_copy(&cidl), core::mem::transmute_copy(&apidl), core::mem::transmute_copy(&rgcategoryids)).into()
            }
        }
        unsafe extern "system" fn GetCategoryInfo<Identity: ICategorizer_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwcategoryid: u32, pci: *mut CATEGORY_INFO) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ICategorizer_Impl::GetCategoryInfo(this, core::mem::transmute_copy(&dwcategoryid), core::mem::transmute_copy(&pci)).into()
            }
        }
        unsafe extern "system" fn CompareCategory<Identity: ICategorizer_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, csfflags: CATSORT_FLAGS, dwcategoryid1: u32, dwcategoryid2: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ICategorizer_Impl::CompareCategory(this, core::mem::transmute_copy(&csfflags), core::mem::transmute_copy(&dwcategoryid1), core::mem::transmute_copy(&dwcategoryid2)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            GetDescription: GetDescription::<Identity, OFFSET>,
            GetCategory: GetCategory::<Identity, OFFSET>,
            GetCategoryInfo: GetCategoryInfo::<Identity, OFFSET>,
            CompareCategory: CompareCategory::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<ICategorizer as windows_core::Interface>::IID
    }
}
#[cfg(feature = "Win32_UI_Shell_Common")]
impl windows_core::RuntimeName for ICategorizer {}
windows_core::imp::define_interface!(ICategoryProvider, ICategoryProvider_Vtbl, 0x9af64809_5864_4c26_a720_c1f78c086ee3);
windows_core::imp::interface_hierarchy!(ICategoryProvider, windows_core::IUnknown);
impl ICategoryProvider {
    pub unsafe fn CanCategorizeOnSCID(&self, pscid: *const super::super::Foundation::PROPERTYKEY) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).CanCategorizeOnSCID)(windows_core::Interface::as_raw(self), pscid).ok() }
    }
    pub unsafe fn GetDefaultCategory(&self, pguid: *mut windows_core::GUID, pscid: *mut super::super::Foundation::PROPERTYKEY) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetDefaultCategory)(windows_core::Interface::as_raw(self), pguid as _, pscid as _).ok() }
    }
    pub unsafe fn GetCategoryForSCID(&self, pscid: *const super::super::Foundation::PROPERTYKEY) -> windows_core::Result<windows_core::GUID> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetCategoryForSCID)(windows_core::Interface::as_raw(self), pscid, &mut result__).map(|| result__)
        }
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn EnumCategories(&self) -> windows_core::Result<super::super::System::Com::IEnumGUID> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).EnumCategories)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn GetCategoryName(&self, pguid: *const windows_core::GUID, pszname: &mut [u16]) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetCategoryName)(windows_core::Interface::as_raw(self), pguid, core::mem::transmute(pszname.as_ptr()), pszname.len().try_into().unwrap()).ok() }
    }
    pub unsafe fn CreateCategory<T>(&self, pguid: *const windows_core::GUID) -> windows_core::Result<T>
    where
        T: windows_core::Interface,
    {
        let mut result__ = core::ptr::null_mut();
        unsafe { (windows_core::Interface::vtable(self).CreateCategory)(windows_core::Interface::as_raw(self), pguid, &T::IID, &mut result__).and_then(|| windows_core::Type::from_abi(result__)) }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ICategoryProvider_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub CanCategorizeOnSCID: unsafe extern "system" fn(*mut core::ffi::c_void, *const super::super::Foundation::PROPERTYKEY) -> windows_core::HRESULT,
    pub GetDefaultCategory: unsafe extern "system" fn(*mut core::ffi::c_void, *mut windows_core::GUID, *mut super::super::Foundation::PROPERTYKEY) -> windows_core::HRESULT,
    pub GetCategoryForSCID: unsafe extern "system" fn(*mut core::ffi::c_void, *const super::super::Foundation::PROPERTYKEY, *mut windows_core::GUID) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub EnumCategories: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    EnumCategories: usize,
    pub GetCategoryName: unsafe extern "system" fn(*mut core::ffi::c_void, *const windows_core::GUID, windows_core::PWSTR, u32) -> windows_core::HRESULT,
    pub CreateCategory: unsafe extern "system" fn(*mut core::ffi::c_void, *const windows_core::GUID, *const windows_core::GUID, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
#[cfg(feature = "Win32_System_Com")]
pub trait ICategoryProvider_Impl: windows_core::IUnknownImpl {
    fn CanCategorizeOnSCID(&self, pscid: *const super::super::Foundation::PROPERTYKEY) -> windows_core::Result<()>;
    fn GetDefaultCategory(&self, pguid: *mut windows_core::GUID, pscid: *mut super::super::Foundation::PROPERTYKEY) -> windows_core::Result<()>;
    fn GetCategoryForSCID(&self, pscid: *const super::super::Foundation::PROPERTYKEY) -> windows_core::Result<windows_core::GUID>;
    fn EnumCategories(&self) -> windows_core::Result<super::super::System::Com::IEnumGUID>;
    fn GetCategoryName(&self, pguid: *const windows_core::GUID, pszname: windows_core::PWSTR, cch: u32) -> windows_core::Result<()>;
    fn CreateCategory(&self, pguid: *const windows_core::GUID, riid: *const windows_core::GUID, ppv: *mut *mut core::ffi::c_void) -> windows_core::Result<()>;
}
#[cfg(feature = "Win32_System_Com")]
impl ICategoryProvider_Vtbl {
    pub const fn new<Identity: ICategoryProvider_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn CanCategorizeOnSCID<Identity: ICategoryProvider_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pscid: *const super::super::Foundation::PROPERTYKEY) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ICategoryProvider_Impl::CanCategorizeOnSCID(this, core::mem::transmute_copy(&pscid)).into()
            }
        }
        unsafe extern "system" fn GetDefaultCategory<Identity: ICategoryProvider_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pguid: *mut windows_core::GUID, pscid: *mut super::super::Foundation::PROPERTYKEY) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ICategoryProvider_Impl::GetDefaultCategory(this, core::mem::transmute_copy(&pguid), core::mem::transmute_copy(&pscid)).into()
            }
        }
        unsafe extern "system" fn GetCategoryForSCID<Identity: ICategoryProvider_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pscid: *const super::super::Foundation::PROPERTYKEY, pguid: *mut windows_core::GUID) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match ICategoryProvider_Impl::GetCategoryForSCID(this, core::mem::transmute_copy(&pscid)) {
                    Ok(ok__) => {
                        pguid.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn EnumCategories<Identity: ICategoryProvider_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, penum: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match ICategoryProvider_Impl::EnumCategories(this) {
                    Ok(ok__) => {
                        penum.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetCategoryName<Identity: ICategoryProvider_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pguid: *const windows_core::GUID, pszname: windows_core::PWSTR, cch: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ICategoryProvider_Impl::GetCategoryName(this, core::mem::transmute_copy(&pguid), core::mem::transmute_copy(&pszname), core::mem::transmute_copy(&cch)).into()
            }
        }
        unsafe extern "system" fn CreateCategory<Identity: ICategoryProvider_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pguid: *const windows_core::GUID, riid: *const windows_core::GUID, ppv: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ICategoryProvider_Impl::CreateCategory(this, core::mem::transmute_copy(&pguid), core::mem::transmute_copy(&riid), core::mem::transmute_copy(&ppv)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            CanCategorizeOnSCID: CanCategorizeOnSCID::<Identity, OFFSET>,
            GetDefaultCategory: GetDefaultCategory::<Identity, OFFSET>,
            GetCategoryForSCID: GetCategoryForSCID::<Identity, OFFSET>,
            EnumCategories: EnumCategories::<Identity, OFFSET>,
            GetCategoryName: GetCategoryName::<Identity, OFFSET>,
            CreateCategory: CreateCategory::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<ICategoryProvider as windows_core::Interface>::IID
    }
}
#[cfg(feature = "Win32_System_Com")]
impl windows_core::RuntimeName for ICategoryProvider {}
windows_core::imp::define_interface!(IColumnManager, IColumnManager_Vtbl, 0xd8ec27bb_3f3b_4042_b10a_4acfd924d453);
windows_core::imp::interface_hierarchy!(IColumnManager, windows_core::IUnknown);
impl IColumnManager {
    pub unsafe fn SetColumnInfo(&self, propkey: *const super::super::Foundation::PROPERTYKEY, pcmci: *const CM_COLUMNINFO) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetColumnInfo)(windows_core::Interface::as_raw(self), propkey, pcmci).ok() }
    }
    pub unsafe fn GetColumnInfo(&self, propkey: *const super::super::Foundation::PROPERTYKEY, pcmci: *mut CM_COLUMNINFO) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetColumnInfo)(windows_core::Interface::as_raw(self), propkey, pcmci as _).ok() }
    }
    pub unsafe fn GetColumnCount(&self, dwflags: CM_ENUM_FLAGS) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetColumnCount)(windows_core::Interface::as_raw(self), dwflags, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetColumns(&self, dwflags: CM_ENUM_FLAGS, rgkeyorder: &mut [super::super::Foundation::PROPERTYKEY]) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetColumns)(windows_core::Interface::as_raw(self), dwflags, core::mem::transmute(rgkeyorder.as_ptr()), rgkeyorder.len().try_into().unwrap()).ok() }
    }
    pub unsafe fn SetColumns(&self, rgkeyorder: &[super::super::Foundation::PROPERTYKEY]) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetColumns)(windows_core::Interface::as_raw(self), core::mem::transmute(rgkeyorder.as_ptr()), rgkeyorder.len().try_into().unwrap()).ok() }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IColumnManager_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub SetColumnInfo: unsafe extern "system" fn(*mut core::ffi::c_void, *const super::super::Foundation::PROPERTYKEY, *const CM_COLUMNINFO) -> windows_core::HRESULT,
    pub GetColumnInfo: unsafe extern "system" fn(*mut core::ffi::c_void, *const super::super::Foundation::PROPERTYKEY, *mut CM_COLUMNINFO) -> windows_core::HRESULT,
    pub GetColumnCount: unsafe extern "system" fn(*mut core::ffi::c_void, CM_ENUM_FLAGS, *mut u32) -> windows_core::HRESULT,
    pub GetColumns: unsafe extern "system" fn(*mut core::ffi::c_void, CM_ENUM_FLAGS, *mut super::super::Foundation::PROPERTYKEY, u32) -> windows_core::HRESULT,
    pub SetColumns: unsafe extern "system" fn(*mut core::ffi::c_void, *const super::super::Foundation::PROPERTYKEY, u32) -> windows_core::HRESULT,
}
pub trait IColumnManager_Impl: windows_core::IUnknownImpl {
    fn SetColumnInfo(&self, propkey: *const super::super::Foundation::PROPERTYKEY, pcmci: *const CM_COLUMNINFO) -> windows_core::Result<()>;
    fn GetColumnInfo(&self, propkey: *const super::super::Foundation::PROPERTYKEY, pcmci: *mut CM_COLUMNINFO) -> windows_core::Result<()>;
    fn GetColumnCount(&self, dwflags: CM_ENUM_FLAGS) -> windows_core::Result<u32>;
    fn GetColumns(&self, dwflags: CM_ENUM_FLAGS, rgkeyorder: *mut super::super::Foundation::PROPERTYKEY, ccolumns: u32) -> windows_core::Result<()>;
    fn SetColumns(&self, rgkeyorder: *const super::super::Foundation::PROPERTYKEY, cvisible: u32) -> windows_core::Result<()>;
}
impl IColumnManager_Vtbl {
    pub const fn new<Identity: IColumnManager_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn SetColumnInfo<Identity: IColumnManager_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, propkey: *const super::super::Foundation::PROPERTYKEY, pcmci: *const CM_COLUMNINFO) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IColumnManager_Impl::SetColumnInfo(this, core::mem::transmute_copy(&propkey), core::mem::transmute_copy(&pcmci)).into()
            }
        }
        unsafe extern "system" fn GetColumnInfo<Identity: IColumnManager_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, propkey: *const super::super::Foundation::PROPERTYKEY, pcmci: *mut CM_COLUMNINFO) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IColumnManager_Impl::GetColumnInfo(this, core::mem::transmute_copy(&propkey), core::mem::transmute_copy(&pcmci)).into()
            }
        }
        unsafe extern "system" fn GetColumnCount<Identity: IColumnManager_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwflags: CM_ENUM_FLAGS, pucount: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IColumnManager_Impl::GetColumnCount(this, core::mem::transmute_copy(&dwflags)) {
                    Ok(ok__) => {
                        pucount.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetColumns<Identity: IColumnManager_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwflags: CM_ENUM_FLAGS, rgkeyorder: *mut super::super::Foundation::PROPERTYKEY, ccolumns: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IColumnManager_Impl::GetColumns(this, core::mem::transmute_copy(&dwflags), core::mem::transmute_copy(&rgkeyorder), core::mem::transmute_copy(&ccolumns)).into()
            }
        }
        unsafe extern "system" fn SetColumns<Identity: IColumnManager_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, rgkeyorder: *const super::super::Foundation::PROPERTYKEY, cvisible: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IColumnManager_Impl::SetColumns(this, core::mem::transmute_copy(&rgkeyorder), core::mem::transmute_copy(&cvisible)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            SetColumnInfo: SetColumnInfo::<Identity, OFFSET>,
            GetColumnInfo: GetColumnInfo::<Identity, OFFSET>,
            GetColumnCount: GetColumnCount::<Identity, OFFSET>,
            GetColumns: GetColumns::<Identity, OFFSET>,
            SetColumns: SetColumns::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IColumnManager as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IColumnManager {}
windows_core::imp::define_interface!(IColumnProvider, IColumnProvider_Vtbl, 0xe8025004_1c42_11d2_be2c_00a0c9a83da1);
windows_core::imp::interface_hierarchy!(IColumnProvider, windows_core::IUnknown);
impl IColumnProvider {
    pub unsafe fn Initialize(&self, psci: *const SHCOLUMNINIT) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).Initialize)(windows_core::Interface::as_raw(self), psci).ok() }
    }
    #[cfg(feature = "Win32_System_Variant")]
    pub unsafe fn GetColumnInfo(&self, dwindex: u32, psci: *mut SHCOLUMNINFO) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetColumnInfo)(windows_core::Interface::as_raw(self), dwindex, psci as _).ok() }
    }
    #[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub unsafe fn GetItemData(&self, pscid: *const super::super::Foundation::PROPERTYKEY, pscd: *const SHCOLUMNDATA) -> windows_core::Result<super::super::System::Variant::VARIANT> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetItemData)(windows_core::Interface::as_raw(self), pscid, pscd, &mut result__).map(|| core::mem::transmute(result__))
        }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IColumnProvider_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub Initialize: unsafe extern "system" fn(*mut core::ffi::c_void, *const SHCOLUMNINIT) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_System_Variant")]
    pub GetColumnInfo: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut SHCOLUMNINFO) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Variant"))]
    GetColumnInfo: usize,
    #[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub GetItemData: unsafe extern "system" fn(*mut core::ffi::c_void, *const super::super::Foundation::PROPERTYKEY, *const SHCOLUMNDATA, *mut super::super::System::Variant::VARIANT) -> windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant")))]
    GetItemData: usize,
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
pub trait IColumnProvider_Impl: windows_core::IUnknownImpl {
    fn Initialize(&self, psci: *const SHCOLUMNINIT) -> windows_core::Result<()>;
    fn GetColumnInfo(&self, dwindex: u32, psci: *mut SHCOLUMNINFO) -> windows_core::Result<()>;
    fn GetItemData(&self, pscid: *const super::super::Foundation::PROPERTYKEY, pscd: *const SHCOLUMNDATA) -> windows_core::Result<super::super::System::Variant::VARIANT>;
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl IColumnProvider_Vtbl {
    pub const fn new<Identity: IColumnProvider_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn Initialize<Identity: IColumnProvider_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, psci: *const SHCOLUMNINIT) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IColumnProvider_Impl::Initialize(this, core::mem::transmute_copy(&psci)).into()
            }
        }
        unsafe extern "system" fn GetColumnInfo<Identity: IColumnProvider_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwindex: u32, psci: *mut SHCOLUMNINFO) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IColumnProvider_Impl::GetColumnInfo(this, core::mem::transmute_copy(&dwindex), core::mem::transmute_copy(&psci)).into()
            }
        }
        unsafe extern "system" fn GetItemData<Identity: IColumnProvider_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pscid: *const super::super::Foundation::PROPERTYKEY, pscd: *const SHCOLUMNDATA, pvardata: *mut super::super::System::Variant::VARIANT) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IColumnProvider_Impl::GetItemData(this, core::mem::transmute_copy(&pscid), core::mem::transmute_copy(&pscd)) {
                    Ok(ok__) => {
                        pvardata.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            Initialize: Initialize::<Identity, OFFSET>,
            GetColumnInfo: GetColumnInfo::<Identity, OFFSET>,
            GetItemData: GetItemData::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IColumnProvider as windows_core::Interface>::IID
    }
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl windows_core::RuntimeName for IColumnProvider {}
windows_core::imp::define_interface!(ICommDlgBrowser, ICommDlgBrowser_Vtbl, 0x000214f1_0000_0000_c000_000000000046);
windows_core::imp::interface_hierarchy!(ICommDlgBrowser, windows_core::IUnknown);
impl ICommDlgBrowser {
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn OnDefaultCommand<P0>(&self, ppshv: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IShellView>,
    {
        unsafe { (windows_core::Interface::vtable(self).OnDefaultCommand)(windows_core::Interface::as_raw(self), ppshv.param().abi()).ok() }
    }
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn OnStateChange<P0>(&self, ppshv: P0, uchange: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IShellView>,
    {
        unsafe { (windows_core::Interface::vtable(self).OnStateChange)(windows_core::Interface::as_raw(self), ppshv.param().abi(), uchange).ok() }
    }
    #[cfg(all(feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
    pub unsafe fn IncludeObject<P0>(&self, ppshv: P0, pidl: *const Common::ITEMIDLIST) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IShellView>,
    {
        unsafe { (windows_core::Interface::vtable(self).IncludeObject)(windows_core::Interface::as_raw(self), ppshv.param().abi(), pidl).ok() }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ICommDlgBrowser_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_System_Ole")]
    pub OnDefaultCommand: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Ole"))]
    OnDefaultCommand: usize,
    #[cfg(feature = "Win32_System_Ole")]
    pub OnStateChange: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Ole"))]
    OnStateChange: usize,
    #[cfg(all(feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
    pub IncludeObject: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *const Common::ITEMIDLIST) -> windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common")))]
    IncludeObject: usize,
}
#[cfg(all(feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
pub trait ICommDlgBrowser_Impl: windows_core::IUnknownImpl {
    fn OnDefaultCommand(&self, ppshv: windows_core::Ref<IShellView>) -> windows_core::Result<()>;
    fn OnStateChange(&self, ppshv: windows_core::Ref<IShellView>, uchange: u32) -> windows_core::Result<()>;
    fn IncludeObject(&self, ppshv: windows_core::Ref<IShellView>, pidl: *const Common::ITEMIDLIST) -> windows_core::Result<()>;
}
#[cfg(all(feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
impl ICommDlgBrowser_Vtbl {
    pub const fn new<Identity: ICommDlgBrowser_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn OnDefaultCommand<Identity: ICommDlgBrowser_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ppshv: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ICommDlgBrowser_Impl::OnDefaultCommand(this, core::mem::transmute_copy(&ppshv)).into()
            }
        }
        unsafe extern "system" fn OnStateChange<Identity: ICommDlgBrowser_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ppshv: *mut core::ffi::c_void, uchange: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ICommDlgBrowser_Impl::OnStateChange(this, core::mem::transmute_copy(&ppshv), core::mem::transmute_copy(&uchange)).into()
            }
        }
        unsafe extern "system" fn IncludeObject<Identity: ICommDlgBrowser_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ppshv: *mut core::ffi::c_void, pidl: *const Common::ITEMIDLIST) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ICommDlgBrowser_Impl::IncludeObject(this, core::mem::transmute_copy(&ppshv), core::mem::transmute_copy(&pidl)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            OnDefaultCommand: OnDefaultCommand::<Identity, OFFSET>,
            OnStateChange: OnStateChange::<Identity, OFFSET>,
            IncludeObject: IncludeObject::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<ICommDlgBrowser as windows_core::Interface>::IID
    }
}
#[cfg(all(feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
impl windows_core::RuntimeName for ICommDlgBrowser {}
windows_core::imp::define_interface!(ICommDlgBrowser2, ICommDlgBrowser2_Vtbl, 0x10339516_2894_11d2_9039_00c04f8eeb3e);
impl core::ops::Deref for ICommDlgBrowser2 {
    type Target = ICommDlgBrowser;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(ICommDlgBrowser2, windows_core::IUnknown, ICommDlgBrowser);
impl ICommDlgBrowser2 {
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn Notify<P0>(&self, ppshv: P0, dwnotifytype: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IShellView>,
    {
        unsafe { (windows_core::Interface::vtable(self).Notify)(windows_core::Interface::as_raw(self), ppshv.param().abi(), dwnotifytype).ok() }
    }
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn GetDefaultMenuText<P0>(&self, ppshv: P0, psztext: &mut [u16]) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IShellView>,
    {
        unsafe { (windows_core::Interface::vtable(self).GetDefaultMenuText)(windows_core::Interface::as_raw(self), ppshv.param().abi(), core::mem::transmute(psztext.as_ptr()), psztext.len().try_into().unwrap()).ok() }
    }
    pub unsafe fn GetViewFlags(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetViewFlags)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ICommDlgBrowser2_Vtbl {
    pub base__: ICommDlgBrowser_Vtbl,
    #[cfg(feature = "Win32_System_Ole")]
    pub Notify: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Ole"))]
    Notify: usize,
    #[cfg(feature = "Win32_System_Ole")]
    pub GetDefaultMenuText: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, windows_core::PWSTR, i32) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Ole"))]
    GetDefaultMenuText: usize,
    pub GetViewFlags: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
}
#[cfg(all(feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
pub trait ICommDlgBrowser2_Impl: ICommDlgBrowser_Impl {
    fn Notify(&self, ppshv: windows_core::Ref<IShellView>, dwnotifytype: u32) -> windows_core::Result<()>;
    fn GetDefaultMenuText(&self, ppshv: windows_core::Ref<IShellView>, psztext: windows_core::PWSTR, cchmax: i32) -> windows_core::Result<()>;
    fn GetViewFlags(&self) -> windows_core::Result<u32>;
}
#[cfg(all(feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
impl ICommDlgBrowser2_Vtbl {
    pub const fn new<Identity: ICommDlgBrowser2_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn Notify<Identity: ICommDlgBrowser2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ppshv: *mut core::ffi::c_void, dwnotifytype: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ICommDlgBrowser2_Impl::Notify(this, core::mem::transmute_copy(&ppshv), core::mem::transmute_copy(&dwnotifytype)).into()
            }
        }
        unsafe extern "system" fn GetDefaultMenuText<Identity: ICommDlgBrowser2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ppshv: *mut core::ffi::c_void, psztext: windows_core::PWSTR, cchmax: i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ICommDlgBrowser2_Impl::GetDefaultMenuText(this, core::mem::transmute_copy(&ppshv), core::mem::transmute_copy(&psztext), core::mem::transmute_copy(&cchmax)).into()
            }
        }
        unsafe extern "system" fn GetViewFlags<Identity: ICommDlgBrowser2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pdwflags: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match ICommDlgBrowser2_Impl::GetViewFlags(this) {
                    Ok(ok__) => {
                        pdwflags.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self {
            base__: ICommDlgBrowser_Vtbl::new::<Identity, OFFSET>(),
            Notify: Notify::<Identity, OFFSET>,
            GetDefaultMenuText: GetDefaultMenuText::<Identity, OFFSET>,
            GetViewFlags: GetViewFlags::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<ICommDlgBrowser2 as windows_core::Interface>::IID || iid == &<ICommDlgBrowser as windows_core::Interface>::IID
    }
}
#[cfg(all(feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
impl windows_core::RuntimeName for ICommDlgBrowser2 {}
windows_core::imp::define_interface!(ICommDlgBrowser3, ICommDlgBrowser3_Vtbl, 0xc8ad25a1_3294_41ee_8165_71174bd01c57);
impl core::ops::Deref for ICommDlgBrowser3 {
    type Target = ICommDlgBrowser2;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(ICommDlgBrowser3, windows_core::IUnknown, ICommDlgBrowser, ICommDlgBrowser2);
impl ICommDlgBrowser3 {
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn OnColumnClicked<P0>(&self, ppshv: P0, icolumn: i32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IShellView>,
    {
        unsafe { (windows_core::Interface::vtable(self).OnColumnClicked)(windows_core::Interface::as_raw(self), ppshv.param().abi(), icolumn).ok() }
    }
    pub unsafe fn GetCurrentFilter(&self, pszfilespec: &mut [u16]) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetCurrentFilter)(windows_core::Interface::as_raw(self), core::mem::transmute(pszfilespec.as_ptr()), pszfilespec.len().try_into().unwrap()).ok() }
    }
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn OnPreViewCreated<P0>(&self, ppshv: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IShellView>,
    {
        unsafe { (windows_core::Interface::vtable(self).OnPreViewCreated)(windows_core::Interface::as_raw(self), ppshv.param().abi()).ok() }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ICommDlgBrowser3_Vtbl {
    pub base__: ICommDlgBrowser2_Vtbl,
    #[cfg(feature = "Win32_System_Ole")]
    pub OnColumnClicked: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, i32) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Ole"))]
    OnColumnClicked: usize,
    pub GetCurrentFilter: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PWSTR, i32) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_System_Ole")]
    pub OnPreViewCreated: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Ole"))]
    OnPreViewCreated: usize,
}
#[cfg(all(feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
pub trait ICommDlgBrowser3_Impl: ICommDlgBrowser2_Impl {
    fn OnColumnClicked(&self, ppshv: windows_core::Ref<IShellView>, icolumn: i32) -> windows_core::Result<()>;
    fn GetCurrentFilter(&self, pszfilespec: windows_core::PWSTR, cchfilespec: i32) -> windows_core::Result<()>;
    fn OnPreViewCreated(&self, ppshv: windows_core::Ref<IShellView>) -> windows_core::Result<()>;
}
#[cfg(all(feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
impl ICommDlgBrowser3_Vtbl {
    pub const fn new<Identity: ICommDlgBrowser3_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn OnColumnClicked<Identity: ICommDlgBrowser3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ppshv: *mut core::ffi::c_void, icolumn: i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ICommDlgBrowser3_Impl::OnColumnClicked(this, core::mem::transmute_copy(&ppshv), core::mem::transmute_copy(&icolumn)).into()
            }
        }
        unsafe extern "system" fn GetCurrentFilter<Identity: ICommDlgBrowser3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pszfilespec: windows_core::PWSTR, cchfilespec: i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ICommDlgBrowser3_Impl::GetCurrentFilter(this, core::mem::transmute_copy(&pszfilespec), core::mem::transmute_copy(&cchfilespec)).into()
            }
        }
        unsafe extern "system" fn OnPreViewCreated<Identity: ICommDlgBrowser3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ppshv: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ICommDlgBrowser3_Impl::OnPreViewCreated(this, core::mem::transmute_copy(&ppshv)).into()
            }
        }
        Self {
            base__: ICommDlgBrowser2_Vtbl::new::<Identity, OFFSET>(),
            OnColumnClicked: OnColumnClicked::<Identity, OFFSET>,
            GetCurrentFilter: GetCurrentFilter::<Identity, OFFSET>,
            OnPreViewCreated: OnPreViewCreated::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<ICommDlgBrowser3 as windows_core::Interface>::IID || iid == &<ICommDlgBrowser as windows_core::Interface>::IID || iid == &<ICommDlgBrowser2 as windows_core::Interface>::IID
    }
}
#[cfg(all(feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
impl windows_core::RuntimeName for ICommDlgBrowser3 {}
windows_core::imp::define_interface!(IComputerInfoChangeNotify, IComputerInfoChangeNotify_Vtbl, 0x0df60d92_6818_46d6_b358_d66170dde466);
windows_core::imp::interface_hierarchy!(IComputerInfoChangeNotify, windows_core::IUnknown);
impl IComputerInfoChangeNotify {
    pub unsafe fn ComputerInfoChanged(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).ComputerInfoChanged)(windows_core::Interface::as_raw(self)).ok() }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IComputerInfoChangeNotify_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub ComputerInfoChanged: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
}
pub trait IComputerInfoChangeNotify_Impl: windows_core::IUnknownImpl {
    fn ComputerInfoChanged(&self) -> windows_core::Result<()>;
}
impl IComputerInfoChangeNotify_Vtbl {
    pub const fn new<Identity: IComputerInfoChangeNotify_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn ComputerInfoChanged<Identity: IComputerInfoChangeNotify_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IComputerInfoChangeNotify_Impl::ComputerInfoChanged(this).into()
            }
        }
        Self { base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(), ComputerInfoChanged: ComputerInfoChanged::<Identity, OFFSET> }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IComputerInfoChangeNotify as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IComputerInfoChangeNotify {}
windows_core::imp::define_interface!(IConnectableCredentialProviderCredential, IConnectableCredentialProviderCredential_Vtbl, 0x9387928b_ac75_4bf9_8ab2_2b93c4a55290);
impl core::ops::Deref for IConnectableCredentialProviderCredential {
    type Target = ICredentialProviderCredential;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IConnectableCredentialProviderCredential, windows_core::IUnknown, ICredentialProviderCredential);
impl IConnectableCredentialProviderCredential {
    pub unsafe fn Connect<P0>(&self, pqcws: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IQueryContinueWithStatus>,
    {
        unsafe { (windows_core::Interface::vtable(self).Connect)(windows_core::Interface::as_raw(self), pqcws.param().abi()).ok() }
    }
    pub unsafe fn Disconnect(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).Disconnect)(windows_core::Interface::as_raw(self)).ok() }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IConnectableCredentialProviderCredential_Vtbl {
    pub base__: ICredentialProviderCredential_Vtbl,
    pub Connect: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub Disconnect: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
}
#[cfg(feature = "Win32_Graphics_Gdi")]
pub trait IConnectableCredentialProviderCredential_Impl: ICredentialProviderCredential_Impl {
    fn Connect(&self, pqcws: windows_core::Ref<IQueryContinueWithStatus>) -> windows_core::Result<()>;
    fn Disconnect(&self) -> windows_core::Result<()>;
}
#[cfg(feature = "Win32_Graphics_Gdi")]
impl IConnectableCredentialProviderCredential_Vtbl {
    pub const fn new<Identity: IConnectableCredentialProviderCredential_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn Connect<Identity: IConnectableCredentialProviderCredential_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pqcws: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IConnectableCredentialProviderCredential_Impl::Connect(this, core::mem::transmute_copy(&pqcws)).into()
            }
        }
        unsafe extern "system" fn Disconnect<Identity: IConnectableCredentialProviderCredential_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IConnectableCredentialProviderCredential_Impl::Disconnect(this).into()
            }
        }
        Self {
            base__: ICredentialProviderCredential_Vtbl::new::<Identity, OFFSET>(),
            Connect: Connect::<Identity, OFFSET>,
            Disconnect: Disconnect::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IConnectableCredentialProviderCredential as windows_core::Interface>::IID || iid == &<ICredentialProviderCredential as windows_core::Interface>::IID
    }
}
#[cfg(feature = "Win32_Graphics_Gdi")]
impl windows_core::RuntimeName for IConnectableCredentialProviderCredential {}
windows_core::imp::define_interface!(IContactManagerInterop, IContactManagerInterop_Vtbl, 0x99eacba7_e073_43b6_a896_55afe48a0833);
windows_core::imp::interface_hierarchy!(IContactManagerInterop, windows_core::IUnknown);
impl IContactManagerInterop {
    pub unsafe fn ShowContactCardForWindow<P1>(&self, appwindow: super::super::Foundation::HWND, contact: P1, selection: *const super::super::Foundation::RECT, preferredplacement: FLYOUT_PLACEMENT) -> windows_core::Result<()>
    where
        P1: windows_core::Param<windows_core::IUnknown>,
    {
        unsafe { (windows_core::Interface::vtable(self).ShowContactCardForWindow)(windows_core::Interface::as_raw(self), appwindow, contact.param().abi(), selection, preferredplacement).ok() }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IContactManagerInterop_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub ShowContactCardForWindow: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::HWND, *mut core::ffi::c_void, *const super::super::Foundation::RECT, FLYOUT_PLACEMENT) -> windows_core::HRESULT,
}
pub trait IContactManagerInterop_Impl: windows_core::IUnknownImpl {
    fn ShowContactCardForWindow(&self, appwindow: super::super::Foundation::HWND, contact: windows_core::Ref<windows_core::IUnknown>, selection: *const super::super::Foundation::RECT, preferredplacement: FLYOUT_PLACEMENT) -> windows_core::Result<()>;
}
impl IContactManagerInterop_Vtbl {
    pub const fn new<Identity: IContactManagerInterop_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn ShowContactCardForWindow<Identity: IContactManagerInterop_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, appwindow: super::super::Foundation::HWND, contact: *mut core::ffi::c_void, selection: *const super::super::Foundation::RECT, preferredplacement: FLYOUT_PLACEMENT) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IContactManagerInterop_Impl::ShowContactCardForWindow(this, core::mem::transmute_copy(&appwindow), core::mem::transmute_copy(&contact), core::mem::transmute_copy(&selection), core::mem::transmute_copy(&preferredplacement)).into()
            }
        }
        Self { base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(), ShowContactCardForWindow: ShowContactCardForWindow::<Identity, OFFSET> }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IContactManagerInterop as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IContactManagerInterop {}
windows_core::imp::define_interface!(IContextMenu, IContextMenu_Vtbl, 0x000214e4_0000_0000_c000_000000000046);
windows_core::imp::interface_hierarchy!(IContextMenu, windows_core::IUnknown);
impl IContextMenu {
    #[cfg(feature = "Win32_UI_WindowsAndMessaging")]
    pub unsafe fn QueryContextMenu(&self, hmenu: super::WindowsAndMessaging::HMENU, indexmenu: u32, idcmdfirst: u32, idcmdlast: u32, uflags: u32) -> windows_core::HRESULT {
        unsafe { (windows_core::Interface::vtable(self).QueryContextMenu)(windows_core::Interface::as_raw(self), hmenu, indexmenu, idcmdfirst, idcmdlast, uflags) }
    }
    pub unsafe fn InvokeCommand(&self, pici: *const CMINVOKECOMMANDINFO) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).InvokeCommand)(windows_core::Interface::as_raw(self), pici).ok() }
    }
    pub unsafe fn GetCommandString(&self, idcmd: usize, utype: u32, preserved: Option<*const u32>, pszname: windows_core::PSTR, cchmax: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetCommandString)(windows_core::Interface::as_raw(self), idcmd, utype, preserved.unwrap_or(core::mem::zeroed()) as _, core::mem::transmute(pszname), cchmax).ok() }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IContextMenu_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_UI_WindowsAndMessaging")]
    pub QueryContextMenu: unsafe extern "system" fn(*mut core::ffi::c_void, super::WindowsAndMessaging::HMENU, u32, u32, u32, u32) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_UI_WindowsAndMessaging"))]
    QueryContextMenu: usize,
    pub InvokeCommand: unsafe extern "system" fn(*mut core::ffi::c_void, *const CMINVOKECOMMANDINFO) -> windows_core::HRESULT,
    pub GetCommandString: unsafe extern "system" fn(*mut core::ffi::c_void, usize, u32, *const u32, windows_core::PSTR, u32) -> windows_core::HRESULT,
}
#[cfg(feature = "Win32_UI_WindowsAndMessaging")]
pub trait IContextMenu_Impl: windows_core::IUnknownImpl {
    fn QueryContextMenu(&self, hmenu: super::WindowsAndMessaging::HMENU, indexmenu: u32, idcmdfirst: u32, idcmdlast: u32, uflags: u32) -> windows_core::HRESULT;
    fn InvokeCommand(&self, pici: *const CMINVOKECOMMANDINFO) -> windows_core::Result<()>;
    fn GetCommandString(&self, idcmd: usize, utype: u32, preserved: *const u32, pszname: windows_core::PSTR, cchmax: u32) -> windows_core::Result<()>;
}
#[cfg(feature = "Win32_UI_WindowsAndMessaging")]
impl IContextMenu_Vtbl {
    pub const fn new<Identity: IContextMenu_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn QueryContextMenu<Identity: IContextMenu_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, hmenu: super::WindowsAndMessaging::HMENU, indexmenu: u32, idcmdfirst: u32, idcmdlast: u32, uflags: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IContextMenu_Impl::QueryContextMenu(this, core::mem::transmute_copy(&hmenu), core::mem::transmute_copy(&indexmenu), core::mem::transmute_copy(&idcmdfirst), core::mem::transmute_copy(&idcmdlast), core::mem::transmute_copy(&uflags))
            }
        }
        unsafe extern "system" fn InvokeCommand<Identity: IContextMenu_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pici: *const CMINVOKECOMMANDINFO) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IContextMenu_Impl::InvokeCommand(this, core::mem::transmute_copy(&pici)).into()
            }
        }
        unsafe extern "system" fn GetCommandString<Identity: IContextMenu_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, idcmd: usize, utype: u32, preserved: *const u32, pszname: windows_core::PSTR, cchmax: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IContextMenu_Impl::GetCommandString(this, core::mem::transmute_copy(&idcmd), core::mem::transmute_copy(&utype), core::mem::transmute_copy(&preserved), core::mem::transmute_copy(&pszname), core::mem::transmute_copy(&cchmax)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            QueryContextMenu: QueryContextMenu::<Identity, OFFSET>,
            InvokeCommand: InvokeCommand::<Identity, OFFSET>,
            GetCommandString: GetCommandString::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IContextMenu as windows_core::Interface>::IID
    }
}
#[cfg(feature = "Win32_UI_WindowsAndMessaging")]
impl windows_core::RuntimeName for IContextMenu {}
windows_core::imp::define_interface!(IContextMenu2, IContextMenu2_Vtbl, 0x000214f4_0000_0000_c000_000000000046);
impl core::ops::Deref for IContextMenu2 {
    type Target = IContextMenu;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IContextMenu2, windows_core::IUnknown, IContextMenu);
impl IContextMenu2 {
    pub unsafe fn HandleMenuMsg(&self, umsg: u32, wparam: super::super::Foundation::WPARAM, lparam: super::super::Foundation::LPARAM) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).HandleMenuMsg)(windows_core::Interface::as_raw(self), umsg, wparam, lparam).ok() }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IContextMenu2_Vtbl {
    pub base__: IContextMenu_Vtbl,
    pub HandleMenuMsg: unsafe extern "system" fn(*mut core::ffi::c_void, u32, super::super::Foundation::WPARAM, super::super::Foundation::LPARAM) -> windows_core::HRESULT,
}
#[cfg(feature = "Win32_UI_WindowsAndMessaging")]
pub trait IContextMenu2_Impl: IContextMenu_Impl {
    fn HandleMenuMsg(&self, umsg: u32, wparam: super::super::Foundation::WPARAM, lparam: super::super::Foundation::LPARAM) -> windows_core::Result<()>;
}
#[cfg(feature = "Win32_UI_WindowsAndMessaging")]
impl IContextMenu2_Vtbl {
    pub const fn new<Identity: IContextMenu2_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn HandleMenuMsg<Identity: IContextMenu2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, umsg: u32, wparam: super::super::Foundation::WPARAM, lparam: super::super::Foundation::LPARAM) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IContextMenu2_Impl::HandleMenuMsg(this, core::mem::transmute_copy(&umsg), core::mem::transmute_copy(&wparam), core::mem::transmute_copy(&lparam)).into()
            }
        }
        Self { base__: IContextMenu_Vtbl::new::<Identity, OFFSET>(), HandleMenuMsg: HandleMenuMsg::<Identity, OFFSET> }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IContextMenu2 as windows_core::Interface>::IID || iid == &<IContextMenu as windows_core::Interface>::IID
    }
}
#[cfg(feature = "Win32_UI_WindowsAndMessaging")]
impl windows_core::RuntimeName for IContextMenu2 {}
windows_core::imp::define_interface!(IContextMenu3, IContextMenu3_Vtbl, 0xbcfce0a0_ec17_11d0_8d10_00a0c90f2719);
impl core::ops::Deref for IContextMenu3 {
    type Target = IContextMenu2;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IContextMenu3, windows_core::IUnknown, IContextMenu, IContextMenu2);
impl IContextMenu3 {
    pub unsafe fn HandleMenuMsg2(&self, umsg: u32, wparam: super::super::Foundation::WPARAM, lparam: super::super::Foundation::LPARAM, plresult: Option<*mut super::super::Foundation::LRESULT>) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).HandleMenuMsg2)(windows_core::Interface::as_raw(self), umsg, wparam, lparam, plresult.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IContextMenu3_Vtbl {
    pub base__: IContextMenu2_Vtbl,
    pub HandleMenuMsg2: unsafe extern "system" fn(*mut core::ffi::c_void, u32, super::super::Foundation::WPARAM, super::super::Foundation::LPARAM, *mut super::super::Foundation::LRESULT) -> windows_core::HRESULT,
}
#[cfg(feature = "Win32_UI_WindowsAndMessaging")]
pub trait IContextMenu3_Impl: IContextMenu2_Impl {
    fn HandleMenuMsg2(&self, umsg: u32, wparam: super::super::Foundation::WPARAM, lparam: super::super::Foundation::LPARAM, plresult: *mut super::super::Foundation::LRESULT) -> windows_core::Result<()>;
}
#[cfg(feature = "Win32_UI_WindowsAndMessaging")]
impl IContextMenu3_Vtbl {
    pub const fn new<Identity: IContextMenu3_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn HandleMenuMsg2<Identity: IContextMenu3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, umsg: u32, wparam: super::super::Foundation::WPARAM, lparam: super::super::Foundation::LPARAM, plresult: *mut super::super::Foundation::LRESULT) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IContextMenu3_Impl::HandleMenuMsg2(this, core::mem::transmute_copy(&umsg), core::mem::transmute_copy(&wparam), core::mem::transmute_copy(&lparam), core::mem::transmute_copy(&plresult)).into()
            }
        }
        Self { base__: IContextMenu2_Vtbl::new::<Identity, OFFSET>(), HandleMenuMsg2: HandleMenuMsg2::<Identity, OFFSET> }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IContextMenu3 as windows_core::Interface>::IID || iid == &<IContextMenu as windows_core::Interface>::IID || iid == &<IContextMenu2 as windows_core::Interface>::IID
    }
}
#[cfg(feature = "Win32_UI_WindowsAndMessaging")]
impl windows_core::RuntimeName for IContextMenu3 {}
windows_core::imp::define_interface!(IContextMenuCB, IContextMenuCB_Vtbl, 0x3409e930_5a39_11d1_83fa_00a0c90dc849);
windows_core::imp::interface_hierarchy!(IContextMenuCB, windows_core::IUnknown);
impl IContextMenuCB {
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn CallBack<P0, P2>(&self, psf: P0, hwndowner: Option<super::super::Foundation::HWND>, pdtobj: P2, umsg: u32, wparam: super::super::Foundation::WPARAM, lparam: super::super::Foundation::LPARAM) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IShellFolder>,
        P2: windows_core::Param<super::super::System::Com::IDataObject>,
    {
        unsafe { (windows_core::Interface::vtable(self).CallBack)(windows_core::Interface::as_raw(self), psf.param().abi(), hwndowner.unwrap_or(core::mem::zeroed()) as _, pdtobj.param().abi(), umsg, wparam, lparam).ok() }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IContextMenuCB_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_System_Com")]
    pub CallBack: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, super::super::Foundation::HWND, *mut core::ffi::c_void, u32, super::super::Foundation::WPARAM, super::super::Foundation::LPARAM) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    CallBack: usize,
}
#[cfg(feature = "Win32_System_Com")]
pub trait IContextMenuCB_Impl: windows_core::IUnknownImpl {
    fn CallBack(&self, psf: windows_core::Ref<IShellFolder>, hwndowner: super::super::Foundation::HWND, pdtobj: windows_core::Ref<super::super::System::Com::IDataObject>, umsg: u32, wparam: super::super::Foundation::WPARAM, lparam: super::super::Foundation::LPARAM) -> windows_core::Result<()>;
}
#[cfg(feature = "Win32_System_Com")]
impl IContextMenuCB_Vtbl {
    pub const fn new<Identity: IContextMenuCB_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn CallBack<Identity: IContextMenuCB_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, psf: *mut core::ffi::c_void, hwndowner: super::super::Foundation::HWND, pdtobj: *mut core::ffi::c_void, umsg: u32, wparam: super::super::Foundation::WPARAM, lparam: super::super::Foundation::LPARAM) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IContextMenuCB_Impl::CallBack(this, core::mem::transmute_copy(&psf), core::mem::transmute_copy(&hwndowner), core::mem::transmute_copy(&pdtobj), core::mem::transmute_copy(&umsg), core::mem::transmute_copy(&wparam), core::mem::transmute_copy(&lparam)).into()
            }
        }
        Self { base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(), CallBack: CallBack::<Identity, OFFSET> }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IContextMenuCB as windows_core::Interface>::IID
    }
}
#[cfg(feature = "Win32_System_Com")]
impl windows_core::RuntimeName for IContextMenuCB {}
windows_core::imp::define_interface!(IContextMenuSite, IContextMenuSite_Vtbl, 0x0811aebe_0b87_4c54_9e72_548cf649016b);
windows_core::imp::interface_hierarchy!(IContextMenuSite, windows_core::IUnknown);
impl IContextMenuSite {
    pub unsafe fn DoContextMenuPopup<P0>(&self, punkcontextmenu: P0, fflags: u32, pt: super::super::Foundation::POINT) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::IUnknown>,
    {
        unsafe { (windows_core::Interface::vtable(self).DoContextMenuPopup)(windows_core::Interface::as_raw(self), punkcontextmenu.param().abi(), fflags, core::mem::transmute(pt)).ok() }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IContextMenuSite_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub DoContextMenuPopup: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, u32, super::super::Foundation::POINT) -> windows_core::HRESULT,
}
pub trait IContextMenuSite_Impl: windows_core::IUnknownImpl {
    fn DoContextMenuPopup(&self, punkcontextmenu: windows_core::Ref<windows_core::IUnknown>, fflags: u32, pt: &super::super::Foundation::POINT) -> windows_core::Result<()>;
}
impl IContextMenuSite_Vtbl {
    pub const fn new<Identity: IContextMenuSite_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn DoContextMenuPopup<Identity: IContextMenuSite_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, punkcontextmenu: *mut core::ffi::c_void, fflags: u32, pt: super::super::Foundation::POINT) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IContextMenuSite_Impl::DoContextMenuPopup(this, core::mem::transmute_copy(&punkcontextmenu), core::mem::transmute_copy(&fflags), core::mem::transmute(&pt)).into()
            }
        }
        Self { base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(), DoContextMenuPopup: DoContextMenuPopup::<Identity, OFFSET> }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IContextMenuSite as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IContextMenuSite {}
windows_core::imp::define_interface!(ICopyHookA, ICopyHookA_Vtbl, 0x000214ef_0000_0000_c000_000000000046);
windows_core::imp::interface_hierarchy!(ICopyHookA, windows_core::IUnknown);
impl ICopyHookA {
    pub unsafe fn CopyCallback<P3, P5>(&self, hwnd: Option<super::super::Foundation::HWND>, wfunc: u32, wflags: u32, pszsrcfile: P3, dwsrcattribs: u32, pszdestfile: P5, dwdestattribs: u32) -> u32
    where
        P3: windows_core::Param<windows_core::PCSTR>,
        P5: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).CopyCallback)(windows_core::Interface::as_raw(self), hwnd.unwrap_or(core::mem::zeroed()) as _, wfunc, wflags, pszsrcfile.param().abi(), dwsrcattribs, pszdestfile.param().abi(), dwdestattribs) }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ICopyHookA_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub CopyCallback: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::HWND, u32, u32, windows_core::PCSTR, u32, windows_core::PCSTR, u32) -> u32,
}
pub trait ICopyHookA_Impl: windows_core::IUnknownImpl {
    fn CopyCallback(&self, hwnd: super::super::Foundation::HWND, wfunc: u32, wflags: u32, pszsrcfile: &windows_core::PCSTR, dwsrcattribs: u32, pszdestfile: &windows_core::PCSTR, dwdestattribs: u32) -> u32;
}
impl ICopyHookA_Vtbl {
    pub const fn new<Identity: ICopyHookA_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn CopyCallback<Identity: ICopyHookA_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, hwnd: super::super::Foundation::HWND, wfunc: u32, wflags: u32, pszsrcfile: windows_core::PCSTR, dwsrcattribs: u32, pszdestfile: windows_core::PCSTR, dwdestattribs: u32) -> u32 {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ICopyHookA_Impl::CopyCallback(this, core::mem::transmute_copy(&hwnd), core::mem::transmute_copy(&wfunc), core::mem::transmute_copy(&wflags), core::mem::transmute(&pszsrcfile), core::mem::transmute_copy(&dwsrcattribs), core::mem::transmute(&pszdestfile), core::mem::transmute_copy(&dwdestattribs))
            }
        }
        Self { base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(), CopyCallback: CopyCallback::<Identity, OFFSET> }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<ICopyHookA as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for ICopyHookA {}
windows_core::imp::define_interface!(ICopyHookW, ICopyHookW_Vtbl, 0x000214fc_0000_0000_c000_000000000046);
windows_core::imp::interface_hierarchy!(ICopyHookW, windows_core::IUnknown);
impl ICopyHookW {
    pub unsafe fn CopyCallback<P3, P5>(&self, hwnd: Option<super::super::Foundation::HWND>, wfunc: u32, wflags: u32, pszsrcfile: P3, dwsrcattribs: u32, pszdestfile: P5, dwdestattribs: u32) -> u32
    where
        P3: windows_core::Param<windows_core::PCWSTR>,
        P5: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).CopyCallback)(windows_core::Interface::as_raw(self), hwnd.unwrap_or(core::mem::zeroed()) as _, wfunc, wflags, pszsrcfile.param().abi(), dwsrcattribs, pszdestfile.param().abi(), dwdestattribs) }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ICopyHookW_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub CopyCallback: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::HWND, u32, u32, windows_core::PCWSTR, u32, windows_core::PCWSTR, u32) -> u32,
}
pub trait ICopyHookW_Impl: windows_core::IUnknownImpl {
    fn CopyCallback(&self, hwnd: super::super::Foundation::HWND, wfunc: u32, wflags: u32, pszsrcfile: &windows_core::PCWSTR, dwsrcattribs: u32, pszdestfile: &windows_core::PCWSTR, dwdestattribs: u32) -> u32;
}
impl ICopyHookW_Vtbl {
    pub const fn new<Identity: ICopyHookW_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn CopyCallback<Identity: ICopyHookW_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, hwnd: super::super::Foundation::HWND, wfunc: u32, wflags: u32, pszsrcfile: windows_core::PCWSTR, dwsrcattribs: u32, pszdestfile: windows_core::PCWSTR, dwdestattribs: u32) -> u32 {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ICopyHookW_Impl::CopyCallback(this, core::mem::transmute_copy(&hwnd), core::mem::transmute_copy(&wfunc), core::mem::transmute_copy(&wflags), core::mem::transmute(&pszsrcfile), core::mem::transmute_copy(&dwsrcattribs), core::mem::transmute(&pszdestfile), core::mem::transmute_copy(&dwdestattribs))
            }
        }
        Self { base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(), CopyCallback: CopyCallback::<Identity, OFFSET> }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<ICopyHookW as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for ICopyHookW {}
windows_core::imp::define_interface!(ICreateProcessInputs, ICreateProcessInputs_Vtbl, 0xf6ef6140_e26f_4d82_bac4_e9ba5fd239a8);
windows_core::imp::interface_hierarchy!(ICreateProcessInputs, windows_core::IUnknown);
impl ICreateProcessInputs {
    pub unsafe fn GetCreateFlags(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetCreateFlags)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetCreateFlags(&self, dwcreationflags: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetCreateFlags)(windows_core::Interface::as_raw(self), dwcreationflags).ok() }
    }
    pub unsafe fn AddCreateFlags(&self, dwcreationflags: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).AddCreateFlags)(windows_core::Interface::as_raw(self), dwcreationflags).ok() }
    }
    pub unsafe fn SetHotKey(&self, whotkey: u16) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetHotKey)(windows_core::Interface::as_raw(self), whotkey).ok() }
    }
    pub unsafe fn AddStartupFlags(&self, dwstartupinfoflags: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).AddStartupFlags)(windows_core::Interface::as_raw(self), dwstartupinfoflags).ok() }
    }
    pub unsafe fn SetTitle<P0>(&self, psztitle: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).SetTitle)(windows_core::Interface::as_raw(self), psztitle.param().abi()).ok() }
    }
    pub unsafe fn SetEnvironmentVariable<P0, P1>(&self, pszname: P0, pszvalue: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
        P1: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).SetEnvironmentVariable)(windows_core::Interface::as_raw(self), pszname.param().abi(), pszvalue.param().abi()).ok() }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ICreateProcessInputs_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetCreateFlags: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetCreateFlags: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub AddCreateFlags: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub SetHotKey: unsafe extern "system" fn(*mut core::ffi::c_void, u16) -> windows_core::HRESULT,
    pub AddStartupFlags: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub SetTitle: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub SetEnvironmentVariable: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, windows_core::PCWSTR) -> windows_core::HRESULT,
}
pub trait ICreateProcessInputs_Impl: windows_core::IUnknownImpl {
    fn GetCreateFlags(&self) -> windows_core::Result<u32>;
    fn SetCreateFlags(&self, dwcreationflags: u32) -> windows_core::Result<()>;
    fn AddCreateFlags(&self, dwcreationflags: u32) -> windows_core::Result<()>;
    fn SetHotKey(&self, whotkey: u16) -> windows_core::Result<()>;
    fn AddStartupFlags(&self, dwstartupinfoflags: u32) -> windows_core::Result<()>;
    fn SetTitle(&self, psztitle: &windows_core::PCWSTR) -> windows_core::Result<()>;
    fn SetEnvironmentVariable(&self, pszname: &windows_core::PCWSTR, pszvalue: &windows_core::PCWSTR) -> windows_core::Result<()>;
}
impl ICreateProcessInputs_Vtbl {
    pub const fn new<Identity: ICreateProcessInputs_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetCreateFlags<Identity: ICreateProcessInputs_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pdwcreationflags: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match ICreateProcessInputs_Impl::GetCreateFlags(this) {
                    Ok(ok__) => {
                        pdwcreationflags.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetCreateFlags<Identity: ICreateProcessInputs_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwcreationflags: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ICreateProcessInputs_Impl::SetCreateFlags(this, core::mem::transmute_copy(&dwcreationflags)).into()
            }
        }
        unsafe extern "system" fn AddCreateFlags<Identity: ICreateProcessInputs_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwcreationflags: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ICreateProcessInputs_Impl::AddCreateFlags(this, core::mem::transmute_copy(&dwcreationflags)).into()
            }
        }
        unsafe extern "system" fn SetHotKey<Identity: ICreateProcessInputs_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, whotkey: u16) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ICreateProcessInputs_Impl::SetHotKey(this, core::mem::transmute_copy(&whotkey)).into()
            }
        }
        unsafe extern "system" fn AddStartupFlags<Identity: ICreateProcessInputs_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwstartupinfoflags: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ICreateProcessInputs_Impl::AddStartupFlags(this, core::mem::transmute_copy(&dwstartupinfoflags)).into()
            }
        }
        unsafe extern "system" fn SetTitle<Identity: ICreateProcessInputs_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, psztitle: windows_core::PCWSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ICreateProcessInputs_Impl::SetTitle(this, core::mem::transmute(&psztitle)).into()
            }
        }
        unsafe extern "system" fn SetEnvironmentVariable<Identity: ICreateProcessInputs_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pszname: windows_core::PCWSTR, pszvalue: windows_core::PCWSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ICreateProcessInputs_Impl::SetEnvironmentVariable(this, core::mem::transmute(&pszname), core::mem::transmute(&pszvalue)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            GetCreateFlags: GetCreateFlags::<Identity, OFFSET>,
            SetCreateFlags: SetCreateFlags::<Identity, OFFSET>,
            AddCreateFlags: AddCreateFlags::<Identity, OFFSET>,
            SetHotKey: SetHotKey::<Identity, OFFSET>,
            AddStartupFlags: AddStartupFlags::<Identity, OFFSET>,
            SetTitle: SetTitle::<Identity, OFFSET>,
            SetEnvironmentVariable: SetEnvironmentVariable::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<ICreateProcessInputs as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for ICreateProcessInputs {}
windows_core::imp::define_interface!(ICreatingProcess, ICreatingProcess_Vtbl, 0xc2b937a9_3110_4398_8a56_f34c6342d244);
windows_core::imp::interface_hierarchy!(ICreatingProcess, windows_core::IUnknown);
impl ICreatingProcess {
    pub unsafe fn OnCreating<P0>(&self, pcpi: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICreateProcessInputs>,
    {
        unsafe { (windows_core::Interface::vtable(self).OnCreating)(windows_core::Interface::as_raw(self), pcpi.param().abi()).ok() }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ICreatingProcess_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub OnCreating: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
}
pub trait ICreatingProcess_Impl: windows_core::IUnknownImpl {
    fn OnCreating(&self, pcpi: windows_core::Ref<ICreateProcessInputs>) -> windows_core::Result<()>;
}
impl ICreatingProcess_Vtbl {
    pub const fn new<Identity: ICreatingProcess_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn OnCreating<Identity: ICreatingProcess_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pcpi: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ICreatingProcess_Impl::OnCreating(this, core::mem::transmute_copy(&pcpi)).into()
            }
        }
        Self { base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(), OnCreating: OnCreating::<Identity, OFFSET> }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<ICreatingProcess as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for ICreatingProcess {}
windows_core::imp::define_interface!(ICredentialProvider, ICredentialProvider_Vtbl, 0xd27c3481_5a1c_45b2_8aaa_c20ebbe8229e);
windows_core::imp::interface_hierarchy!(ICredentialProvider, windows_core::IUnknown);
impl ICredentialProvider {
    pub unsafe fn SetUsageScenario(&self, cpus: CREDENTIAL_PROVIDER_USAGE_SCENARIO, dwflags: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetUsageScenario)(windows_core::Interface::as_raw(self), cpus, dwflags).ok() }
    }
    pub unsafe fn SetSerialization(&self, pcpcs: *const CREDENTIAL_PROVIDER_CREDENTIAL_SERIALIZATION) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetSerialization)(windows_core::Interface::as_raw(self), pcpcs).ok() }
    }
    pub unsafe fn Advise<P0>(&self, pcpe: P0, upadvisecontext: usize) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICredentialProviderEvents>,
    {
        unsafe { (windows_core::Interface::vtable(self).Advise)(windows_core::Interface::as_raw(self), pcpe.param().abi(), upadvisecontext).ok() }
    }
    pub unsafe fn UnAdvise(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).UnAdvise)(windows_core::Interface::as_raw(self)).ok() }
    }
    pub unsafe fn GetFieldDescriptorCount(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetFieldDescriptorCount)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetFieldDescriptorAt(&self, dwindex: u32) -> windows_core::Result<*mut CREDENTIAL_PROVIDER_FIELD_DESCRIPTOR> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetFieldDescriptorAt)(windows_core::Interface::as_raw(self), dwindex, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetCredentialCount(&self, pdwcount: *mut u32, pdwdefault: *mut u32, pbautologonwithdefault: *mut windows_core::BOOL) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetCredentialCount)(windows_core::Interface::as_raw(self), pdwcount as _, pdwdefault as _, pbautologonwithdefault as _).ok() }
    }
    pub unsafe fn GetCredentialAt(&self, dwindex: u32) -> windows_core::Result<ICredentialProviderCredential> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetCredentialAt)(windows_core::Interface::as_raw(self), dwindex, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ICredentialProvider_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub SetUsageScenario: unsafe extern "system" fn(*mut core::ffi::c_void, CREDENTIAL_PROVIDER_USAGE_SCENARIO, u32) -> windows_core::HRESULT,
    pub SetSerialization: unsafe extern "system" fn(*mut core::ffi::c_void, *const CREDENTIAL_PROVIDER_CREDENTIAL_SERIALIZATION) -> windows_core::HRESULT,
    pub Advise: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, usize) -> windows_core::HRESULT,
    pub UnAdvise: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetFieldDescriptorCount: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetFieldDescriptorAt: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut *mut CREDENTIAL_PROVIDER_FIELD_DESCRIPTOR) -> windows_core::HRESULT,
    pub GetCredentialCount: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, *mut u32, *mut windows_core::BOOL) -> windows_core::HRESULT,
    pub GetCredentialAt: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
pub trait ICredentialProvider_Impl: windows_core::IUnknownImpl {
    fn SetUsageScenario(&self, cpus: CREDENTIAL_PROVIDER_USAGE_SCENARIO, dwflags: u32) -> windows_core::Result<()>;
    fn SetSerialization(&self, pcpcs: *const CREDENTIAL_PROVIDER_CREDENTIAL_SERIALIZATION) -> windows_core::Result<()>;
    fn Advise(&self, pcpe: windows_core::Ref<ICredentialProviderEvents>, upadvisecontext: usize) -> windows_core::Result<()>;
    fn UnAdvise(&self) -> windows_core::Result<()>;
    fn GetFieldDescriptorCount(&self) -> windows_core::Result<u32>;
    fn GetFieldDescriptorAt(&self, dwindex: u32) -> windows_core::Result<*mut CREDENTIAL_PROVIDER_FIELD_DESCRIPTOR>;
    fn GetCredentialCount(&self, pdwcount: *mut u32, pdwdefault: *mut u32, pbautologonwithdefault: *mut windows_core::BOOL) -> windows_core::Result<()>;
    fn GetCredentialAt(&self, dwindex: u32) -> windows_core::Result<ICredentialProviderCredential>;
}
impl ICredentialProvider_Vtbl {
    pub const fn new<Identity: ICredentialProvider_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn SetUsageScenario<Identity: ICredentialProvider_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, cpus: CREDENTIAL_PROVIDER_USAGE_SCENARIO, dwflags: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ICredentialProvider_Impl::SetUsageScenario(this, core::mem::transmute_copy(&cpus), core::mem::transmute_copy(&dwflags)).into()
            }
        }
        unsafe extern "system" fn SetSerialization<Identity: ICredentialProvider_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pcpcs: *const CREDENTIAL_PROVIDER_CREDENTIAL_SERIALIZATION) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ICredentialProvider_Impl::SetSerialization(this, core::mem::transmute_copy(&pcpcs)).into()
            }
        }
        unsafe extern "system" fn Advise<Identity: ICredentialProvider_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pcpe: *mut core::ffi::c_void, upadvisecontext: usize) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ICredentialProvider_Impl::Advise(this, core::mem::transmute_copy(&pcpe), core::mem::transmute_copy(&upadvisecontext)).into()
            }
        }
        unsafe extern "system" fn UnAdvise<Identity: ICredentialProvider_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ICredentialProvider_Impl::UnAdvise(this).into()
            }
        }
        unsafe extern "system" fn GetFieldDescriptorCount<Identity: ICredentialProvider_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pdwcount: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match ICredentialProvider_Impl::GetFieldDescriptorCount(this) {
                    Ok(ok__) => {
                        pdwcount.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetFieldDescriptorAt<Identity: ICredentialProvider_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwindex: u32, ppcpfd: *mut *mut CREDENTIAL_PROVIDER_FIELD_DESCRIPTOR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match ICredentialProvider_Impl::GetFieldDescriptorAt(this, core::mem::transmute_copy(&dwindex)) {
                    Ok(ok__) => {
                        ppcpfd.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetCredentialCount<Identity: ICredentialProvider_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pdwcount: *mut u32, pdwdefault: *mut u32, pbautologonwithdefault: *mut windows_core::BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                ICredentialProvider_Impl::GetCredentialCount(this, core::mem::transmute_copy(&pdwcount), core::mem::transmute_copy(&pdwdefault), core::mem::transmute_copy(&pbautologonwithdefault)).into()
            }
        }
        unsafe extern "system" fn GetCredentialAt<Identity: ICredentialProvider_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwindex: u32, ppcpc: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match ICredentialProvider_Impl::GetCredentialAt(this, core::mem::transmute_copy(&dwindex)) {
                    Ok(ok__) => {
                        ppcpc.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            SetUsageScenario: SetUsageScenario::<Identity, OFFSET>,
            SetSerialization: SetSerialization::<Identity, OFFSET>,
            Advise: Advise::<Identity, OFFSET>,
            UnAdvise: UnAdvise::<Identity, OFFSET>,
            GetFieldDescriptorCount: GetFieldDescriptorCount::<Identity, OFFSET>,
            GetFieldDescriptorAt: GetFieldDescriptorAt::<Identity, OFFSET>,
            GetCredentialCount: GetCredentialCount::<Identity, OFFSET>,
            GetCredentialAt: GetCredentialAt::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<ICredentialProvider as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for ICredentialProvider {}
windows_core::imp::define_interface!(ICredentialProviderCredential, ICredentialProviderCredential_Vtbl, 0x63913a93_40c1_481a_818d_4072ff8c70cc);
windows_core::imp::interface_hierarchy!(ICredentialProviderCredential, windows_core::IUnknown);
impl ICredentialProviderCredential {
    pub unsafe fn Advise<P0>(&self, pcpce: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICredentialProviderCredentialEvents>,
    {
        unsafe { (windows_core::Interface::vtable(self).Advise)(windows_core::Interface::as_raw(self), pcpce.param().abi()).ok() }
    }
    pub unsafe fn UnAdvise(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).UnAdvise)(windows_core::Interface::as_raw(self)).ok() }
    }
    pub unsafe fn SetSelected(&self) -> windows_core::Result<windows_core::BOOL> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).SetSelected)(windows_core::