//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;

use crate::*;

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsindexpath?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSIndexPath;
);

#[cfg(feature = "NSObject")]
extern_conformance!(
    unsafe impl NSCoding for NSIndexPath {}
);

#[cfg(feature = "NSObject")]
extern_conformance!(
    unsafe impl NSCopying for NSIndexPath {}
);

#[cfg(feature = "NSObject")]
unsafe impl CopyingHelper for NSIndexPath {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for NSIndexPath {}
);

#[cfg(feature = "NSObject")]
extern_conformance!(
    unsafe impl NSSecureCoding for NSIndexPath {}
);

impl NSIndexPath {
    extern_methods!(
        #[unsafe(method(indexPathWithIndex:))]
        #[unsafe(method_family = none)]
        pub fn indexPathWithIndex(index: NSUInteger) -> Retained<Self>;

        /// # Safety
        ///
        /// `indexes` must be a valid pointer or null.
        #[unsafe(method(indexPathWithIndexes:length:))]
        #[unsafe(method_family = none)]
        pub unsafe fn indexPathWithIndexes_length(
            indexes: *mut NSUInteger,
            length: NSUInteger,
        ) -> Retained<Self>;

        /// # Safety
        ///
        /// `indexes` must be a valid pointer or null.
        #[unsafe(method(initWithIndexes:length:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithIndexes_length(
            this: Allocated<Self>,
            indexes: *mut NSUInteger,
            length: NSUInteger,
        ) -> Retained<Self>;

        #[unsafe(method(initWithIndex:))]
        #[unsafe(method_family = init)]
        pub fn initWithIndex(this: Allocated<Self>, index: NSUInteger) -> Retained<Self>;

        #[unsafe(method(indexPathByAddingIndex:))]
        #[unsafe(method_family = none)]
        pub fn indexPathByAddingIndex(&self, index: NSUInteger) -> Retained<NSIndexPath>;

        #[unsafe(method(indexPathByRemovingLastIndex))]
        #[unsafe(method_family = none)]
        pub fn indexPathByRemovingLastIndex(&self) -> Retained<NSIndexPath>;

        #[unsafe(method(indexAtPosition:))]
        #[unsafe(method_family = none)]
        pub fn indexAtPosition(&self, position: NSUInteger) -> NSUInteger;

        #[unsafe(method(length))]
        #[unsafe(method_family = none)]
        pub fn length(&self) -> NSUInteger;

        #[cfg(feature = "NSRange")]
        /// Copies the indexes stored in this index path from the positions specified by positionRange into indexes.
        ///
        /// Parameter `indexes`: Buffer of at least as many NSUIntegers as specified by the length of positionRange. On return, this memory will hold the index path's indexes.
        ///
        /// Parameter `positionRange`: A range of valid positions within this index path.  If the location plus the length of positionRange is greater than the length of this index path, this method raises an NSRangeException.
        ///
        /// It is the developer’s responsibility to allocate the memory for the C array.
        ///
        /// # Safety
        ///
        /// `indexes` must be a valid pointer.
        #[unsafe(method(getIndexes:range:))]
        #[unsafe(method_family = none)]
        pub unsafe fn getIndexes_range(
            &self,
            indexes: NonNull<NSUInteger>,
            position_range: NSRange,
        );

        #[cfg(feature = "NSObjCRuntime")]
        #[unsafe(method(compare:))]
        #[unsafe(method_family = none)]
        pub fn compare(&self, other_object: &NSIndexPath) -> NSComparisonResult;
    );
}

/// Methods declared on superclass `NSObject`.
impl NSIndexPath {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub fn new() -> Retained<Self>;
    );
}

impl DefaultRetained for NSIndexPath {
    #[inline]
    fn default_retained() -> Retained<Self> {
        Self::new()
    }
}

/// NSDeprecated.
impl NSIndexPath {
    extern_methods!(
        /// This method is unsafe because it could potentially cause buffer overruns. You should use -getIndexes:range: instead.
        ///
        /// # Safety
        ///
        /// `indexes` must be a valid pointer.
        #[deprecated]
        #[unsafe(method(getIndexes:))]
        #[unsafe(method_family = none)]
        pub unsafe fn getIndexes(&self, indexes: NonNull<NSUInteger>);
    );
}
