# Announce: Rakudo Perl 6 compiler, Development Release #94 (“коледа”)

On behalf of the Rakudo development team, I’m proud to announce the
Christmas release (December 2015) of Rakudo Perl 6 #94 “коледа”. Rakudo
is an implementation of Perl 6 on the Moar Virtual Machine[^1] and the
Java Virtual Machine.

This is the Christmas release of Rakudo Perl 6. This version of the compiler
targets the v6.c “Christmas” specification of the Perl 6 language. The
Perl 6 community has been working toward this release over the last 15 years.
Together, we've built a language that:

+ Retains the core values of Perl: expressiveness, getting the job done,
  taking influences from natural language, and pushing the boundaries of
  language design
+ Has clean, modern syntax, rooted in familiar constructs but revisiting
  and revising the things that needed it
+ Is truly multi-paradigm, enabling elegant object-oriented, functional,
  procedural, and concurrent programming
+ Serves as a great glue language, allowing for easy calling of C/C++
  (using NativeCall) and staying compatible with Perl 5 (via Inline::Perl5).
+ Provides composable constructs for working with asynchronous data and
  parallel computations
+ Dramatically reforms and sets a new standard in regex syntax, which
  scales up to full grammars - powerful enough to parse Perl 6 itself
+ Has outstanding Unicode support, with strings working at grapheme level
+ Values lexical scoping and encapsulation, enabling easy refactoring
+ Is extensible through meta-object programming, user-defined operators,
  and traits

The tag for this release is “коледа”[^2], a slavic word for an ancient winter
festival that has been incorporated into Christmas. We hope you join us
in our celebration of getting our Christmas release shipped!

While we are extremely happy to ship an official Perl 6 release, this is not
the end of Rakudo’s development. We will continue to ship monthly releases,
which will continue to improve performance and our user’s experience. We’ll
also continue our work on the specification, with feedback from the community.

To be clear on that point, this Rakudo release is not considered the primary
deliverable for this Christmas; it is the language specification, known
as "roast" (Repository Of All Spec Tests), that is considered the primary
deliverable.  The specification tests that define this 6.c version[^3] of the
language are now frozen, and we hope it will be quite some time before we
feel obligated to define a 6.d (Diwali) version of the language.

This Rakudo release targets those tests (over 120 thousand of them), and passes
them all on at least some architectures when the moon is in the right phase.
But Rakudo itself is not frozen.  There is still plenty of work ahead for us to
improve speed, portability, and stability.  Do not expect the level of
perfection that you see in established products.  This is essentially a .0
release of a compiler.  We do not claim an absence of bugs or instabilities.
We do not claim the documentation is complete.  We do not claim portability to
many architectures.  We do not claim that all downstream software will work
correctly.  Think of it as a first kernel release, and now we get to build and
port various distributions based around that kernel.

What we do claim is that you now have a stable language specification, and
you can enjoy getting some stuff done with Perl 6 without us breaking it every
month—as long as you stick to the features that are actually tested in the
test suite, that is.  Please note that any “feature” you discover that is
not tested in the test suite is considered fair game for change without notice.

Have the appropriate amount of fun!

The tarball for this release is available from <http://rakudo.org/downloads/rakudo/>.

Please note: This announcement is not for the Rakudo Star
distribution[^4] --- it’s announcing a new release of the compiler
and the specification. For the latest Rakudo Star release, see
<http://rakudo.org/downloads/star/>. A Christmas-based version will
be available soon.

In addition to being our Christmas release, this is yet another
monthly compiler release; Some of the changes that are new in
release are outlined below:

New in 2015.12:
 + Fixed size and multi-dimensional typed and native arrays
 + Greatly overhauled module loading and installation, including handling
   precompilation at module installation time in Rakudo
 + while/until loops can now return lists of values
 + We now catch many more kinds of "Useless use of X in sink context"
 + A number of convenient Unicode equivalents were introduced
 + Superscripts can now be used for integer powers
 + Non-digit unicode characters with a numeric value (½ and such) can now be
   used for that numeric value
 + There is a new "approximately equal" operator
 + Add support for USAGE argument help
 + Provide tau constant (also: τ)
 + Can now use channels with supply/react/whenever
 + Bool is now a proper enum
 + Supply/Supplier improvements
 + Use of EVAL now requires a declaration of 'use MONKEY-SEE-NO-EVAL'
 + Make pack and unpack experimental
 + Dynamic variables are now visible inside start { ... } blocks
 + Autoincrements on native ints are now faster than on Int
 + The ~~ operator can now chain with other comparisons in many circumstances
 + Various numeric operations now return overflow/underflow failures instead
   of wrong value
 + The :ss, :ii, and :mm options to s/// now all work together

This is only a partial list of the changes in this release. For a more
detailed list, see “docs/ChangeLog”.

The development team thanks all of our contributors and sponsors for
making Rakudo Perl possible, as well as those people who worked on
the design docs, the Perl 6 test suite, MoarVM and the specification.
Additionally, the Pugs, Parrot, and Niecza projects were all instrumental
with their contributions to the specification and the community.

The following people contributed to the development of the Christmas release;
We’ve gone back through the logs of all the various projects.  Thanks to
everyone who has worked to make this release happen over the past 15 years. We
would also like to thank everyone who submitted bug reports or dropped in on
the various forums to discuss things.  Finally, we’d like to extend a special
thanks to everyone who we accidentally left out of this list.

Gisle Aas, abcxyzp, Chuck Adams, Colin Paul Adams, Rod Adams,
C.J. Adams-Collier, David H. Adler, Chirag Agrawal,
Amir E. Aharoni, Bilal Akhtar, Julian Albo, Alekssasho,
alexghacker, Paco Alguacil, Brandon S Allbery, Geir Amdal,
Markus Amsler, Paul C. Anagnostopoulos, Nikolay Ananiev,
anatolyv, andras, Saleem Ansari, Joji Antony, Tomoki Aonuma,
Syed Uzair Aqeel, arathorn, Arcterus, Kodi Arfer,
Daniel Arbelo Arrocha, ash, Ted Ashton, Arnaud Assad, atroxaper,
Ori Avtalion אורי אבטליון, Auzon, Greg Bacon,
Ivan Baidakou, Alex Balhatchet, Szabó, Balázs, Amir Livine Bar-On
עמיר ליבנה בר-און, Luca Barbato, Mattia Barbon,
Ann Barcomb, Christian Bartolomäus, Alex "Skud" Bayley,
bcmb, Jody Belka, Shachaf Ben-Kiki, Andrei Benea, benedikth,
Zev Benjamin, benmorrow, Kevan Benson, Martin Berends, Anton Berezin,
Arthur Bergman, Anders Nor Berle, bestian, Peter Bevan, Mark Biggar,
Carlin Bingham, Ævar Arnfjörð Bjarmason, J. David Blackstone,
Ronald Blaschke, Ingo Blechschmidt, bloonix, blwood, Kristof Bogaerts,
Dan Bolser, Конрад Боровски, Christopher Bottoms,
Gonéri Le Bouder, Jos Boumans, Brad Bowman, Matt Boyle, bpetering,
H.Merijn Brand, Terrence Brannon, Gwern Branwen, Stig Brautaset,
Herbert "lichtkind" Breunung, bri, brian_d_foy, Fernando Brito,
Geoffrey Broadwell, Leon Brocard, Benjamin Brodfuehrer, Samuel Bronson,
Dan Brook, Nathan C. Brown, Roger Browne, Philippe Bruhat (BooK),
David Brunton, Corwin Brust, Klaus Brüssel, Lucas Buchala,
buchetc, Christoph Buchetmann, Norbert Buchmuller, Buddha Buck,
Alexandre Buisse, Tim Bunce, Bryan Burgers, Sean M. Burke,
Matthew Byng-Maddick, András Bártházi, Jürgen Bömmels, Caelum,
Aldo Calpini, Edward Cant, David Cantrell, Carlin, Michael Cartmell,
Hezekiah Carty, Nuno 'smash' Carvalho, Marcelo Serra Castilhos,
Piers Cawley, cdavaz, cdpruden, Gianni Ceccarelli, cfourier,
Marc Chantreux, Mitchell N Charity, Oliver Charles, Vasily Chekalkin,
Yuan-Chen Cheng 鄭原真, Daniel Chetlin, Hsin-Chan Chien 簡信昌,
N. Hao Ching, Joshua Choi, Elizabeth Cholet, David Christensen,
chuck, cjeris, Nicholas Clark, Steve Clark, Jeff Clites,
cmarcelo, cmeyer, Paul Cochrane, Daniel Colascione, Jason Cole,
Will "Coke" Coleda, Sylvain Colinet, cono, Tim Conrow, Géraud Continsouzas,
Damian Conway, Neil Conway, Stuart Cook, David Corbin,
Deven T. Corzine, cosmicnet, Timothy Covell, Beau E. Cox,
Simon Cozens, Philip Crow, cspenser, Franck Cuny, Tyler Curtis,
David Czech, Daenyth, Dagur, Ritz Daniel, darkwolf, Chris Davaz,
David Warring, Justin DeVuyst, Daniel Dehennin, Akim Demaille,
Detonite, Lars "daxim" Dieckow 迪拉斯,
Matt Diephouse, Bob Diertens, Wendy "woolfy" van Dijk, Jeffrey Dik,
John M. Dlugosz, dimid, diotalevi, Hans van Dok, Chris Dolan,
Mark Dominus, Bryan Donlan, Andy Dougherty, Dave Doyle,
drKreso, dr_df0, dudley, Jonathan Scott Duff, dug, Lee Duhem,
Darren Duncan, Andrew Egeler, Havard Eidnes, Nelson Elhage,
Fitz Elliott, Alex Elsayed, Jay Emerson, Aankhola Encorporated,
ennio, Enveigler, Jon Ericson, Shae Matijs Erisson, Eryq,
Mike Eve, Pat Eyler, Aaron Faanes, Kevin Falcone, David Farrell,
Angel Faus, Jason Felds, Paul Fenwick, Jose Rodrigo Fernandez,
Nelson Ferraz, Adriano Ferreira, João Fernando Ferreira,
Chris Fields, Caio Marcelo de Oliveira Filho, Steve Fink,
Shlomi "rindolf" Fish שלומי פיש, Mark Leighton Fisher,
Scott Fitzenrider, Dudley Flanders, Richard Foley, Vincent Foley,
Julian Fondren, Ruben Fonseca, David Formosa, Karl Forner,
Solomon Foster, Chaddaï Fouché, Lloyd Fournier, Michael Fowler,
Matt Fowles, franck, Austin Frank, Carl Franks,
Kent Fredric, Chaim Frenkel, Piotr Fusik, gabriele,
John Gabriele, Christoph Gärtner, Martin von Gagern,
Felix Gallo, Salvador Ortiz Garcia, Rafaël Garcia-Suarez,
Joshua Gatcomb, Jerry Gay, gcomnz, Jonathan Gentle, iVAN Georgiev,
Brian Gernhardt, Bram Geron, Alessandro Ghedini, Imran Ghory,
Peter Gibbs, Tanton Gibbs, Brad Gilbert (b2gills), Karl Glazebrook,
Nick Glencross, Mark Glines, Flávio S. Glock, Jason Gloudon,
Simon Glover, gnuvince, Garrett Goebel, Jeffrey Goff,
Mikhael Goikhman, Benjamin Goldberg, Arcady Goldmints-Orlov,
Dimitry Golubovsky, Gerard Goossen, Goplat, Alex Gough, Léo Grange,
Chad "Exodist" Granum, Kenneth A Graves, Bruce Gray, Nathan Gray,
Mark Grimes, Lucien Grondin, Rolf Grossmann, David Grove,
Marcel Grünauer, Daniel Grunblatt, Uri Guttman, gwern, Swaroop C H,
Richard Hainsworth, Roger Hale, John "ab5tract" Haltiwanger,
Nigel Hamilton, Eric Hanchrow, Sterling Hanenkamp, Ask Bjørn Hansen,
Christian "chansen" Hansen, Eirik Berg Hanssen, Samuel Harrington,
Trey Harris, John Harrison, Carsten Hartenfels, Richard Hartmann,
Kyle Hasselbacher, Austin Hastings, Carl Hayter, Florian Helmberger,
Gordon Henriksen, Felix Herrmann, Peter Heslin, Fred Heutte,
Jarkko Hietaniemi, Michael H. Hind, Joshua Hoblitt, Zack Hobson,
Eric Hodges, Rob Hoelz, Masahiro Honma, Lyle Hopkins, JD Horelick,
Jeff Horwitz, Chris Hostetter, Laurens Van Houtven, Jeremy Howard,
Yiyi Hu 鹄驿懿, Benedikt Huber, Brad Hughes, Sterling Hughes,
Tom Hughes, Tristan Hume, Donald Hunter, Douglas Hunter,
Juan Francisco Cantero Hurtado, Kay-Uwe 'kiwi' Hüll, Ran Eliam,
Alin Iacob, Ibotty, ibrown, ihrd, Roland Illing, Jan Ingvoldstad,
Joshua Isom, isop, Ivan_A_Frey, ivanoff, Akash Manohar J, jafelds,
Robert G. Jakabosky, jamesrom, S. A. Janet, jani, Heiko Jansen,
Stuart Jansen, Jarrod, Jedai, Chris Jepeway, Chris Jeris,
Dagur Valberg Johannsson, Erik Johansen, Paul Johnson, johnspurr,
Isaac Jones, Norman Nunley, Jr, Yoshikuni Jujo, Brian S. Julin,
Brian S. Julin, Josh Juran, Michal Jurosz, David KOENIG,
Prakash Kailasa, Shoichi Kaji, Daniel Kang, Isis Kang,
Chia-Liang Kao 高嘉良, Dmitry Karasik, Luben Karavelov,
Amir Karger, Offer Kaye, Bruce Keeler, James E Keenan, Cole Keirsey,
Adam Kennedy, Matt Kennedy, Shane Kerr, khairul, Mikhail Khorkov,
Krzysztof Kielak, Andres Kievsky, Daehyub Kim, Rob Kinyon,
Oleg Kiselyov, OOLLEY kj, Martin Kjeldsen, Thomas "domm" Klausner,
Zohar "lumi" Kelrich זהר קלריך/卡卓哈, Damian Miles Knopp,
Dan Kogai 小飼弾, Yuval "nothingmuch" Kogman יובל קוג'מן,
Tomasz Konojacki, Vadim Konovalov, Nick Kostirya, Matt Kraai,
Thomas Kratz, Adrian Kreher, John van Krieken, Matthias Krull,
Bradley M. Kuhn, Bob Kuo, Colin Kuskie, Kamil Kułaga,
Sage LaTorra, Brent Laabs, laben, Johannes Laire, Markus Laire,
Fayland Lam 林道, Mike Lambert, lanny, Leo Lapworth,
last.of.the.careless.men, Bart Lateur, Jia-Hong Lee,
Lola Lee, Jonathan Leffler, Tobias Leich, lembark,
Mark Lentczner, Moritz A Lenz, Jean-Louis Leroy, Andy Lester,
Jonathan "Duke" Leto, Vladimir Lettiev, Mike Li 李曉光,
Stefan Lidman, Yung-Chung Lin 林永忠, Glenn Linderman,
Vladimir Lipsky, Zach Lipton, Stevan Little, Kang-Min Liu 劉康民,
Skip Livingston, David M. Lloyd, Daniel Lo, Peter Lobsinger,
Andres Löh, Nick Logan, Eric Lubow, Nolan Lum, Peter Lunicks,
LylePerl, Ian Lynagh, lysdexsik, Kiran Kumar M., Jerry MacClure,
Noel Maddy, Christopher J. Madsen, Abhijit A. Mahabal,
Max Maischein, Peter Makholm, Ujwal Reddy Malipeddi, malon,
Christopher Malon, Dagfinn Ilmari Mannsåker, Michael Maraist,
Roie Marianer רועי מריאנר, markmont, Simon Marlow,
martin, Paolo Martini, Ilya Martynov, Jaume Martí, James Mastros,
Michael J. Mathews, Vyacheslav Matjukhin, Tokuhiro Matsuno, mattc,
Mike Mattie, Elizabeth "lizmat" Mattijsen, Вячеслав Матюхин,
Markus Mayr, Josh McAdams, Martin McCarthy, Mark McConnell,
Steven McDougall, John McNamara, Scott McWhirter, mdinger,
Olivier "dolmen" Mengué, Kevin Metcalf, Patrick R. Michaud, mimir,
mjreed, Tom Moertel, Michael Mol, Paolo Molaro, Shawn M Moore,
Brandon Michael Moore, Alexander Moquin, Ion Alexandru Morega,
Dino Morelli, Kolia Morev, Zach Morgan, mr_ank, Alex Munroe, muraiki,
Paweł Murias, mvuets, Steve Mynott, mzedeler, Carl Mäsak, naesten,
Tim Nelson, Ailin Nemui, Ingy döt Net 應吉大聶, David Nicol,
Faye Niemeyer, Nigelsandever, Karl Rune Nilsen, Salve J. Nilsen,
Per Christian Nodtvedt, Ben Noordhuis, Paweł Nowak,
Norman Nunley, Tony O'Dell, יהושע "שי" אוחיון,
Clayton O'Neill, Stefan O'Rear, Sean O'Rourke, Matt Oates,
Tony Olekshy, Martin Olsen, Dmitriy Olshevskiy, Dave Olszewski,
Nelo Onyiah, William Orr, Jon Orwant, Andrei Osipov, Christoph Otto,
Pawel Pabian, Walter Pallestrong, Luke Palmer, Bartłomiej Palmowski,
Pancake, Paolo, Marton Papp, Andrew Parker, Roman M. Parparov,
Anthony Parsons, Mike Pastore, Nova Patch, Timo Paulssen, Tony Payne,
Stéphane "cognominal" Payrard, Slava Pechenin, Gael Pegliasco,
Stéphane Peiry, Felipe Pena, Nayden Pendov, Wenzel P. P. Peppmeyer,
François Perrad, Markus Peter, Ben Petering, Steve Peters,
Tim Peterson, Ronny Pfannschmidt, Clinton A. Pierce, Jerrad Pierce,
Thilo Planz, plunix, pmakholm, Curtis 'Ovid' Poe, Gerd Pokorra,
Peter Polacik, Flavio Poletti, Kevin Polulak, John Porter,
Ryan W. Porter, Stephen P. Potter, Philip Potter, Adam Preble,
premshree, Klāvs Priedītis, Adam Prime, Richard Proctor,
Christopher Pruden, Kevin Puetz, Gregor N. Purdy, purl, Hongwen Qiu,
Jerome Quelin, quester, Gerhard R., Peter Rabbitson, Florian Ragwitz,
raiph, Matt Rajca, Marcus Ramberg, Claudio Ramirez, Prog Rammer,
Allison Randal, David Ranvig, Lars Balker Rasmussen, Curtis Rawls,
raydiak, Robin Redeker, Ted Reed, Jens Rehsack, Charles Reiss,
Gabriele Renzi, Kenneth C. Rich, Jason Richmond, Ryan Richter,
Sebastian Riedel, Dennis Rieks, Jens Rieks, Lanny Ripple,
John Rizzo, rkhill, Andrew Robbins, Amos Robinson, Jonathan Rockway,
Stefano Rodighiero, Andrew Rodland, Lindolfo Rodrigues, Bob Rogers,
Dave Rolsky, David Romano, ron, Eric J. Roode,
Garret Rooney, Garrett Rooney, David Ross, Andreas Rottmann,
Brent Royal-Gordon, Shmarya Rubenstein, Sam Ruby, Simon Ruderich,
Daniel Ruoso, Jake Russo, ruz, Joseph Ryan, Gilbert Röhrbein,
Sam S, s1n, sahadev, Patrick Abi Salloum, salty_horse,
Chip Salzenberg, Shrivatsan Sampathkumar, Igor Rafael Sanchez-Puls,
Hugo van der Sanden, Thomas Sandlaß, Yun SangHo, sanug,
Siddhant Saraf, Sasho, Andrew Savige, John Saylor, Matt Schallert,
Bernhard Schmalhofer, Arthur Axel Schmidt, Ronald Schmidt,
Michael Schroeder, Steven Schubiger, Steve "thundergnat" Schulze,
Andreas Schwab, Randal L. Schwartz, Pepe Schwarz, Frederik Schwarzer,
Calvin Schwenzfeier, Michael G. Schwern, Steffen Schwigon,
Tom Scola, Ariel Scolnicov, Michael Scott, Peter Scott,
Rick Scott, Stefan Seifert, Austin Seipp, Mark Senn, Filip Sergot,
Seth Gold (Sgeo), William Shallum, Kris Shannon, shenyute,
Aaron Sherman, Mark Shoulson, Ryan Siemens, Ricardo Signes,
Hinrik Örn Sigurðsson, Jonathan Sillito, Miroslav Silovic,
Steve Simmons, Alberto Manuel Brandao Simoes, John Siracusa,
Arne Skjærholt, Barrie Slaymaker, Radek Slupik, Mike Small,
Benjamin Smith, Melvin Smith, Tim Smith, Adrian White aka
snarkyboojum, Richard Soderberg, SolidState, Vishal Soni, Syloke Soong,
Shawn Sorichetti, Tadeusz Sośnierz, sue spence, Cory Spencer,
Robert Spier, Michael Stapelberg, Edwin Steiner, stephenpollei,
Michael Stevens, Don Stewart, Radu Stoica, Klaas-Jan Stol,
Alek Storm, David Storrs, Mark Stosberg, Jonathan Stowe,
Cosimo Streppone, Jonathan Strickland, Pascal Stumpf, Su-Shee,
Sue, Laye Suen, Dan Sugalski, Mark Summerfield, Simon Sun,
Cheng-Lung Sung 宋政隆, Sunnavy, Samuel Sutch, svatsan,
svn, Andrew Sweger, sygi, Sebastian Sylvan, Gábor Szabó,
Bálint Szilakszi, Marek Šuppa, TOGoS, Arvindh Rajesh Tamilmani,
Audrey Tang 唐鳳, Bestian Tang 唐宗浩, Adrian Taylor,
Jesse Taylor, Philip Taylor, Kevin Tew, the_dormant, Marcus Thiesen,
Adam Thomason, Richard Tibbetts, Carey Tilden, Marcel Timmerman,
Leon Timmermans, tkob, John Tobey, Frank Tobin, Bennett Todd,
Graham Todd, Leopold Tötsch, Daniel Toma, Nathan Torkington,
Timothy Totten, John J. Trammell, Matt S. Trout, Nat Tuck,
Adam Turoff, Ben Tyler, ujwal, Bernd Ulmann, Reini Urban,
parrot user, uzair, VZ, Ilmari Vacklin, vamped, Wim Vanderbauwhede,
vendethiel, David Vergin, Ted Vessenes, Sam Vilain, Cédric Vincent,
Jesse Vincent, Jos Visser, John van Vlaanderen, vmax, Jeremy Voorhis,
Martin Vorländer, Johan Vromans, Maxim Vuets, Juerd Waalboer,
Mariano Wahlmann, Kevin Walker, Gloria Wall, Larry Wall, Lewis Wall,
Michal J Wallace, John Paul Wallington, walter, Matthew Walton,
Ting Wang, Xinyuan Wang, Andy Wardley, Bryan C. Warnock,
wayland, Stephen Weeks, Zhen-Bang Wei, Nick Wellnhofer,
Shu-Chun Weng, Danny Werner, Brian Wheeler, David E. Wheeler,
Dave Whipp, Adrian White, Andrew Whitworth, Bart Wiegmans,
Nathan Wiger, Brock Wilcox, Edwin Wiles, Bob Wilkinson,
Chris 'BinGOs' Williams, Greg Williams, Josh Wilmes, Matthew Wilson,
Ashley Winters, Brian Wisti, Dave Woldrich, Helmut Wollmersdorfer,
Kevin J. Woolley, Jonathan Worthington, Kuang-Che Wu 吳光哲,
xenu, Liang-Qi Xie 謝良奇, Xtreak, Gaal Yahas גל יחס,
Thomas Yandell, Alvis Yardley, Thomas Yeh 葉志宏, Natan Yellin,
yiyihu, Matt Youell, Tony Young, Shen, Yu-Teh, Ilya Zakharevich,
Ruslan Zakirov, Ahmad M. Zawawi, Michael A. D. Zedeler, zengargoyle,
zeriod, Agent Zhang 章亦春, Jimmy Zhuo, Ziggy6, Rob Zinkov,
Zoffix Znet

If you would like to contribute or find out more information, visit
<http://perl6.org>, <http://rakudo.org/how-to-help>, ask on the
<perl6-compiler@perl.org> mailing list, or ask on IRC #perl6 on freenode.

The next release of Rakudo (#95), is tentatively scheduled for 16 January
2016. A list of the other planned release dates is available in the
“docs/release_guide.pod” file.

The development team appreciates feedback! If you’re using Rakudo, do
get back to us. Questions, comments, suggestions for improvements, cool
discoveries, incredible hacks, or any other feedback -- get in touch with
us through (the above-mentioned) mailing list or IRC channel. Enjoy!

[^1]: See <http://moarvm.org/>

[^2]: See <https://en.wikipedia.org/wiki/Koliada>

[^3]: See <https://github.com/perl6/roast/tree/6.c>

[^4]: What’s the difference between the Rakudo compiler and the Rakudo
Star distribution?

The Rakudo compiler is a compiler for the Perl 6 language.
Not much more.

The Rakudo Star distribution is the Rakudo compiler plus a selection
of useful Perl 6 modules, a module installer, the most recent
incarnation of the “Using Perl 6” book, and other software that can
be used with the Rakudo compiler to enhance its utility. Rakudo Star
is meant for early adopters who wish to explore what’s possible with
Rakudo Perl 6 and provide feedback on what works, what doesn’t, and
what else they would like to see included in the distribution.
