# Claimant Model Render Tool

:warning: This is a prototype and has no guarantees of stability!

This tooling takes a definition of a Claimant Model in yaml format, and renders it in ways that are useful for evaluating the design.
Once the authors are happy with the design, these rendering artefacts can be used as documentation for the project.

The markdown snippets that are generated will look at their best when rendered in GitHub.

## Prerequisites & Assumptions

This tooling assumes that you are using the Claimant Model as a way of describing participants in an ecosystem around logs.

Users are required to have an understanding of the roles in the [Claimant Model](../../../CoreModel.md) before starting to populate a custom yaml file for input into this tool.

## Usage

Start by copying the [example: CT Claimant Model](./internal/models/ct/model.yaml) into your working directory.
This model is the simplest form as it has a single claim. If you know that your model has multiple claims with different verifiers, then starting with [example: Armory Drive Claimant Model](./internal/models/armorydrive/model.yaml) is a better call.

The first step is to turn this domain-level Claimant Model into a "full" model, i.e. one that also includes the log and its verifiers.

```bash
go run ./docs/claimantmodel/experimental/cmd/render --domain_model_file /tmp/cmfun/model.yaml
```

This will output some snippets to stdout. If you'd written the input file yourself, this would be a good opportunity to check that the output looked reasonable and to iterate on the input yaml file as needed.

Part of the output will be a complete model. Copy this and save it into another file in your working directory called `full.yaml`. If you reviewed the output you'll have seen that there are a few `TODO` entries with some guesses in this output, specifically when defining the actors for the Log Claimant and Arbiter. The Claimant and Arbiter from the base model are suggested as defaults, but it could be that a new actor (that doesn't participate in the base model) is introduced to perform either or both of these roles.

Edit the file to resolve the `TODO` entries, and then run the tooling again against this file:

```bash
go run ./docs/claimantmodel/experimental/cmd/render --full_model_file /tmp/cmfun/full.yaml
```

The rendered output will include markdown snippets for the full claimant model, and a mermaid sequence diagram.

## Known Issues

A non-exhaustive list of issues or limiting assumptions:
- the sequence diagram assumes that an offline proof bundle will be generated by the Claimant and distributed to the Believer; this is a best practice, but somewhat rare. Supporting other flows should be possible.
- the sequence diagram doesn't show anyone relying on the output of the witness checks; this should be included because that's the whole point of the witness countersigning checkpoints
- the tool doesn't support SCTs/promises

