RabbitMQ `3.11.9` is a maintenance release in the `3.11.x` [release series](https://www.rabbitmq.com/versions.html).

Please refer to the upgrade section from [v3.11.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.11.0)
if upgrading from a version prior to 3.11.0.

This release requires Erlang 25.
[RabbitMQ and Erlang/OTP Compatibility Matrix](https://www.rabbitmq.com/which-erlang.html) has more details on
Erlang version requirements for RabbitMQ.


### Minimum Supported Erlang Version

As of 3.11.0, RabbitMQ requires Erlang 25. Nodes **will fail to start** on older Erlang releases.

Erlang 25 as our new baseline means much improved performance on ARM64 architectures, [profiling with flame graphs](https://blog.rabbitmq.com/posts/2022/05/flame-graphs/)
across all architectures, and the most recent TLS 1.3 implementation available to all RabbitMQ 3.11 users.


## Changes Worth Mentioning

Release notes can be found on GitHub at [rabbitmq-server/release-notes](https://github.com/rabbitmq/rabbitmq-server/tree/v3.11.x/release-notes).

### Core Server

#### Bug Fixes

 * Stream delivery using [RabbitMQ Stream protocol](https://github.com/rabbitmq/rabbitmq-server/blob/v3.11.x/deps/rabbitmq_stream/docs/PROTOCOL.adoc) v2 could fail to start in some cases.

   GitHub issue: [#7118](https://github.com/rabbitmq/rabbitmq-server/pull/7118)

 * Nodes could run into an exception with certain publishers that used QPid for client library.

   GitHub issue: [#7119](https://github.com/rabbitmq/rabbitmq-server/issues/7119)

 * When discovering feature flags across the cluster, default stability level is now `experimental` and not `stable`.

   GitHub issue: [#7156](https://github.com/rabbitmq/rabbitmq-server/pull/7156)

 * Reset and manually added nodes could start receiving stream replica data before its database was initialized,
   confusing all code paths that expected a blank node state.

   GitHub issue: [#7222](https://github.com/rabbitmq/rabbitmq-server/pull/7222)

 * Fixed a minor issue with feature flag log message formatting.

   GitHub issue: [#7233](https://github.com/rabbitmq/rabbitmq-server/pull/7233)

#### Enhancements

 * Improved support for the AMQP 1.0 message format (used internally by streams), in particular, when original message
   was published using AMQP 1.0.

   GitHub issue: [#7001](https://github.com/rabbitmq/rabbitmq-server/pull/7001)


### CLI Tools

#### Features

 * `rabbitmqctl set_permissions_globally` is a new command that sets up user permissions in all existing virtual hosts.

   GitHub issue: [#1000](https://github.com/rabbitmq/rabbitmq-server/issues/1000)

 * `rabbitmq-diagnostics cluster_status` now lists how many CPU cores are available to individual nodes, plus a total.

   GitHub issue: [#7135](https://github.com/rabbitmq/rabbitmq-server/pull/7135)


### Management Plugin

#### Bug Fixes

 * Limits tab failed to load when there were no limits configured.

   GitHub issue: [#7142](https://github.com/rabbitmq/rabbitmq-server/issues/7142)

#### Enhancements

 * It is now possible to disable operator policy modifications. This can be necessary in
   RabbitMQ-as-a-Service environments.

   Contributed by @illotum (AWS).

   GitHub issue: [#7131](https://github.com/rabbitmq/rabbitmq-server/issues/7131)


### AMQP 1.0 Plugin

#### Enhancements

 * Support for [OAuth 2 authentication and authorization backends](https://rabbitmq.com/oauth2.html).

   GitHub issue: [#6931](https://github.com/rabbitmq/rabbitmq-server/pull/6931)


### MQTT Plugin

#### Bug Fixes

 * MQTT nodes did not correctly remove client IDs for clients connected to a node that was in the process of
   being removed from the cluster.

   GitHub issue: [#7162](https://github.com/rabbitmq/rabbitmq-server/pull/7162)


### OAuth 2 Plugin

#### Bug Fixes

 * `auth_oauth2.additional_scopes_key` had no effect.

   Contributed by @brunomedeirosdedalus.

   GitHub issue: [#7190](https://github.com/rabbitmq/rabbitmq-server/pull/7190)


### LDAP Plugin

#### Bug Fixes

 * Due to a `$` sign escaping differences between Make and Bazel (the newly adopted build tool),
   default value of of `user_dn_pattern` setting was incorrect (had an extra `$`).

   GitHub issue: [#7161](https://github.com/rabbitmq/rabbitmq-server/issues/7161)


## Dependency Upgrades

None in this release.


## Source Code Archives

To obtain source code of the entire distribution, please download the archive named `rabbitmq-server-3.11.9.tar.xz`
instead of the source tarball produced by GitHub.
