# Contributing to GNS3

We welcome contributions and bugs reports from everyone.
We are friendly so don't be afraid to ask questions.

## Bug reports

Before reporting an issue:
* check our website over at https://gns3.com
* check if an issue already exists on https://github.com/GNS3/gns3-gui
* check if an issue already exists on https://github.com/GNS3/gns3-server

Please post on our community website if you are unsure you found a bug,
you will get faster support and be able to exchange with more users.

If you are unsure which project you should create an issue for, just do 
it on https://github.com/GNS3/gns3-gui we will take care of the triage.

For bugs specific to the GNS3 VM, please report on https://github.com/GNS3/gns3-vm

## Security issues

For security issues please keep it private and send an email to developers@gns3.net

## Asking for new features

The best is to start a discussion on the community website in order to get feedback
from the whole community.


## Contributing code

We welcome code contribution from everyone including beginners.
Don't be afraid to submit a half finished or mediocre contribution and we will help you.

Don't hesitate to share your plans before starting working on a contribution, we can help
you to find the best approach.

### Contributors License Agreements

We at GNS3 are eager to work with you. For small changes — little bugfixes, correcting typos, and the like — please just submit pull requests to any of our projects. For larger changes, though, we have to ask you to jump through a little hoop.

In particular, in order for us to accept any major patches from you, you will have to electronically sign a statement that indicates two things:

- You are willingly licensing your contributions under the terms of the open source license of the project that you’re contributing to.
- You are legally able to license your contributions as stated.

The reason we do this is to ensure, to the extent possible, that we don’t “taint” the projects we manage with contributions that turn out to be improper. This protects everyone who wants to use the projects, including you!

More information there: https://github.com/GNS3/cla

### Pull requests

Creating a pull request is the easiest way to contribute code. Do not hesitate to create one early when  contributing for new feature in order to get our feedback.
