--- ./arpspoof.c.orig	2001-03-15 09:32:58.000000000 +0100
+++ ./arpspoof.c	2014-07-22 13:21:17.000000000 +0200
@@ -13,7 +13,10 @@
 
 #include <sys/types.h>
 #include <sys/param.h>
+#include <sys/socket.h>
+#include <net/ethernet.h>
 #include <netinet/in.h>
+#include <netinet/if_ether.h>
 
 #include <stdio.h>
 #include <string.h>
@@ -22,12 +25,12 @@
 #include <libnet.h>
 #include <pcap.h>
 
+//extern char *ether_ntoa(struct ether_addr *);
+
 #include "arp.h"
 #include "version.h"
 
-extern char *ether_ntoa(struct ether_addr *);
-
-static struct libnet_link_int *llif;
+static libnet_t *l;
 static struct ether_addr spoof_mac, target_mac;
 static in_addr_t spoof_ip, target_ip;
 static char *intf;
@@ -41,47 +44,49 @@
 }
 
 static int
-arp_send(struct libnet_link_int *llif, char *dev,
-	 int op, u_char *sha, in_addr_t spa, u_char *tha, in_addr_t tpa)
+arp_send(libnet_t *l, int op, u_int8_t *sha,
+	 in_addr_t spa, u_int8_t *tha, in_addr_t tpa)
 {
-	char ebuf[128];
-	u_char pkt[60];
-	
+	int retval;
+
 	if (sha == NULL &&
-	    (sha = (u_char *)libnet_get_hwaddr(llif, dev, ebuf)) == NULL) {
+	    (sha = (u_int8_t *)libnet_get_hwaddr(l)) == NULL) {
 		return (-1);
 	}
 	if (spa == 0) {
-		if ((spa = libnet_get_ipaddr(llif, dev, ebuf)) == 0)
+		if ((spa = libnet_get_ipaddr4(l)) == -1)
 			return (-1);
-		spa = htonl(spa); /* XXX */
 	}
 	if (tha == NULL)
 		tha = "\xff\xff\xff\xff\xff\xff";
 	
-	libnet_build_ethernet(tha, sha, ETHERTYPE_ARP, NULL, 0, pkt);
+	libnet_autobuild_arp(op, sha, (u_int8_t *)&spa,
+			     tha, (u_int8_t *)&tpa, l);
+	libnet_build_ethernet(tha, sha, ETHERTYPE_ARP, NULL, 0, l, 0);
 	
-	libnet_build_arp(ARPHRD_ETHER, ETHERTYPE_IP, ETHER_ADDR_LEN, 4,
-			 op, sha, (u_char *)&spa, tha, (u_char *)&tpa,
-			 NULL, 0, pkt + ETH_H);
-
 	fprintf(stderr, "%s ",
 		ether_ntoa((struct ether_addr *)sha));
 
 	if (op == ARPOP_REQUEST) {
 		fprintf(stderr, "%s 0806 42: arp who-has %s tell %s\n",
 			ether_ntoa((struct ether_addr *)tha),
-			libnet_host_lookup(tpa, 0),
-			libnet_host_lookup(spa, 0));
+			libnet_addr2name4(tpa, LIBNET_DONT_RESOLVE),
+			libnet_addr2name4(spa, LIBNET_DONT_RESOLVE));
 	}
 	else {
 		fprintf(stderr, "%s 0806 42: arp reply %s is-at ",
 			ether_ntoa((struct ether_addr *)tha),
-			libnet_host_lookup(spa, 0));
+			libnet_addr2name4(spa, LIBNET_DONT_RESOLVE));
 		fprintf(stderr, "%s\n",
 			ether_ntoa((struct ether_addr *)sha));
 	}
-	return (libnet_write_link_layer(llif, dev, pkt, sizeof(pkt)) == sizeof(pkt));
+	retval = libnet_write(l);
+	if (retval)
+		fprintf(stderr, "%s", libnet_geterror(l));
+
+	libnet_clear_packet(l);
+
+	return retval;
 }
 
 #ifdef __linux__
@@ -119,7 +124,7 @@
 		/* XXX - force the kernel to arp. feh. */
 		arp_force(ip);
 #else
-		arp_send(llif, intf, ARPOP_REQUEST, NULL, 0, NULL, ip);
+		arp_send(l, ARPOP_REQUEST, NULL, 0, NULL, ip);
 #endif
 		sleep(1);
 	}
@@ -136,9 +141,9 @@
 	if (arp_find(spoof_ip, &spoof_mac)) {
 		for (i = 0; i < 3; i++) {
 			/* XXX - on BSD, requires ETHERSPOOF kernel. */
-			arp_send(llif, intf, ARPOP_REPLY,
-				 (u_char *)&spoof_mac, spoof_ip,
-				 (target_ip ? (u_char *)&target_mac : NULL),
+			arp_send(l, ARPOP_REPLY,
+				 (u_int8_t *)&spoof_mac, spoof_ip,
+				 (target_ip ? (u_int8_t *)&target_mac : NULL),
 				 target_ip);
 			sleep(1);
 		}
@@ -151,7 +156,8 @@
 {
 	extern char *optarg;
 	extern int optind;
-	char ebuf[PCAP_ERRBUF_SIZE];
+	char pcap_ebuf[PCAP_ERRBUF_SIZE];
+	char libnet_ebuf[LIBNET_ERRBUF_SIZE];
 	int c;
 	
 	intf = NULL;
@@ -163,7 +169,7 @@
 			intf = optarg;
 			break;
 		case 't':
-			if ((target_ip = libnet_name_resolve(optarg, 1)) == -1)
+			if ((target_ip = libnet_name2addr4(l, optarg, LIBNET_RESOLVE)) == -1)
 				usage();
 			break;
 		default:
@@ -176,26 +182,26 @@
 	if (argc != 1)
 		usage();
 	
-	if ((spoof_ip = libnet_name_resolve(argv[0], 1)) == -1)
+	if ((spoof_ip = libnet_name2addr4(l, argv[0], LIBNET_RESOLVE)) == -1)
 		usage();
 	
-	if (intf == NULL && (intf = pcap_lookupdev(ebuf)) == NULL)
-		errx(1, "%s", ebuf);
+	if (intf == NULL && (intf = pcap_lookupdev(pcap_ebuf)) == NULL)
+		errx(1, "%s", pcap_ebuf);
 	
-	if ((llif = libnet_open_link_interface(intf, ebuf)) == 0)
-		errx(1, "%s", ebuf);
+	if ((l = libnet_init(LIBNET_LINK, intf, libnet_ebuf)) == NULL)
+		errx(1, "%s", libnet_ebuf);
 	
 	if (target_ip != 0 && !arp_find(target_ip, &target_mac))
 		errx(1, "couldn't arp for host %s",
-		     libnet_host_lookup(target_ip, 0));
+		     libnet_addr2name4(target_ip, LIBNET_DONT_RESOLVE));
 	
 	signal(SIGHUP, cleanup);
 	signal(SIGINT, cleanup);
 	signal(SIGTERM, cleanup);
 	
 	for (;;) {
-		arp_send(llif, intf, ARPOP_REPLY, NULL, spoof_ip,
-			 (target_ip ? (u_char *)&target_mac : NULL),
+		arp_send(l, ARPOP_REPLY, NULL, spoof_ip,
+			 (target_ip ? (u_int8_t *)&target_mac : NULL),
 			 target_ip);
 		sleep(2);
 	}
