<?php
/*********************************************************************************
 * The contents of this file are subject to the TimeTrex Public License Version
 * 1.1.0 ("License"); You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at http://www.TimeTrex.com/TPL
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * All copies of the Covered Code must include on each user interface screen:
 *    (i) the "Powered by TimeTrex" logo and
 *    (ii) the TimeTrex copyright notice
 * in the same form as they appear in the distribution.  See full license for
 * requirements.
 *
 * The Original Code is: TimeTrex Open Source
 * The Initial Developer of the Original Code is TimeTrex Payroll Services
 * Portions created by TimeTrex are Copyright (C) 2004-2007 TimeTrex Payroll Services;
 * All Rights Reserved.
 *
 ********************************************************************************/
/*
 * $Revision: 1246 $
 * $Id: set_admin_permissions.php 1246 2007-09-14 23:47:42Z ipso $
 * $Date: 2007-09-14 16:47:42 -0700 (Fri, 14 Sep 2007) $
 */
require_once( dirname(__FILE__) . DIRECTORY_SEPARATOR .'..'. DIRECTORY_SEPARATOR .'includes'. DIRECTORY_SEPARATOR .'global.inc.php');
require_once( dirname(__FILE__) . DIRECTORY_SEPARATOR .'..'. DIRECTORY_SEPARATOR .'includes'. DIRECTORY_SEPARATOR .'CLI.inc.php');

if ( $argc < 2 OR in_array ($argv[1], array('--help', '-help', '-h', '-?') ) ) {
	$help_output = "Usage: set_admin_permissions.php [user_name]\n";
	echo $help_output;
} else {
	//Handle command line arguments
	$last_arg = count($argv)-1;

	if ( isset($argv[$last_arg]) AND $argv[$last_arg] != '' ) {
		$user_name = $argv[$last_arg];
		//Get user_id from user_name
		$ulf = new UserListFactory();
		$ulf->getByUserName( $user_name );
		if ( $ulf->getRecordCount() == 1 ) {
			echo "Found user, apply administrator permissions...\n";
			ob_flush();

			$u_obj = $ulf->getCurrent();
			//Create new Permission Group just for this purpose.
			$pf = new PermissionFactory();
			$pf->StartTransaction();

			$preset_flags = array();

			$preset_options = $pf->getOptions('preset');
			$pcf = new PermissionControlFactory();
			$pcf->setCompany( $u_obj->getCompany() );
			$pcf->setName( 'Administrator Fix ('.rand(1,1000).')' );
			$pcf->setDescription( 'Created By set_admin_permissions.php' );
			if ( $pcf->isValid() ) {
				$pcf_id = $pcf->Save(FALSE);

				$pcf->setUser( array( $u_obj->getId() ) );

				$pcf->Save();

				if ( $pf->applyPreset($pcf_id, 40, $preset_flags ) == TRUE ) {
					echo "Success!\n";
				}
			}
			//$pf->FailTransaction();
			$pf->CommitTransaction();
		} elseif ( $ulf->getRecordCount() > 2 ) {
			echo "Found more then one user with the same user name, not updating permissions!\n";
		} else {
			echo "User name not found!\n";
		}
	}
}

echo "WARNING: Clear TimeTrex cache after running this.\n";

//Debug::Display();
?>
