<?php
/*********************************************************************************
 * The contents of this file are subject to the TimeTrex Public License Version
 * 1.1.0 ("License"); You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at http://www.TimeTrex.com/TPL
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * All copies of the Covered Code must include on each user interface screen:
 *    (i) the "Powered by TimeTrex" logo and
 *    (ii) the TimeTrex copyright notice
 * in the same form as they appear in the distribution.  See full license for
 * requirements.
 *
 * The Original Code is: TimeTrex Open Source
 * The Initial Developer of the Original Code is TimeTrex Payroll Services
 * Portions created by TimeTrex are Copyright (C) 2004-2007 TimeTrex Payroll Services;
 * All Rights Reserved.
 *
 ********************************************************************************/
/*
 * $Revision: 1396 $
 * $Id: AddRecurringHoliday.php 1396 2007-11-07 16:49:35Z ipso $
 * $Date: 2007-11-07 08:49:35 -0800 (Wed, 07 Nov 2007) $
 */
/*
 * Adds recurring holidays X days in advance,
 * This file should run once a day.
 *
 */
require_once( dirname(__FILE__) . DIRECTORY_SEPARATOR .'..'. DIRECTORY_SEPARATOR .'includes'. DIRECTORY_SEPARATOR .'global.inc.php');
require_once( dirname(__FILE__) . DIRECTORY_SEPARATOR .'..'. DIRECTORY_SEPARATOR .'includes'. DIRECTORY_SEPARATOR .'CLI.inc.php');

$offset = 86400*60; //60 days

$hplf = new HolidayPolicyListFactory();

//Get all holiday policies
$hplf->getAll(NULL, NULL, NULL );

$epoch = time();

foreach ($hplf as $hp_obj) {
	//Get all recurring holidays
	$recurring_holiday_ids = $hp_obj->getRecurringHoliday();

	if ( is_array($recurring_holiday_ids) AND count($recurring_holiday_ids) > 0 ) {
		Debug::Text('Found Recurring Holidays...', __FILE__, __LINE__, __METHOD__,10);
		foreach( $recurring_holiday_ids as $recurring_holiday_id) {
			$rhlf = new RecurringHolidayListFactory();
			$rhlf->getById( $recurring_holiday_id );
			if ( $rhlf->getRecordCount() == 1 ) {
				$rh_obj = $rhlf->getCurrent();
				Debug::Text('Found Recurring Holiday: '. $rh_obj->getName(), __FILE__, __LINE__, __METHOD__,10);

				$next_holiday_date = $rh_obj->getNextDate( $epoch );
				Debug::Text('Next Holiday Date: '. TTDate::getDate('DATE+TIME', $next_holiday_date), __FILE__, __LINE__, __METHOD__,10);

				if ( $next_holiday_date <= ($epoch + $offset) ) {
					Debug::Text('Next Holiday Date is within Time Period (offset) adding...', __FILE__, __LINE__, __METHOD__,10);

					$hf = new HolidayFactory();
					$hf->setHolidayPolicyId( $hp_obj->getId() );
					$hf->setDateStamp( $next_holiday_date );
					$hf->setName( $rh_obj->getName() );

					if ( $hf->isValid() ) {
						$hf->Save();
					}
				} else {
					Debug::Text('Next Holiday Date is NOT within Time Period (offset)!', __FILE__, __LINE__, __METHOD__,10);
				}
			}
		}
	}

	/*
	$end_date = NULL;

	$pay_period_schedule->createNextPayPeriod($end_date, $offset);

	unset($ppf);
	unset($pay_period_schedule);
	*/
}
Debug::writeToLog();
Debug::Display();
?>