<?php
/*********************************************************************************
 * The contents of this file are subject to the TimeTrex Public License Version
 * 1.1.0 ("License"); You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at http://www.TimeTrex.com/TPL
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * All copies of the Covered Code must include on each user interface screen:
 *    (i) the "Powered by TimeTrex" logo and
 *    (ii) the TimeTrex copyright notice
 * in the same form as they appear in the distribution.  See full license for
 * requirements.
 *
 * The Original Code is: TimeTrex Open Source
 * The Initial Developer of the Original Code is TimeTrex Payroll Services
 * Portions created by TimeTrex are Copyright (C) 2004-2007 TimeTrex Payroll Services;
 * All Rights Reserved.
 *
 ********************************************************************************/
/*
 * $Revision: 1855 $
 * $Id: SystemSettings.php 1855 2008-05-08 23:14:41Z ipso $
 * $Date: 2008-05-08 16:14:41 -0700 (Thu, 08 May 2008) $
 */
require_once('../../includes/global.inc.php');

$authenticate=FALSE;
require_once(Environment::getBasePath() .'includes/Interface.inc.php');

$smarty->assign('title', TTi18n::gettext($title = '4. System Settings')); // See index.php

/*
 * Get FORM variables
 */
extract	(FormVariables::GetVariables(
										array	(
												'action',
												'data',
												'external_installer',
												) ) );

$install_obj = new Install();
if ( $install_obj->isInstallMode() == FALSE ) {
	Redirect::Page( URLBuilder::getURL(NULL, 'install.php') );
}

$action = Misc::findSubmitButton();
switch ($action) {
	case 'back':
		Debug::Text('Back', __FILE__, __LINE__, __METHOD__,10);

		Redirect::Page( URLBuilder::getURL(NULL, 'DatabaseConfig.php') );
		break;

	case 'next':
		//Debug::setVerbosity(11);
		Debug::Text('Next', __FILE__, __LINE__, __METHOD__,10);

		//Set salt if it isn't already.
		$data['salt'] = md5( uniqid() );

		$install_obj->writeConfigFile( $data );

		//Write auto_update feature to system settings.
		$sslf = new SystemSettingListFactory();
		$sslf->getByName('update_notify');
		if ( $sslf->getRecordCount() == 1 ) {
			$obj = $sslf->getCurrent();
		} else {
			$obj = new SystemSettingListFactory();
		}

		$obj->setName( 'update_notify' );
		if ( ( isset($data['update_notify']) AND $data['update_notify'] == 1 )
				OR getTTProductEdition() > 10
				OR $external_installer == 1 ) {
			$obj->setValue( 1 );
		} else {
			$obj->setValue( 0 );
		}
		if ( $obj->isValid() ) {
			$obj->Save();
		}

		//Write anonymous_auto_update feature to system settings.
		$sslf = new SystemSettingListFactory();
		$sslf->getByName('anonymous_update_notify');
		if ( $sslf->getRecordCount() == 1 ) {
			$obj = $sslf->getCurrent();
		} else {
			$obj = new SystemSettingListFactory();
		}

		$obj->setName( 'anonymous_update_notify' );
		if ( isset($data['anonymous_update_notify']) AND $data['anonymous_update_notify'] == 1 ) {
			$obj->setValue( 1 );
		} elseif ( getTTProductEdition() == TT_PRODUCT_PROFESSIONAL ) {
			$obj->setValue( 0 );
		} else {
			$obj->setValue( 0 );
		}
		if ( $obj->isValid() ) {
			$obj->Save();
		}

		$ttsc = new TimeTrexSoapClient();
		$ttsc->saveRegistrationKey();

		$handle = fopen('http://www.timetrex.com/'.URLBuilder::getURL( array('v' => $install_obj->getFullApplicationVersion(), 'page' => 'system_setting', 'update_notify' => (int)$data['update_notify'], 'anonymous_update_notify' => (int)$data['anonymous_update_notify']), 'pre_install.php'), "r");
		fclose($handle);

		Redirect::Page( URLBuilder::getURL( array('external_installer' => $external_installer), 'Company.php') );
		break;
	default:
		Debug::Text('Request URI: '. $_SERVER['REQUEST_URI'], __FILE__, __LINE__, __METHOD__,10);

		$data = array(
					'host_name' => $_SERVER['HTTP_HOST'],
					'base_url' => str_replace('/install', '', dirname( $_SERVER['REQUEST_URI'] ) ),
					'log_dir' => $config_vars['path']['log'],
					'storage_dir' => $config_vars['path']['storage'],
					'cache_dir' => $config_vars['cache']['dir'],
					);

		$smarty->assign_by_ref('data', $data);

		break;
}

$handle = @fopen('http://www.timetrex.com/'.URLBuilder::getURL( array('v' => $install_obj->getFullApplicationVersion(), 'page' => 'system_setting'), 'pre_install.php'), "r");
@fclose($handle);

$smarty->assign_by_ref('install_obj', $install_obj);
$smarty->assign_by_ref('external_installer', $external_installer);
$smarty->display('install/SystemSettings.tpl');
?>