<?php
/*********************************************************************************
 * The contents of this file are subject to the TimeTrex Public License Version
 * 1.1.0 ("License"); You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at http://www.TimeTrex.com/TPL
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * All copies of the Covered Code must include on each user interface screen:
 *    (i) the "Powered by TimeTrex" logo and
 *    (ii) the TimeTrex copyright notice
 * in the same form as they appear in the distribution.  See full license for
 * requirements.
 *
 * The Original Code is: TimeTrex Open Source
 * The Initial Developer of the Original Code is TimeTrex Payroll Services
 * Portions created by TimeTrex are Copyright (C) 2004-2007 TimeTrex Payroll Services;
 * All Rights Reserved.
 *
 ********************************************************************************/
/*
 * $Revision: 1246 $
 * $Id: EditHierarchyControl.php 1246 2007-09-14 23:47:42Z ipso $
 * $Date: 2007-09-14 16:47:42 -0700 (Fri, 14 Sep 2007) $
 */
require_once('../../includes/global.inc.php');
require_once(Environment::getBasePath() .'includes/Interface.inc.php');

if ( !$permission->Check('hierarchy','enabled')
		OR !( $permission->Check('hierarchy','edit') OR $permission->Check('hierarchy','edit_own') ) ) {

	$permission->Redirect( FALSE ); //Redirect

}

$smarty->assign('title', TTi18n::gettext($title = 'Edit Hierarchy List')); // See index.php

/*
 * Get FORM variables
 */
extract	(FormVariables::GetVariables(
										array	(
												'action',
												'hierarchy_control_id',
												'hierarchy_control_data'
												) ) );

$hcf = new HierarchyControlFactory();

$action = Misc::findSubmitButton();
switch ($action) {
	case 'submit':
		Debug::Text('Submit!', __FILE__, __LINE__, __METHOD__,10);

		$hcf->setId( $hierarchy_control_data['id'] );
		$hcf->setCompany( $current_company->getId() );
		if ( isset($hierarchy_control_data['object_type_ids']) ) {
			$hcf->setObjectType(  $hierarchy_control_data['object_type_ids'] );
		} else {
			$hcf->setObjectType(  FALSE );
		}

		//$dscf->setStatus( $default_schedule_control_data['status'] );

		$hcf->setName($hierarchy_control_data['name']);
		$hcf->setDescription($hierarchy_control_data['description']);

		if ( $hcf->isValid() ) {
			$hcf->Save(FALSE);

			Redirect::Page( URLBuilder::getURL( array(), 'HierarchyControlList.php') );

			break;
		}

	default:
		if ( isset($hierarchy_control_id) ) {
			BreadCrumb::setCrumb($title);

			$hclf = new HierarchyControlListFactory();

			$hclf->GetByIdAndCompanyId($hierarchy_control_id, $current_company->getId() );

			foreach ($hclf as $hierarchy_control) {
				//echo "Status: ".$default_schedule_control->getStatus() ."<br>\n";



				$hierarchy_control_data = array(
									'id' => $hierarchy_control->getId(),
									'name' => $hierarchy_control->getName(),
									'description' => $hierarchy_control->getDescription(),
									'object_type_ids' => $hierarchy_control->getObjectType(),
									'created_date' => $hierarchy_control->getCreatedDate(),
									'created_by' => $hierarchy_control->getCreatedBy(),
									'updated_date' => $hierarchy_control->getUpdatedDate(),
									'updated_by' => $hierarchy_control->getUpdatedBy(),
									'deleted_date' => $hierarchy_control->getDeletedDate(),
									'deleted_by' => $hierarchy_control->getDeletedBy()
								);
			}
		}

		$hotlf = new HierarchyObjectTypeListFactory();

		//Select box options;
		$hierarchy_control_data['object_type_options'] = $hotlf->getOptions('object_type');

		$smarty->assign_by_ref('hierarchy_control_data', $hierarchy_control_data);

		break;
}

$smarty->assign_by_ref('hcf', $hcf);

$smarty->display('hierarchy/EditHierarchyControl.tpl');
?>