#!/usr/bin/php
<?php
/*********************************************************************************
 * The contents of this file are subject to the TimeTrex Public License Version
 * 1.1.0 ("License"); You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at http://www.TimeTrex.com/TPL
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * All copies of the Covered Code must include on each user interface screen:
 *    (i) the "Powered by TimeTrex" logo and
 *    (ii) the TimeTrex copyright notice
 * in the same form as they appear in the distribution.  See full license for
 * requirements.
 *
 * The Original Code is: TimeTrex Open Source
 * The Initial Developer of the Original Code is TimeTrex Payroll Services
 * Portions created by TimeTrex are Copyright (C) 2004-2007 TimeTrex Payroll Services;
 * All Rights Reserved.
 *
 ********************************************************************************/
/*
 * $Revision: 679 $
 * $Id: calc_l10n_stats.php 679 2007-03-08 18:32:16Z ipso $
 * $Date: 2007-03-08 10:32:16 -0800 (Thu, 08 Mar 2007) $
 *
 * File Contributed By: Open Source Consulting, S.A.   San Jose, Costa Rica.
 * http://osc.co.cr
 */

// Calculates percent complete statistics for all locales.
// Must be run from tools/i18n directory.

   $root_dir = '../../interface/locale';
   if( count( $argv ) > 1 ) {
      $root_dir = $argv[1];
   }

   $d = opendir( $root_dir );
   
   if( $d ) {
   
      echo "calculating locale statistics...\n";

      $outpath = $root_dir . '/' . 'locale_stats.txt';
      $fh = fopen( $outpath, 'w' );
      
      $ignore_dirs = array( '.', '..', 'CVS' );
      while (false !== ($file = readdir($d))) {
         if( is_dir( $root_dir . '/' . $file ) && !in_array( $file, $ignore_dirs) ) {
            $stats = calcStats( $root_dir, $file );
            $pct = $stats['pct_complete'];
            $team = $stats['team'];
            fwrite( $fh, "$file|$pct|$team\n" );
         }
      }
      closedir( $d );
      
      fclose( $fh );
      
      echo "done. stats saved in $outpath\n";
   }

   function calcStats( $root_dir, $locale ) {
      $messages = 0;
      $translations = 0;
      $fuzzy = 0;
      
      $team = '';
   
      $path = $root_dir . '/' . $locale . '/LC_MESSAGES/messages.po';
      // echo "<li><b>$path</b>";
      if( file_exists( $path ) ) {
         $lines = file( $path );
         
         $in_msgid = false;
         $in_msgstr = false;
         $found_translation = false;
         $found_msg = false;
         foreach( $lines as $line ) {
            // ignore comment lines
            if( $line[0] == '#' ) {
               continue;
            }
            
            // Parse out the contributors.
            if( strstr( $line, '"Language-Team: ' ) ) {
               $endpos = strpos( $line, '\n' );
               if( $endpos === false ) {
                  $endpos = strlen( $line ) - 2;
               }
               $len = strlen('"Language-Team: ');
               $field = substr( $line, $len, $endpos - $len );
               $names = explode( ',', $field );
               foreach( $names as $name ) {
                  if( $name != 'none' ) {
                     if( $team != '' ) {
                        $team .= ',';
                     }
                     $team .= trim( $name );
                  }
               }
            }
         
            if( strstr( $line, 'msgid "' ) ) {
               $in_msgid = true;
               $in_msgstr = false;
               $found_msg = false;
               $found_translation = false;
            }
            if( $in_msgid && !$found_msg && strstr( $line, '"' ) && !strstr( $line, '""' ) ) {
               // echo "<li>msgid: $line";
               $found_msg = true;
               $messages ++;
            }
            else if( strstr($line, 'msgstr "') ) {
               $in_msgstr = true;
               $in_msgid = false;
            }
            if( $in_msgstr && $found_msg && !$found_translation ) {
               if( strstr( $line, '"' ) && !strstr( $line, '""' ) ) {
                  // echo "<li>msgstr: $line";
                  $translations ++;
                  $found_translation = true;
               }
            }
            else if( strstr( $line, '#, fuzzy' ) ) {
               $fuzzy ++;
            }
         }
      }
      $translations -= $fuzzy;
      $pct_complete = $messages ? (int)(($translations / $messages) * 100) : 0;

      return array( 'pct_complete' => $pct_complete, 'team' => $team );
   }
 
 
?>
