<?php
/*********************************************************************************
 * The contents of this file are subject to the TimeTrex Public License Version
 * 1.1.0 ("License"); You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at http://www.TimeTrex.com/TPL
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * All copies of the Covered Code must include on each user interface screen:
 *    (i) the "Powered by TimeTrex" logo and
 *    (ii) the TimeTrex copyright notice
 * in the same form as they appear in the distribution.  See full license for
 * requirements.
 *
 * The Original Code is: TimeTrex Open Source
 * The Initial Developer of the Original Code is TimeTrex Payroll Services
 * Portions created by TimeTrex are Copyright (C) 2004-2007 TimeTrex Payroll Services;
 * All Rights Reserved.
 *
 ********************************************************************************/
/*
 * $Revision: 1636 $
 * $Id: EditCompany.php 1636 2008-01-11 20:35:56Z ipso $
 * $Date: 2008-01-11 12:35:56 -0800 (Fri, 11 Jan 2008) $
 */
require_once('../../includes/global.inc.php');
require_once(Environment::getBasePath() .'includes/Interface.inc.php');

if ( !$permission->Check('company','enabled')
		OR !( $permission->Check('company','edit') OR $permission->Check('company','edit_own') ) ) {

	$permission->Redirect( FALSE ); //Redirect
}

$smarty->assign('title', TTi18n::gettext($title = 'Edit Company')); // See index.php

/*
 * Get FORM variables
 */
extract	(FormVariables::GetVariables(
										array	(
												'action',
												'id',
												'company_data'
												) ) );

$cf = new CompanyFactory();

$action = Misc::findSubmitButton();
switch ($action) {
	case 'submit':
		//Debug::setVerbosity( 11 );
		Debug::Text('Submit!', __FILE__, __LINE__, __METHOD__,10);
		$cf->StartTransaction();

		if ( $permission->Check('company','edit') ) {
			$cf->setId( $company_data['id'] );
			$cf->setParent( $company_data['parent'] );
			$cf->setStatus( $company_data['status'] );
		} else {
			$cf->setId( $current_company->getId() );
		}

		$cf->setProductEdition($company_data['product_edition']);
		if ( isset($company_data['name']) ) {
			$cf->setName($company_data['name']);
		}
		$cf->setShortName($company_data['short_name']);
		$cf->setBusinessNumber($company_data['business_number']);
		$cf->setOriginatorID($company_data['originator_id']);
		$cf->setDataCenterID($company_data['data_center_id']);
		$cf->setAddress1($company_data['address1']);
		$cf->setAddress2($company_data['address2']);
		$cf->setCity($company_data['city']);
		$cf->setCountry($company_data['country']);
		if ( isset($company_data['province']) ) {
			$cf->setProvince($company_data['province']);
		}
		$cf->setPostalCode($company_data['postal_code']);
		$cf->setWorkPhone($company_data['work_phone']);
		$cf->setFaxPhone($company_data['fax_phone']);
		$cf->setAdminContact($company_data['admin_contact']);
		$cf->setBillingContact($company_data['billing_contact']);
		$cf->setSupportContact($company_data['support_contact']);

		if ( isset($company_data['enable_second_last_name']) AND $company_data['enable_second_last_name'] == 1 ) {
			$cf->setEnableSecondLastName( TRUE );
		}else{
			$cf->setEnableSecondLastName( FALSE );
		}

		if ( $cf->isNew() == TRUE ) {
			$cf->setEnableAddCurrency( TRUE );
			$cf->setEnableAddPermissionGroupPreset( TRUE );
			$cf->setEnableAddStation( TRUE );
			$cf->setEnableAddPayStubEntryAccountPreset( TRUE );
			$cf->setEnableAddRecurringHolidayPreset( TRUE );
		}

		if ( $cf->isValid() ) {
			$cf->Save();

			//$cf->FailTransaction();
			$cf->CommitTransaction();

			if ( $permission->Check('company','edit') ) {
				Redirect::Page( URLBuilder::getURL(NULL, 'CompanyList.php') );
			} else {
				Redirect::Page( URLBuilder::getURL(NULL, '../index.php') );
			}

			break;
		}
		$cf->FailTransaction();
	default:
		if ( isset($id) ) {
			BreadCrumb::setCrumb($title);

			$clf = new CompanyListFactory();

			if ( $permission->Check('company','edit') ) {
				$clf->GetByID($id);
			} else {
				$id = $current_company->getId();
				$clf->GetByID( $id );
			}

			foreach ($clf as $company) {
				//Debug::Arr($company,'Company', __FILE__, __LINE__, __METHOD__,10);

				$company_data = array(
									'id' => $company->getId(),
									'parent' => $company->getParent(),
									'status' => $company->getStatus(),
									'product_edition' => $company->getProductEdition(),
									'name' => $company->getName(),
									'short_name' => $company->getShortName(),
									'business_number' => $company->getBusinessNumber(),
									'originator_id' => $company->getOriginatorID(),
									'data_center_id' => $company->getDataCenterID(),
									'address1' => $company->getAddress1(),
									'address2' => $company->getAddress2(),
									'city' => $company->getCity(),
									'province' => $company->getProvince(),
									'country' => $company->getCountry(),
									'postal_code' => $company->getPostalCode(),
									'work_phone' => $company->getWorkPhone(),
									'fax_phone' => $company->getFaxPhone(),
									'admin_contact' => $company->getAdminContact(),
									'billing_contact' => $company->getBillingContact(),
									'support_contact' => $company->getSupportContact(),
									'logo_file_name' => $company->getLogoFileName( NULL, FALSE ),
									'enable_second_last_name' => $company->getEnableSecondLastName(),
									'created_date' => $company->getCreatedDate(),
									'created_by' => $company->getCreatedBy(),
									'updated_date' => $company->getUpdatedDate(),
									'updated_by' => $company->getUpdatedBy(),
									'deleted_date' => $company->getDeletedDate(),
									'deleted_by' => $company->getDeletedBy(),
								);
			}
		}

		//Select box options;
		$company_data['status_options'] = $cf->getOptions('status');
		$company_data['country_options'] = $cf->getOptions('country');

		//Company list.
		$company_data['company_list_options'] = CompanyListFactory::getAllArray();
		$company_data['product_edition_options'] = $cf->getOptions('product_edition');

		if (!isset($id) AND isset($company_data['id']) ) {
			$id = $company_data['id'];
		}
		$company_data['user_list_options'] = UserListFactory::getByCompanyIdArray($id);

		$smarty->assign_by_ref('company_data', $company_data);

		break;
}

$smarty->assign_by_ref('cf', $cf);

$smarty->display('company/EditCompany.tpl');
?>