/*
 * acclists.h
 * Thomas Nemeth, le 18.09.1999
 *
 * HEADER
 * Gestion de la liste des donnes de gAcc, gestionnaire de comptes
 * banquaires personnels avec GTK+.
 *
 *   Copyright (C) 1999  Thomas Nemeth
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef _ACCLISTS_H_
#define _ACCLISTS_H_

#include "structs.h"

/* ------++++++======****** AIDE ******* HELP ******======++++++----- */

/* Ajoute un sous-niveau  la structure d'historique de l'aide        */
/* Add a sub-level to the help history structure                      */
void help_push (const char *index);

/* Enlve un sous-niveau de la structure d'historique de l'aide       */
/* Remove a sub-level from the help history structure                 */
void help_pop ();

/* Renvoie le dernier sous-niveau de l'historique de l'aide           */
/* Return the last sub-level from the help history                    */
char *help_top ();

/* Vide l'historique de l'aide                                        */
/* Empty the help history                                             */
void help_empty ();


/* ------++++++======****** LISTE *** MY_LIST ******======++++++----- */

/* Ajoute un lment dans la structure de transfert de donnes        */
/* Add an element in the data transfer structure                      */
MY_LIST *my_list_add (MY_LIST *list, void *element);

/* Libre la mmoire occupe par la structure de transfert de donnes */
/* Free the memory used by the data transfer structure                */
void my_list_free (MY_LIST *list);

/* Renvoie un lment de la structure de transfert de donnes         */
/* Return an element from the data transfer structure                 */
void *my_list_get_element (MY_LIST *list, int element);


#endif
