/*  xtraceroute - graphically show traceroute information.
 *  Copyright (C) 1996-1998  Bjrn Augustsson 
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <unistd.h>
#include <string.h>
#include "xt.h"

extern GtkWidget *clist;
extern traceroute_state_t traceroute_state;  // From extprog.c

static gint destroy_widget_callback(GtkWidget *wi, gpointer *target)
{
  gtk_widget_destroy(GTK_WIDGET(target));

  return TRUE;
}

static gint yesbutton_callback(GtkWidget *wi, gpointer *data)
{
    int i;
    strcpy(currentloc, gtk_entry_get_text(GTK_ENTRY(data)));

    /* Might make sense to have a better test for hostname
       validity here. Nasty things might happen if there's
       an ampersand character in the string for example, since
       it gets passed to the shell via popen(). 

       God I'm happy this won't run SUID root... :)     */

    if(strlen(currentloc) < 2)
      {
	new_trace(NULL, NULL);
	return TRUE;
      }


    if(traceroute_state.fd[0] != -1)  // FIXME upgrade to real pipes.
      {
	gdk_input_remove(traceroute_state.tag); // Should this be here? Think so.
	close(traceroute_state.fd[0]);
	traceroute_state.fd[0] = -1;
      }
    traceroute_state.buffer_counter = 0;

    for(i=0;i<MAX_SITES;i++)
      {
	sites[i].draw = 0;
	sites[i].selected = 0;
	/* Kill all possible extprograms still running. */
	if(sites[i].extpipe_tag != 0)
	  {
	    gdk_input_remove(sites[i].extpipe_tag);
	    sites[i].extpipe_tag = 0;
	    if(sites[i].extpipe[0] != -1)
	      {
		close(sites[i].extpipe[0]);
		sites[i].extpipe[0] = -1;
	      }
	  }
	sites[i].extpipe_data_counter = 0;
      }
    /* Clear the whole list. */
    gtk_clist_clear(GTK_CLIST(clist));
    makeearth();
    calltrace(FALSE);
    return TRUE;
}

/**
 * Opens a dialog box, prompting for a site to traceroute.
 *
 * None of the arguments are used.
 */

gint new_trace(GtkWidget *wi, gpointer *data)
{
  GtkWidget *dialog;
  GtkWidget *yesbutton;
  GtkWidget *nobutton;
  GtkWidget *label;
  GtkWidget *entry;


  dialog = gtk_dialog_new();
  label  = gtk_label_new(_("Enter target for new trace:"));
  entry  = gtk_entry_new();
  
  gtk_window_set_title (GTK_WINDOW(dialog),_("New trace"));

  gtk_container_border_width(GTK_CONTAINER(dialog), 10);
  

  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox), label, TRUE,
		      TRUE, 0);
  gtk_widget_show(label);

  
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox), entry, TRUE,
		     TRUE, 0);
  gtk_signal_connect(GTK_OBJECT (entry), "activate",
		     GTK_SIGNAL_FUNC (yesbutton_callback), entry);
  gtk_signal_connect(GTK_OBJECT (entry), "activate",
		     GTK_SIGNAL_FUNC (destroy_widget_callback), dialog);
  gtk_widget_grab_focus(entry);
  gtk_widget_show(entry);


  yesbutton = gtk_button_new_with_label(_("OK"));
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area), yesbutton,
		     TRUE, TRUE, 0);
  gtk_signal_connect(GTK_OBJECT (yesbutton), "clicked",
		     GTK_SIGNAL_FUNC (yesbutton_callback), entry);
  gtk_signal_connect(GTK_OBJECT (yesbutton), "clicked",
		     GTK_SIGNAL_FUNC (destroy_widget_callback), dialog);
  GTK_WIDGET_SET_FLAGS(yesbutton, GTK_CAN_DEFAULT);
  gtk_widget_grab_default(yesbutton);
  gtk_widget_show(yesbutton);

  nobutton = gtk_button_new_with_label(_("Cancel"));
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area), nobutton,
		     TRUE, TRUE, 0);
  gtk_signal_connect(GTK_OBJECT (nobutton), "clicked",
		      GTK_SIGNAL_FUNC(destroy_widget_callback), dialog);
  gtk_widget_show(nobutton);
  

  gtk_widget_show (dialog);

  return TRUE;
}

void tell_user(const char *mess)
{
    GtkWidget *dialog;
    GtkWidget *button; 
    GtkWidget *label;
    
    dialog = gtk_dialog_new();
    gtk_container_border_width(GTK_CONTAINER(dialog), 10);
    
    label  = gtk_label_new(mess);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox), label, TRUE,
	    TRUE, 0);
    gtk_widget_show(label);
    
    
    button = gtk_button_new_with_label(_("OK"));
    gtk_signal_connect(GTK_OBJECT (button), "clicked",
	    GTK_SIGNAL_FUNC (destroy_widget_callback), dialog);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area), button,
	    TRUE, TRUE, 0);
    GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);
    gtk_widget_grab_default(button);
    gtk_widget_show(button);
    
    gtk_widget_show(dialog);    
}

