/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.inject;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InjectedLanguage {
    private static Map<String, Language> ourLanguageCache;
    private static int ourLanguageCount;
    @NotNull
    private final String myID;
    @NotNull
    private final String myPrefix;
    @NotNull
    private final String mySuffix;
    private final boolean myDynamic;

    private InjectedLanguage(@NotNull String id, @NotNull String prefix, @NotNull String suffix, boolean dynamic) {
        if (id == null) {
            InjectedLanguage.$$$reportNull$$$0(0);
        }
        if (prefix == null) {
            InjectedLanguage.$$$reportNull$$$0(1);
        }
        if (suffix == null) {
            InjectedLanguage.$$$reportNull$$$0(2);
        }
        this.myID = id;
        this.myPrefix = prefix;
        this.mySuffix = suffix;
        this.myDynamic = dynamic;
    }

    @NotNull
    public String getID() {
        String string = this.myID;
        if (string == null) {
            InjectedLanguage.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    public Language getLanguage() {
        return InjectedLanguage.findLanguageById(this.myID);
    }

    @NotNull
    public String getPrefix() {
        String string = this.myPrefix;
        if (string == null) {
            InjectedLanguage.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public String getSuffix() {
        String string = this.mySuffix;
        if (string == null) {
            InjectedLanguage.$$$reportNull$$$0(5);
        }
        return string;
    }

    public boolean isDynamic() {
        return this.myDynamic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Language findLanguageById(@Nullable String langID) {
        if (langID == null || langID.isEmpty()) {
            return null;
        }
        Class<InjectedLanguage> clazz = InjectedLanguage.class;
        synchronized (InjectedLanguage.class) {
            if (ourLanguageCache == null || ourLanguageCount != Language.getRegisteredLanguages().size()) {
                InjectedLanguage.initLanguageCache();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return ourLanguageCache.get(langID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Language @NotNull [] getAvailableLanguages() {
        Class<InjectedLanguage> clazz = InjectedLanguage.class;
        synchronized (InjectedLanguage.class) {
            if (ourLanguageCache == null || ourLanguageCount != Language.getRegisteredLanguages().size()) {
                InjectedLanguage.initLanguageCache();
            }
            Language[] languageArray = (Language[])new HashSet<Language>(ourLanguageCache.values()).toArray(Language[]::new);
            // ** MonitorExit[var0] (shouldn't be in output)
            if (languageArray == null) {
                InjectedLanguage.$$$reportNull$$$0(6);
            }
            return languageArray;
        }
    }

    private static void initLanguageCache() {
        ArrayList registeredLanguages;
        ourLanguageCache = ContainerUtil.createWeakValueMap();
        do {
            registeredLanguages = new ArrayList(Language.getRegisteredLanguages());
            for (Language language : registeredLanguages) {
                if (!LanguageUtil.isInjectableLanguage((Language)language)) continue;
                String languageID = language.getID();
                ourLanguageCache.put(languageID, language);
                String lowerCase = languageID.toLowerCase(Locale.ROOT);
                if (lowerCase.equals(languageID)) continue;
                ourLanguageCache.put(lowerCase, language);
            }
        } while (Language.getRegisteredLanguages().size() != registeredLanguages.size());
        ourLanguageCount = registeredLanguages.size();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InjectedLanguage that = (InjectedLanguage)o;
        return this.myID.equals(that.myID);
    }

    public int hashCode() {
        return this.myID.hashCode();
    }

    @Nullable
    public static InjectedLanguage create(String id) {
        return InjectedLanguage.create(id, "", "", false);
    }

    @Contract(value="null, _, _, _ -> null; !null, _, _, _ -> new", pure=true)
    @Nullable
    public static InjectedLanguage create(@Nullable String id, String prefix, String suffix, boolean isDynamic) {
        return id == null ? null : new InjectedLanguage(id, prefix == null ? "" : prefix, suffix == null ? "" : suffix, isDynamic);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/plugins/intelliLang/inject/InjectedLanguage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/plugins/intelliLang/inject/InjectedLanguage";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrefix";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuffix";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableLanguages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6 -> new IllegalStateException(string);
        };
    }
}

