/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notebooks.visualization.ui;

import com.intellij.ide.ui.customization.CustomActionsSchema;
import com.intellij.notebooks.visualization.CaretBasedCellSelectionModelKt;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.NotebookVisualizationUiUtilKt;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.impl.FloatingToolbar;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J\n\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0014\u00a8\u0006\u000f"}, d2={"Lcom/intellij/notebooks/visualization/ui/MarkdownCellsFloatingToolbar;", "Lcom/intellij/openapi/actionSystem/impl/FloatingToolbar;", "editor", "Lcom/intellij/openapi/editor/Editor;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/editor/Editor;Lkotlinx/coroutines/CoroutineScope;)V", "isEnabled", "", "getSelectedCells", "", "Lcom/intellij/notebooks/visualization/NotebookCellLines$Interval;", "createActionGroup", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "intellij.notebooks.visualization"})
@SourceDebugExtension(value={"SMAP\nMarkdownCellsFloatingToolbar.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkdownCellsFloatingToolbar.kt\ncom/intellij/notebooks/visualization/ui/MarkdownCellsFloatingToolbar\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,34:1\n1387#2:35\n1475#2,5:36\n*S KotlinDebug\n*F\n+ 1 MarkdownCellsFloatingToolbar.kt\ncom/intellij/notebooks/visualization/ui/MarkdownCellsFloatingToolbar\n*L\n25#1:35\n25#1:36,5\n*E\n"})
public final class MarkdownCellsFloatingToolbar
extends FloatingToolbar {
    public MarkdownCellsFloatingToolbar(@NotNull Editor editor, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        super(editor, coroutineScope);
    }

    public boolean isEnabled() {
        List<NotebookCellLines.Interval> selectedCells = this.getSelectedCells();
        if (selectedCells.isEmpty() || selectedCells.size() > 1) {
            return false;
        }
        return ((NotebookCellLines.Interval)CollectionsKt.first(selectedCells)).getType() == NotebookCellLines.CellType.MARKDOWN;
    }

    /*
     * WARNING - void declaration
     */
    private final List<NotebookCellLines.Interval> getSelectedCells() {
        void $this$flatMapTo$iv$iv;
        NotebookCellLines notebookCellLines = NotebookCellLines.Companion.get(this.getEditor());
        List list = this.getEditor().getCaretModel().getAllCarets();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllCarets(...)");
        Iterable $this$flatMap$iv = list;
        boolean $i$f$flatMapSequence = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapSequenceTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Caret caret = (Caret)element$iv$iv;
            boolean bl = false;
            Document document = this.getEditor().getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            Intrinsics.checkNotNull((Object)caret);
            Sequence<NotebookCellLines.Interval> list$iv$iv = NotebookVisualizationUiUtilKt.getCells(notebookCellLines, CaretBasedCellSelectionModelKt.getSelectionLines(document, caret));
            CollectionsKt.addAll((Collection)destination$iv$iv, list$iv$iv);
        }
        return CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
    }

    @Nullable
    protected ActionGroup createActionGroup() {
        AnAction anAction = CustomActionsSchema.Companion.getInstance().getCorrectedAction("Markdown.Toolbar.Floating");
        return anAction instanceof ActionGroup ? (ActionGroup)anAction : null;
    }
}

