/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * asinh(vec3(0.0, 1e-10, -1e-10)) => vec3(0.0, 1e-10, -1e-10)
 * asinh(vec3(0.1, -0.1, 1.0)) => vec3(0.09983408, -0.09983408, 0.8813736)
 * asinh(vec3(-1.0, 10.0, -10.0)) => vec3(-0.8813736, 2.998223, -2.998223)
 * asinh(vec3(10000000000.0, -10000000000.0, 0.0)) => vec3(23.718998, -23.718998, 0.0)
 */
#version 150

void main()
{
  float[distance(asinh(vec3(0.0, 1e-10, -1e-10)), vec3(0.0, 1e-10, -1e-10)) <= 0.00017320507 ? 1 : -1] array0;
  float[distance(asinh(vec3(0.1, -0.1, 1.0)), vec3(0.09983408, -0.09983408, 0.8813736)) <= 0.0008926474 ? 1 : -1] array1;
  float[distance(asinh(vec3(-1.0, 10.0, -10.0)), vec3(-0.8813736, 2.998223, -2.998223)) <= 0.0043307627 ? 1 : -1] array2;
  float[distance(asinh(vec3(10000000000.0, -10000000000.0, 0.0)), vec3(23.718998, -23.718998, 0.0)) <= 0.033543877 ? 1 : -1] array3;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
