/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * require_extensions: GL_ARB_gpu_shader_fp64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (dmat2x4(0.16lf, -0.8lf, -1.74lf, -0.02lf, -1.69lf, 0.59lf, -1.43lf, -1.21lf) * dvec2(-0.1lf, -1.2lf)) => dvec4(2.012lf, -0.6279999999999999lf, 1.89lf, 1.454lf)
 * (dmat2x4(0.16lf, -0.8lf, -1.74lf, -0.02lf, -1.69lf, 0.59lf, -1.43lf, -1.21lf) * dvec2(-0.42lf, 0.48lf)) => dvec4(-0.8784lf, 0.6192lf, 0.044400000000000106lf, -0.5724lf)
 * (dmat2x4(-1.02lf, -1.64lf, -1.59lf, 0.3lf, 0.74lf, -0.13lf, 0.47lf, 1.13lf) * dvec2(-0.1lf, -1.2lf)) => dvec4(-0.786lf, 0.32lf, -0.4049999999999999lf, -1.386lf)
 * (dmat2x4(-1.02lf, -1.64lf, -1.59lf, 0.3lf, 0.74lf, -0.13lf, 0.47lf, 1.13lf) * dvec2(-0.42lf, 0.48lf)) => dvec4(0.7836lf, 0.6264lf, 0.8934lf, 0.4163999999999999lf)
 */
#version 150
#extension GL_ARB_gpu_shader_fp64 : require

void main()
{
  double[distance((dmat2x4(0.16lf, -0.8lf, -1.74lf, -0.02lf, -1.69lf, 0.59lf, -1.43lf, -1.21lf) * dvec2(-0.1lf, -1.2lf)), dvec4(2.012lf, -0.6279999999999999lf, 1.89lf, 1.454lf)) <= 3.18256877380521e-05lf ? 1 : -1] array0;
  double[distance((dmat2x4(0.16lf, -0.8lf, -1.74lf, -0.02lf, -1.69lf, 0.59lf, -1.43lf, -1.21lf) * dvec2(-0.42lf, 0.48lf)), dvec4(-0.8784lf, 0.6192lf, 0.044400000000000106lf, -0.5724lf)) <= 1.2184450418463692e-05lf ? 1 : -1] array1;
  double[distance((dmat2x4(-1.02lf, -1.64lf, -1.59lf, 0.3lf, 0.74lf, -0.13lf, 0.47lf, 1.13lf) * dvec2(-0.1lf, -1.2lf)), dvec4(-0.786lf, 0.32lf, -0.4049999999999999lf, -1.386lf)) <= 1.6748782045271233e-05lf ? 1 : -1] array2;
  double[distance((dmat2x4(-1.02lf, -1.64lf, -1.59lf, 0.3lf, 0.74lf, -0.13lf, 0.47lf, 1.13lf) * dvec2(-0.42lf, 0.48lf)), dvec4(0.7836lf, 0.6264lf, 0.8934lf, 0.4163999999999999lf)) <= 1.4063991040952777e-05lf ? 1 : -1] array3;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
