/*
 * Decompiled with CFR 0.152.
 */
package com.o19s.es.ltr.action;

import com.o19s.es.ltr.action.ListStoresAction;
import com.o19s.es.ltr.feature.store.index.IndexFeatureStore;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.opensearch.action.IndicesRequest;
import org.opensearch.action.admin.cluster.state.ClusterStateRequest;
import org.opensearch.action.search.MultiSearchRequestBuilder;
import org.opensearch.action.search.MultiSearchResponse;
import org.opensearch.action.search.SearchRequestBuilder;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.clustermanager.TransportClusterManagerNodeReadAction;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.block.ClusterBlockException;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.collect.Tuple;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.search.aggregations.AggregationBuilder;
import org.opensearch.search.aggregations.AggregationBuilders;
import org.opensearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.opensearch.search.aggregations.bucket.terms.Terms;
import org.opensearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;

public class TransportListStoresAction
extends TransportClusterManagerNodeReadAction<ListStoresAction.ListStoresActionRequest, ListStoresAction.ListStoresActionResponse> {
    private final Client client;

    @Inject
    public TransportListStoresAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Client client) {
        super("cluster:admin/ltr/featurestore/list", transportService, clusterService, threadPool, actionFilters, ListStoresAction.ListStoresActionRequest::new, indexNameExpressionResolver);
        this.client = client;
    }

    protected String executor() {
        return "same";
    }

    protected ListStoresAction.ListStoresActionResponse read(StreamInput in) throws IOException {
        return new ListStoresAction.ListStoresActionResponse(in);
    }

    protected void clusterManagerOperation(ListStoresAction.ListStoresActionRequest request, ClusterState state, ActionListener<ListStoresAction.ListStoresActionResponse> listener) throws Exception {
        String[] names = this.indexNameExpressionResolver.concreteIndexNames(state, (IndicesRequest)new ClusterStateRequest().indices(new String[]{".ltrstore", ".ltrstore_*"}));
        MultiSearchRequestBuilder req = this.client.prepareMultiSearch();
        ArrayList versions = new ArrayList();
        Stream.of(names).filter(IndexFeatureStore::isIndexStore).map(s -> (IndexMetadata)this.clusterService.state().metadata().getIndices().get(s)).filter(Objects::nonNull).filter(im -> IndexFeatureStore.STORE_VERSION_PROP.exists(im.getSettings())).forEach(m -> {
            req.add(this.countSearchRequest((IndexMetadata)m));
            versions.add(Tuple.tuple((Object)m.getIndex().getName(), (Object)((Integer)IndexFeatureStore.STORE_VERSION_PROP.get(m.getSettings()))));
        });
        if (versions.isEmpty()) {
            listener.onResponse((Object)new ListStoresAction.ListStoresActionResponse(Collections.emptyList()));
        } else {
            req.execute(ActionListener.wrap(r -> listener.onResponse((Object)this.toResponse((MultiSearchResponse)r, versions)), arg_0 -> listener.onFailure(arg_0)));
        }
    }

    private SearchRequestBuilder countSearchRequest(IndexMetadata meta) {
        return this.client.prepareSearch(new String[]{meta.getIndex().getName()}).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).setSize(0).addAggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"type").field("type")).size(100));
    }

    private ListStoresAction.ListStoresActionResponse toResponse(MultiSearchResponse response, List<Tuple<String, Integer>> versions) {
        assert (versions.size() == response.getResponses().length);
        Iterator<Tuple<String, Integer>> vs = versions.iterator();
        Iterator rs = response.iterator();
        ArrayList<ListStoresAction.IndexStoreInfo> infos = new ArrayList<ListStoresAction.IndexStoreInfo>(versions.size());
        while (vs.hasNext() && rs.hasNext()) {
            MultiSearchResponse.Item it = (MultiSearchResponse.Item)rs.next();
            Tuple<String, Integer> idxAndVersion = vs.next();
            Map<String, Integer> counts = Collections.emptyMap();
            if (!it.isFailure()) {
                Terms aggs = (Terms)it.getResponse().getAggregations().get("type");
                counts = aggs.getBuckets().stream().collect(Collectors.toMap(MultiBucketsAggregation.Bucket::getKeyAsString, b -> (int)b.getDocCount()));
            }
            infos.add(new ListStoresAction.IndexStoreInfo((String)idxAndVersion.v1(), (Integer)idxAndVersion.v2(), counts));
        }
        return new ListStoresAction.ListStoresActionResponse(infos);
    }

    private Tuple<String, Integer> toVersion(String s) {
        if (!IndexFeatureStore.isIndexStore(s)) {
            return null;
        }
        IndexMetadata index = (IndexMetadata)this.clusterService.state().metadata().getIndices().get(s);
        if (index != null && IndexFeatureStore.STORE_VERSION_PROP.exists(index.getSettings())) {
            return new Tuple((Object)index.getIndex().getName(), (Object)((Integer)IndexFeatureStore.STORE_VERSION_PROP.get(index.getSettings())));
        }
        return null;
    }

    protected ClusterBlockException checkBlock(ListStoresAction.ListStoresActionRequest request, ClusterState state) {
        return null;
    }
}

