/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.soap.client.messaging;

import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.InOutOperationContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.messaging.context.navigate.ContextDataLookupFunction;
import org.opensaml.messaging.context.navigate.RecursiveTypedParentContextLookup;
import org.opensaml.soap.client.SOAPClientContext;
import org.slf4j.Logger;

public class SOAPClientPipelineNameMappingFunction<T>
implements Function<MessageContext, T> {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(SOAPClientPipelineNameMappingFunction.class);
    @Nonnull
    private Function<MessageContext, SOAPClientContext> soapClientContextLookup;
    @Nonnull
    private Map<String, Function<MessageContext, T>> delegateMap;

    public SOAPClientPipelineNameMappingFunction(@Nonnull @ParameterName(name="mappings") Map<String, Function<MessageContext, T>> mappings) {
        this(mappings, null);
    }

    public SOAPClientPipelineNameMappingFunction(@Nonnull @ParameterName(name="mappings") Map<String, Function<MessageContext, T>> mappings, @Nullable @ParameterName(name="lookupStrategy") ContextDataLookupFunction<MessageContext, SOAPClientContext> lookupStrategy) {
        this.delegateMap = CollectionSupport.copyToMap(Constraint.isNotNull(mappings, "Delegate mappings may not be null"));
        this.soapClientContextLookup = lookupStrategy != null ? lookupStrategy : new ChildContextLookup(SOAPClientContext.class).compose(new RecursiveTypedParentContextLookup(InOutOperationContext.class));
    }

    @Override
    public T apply(@Nullable MessageContext input) {
        if (input == null) {
            return null;
        }
        SOAPClientContext clientContext = this.soapClientContextLookup.apply(input);
        if (clientContext != null && clientContext.getPipelineName() != null) {
            this.log.debug("Resolved SOAP client pipeline name: {}", (Object)clientContext.getPipelineName());
            Function<MessageContext, MessageContext> delegate = this.delegateMap.get(clientContext.getPipelineName());
            this.log.debug("Resolved delegate function: {}", (Object)(delegate != null ? delegate.getClass().getName() : "null"));
            if (delegate != null) {
                return delegate.apply(input);
            }
        }
        this.log.debug("No delegate function could be resolved, returning null");
        return null;
    }
}

