/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.materialproviders;

import Wrappers_Compile.Result;
import dafny.TypeDescriptor;
import java.util.Objects;
import software.amazon.awssdk.services.kms.KmsClient;
import software.amazon.cryptography.materialproviders.ToDafny;
import software.amazon.cryptography.materialproviders.ToNative;
import software.amazon.cryptography.materialproviders.internaldafny.types.Error;
import software.amazon.cryptography.materialproviders.internaldafny.types.IClientSupplier;
import software.amazon.cryptography.materialproviders.model.GetClientInput;
import software.amazon.cryptography.services.kms.internaldafny.Shim;
import software.amazon.cryptography.services.kms.internaldafny.types.IKMSClient;

public final class ClientSupplier
implements software.amazon.cryptography.materialproviders.IClientSupplier {
    private final IClientSupplier _impl;

    private ClientSupplier(IClientSupplier iClientSupplier) {
        Objects.requireNonNull(iClientSupplier, "Missing value for required argument `iClientSupplier`");
        this._impl = iClientSupplier;
    }

    public static ClientSupplier wrap(IClientSupplier iClientSupplier) {
        return new ClientSupplier(iClientSupplier);
    }

    public static <I extends software.amazon.cryptography.materialproviders.IClientSupplier> ClientSupplier wrap(I iClientSupplier) {
        Objects.requireNonNull(iClientSupplier, "Missing value for required argument `iClientSupplier`");
        if (iClientSupplier instanceof ClientSupplier) {
            return (ClientSupplier)iClientSupplier;
        }
        return ClientSupplier.wrap(new NativeWrapper(iClientSupplier));
    }

    public IClientSupplier impl() {
        return this._impl;
    }

    @Override
    public KmsClient GetClient(GetClientInput input) {
        software.amazon.cryptography.materialproviders.internaldafny.types.GetClientInput dafnyValue = ToDafny.GetClientInput(input);
        Result<IKMSClient, Error> result = this._impl.GetClient(dafnyValue);
        if (result.is_Failure()) {
            throw ToNative.Error(result.dtor_error());
        }
        return software.amazon.cryptography.services.kms.internaldafny.ToNative.TrentService(result.dtor_value());
    }

    protected static final class NativeWrapper
    implements IClientSupplier {
        protected final software.amazon.cryptography.materialproviders.IClientSupplier _impl;

        NativeWrapper(software.amazon.cryptography.materialproviders.IClientSupplier nativeImpl) {
            if (nativeImpl instanceof ClientSupplier) {
                throw new IllegalArgumentException("Recursive wrapping is strictly forbidden.");
            }
            this._impl = nativeImpl;
        }

        @Override
        public Result<IKMSClient, Error> GetClient(software.amazon.cryptography.materialproviders.internaldafny.types.GetClientInput dafnyInput) {
            try {
                GetClientInput nativeInput = ToNative.GetClientInput(dafnyInput);
                KmsClient nativeOutput = this._impl.GetClient(nativeInput);
                Shim dafnyOutput = new Shim(nativeOutput, null);
                return Result.create_Success(TypeDescriptor.reference(IKMSClient.class), Error._typeDescriptor(), dafnyOutput);
            }
            catch (RuntimeException ex) {
                return Result.create_Failure(TypeDescriptor.reference(IKMSClient.class), Error._typeDescriptor(), ToDafny.Error(ex));
            }
        }

        @Override
        public Result<IKMSClient, Error> GetClient_k(software.amazon.cryptography.materialproviders.internaldafny.types.GetClientInput dafnyInput) {
            throw new RuntimeException("Not supported at this time.");
        }
    }
}

