/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.request;

import java.util.List;
import org.json.JSONObject;
import org.opensearch.sql.legacy.request.SqlRequest;

public class PreparedStatementRequest
extends SqlRequest {
    private final List<PreparedStatementParameter> parameters;
    private final String sqlTemplate;

    public PreparedStatementRequest(String sql, JSONObject payloadJson, List<PreparedStatementParameter> parameters) {
        super(null, payloadJson);
        this.sqlTemplate = sql;
        this.parameters = parameters;
        this.sql = this.substituteParameters();
    }

    public PreparedStatementRequest(String sql, Integer fetchSize, JSONObject payloadJson, List<PreparedStatementParameter> parameters) {
        this(sql, payloadJson, parameters);
        this.fetchSize = fetchSize;
    }

    public List<PreparedStatementParameter> getParameters() {
        return this.parameters;
    }

    @Override
    public String getSql() {
        return this.sql;
    }

    public String getPreparedStatement() {
        return this.sqlTemplate;
    }

    private String substituteParameters() {
        if (this.sqlTemplate == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        int paramIndex = 0;
        block0: for (int i = 0; i < this.sqlTemplate.length(); ++i) {
            char c = this.sqlTemplate.charAt(i);
            if (c == '\'') {
                sb.append(c);
                ++i;
                while (i < this.sqlTemplate.length()) {
                    char s = this.sqlTemplate.charAt(i);
                    sb.append(s);
                    if (s == '\'') {
                        if (this.sqlTemplate.charAt(i - 1) == '\\') {
                            ++i;
                            continue;
                        }
                        if (i + 1 >= this.sqlTemplate.length() || this.sqlTemplate.charAt(i + 1) != '\'') continue block0;
                        sb.append('\'');
                        i += 2;
                        continue;
                    }
                    ++i;
                }
                continue;
            }
            if (c == '?') {
                if (paramIndex >= this.parameters.size()) {
                    throw new IllegalStateException("Placeholder count is greater than parameter number " + this.parameters.size() + " . Cannot convert PreparedStatement to sql query");
                }
                sb.append(this.parameters.get(paramIndex).getSqlSubstitutionValue());
                ++paramIndex;
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static class PreparedStatementParameter<T> {
        protected final T value;

        public PreparedStatementParameter(T value) {
            this.value = value;
        }

        public String getSqlSubstitutionValue() {
            return String.valueOf(this.value);
        }

        public T getValue() {
            return this.value;
        }
    }

    public static class NullParameter
    extends PreparedStatementParameter {
        public NullParameter() {
            super(null);
        }

        @Override
        public String getSqlSubstitutionValue() {
            return "null";
        }
    }

    public static class StringParameter
    extends PreparedStatementParameter<String> {
        public StringParameter(String value) {
            super(value);
        }

        @Override
        public String getSqlSubstitutionValue() {
            if (this.value == null) {
                return "null";
            }
            StringBuilder sb = new StringBuilder();
            sb.append('\'');
            block8: for (int i = 0; i < ((String)this.value).length(); ++i) {
                char c = ((String)this.value).charAt(i);
                switch (c) {
                    case '\u0000': {
                        sb.append('\\').append(0);
                        continue block8;
                    }
                    case '\n': {
                        sb.append('\\').append('n');
                        continue block8;
                    }
                    case '\r': {
                        sb.append('\\').append('r');
                        continue block8;
                    }
                    case '\\': {
                        sb.append('\\').append('\\');
                        continue block8;
                    }
                    case '\'': {
                        sb.append('\\').append('\'');
                        continue block8;
                    }
                    case '\"': {
                        sb.append('\\').append('\"');
                        continue block8;
                    }
                    default: {
                        sb.append(c);
                    }
                }
            }
            sb.append('\'');
            return sb.toString();
        }
    }

    public static enum ParameterType {
        BYTE,
        SHORT,
        INTEGER,
        LONG,
        FLOAT,
        DOUBLE,
        BOOLEAN,
        STRING,
        KEYWORD,
        DATE,
        NULL;

    }
}

