/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.operator.convert;

import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.opensearch.sql.data.model.ExprBooleanValue;
import org.opensearch.sql.data.model.ExprByteValue;
import org.opensearch.sql.data.model.ExprDateValue;
import org.opensearch.sql.data.model.ExprDoubleValue;
import org.opensearch.sql.data.model.ExprFloatValue;
import org.opensearch.sql.data.model.ExprIntegerValue;
import org.opensearch.sql.data.model.ExprIpValue;
import org.opensearch.sql.data.model.ExprLongValue;
import org.opensearch.sql.data.model.ExprShortValue;
import org.opensearch.sql.data.model.ExprStringValue;
import org.opensearch.sql.data.model.ExprTimeValue;
import org.opensearch.sql.data.model.ExprTimestampValue;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.expression.function.BuiltinFunctionName;
import org.opensearch.sql.expression.function.BuiltinFunctionRepository;
import org.opensearch.sql.expression.function.DefaultFunctionResolver;
import org.opensearch.sql.expression.function.FunctionDSL;
import org.opensearch.sql.expression.function.FunctionProperties;
import org.opensearch.sql.utils.JsonUtils;

public final class TypeCastOperators {
    public static void register(BuiltinFunctionRepository repository) {
        repository.register(TypeCastOperators.castToString());
        repository.register(TypeCastOperators.castToByte());
        repository.register(TypeCastOperators.castToShort());
        repository.register(TypeCastOperators.castToInt());
        repository.register(TypeCastOperators.castToLong());
        repository.register(TypeCastOperators.castToFloat());
        repository.register(TypeCastOperators.castToDouble());
        repository.register(TypeCastOperators.castToBoolean());
        repository.register(TypeCastOperators.castToIp());
        repository.register(TypeCastOperators.castToJson());
        repository.register(TypeCastOperators.castToDate());
        repository.register(TypeCastOperators.castToTime());
        repository.register(TypeCastOperators.castToTimestamp());
    }

    private static DefaultFunctionResolver castToString() {
        return FunctionDSL.define(BuiltinFunctionName.CAST_TO_STRING.getName(), Stream.concat(Arrays.asList(ExprCoreType.BYTE, ExprCoreType.SHORT, ExprCoreType.INTEGER, ExprCoreType.LONG, ExprCoreType.FLOAT, ExprCoreType.DOUBLE, ExprCoreType.BOOLEAN, ExprCoreType.TIME, ExprCoreType.DATE, ExprCoreType.TIMESTAMP).stream().map(type -> FunctionDSL.impl(FunctionDSL.nullMissingHandling(v -> new ExprStringValue(v.value().toString())), ExprCoreType.STRING, type)), Stream.of(FunctionDSL.impl(FunctionDSL.nullMissingHandling(v -> v), ExprCoreType.STRING, ExprCoreType.STRING))).collect(Collectors.toList()));
    }

    private static DefaultFunctionResolver castToByte() {
        return FunctionDSL.define(BuiltinFunctionName.CAST_TO_BYTE.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(v -> new ExprByteValue(Byte.valueOf(v.stringValue()))), ExprCoreType.BYTE, ExprCoreType.STRING), FunctionDSL.impl(FunctionDSL.nullMissingHandling(v -> new ExprByteValue(v.byteValue())), ExprCoreType.BYTE, ExprCoreType.DOUBLE), FunctionDSL.impl(FunctionDSL.nullMissingHandling(v -> new ExprByteValue(v.booleanValue() != false ? 1 : 0)), ExprCoreType.BYTE, ExprCoreType.BOOLEAN));
    }

    private static DefaultFunctionResolver castToShort() {
        return FunctionDSL.define(BuiltinFunctionName.CAST_TO_SHORT.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(v -> new ExprShortValue(Short.valueOf(v.stringValue()))), ExprCoreType.SHORT, ExprCoreType.STRING), FunctionDSL.impl(FunctionDSL.nullMissingHandling(v -> new ExprShortValue(v.shortValue())), ExprCoreType.SHORT, ExprCoreType.DOUBLE), FunctionDSL.impl(FunctionDSL.nullMissingHandling(v -> new ExprShortValue(v.booleanValue() != false ? 1 : 0)), ExprCoreType.SHORT, ExprCoreType.BOOLEAN), FunctionDSL.impl(FunctionDSL.nullMissingHandling(v -> v), ExprCoreType.SHORT, ExprCoreType.UNDEFINED));
    }

    private static DefaultFunctionResolver castToInt() {
        return FunctionDSL.define(BuiltinFunctionName.CAST_TO_INT.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(v -> new ExprIntegerValue(Integer.valueOf(v.stringValue()))), ExprCoreType.INTEGER, ExprCoreType.STRING), FunctionDSL.impl(FunctionDSL.nullMissingHandling(v -> new ExprIntegerValue(v.integerValue())), ExprCoreType.INTEGER, ExprCoreType.DOUBLE), FunctionDSL.impl(FunctionDSL.nullMissingHandling(v -> new ExprIntegerValue(v.booleanValue() != false ? 1 : 0)), ExprCoreType.INTEGER, ExprCoreType.BOOLEAN), FunctionDSL.impl(FunctionDSL.nullMissingHandling(v -> v), ExprCoreType.INTEGER, ExprCoreType.UNDEFINED));
    }

    private static DefaultFunctionResolver castToLong() {
        return FunctionDSL.define(BuiltinFunctionName.CAST_TO_LONG.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(v -> new ExprLongValue(Long.valueOf(v.stringValue()))), ExprCoreType.LONG, ExprCoreType.STRING), FunctionDSL.impl(FunctionDSL.nullMissingHandling(v -> new ExprLongValue(v.longValue())), ExprCoreType.LONG, ExprCoreType.DOUBLE), FunctionDSL.impl(FunctionDSL.nullMissingHandling(v -> new ExprLongValue(v.booleanValue() != false ? 1L : 0L)), ExprCoreType.LONG, ExprCoreType.BOOLEAN), FunctionDSL.impl(FunctionDSL.nullMissingHandling(v -> v), ExprCoreType.LONG, ExprCoreType.UNDEFINED));
    }

    private static DefaultFunctionResolver castToFloat() {
        return FunctionDSL.define(BuiltinFunctionName.CAST_TO_FLOAT.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(v -> new ExprFloatValue(Float.valueOf(v.stringValue()))), ExprCoreType.FLOAT, ExprCoreType.STRING), FunctionDSL.impl(FunctionDSL.nullMissingHandling(v -> new ExprFloatValue(v.floatValue())), ExprCoreType.FLOAT, ExprCoreType.DOUBLE), FunctionDSL.impl(FunctionDSL.nullMissingHandling(v -> new ExprFloatValue(Float.valueOf(v.booleanValue() != false ? 1.0f : 0.0f))), ExprCoreType.FLOAT, ExprCoreType.BOOLEAN), FunctionDSL.impl(FunctionDSL.nullMissingHandling(v -> v), ExprCoreType.FLOAT, ExprCoreType.UNDEFINED));
    }

    private static DefaultFunctionResolver castToDouble() {
        return FunctionDSL.define(BuiltinFunctionName.CAST_TO_DOUBLE.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(v -> new ExprDoubleValue(Double.valueOf(v.stringValue()))), ExprCoreType.DOUBLE, ExprCoreType.STRING), FunctionDSL.impl(FunctionDSL.nullMissingHandling(v -> new ExprDoubleValue(v.doubleValue())), ExprCoreType.DOUBLE, ExprCoreType.DOUBLE), FunctionDSL.impl(FunctionDSL.nullMissingHandling(v -> new ExprDoubleValue(v.booleanValue() != false ? 1.0 : 0.0)), ExprCoreType.DOUBLE, ExprCoreType.BOOLEAN), FunctionDSL.impl(FunctionDSL.nullMissingHandling(v -> v), ExprCoreType.DOUBLE, ExprCoreType.UNDEFINED));
    }

    private static DefaultFunctionResolver castToBoolean() {
        return FunctionDSL.define(BuiltinFunctionName.CAST_TO_BOOLEAN.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(v -> ExprBooleanValue.of(Boolean.valueOf(v.stringValue()))), ExprCoreType.BOOLEAN, ExprCoreType.STRING), FunctionDSL.impl(FunctionDSL.nullMissingHandling(v -> ExprBooleanValue.of(v.doubleValue() != 0.0)), ExprCoreType.BOOLEAN, ExprCoreType.DOUBLE), FunctionDSL.impl(FunctionDSL.nullMissingHandling(v -> v), ExprCoreType.BOOLEAN, ExprCoreType.BOOLEAN), FunctionDSL.impl(FunctionDSL.nullMissingHandling(v -> v), ExprCoreType.BOOLEAN, ExprCoreType.UNDEFINED));
    }

    private static DefaultFunctionResolver castToIp() {
        return FunctionDSL.define(BuiltinFunctionName.CAST_TO_IP.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(v -> new ExprIpValue(v.stringValue())), ExprCoreType.IP, ExprCoreType.STRING), FunctionDSL.impl(FunctionDSL.nullMissingHandling(v -> v), ExprCoreType.IP, ExprCoreType.IP));
    }

    private static DefaultFunctionResolver castToJson() {
        return FunctionDSL.define(BuiltinFunctionName.CAST_TO_JSON.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(JsonUtils::castJson), ExprCoreType.UNDEFINED, ExprCoreType.STRING));
    }

    private static DefaultFunctionResolver castToDate() {
        return FunctionDSL.define(BuiltinFunctionName.CAST_TO_DATE.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(v -> new ExprDateValue(v.stringValue())), ExprCoreType.DATE, ExprCoreType.STRING), FunctionDSL.impl(FunctionDSL.nullMissingHandling(v -> new ExprDateValue(v.dateValue())), ExprCoreType.DATE, ExprCoreType.TIMESTAMP), FunctionDSL.impl(FunctionDSL.nullMissingHandling(v -> v), ExprCoreType.DATE, ExprCoreType.DATE));
    }

    private static DefaultFunctionResolver castToTime() {
        return FunctionDSL.define(BuiltinFunctionName.CAST_TO_TIME.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(v -> new ExprTimeValue(v.stringValue())), ExprCoreType.TIME, ExprCoreType.STRING), FunctionDSL.impl(FunctionDSL.nullMissingHandling(v -> new ExprTimeValue(v.timeValue())), ExprCoreType.TIME, ExprCoreType.TIMESTAMP), FunctionDSL.impl(FunctionDSL.nullMissingHandling(v -> v), ExprCoreType.TIME, ExprCoreType.TIME));
    }

    private static DefaultFunctionResolver castToTimestamp() {
        return FunctionDSL.define(BuiltinFunctionName.CAST_TO_TIMESTAMP.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(v -> new ExprTimestampValue(v.stringValue())), ExprCoreType.TIMESTAMP, ExprCoreType.STRING), FunctionDSL.impl(FunctionDSL.nullMissingHandling(v -> new ExprTimestampValue(v.timestampValue())), ExprCoreType.TIMESTAMP, ExprCoreType.DATE), FunctionDSL.implWithProperties(FunctionDSL.nullMissingHandlingWithProperties((fp, v) -> new ExprTimestampValue(((ExprTimeValue)v).timestampValue((FunctionProperties)fp))), ExprCoreType.TIMESTAMP, ExprCoreType.TIME), FunctionDSL.impl(FunctionDSL.nullMissingHandling(v -> v), ExprCoreType.TIMESTAMP, ExprCoreType.TIMESTAMP));
    }

    @Generated
    private TypeCastOperators() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

