/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.plugin.insights.core.reader;

import java.io.IOException;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.plugin.insights.core.reader.LocalIndexReader;
import org.opensearch.plugin.insights.core.reader.QueryInsightsReader;
import org.opensearch.transport.client.Client;

public class QueryInsightsReaderFactory {
    private final Logger logger = LogManager.getLogger();
    private final Client client;
    private final Map<String, QueryInsightsReader> readers;

    public QueryInsightsReaderFactory(Client client) {
        this.client = client;
        this.readers = new HashMap<String, QueryInsightsReader>();
    }

    public QueryInsightsReader createLocalIndexReader(String id, String indexPattern, NamedXContentRegistry namedXContentRegistry) {
        LocalIndexReader reader = new LocalIndexReader(this.client, DateTimeFormatter.ofPattern(indexPattern, Locale.ROOT), namedXContentRegistry, id);
        this.readers.put(id, reader);
        return reader;
    }

    public QueryInsightsReader updateReader(QueryInsightsReader reader, String indexPattern) {
        if (reader.getClass() == LocalIndexReader.class) {
            ((LocalIndexReader)reader).setIndexPattern(DateTimeFormatter.ofPattern(indexPattern, Locale.ROOT));
        }
        return reader;
    }

    public QueryInsightsReader getReader(String id) {
        return this.readers.get(id);
    }

    public void closeReader(QueryInsightsReader reader) throws IOException {
        if (reader != null) {
            reader.close();
            this.readers.remove(reader.getId());
        }
    }

    public void closeAllReaders() {
        for (QueryInsightsReader reader : this.readers.values()) {
            try {
                this.closeReader(reader);
            }
            catch (IOException e) {
                this.logger.error("Fail to close query insights reader, error: ", (Throwable)e);
            }
        }
    }
}

