/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler;

import com.codahale.metrics.Timer;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.exc.UnrecognizedPropertyException;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.spark.SparkEnv;
import org.apache.spark.internal.Logging;
import org.apache.spark.scheduler.HaltReplayException;
import org.apache.spark.scheduler.ReplayListenerBus$;
import org.apache.spark.scheduler.SparkListenerBus;
import org.apache.spark.scheduler.SparkListenerEvent;
import org.apache.spark.scheduler.SparkListenerInterface;
import org.apache.spark.util.JsonProtocol$;
import org.apache.spark.util.ListenerBus;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashSet;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0005=a!B\u0007\u000f\u0001A1\u0002\"B\u0014\u0001\t\u0003I\u0003\"B\u0016\u0001\t\u0003a\u0003b\u00022\u0001#\u0003%\ta\u0019\u0005\b]\u0002\t\n\u0011\"\u0001p\u0011\u0015Y\u0003\u0001\"\u0001r\u0011\u001d\t\t\u0001\u0001C)\u0003\u00079a!\u0016\b\t\u0002A1fAB\u0007\u000f\u0011\u0003\u0001r\u000bC\u0003(\u0011\u0011\u0005\u0001,\u0002\u0003Z\u0011\u0001Q\u0006bB/\t\u0005\u0004%\tA\u0018\u0005\u0007C\"\u0001\u000b\u0011B0\u0003#I+\u0007\u000f\\1z\u0019&\u001cH/\u001a8fe\n+8O\u0003\u0002\u0010!\u0005I1o\u00195fIVdWM\u001d\u0006\u0003#I\tQa\u001d9be.T!a\u0005\u000b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005)\u0012aA8sON!\u0001aF\u000f\"!\tA2$D\u0001\u001a\u0015\u0005Q\u0012!B:dC2\f\u0017B\u0001\u000f\u001a\u0005\u0019\te.\u001f*fMB\u0011adH\u0007\u0002\u001d%\u0011\u0001E\u0004\u0002\u0011'B\f'o\u001b'jgR,g.\u001a:CkN\u0004\"AI\u0013\u000e\u0003\rR!\u0001\n\t\u0002\u0011%tG/\u001a:oC2L!AJ\u0012\u0003\u000f1{wmZ5oO\u00061A(\u001b8jiz\u001a\u0001\u0001F\u0001+!\tq\u0002!\u0001\u0004sKBd\u0017-\u001f\u000b\u0006[ARt)\u0013\t\u000319J!aL\r\u0003\u000f\t{w\u000e\\3b]\")\u0011G\u0001a\u0001e\u00059An\\4ECR\f\u0007CA\u001a9\u001b\u0005!$BA\u001b7\u0003\tIwNC\u00018\u0003\u0011Q\u0017M^1\n\u0005e\"$aC%oaV$8\u000b\u001e:fC6DQa\u000f\u0002A\u0002q\n!b]8ve\u000e,g*Y7f!\tiDI\u0004\u0002?\u0005B\u0011q(G\u0007\u0002\u0001*\u0011\u0011\tK\u0001\u0007yI|w\u000e\u001e \n\u0005\rK\u0012A\u0002)sK\u0012,g-\u0003\u0002F\r\n11\u000b\u001e:j]\u001eT!aQ\r\t\u000f!\u0013\u0001\u0013!a\u0001[\u0005qQ.Y=cKR\u0013XO\\2bi\u0016$\u0007b\u0002&\u0003!\u0003\u0005\raS\u0001\rKZ,g\u000e^:GS2$XM\u001d\t\u0003\u0019*q!!T\u0004\u000f\u00059#fBA(T\u001d\t\u0001&K\u0004\u0002@#&\tQ#\u0003\u0002\u0014)%\u0011\u0011CE\u0005\u0003\u001fA\t\u0011CU3qY\u0006LH*[:uK:,'OQ;t!\tq\u0002b\u0005\u0002\t/Q\taK\u0001\nSKBd\u0017-_#wK:$8OR5mi\u0016\u0014\b\u0003\u0002\r\\y5J!\u0001X\r\u0003\u0013\u0019+hn\u0019;j_:\f\u0014!E*F\u0019\u0016\u001bEkX!M\u0019~3\u0015\n\u0014+F%V\tq\f\u0005\u0002a\u00155\t\u0001\"\u0001\nT\u000b2+5\tV0B\u00192{f)\u0013'U\u000bJ\u0003\u0013\u0001\u0005:fa2\f\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00134+\u0005!'FA\u0017fW\u00051\u0007CA4m\u001b\u0005A'BA5k\u0003%)hn\u00195fG.,GM\u0003\u0002l3\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u00055D'!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006\u0001\"/\u001a9mCf$C-\u001a4bk2$H\u0005N\u000b\u0002a*\u00121*\u001a\u000b\u0006[Ilhp \u0005\u0006g\u0016\u0001\r\u0001^\u0001\u0006Y&tWm\u001d\t\u0004kjddB\u0001<y\u001d\tyt/C\u0001\u001b\u0013\tI\u0018$A\u0004qC\u000e\\\u0017mZ3\n\u0005md(\u0001C%uKJ\fGo\u001c:\u000b\u0005eL\u0002\"B\u001e\u0006\u0001\u0004a\u0004\"\u0002%\u0006\u0001\u0004i\u0003\"\u0002&\u0006\u0001\u0004Y\u0015\u0001F5t\u0013\u001etwN]1cY\u0016,\u0005pY3qi&|g\u000eF\u0002.\u0003\u000bAq!a\u0002\u0007\u0001\u0004\tI!A\u0001f!\r)\u00181B\u0005\u0004\u0003\u001ba(!\u0003+ie><\u0018M\u00197f\u0001")
public class ReplayListenerBus
implements SparkListenerBus {
    private CopyOnWriteArrayList<Tuple2<SparkListenerInterface, Option<Timer>>> org$apache$spark$util$ListenerBus$$listenersPlusTimers;
    private SparkEnv org$apache$spark$util$ListenerBus$$env;
    private boolean org$apache$spark$util$ListenerBus$$logSlowEventEnabled;
    private long org$apache$spark$util$ListenerBus$$logSlowEventThreshold;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$0;

    public static Function1<String, Object> SELECT_ALL_FILTER() {
        return ReplayListenerBus$.MODULE$.SELECT_ALL_FILTER();
    }

    @Override
    public void doPostEvent(SparkListenerInterface listener, SparkListenerEvent event) {
        SparkListenerBus.doPostEvent$(this, listener, event);
    }

    @Override
    public List<SparkListenerInterface> listeners() {
        return ListenerBus.listeners$(this);
    }

    @Override
    public Option getTimer(Object listener) {
        return ListenerBus.getTimer$(this, listener);
    }

    @Override
    public final void addListener(Object listener) {
        ListenerBus.addListener$(this, listener);
    }

    @Override
    public final void removeListener(Object listener) {
        ListenerBus.removeListener$(this, listener);
    }

    @Override
    public final void removeAllListeners() {
        ListenerBus.removeAllListeners$(this);
    }

    @Override
    public void removeListenerOnError(Object listener) {
        ListenerBus.removeListenerOnError$(this, listener);
    }

    @Override
    public void postToAll(Object event) {
        ListenerBus.postToAll$(this, event);
    }

    @Override
    public <T extends SparkListenerInterface> Seq<T> findListenersByClass(ClassTag<T> evidence$1) {
        return ListenerBus.findListenersByClass$(this, evidence$1);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    @Override
    public CopyOnWriteArrayList<Tuple2<SparkListenerInterface, Option<Timer>>> org$apache$spark$util$ListenerBus$$listenersPlusTimers() {
        return this.org$apache$spark$util$ListenerBus$$listenersPlusTimers;
    }

    private SparkEnv org$apache$spark$util$ListenerBus$$env$lzycompute() {
        ReplayListenerBus replayListenerBus = this;
        synchronized (replayListenerBus) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.org$apache$spark$util$ListenerBus$$env = ListenerBus.org$apache$spark$util$ListenerBus$$env$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.org$apache$spark$util$ListenerBus$$env;
    }

    @Override
    public SparkEnv org$apache$spark$util$ListenerBus$$env() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.org$apache$spark$util$ListenerBus$$env$lzycompute() : this.org$apache$spark$util$ListenerBus$$env;
    }

    private boolean org$apache$spark$util$ListenerBus$$logSlowEventEnabled$lzycompute() {
        ReplayListenerBus replayListenerBus = this;
        synchronized (replayListenerBus) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.org$apache$spark$util$ListenerBus$$logSlowEventEnabled = ListenerBus.org$apache$spark$util$ListenerBus$$logSlowEventEnabled$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.org$apache$spark$util$ListenerBus$$logSlowEventEnabled;
    }

    @Override
    public boolean org$apache$spark$util$ListenerBus$$logSlowEventEnabled() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.org$apache$spark$util$ListenerBus$$logSlowEventEnabled$lzycompute() : this.org$apache$spark$util$ListenerBus$$logSlowEventEnabled;
    }

    private long org$apache$spark$util$ListenerBus$$logSlowEventThreshold$lzycompute() {
        ReplayListenerBus replayListenerBus = this;
        synchronized (replayListenerBus) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.org$apache$spark$util$ListenerBus$$logSlowEventThreshold = ListenerBus.org$apache$spark$util$ListenerBus$$logSlowEventThreshold$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.org$apache$spark$util$ListenerBus$$logSlowEventThreshold;
    }

    @Override
    public long org$apache$spark$util$ListenerBus$$logSlowEventThreshold() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.org$apache$spark$util$ListenerBus$$logSlowEventThreshold$lzycompute() : this.org$apache$spark$util$ListenerBus$$logSlowEventThreshold;
    }

    @Override
    public final void org$apache$spark$util$ListenerBus$_setter_$org$apache$spark$util$ListenerBus$$listenersPlusTimers_$eq(CopyOnWriteArrayList<Tuple2<SparkListenerInterface, Option<Timer>>> x$1) {
        this.org$apache$spark$util$ListenerBus$$listenersPlusTimers = x$1;
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public boolean replay(InputStream logData, String sourceName, boolean maybeTruncated, Function1<String, Object> eventsFilter) {
        Iterator lines = Source$.MODULE$.fromInputStream(logData, Codec$.MODULE$.UTF8()).getLines();
        return this.replay((Iterator<String>)lines, sourceName, maybeTruncated, eventsFilter);
    }

    public boolean replay(Iterator<String> lines, String sourceName, boolean maybeTruncated, Function1<String, Object> eventsFilter) {
        boolean bl;
        ObjectRef currentLine = ObjectRef.create(null);
        IntRef lineNumber = IntRef.create((int)0);
        HashSet unrecognizedEvents = new HashSet();
        HashSet unrecognizedProperties = new HashSet();
        try {
            Iterator lineEntries = lines.zipWithIndex().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ReplayListenerBus.$anonfun$replay$1(eventsFilter, x0$1)));
            while (lineEntries.hasNext()) {
                try {
                    Tuple2 entry = (Tuple2)lineEntries.next();
                    currentLine.elem = (String)entry._1();
                    lineNumber.elem = entry._2$mcI$sp() + 1;
                    this.postToAll(JsonProtocol$.MODULE$.sparkEventFromJson((String)currentLine.elem));
                }
                catch (ClassNotFoundException e) {
                    Object object;
                    if (!unrecognizedEvents.contains((Object)e.getMessage())) {
                        this.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(25).append("Drop unrecognized event: ").append(e.getMessage()).toString());
                        object = BoxesRunTime.boxToBoolean((boolean)unrecognizedEvents.add((Object)e.getMessage()));
                    } else {
                        object = BoxedUnit.UNIT;
                    }
                    this.logDebug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(29).append("Drop incompatible event log: ").append((String)currentLine$1.elem).toString());
                }
                catch (UnrecognizedPropertyException e) {
                    Object object;
                    if (!unrecognizedProperties.contains((Object)e.getMessage())) {
                        this.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(28).append("Drop unrecognized property: ").append(e.getMessage()).toString());
                        object = BoxesRunTime.boxToBoolean((boolean)unrecognizedProperties.add((Object)e.getMessage()));
                    } else {
                        object = BoxedUnit.UNIT;
                    }
                    this.logDebug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(29).append("Drop incompatible event log: ").append((String)currentLine$1.elem).toString());
                }
                catch (JsonParseException jpe) {
                    if (!maybeTruncated || lineEntries.hasNext()) {
                        throw jpe;
                    }
                    this.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(37).append("Got JsonParseException from log file ").append(sourceName).toString()).append(new StringBuilder(60).append(" at line ").append(lineNumber$1.elem).append(", the file might not have finished writing cleanly.").toString()).toString());
                }
            }
            bl = true;
        }
        catch (Throwable throwable) {
            boolean bl2;
            Throwable throwable2 = throwable;
            if (throwable2 instanceof HaltReplayException) {
                bl2 = false;
            } else if (throwable2 instanceof EOFException && maybeTruncated) {
                bl2 = false;
            } else {
                if (throwable2 instanceof IOException) {
                    IOException iOException = (IOException)throwable2;
                    throw iOException;
                }
                if (throwable2 instanceof Exception) {
                    Exception exception = (Exception)throwable2;
                    this.logError((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(35).append("Exception parsing Spark event log: ").append(sourceName).toString(), exception);
                    this.logError((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(19).append("Malformed line #").append(lineNumber$1.elem).append(": ").append((String)currentLine$1.elem).append("\n").toString());
                    bl2 = false;
                } else {
                    throw throwable;
                }
            }
            bl = bl2;
        }
        return bl;
    }

    public boolean replay$default$3() {
        return false;
    }

    public Function1<String, Object> replay$default$4() {
        return ReplayListenerBus$.MODULE$.SELECT_ALL_FILTER();
    }

    @Override
    public boolean isIgnorableException(Throwable e) {
        return e instanceof HaltReplayException;
    }

    public static final /* synthetic */ boolean $anonfun$replay$1(Function1 eventsFilter$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String line = (String)tuple2._1();
        boolean bl = BoxesRunTime.unboxToBoolean((Object)eventsFilter$1.apply((Object)line));
        return bl;
    }

    public ReplayListenerBus() {
        Logging.$init$((Logging)this);
        ListenerBus.$init$(this);
        SparkListenerBus.$init$(this);
        Statics.releaseFence();
    }
}

