/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.searchrelevance.transport.stats;

import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.opensearch.action.FailedNodeException;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.nodes.TransportNodesAction;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.searchrelevance.stats.common.StatSnapshot;
import org.opensearch.searchrelevance.stats.events.EventStatName;
import org.opensearch.searchrelevance.stats.events.EventStatsManager;
import org.opensearch.searchrelevance.stats.events.TimestampedEventStatSnapshot;
import org.opensearch.searchrelevance.stats.info.InfoStatName;
import org.opensearch.searchrelevance.stats.info.InfoStatsManager;
import org.opensearch.searchrelevance.transport.stats.SearchRelevanceStatsNodeRequest;
import org.opensearch.searchrelevance.transport.stats.SearchRelevanceStatsNodeResponse;
import org.opensearch.searchrelevance.transport.stats.SearchRelevanceStatsRequest;
import org.opensearch.searchrelevance.transport.stats.SearchRelevanceStatsResponse;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;

public class SearchRelevanceStatsTransportAction
extends TransportNodesAction<SearchRelevanceStatsRequest, SearchRelevanceStatsResponse, SearchRelevanceStatsNodeRequest, SearchRelevanceStatsNodeResponse> {
    private final EventStatsManager eventStatsManager;
    private final InfoStatsManager infoStatsManager;

    @Inject
    public SearchRelevanceStatsTransportAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, EventStatsManager eventStatsManager, InfoStatsManager infoStatsManager) {
        super("cluster:admin/search_relevance_stats_action", threadPool, clusterService, transportService, actionFilters, SearchRelevanceStatsRequest::new, SearchRelevanceStatsNodeRequest::new, "management", SearchRelevanceStatsNodeResponse.class);
        this.eventStatsManager = eventStatsManager;
        this.infoStatsManager = infoStatsManager;
    }

    protected SearchRelevanceStatsResponse newResponse(SearchRelevanceStatsRequest request, List<SearchRelevanceStatsNodeResponse> responses, List<FailedNodeException> failures) {
        Map<String, Map<String, StatSnapshot<?>>> nodeIdToEventStats = this.processorNodeEventStatsIntoMap(responses);
        Map<String, StatSnapshot<?>> aggregatedNodeStats = Collections.emptyMap();
        if (request.getSearchRelevanceStatsInput().isIncludeAllNodes()) {
            aggregatedNodeStats = this.aggregateNodesResponses(responses, request.getSearchRelevanceStatsInput().getEventStatNames());
        }
        Map<String, StatSnapshot<Object>> flatInfoStats = Collections.emptyMap();
        if (request.getSearchRelevanceStatsInput().isIncludeInfo()) {
            Map<InfoStatName, StatSnapshot<?>> infoStats = this.infoStatsManager.getStats(request.getSearchRelevanceStatsInput().getInfoStatNames());
            flatInfoStats = infoStats.entrySet().stream().collect(Collectors.toMap(entry -> ((InfoStatName)entry.getKey()).getFullPath(), Map.Entry::getValue));
        }
        return new SearchRelevanceStatsResponse(this.clusterService.getClusterName(), responses, failures, flatInfoStats, aggregatedNodeStats, nodeIdToEventStats, request.getSearchRelevanceStatsInput().isFlatten(), request.getSearchRelevanceStatsInput().isIncludeMetadata(), request.getSearchRelevanceStatsInput().isIncludeIndividualNodes(), request.getSearchRelevanceStatsInput().isIncludeAllNodes(), request.getSearchRelevanceStatsInput().isIncludeInfo());
    }

    protected SearchRelevanceStatsNodeRequest newNodeRequest(SearchRelevanceStatsRequest request) {
        return new SearchRelevanceStatsNodeRequest(request);
    }

    protected SearchRelevanceStatsNodeResponse newNodeResponse(StreamInput in) throws IOException {
        return new SearchRelevanceStatsNodeResponse(in);
    }

    protected SearchRelevanceStatsNodeResponse nodeOperation(SearchRelevanceStatsNodeRequest request) {
        EnumSet<EventStatName> eventStatsToRetrieve = request.getRequest().getSearchRelevanceStatsInput().getEventStatNames();
        Map<EventStatName, TimestampedEventStatSnapshot> eventStatDataMap = this.eventStatsManager.getTimestampedEventStatSnapshots(eventStatsToRetrieve);
        return new SearchRelevanceStatsNodeResponse(this.clusterService.localNode(), eventStatDataMap);
    }

    private Map<String, StatSnapshot<?>> aggregateNodesResponses(List<SearchRelevanceStatsNodeResponse> responses, EnumSet<EventStatName> statsToRetrieve) {
        if (responses == null || responses.isEmpty()) {
            return new HashMap();
        }
        List<Map> nodeEventStatsList = responses.stream().map(SearchRelevanceStatsNodeResponse::getStats).map(map -> map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))).toList();
        HashMap aggregatedMap = new HashMap();
        for (EventStatName eventStatName : statsToRetrieve) {
            HashSet<TimestampedEventStatSnapshot> timestampedEventStatSnapshotCollection = new HashSet<TimestampedEventStatSnapshot>();
            for (Map eventStats : nodeEventStatsList) {
                timestampedEventStatSnapshotCollection.add((TimestampedEventStatSnapshot)eventStats.get(eventStatName));
            }
            TimestampedEventStatSnapshot aggregatedEventSnapshots = TimestampedEventStatSnapshot.aggregateEventStatSnapshots(timestampedEventStatSnapshotCollection);
            if (aggregatedEventSnapshots == null) continue;
            aggregatedMap.put(eventStatName.getFullPath(), aggregatedEventSnapshots);
        }
        return aggregatedMap;
    }

    private Map<String, Map<String, StatSnapshot<?>>> processorNodeEventStatsIntoMap(List<SearchRelevanceStatsNodeResponse> nodeResponses) {
        HashMap results = new HashMap();
        for (SearchRelevanceStatsNodeResponse nodesResponse : nodeResponses) {
            String nodeId = nodesResponse.getNode().getId();
            Map<String, StatSnapshot> resultNodeStatsMap = nodesResponse.getStats().entrySet().stream().collect(Collectors.toMap(entry -> ((EventStatName)entry.getKey()).getFullPath(), Map.Entry::getValue));
            results.put(nodeId, resultNodeStatsMap);
        }
        return results;
    }
}

