/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.searchrelevance.stats.events;

import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.opensearch.Version;
import org.opensearch.searchrelevance.stats.common.StatName;
import org.opensearch.searchrelevance.stats.events.EventStat;
import org.opensearch.searchrelevance.stats.events.EventStatType;
import org.opensearch.searchrelevance.stats.events.TimestampedEventStat;

public enum EventStatName implements StatName
{
    IMPORT_JUDGMENT_RATING_GENERATIONS("import_judgment_rating_generations", "judgments", EventStatType.TIMESTAMPED_EVENT_COUNTER, Version.V_3_1_0),
    LLM_JUDGMENT_RATING_GENERATIONS("llm_judgment_rating_generations", "judgments", EventStatType.TIMESTAMPED_EVENT_COUNTER, Version.V_3_1_0),
    UBI_JUDGMENT_RATING_GENERATIONS("ubi_judgment_rating_generations", "judgments", EventStatType.TIMESTAMPED_EVENT_COUNTER, Version.V_3_1_0),
    EXPERIMENT_EXECUTIONS("experiment_executions", "experiments", EventStatType.TIMESTAMPED_EVENT_COUNTER, Version.V_3_1_0),
    EXPERIMENT_PAIRWISE_COMPARISON_EXECUTIONS("experiment_pairwise_comparison_executions", "experiments", EventStatType.TIMESTAMPED_EVENT_COUNTER, Version.V_3_1_0),
    EXPERIMENT_POINTWISE_EVALUATION_EXECUTIONS("experiment_pointwise_evaluation_executions", "experiments", EventStatType.TIMESTAMPED_EVENT_COUNTER, Version.V_3_1_0),
    EXPERIMENT_HYBRID_OPTIMIZER_EXECUTIONS("experiment_hybrid_optimizer_executions", "experiments", EventStatType.TIMESTAMPED_EVENT_COUNTER, Version.V_3_1_0);

    private final String nameString;
    private final String path;
    private final EventStatType statType;
    private EventStat eventStat;
    private final Version version;
    private static final Map<String, EventStatName> BY_NAME;

    private EventStatName(String nameString, String path, EventStatType statType, Version version) {
        this.nameString = nameString;
        this.path = path;
        this.statType = statType;
        this.version = version;
        switch (statType) {
            case TIMESTAMPED_EVENT_COUNTER: {
                this.eventStat = new TimestampedEventStat(this);
            }
        }
        if (this.eventStat == null) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Unable to initialize event stat [%s]. Unrecognized event stat type: [%s]", nameString, statType));
        }
    }

    public static EventStatName from(String name) {
        if (!EventStatName.isValidName(name)) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Event stat not found: %s", name));
        }
        return BY_NAME.get(name);
    }

    @Override
    public String getFullPath() {
        if (this.path == null || this.path.isBlank()) {
            return this.nameString;
        }
        return String.join((CharSequence)".", this.path, this.nameString);
    }

    public static boolean isValidName(String name) {
        return BY_NAME.containsKey(name);
    }

    @Override
    public Version version() {
        return this.version;
    }

    public String toString() {
        return this.getNameString();
    }

    @Override
    @Generated
    public String getNameString() {
        return this.nameString;
    }

    @Generated
    public String getPath() {
        return this.path;
    }

    @Override
    @Generated
    public EventStatType getStatType() {
        return this.statType;
    }

    @Generated
    public EventStat getEventStat() {
        return this.eventStat;
    }

    @Generated
    public Version getVersion() {
        return this.version;
    }

    static {
        BY_NAME = Arrays.stream(EventStatName.values()).collect(Collectors.toMap(stat -> stat.nameString, stat -> stat));
    }
}

