/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.CollectionTerminatedException;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.packed.PackedLongValues;
import org.opensearch.common.util.BigArrays;
import org.opensearch.common.util.LongHash;
import org.opensearch.search.aggregations.Aggregator;
import org.opensearch.search.aggregations.BucketCollector;
import org.opensearch.search.aggregations.InternalAggregation;
import org.opensearch.search.aggregations.LeafBucketCollector;
import org.opensearch.search.aggregations.MultiBucketCollector;
import org.opensearch.search.aggregations.bucket.DeferringBucketCollector;
import org.opensearch.search.internal.SearchContext;

public class BestBucketsDeferringCollector
extends DeferringBucketCollector {
    protected List<Entry> entries = new ArrayList<Entry>();
    protected BucketCollector collector;
    protected final SearchContext searchContext;
    protected final boolean isGlobal;
    protected LeafReaderContext context;
    protected PackedLongValues.Builder docDeltasBuilder;
    protected PackedLongValues.Builder bucketsBuilder;
    protected long maxBucket = -1L;
    protected boolean finished;
    protected LongHash selectedBuckets;

    public BestBucketsDeferringCollector(SearchContext context, boolean isGlobal) {
        this.searchContext = context;
        this.isGlobal = isGlobal;
        this.finished = context.searcher().getLeafContexts().isEmpty();
    }

    public ScoreMode scoreMode() {
        if (this.collector == null) {
            throw new IllegalStateException();
        }
        return this.collector.scoreMode();
    }

    @Override
    public void setDeferredCollector(Iterable<BucketCollector> deferredCollectors) {
        this.collector = MultiBucketCollector.wrap(deferredCollectors);
    }

    private void finishLeaf() {
        if (this.context != null) {
            assert (this.docDeltasBuilder != null && this.bucketsBuilder != null);
            this.entries.add(new Entry(this.context, this.docDeltasBuilder.build(), this.bucketsBuilder.build()));
            this.context = null;
        }
    }

    @Override
    public LeafBucketCollector getLeafCollector(final LeafReaderContext ctx) throws IOException {
        this.finishLeaf();
        this.context = null;
        this.docDeltasBuilder = null;
        this.bucketsBuilder = null;
        return new LeafBucketCollector(this){
            int lastDoc = 0;
            final /* synthetic */ BestBucketsDeferringCollector this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void collect(int doc, long bucket) throws IOException {
                if (this.this$0.context == null) {
                    this.this$0.context = ctx;
                    this.this$0.docDeltasBuilder = PackedLongValues.packedBuilder((float)0.25f);
                    this.this$0.bucketsBuilder = PackedLongValues.packedBuilder((float)0.25f);
                }
                this.this$0.docDeltasBuilder.add((long)(doc - this.lastDoc));
                this.this$0.bucketsBuilder.add(bucket);
                this.lastDoc = doc;
                this.this$0.maxBucket = Math.max(this.this$0.maxBucket, bucket);
            }
        };
    }

    @Override
    public void preCollection() throws IOException {
        this.collector.preCollection();
    }

    @Override
    public void postCollection() throws IOException {
        assert (this.searchContext.searcher().getLeafContexts().isEmpty() || !this.finished);
        this.finishLeaf();
        this.finished = true;
    }

    @Override
    public void prepareSelectedBuckets(long ... selectedBuckets) throws IOException {
        if (!this.finished) {
            throw new IllegalStateException("Cannot replay yet, collection is not finished: postCollect() has not been called");
        }
        if (this.selectedBuckets != null) {
            throw new IllegalStateException("Already been replayed");
        }
        this.selectedBuckets = new LongHash(selectedBuckets.length, BigArrays.NON_RECYCLING_INSTANCE);
        for (long ord : selectedBuckets) {
            this.selectedBuckets.add(ord);
        }
        boolean needsScores = this.scoreMode().needsScores();
        Weight weight = null;
        if (needsScores) {
            MatchAllDocsQuery query = this.isGlobal ? new MatchAllDocsQuery() : this.searchContext.query();
            weight = this.searchContext.searcher().createWeight(this.searchContext.searcher().rewrite((Query)query), ScoreMode.COMPLETE, 1.0f);
        }
        for (Entry entry : this.entries) {
            assert (entry.docDeltas.size() > 0L) : "segment should have at least one document to replay, got 0";
            try {
                LeafBucketCollector leafCollector = this.collector.getLeafCollector(entry.context);
                DocIdSetIterator scoreIt = null;
                if (needsScores) {
                    Scorer scorer = weight.scorer(entry.context);
                    scoreIt = scorer.iterator();
                    leafCollector.setScorer((Scorable)scorer);
                }
                PackedLongValues.Iterator docDeltaIterator = entry.docDeltas.iterator();
                PackedLongValues.Iterator buckets = entry.buckets.iterator();
                int doc = 0;
                long end = entry.docDeltas.size();
                for (long i = 0L; i < end; ++i) {
                    doc += (int)docDeltaIterator.next();
                    long bucket = buckets.next();
                    long rebasedBucket = this.selectedBuckets.find(bucket);
                    if (rebasedBucket == -1L) continue;
                    if (needsScores) {
                        if (scoreIt.docID() < doc) {
                            scoreIt.advance(doc);
                        }
                        assert (scoreIt.docID() == doc);
                    }
                    leafCollector.collect(doc, rebasedBucket);
                }
            }
            catch (CollectionTerminatedException collectionTerminatedException) {
            }
        }
        this.collector.postCollection();
    }

    @Override
    public Aggregator wrap(final Aggregator in) {
        return new DeferringBucketCollector.WrappedAggregator(this, in){
            final /* synthetic */ BestBucketsDeferringCollector this$0;
            {
                this.this$0 = this$0;
                super(this$0, in2);
            }

            @Override
            public InternalAggregation[] buildAggregations(long[] owningBucketOrds) throws IOException {
                if (this.this$0.selectedBuckets == null) {
                    throw new IllegalStateException("Collection has not been replayed yet.");
                }
                long[] rebasedOrds = new long[owningBucketOrds.length];
                for (int ordIdx = 0; ordIdx < owningBucketOrds.length; ++ordIdx) {
                    rebasedOrds[ordIdx] = this.this$0.selectedBuckets.find(owningBucketOrds[ordIdx]);
                    if (rebasedOrds[ordIdx] != -1L) continue;
                    throw new IllegalStateException("Cannot build for a bucket which has not been collected");
                }
                return in.buildAggregations(rebasedOrds);
            }
        };
    }

    static class Entry {
        final LeafReaderContext context;
        final PackedLongValues docDeltas;
        final PackedLongValues buckets;

        Entry(LeafReaderContext context, PackedLongValues docDeltas, PackedLongValues buckets) {
            this.context = Objects.requireNonNull(context);
            this.docDeltas = Objects.requireNonNull(docDeltas);
            this.buckets = Objects.requireNonNull(buckets);
        }
    }
}

