/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.geom;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.GeneralPath;
import java.awt.geom.IllegalPathStateException;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.jhotdraw.geom.BezierPathIterator;
import org.jhotdraw.geom.Geom;
import org.jhotdraw.geom.Shapes;

public class BezierPath
extends ArrayList<Node>
implements Shape,
Serializable {
    public static final int C0_MASK = 0;
    public static final int C1_MASK = 1;
    public static final int C2_MASK = 2;
    public static final int C1C2_MASK = 3;
    private transient GeneralPath generalPath;
    private transient Rectangle2D.Double bounds;
    private int outer = -1;
    private boolean isClosed;
    private int windingRule = 0;

    public void add(Point2D.Double double_) {
        this.add(new Node(0, double_, double_, double_));
    }

    public void addPoint(double d, double d2) {
        this.add(new Node(0, d, d2, d, d2, d, d2));
    }

    public void add(int n, Point2D.Double double_, Point2D.Double double_2, Point2D.Double double_3) {
        this.add(new Node(n, double_, double_2, double_3));
    }

    public void addAll(Collection<Point2D.Double> collection) {
        for (Point2D.Double double_ : collection) {
            this.add(new Node(0, double_, double_, double_));
        }
    }

    public void set(int n, int n2, Point2D.Double double_) {
        Node node = (Node)this.get(n);
        node.x[n2] = double_.x;
        node.y[n2] = double_.y;
    }

    public Point2D.Double get(int n, int n2) {
        Node node = (Node)this.get(n);
        return new Point2D.Double(node.x[n2], node.y[n2]);
    }

    public void invalidatePath() {
        this.generalPath = null;
        this.bounds = null;
        this.outer = -1;
    }

    public void validatePath() {
        if (this.generalPath == null) {
            this.generalPath = this.toGeneralPath();
        }
    }

    public GeneralPath toGeneralPath() {
        GeneralPath generalPath = new GeneralPath();
        generalPath.setWindingRule(this.windingRule);
        if (this.size() == 0) {
            generalPath.moveTo(0.0f, 0.0f);
            generalPath.lineTo(0.0f, 1.0f);
        } else if (this.size() == 1) {
            Node node = (Node)this.get(0);
            generalPath.moveTo((float)node.x[0], (float)node.y[0]);
            generalPath.lineTo((float)node.x[0], (float)node.y[0] + 1.0f);
        } else {
            Node node;
            Node node2 = node = (Node)this.get(0);
            generalPath.moveTo((float)node.x[0], (float)node.y[0]);
            int n = this.size();
            for (int i = 1; i < n; ++i) {
                node2 = node;
                node = (Node)this.get(i);
                if ((node2.mask & 2) == 0) {
                    if ((node.mask & 1) == 0) {
                        generalPath.lineTo((float)node.x[0], (float)node.y[0]);
                        continue;
                    }
                    generalPath.quadTo((float)node.x[1], (float)node.y[1], (float)node.x[0], (float)node.y[0]);
                    continue;
                }
                if ((node.mask & 1) == 0) {
                    generalPath.quadTo((float)node2.x[2], (float)node2.y[2], (float)node.x[0], (float)node.y[0]);
                    continue;
                }
                generalPath.curveTo((float)node2.x[2], (float)node2.y[2], (float)node.x[1], (float)node.y[1], (float)node.x[0], (float)node.y[0]);
            }
            if (this.isClosed) {
                if (this.size() > 1) {
                    node2 = (Node)this.get(this.size() - 1);
                    node = (Node)this.get(0);
                    if ((node2.mask & 2) == 0) {
                        if ((node.mask & 1) == 0) {
                            generalPath.lineTo((float)node.x[0], (float)node.y[0]);
                        } else {
                            generalPath.quadTo((float)node.x[1], (float)node.y[1], (float)node.x[0], (float)node.y[0]);
                        }
                    } else if ((node.mask & 1) == 0) {
                        generalPath.quadTo((float)node2.x[2], (float)node2.y[2], (float)node.x[0], (float)node.y[0]);
                    } else {
                        generalPath.curveTo((float)node2.x[2], (float)node2.y[2], (float)node.x[1], (float)node.y[1], (float)node.x[0], (float)node.y[0]);
                    }
                }
                generalPath.closePath();
            }
        }
        return generalPath;
    }

    @Override
    public boolean contains(Point2D point2D) {
        this.validatePath();
        return this.generalPath.contains(point2D);
    }

    public boolean outlineContains(Point2D.Double double_, double d) {
        return Shapes.outlineContains(this, double_, d);
    }

    @Override
    public boolean intersects(Rectangle2D rectangle2D) {
        this.validatePath();
        return this.generalPath.intersects(rectangle2D);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform affineTransform) {
        return new BezierPathIterator(this, affineTransform);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform affineTransform, double d) {
        return new FlatteningPathIterator(new BezierPathIterator(this, affineTransform), d);
    }

    @Override
    public boolean contains(Rectangle2D rectangle2D) {
        this.validatePath();
        return this.generalPath.contains(rectangle2D);
    }

    @Override
    public boolean intersects(double d, double d2, double d3, double d4) {
        this.validatePath();
        return this.generalPath.intersects(d, d2, d3, d4);
    }

    @Override
    public Rectangle2D.Double getBounds2D() {
        if (this.bounds == null) {
            double d;
            double d2;
            double d3;
            double d4;
            int n = this.size();
            if (n == 0) {
                d4 = 0.0;
                d3 = 0.0;
                d2 = 0.0;
                d = 0.0;
            } else {
                double d5;
                double d6;
                Node node = (Node)this.get(0);
                d2 = d4 = node.y[0];
                d = d3 = node.x[0];
                if (this.isClosed && (node.mask & 1) != 0) {
                    d6 = node.y[1];
                    d5 = node.x[1];
                    if (d5 < d) {
                        d = d5;
                    }
                    if (d6 < d2) {
                        d2 = d6;
                    }
                    if (d5 > d3) {
                        d3 = d5;
                    }
                    if (d6 > d4) {
                        d4 = d6;
                    }
                }
                if ((node.mask & 2) != 0) {
                    d6 = node.y[2];
                    d5 = node.x[2];
                    if (d5 < d) {
                        d = d5;
                    }
                    if (d6 < d2) {
                        d2 = d6;
                    }
                    if (d5 > d3) {
                        d3 = d5;
                    }
                    if (d6 > d4) {
                        d4 = d6;
                    }
                }
                node = (Node)this.get(n - 1);
                d6 = node.y[0];
                d5 = node.x[0];
                if (d5 < d) {
                    d = d5;
                }
                if (d6 < d2) {
                    d2 = d6;
                }
                if (d5 > d3) {
                    d3 = d5;
                }
                if (d6 > d4) {
                    d4 = d6;
                }
                if ((node.mask & 1) != 0) {
                    d6 = node.y[1];
                    d5 = node.x[1];
                    if (d5 < d) {
                        d = d5;
                    }
                    if (d6 < d2) {
                        d2 = d6;
                    }
                    if (d5 > d3) {
                        d3 = d5;
                    }
                    if (d6 > d4) {
                        d4 = d6;
                    }
                }
                if (this.isClosed && (node.mask & 2) != 0) {
                    d6 = node.y[2];
                    d5 = node.x[2];
                    if (d5 < d) {
                        d = d5;
                    }
                    if (d6 < d2) {
                        d2 = d6;
                    }
                    if (d5 > d3) {
                        d3 = d5;
                    }
                    if (d6 > d4) {
                        d4 = d6;
                    }
                }
                int n2 = n - 1;
                for (int i = 1; i < n2; ++i) {
                    node = (Node)this.get(i);
                    d6 = node.y[0];
                    d5 = node.x[0];
                    if (d5 < d) {
                        d = d5;
                    }
                    if (d6 < d2) {
                        d2 = d6;
                    }
                    if (d5 > d3) {
                        d3 = d5;
                    }
                    if (d6 > d4) {
                        d4 = d6;
                    }
                    if ((node.mask & 1) != 0) {
                        d6 = node.y[1];
                        d5 = node.x[1];
                        if (d5 < d) {
                            d = d5;
                        }
                        if (d6 < d2) {
                            d2 = d6;
                        }
                        if (d5 > d3) {
                            d3 = d5;
                        }
                        if (d6 > d4) {
                            d4 = d6;
                        }
                    }
                    if ((node.mask & 2) == 0) continue;
                    d6 = node.y[2];
                    d5 = node.x[2];
                    if (d5 < d) {
                        d = d5;
                    }
                    if (d6 < d2) {
                        d2 = d6;
                    }
                    if (d5 > d3) {
                        d3 = d5;
                    }
                    if (!(d6 > d4)) continue;
                    d4 = d6;
                }
            }
            this.bounds = new Rectangle2D.Double(d, d2, d3 - d, d4 - d2);
        }
        return (Rectangle2D.Double)this.bounds.clone();
    }

    @Override
    public Rectangle getBounds() {
        return this.getBounds2D().getBounds();
    }

    @Override
    public boolean contains(double d, double d2, double d3, double d4) {
        this.validatePath();
        return this.generalPath.contains(d, d2, d3, d4);
    }

    @Override
    public boolean contains(double d, double d2) {
        this.validatePath();
        return this.generalPath.contains(d, d2);
    }

    public void setClosed(boolean bl) {
        if (this.isClosed != bl) {
            this.isClosed = bl;
            this.invalidatePath();
        }
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public BezierPath clone() {
        BezierPath bezierPath = (BezierPath)super.clone();
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            bezierPath.set(i, (Node)((Node)this.get(i)).clone());
        }
        return bezierPath;
    }

    public void transform(AffineTransform affineTransform) {
        Point2D.Double double_ = new Point2D.Double();
        for (Node node : this) {
            for (int i = 0; i < 3; ++i) {
                double_.x = node.x[i];
                double_.y = node.y[i];
                affineTransform.transform(double_, double_);
                node.x[i] = double_.x;
                node.y[i] = double_.y;
            }
        }
        this.invalidatePath();
    }

    public void setTo(BezierPath bezierPath) {
        while (bezierPath.size() < this.size()) {
            this.remove(this.size() - 1);
        }
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            ((Node)this.get(i)).setTo((Node)bezierPath.get(i));
        }
        while (this.size() < bezierPath.size()) {
            this.add((Node)((Node)bezierPath.get(this.size())).clone());
        }
    }

    public Point2D.Double getCenter() {
        double d = 0.0;
        double d2 = 0.0;
        for (Node node : this) {
            d += node.x[0];
            d2 += node.y[0];
        }
        int n = this.size();
        return new Point2D.Double(d / (double)n, d2 / (double)n);
    }

    public Point2D.Double chop(Point2D.Double double_) {
        this.validatePath();
        return Geom.chop(this.generalPath, double_);
    }

    public int indexOfOutermostNode() {
        if (this.outer == -1) {
            Point2D.Double double_ = this.getCenter();
            this.outer = 0;
            double d = 0.0;
            int n = this.size();
            for (int i = 0; i < n; ++i) {
                Node node = (Node)this.get(i);
                double d2 = Geom.length2(double_.x, double_.y, node.x[0], node.y[0]);
                if (!(d2 > d)) continue;
                d = d2;
                this.outer = i;
            }
        }
        return this.outer;
    }

    public Point2D.Double getPointOnPath(double d, double d2) {
        if (this.size() == 0) {
            return null;
        }
        if (this.size() == 1) {
            return ((Node)this.get(0)).getControlPoint(0);
        }
        if (d <= 0.0) {
            return ((Node)this.get(0)).getControlPoint(0);
        }
        if (d >= 1.0) {
            return ((Node)this.get(this.size() - 1)).getControlPoint(0);
        }
        this.validatePath();
        double d3 = this.getLengthOfPath(d2);
        double d4 = d3 * d;
        double d5 = 0.0;
        double[] dArray = new double[6];
        PathIterator pathIterator = this.generalPath.getPathIterator(new AffineTransform(), d2);
        int n = pathIterator.currentSegment(dArray);
        double d6 = dArray[0];
        double d7 = dArray[1];
        pathIterator.next();
        while (!pathIterator.isDone()) {
            pathIterator.currentSegment(dArray);
            double d8 = Geom.length(d6, d7, dArray[0], dArray[1]);
            if (d5 + d8 >= d4) {
                double d9 = (d4 - d5) / d8;
                return new Point2D.Double(d6 * (1.0 - d9) + dArray[0] * d9, d7 * (1.0 - d9) + dArray[1] * d9);
            }
            d5 += d8;
            d6 = dArray[0];
            d7 = dArray[1];
            pathIterator.next();
        }
        throw new InternalError("We should never get here");
    }

    public double getLengthOfPath(double d) {
        double d2 = 0.0;
        PathIterator pathIterator = this.generalPath.getPathIterator(new AffineTransform(), d);
        double[] dArray = new double[6];
        int n = pathIterator.currentSegment(dArray);
        double d3 = dArray[0];
        double d4 = dArray[1];
        pathIterator.next();
        while (!pathIterator.isDone()) {
            pathIterator.currentSegment(dArray);
            d2 += Geom.length(d3, d4, dArray[0], dArray[1]);
            d3 = dArray[0];
            d4 = dArray[1];
            pathIterator.next();
        }
        return d2;
    }

    public double getRelativePositionOnPath(Point2D.Double double_, double d) {
        Node node;
        Node node2;
        double d2 = this.getLengthOfPath(d);
        double d3 = 0.0;
        BezierPath bezierPath = new BezierPath();
        Node node3 = new Node();
        bezierPath.add(node3);
        Node node4 = new Node();
        bezierPath.add(node4);
        int n = this.size() - 1;
        for (int i = 0; i < n; ++i) {
            node2 = (Node)this.get(i);
            node = (Node)this.get(i + 1);
            if (node2.mask == 0 && node.mask == 0) {
                if (Geom.lineContainsPoint(node2.x[0], node2.y[0], node.x[0], node.y[0], double_.x, double_.y, d)) {
                    return (d3 += Geom.length(node2.x[0], node2.y[0], double_.x, double_.y)) / d2;
                }
                d3 += Geom.length(node2.x[0], node2.y[0], node.x[0], node.y[0]);
                continue;
            }
            node3.setTo(node2);
            node4.setTo(node);
            bezierPath.invalidatePath();
            if (bezierPath.outlineContains(double_, d)) {
                return (d3 += Geom.length(node2.x[0], node2.y[0], double_.x, double_.y)) / d2;
            }
            d3 += Geom.length(node2.x[0], node2.y[0], node.x[0], node.y[0]);
        }
        if (this.isClosed && this.size() > 1) {
            node2 = (Node)this.get(this.size() - 1);
            node = (Node)this.get(0);
            if (node2.mask == 0 && node.mask == 0) {
                if (Geom.lineContainsPoint(node2.x[0], node2.y[0], node.x[0], node.y[0], double_.x, double_.y, d)) {
                    return (d3 += Geom.length(node2.x[0], node2.y[0], double_.x, double_.y)) / d2;
                }
            } else {
                node3.setTo(node2);
                node4.setTo(node);
                bezierPath.invalidatePath();
                if (bezierPath.outlineContains(double_, d)) {
                    return (d3 += Geom.length(node2.x[0], node2.y[0], double_.x, double_.y)) / d2;
                }
            }
        }
        return -1.0;
    }

    public int findSegment(Point2D.Double double_, double d) {
        Node node;
        Node node2;
        BezierPath bezierPath = new BezierPath();
        Node node3 = new Node();
        bezierPath.add(node3);
        Node node4 = new Node();
        bezierPath.add(node4);
        int n = this.size() - 1;
        for (int i = 0; i < n; ++i) {
            node2 = (Node)this.get(i);
            node = (Node)this.get(i + 1);
            if (node2.mask == 0 && node.mask == 0) {
                if (!Geom.lineContainsPoint(node2.x[0], node2.y[0], node.x[0], node.y[0], double_.x, double_.y, d)) continue;
                return i;
            }
            node3.setTo(node2);
            node4.setTo(node);
            bezierPath.invalidatePath();
            if (!bezierPath.outlineContains(double_, d)) continue;
            return i;
        }
        if (this.isClosed && this.size() > 1) {
            node2 = (Node)this.get(this.size() - 1);
            node = (Node)this.get(0);
            if (node2.mask == 0 && node.mask == 0) {
                if (Geom.lineContainsPoint(node2.x[0], node2.y[0], node.x[0], node.y[0], double_.x, double_.y, d)) {
                    return this.size() - 1;
                }
            } else {
                node3.setTo(node2);
                node4.setTo(node);
                bezierPath.invalidatePath();
                if (bezierPath.outlineContains(double_, d)) {
                    return this.size() - 1;
                }
            }
        }
        return -1;
    }

    public int joinSegments(Point2D.Double double_, double d) {
        for (int i = 0; i < this.size(); ++i) {
            Node node = (Node)this.get(i);
            if (!(Geom.length(node.x[0], node.y[0], double_.x, double_.y) < d)) continue;
            this.remove(i);
            return i;
        }
        return -1;
    }

    public int splitSegment(Point2D.Double double_, double d) {
        int n = this.findSegment(double_, d);
        int n2 = (n + 1) % this.size();
        if (n != -1) {
            if ((((Node)this.get((int)n)).mask & 2) == 2 && (((Node)this.get((int)n2)).mask & 1) == 0) {
                this.add(n + 1, new Node(2, double_, double_, double_));
            } else if ((((Node)this.get((int)n)).mask & 2) == 0 && (((Node)this.get((int)n2)).mask & 1) == 1) {
                this.add(n + 1, new Node(1, double_, double_, double_));
            } else if ((((Node)this.get((int)n)).mask & 2) == 2 && (((Node)this.get((int)n2)).mask & 1) == 1) {
                this.add(n + 1, new Node(3, double_, double_, double_));
            } else {
                this.add(n + 1, new Node(double_));
            }
        }
        return n + 1;
    }

    public void moveTo(double d, double d2) {
        if (this.size() != 0) {
            throw new IllegalPathStateException("moveTo only allowed when empty");
        }
        Node node = new Node(d, d2);
        node.keepColinear = false;
        this.add(node);
    }

    public void lineTo(double d, double d2) {
        if (this.size() == 0) {
            throw new IllegalPathStateException("lineTo only allowed when not empty");
        }
        ((Node)this.get((int)(this.size() - 1))).keepColinear = false;
        this.add(new Node(d, d2));
    }

    public void quadTo(double d, double d2, double d3, double d4) {
        if (this.size() == 0) {
            throw new IllegalPathStateException("quadTo only allowed when not empty");
        }
        this.add(new Node(1, d3, d4, d, d2, d3, d4));
    }

    public void curveTo(double d, double d2, double d3, double d4, double d5, double d6) {
        if (this.size() == 0) {
            throw new IllegalPathStateException("curveTo only allowed when not empty");
        }
        Node node = (Node)this.get(this.size() - 1);
        node.mask |= 2;
        node.x[2] = d;
        node.y[2] = d2;
        if ((node.mask & 3) == 3) {
            node.keepColinear = Math.abs(Geom.angle(node.x[0], node.y[0], node.x[1], node.y[1]) - Geom.angle(node.x[2], node.y[2], node.x[0], node.y[0])) < 0.001;
        }
        this.add(new Node(1, d5, d6, d3, d4, d5, d6));
    }

    public void arcTo(double d, double d2, double d3, boolean bl, boolean bl2, double d4, double d5) {
        double d6;
        double d7;
        double d8;
        if (d == 0.0 || d2 == 0.0) {
            this.lineTo(d4, d5);
            return;
        }
        Node node = (Node)this.get(this.size() - 1);
        double d9 = (node.mask & 2) == 2 ? node.x[2] : node.x[0];
        double d10 = d8 = (node.mask & 2) == 2 ? node.y[2] : node.y[0];
        if (d9 == d4 && d8 == d5) {
            return;
        }
        double d11 = (d9 - d4) / 2.0;
        double d12 = (d8 - d5) / 2.0;
        double d13 = Math.toRadians(d3);
        double d14 = Math.cos(d13);
        double d15 = Math.sin(d13);
        double d16 = d14 * d11 + d15 * d12;
        double d17 = -d15 * d11 + d14 * d12;
        double d18 = d16 * d16;
        double d19 = (d = Math.abs(d)) * d;
        double d20 = d18 / d19 + (d7 = d17 * d17) / (d6 = (d2 = Math.abs(d2)) * d2);
        if (d20 > 1.0) {
            d = Math.sqrt(d20) * d;
            d2 = Math.sqrt(d20) * d2;
            d19 = d * d;
            d6 = d2 * d2;
        }
        double d21 = bl == bl2 ? -1.0 : 1.0;
        double d22 = (d19 * d6 - d19 * d7 - d6 * d18) / (d19 * d7 + d6 * d18);
        d22 = d22 < 0.0 ? 0.0 : d22;
        double d23 = d21 * Math.sqrt(d22);
        double d24 = d23 * (d * d17 / d2);
        double d25 = d23 * -(d2 * d16 / d);
        double d26 = (d9 + d4) / 2.0;
        double d27 = (d8 + d5) / 2.0;
        double d28 = d26 + (d14 * d24 - d15 * d25);
        double d29 = d27 + (d15 * d24 + d14 * d25);
        double d30 = (d16 - d24) / d;
        double d31 = (d17 - d25) / d2;
        double d32 = (-d16 - d24) / d;
        double d33 = (-d17 - d25) / d2;
        double d34 = Math.sqrt(d30 * d30 + d31 * d31);
        double d35 = d30;
        d21 = d31 < 0.0 ? -1.0 : 1.0;
        double d36 = Math.toDegrees(d21 * Math.acos(d35 / d34));
        d34 = Math.sqrt((d30 * d30 + d31 * d31) * (d32 * d32 + d33 * d33));
        d35 = d30 * d32 + d31 * d33;
        d21 = d30 * d33 - d31 * d32 < 0.0 ? -1.0 : 1.0;
        double d37 = Math.toDegrees(d21 * Math.acos(d35 / d34));
        if (!bl2 && d37 > 0.0) {
            d37 -= 360.0;
        } else if (bl2 && d37 < 0.0) {
            d37 += 360.0;
        }
        Arc2D.Double double_ = new Arc2D.Double(d28 - d, d29 - d2, d * 2.0, d2 * 2.0, -(d36 %= 360.0), -(d37 %= 360.0), 0);
        PathIterator pathIterator = double_.getPathIterator(AffineTransform.getRotateInstance(d13, double_.getCenterX(), double_.getCenterY()));
        double[] dArray = new double[6];
        pathIterator.next();
        while (!pathIterator.isDone()) {
            int n = pathIterator.currentSegment(dArray);
            switch (n) {
                case 4: {
                    break;
                }
                case 3: {
                    this.curveTo(dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5]);
                    break;
                }
                case 1: {
                    this.lineTo(dArray[0], dArray[1]);
                    break;
                }
                case 0: {
                    break;
                }
                case 2: {
                    this.quadTo(dArray[0], dArray[1], dArray[2], dArray[3]);
                }
            }
            pathIterator.next();
        }
    }

    public Point2D.Double[] toPolygonArray() {
        Point2D.Double[] doubleArray = new Point2D.Double[this.size()];
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            doubleArray[i] = new Point2D.Double(((Node)this.get((int)i)).x[0], ((Node)this.get((int)i)).y[0]);
        }
        return doubleArray;
    }

    public void setWindingRule(int n) {
        if (n != this.windingRule) {
            this.invalidatePath();
            int n2 = this.windingRule;
            this.windingRule = n;
        }
    }

    public int getWindingRule() {
        return this.windingRule;
    }

    public static class Node
    implements Cloneable,
    Serializable {
        public int mask = 0;
        public double[] x = new double[3];
        public double[] y = new double[3];
        public boolean keepColinear = true;

        public Node() {
        }

        public Node(Node node) {
            this.setTo(node);
        }

        public void setTo(Node node) {
            this.mask = node.mask;
            this.keepColinear = node.keepColinear;
            System.arraycopy(node.x, 0, this.x, 0, 3);
            System.arraycopy(node.y, 0, this.y, 0, 3);
        }

        public Node(Point2D.Double double_) {
            this.mask = 0;
            this.x[0] = double_.x;
            this.y[0] = double_.y;
            this.x[1] = double_.x;
            this.y[1] = double_.y;
            this.x[2] = double_.x;
            this.y[2] = double_.y;
        }

        public Node(int n, Point2D.Double double_, Point2D.Double double_2, Point2D.Double double_3) {
            this.mask = n;
            this.x[0] = double_.x;
            this.y[0] = double_.y;
            this.x[1] = double_2.x;
            this.y[1] = double_2.y;
            this.x[2] = double_3.x;
            this.y[2] = double_3.y;
        }

        public Node(double d, double d2) {
            this.mask = 0;
            this.x[0] = d;
            this.y[0] = d2;
            this.x[1] = d;
            this.y[1] = d2;
            this.x[2] = d;
            this.y[2] = d2;
        }

        public Node(int n, double d, double d2, double d3, double d4, double d5, double d6) {
            this.mask = n;
            this.x[0] = d;
            this.y[0] = d2;
            this.x[1] = d3;
            this.y[1] = d4;
            this.x[2] = d5;
            this.y[2] = d6;
        }

        public int getMask() {
            return this.mask;
        }

        public void setMask(int n) {
            this.mask = n;
        }

        public void setControlPoint(int n, Point2D.Double double_) {
            this.x[n] = double_.x;
            this.y[n] = double_.y;
        }

        public Point2D.Double getControlPoint(int n) {
            return new Point2D.Double(this.x[n], this.y[n]);
        }

        public void moveTo(Point2D.Double double_) {
            this.moveBy(double_.x - this.x[0], double_.y - this.y[0]);
        }

        public void moveTo(double d, double d2) {
            this.moveBy(d - this.x[0], d2 - this.y[0]);
        }

        public void moveBy(double d, double d2) {
            int n = 0;
            while (n < 3) {
                int n2 = n;
                this.x[n2] = this.x[n2] + d;
                int n3 = n++;
                this.y[n3] = this.y[n3] + d2;
            }
        }

        public Object clone() {
            try {
                Node node = (Node)super.clone();
                node.x = (double[])this.x.clone();
                node.y = (double[])this.y.clone();
                return node;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                InternalError internalError = new InternalError();
                internalError.initCause(cloneNotSupportedException);
                throw internalError;
            }
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append('[');
            for (int i = 0; i < 3; ++i) {
                if (i != 0) {
                    if ((this.mask & i) != i) continue;
                    stringBuilder.append(',');
                }
                stringBuilder.append('x');
                stringBuilder.append(i);
                stringBuilder.append('=');
                stringBuilder.append(this.x[i]);
                stringBuilder.append(",y");
                stringBuilder.append(i);
                stringBuilder.append('=');
                stringBuilder.append(this.y[i]);
            }
            stringBuilder.append(']');
            return stringBuilder.toString();
        }

        public int hashCode() {
            return (this.mask & 3) << 29 | Arrays.hashCode(this.x) & 0x3FFF0000 | Arrays.hashCode(this.y) & 0xFFFF;
        }

        public boolean equals(Object object) {
            if (object instanceof Node) {
                Node node = (Node)object;
                return node.mask == this.mask && Arrays.equals(node.x, this.x) && Arrays.equals(node.y, this.y);
            }
            return false;
        }
    }
}

