/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.time.LocalDateTime;
import java.util.Objects;
import twitter4j.HttpResponse;
import twitter4j.JSONArray;
import twitter4j.JSONException;
import twitter4j.JSONObject;
import twitter4j.ParseUtil;
import twitter4j.ResponseListImpl;
import twitter4j.TwitterException;
import twitter4j.TwitterObjectFactory;
import twitter4j.TwitterResponseImpl;
import twitter4j.v1.ResponseList;
import twitter4j.v1.SavedSearch;

final class SavedSearchJSONImpl
extends TwitterResponseImpl
implements SavedSearch {
    private static final long serialVersionUID = -2281949861485441692L;
    private LocalDateTime createdAt;
    private String query;
    private int position;
    private String name;
    private long id;

    SavedSearchJSONImpl(HttpResponse res, boolean jsonStoreEnabled) throws TwitterException {
        super(res);
        if (jsonStoreEnabled) {
            TwitterObjectFactory.clearThreadLocalMap();
        }
        JSONObject json = res.asJSONObject();
        this.init(json);
        if (jsonStoreEnabled) {
            TwitterObjectFactory.registerJSONObject(this, json);
        }
    }

    SavedSearchJSONImpl(JSONObject savedSearch) throws TwitterException {
        this.init(savedSearch);
    }

    static ResponseList<SavedSearch> createSavedSearchList(HttpResponse res, boolean jsonStoreEnabled) throws TwitterException {
        if (jsonStoreEnabled) {
            TwitterObjectFactory.clearThreadLocalMap();
        }
        JSONArray json = res.asJSONArray();
        try {
            ResponseListImpl<SavedSearch> savedSearches = new ResponseListImpl<SavedSearch>(json.length(), res);
            for (int i = 0; i < json.length(); ++i) {
                JSONObject savedSearchesJSON = json.getJSONObject(i);
                SavedSearchJSONImpl savedSearch = new SavedSearchJSONImpl(savedSearchesJSON);
                savedSearches.add(savedSearch);
                if (!jsonStoreEnabled) continue;
                TwitterObjectFactory.registerJSONObject(savedSearch, savedSearchesJSON);
            }
            if (jsonStoreEnabled) {
                TwitterObjectFactory.registerJSONObject(savedSearches, json);
            }
            return savedSearches;
        }
        catch (JSONException jsone) {
            throw new TwitterException(jsone.getMessage() + ":" + res.asString(), jsone);
        }
    }

    private void init(JSONObject savedSearch) throws TwitterException {
        this.createdAt = ParseUtil.getDate("created_at", savedSearch, "EEE MMM dd HH:mm:ss Z yyyy");
        this.query = ParseUtil.getUnescapedString("query", savedSearch);
        this.position = ParseUtil.getInt("position", savedSearch);
        this.name = ParseUtil.getUnescapedString("name", savedSearch);
        this.id = ParseUtil.getLong("id", savedSearch);
    }

    @Override
    public int compareTo(SavedSearch that) {
        return (int)(this.id - that.getId());
    }

    @Override
    public LocalDateTime getCreatedAt() {
        return this.createdAt;
    }

    @Override
    public String getQuery() {
        return this.query;
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public long getId() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SavedSearchJSONImpl that = (SavedSearchJSONImpl)o;
        return this.position == that.position && this.id == that.id && Objects.equals(this.createdAt, that.createdAt) && Objects.equals(this.query, that.query) && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        int result = this.createdAt.hashCode();
        result = 31 * result + this.query.hashCode();
        result = 31 * result + this.position;
        result = 31 * result + this.name.hashCode();
        result = 31 * result + (int)this.id;
        return result;
    }

    public String toString() {
        return "SavedSearchJSONImpl{createdAt=" + this.createdAt + ", query='" + this.query + '\'' + ", position=" + this.position + ", name='" + this.name + '\'' + ", id=" + this.id + '}';
    }
}

