/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.readline.action.mappings;

import org.aesh.readline.InputProcessor;
import org.aesh.readline.action.Action;
import org.aesh.readline.action.ActionEvent;
import org.aesh.readline.action.KeyAction;
import org.aesh.readline.completion.CompletionHandler;
import org.aesh.readline.terminal.Key;
import org.aesh.utils.Config;

public class Complete
implements ActionEvent {
    private boolean askForCompletion = false;
    private KeyAction key;

    @Override
    public String name() {
        return "complete";
    }

    @Override
    public void accept(InputProcessor inputProcessor) {
        if (this.askForCompletion) {
            if (this.key == Key.y) {
                this.askForCompletion = false;
                this.key = null;
                inputProcessor.buffer().completer().complete(inputProcessor);
            } else if (this.key == Key.n) {
                this.askForCompletion = false;
                this.key = null;
                inputProcessor.buffer().completer().setCompletionStatus(CompletionHandler.CompletionStatus.COMPLETE);
                inputProcessor.buffer().undoManager().clear();
                inputProcessor.buffer().writeOut(Config.CR);
                inputProcessor.buffer().drawLineForceDisplay();
            }
        } else if (inputProcessor.buffer().completer() != null) {
            inputProcessor.buffer().completer().complete(inputProcessor);
            if (inputProcessor.buffer().completer().completionStatus() == CompletionHandler.CompletionStatus.ASKING_FOR_COMPLETIONS) {
                this.askForCompletion = true;
            }
        }
    }

    @Override
    public void input(Action action, KeyAction key) {
        if (this.askForCompletion && Key.isPrintable(key.buffer())) {
            if (Key.y.equalTo(key.buffer().array())) {
                this.key = Key.y;
            }
            if (Key.n.equalTo(key.buffer().array())) {
                this.key = Key.n;
            }
        }
    }

    @Override
    public boolean keepFocus() {
        return this.askForCompletion;
    }
}

