/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Tension;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.WorkLocation;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.LogBuilder;
import net.sf.freecol.common.util.StringUtils;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIObject;
import net.sf.freecol.server.ai.AIPlayer;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.mission.DefendSettlementMission;
import net.sf.freecol.server.ai.mission.IdleAtSettlementMission;
import net.sf.freecol.server.ai.mission.Mission;
import net.sf.freecol.server.ai.mission.UnitSeekAndDestroyMission;
import net.sf.freecol.server.ai.mission.UnitWanderHostileMission;

public abstract class MissionAIPlayer
extends AIPlayer {
    private static final Logger logger = Logger.getLogger(MissionAIPlayer.class.getName());
    private static final Comparator<AIUnit> aiUnitLocationComparator = new Comparator<AIUnit>(){

        @Override
        public int compare(AIUnit a1, AIUnit a2) {
            Location l1;
            Location location = a1 == null ? null : (l1 = a1.getUnit() == null ? null : a1.getUnit().getLocation());
            Location l2 = a2 == null ? null : (a2.getUnit() == null ? null : a2.getUnit().getLocation());
            FreeColObject f1 = l1 instanceof WorkLocation ? l1.getColony() : (FreeColObject)((Object)l1);
            FreeColObject f2 = l2 instanceof WorkLocation ? l2.getColony() : (FreeColObject)((Object)l2);
            return FreeColObject.compareIds(f1, f2);
        }
    };
    private List<AIUnit> aiUnits = new ArrayList<AIUnit>();

    public MissionAIPlayer(AIMain aiMain, Player player) {
        super(aiMain, player);
    }

    public MissionAIPlayer(AIMain aiMain, FreeColXMLReader xr) throws XMLStreamException {
        super(aiMain, xr);
    }

    @Override
    public void removeAIObject(AIObject ao) {
        if (ao instanceof AIUnit) {
            this.removeAIUnit((AIUnit)ao);
        } else {
            super.removeAIObject(ao);
        }
    }

    protected void clearAIUnits() {
        this.aiUnits.clear();
    }

    public void addAIUnit(AIUnit aiUnit) {
        this.aiUnits.add(aiUnit);
    }

    private void removeAIUnit(AIUnit aiu) {
        aiu.dropTransport();
        aiu.changeMission(null);
        this.aiUnits.remove(aiu);
    }

    @Override
    protected List<AIUnit> getAIUnits() {
        if (this.aiUnits.isEmpty()) {
            this.aiUnits = super.getAIUnits();
        }
        return new ArrayList<AIUnit>(this.aiUnits);
    }

    public int getSettlementDefenders(Settlement settlement) {
        int defenders = 0;
        for (AIUnit au : this.getAIUnits()) {
            DefendSettlementMission dm = au.getMission(DefendSettlementMission.class);
            if (dm == null || ((Mission)dm).getTarget() != settlement || au.getUnit().getSettlement() != settlement) continue;
            ++defenders;
        }
        return defenders;
    }

    public boolean isTargetValidForSeekAndDestroy(Unit attacker, Tile tile) {
        Player defenderPlayer;
        if (attacker == null) {
            return false;
        }
        Player attackerPlayer = attacker.getOwner();
        Settlement settlement = tile.getSettlement();
        Unit defender = tile.getDefendingUnit(attacker);
        Player player = settlement != null ? settlement.getOwner() : (defenderPlayer = defender != null ? defender.getOwner() : null);
        if (defenderPlayer == null) {
            return false;
        }
        if (attackerPlayer == defenderPlayer) {
            return false;
        }
        boolean atWar = attackerPlayer.atWarWith(defenderPlayer);
        if (attackerPlayer.isEuropean() ? !atWar : attackerPlayer.isIndian() && !atWar && attackerPlayer.getTension(defenderPlayer).getLevel().compareTo(Tension.Level.CONTENT) <= 0) {
            return false;
        }
        return attacker.canAttack(defender);
    }

    protected void logMissions(Map<Unit, String> reasons, LogBuilder lb) {
        List<AIUnit> units = this.getAIUnits();
        for (AIUnit aiu : CollectionUtils.sort(units, aiUnitLocationComparator)) {
            Unit u = aiu.getUnit();
            String reason = reasons.get(u);
            if (reason == null) {
                reason = "OMITTED";
            }
            String ms = "NONE";
            Location target = null;
            if (aiu.hasMission()) {
                Mission m = aiu.getMission();
                ms = StringUtils.lastPart(m.getClass().toString(), ".");
                ms = ms.substring(0, ms.length() - "Mission".length());
                target = m.getTarget();
            }
            lb.add("\n  @", String.format("%-30s%-10s%-40s%-16s", StringUtils.chop(u.getLocation().toShortString(), 30), StringUtils.chop(reason, 10), StringUtils.chop(u.toShortString(), 40), StringUtils.chop(ms, 16)));
            if (target == null) continue;
            lb.add("->", target);
        }
    }

    public Mission getDefendCurrentSettlementMission(AIUnit aiUnit) {
        if (DefendSettlementMission.invalidMissionReason(aiUnit) != null) {
            return null;
        }
        Unit unit = aiUnit.getUnit();
        Location loc = unit.getLocation();
        Settlement settlement = loc == null ? null : loc.getSettlement();
        return settlement != null && settlement.isBadlyDefended() ? this.getDefendSettlementMission(aiUnit, settlement) : null;
    }

    public Mission getDefendSettlementMission(AIUnit aiUnit, Settlement target) {
        return DefendSettlementMission.invalidMissionReason(aiUnit) != null ? null : new DefendSettlementMission(this.getAIMain(), aiUnit, target);
    }

    public Mission getIdleAtSettlementMission(AIUnit aiUnit) {
        return IdleAtSettlementMission.invalidMissionReason(aiUnit) != null ? null : new IdleAtSettlementMission(this.getAIMain(), aiUnit);
    }

    public Mission getSeekAndDestroyMission(AIUnit aiUnit, int range) {
        Location loc = null;
        if (UnitSeekAndDestroyMission.invalidMissionReason(aiUnit) == null) {
            loc = UnitSeekAndDestroyMission.findMissionTarget(aiUnit, range, false, false);
        }
        return loc == null ? null : this.getSeekAndDestroyMission(aiUnit, loc);
    }

    public Mission getSeekAndDestroyMission(AIUnit aiUnit, Location loc) {
        return UnitSeekAndDestroyMission.invalidMissionReason(aiUnit) != null || loc == null ? null : new UnitSeekAndDestroyMission(this.getAIMain(), aiUnit, loc);
    }

    public Mission getWanderHostileMission(AIUnit aiUnit) {
        return UnitWanderHostileMission.invalidMissionReason(aiUnit) != null ? null : new UnitWanderHostileMission(this.getAIMain(), aiUnit);
    }

    protected List<AIUnit> doMissions(List<AIUnit> aiUnits, LogBuilder lb) {
        lb.add("\n  Do Missions:");
        ArrayList<AIUnit> result = new ArrayList<AIUnit>();
        for (AIUnit aiu : aiUnits) {
            Unit unit = aiu.getUnit();
            if (unit == null || unit.isDisposed()) continue;
            lb.add("\n  ", unit, " ");
            try {
                aiu.doMission(lb);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "doMissions failed for: " + aiu, e);
            }
            if (unit.isDisposed() || unit.getMovesLeft() <= 0) continue;
            result.add(aiu);
        }
        return result;
    }

    public abstract int adjustMission(AIUnit var1, PathNode var2, Class var3, int var4);
}

