/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository;

import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.repository.Messages;
import org.pentaho.di.repository.Repository;

public class PermissionMeta {
    private long id;
    private int type;
    public static final int TYPE_PERMISSION_NONE = 0;
    public static final int TYPE_PERMISSION_READ_ONLY = 1;
    public static final int TYPE_PERMISSION_ADMIN = 2;
    public static final int TYPE_PERMISSION_TRANSFORMATION = 3;
    public static final int TYPE_PERMISSION_JOB = 4;
    public static final int TYPE_PERMISSION_SCHEMA = 5;
    public static final String[] permissionTypeCode = new String[]{"-", "READONLY", "ADMIN", "TRANS", "JOB", "SCHEMA"};
    public static final String[] permissionTypeDesc = new String[]{"-", Messages.getString("PermissionMeta.Permission.ReadOnly"), Messages.getString("PermissionMeta.Permission.Administrator"), Messages.getString("PermissionMeta.Permission.UseTransformations"), Messages.getString("PermissionMeta.Permission.UseJobs"), Messages.getString("PermissionMeta.Permission.UseSchemas")};

    public PermissionMeta(int type) {
        this.type = type;
    }

    public PermissionMeta(String stype) {
        this.type = PermissionMeta.getType(stype);
    }

    public PermissionMeta(Repository rep, long id_permission) throws KettleException {
        try {
            RowMetaAndData r = rep.getPermission(id_permission);
            this.setID(id_permission);
            String code = r.getString("CODE", null);
            this.type = PermissionMeta.getType(code);
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(Messages.getString("PermissionMeta.Error.LoadPermisson", Long.toString(id_permission)), (Throwable)dbe);
        }
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public String getTypeDesc() {
        return PermissionMeta.getTypeDesc(this.type);
    }

    public static final String getTypeDesc(int i) {
        if (i < 0 || i >= permissionTypeCode.length) {
            return null;
        }
        return permissionTypeCode[i];
    }

    public static final int getType(String str) {
        int i;
        for (i = 0; i < permissionTypeCode.length; ++i) {
            if (!permissionTypeCode[i].equalsIgnoreCase(str)) continue;
            return i;
        }
        for (i = 0; i < permissionTypeDesc.length; ++i) {
            if (!permissionTypeDesc[i].equalsIgnoreCase(str)) continue;
            return i;
        }
        return 0;
    }

    public long getID() {
        return this.id;
    }

    public void setID(long id) {
        this.id = id;
    }

    public boolean isReadonly() {
        return this.type == 1;
    }

    public boolean isAdministrator() {
        return this.type == 2;
    }

    public boolean useTransformations() {
        return this.type == 3;
    }

    public boolean useJobs() {
        return this.type == 4;
    }

    public boolean useSchemas() {
        return this.type == 5;
    }

    public String toString() {
        return this.getTypeDesc();
    }
}

