/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.hash;

import com.oracle.labs.mlrg.olcut.config.Option;
import com.oracle.labs.mlrg.olcut.config.Options;
import java.util.Optional;
import java.util.logging.Logger;
import org.tribuo.Output;
import org.tribuo.Trainer;
import org.tribuo.hash.HashCodeHasher;
import org.tribuo.hash.Hasher;
import org.tribuo.hash.HashingTrainer;
import org.tribuo.hash.MessageDigestHasher;
import org.tribuo.hash.ModHashCodeHasher;

public class HashingOptions
implements Options {
    private static final Logger logger = Logger.getLogger(HashingOptions.class.getName());
    @Option(longName="model-hashing-algorithm", usage="Hash the model during training, options are {NONE,MOD,HC,SHA1,SHA256}")
    public ModelHashingType modelHashingAlgorithm = ModelHashingType.NONE;
    @Option(longName="model-hashing-salt", usage="Salt for hashing the model")
    public String modelHashingSalt = "";

    public Optional<Hasher> getHasher() {
        if (this.modelHashingAlgorithm == ModelHashingType.NONE) {
            return Optional.empty();
        }
        if (Hasher.validateSalt(this.modelHashingSalt)) {
            switch (this.modelHashingAlgorithm) {
                case MOD: {
                    return Optional.of(new ModHashCodeHasher(this.modelHashingSalt));
                }
                case HC: {
                    return Optional.of(new HashCodeHasher(this.modelHashingSalt));
                }
                case SHA1: {
                    return Optional.of(new MessageDigestHasher("SHA1", this.modelHashingSalt));
                }
                case SHA256: {
                    return Optional.of(new MessageDigestHasher("SHA-256", this.modelHashingSalt));
                }
            }
            logger.info("Unknown hasher " + (Object)((Object)this.modelHashingAlgorithm));
            return Optional.empty();
        }
        logger.info("Invalid salt");
        return Optional.empty();
    }

    public <T extends Output<T>> Trainer<T> getHashedTrainer(Trainer<T> innerTrainer) {
        Optional<Hasher> hasherOpt = this.getHasher();
        if (hasherOpt.isPresent()) {
            return new HashingTrainer<T>(innerTrainer, hasherOpt.get());
        }
        throw new IllegalArgumentException("Invalid Hasher");
    }

    public static enum ModelHashingType {
        NONE,
        MOD,
        HC,
        SHA1,
        SHA256;

    }
}

