/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.antlr.semantic.types;

import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.opensearch.sql.legacy.antlr.semantic.types.Type;
import org.opensearch.sql.legacy.antlr.semantic.types.base.OpenSearchDataType;
import org.opensearch.sql.legacy.antlr.semantic.types.special.Generic;
import org.opensearch.sql.legacy.utils.StringUtils;

public interface TypeExpression
extends Type {
    @Override
    default public Type construct(List<Type> actualArgs) {
        TypeExpressionSpec[] specifications = this.specifications();
        if (specifications.length == 0) {
            return OpenSearchDataType.UNKNOWN;
        }
        TypeExpressionSpec actualSpec = new TypeExpressionSpec();
        actualSpec.argTypes = actualArgs.toArray(new Type[0]);
        for (TypeExpressionSpec spec : specifications) {
            if (!spec.isCompatible(actualSpec)) continue;
            return spec.constructFunc.apply(actualArgs.toArray(new Type[0]));
        }
        return OpenSearchDataType.TYPE_ERROR;
    }

    @Override
    default public String usage() {
        return Arrays.stream(this.specifications()).map(spec -> this.getName() + String.valueOf(spec)).collect(Collectors.joining(" or "));
    }

    public TypeExpressionSpec[] specifications();

    public static class TypeExpressionSpec {
        Type[] argTypes;
        Function<Type[], Type> constructFunc;

        public TypeExpressionSpec map(Type ... args) {
            this.argTypes = args;
            return this;
        }

        public TypeExpressionSpec to(Function<Type[], Type> constructFunc) {
            this.constructFunc = Generic.specialize(constructFunc, this.argTypes);
            return this;
        }

        public TypeExpressionSpec to(Type returnType) {
            this.constructFunc = x -> returnType;
            return this;
        }

        public boolean isCompatible(TypeExpressionSpec otherSpec) {
            Type[] expectArgTypes = this.argTypes;
            Type[] actualArgTypes = otherSpec.argTypes;
            if (expectArgTypes.length != actualArgTypes.length) {
                return false;
            }
            for (int i = 0; i < expectArgTypes.length; ++i) {
                if (expectArgTypes[i].isCompatible(actualArgTypes[i])) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            String argTypesStr = Arrays.stream(this.argTypes).map(Type::usage).collect(Collectors.joining(", "));
            Type returnType = this.constructFunc.apply(this.argTypes);
            String returnTypeStr = returnType instanceof Generic ? returnType.getName() : returnType.usage();
            return StringUtils.format("(%s) -> %s", argTypesStr, returnTypeStr);
        }
    }
}

