/*
 * Decompiled with CFR 0.152.
 */
package ciir.umass.edu.metric;

import ciir.umass.edu.learning.RankList;
import ciir.umass.edu.metric.MetricScorer;
import ciir.umass.edu.utilities.RankLibError;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.HashMap;

public class APScorer
extends MetricScorer {
    public HashMap<String, Integer> relDocCount = null;

    public APScorer() {
        this.k = 0;
    }

    @Override
    public MetricScorer copy() {
        return new APScorer();
    }

    @Override
    public void loadExternalRelevanceJudgment(String qrelFile) {
        this.relDocCount = new HashMap();
        try (BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(qrelFile)));){
            String content = "";
            while ((content = in.readLine()) != null) {
                if ((content = content.trim()).length() == 0) continue;
                String[] s = content.split(" ");
                String qid = s[0].trim();
                int label = (int)Math.rint(Double.parseDouble(s[3].trim()));
                if (label <= 0) continue;
                int prev = this.relDocCount.getOrDefault(qid, 0);
                this.relDocCount.put(qid, prev + 1);
            }
            System.out.println("Relevance judgment file loaded. [#q=" + this.relDocCount.size() + "]");
        }
        catch (IOException ex) {
            throw RankLibError.create("Error in APScorer::loadExternalRelevanceJudgment(): ", ex);
        }
    }

    @Override
    public double score(RankList rl) {
        double ap = 0.0;
        int count = 0;
        for (int i = 0; i < rl.size(); ++i) {
            if (!((double)rl.get(i).getLabel() > 0.0)) continue;
            ap += (double)(++count) / (double)(i + 1);
        }
        int rdCount = 0;
        if (this.relDocCount != null) {
            Integer it = this.relDocCount.get(rl.getID());
            if (it != null) {
                rdCount = it;
            }
        } else {
            rdCount = count;
        }
        if (rdCount == 0) {
            return 0.0;
        }
        return ap / (double)rdCount;
    }

    @Override
    public String name() {
        return "MAP";
    }

    @Override
    public double[][] swapChange(RankList rl) {
        int i;
        int[] relCount = new int[rl.size()];
        int[] labels = new int[rl.size()];
        int count = 0;
        for (int i2 = 0; i2 < rl.size(); ++i2) {
            labels[i2] = rl.get(i2).getLabel() > 0.0f ? 1 : 0;
            relCount[i2] = ++count;
        }
        int rdCount = 0;
        if (this.relDocCount != null) {
            Integer it = this.relDocCount.get(rl.getID());
            if (it != null) {
                rdCount = it;
            }
        } else {
            rdCount = count;
        }
        double[][] changes = new double[rl.size()][];
        for (i = 0; i < rl.size(); ++i) {
            changes[i] = new double[rl.size()];
            Arrays.fill(changes[i], 0.0);
        }
        if (rdCount == 0 || count == 0) {
            return changes;
        }
        for (i = 0; i < rl.size() - 1; ++i) {
            for (int j = i + 1; j < rl.size(); ++j) {
                double change = 0.0;
                if (labels[i] != labels[j]) {
                    int diff = labels[j] - labels[i];
                    change += (double)((relCount[i] + diff) * labels[j] - relCount[i] * labels[i]) / (double)(i + 1);
                    for (int k = i + 1; k <= j - 1; ++k) {
                        if (labels[k] <= 0) continue;
                        change += (double)diff / (double)(k + 1);
                    }
                    change += (double)(-relCount[j] * diff) / (double)(j + 1);
                }
                double d = change / (double)rdCount;
                changes[i][j] = d;
                changes[j][i] = d;
            }
        }
        return changes;
    }
}

