/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.materialproviders.model;

import java.nio.ByteBuffer;
import java.util.Objects;
import software.amazon.cryptography.materialproviders.model.AlgorithmSuiteId;
import software.amazon.cryptography.materialproviders.model.DerivationAlgorithm;
import software.amazon.cryptography.materialproviders.model.EdkWrappingAlgorithm;
import software.amazon.cryptography.materialproviders.model.Encrypt;
import software.amazon.cryptography.materialproviders.model.SignatureAlgorithm;
import software.amazon.cryptography.materialproviders.model.SymmetricSignatureAlgorithm;

public class AlgorithmSuiteInfo {
    private final AlgorithmSuiteId id;
    private final ByteBuffer binaryId;
    private final Integer messageVersion;
    private final Encrypt encrypt;
    private final DerivationAlgorithm kdf;
    private final DerivationAlgorithm commitment;
    private final SignatureAlgorithm signature;
    private final SymmetricSignatureAlgorithm symmetricSignature;
    private final EdkWrappingAlgorithm edkWrapping;

    protected AlgorithmSuiteInfo(BuilderImpl builder) {
        this.id = builder.id();
        this.binaryId = builder.binaryId();
        this.messageVersion = builder.messageVersion();
        this.encrypt = builder.encrypt();
        this.kdf = builder.kdf();
        this.commitment = builder.commitment();
        this.signature = builder.signature();
        this.symmetricSignature = builder.symmetricSignature();
        this.edkWrapping = builder.edkWrapping();
    }

    public AlgorithmSuiteId id() {
        return this.id;
    }

    public ByteBuffer binaryId() {
        return this.binaryId;
    }

    public Integer messageVersion() {
        return this.messageVersion;
    }

    public Encrypt encrypt() {
        return this.encrypt;
    }

    public DerivationAlgorithm kdf() {
        return this.kdf;
    }

    public DerivationAlgorithm commitment() {
        return this.commitment;
    }

    public SignatureAlgorithm signature() {
        return this.signature;
    }

    public SymmetricSignatureAlgorithm symmetricSignature() {
        return this.symmetricSignature;
    }

    public EdkWrappingAlgorithm edkWrapping() {
        return this.edkWrapping;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected AlgorithmSuiteId id;
        protected ByteBuffer binaryId;
        protected Integer messageVersion;
        protected Encrypt encrypt;
        protected DerivationAlgorithm kdf;
        protected DerivationAlgorithm commitment;
        protected SignatureAlgorithm signature;
        protected SymmetricSignatureAlgorithm symmetricSignature;
        protected EdkWrappingAlgorithm edkWrapping;

        protected BuilderImpl() {
        }

        protected BuilderImpl(AlgorithmSuiteInfo model) {
            this.id = model.id();
            this.binaryId = model.binaryId();
            this.messageVersion = model.messageVersion();
            this.encrypt = model.encrypt();
            this.kdf = model.kdf();
            this.commitment = model.commitment();
            this.signature = model.signature();
            this.symmetricSignature = model.symmetricSignature();
            this.edkWrapping = model.edkWrapping();
        }

        @Override
        public Builder id(AlgorithmSuiteId id) {
            this.id = id;
            return this;
        }

        @Override
        public AlgorithmSuiteId id() {
            return this.id;
        }

        @Override
        public Builder binaryId(ByteBuffer binaryId) {
            this.binaryId = binaryId;
            return this;
        }

        @Override
        public ByteBuffer binaryId() {
            return this.binaryId;
        }

        @Override
        public Builder messageVersion(Integer messageVersion) {
            this.messageVersion = messageVersion;
            return this;
        }

        @Override
        public Integer messageVersion() {
            return this.messageVersion;
        }

        @Override
        public Builder encrypt(Encrypt encrypt) {
            this.encrypt = encrypt;
            return this;
        }

        @Override
        public Encrypt encrypt() {
            return this.encrypt;
        }

        @Override
        public Builder kdf(DerivationAlgorithm kdf) {
            this.kdf = kdf;
            return this;
        }

        @Override
        public DerivationAlgorithm kdf() {
            return this.kdf;
        }

        @Override
        public Builder commitment(DerivationAlgorithm commitment) {
            this.commitment = commitment;
            return this;
        }

        @Override
        public DerivationAlgorithm commitment() {
            return this.commitment;
        }

        @Override
        public Builder signature(SignatureAlgorithm signature) {
            this.signature = signature;
            return this;
        }

        @Override
        public SignatureAlgorithm signature() {
            return this.signature;
        }

        @Override
        public Builder symmetricSignature(SymmetricSignatureAlgorithm symmetricSignature) {
            this.symmetricSignature = symmetricSignature;
            return this;
        }

        @Override
        public SymmetricSignatureAlgorithm symmetricSignature() {
            return this.symmetricSignature;
        }

        @Override
        public Builder edkWrapping(EdkWrappingAlgorithm edkWrapping) {
            this.edkWrapping = edkWrapping;
            return this;
        }

        @Override
        public EdkWrappingAlgorithm edkWrapping() {
            return this.edkWrapping;
        }

        @Override
        public AlgorithmSuiteInfo build() {
            if (Objects.isNull(this.id())) {
                throw new IllegalArgumentException("Missing value for required field `id`");
            }
            if (Objects.isNull(this.binaryId())) {
                throw new IllegalArgumentException("Missing value for required field `binaryId`");
            }
            if (Objects.isNull(this.messageVersion())) {
                throw new IllegalArgumentException("Missing value for required field `messageVersion`");
            }
            if (Objects.isNull(this.encrypt())) {
                throw new IllegalArgumentException("Missing value for required field `encrypt`");
            }
            if (Objects.isNull(this.kdf())) {
                throw new IllegalArgumentException("Missing value for required field `kdf`");
            }
            if (Objects.isNull(this.commitment())) {
                throw new IllegalArgumentException("Missing value for required field `commitment`");
            }
            if (Objects.isNull(this.signature())) {
                throw new IllegalArgumentException("Missing value for required field `signature`");
            }
            if (Objects.isNull(this.symmetricSignature())) {
                throw new IllegalArgumentException("Missing value for required field `symmetricSignature`");
            }
            if (Objects.isNull(this.edkWrapping())) {
                throw new IllegalArgumentException("Missing value for required field `edkWrapping`");
            }
            return new AlgorithmSuiteInfo(this);
        }
    }

    public static interface Builder {
        public Builder id(AlgorithmSuiteId var1);

        public AlgorithmSuiteId id();

        public Builder binaryId(ByteBuffer var1);

        public ByteBuffer binaryId();

        public Builder messageVersion(Integer var1);

        public Integer messageVersion();

        public Builder encrypt(Encrypt var1);

        public Encrypt encrypt();

        public Builder kdf(DerivationAlgorithm var1);

        public DerivationAlgorithm kdf();

        public Builder commitment(DerivationAlgorithm var1);

        public DerivationAlgorithm commitment();

        public Builder signature(SignatureAlgorithm var1);

        public SignatureAlgorithm signature();

        public Builder symmetricSignature(SymmetricSignatureAlgorithm var1);

        public SymmetricSignatureAlgorithm symmetricSignature();

        public Builder edkWrapping(EdkWrappingAlgorithm var1);

        public EdkWrappingAlgorithm edkWrapping();

        public AlgorithmSuiteInfo build();
    }
}

