/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.observe;

import java.util.concurrent.TimeUnit;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.elements.util.ClockUtil;

public class NotificationOrder {
    protected final Integer number;
    protected final long nanoTimestamp;

    public NotificationOrder(Integer observe) {
        this(observe, ClockUtil.nanoRealtime());
    }

    public NotificationOrder(Integer observe, long nanoTime) {
        this.number = observe;
        this.nanoTimestamp = nanoTime;
    }

    public Integer getObserve() {
        return this.number;
    }

    public synchronized boolean isNew(Response response) {
        Integer observe = response.getOptions().getObserve();
        if (observe == null) {
            return true;
        }
        return NotificationOrder.isNew(this.nanoTimestamp, this.number, ClockUtil.nanoRealtime(), observe);
    }

    public static boolean isNew(long T1, int V1, long T2, int V2) {
        return V1 < V2 && (long)(V2 - V1) < 0x800000L || V1 > V2 && (long)(V1 - V2) > 0x800000L || T2 > T1 + TimeUnit.SECONDS.toNanos(128L);
    }
}

