/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.project.state;

import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.bootstrap.workspace.WorkspaceModule;
import io.quarkus.bootstrap.workspace.WorkspaceModuleId;
import io.quarkus.devtools.project.state.ExtensionProvider;
import io.quarkus.devtools.project.state.ModuleState;
import io.quarkus.devtools.project.state.ProjectState;
import io.quarkus.devtools.project.state.TopExtensionDependency;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.maven.dependency.Dependency;
import io.quarkus.maven.dependency.ResolvedDependency;
import io.quarkus.registry.catalog.Extension;
import io.quarkus.registry.catalog.ExtensionCatalog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;

public final class ProjectStates {
    private ProjectStates() {
    }

    public static ProjectState resolveProjectState(ApplicationModel appModel, ExtensionCatalog currentCatalog) {
        ProjectState.Builder projectBuilder = ProjectState.builder();
        Collection importedPlatformBoms = appModel.getPlatforms().getImportedPlatformBoms();
        if (importedPlatformBoms.isEmpty()) {
            return projectBuilder.build();
        }
        LinkedHashMap<String, ExtensionProvider.Builder> extProviderBuilders = new LinkedHashMap<String, ExtensionProvider.Builder>(importedPlatformBoms.size());
        importedPlatformBoms.forEach(bom -> {
            projectBuilder.addPlatformBom((ArtifactCoords)bom);
            extProviderBuilders.put(ExtensionProvider.key(bom, true), ExtensionProvider.builder().setArtifact((ArtifactCoords)bom).setPlatform(true));
        });
        HashMap<WorkspaceModuleId, Object> projectModuleBuilders = new HashMap<WorkspaceModuleId, Object>();
        HashMap directModuleDeps = new HashMap();
        WorkspaceModule appModule = appModel.getAppArtifact().getWorkspaceModule();
        if (appModule != null) {
            ModuleState.Builder module = ModuleState.builder().setWorkspaceModule(appModule).setMainModule(true);
            projectModuleBuilders.put(appModule.getId(), module);
            appModule.getDirectDependencies().forEach(d -> directModuleDeps.computeIfAbsent(d.getKey(), dk -> new ArrayList()).add(module));
            for (Dependency constraint : appModule.getDirectDependencyConstraints()) {
                if (!extProviderBuilders.containsKey(constraint.toCompactCoords())) continue;
                module.addPlatformBom((ArtifactCoords)constraint);
            }
        }
        for (ResolvedDependency dep : appModel.getDependencies()) {
            if (dep.getWorkspaceModule() == null) continue;
            projectModuleBuilders.computeIfAbsent(dep.getWorkspaceModule().getId(), k -> {
                ModuleState.Builder module = ModuleState.builder().setWorkspaceModule(dep.getWorkspaceModule());
                dep.getWorkspaceModule().getDirectDependencies().forEach(d -> directModuleDeps.computeIfAbsent(d.getKey(), dk -> new ArrayList()).add(module));
                return module;
            });
        }
        HashMap<ArtifactKey, TopExtensionDependency.Builder> directExtDeps = new HashMap<ArtifactKey, TopExtensionDependency.Builder>();
        for (ResolvedDependency dep : appModel.getDependencies()) {
            if (dep.isFlagSet(128)) {
                directExtDeps.put(dep.getKey(), TopExtensionDependency.builder().setResolvedDependency(dep).setTransitive(!directModuleDeps.containsKey(dep.getKey())));
                continue;
            }
            if (!dep.isRuntimeExtensionArtifact() || !directModuleDeps.containsKey(dep.getKey())) continue;
            directExtDeps.put(dep.getKey(), TopExtensionDependency.builder().setResolvedDependency(dep));
        }
        if (directExtDeps.isEmpty()) {
            return projectBuilder.build();
        }
        currentCatalog.getExtensions().forEach(e -> {
            ArtifactKey key = e.getArtifact().getKey();
            TopExtensionDependency.Builder dep = (TopExtensionDependency.Builder)directExtDeps.get(key);
            if (dep != null) {
                dep.setCatalogMetadata((Extension)e);
            }
        });
        for (TopExtensionDependency.Builder extBuilder : directExtDeps.values()) {
            List modules = directModuleDeps.getOrDefault(extBuilder.getKey(), Collections.emptyList());
            TopExtensionDependency dep = extBuilder.setTransitive(modules.isEmpty()).build();
            projectBuilder.addExtensionDependency(dep);
            for (ModuleState.Builder module : modules) {
                module.addExtensionDependency(dep);
            }
            ExtensionProvider.Builder provider = extProviderBuilders.computeIfAbsent(dep.getProviderKey(), k -> ExtensionProvider.builder().setOrigin(dep.getOrigin()));
            provider.addExtension(dep);
        }
        for (Object builder : extProviderBuilders.values()) {
            projectBuilder.addExtensionProvider(((ExtensionProvider.Builder)builder).build());
        }
        for (Object builder : projectModuleBuilders.values()) {
            projectBuilder.addModule(((ModuleState.Builder)builder).build());
        }
        return projectBuilder.build();
    }
}

