/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.mutation.group;

import java.util.Locale;
import org.hibernate.HibernateException;
import org.hibernate.engine.jdbc.mutation.ParameterUsage;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.sql.model.MutationTarget;
import org.hibernate.sql.model.MutationType;

public class UnknownParameterException
extends HibernateException {
    private final MutationType mutationType;
    private final MutationTarget<?> mutationTarget;
    private final String tableName;
    private final String columnName;
    private final ParameterUsage usage;

    public UnknownParameterException(MutationType mutationType, MutationTarget<?> mutationTarget, String tableName, String columnName, ParameterUsage usage) {
        super(String.format(Locale.ROOT, "Unable to locate parameter `%s.%s` for %s - %s : %s", new Object[]{tableName, columnName, usage, mutationType.name(), mutationTarget.getRolePath()}));
        this.mutationType = mutationType;
        this.mutationTarget = mutationTarget;
        this.tableName = tableName;
        this.columnName = columnName;
        this.usage = usage;
    }

    public String toString() {
        return String.format(Locale.ROOT, "UnknownParameterException(`%s.%s` for %s - %s : %s)", new Object[]{this.tableName, this.columnName, this.usage, this.mutationType.name(), StringHelper.collapse(this.mutationTarget.getRolePath())});
    }
}

