/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.net.Inet6Address;
import org.pcap4j.packet.DnsResourceRecord;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.util.ByteArrays;

public final class DnsRDataAaaa
implements DnsResourceRecord.DnsRData {
    private static final long serialVersionUID = 69151497541755310L;
    private final Inet6Address address;

    public static DnsRDataAaaa newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new DnsRDataAaaa(rawData, offset, length);
    }

    private DnsRDataAaaa(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        if (length < 16) {
            StringBuilder sb = new StringBuilder(200);
            sb.append("The data is too short to build a DnsRDataAaaa (").append(16).append(" bytes). data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
            throw new IllegalRawDataException(sb.toString());
        }
        this.address = ByteArrays.getInet6Address(rawData, offset);
    }

    private DnsRDataAaaa(Builder builder2) {
        if (builder2 == null || builder2.address == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("builder: ").append(builder2).append(" builder.address: ").append(builder2.address);
            throw new NullPointerException(sb.toString());
        }
        this.address = builder2.address;
    }

    public Inet6Address getAddress() {
        return this.address;
    }

    @Override
    public int length() {
        return 16;
    }

    @Override
    public byte[] getRawData() {
        return this.address.getAddress();
    }

    public Builder getBuilder() {
        return new Builder(this);
    }

    public String toString() {
        return this.convertToString("", null);
    }

    @Override
    public String toString(String indent) {
        return this.convertToString(indent, null);
    }

    @Override
    public String toString(String indent, byte[] headerRawData) {
        if (headerRawData == null) {
            throw new NullPointerException("headerRawData is null.");
        }
        return this.convertToString(indent, headerRawData);
    }

    private String convertToString(String indent, byte[] headerRawData) {
        StringBuilder sb = new StringBuilder();
        String ls = System.getProperty("line.separator");
        sb.append(indent).append("AAAA RDATA:").append(ls).append(indent).append("  ADDRESS: ").append(this.address.getHostAddress()).append(ls);
        return sb.toString();
    }

    public int hashCode() {
        return this.address.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        DnsRDataAaaa other = (DnsRDataAaaa)obj;
        return this.address.equals(other.address);
    }

    public static final class Builder {
        private Inet6Address address;

        public Builder() {
        }

        private Builder(DnsRDataAaaa obj) {
            this.address = obj.address;
        }

        public Builder address(Inet6Address address) {
            this.address = address;
            return this;
        }

        public DnsRDataAaaa build() {
            return new DnsRDataAaaa(this);
        }
    }
}

