/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.internal.util;

import jakarta.ws.rs.RuntimeType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.jersey.CommonProperties;
import org.glassfish.jersey.internal.LocalizationMessages;
import org.glassfish.jersey.internal.util.ReflectionHelper;

public final class PropertiesHelper {
    private static final Logger LOGGER = Logger.getLogger(PropertiesHelper.class.getName());
    private static final boolean METAINF_SERVICES_LOOKUP_DISABLE_DEFAULT = false;
    private static final boolean JAXRS_SERVICE_LOADING_ENABLE_DEFAULT = true;
    private static final String RUNTIME_SERVER_LOWER = RuntimeType.SERVER.name().toLowerCase(Locale.ROOT);
    private static final String RUNTIME_CLIENT_LOWER = RuntimeType.CLIENT.name().toLowerCase(Locale.ROOT);

    public static PrivilegedAction<Properties> getSystemProperties() {
        return new PrivilegedAction<Properties>(){

            @Override
            public Properties run() {
                return System.getProperties();
            }
        };
    }

    public static PrivilegedAction<String> getSystemProperty(final String name) {
        return new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(name);
            }
        };
    }

    public static PrivilegedAction<String> getSystemProperty(final String name, final String def) {
        return new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(name, def);
            }
        };
    }

    public static <T> T getValue(Map<String, ?> properties2, String key, T defaultValue, Map<String, String> legacyMap) {
        return PropertiesHelper.getValue(properties2, null, key, defaultValue, legacyMap);
    }

    public static <T> T getValue(Map<String, ?> properties2, RuntimeType runtimeType, String key, T defaultValue, Map<String, String> legacyMap) {
        return PropertiesHelper.getValue(properties2, runtimeType, key, defaultValue, defaultValue.getClass(), legacyMap);
    }

    public static <T> T getValue(Map<String, ?> properties2, String key, T defaultValue, Class<T> type2, Map<String, String> legacyMap) {
        return PropertiesHelper.getValue(properties2, null, key, defaultValue, type2, legacyMap);
    }

    public static <T> T getValue(Map<String, ?> properties2, RuntimeType runtimeType, String key, T defaultValue, Class<T> type2, Map<String, String> legacyMap) {
        T value2 = PropertiesHelper.getValue(properties2, runtimeType, key, type2, legacyMap);
        if (value2 == null) {
            value2 = defaultValue;
        }
        return value2;
    }

    public static <T> T getValue(Map<String, ?> properties2, String key, Class<T> type2, Map<String, String> legacyMap) {
        return PropertiesHelper.getValue(properties2, null, key, type2, legacyMap);
    }

    public static <T> T getValue(Map<String, ?> properties2, RuntimeType runtimeType, String key, Class<T> type2, Map<String, String> legacyMap) {
        Object value2 = null;
        if (runtimeType != null) {
            String runtimeAwareKey = PropertiesHelper.getPropertyNameForRuntime(key, runtimeType);
            if (key.equals(runtimeAwareKey)) {
                runtimeAwareKey = key + "." + PropertiesHelper.toLowerCase(runtimeType);
            }
            value2 = properties2.get(runtimeAwareKey);
        }
        if (value2 == null) {
            value2 = properties2.get(key);
        }
        if (value2 == null) {
            value2 = PropertiesHelper.getLegacyFallbackValue(properties2, legacyMap, key);
        }
        if (value2 == null) {
            return null;
        }
        return PropertiesHelper.convertValue(value2, type2);
    }

    public static String getPropertyNameForRuntime(String key, RuntimeType runtimeType) {
        if (runtimeType != null && key.startsWith("jersey.config")) {
            RuntimeType[] types;
            for (RuntimeType type2 : types = RuntimeType.values()) {
                if (!key.startsWith("jersey.config." + PropertiesHelper.toLowerCase(type2))) continue;
                return key;
            }
            return key.replace("jersey.config", "jersey.config." + PropertiesHelper.toLowerCase(runtimeType));
        }
        return key;
    }

    private static Object getLegacyFallbackValue(Map<String, ?> properties2, Map<String, String> legacyFallbackMap, String key) {
        if (legacyFallbackMap == null || !legacyFallbackMap.containsKey(key)) {
            return null;
        }
        String fallbackKey = legacyFallbackMap.get(key);
        Object value2 = properties2.get(fallbackKey);
        if (value2 != null && LOGGER.isLoggable(Level.CONFIG)) {
            LOGGER.config(LocalizationMessages.PROPERTIES_HELPER_DEPRECATED_PROPERTY_NAME(fallbackKey, key));
        }
        return value2;
    }

    public static <T> T convertValue(Object value2, Class<T> type2) {
        if ((type2.equals(Integer.class) || type2.equals(Integer.TYPE)) && Number.class.isInstance(value2)) {
            Integer number2Int = ((Number)value2).intValue();
            return (T)number2Int;
        }
        if ((type2.equals(Long.class) || type2.equals(Long.TYPE)) && Number.class.isInstance(value2)) {
            Long number2Long = ((Number)value2).longValue();
            return (T)number2Long;
        }
        if (!type2.isInstance(value2)) {
            Method valueOf;
            Constructor constructor = AccessController.doPrivileged(ReflectionHelper.getStringConstructorPA(type2));
            if (constructor != null) {
                try {
                    return type2.cast(constructor.newInstance(value2));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((valueOf = AccessController.doPrivileged(ReflectionHelper.getValueOfStringMethodPA(type2))) != null) {
                try {
                    return type2.cast(valueOf.invoke(null, value2));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.warning(LocalizationMessages.PROPERTIES_HELPER_GET_VALUE_NO_TRANSFORM(String.valueOf(value2), value2.getClass().getName(), type2.getName()));
            }
            return null;
        }
        return type2.cast(value2);
    }

    public static boolean isMetaInfServicesEnabled(Map<String, Object> properties2, RuntimeType runtimeType) {
        boolean disableMetaInfServicesLookup = false;
        if (properties2 != null) {
            disableMetaInfServicesLookup = CommonProperties.getValue(properties2, runtimeType, "jersey.config.disableMetainfServicesLookup", false, Boolean.class);
        }
        return !disableMetaInfServicesLookup;
    }

    public static boolean isJaxRsServiceLoadingEnabled(Map<String, Object> properties2) {
        boolean enableServicesLoading = true;
        if (properties2 != null) {
            enableServicesLoading = CommonProperties.getValue(properties2, "jakarta.ws.rs.loadServices", true);
        }
        return enableServicesLoading;
    }

    public static boolean isProperty(Map<String, Object> properties2, String name) {
        return properties2.containsKey(name) && PropertiesHelper.isProperty(properties2.get(name));
    }

    public static boolean isProperty(Object value2) {
        if (value2 instanceof Boolean) {
            return (Boolean)Boolean.class.cast(value2);
        }
        return value2 != null && Boolean.parseBoolean(value2.toString());
    }

    private static String toLowerCase(RuntimeType runtimeType) {
        switch (runtimeType) {
            case CLIENT: {
                return RUNTIME_CLIENT_LOWER;
            }
        }
        return RUNTIME_SERVER_LOWER;
    }

    private PropertiesHelper() {
    }
}

