/*
 * Decompiled with CFR 0.152.
 */
package elements;

import basic.Oriented;
import java.awt.Graphics;
import java.awt.Image;
import javax.swing.ImageIcon;
import values.BrickColor;
import values.GameType;
import values.Orientation;
import values.Settings;

public class Brick
extends Oriented {
    public static final Brick BLACK = new Brick();
    private BrickColor color;
    private Oriented parentCollection = null;

    public Brick(BrickColor brickColor) {
        super(brickColor.getColor());
        this.color = brickColor;
        this.setOrientation(Orientation.NONE);
    }

    public Brick(BrickColor brickColor, Orientation orientation) {
        super(brickColor.getColor());
        this.color = brickColor;
        this.setOrientation(orientation);
    }

    public Brick() {
        this(BrickColor.BLACK);
    }

    public Brick(int n) {
        this(BrickColor.generate(n, GameType.STRATEGY));
    }

    public Brick(int n, GameType gameType) {
        this(BrickColor.generate(n, gameType));
    }

    @Override
    public void setOrientation(Orientation orientation) {
        super.setOrientation(orientation);
        this.setIcon(this.color.getColor(orientation));
    }

    public Oriented getParentCollection() {
        return this.parentCollection;
    }

    public final BrickColor getColor() {
        return this.color;
    }

    public void update() {
        this.setIcon(this.color.getColor(this.getOrientation()));
        this.repaint();
    }

    public void setColor(BrickColor brickColor) {
        this.color = brickColor;
        this.setIcon(brickColor.getColor(this.getOrientation()));
    }

    public void setParentCollection(Oriented oriented) {
        this.parentCollection = oriented;
    }

    public boolean hasSameColor(Brick brick) {
        return this.color.compareTo(brick.color);
    }

    public boolean hasSameColor(BrickColor brickColor) {
        return this.color.compareTo(brickColor);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Image image = Settings.getScaledImage(((ImageIcon)this.getIcon()).getImage(), this.getWidth(), this.getHeight());
        graphics.drawImage(image, 0, 0, null);
    }
}

