/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.tracklink.vcslinks.actions;

import com.almworks.tracklink.util.StringBundle;
import com.almworks.tracklink.vcslinks.CustomDiffContent;
import com.almworks.tracklink.vcslinks.VCSUtil;
import com.almworks.util.Log;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.DiffManager;
import com.intellij.openapi.diff.DiffRequest;
import com.intellij.openapi.diff.DiffTool;
import com.intellij.openapi.diff.SimpleDiffRequest;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import java.util.List;

public class ShowDiffAction
extends AnAction {
    public void update(AnActionEvent event) {
        super.update(event);
        DataContext dataContext = event.getDataContext();
        VirtualFile file = (VirtualFile)dataContext.getData("virtualFile");
        Project project = (Project)dataContext.getData("project");
        boolean isFileAppropriate = this.isFileAppropriate(file);
        event.getPresentation().setEnabled(isFileAppropriate && project != null);
        String name = file == null ? "?" : file.getName();
        String actionName = isFileAppropriate && project != null ? StringBundle.get("usages.show.diff", name) : null;
        event.getPresentation().setText(actionName);
    }

    private boolean isFileAppropriate(VirtualFile file) {
        return file != null && !file.isDirectory() && file.isValid();
    }

    public void actionPerformed(AnActionEvent event) {
        DataContext dataContext = event.getDataContext();
        Project project = (Project)dataContext.getData("project");
        VirtualFile file = (VirtualFile)dataContext.getData("virtualFile");
        if (project == null) {
            Log.debug("no project");
            return;
        }
        if (!this.isFileAppropriate(file)) {
            Log.debug("No appropriate file");
            return;
        }
        try {
            List<VcsFileRevision> revisionList = VCSUtil.getRevisionsFromVcsHistory(file, project);
            assert (revisionList.size() > 1);
            VcsFileRevision revision1 = revisionList.get(0);
            VcsFileRevision revision2 = revisionList.get(1);
            this.showDiffDialog(revision1, revision2, project, file);
        }
        catch (VcsException e) {
            Log.warn("cannot show diff", e);
        }
        catch (IOException e) {
            Log.warn("cannot show diff", e);
        }
    }

    private void showDiffDialog(VcsFileRevision v1, VcsFileRevision v2, Project project, VirtualFile file) throws VcsException, IOException {
        v1.loadContent();
        v2.loadContent();
        DiffManager diff = DiffManager.getInstance();
        DiffTool ideaDiffTool = diff.getIdeaDiffTool();
        SimpleDiffRequest request = new SimpleDiffRequest(project, file.getPath());
        request.setContents((DiffContent)new CustomDiffContent(file, v1), (DiffContent)new CustomDiffContent(file, v2));
        request.setContentTitles(v1.getRevisionNumber().asString(), v2.getRevisionNumber().asString());
        ideaDiffTool.show((DiffRequest)request);
    }
}

