/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.io.PrintStream;
import java.io.PrintWriter;
import org.springframework.core.NestedExceptionUtils;

public abstract class NestedCheckedException
extends Exception {
    private static final long serialVersionUID = 7100714597678207546L;
    private Throwable cause;

    public NestedCheckedException(String msg) {
        super(msg);
    }

    public NestedCheckedException(String msg, Throwable cause) {
        super(msg);
        this.cause = cause;
    }

    public Throwable getCause() {
        return this.cause == this ? null : this.cause;
    }

    public String getMessage() {
        return NestedExceptionUtils.buildMessage(super.getMessage(), this.getCause());
    }

    public void printStackTrace(PrintStream ps) {
        if (this.getCause() == null) {
            super.printStackTrace(ps);
        } else {
            ps.println(this);
            ps.print("Caused by: ");
            this.getCause().printStackTrace(ps);
        }
    }

    public void printStackTrace(PrintWriter pw) {
        if (this.getCause() == null) {
            super.printStackTrace(pw);
        } else {
            pw.println(this);
            pw.print("Caused by: ");
            this.getCause().printStackTrace(pw);
        }
    }

    public Throwable getRootCause() {
        Throwable cause = this.getCause();
        if (cause instanceof NestedCheckedException) {
            return ((NestedCheckedException)cause).getRootCause();
        }
        return cause;
    }

    public Throwable getMostSpecificCause() {
        Throwable rootCause = this.getRootCause();
        return rootCause != null ? rootCause : this;
    }

    public boolean contains(Class exType) {
        if (exType == null) {
            return false;
        }
        if (exType.isInstance(this)) {
            return true;
        }
        Throwable cause = this.getCause();
        if (cause instanceof NestedCheckedException) {
            return ((NestedCheckedException)cause).contains(exType);
        }
        return cause != null && exType.isInstance(cause);
    }
}

